#!/bin/bash

export YT_TOKEN=`cat ~/.yt/robot_token`

set -e
set -x

YT_META_CLUSTER='pythia'
YT_REPLICA_CLUSTER_1='freud'
YT_REPLICA_CLUSTER_2='hume'

YT_PROJECT_PATH='//home/partner/dict'

YT_TABLE_PATH="${YT_PROJECT_PATH}/iab_bm_category_mapping"
YT_TABLE_DATA="migrations/before_release/PI-20898_iab_bm_map.json"

if [[ $1 && $1 == "prod" ]];
then
    echo "~using PRODUCTION config";
    YT_META_CLUSTER='markov'
    YT_REPLICA_CLUSTER_1='hahn'
    YT_REPLICA_CLUSTER_2='arnold'
else
    echo "~using TEST config";
fi

yt select "id from [$YT_TABLE_PATH] where PICategoryID in (\"302\",\"307\")" --format json --proxy $YT_META_CLUSTER | yt delete-rows $YT_TABLE_PATH  --no-require-sync-replica  --format json  --proxy $YT_META_CLUSTER
cat $YT_TABLE_DATA | yt insert-rows $YT_TABLE_PATH  --no-require-sync-replica --format json  --proxy $YT_META_CLUSTER
yt select "* from [$YT_TABLE_PATH] order by id desc limit 10" --format json --proxy $YT_META_CLUSTER

exit 0;
