CREATE TABLE IF NOT EXISTS `scheduler_instances` (
    `instance_id` VARCHAR(128) NOT NULL,
    `version` VARCHAR(128) NOT NULL,
    `heartbeat_time` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `is_main` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
    `meta` VARCHAR(512),
    PRIMARY KEY (`instance_id`)
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8';

CREATE TABLE IF NOT EXISTS `scheduled_tasks` (
    `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
    `name` VARCHAR(128) NOT NULL,
    `params` VARCHAR(128) NOT NULL,
    `status` ENUM('New', 'Starting', 'Running', 'Finished', 'Paused', 'Deleted') NOT NULL DEFAULT 'New',
    `instance_id` VARCHAR(128),
    `heartbeat_time` TIMESTAMP,
    `next_run` TIMESTAMP NOT NULL DEFAULT '0000-00-00 00:00:00',
    `schedule_hash` VARCHAR(512) NOT NULL,
    `job_name_hash` VARCHAR(128) NOT NULL,
    `last_start_time` TIMESTAMP NOT NULL DEFAULT '0000-00-00 00:00:00',
    `last_finish_time` TIMESTAMP NOT NULL DEFAULT '0000-00-00 00:00:00',
    `need_reschedule` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
    `version` VARCHAR(128) NOT NULL DEFAULT '',
    `meta` VARCHAR(512),
    PRIMARY KEY (`id`),
    UNIQUE INDEX `uniq_scheduled_tasks__name_params` (`name`, `params`)
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8';
