CREATE TABLE IF NOT EXISTS `moderation_reason`
(
    `id`             bigint(20) unsigned NOT NULL AUTO_INCREMENT,
    `multistate`     bigint(20) unsigned NOT NULL DEFAULT '0',
    `create_date`    datetime            NOT NULL,
    `manager_txt_en` varchar(512)                 DEFAULT NULL,
    `manager_txt_ru` varchar(512)                 DEFAULT NULL,
    `partner_txt_en` varchar(512)                 DEFAULT NULL,
    `partner_txt_ru` varchar(512)                 DEFAULT NULL,
    `owner_id`       bigint(20) unsigned NOT NULL,
    PRIMARY KEY (`id`),
    KEY `fk_moderation_reason__owner_id___users__id` (`owner_id`),
    CONSTRAINT `moderation_reason_ibfk_1` FOREIGN KEY (`owner_id`) REFERENCES `users` (`id`)
);

CREATE TABLE IF NOT EXISTS `moderation_reason_action_log`
(
    `id`             bigint(20) unsigned NOT NULL AUTO_INCREMENT,
    `dt`             datetime            NOT NULL,
    `user_id`        bigint(20) unsigned NOT NULL,
    `elem_id`        bigint(20) unsigned NOT NULL,
    `old_multistate` bigint(20) unsigned NOT NULL,
    `action`         varchar(100)        NOT NULL,
    `new_multistate` bigint(20) unsigned NOT NULL,
    `opts`           text                NOT NULL,
    `comment`        varchar(100)        NOT NULL DEFAULT '',
    PRIMARY KEY (`id`),
    KEY `moderation_reason_action_log__dt_elem_id_action` (`dt`, `elem_id`, `action`),
    KEY `moderation_reason_action_log__elem_id_action` (`elem_id`, `action`),
    KEY `fk_moderation_reason_action_log__user_id___users__id` (`user_id`),
    CONSTRAINT `moderation_reason_action_log_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`),
    CONSTRAINT `moderation_reason_action_log_ibfk_2` FOREIGN KEY (`elem_id`) REFERENCES `moderation_reason` (`id`)
);

insert ignore into `moderation_reason` (
`id`,
`manager_txt_ru`,
`partner_txt_ru`,
`manager_txt_en`,
`partner_txt_en`,
`create_date`,
`owner_id`
) values
(1,'Сайт не работает','Сайт не работает','Сайт не работает','Сайт не работает',now(),0),
(2,'Нет контента','Сайт не наполнен контентом','Нет контента','Сайт не наполнен контентом',now(),0),
(3,'Дополнительные действия','Сайт не доступен для проверки','Дополнительные действия','Сайт не доступен для проверки',now(),0),
(4,'Вирус на сайте','Вирус на сайте','Вирус на сайте','Вирус на сайте',now(),0),
(5,'Иностранный язык','Иностранный язык','Иностранный язык','Иностранный язык',now(),0),
(6,'Подозрение на фрод','Не соответствует рекламной политике Яндекса','Подозрение на фрод','Не соответствует рекламной политике Яндекса',now(),0),
(7,'Некачественный ресурс','Не соответствует рекламной политике Яндекса','Некачественный ресурс','Не соответствует рекламной политике Яндекса',now(),0),
(8,'Нарушение законодательства','Не соответствует рекламной политике Яндекса','Нарушение законодательства','Не соответствует рекламной политике Яндекса',now(),0),
(9,'Нарушение политики РСЯ','Не соответствует рекламной политике Яндекса','Нарушение политики РСЯ','Не соответствует рекламной политике Яндекса',now(),0),
(10,'Заблокировано в ПИ','Заблокировано в ПИ','Заблокировано в ПИ','Заблокировано в ПИ',now(),0),
(11,'Домен на продажу','Не соответствует рекламной политике Яндекса','Домен на продажу','Не соответствует рекламной политике Яндекса',now(),0),
(12,'Бессмысленный текст','Не соответствует рекламной политике Яндекса','Бессмысленный текст','Не соответствует рекламной политике Яндекса',now(),0),
(13,'Ветки комментариев','Не соответствует рекламной политике Яндекса','Ветки комментариев','Не соответствует рекламной политике Яндекса',now(),0),
(14,'Дорвей','Не соответствует рекламной политике Яндекса','Дорвей','Не соответствует рекламной политике Яндекса',now(),0),
(15,'Нарушение правил размещения блоков','Не соответствует рекламной политике Яндекса','Нарушение правил размещения блоков','Не соответствует рекламной политике Яндекса',now(),0),
(16,'Фрод','Фрод?','Фрод','Фрод?',now(),0),
(1105,'Приложение недоступно в магазине','Не соответствует рекламной политике Яндекса','Приложение недоступно в магазине','Не соответствует рекламной политике Яндекса',now(),0),
(1106,'Приложение на армянском языке','Не соответствует рекламной политике Яндекса','Приложение на армянском языке','Не соответствует рекламной политике Яндекса',now(),0),
(1107,'Приложение нарушает авторские права','Не соответствует рекламной политике Яндекса','Приложение нарушает авторские права','Не соответствует рекламной политике Яндекса',now(),0),
(1108,'Плохая тематика приложения. Политика РСЯ','Не соответствует рекламной политике Яндекса','Плохая тематика приложения. Политика РСЯ','Не соответствует рекламной политике Яндекса',now(),0),
(2001,'Фродовый трафик','Не соответствует рекламной политике Яндекса','Фродовый трафик','Не соответствует рекламной политике Яндекса',now(),926859316),
(2002,'Обман рекламного кода','Не соответствует рекламной политике Яндекса','Обман рекламного кода','Не соответствует рекламной политике Яндекса',now(),926859316),
(2003,'Абьюз BidCorrection','Не соответствует рекламной политике Яндекса','Абьюз BidCorrection','Не соответствует рекламной политике Яндекса',now(),926859316)
;
