-- advnet_report_by_login

INSERT INTO
    `statistics_reports`
(`id`, `report_id`, `caption_en`, `caption_ru`,
    `description`, `level`, `query`, `owner_id`, `not_show`, `multistate`, `report_type`)
VALUES
('advnet_report_by_login',null,'','Отчет по рекламе на сайтах для логина ${login} за 30 дней',
    '', 'payment', '{"tableLevel":{"entity_fields":["page_id","page_caption","block_level"],"dimension_fields":["date|day"],"fields":["partner_wo_nds"],"lang":"ru","levels":[{"filter":["AND",[["login","IN",["${login}"]],["page_level","IN",["context_on_site_campaign"]]]],"id":"payment"}],"limits":{"limit":100,"offset":0},"period":"30days","order_by":[{"sortBy":"date","sortOrder":"asc"}]},"chartLevel":{"entity_fields":["page_id","page_caption","block_level"],"dimension_fields":["date|day"],"fields":["partner_wo_nds"],"lang":"ru","levels":[{"filter":["AND",[["login","IN",["${login}"]],["page_level","IN",["context_on_site_campaign"]]]],"id":"payment"}],"limits":{"limit":100,"offset":0},"period":"30days","order_by":[]}}',
    null, 1, 0, 'mol'
);

-- mobile_report_by_login

INSERT INTO
    `statistics_reports`
(`id`, `report_id`, `caption_en`, `caption_ru`,
    `description`, `level`, `query`, `owner_id`, `not_show`, `multistate`, `report_type`)
VALUES
('mobile_report_by_login',null,'','Отчет по рекламе в мобильных приложениях для логина ${login} за 30 дней',
    '', 'payment', '{"tableLevel":{"entity_fields":["page_id","page_caption"],"dimension_fields":["date|day"],"fields":["partner_wo_nds"],"lang":"ru","levels":[{"filter":["AND",[["login","IN",["${login}"]],["page_level","IN",["mobile_app_settings"]]]],"id":"payment"}],"limits":{"limit":100,"offset":0},"period":"30days","order_by":[{"sortBy":"date","sortOrder":"asc"}]},"chartLevel":{"entity_fields":["page_id","page_caption"],"dimension_fields":["date|day"],"fields":["partner_wo_nds"],"lang":"ru","levels":[{"filter":["AND",[["login","IN",["${login}"]],["page_level","IN",["mobile_app_settings"]]]],"id":"payment"}],"limits":{"limit":100,"offset":0},"period":"30days","order_by":[]}}',
    null, 1, 0, 'mol'
);

-- video_site_report_by_login

INSERT INTO
    `statistics_reports`
(`id`, `report_id`, `caption_en`, `caption_ru`,
    `description`, `level`, `query`, `owner_id`, `not_show`, `multistate`, `report_type`)
VALUES
('video_site_report_by_login',null,'','Отчет по видеорекламе для логина ${login} за 30 дней',
    '', 'payment', '{"tableLevel":{"entity_fields":["page_id","page_caption","block_level"],"dimension_fields":["date|day"],"fields":["partner_wo_nds"],"lang":"ru","levels":[{"filter":["AND",[["login","IN",["${login}"]],["page_level","IN",["video_an_site"]]]],"id":"payment"}],"limits":{"limit":100,"offset":0},"period":"30days","order_by":[{"sortBy":"date","sortOrder":"asc"}]},"chartLevel":{"entity_fields":["page_id","page_caption","block_level"],"dimension_fields":["date|day"],"fields":["partner_wo_nds"],"lang":"ru","levels":[{"filter":["AND",[["login","IN",["${login}"]],["page_level","IN",["video_an_site"]]]],"id":"payment"}],"limits":{"limit":100,"offset":0},"period":"30days","order_by":[]}}',
    null, 1, 0, 'mol'
);

-- report_by_page_id

INSERT INTO
    `statistics_reports`
(`id`, `report_id`, `caption_en`, `caption_ru`,
    `description`, `level`, `query`, `owner_id`, `not_show`, `multistate`, `report_type`)
VALUES
('report_by_page_id',null,'','Отчет по тематической площадке ${page_id} «${name}» за ${period||30days}',
    '', 'payment', '{"tableLevel":{"entity_fields":["block_level"],"dimension_fields":["date|day"],"fields":["partner_wo_nds"],"lang":"ru","levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"payment"}],"limits":{"limit":100,"offset":0},"period":"30days","order_by":[{"sortBy":"date","sortOrder":"asc"}]},"chartLevel":{"entity_fields":["block_level"],"dimension_fields":["date|day"],"fields":["partner_wo_nds"],"lang":"ru","levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"payment"}],"limits":{"limit":100,"offset":0},"period":"30days","order_by":[]}}',
    null, 1, 0, 'mol'
);

-- detailed_report_by_page_id

INSERT INTO
    `statistics_reports`
(`id`, `report_id`, `caption_en`, `caption_ru`,
    `description`, `level`, `query`, `owner_id`, `not_show`, `multistate`, `report_type`)
VALUES
('detailed_report_by_page_id',null,'','Отчет по блокам для площадки ${page_id} «${name}» за ${period||30days}',
    '', 'payment', '{"tableLevel":{"entity_fields":["complex_block_id","block_caption"],"dimension_fields":["date|day"],"fields":["partner_wo_nds","cpmv_partner_wo_nds","hits","hits_render","shows","winrate","visibility"],"lang":"ru","levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]],["block_level","IN",["context_on_site_rtb"]]]],"id":"payment"}],"limits":{"limit":100,"offset":0},"period":"30days","order_by":[{"sortBy":"date","sortOrder":"asc"}]},"chartLevel":{"entity_fields":["complex_block_id","block_caption"],"dimension_fields":["date|day"],"fields":["partner_wo_nds","cpmv_partner_wo_nds","hits","hits_render","shows","winrate","visibility"],"lang":"ru","levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]],["block_level","IN",["context_on_site_rtb"]]]],"id":"payment"}],"limits":{"limit":100,"offset":0},"period":"30days","order_by":[]}}',
    null, 1, 0, 'mol'
);

-- context_rtb_tags_report_by_page_id

INSERT INTO
    `statistics_reports`
(`id`, `report_id`, `caption_en`, `caption_ru`,
    `description`, `level`, `query`, `owner_id`, `not_show`, `multistate`, `report_type`)
VALUES
('context_rtb_tags_report_by_page_id',null,'','Отчет по срезам RTB для площадки за ${page_id} «${name}» ${period||30days}',
    '', 'payment', '{"tableLevel":{"entity_fields":["tag_id","complex_block_id","block_caption"],"dimension_fields":[],"fields":["partner_wo_nds","cpmv_partner_wo_nds","hits","hits_render","shows","winrate","visibility"],"lang":"ru","levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]],["block_level","IN",["context_on_site_rtb"]]]],"id":"payment"}],"limits":{"limit":100,"offset":0},"period":"30days","order_by":[{"sortBy":"date","sortOrder":"asc"}]},"chartLevel":{"entity_fields":["tag_id","complex_block_id","block_caption"],"dimension_fields":[],"fields":["partner_wo_nds","cpmv_partner_wo_nds","hits","hits_render","shows","winrate","visibility"],"lang":"ru","levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]],["block_level","IN",["context_on_site_rtb"]]]],"id":"payment"}],"limits":{"limit":100,"offset":0},"period":"30days","order_by":[]}}',
    null, 1, 0, 'mol'
);

-- detailed_report_by_block_id

INSERT INTO
    `statistics_reports`
(`id`, `report_id`, `caption_en`, `caption_ru`,
    `description`, `level`, `query`, `owner_id`, `not_show`, `multistate`, `report_type`)
VALUES
('detailed_report_by_block_id',null,'','Отчет по блоку ${block_id} «${name}» за ${period||30days}',
    '', 'payment', '{"tableLevel":{"entity_fields":[""],"dimension_fields":["date|day"],"fields":["partner_wo_nds","cpmv_partner_wo_nds","hits","hits_render","shows","winrate","visibility"],"lang":"ru","levels":[{"filter":["AND",[["public_id","=","${block_id}"]]],"id":"payment"}],"limits":{"limit":100,"offset":0},"period":"30days","order_by":[{"sortBy":"date","sortOrder":"asc"}]},"chartLevel":{"entity_fields":[""],"dimension_fields":["date|day"],"fields":["partner_wo_nds","cpmv_partner_wo_nds","hits","hits_render","shows","winrate","visibility"],"lang":"ru","levels":[{"filter":["AND",[["public_id","=","${block_id}"]]],"id":"payment"}],"limits":{"limit":100,"offset":0},"period":"30days","order_by":[]}}',
    null, 1, 0, 'mol'
);

-- template_report_by_template_id

INSERT INTO
    `statistics_reports`
(`id`, `report_id`, `caption_en`, `caption_ru`,
    `description`, `level`, `query`, `owner_id`, `not_show`, `multistate`, `report_type`)
VALUES
('template_report_by_template_id',null,'','Отчет по дизайнам в РТБ-блоке ${block_id} «${name}» за ${period||30days}',
    '', 'payment', '{"tableLevel":{"entity_fields":["design_id","design_name"],"dimension_fields":["date|day"],"fields":["partner_wo_nds","cpmv_partner_wo_nds","hits","hits_render","shows","winrate","visibility"],"lang":"ru","levels":[{"filter":["AND",[["public_id","=","${block_id}"]]],"id":"payment"}],"limits":{"limit":100,"offset":0},"period":"30days","order_by":[{"sortBy":"date","sortOrder":"asc"}]},"chartLevel":{"entity_fields":["design_id","design_name"],"dimension_fields":["date|day"],"fields":["partner_wo_nds","cpmv_partner_wo_nds","hits","hits_render","shows","winrate","visibility"],"lang":"ru","levels":[{"filter":["AND",[["public_id","=","${block_id}"]]],"id":"payment"}],"limits":{"limit":100,"offset":0},"period":"30days","order_by":[]}}',
    null, 1, 0, 'mol'
);

-- recommendation_widget_report_by_block_id

INSERT INTO
    `statistics_reports`
(`id`, `report_id`, `caption_en`, `caption_ru`,
    `description`, `level`, `query`, `owner_id`, `not_show`, `multistate`, `report_type`)
VALUES
('recommendation_widget_report_by_block_id',null,'','Отчет по рекомендательному виджету ${block_id} «${name}» за ${period||30days}',
    '', 'payment', '{"tableLevel":{"entity_fields":[""],"dimension_fields":["date|day"],"fields":["partner_wo_nds","cpmv_partner_wo_nds","RecommendationShows","RecommendationClicks","RecommendationCTR","RecommendationWidgetShows","RecommendationWidgetClicksAverage"],"lang":"ru","levels":[{"filter":["AND",[["public_id","=","${block_id}"]]],"id":"payment"}],"limits":{"limit":100,"offset":0},"period":"30days","order_by":[{"sortBy":"date","sortOrder":"asc"}]},"chartLevel":{"entity_fields":[""],"dimension_fields":["date|day"],"fields":["partner_wo_nds","cpmv_partner_wo_nds","RecommendationShows","RecommendationClicks","RecommendationCTR","RecommendationWidgetShows","RecommendationWidgetClicksAverage"],"lang":"ru","levels":[{"filter":["AND",[["public_id","=","${block_id}"]]],"id":"payment"}],"limits":{"limit":100,"offset":0},"period":"30days","order_by":[]}}',
    null, 1, 0, 'mol'
);

-- vmap_report_by_vmap_id

INSERT INTO
    `statistics_reports`
(`id`, `report_id`, `caption_en`, `caption_ru`,
    `description`, `level`, `query`, `owner_id`, `not_show`, `multistate`, `report_type`)
VALUES
('vmap_report_by_vmap_id',null,'','Отчет по сценарию Instream ${vmap_id} «${name}» за ${period||30days}',
    '', 'payment', '{"tableLevel":{"entity_fields":[""],"dimension_fields":["date|day"],"fields":["partner_wo_nds","cpmv_partner_wo_nds","hits","hits_render","shows","winrate","visibility"],"lang":"ru","levels":[{"filter":["AND",[["vmap_id","IN",["${vmap_id}"]]]],"id":"payment"}],"limits":{"limit":100,"offset":0},"period":"30days","order_by":[{"sortBy":"date","sortOrder":"asc"}]},"chartLevel":{"entity_fields":[""],"dimension_fields":["date|day"],"fields":["partner_wo_nds","cpmv_partner_wo_nds","hits","hits_render","shows","winrate","visibility"],"lang":"ru","levels":[{"filter":["AND",[["vmap_id","IN",["${vmap_id}"]]]],"id":"payment"}],"limits":{"limit":100,"offset":0},"period":"30days","order_by":[]}}',
    null, 1, 0, 'mol'
);

-- dsp_detailed_report_by_dsp_id

INSERT INTO
    `statistics_reports`
(`id`, `report_id`, `caption_en`, `caption_ru`,
    `description`, `level`, `query`, `owner_id`, `not_show`, `multistate`, `report_type`)
VALUES
('dsp_detailed_report_by_dsp_id',null,'','Отчет для DSP ID ${dsp_id} «${name}» за ${period||30days}',
    '', 'payment', '{"tableLevel":{"entity_fields":["dsp_id","dsp_caption"],"dimension_fields":["date|day"],"fields":["all_wo_nds","cpmv_all_wo_nds","hits","shows"],"lang":"ru","levels":[{"filter":["AND",[["dsp_id","IN",["${dsp_id}"]]]],"id":"payment"}],"limits":{"limit":100,"offset":0},"period":"30days","order_by":[{"sortBy":"date","sortOrder":"asc"}]},"chartLevel":{"entity_fields":["dsp_id","dsp_caption"],"dimension_fields":["date|day"],"fields":["all_wo_nds","cpmv_all_wo_nds","hits","shows"],"lang":"ru","levels":[{"filter":["AND",[["dsp_id","IN",["${dsp_id}"]]]],"id":"payment"}],"limits":{"limit":100,"offset":0},"period":"30days","order_by":[]}}',
    null, 1, 0, 'mol'
);

-- business_rules_report_by_rule_id

INSERT INTO
    `statistics_reports`
(`id`, `report_id`, `caption_en`, `caption_ru`,
    `description`, `level`, `query`, `owner_id`, `not_show`, `multistate`, `report_type`)
VALUES
('business_rules_report_by_rule_id',null,'','Отчет по бизнес-правилу ${business_rule_id} за ${period||30days}',
    '', 'payment', '{"tableLevel":{"entity_fields":[""],"dimension_fields":["date|day"],"fields":["partner_wo_nds","cpmv_partner_wo_nds","hits","hits_render","shows","winrate","visibility"],"lang":"ru","levels":[{"filter":["AND",[["business_rule_id","IN",["${business_rule_id}"]]]],"id":"payment"}],"limits":{"limit":100,"offset":0},"period":"30days","order_by":[{"sortBy":"date","sortOrder":"asc"}]},"chartLevel":{"entity_fields":[""],"dimension_fields":["date|day"],"fields":["partner_wo_nds","cpmv_partner_wo_nds","hits","hits_render","shows","winrate","visibility"],"lang":"ru","levels":[{"filter":["AND",[["business_rule_id","IN",["${business_rule_id}"]]]],"id":"payment"}],"limits":{"limit":100,"offset":0},"period":"30days","order_by":[]}}',
    null, 1, 0, 'mol'
);
