#!/bin/bash

PAUSE=3
BUNDLE=partner
YT_PATH=//home/partner/dict

change_yt_bundle_on_table() {
    if [ $# -eq 1 ]
    then
        if [ `yt get $1/@tablet_cell_bundle` == "\"$BUNDLE\"" ]
        then
            echo "Skip table [$1] since it already has bunle [$BUNDLE]"
        else
            if [ `yt get $1/@dynamic` == '%false' ]
            then
                yt set $1/@tablet_cell_bundle $BUNDLE && \
                    echo "Bundle [$BUNDLE] was applied on static table [$1] on cluster [$YT_PROXY]"
            else
                yt unmount-table $1 && \
                    echo "Dynamic table [$1] was unmounted on cluster [$YT_PROXY]" && \
                    sleep $PAUSE && \
                    yt set $1/@tablet_cell_bundle $BUNDLE && \
                    echo "Bundle [$BUNDLE] was applied on dynamic table [$1] on cluster [$YT_PROXY]" && \
                    sleep $PAUSE && \
                    yt mount-table $1 && \
                    echo "Dynamic table [$1] was mounted on cluster [$YT_PROXY]"
            fi
        fi
    else
        echo "Usage: change_yt_bundle_on_table table"
    fi
}

change_yt_bundle_on_cluster() {
    if [ $# -eq 1 ]
    then
        export YT_PROXY=$1.yt.yandex.net
        for table in $(yt list $YT_PATH)
        do
            if [ $table != 'backup' ]
            then
                change_yt_bundle_on_table $YT_PATH/$table
                echo
            fi
        done
    else
        echo "Usage: change_yt_bundle_on_cluster cluster"
    fi
}

change_yt_bundle_on_cluster arnold
change_yt_bundle_on_cluster hahn
