-- #dependencies PI-23720_statistics_reports_categories.sql
INSERT IGNORE INTO
    `statistics_reports_level_order`
    (`level_id`, `order`)
VALUES
    ('context_on_site_campaign', 20),
    ('mobile_app_settings', 110),
    ('context_on_site_content', 50);


UPDATE `statistics_reports` SET
`caption_ru` = 'По всем видам рекламы',
`query` = '{"tableLevel":{"entity_fields":["block_level"],"dimension_fields":["date|day"],"fields":["partner_wo_nds"],"lang":"ru","levels":[{"filter":null,"id":"payment"}],"limits":{"limit":50,"offset":0},"period":"30days","order_by":[{"sortBy":"date","sortOrder":"asc"}]}}'
WHERE
    `report_type` = 'mol' AND `id` = 'all_income';

UPDATE `statistics_reports` SET
`caption_ru` = 'По всем видам рекламы ADFOX',
`query` = '{"tableLevel":{"entity_fields":["block_level"],"dimension_fields":["date|day"],"fields":["partner_wo_nds"],"lang":"ru","levels":[{"filter":["AND",[["adfox_block","=",true]]],"id":"payment"}],"limits":{"limit":50,"offset":0},"period":"30days","order_by":[{"sortBy":"date","sortOrder":"asc"}]}}'
WHERE
    `report_type` = 'mol' AND `id` = 'all_income_adfox';


INSERT IGNORE INTO
    `statistics_reports`
(`id`, `caption_en`, `caption_ru`,
`level`, `query`,
`owner_id`, `not_show`, `multistate`, `report_type`)
VALUES
('context_rtb_detailed_report','','По РТБ-блокам на сайтах',
    'context_on_site_rtb','{"tableLevel":{"entity_fields":["complex_block_id","block_caption"],"dimension_fields":["date|day"],"fields":["partner_wo_nds","hits","hits_render","shows","cpmv_partner_wo_nds","winrate","visibility"],"lang":"ru","levels":[{"filter":["AND",[["block_level","=","context_on_site_rtb"]]],"id":"payment"}],"limits":{"limit":50,"offset":0},"period":"30days","order_by":[{"sortBy":"date","sortOrder":"asc"}]}}',
    null, 0, 0, 'mol'
),
('mobile_rtb_detailed_report','','По РТБ-блокам в приложениях',
    'mobile_app_rtb','{"tableLevel":{"entity_fields":["complex_block_id","block_caption"],"dimension_fields":["date|day"],"fields":["partner_wo_nds","hits","hits_render","shows","cpmv_partner_wo_nds","winrate","visibility"],"lang":"ru","levels":[{"filter":["AND",[["block_level","=","mobile_app_rtb"]]],"id":"payment"}],"limits":{"limit":50,"offset":0},"period":"30days","order_by":[{"sortBy":"date","sortOrder":"asc"}]}}',
    null, 0, 0, 'mol'
),
('video_instream_block_detailed_report','','По Instream-блокам',
    'video_an_site_instream','{"tableLevel":{"entity_fields":["complex_block_id","block_caption"],"dimension_fields":["date|day"],"fields":["partner_wo_nds","hits","hits_render","shows","cpmv_partner_wo_nds","winrate","visibility"],"lang":"ru","levels":[{"filter":["AND",[["block_level","=","video_an_site_instream"]]],"id":"payment"}],"limits":{"limit":50,"offset":0},"period":"30days","order_by":[{"sortBy":"date","sortOrder":"asc"}]}}',
    null, 0, 0, 'mol'
),
('all_context','','По сайтам',
    'context_on_site_campaign','{"tableLevel":{"entity_fields":["domain","page_id","page_caption"],"dimension_fields":["date|day"],"fields":["partner_wo_nds"],"lang":"ru","levels":[{"filter":["AND",[["page_level","=","context_on_site_campign"]]],"id":"payment"}],"limits":{"limit":50,"offset":0},"period":"30days","order_by":[{"sortBy":"date","sortOrder":"asc"}]}}',
    null, 0, 0, 'mol'
),
('all_mobile','','По приложениям',
    'mobile_app_settings', '{"tableLevel":{"entity_fields":["domain","page_id","page_caption"],"dimension_fields":["date|day"],"fields":["partner_wo_nds"],"lang":"ru","levels":[{"filter":["AND",[["page_level","=","mobile_app_settings"]]],"id":"payment"}],"limits":{"limit":50,"offset":0},"period":"30days","order_by":[{"sortBy":"date","sortOrder":"asc"}]}}',
    null, 0, 0, 'mol'
),
('all_video','','По видеоресурсам',
    'video_an_site', '{"tableLevel":{"entity_fields":["domain","page_id","page_caption"],"dimension_fields":["date|day"],"fields":["partner_wo_nds"],"lang":"ru","levels":[{"filter":["AND",[["page_level","=","video_an_site"]]],"id":"payment"}],"limits":{"limit":50,"offset":0},"period":"30days","order_by":[{"sortBy":"date","sortOrder":"asc"}]}}',
    null, 0, 0, 'mol'
),
('recwidget_detailed_report','','По рекомендательному виджету',
    'context_on_site_content', '{"tableLevel":{"entity_fields":["complex_block_id","block_caption"],"dimension_fields":["date|day"],"fields":["partner_wo_nds","cpmv_partner_wo_nds","rec_widget_ctr","rec_card_ctr","rec_widget_clicks","rec_card_shows"],"lang":"ru","levels":[{"filter":["AND",[["block_level","=","context_on_site_content"]]],"id":"payment"}],"limits":{"limit":50,"offset":0},"period":"30days","order_by":[{"sortBy":"date","sortOrder":"asc"}]}}',
    null, 0, 0, 'mol'
),
('context_rtb_tags_report','','По срезам',
    'context_on_site_rtb', '{"tableLevel":{"entity_fields":["page_id","page_caption","tag_id"],"dimension_fields":["date|day"],"fields":["partner_wo_nds","hits","hits_render","shows","cpmv_partner_wo_nds"],"lang":"ru","levels":[{"filter":null,"id":"payment"}],"limits":{"limit":50,"offset":0},"period":"30days","order_by":[{"sortBy":"date","sortOrder":"asc"}]}}',
    null, 0, 0, 'mol'
)
;

-- pages category
UPDATE
    statistics_reports
SET
    category_bits = category_bits | 64
WHERE id in ('all_context', 'all_mobile', 'all_video')
;
-- blocks category
UPDATE
    statistics_reports
SET
    category_bits = category_bits | 128
WHERE id in ('context_rtb_detailed_report','mobile_rtb_detailed_report','video_instream_block_detailed_report','recwidget_detailed_report')
;
-- misc category
UPDATE
    statistics_reports
SET
    category_bits = category_bits | 256
WHERE id in ('context_rtb_tags_report')
;

-- set hidden
UPDATE
    statistics_reports
SET
    not_show = 1
WHERE
    report_type = 'mol' AND
    id NOT IN ('all_income', 'all_income_adfox','all_context', 'all_mobile', 'all_video', 'context_rtb_detailed_report','mobile_rtb_detailed_report','video_instream_block_detailed_report','recwidget_detailed_report', 'context_rtb_tags_report')
;
