-- adding new column for category_bits
ALTER TABLE
    statistics_reports
ADD COLUMN
    category_bits INT UNSIGNED NOT NULL DEFAULT 0;
-- MOL (new) report category_bits
UPDATE
    statistics_reports
SET
    category_bits = category_bits | 1
WHERE
    report_type = 'mol'
;
-- User (not standard) report category_bits
UPDATE
    statistics_reports
SET
    category_bits = category_bits | 2
WHERE
    owner_id IS NOT NULL
;
-- Main report category_bits
UPDATE
    statistics_reports
SET
    category_bits = category_bits | 4
;
-- Mobile mediation report category_bits
UPDATE
    statistics_reports
SET
    category_bits = category_bits | 8
WHERE 0
;
-- DSP report category_bits
UPDATE
    statistics_reports
SET
    category_bits = category_bits | 16
WHERE 0
;
-- MAIN subcategories
-- main
UPDATE
    statistics_reports
SET
    category_bits = category_bits | 32
WHERE id in ('all_income', 'all_income_adfox')
;
-- pages
UPDATE
    statistics_reports
SET
    category_bits = category_bits | 64
WHERE id in ('context_income_30days','context_income_7days','mobile_income_30days','mobile_income_7days','video_blocks_report','video_income_30days','video_income_7days')
;
-- blocks
UPDATE
    statistics_reports
SET
    category_bits = category_bits | 128
WHERE id in ('context_rtb_detailed_report_30days','context_rtb_report_30days','mobile_rtb_detailed_report_30days','mobile_rtb_report_30days','video_instream_block_detailed_report_30days','video_instream_block_report_30days')
;
-- misc
UPDATE
    statistics_reports
SET
    category_bits = category_bits | 256
WHERE id in ('context_rtb_tags_report_30days')
;
