#!/usr/bin/perl

use qbit;
use Utils::ScriptWrapper;

run(
    sub {
        my ($app, $opts) = @_;

        my $data = $app->partner_db->query->select(
            table  => $app->partner_db->users,
            alias  => 'u',
            fields => [qw(client_id)],
          )->left_join(
            table   => $app->partner_db->contracts,
            alias   => 'c',
            join_on => [AND => [[{client_id => 'c'} => '=' => {client_id => 'u'}],]],
            filter => [AND => [[client_id => 'IS' => \undef],],],
          )->get_all();

        foreach my $user (@$data) {
            if ($user->{client_id}) {
                try {
                    my $contracts = $app->documents->get_live_contracts(client_id => $user->{client_id});
                    if (@$contracts) {
                        my $contract = $contracts->[0];
                        print logstr scalar(@$contracts) . " live contracts for client_id = $user->{client_id}"
                          if (@$contracts > 1);
                        $app->contracts->add(
                            id          => $contract->{Contract}{contract2_id},
                            multistate  => 0,
                            type        => $contract->{Contract}{type},
                            external_id => $contract->{Contract}{external_id},
                            client_id   => $user->{client_id},
                            dt          => $contract->{Contract}{dt},
                            end_dt      => $contract->{Contract}{end_dt},
                            update_dt   => $contract->{Contract}{update_dt},
                            contract    => to_json $contract->{Contract},
                            opts        => '{}',
                        );
                    }
                }
                catch {
                    print logstr 'Error while process user', $user, "$_[0]";
                };
            }
        }
    }
   );
