CREATE TABLE IF NOT EXISTS `contracts` (
    `id` BIGINT UNSIGNED NOT NULL,
    `multistate` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `type` VARCHAR(32) NOT NULL,
    `external_id` VARCHAR(32) NOT NULL,
    `client_id` BIGINT UNSIGNED NOT NULL,
    `dt` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
    `end_dt` DATETIME,
    `update_dt` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
    `contract` VARCHAR(1024) NOT NULL,
    `opts` JSON NOT NULL,
    PRIMARY KEY (`id`),
    INDEX `contracts__multistate` (`multistate`),
    INDEX `contracts__client_id` (`client_id`),
    INDEX `contracts__end_dt` (`end_dt`)
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8';

CREATE TABLE IF NOT EXISTS `contracts_action_log` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `dt` DATETIME NOT NULL,
    `user_id` BIGINT UNSIGNED NOT NULL,
    `elem_id` BIGINT UNSIGNED NOT NULL,
    `old_multistate` BIGINT UNSIGNED NOT NULL,
    `action` VARCHAR(100) NOT NULL,
    `new_multistate` BIGINT UNSIGNED NOT NULL,
    `opts` MEDIUMTEXT NOT NULL,
    `comment` VARCHAR(100) NOT NULL DEFAULT '',
    PRIMARY KEY (`id`),
    INDEX `contracts_action_log__dt_elem_id_action` (`dt`, `elem_id`, `action`),
    INDEX `contracts_action_log__elem_id_action` (`elem_id`, `action`),
    FOREIGN KEY `fk_contracts_action_log__user_id___users__id` (`user_id`)
        REFERENCES `users` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_contracts_action_log__elem_id___contracts__id` (`elem_id`)
        REFERENCES `contracts` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8';
