UPDATE
    statistics_reports
SET
    query = json_set(query, '$.tableLevel.stat_type', "dsp", '$.chartLevel.stat_type', "dsp")
WHERE
    id = 'dsp_detailed_report_by_dsp_id' AND
    report_type = 'mol'
;

UPDATE
    statistics_reports
SET
    query = json_set(query,'$.tableLevel.levels[0].filter[1][0][2][0]','${rule_id}','$.chartLevel.levels[0].filter[1][0][2][0]','${rule_id}')
WHERE
    id = 'business_rules_report_by_rule_id' AND
    report_type = 'mol'
;

DELETE FROM
    `statistics_reports`
WHERE
    report_type = 'mol' AND
    id IN ('mobmed_report_by_app_id', 'mobmed_report_by_place_id');

INSERT INTO `statistics_reports`
    (`id`, `caption_en`, `caption_ru`, `level`, `category_bits`, `owner_id`, `not_show`, `multistate`, `report_type`, `query`)
VALUES
(
'mobmed_report_by_app_id', 'By application', 'По приложению', 'payment', 1|8, null, 1, 0, 'mol',
'{"tableLevel":{"entity_fields":["place_id","place_name","mobile_caption","monetizer_caption"],"dimension_fields":["date|day"],"fields":["hits_mm","impressions_mm","fill_rate_mm","revenue_mm","revenue_original_mm_rubrsya","revenue_original_mm_rub","revenue_original_mm_usd","revenue_original_mm_eur"],"lang":"ru","levels":[{"id":"payment","filter":["AND",[["application_id","IN",["${app_id}"]]]]}],"limits":{"limit":10,"offset":0},"period":"30days","stat_type":"mm","order_by":[]}}'
),
(
'mobmed_report_by_place_id', 'By place', 'По размещению', 'payment', 1|8, null, 1, 0, 'mol',
'{"tableLevel":{"entity_fields":["place_name","mobile_caption","monetizer_caption"],"dimension_fields":["date|day"],"fields":["hits_mm","impressions_mm","fill_rate_mm","revenue_mm","revenue_original_mm_rubrsya","revenue_original_mm_rub","revenue_original_mm_usd","revenue_original_mm_eur"],"lang":"ru","levels":[{"id":"payment","filter":["AND",[["place_id","IN",["${place_id}"]]]]}],"limits":{"limit":10,"offset":0},"period":"30days","stat_type":"mm","order_by":[]}}'
)
;
