UPDATE notification
SET message_ru        = 'Ваш ресурс "[% custom_data.resource | html %]" отклонен модерацией. Причины отклонения:<br />
[% FOREACH moderation_reason = custom_data.reason %]
    &mdash; [% moderation_reason | html %]<br />
[% END %]
Причина также указана в Партнерском интерфейсе в статусе вашей площадки. Рекомендуем комплексно поработать над качеством сайта, его контентом и пользовательскими метриками. Отклонённые площадки можно повторно отправить на модерацию после приведения сайта в соответствие с правилами участия. Для этого обратитесь в службу поддержки.',
    message_en        = 'Your resource "[% custom_data.resource | html %]" was rejected by moderation as it does not comply with the rules governing participation in the Yandex Advertising Network. We recommend performing a comprehensive review of the site''s quality, content and user metrics. Rejected sites can be re-submitted for moderation once the site has been brought into compliance with the rules of participation. To do so, contact the support service.',
    button_caption_ru = 'Служба поддержки РСЯ',
    button_caption_en = 'Yandex Advertising Network Support Service',
    url               = 'https://yandex.ru/support/partner2/support.html'
WHERE id = 3;

UPDATE text_template
SET content_ru = '<p>Добрый день!</p>
<p>Мы постоянно следим за качеством площадок Рекламной сети. Помимо модерации новых ресурсов, подключаемых к РСЯ, мы можем проводить перемодерацию уже подключенных площадок без дополнительного уведомления.</p>
<p>По итогам проверки Ваш ресурс "[% resource | html %]" был отклонен модераторами. Причины отклонения:<br />
[% FOREACH moderation_reason = reason %]
    &mdash; [% moderation_reason | html %]<br />
[% END %]
<p>Причины также указаны в Партнерском интерфейсе в статусе вашей площадки: <a href="https://partner2.yandex.ru/v2/context/campaigns/" target="_blank">тематической</a> или <a href="https://partner2.yandex.ru/v2/mobile/campaigns/" target="_blank">мобильной</a>.</p>
<p>Отклоненную площадку можно повторно отправить на модерацию. Приведите сайт в соответствие с <a href="https://yandex.ru/legal/partner/" target="_blank">Правилами участия</a> и после этого нажмите кнопку «Отправить на модерацию» в Партнерском интерфейсе РСЯ.</p>
<p>Обратите внимание: кнопка доступна только по истечении определенного количества дней после отклонения. Узнать подробнее о сроках повторной модерации и причинах отклонения можно в <a href="https://yandex.ru/support/partner2/joining/moderation.html" target="_blank">Справке</a>.</p>
<p>Если у вас возникнут вопросы, вы можете обратиться в Службу поддержки РСЯ через <a href="https://yandex.ru/support/partner2/support.html" target="_blank">форму обратной связи</a>.</p>

<p>С уважением,<br />
    команда Рекламной сети Яндекса</p>',
    content_en = '<p>Dear publisher!</p>
<p>It is important for us to keep good quality of the resources in the Yandex Advertising Network. Apart from new resources moderation, we can perform audit of resources quality without preliminary notification.</p>
<p>Your resource "[% resource | html %]" is rejected by moderator. The reasons are:<br />
[% FOREACH moderation_reason = reason %]
    &mdash; [% moderation_reason | html %]<br />
[% END %]
<p>The reasons are also listed in the Yandex Advertising network partner interface in your <a href="https://partner2.yandex.ru/v2/context/campaigns/" target="_blank">context site</a> or <a href="https://partner2.yandex.ru/v2/mobile/campaigns/" target="_blank">mobile platform</a> resource status.</p>
<p>Rejected resource can be sent to moderation again. Bring it into compliance to the <a href="https://yandex.ru/legal/partner/" target="_blank">participation rules</a> and click "Send to moderation" button on the resource page of Advertising Network partner interface.</p>
<p>Please note, that the button will become active after delay as described in the <a href="https://yandex.ru/support/partner2/joining/moderation.html?lang=en" target="_blank">Help guidelines</a>.</p>
<p>If you have any questions, please contact Yandex Advertising Network support through the <a href="https://yandex.ru/support/partner2/support.html" target="_blank">feedback form</a>.</p>

<p>Best regards,<br />
    Yandex Advertising Network team.</p>'
WHERE `key` = 'letter_after_reject';
