INSERT INTO
    kv_store_frontend
    (user_id, create_time, update_time, `key`, `value`)
VALUES
    (0, NOW(), NOW(), 'NativeContextRuTemplates', "[{\"value\":\"5\",\"name\":\"grid\",\"label\":\"Мобильный сингл 100% x 100px\",\"props\":{},\"template\":\"<ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n\\n  <div class=\\\"unit-misc\\\">\\n    <ya-unit-kebab class=\\\"ya-unit-kebab_dark\\\" />\\n  </div>\\n\\n  <div class=\\\"unit-content\\\">\\n\\n    <!-- Начало Шаблона ТГО -->\\n    <ya-unit-if condition=\\\"!unit.isRmp\\\">\\n      <div class=\\\"unit-meta\\\">\\n        <ya-unit-category class=\\\"unit-category\\\" />\\n        <ya-unit-age class=\\\"unit-age\\\" />\\n      </div>\\n\\n      <div class=\\\"unit-image-block\\\">\\n        <ya-unit-image disable-disclaimer />\\n      </div>\\n\\n      <div class=\\\"unit-text-content\\\" data-cols=\\\"1\\\" data-rows=\\\"1\\\">\\n\\n        <div class=\\\"unit-title\\\">\\n          <ya-unit-if condition=\\\"unit.title < 22\\\">\\n            <span class=\\\"title-short\\\">\\n              <ya-clamp lines=\\\"3\\\"><ya-unit-title /></ya-clamp>\\n            </span>\\n          </ya-unit-if>\\n\\n          <ya-unit-if condition=\\\"unit.title > 21 & unit.title < 37\\\">\\n            <span class=\\\"title-mid\\\">\\n              <ya-clamp lines=\\\"3\\\"><ya-unit-title /></ya-clamp>\\n            </span>\\n          </ya-unit-if>\\n\\n          <ya-unit-if condition=\\\"unit.title > 36\\\">\\n            <span class=\\\"title-long\\\">\\n              <ya-clamp lines=\\\"3\\\"><ya-unit-title /></ya-clamp>\\n            </span>\\n          </ya-unit-if>\\n        </div>\\n\\n        <div class=\\\"unit-prices\\\"><ya-unit-price /><ya-unit-old-price /></div>\\n  \\n        <div class=\\\"unit-desc\\\">\\n          <ya-clamp lines=\\\"2\\\">\\n            <ya-unit-desc class=\\\"desc\\\" />\\n          </ya-clamp>\\n        </div>\\n\\n        <div class=\\\"unit-cta\\\">\\n          <div class=\\\"unit-domain\\\">\\n            <span class=\\\"unit-domain-no-wrap\\\">\\n              <span class=\\\"unit-favicon\\\"><ya-unit-favicon size=\\\"32\\\"/></span>\\n              <ya-unit-domain class=\\\"domain\\\"/>\\n            </span>\\n          </div>\\n        </div>\\n\\n      </div>\\n\\n    </ya-unit-if>\\n    <!-- Конец Шаблона ТГО -->\\n\\n\\n    \\n    <!-- Начало Шаблона РМП -->\\n    <ya-unit-if condition=\\\"unit.isRmp\\\">\\n\\n      <div class=\\\"unit-image-block\\\">\\n        <ya-unit-app-icon />\\n      </div>\\n\\n      <div class=\\\"unit-text-content unit-rmp-content\\\" data-cols=\\\"1\\\" data-rows=\\\"1\\\">\\n\\n        <div class=\\\"unit-title\\\">\\n          <span class=\\\"title-rmp\\\">\\n            <ya-clamp lines=\\\"2\\\"><ya-unit-title /></ya-clamp>\\n          </span>\\n        </div>\\n\\n        <div class=\\\"unit-app-name\\\">\\n          <ya-clamp lines=\\\"1\\\">\\n            <ya-unit-app-name />\\n          </ya-clamp>\\n        </div>\\n\\n        <div class=\\\"unit-app-rating\\\">\\n          <ya-unit-rating />\\n          <ya-unit-review-count />\\n          <div class=\\\"unit-meta\\\">\\n            <ya-unit-category class=\\\"unit-category\\\" />\\n            <ya-unit-age class=\\\"unit-age\\\" />\\n          </div>\\n        </div>\\n\\n        <div class=\\\"unit-cta\\\">\\n          <div class=\\\"unit-domain\\\">\\n            <ya-unit-mobile-app-button />\\n          </div>\\n        </div>\\n  \\n      </div>\\n\\n    </ya-unit-if>\\n    <!-- Конец Шаблона РМП -->\\n\\n  </div>\\n</ya-units-grid>\",\"css\":\"/* Шаблон 1: Мобильный сингл размером 100% x 100px\\n   Для использования в шапках сайта или \\\"подвалах\\\" */\\n\\n\\n/* Шаблоны не работают в браузерах IE 11 версии и ниже */\\n\\n/* РМП — Реклама Мобильных Приложений */\\n\\n\\n/* -------- Переменные цветов -------- */\\n/* изменив значение цвета тут — изменится во всех элементах шаблона */\\n.ya-container {\\n\\n  --color-blue: #3377FF;\\n  --color-blue-dark: #0055FF;\\n\\n  --color-blue-transparent: #3377FF1A;\\n  --color-blue-dark-transparent: #0055FF1A;\\n\\n  --color-yellow: #FFCC33;\\n  --color-yellow-dark: #FFBF00;\\n\\n  --color-black: #232526;\\n  --color-grey: #575c66;\\n  --color-grey-alt: #A3ACBF;\\n  --color-light: #f4f4f6;\\n  --color-light-alt: #ececef;\\n}\\n\\n/* Переменные цветов для устройств с поддержкой \\n   цветового профиля Display P3 (устройства Apple) */\\n\\n/* Устройства Apple поддерживают цветовой профиль \\n   с более яркими цветами (цветовой профиль Display P3). \\n   Если вы хотите поддержать его, то следует поменять \\n   значения цветов в блоке ниже */\\n@supports (color: color(display-p3)) {\\n  .ya-container {\\n    --color-blue: color(display-p3 0.2 0.47 1.0);\\n    --color-blue-dark: color(display-p3 0.0 0.33 1.0);\\n\\n    --color-blue-transparent: color(display-p3 0.2 0.47 1.0 / 0.1);\\n    --color-blue-dark-transparent: color(display-p3 0.0 0.33 1.0 / 0.1);\\n\\n    --color-yellow: color(display-p3 1.0 0.8 0.2);\\n    --color-yellow-dark: color(display-p3 1.0 0.75 0.0);\\n  }\\n}\\n\\n\\n\\n/* -------- Переменные для отрисовки объявления -------- */\\n\\n.ya-container {\\n\\n  /* Адаптивность объявления по ширине.\\n     Укажите значение none, чтобы зафиксировать размер объявления.\\n     Укажите auto, чтобы объявление занимало всю доступную ширину */\\n  --banner-flex: auto;\\n\\n  /* Фиксированная ширина объявления.\\n     Работает при --banner-flex: none */\\n  --banner-width: 320px;\\n\\n  /* Минимальная и максимальная ширина объявления.\\n     Работает при --banner-flex: auto */\\n  --banner-min-width: 300px;\\n  --banner-max-width: 640px;\\n\\n  /* Минимальная и максимальная высота объявления.\\n     Объявление будет растягиваться по высоте \\n     в зависимости от количества контента */\\n  --banner-min-height: 100px;\\n  --banner-max-height: 100px;\\n\\n\\n  /* Отображение фавиконки: \\n     вкл - block, выкл - none; */\\n  --display-favicon: block;\\n  /* Отображение изображения: \\n     вкл - block, выкл - none; */\\n  --display-image: block;\\n  /* Отображение текста: \\n     вкл - block, выкл - none; */\\n  --display-desc: none;\\n  /* Отображение цен: \\n     вкл - inline, выкл - none */\\n  --display-price: inline;\\n  /* Отображение количества отзывов (для РМП): \\n     вкл - inline, выкл - none */\\n  --display-rmp-rating-count: none;\\n\\n\\n  /* Максимальная ширина картинки */\\n  --image-max-width: 96px;\\n\\n  /* Высота картинки */\\n  --image-height: 100%;\\n\\n  /* Размер иконки приложения.\\n     Только для рекламы мобильных приложений */\\n  --app-icon-size: 80px;\\n\\n  /* Горизонтальное позиционирование сетки баннеров\\n     center - по середине, flex-start - слева,\\n     space-between - по всей ширине, space-around - по всей ширине с отступами\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/justify-content */\\n  --banners-justify-content: center;\\n\\n  /* Отступы вокруг объявления */\\n  --banner-margin: 0px;\\n  \\n  /* Отступы первых и последних объявлений от края \\n     по горизонтали и вертикали. Значение var(--banner-margin) \\n     повторяет общее значение отступов. \\n     ! Неприменимо для одиночных объявлений */\\n  --banners-grid-first-item-top-margin: var(--banner-margin);\\n  --banners-grid-first-item-left-margin: var(--banner-margin);\\n  --banners-grid-first-item-right-margin: var(--banner-margin);\\n  --banners-grid-first-item-bottom-margin: var(--banner-margin);\\n\\n  /* Цвет фона объявления. Пример: white или #f0f2f8;\\n     Допустимо использование переменных. См. начало документа */\\n  --banner-background: white;\\n  /* Цвет фона при наведении на объявление */\\n  --banner-background-hover: white;\\n\\n  /* Обводка объявления. Для отключения укажите значение none\\n     Пример: solid 1px rgba(0 0 0 / 15%);\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/border */\\n  --banner-stroke: solid 1px rgba(0 0 0 / 15%);\\n  \\n  /* Тень объявления. Пример: 0px 8px 24px rgba(0, 21, 64, 0.125);\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/box-shadow */\\n  --banner-shadow: none;\\n  /* Тень объявления при наведении */\\n  --banner-shadow-hover: none;\\n  /* Трансформация объявления при наведении. Пример: translateY(-2px); */\\n  --banner-transform-hover: none;\\n  /* Анимация изменений при наведении */\\n  --banner-transition: box-shadow 120ms ease, transform 120ms ease;\\n\\n  /* Скругление углов объявления */\\n  --banner-outer-border-radius: 0px;\\n  /* Скругление углов внутренних элементов объявления (картинка, кнопки) */\\n  --banner-inner-border-radius: 8px;\\n  \\n  /* Отступы элементов от краев объявления */\\n  --banner-padding-outer: 0px 12px;\\n  /* Отступы между элементами объявления */\\n  --banner-padding-inner: 4px;\\n\\n\\n  /* Цвет заголовка в объявлении */\\n  --color-text-header: var(--color-black); \\n  /* Цвет текста в объявлении */\\n  --color-text-desc: var(--color-grey-alt);\\n  /* Цвет цены в объявлении */\\n  --color-text-price: var(--color-black);\\n  /* Цвет ссылки в объявлении */\\n  --color-text-domain: var(--color-blue);\\n  /* Цвет ссылки в объявлении при наведении */\\n  --color-text-domain-hover: var(--color-blue-dark);\\n  /* Фон кнопки действия. Не применимо, если кнопка \\n     не предусмотрена в шаблоне (для форматов маленького размера) */\\n  --color-background-domain: var(--color-blue-transparent);\\n  /* Фон кнопки действия при наведении */\\n  --color-background-domain-hover: var(--color-blue-dark-transparent);\\n\\n  /* Цвет названия приложения в объявления (для РМП) */\\n  --color-text-app-name: var(--color-grey-alt);\\n\\n\\n  /* Цепочка используемых шрифтов в объявлении. По умолчанию указана \\n     цепочка системных шрифтов. Если шрифт не поддерживается, используется \\n     следующий по цепочке. При использовании собственного шрифта, \\n     следует указывать его название в самом начале */\\n  --font-family: \\n    -apple-system, BlinkMacSystemFont, \\\"Segoe UI\\\", Roboto, \\n    Oxygen, Ubuntu, Cantarell, \\\"Open Sans\\\", \\\"Helvetica Neue\\\", sans-serif, \\n    Apple Color Emoji, Segoe UI Emoji;\\n\\n  /* Размер шрифта и межстрочное расстояние для коротких заголовков\\n     (до 21 символа) */\\n  --font-size-title-short: 22px;\\n  --line-height-title-short: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для заголовков средней длины \\n     (от 22 до 36 символа) */\\n  --font-size-title-mid: 16px;\\n  --line-height-title-mid: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для длинных заголовков \\n     (от 37 символов) */\\n  --font-size-title-long: 14px;\\n  --line-height-title-long: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для заголовков РМП */\\n  --font-size-title-rmp: 14px;\\n  --line-height-title-rmp: calc(1em + 0px);\\n\\n  /* Размер шрифта и межстрочное расстояние для цен */\\n  --font-size-price: 14px;\\n  --line-height-price: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для текста объявления */\\n  --font-size-desc: 14px;\\n  --line-height-desc: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для ссылки */\\n  --font-size-domain: 12px;\\n  --line-height-domain: 16px;\\n\\n  /* Размер шрифта и межстрочное расстояние для названия приложения \\n     (для РМП) */\\n  --font-size-app-name: 12px;\\n  --line-height-app-name: calc(1em + 4px);\\n  \\n\\n  width: 100%;\\n  margin: 0 auto;\\n\\n  height: auto;\\n  padding: 0;\\n  overflow: visible;\\n}\\n\\n/* Специальные переменные для Рекламы Мобильных Приложений */\\n.unit-rmp-content {\\n  /* Цвет ссылки */\\n  --color-text-domain: var(--color-blue);\\n  /* Цвет ссылки при наведении */\\n  --color-text-domain-hover: var(--color-blue-dark);\\n  /* Цвет фона кнопки объявления.\\n     Не применимо если, кнопки не предусмотрено (для маленьких форматов) */\\n  --color-background-domain: var(--color-blue-transparent);\\n  /* Цвет фона кнопки объявления при наведении */\\n  --color-background-domain-hover: var(--color-blue-dark-transparent);\\n}\\n\\n/* Специальные значения для размеров экрана шире 400px */\\n@media screen and (min-width: 400px) {\\n\\n  .ya-container {\\n    --banner-padding-outer: 0px 16px;\\n\\n    --font-size-title: 18px;\\n    --line-height-title: calc(1em + 2px);\\n\\n    --font-size-title-short: 24px;\\n    --line-height-title-short: calc(1em + 2px);\\n\\n    --font-size-title-mid: 20px;\\n    --line-height-title-mid: calc(1em + 2px);\\n\\n    --font-size-title-long: 16px;\\n    --line-height-title-long: calc(1em + 2px);\\n\\n    --font-size-desc: 15px;\\n    --line-height-desc: calc(1em + 4px);\\n\\n    --font-size-domain: 14px;\\n    --line-height-domain: 16px;\\n  }\\n\\n  .ya-unit-review-count {\\n    --display-rmp-rating-count: inline;\\n  }\\n}\\n\\n/* Специальные значения для размеров экрана шире 480px */\\n@media screen and (min-width: 480px) {\\n  .ya-container {\\n    --image-width: 160px;\\n    --image-max-width: 160px;\\n  }\\n}\\n\\n\\n\\n\\n/* -------- Далее — настройка стилей объявления. -------- */\\n/* -------- Не рекомендуется редактировать -------- */\\n\\n.ya-units-grid {\\n  margin: 0px auto;\\n}\\n\\n.grid-row {\\n  justify-content: var(--banners-justify-content);\\n  align-content: var(--banners-align-content);\\n  padding: 0px 0;\\n}\\n\\n.grid-item {\\n  width: var(--banner-width);\\n  min-width: var(--banner-min-width);\\n  max-width: var(--banner-max-width);\\n  \\n  min-height: var(--banner-min-height);\\n  max-height: var(--banner-max-height);\\n\\n  font-family: var(--font-family);\\n  background: var(--banner-background);\\n\\n  border: var(--banner-stroke);\\n\\n  margin: var(--banner-margin, inherit);\\n  border-radius: var(--banner-outer-border-radius);\\n  overflow: hidden;\\n  box-sizing: border-box;\\n\\n  flex: var(--banner-flex);\\n\\n  box-shadow: var(--banner-shadow);\\n  transform: none;\\n  transition: var(--banner-transition);\\n}\\n\\n.grid-item:hover {\\n  transform: var(--banner-transform-hover);\\n  box-shadow: var(--banner-shadow-hover);\\n  background: var(--banner-background-hover);\\n  --color-text-domain: var(--color-text-domain-hover);\\n}\\n\\n.grid-item:first-child {\\n  margin-left: var(--banners-grid-first-item-left-margin);\\n}\\n\\n.grid-item:last-child {\\n  margin-right: var(--banners-grid-first-item-right-margin);\\n}\\n\\n.grid-row:first-child .grid-item {\\n  margin-top: var(--banners-grid-first-item-top-margin);\\n}\\n\\n.grid-row:last-child .grid-item {\\n  margin-bottom: var(--banners-grid-first-item-bottom-margin);\\n}\\n\\n.unit-wrapper {\\n  height: 100%;\\n}\\n\\n.ya-unit-favicon {\\n  display: block !important;\\n}\\n\\na.yrw-url {\\n  color: inherit;\\n  cursor: pointer;\\n}\\n\\n.unit-misc {\\n  position: absolute;\\n  top: 0;\\n  left: 0;\\n  width: 100%;\\n  height: 100%;\\n}\\n\\n.unit-meta {\\n  position: absolute;\\n  top: 4px;\\n  left: 4px;\\n  z-index: 2;\\n  padding: 0px 4px 0px;\\n  text-transform: uppercase;\\n  height: 12px;\\n  background: white;\\n  color: var(--color-grey);\\n  border-radius: 4px;\\n  font-size: 8px;\\n  line-height: 13px;\\n  font-weight: 500;\\n  letter-spacing: 0.12em;\\n  vertical-align: 5px;\\n  margin: 0;\\n  user-select: none;\\n  -ms-user-select: none;\\n  -moz-user-select: none;\\n  -khtml-user-select: none;\\n  -webkit-user-select: none;\\n}\\n\\n.unit-rmp-content .unit-meta {\\n  background: transparent;\\n  position: relative;\\n}\\n\\n.unit-age::before {\\n  content: \\\" | \\\";\\n}\\n\\n.unit-age:empty {\\n  display: none;\\n}\\n\\n.ya-unit-kebab_button svg circle {\\n  fill: var(--color-grey);\\n}\\n\\n.ya-unit-kebab_bg {\\n  background: white;\\n  opacity: 1.0;\\n}\\n\\n.ya-unit-kebab_icon {\\n  filter: var(--display-image, none);\\n}\\n\\n.ya-unit-kebab_icon circle {\\n  fill: var(--color-grey) !important;\\n}\\n\\n.ya-unit-kebab_button {\\n  position: absolute;\\n  z-index: 940;\\n  top: 4px;\\n  right: 4px;\\n  width: 24px;\\n  height: 24px;\\n}\\n\\n.yrw-body_warning {\\n  position: relative;\\n}\\n\\n.yrw-body_warning div {\\n  padding: 0;\\n}\\n\\n.yrw-body_warning div:not(.yrw-warning-wrapper):not(.yrw-warning-text) {\\n  position: relative;\\n  background-color: var(--color-light-alt);\\n  color: #575c66;\\n  display: flex;\\n  padding: 0 calc(var(--inner-border-radius) / 2);\\n}\\n\\n.yrw-body_warning div text {\\n  fill: #575c66;\\n}\\n\\n.yrw-body_warning div:not(.yrw-warning-wrapper) {\\n  padding: 0 calc(var(--inner-border-radius) / 2 + 4px);\\n}\\n\\n.yrw-warning-text {\\n  text-shadow: none;\\n}\\n\\n\\n\\n.unit-container {\\n  box-sizing: border-box;\\n  position: relative;\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: flex-end;\\n  overflow: hidden;\\n  max-width: var(--max-content-width, --banner-max-width, 960px);\\n  margin: auto;\\n}\\n\\n.unit-content {\\n  display: flex;\\n  flex-direction: row;\\n  justify-content: flex-start;\\n  position: relative;\\n  height: 100%;\\n}\\n\\n.unit-text-content {\\n  display: flex;\\n  justify-content: center;\\n  flex-direction: column;\\n  flex: auto;\\n  height: 100%;\\n  padding: var(--banner-padding-outer);\\n  padding-right: 32px;\\n}\\n\\n.unit-text-content > div {\\n  margin-top: var(--banner-padding-inner);\\n}\\n\\n.unit-text-content > div:first-child {\\n  margin-top: 0;\\n}\\n\\n\\n\\n.ya-unit-title, .unit-title {\\n  color: var(--color-text-header);\\n  font-size: var(--font-size-title);\\n  line-height: var(--line-height-title);\\n  font-weight: 600;\\n  display: flex;\\n}\\n\\n.title-short {\\n  font-size: var(--font-size-title-short);\\n  line-height: var(--line-height-title-short);\\n}\\n\\n.title-mid {\\n  font-size: var(--font-size-title-mid);\\n  line-height: var(--line-height-title-mid);\\n}\\n\\n.title-long {\\n  font-size: var(--font-size-title-long);\\n  line-height: var(--line-height-title-long);\\n}\\n\\n.title-rmp {\\n  font-size: var(--font-size-title-rmp);\\n  line-height: var(--line-height-title-rmp);\\n\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: center;\\n}\\n\\n.unit-app-name {\\n  font-size: var(--font-size-app-name);\\n  line-height: var(--line-height-app-name);\\n  color: var(--color-text-app-name);\\n}\\n\\n\\n\\n.unit-favicon {\\n  width: var(--font-size-domain);\\n  background-color: white;\\n  border-radius: 3px;\\n  margin-right: calc(var(--font-size-domain) / 3.5);\\n  align-self: center;\\n  display: var(--display-favicon, inline);\\n}\\n\\n.ya-unit-favicon {\\n  width: var(--font-size-domain);\\n  height: var(--font-size-domain);\\n}\\n\\n.ya-unit-rating {\\n  margin-right: 4px;\\n  height: 16px;\\n  display: inline;\\n}\\n\\n.ya-unit-review-count {\\n  display: var(--display-rmp-rating-count);\\n}\\n\\n.unit-favicon:empty,\\n.ya-unit-domain:empty,\\n.unit-domain:empty {\\n  display: none;\\n}\\n\\n.unit-domain {\\n  display: flex;\\n  margin-right: auto;\\n  border-radius: 4px;\\n  color: var(--color-text-domain);\\n  font-size: var(--font-size-domain);\\n  line-height: var(--line-height-domain);\\n  \\n  padding: 0;\\n  width: 100%;\\n  height: var(--line-height-domain, 16px);\\n  flex-direction: row;\\n  flex-wrap: wrap;\\n  justify-content: flex-start;\\n  align-content: flex-end;\\n  overflow: hidden;\\n}\\n\\n.unit-domain span {\\n  flex: none;\\n}\\n\\n.unit-domain-no-wrap {\\n  display: flex;\\n}\\n\\n.unit-with-warning .ya-unit-item-rmp .unit-cta {\\n  display: none;\\n}\\n\\n\\n\\n.unit-app-rating {\\n  display: flex;\\n  flex-direction: row;\\n  align-content: center;\\n}\\n\\n.unit-prices {\\n  display: var(--display-price, inline);\\n  white-space: nowrap;\\n  font-size: var(--font-size-price);\\n  line-height: var(--line-height-price);\\n}\\n\\n.ya-unit-price {\\n  color: var(--color-text-price);\\n  font-weight: 600;\\n  display: inline;\\n  white-space: nowrap;\\n}\\n\\n.ya-unit-old-price {\\n  margin-left: 8px;\\n  font-size: max(0.9em, 12px);\\n  line-height: max(0.9em, 12px);\\n  color: var(--color-grey-alt);\\n\\n  position: relative;\\n  white-space: nowrap;\\n  display: inline;\\n}\\n\\n.ya-unit-old-price::after {\\n  content: \\\"\\\";\\n  position: absolute;\\n  bottom: 0;\\n  left: 0;\\n  width: 100%;\\n  height: 100%;\\n  \\n  background-image: url(\\\"data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='100%' height='100%'><line class='line' x1='0' y1='65%' x2='100%' y2='50%' stroke='%23A3ACBF' stroke-width='8vh' /></svg>\\\");\\n  background-repeat: no-repeat;\\n}\\n\\n.ya-unit-review-count {\\n  transform: translateY(1px);\\n  color: var(--color-grey-alt);\\n  font-size: 13px;\\n  line-height: var(--line-height-domain);\\n}\\n\\n.unit-desc {\\n  display: var(--display-desc);\\n  color: var(--color-text-desc);\\n  font-size: var(--font-size-desc);\\n  line-height: var(--line-height-desc);\\n}\\n\\n\\n\\n.unit-image-block {\\n  display: var(--display-image);\\n  width: 100%;\\n  max-width: var(--image-max-width, none);\\n  height: var(--image-height);\\n  flex: none;\\n  border-radius: 0 var(--banner-inner-border-radius) var(--banner-inner-border-radius) 0;\\n  position: relative;\\n\\n  box-sizing: border-box;\\n  padding-right: var(--banner-padding-outer);\\n  background-color: var(--color-light-alt);\\n  overflow: hidden;\\n}\\n\\n.unit-image {\\n  width: 100%;\\n  height: 100%;\\n  display: var(--display-image);\\n  position: relative;\\n}\\n\\n.video-source-container {\\n  border-radius: 0 var(--banner-inner-border-radius) var(--banner-inner-border-radius) 0;\\n  z-index: 1;\\n  overflow: hidden;\\n}\\n\\n.unit-rmp-content .unit-image-block {\\n  overflow: visible;\\n}\\n\\n.unit-rmp-content .unit-image-block {\\n  margin-bottom: 16px;\\n}\\n\\n.ya-unit-app-icon {\\n  width: 100%;\\n  height: 100%;\\n  position: relative;\\n  display: flex;\\n}\\n\\n.unit-app-icon {\\n  margin: auto;\\n}\\n\\n.ya-unit-app-icon .yrw-img-component {\\n  width: var(--app-icon-size);\\n  height: var(--app-icon-size);\\n}\\n\\n.ya-unit-image {\\n  height: 100%;\\n}\\n\\n.yrw-img-component {\\n  height: 100%;\\n  padding-bottom: 0;\\n}\\n\\n.unit-image .img-source-component {\\n  border-radius: 0 var(--banner-inner-border-radius) var(--banner-inner-border-radius) 0;\\n  background-image: url(\\\"data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='256' height='256'><rect x='80' y='80' width='96' height='96' rx='19.2' fill='%23405580' fill-opacity='0.15'/><path d='M144.619 110.181H147.619C147.619 108.524 146.276 107.181 144.619 107.181V110.181ZM111.102 147.94L146.74 112.302L142.498 108.06L106.86 143.698L111.102 147.94ZM114.072 113.181H144.619V107.181L114.072 107.181V113.181ZM141.619 110.181V140.728H147.619V110.181L141.619 110.181Z' fill='white'/></svg>\\\");\\n  background-position: center;\\n}\\n\\n.ya-unit-app-icon .img-source-component {\\n  border-radius: calc(var(--app-icon-size) / 4 - 4px);\\n}\\n\\n.ya-clamp {\\n  width: 100%;\\n}\\n\\n.yrw-content {\\n  overflow: visible;\\n}\\n\\n.ya-grid-template:empty {\\n  display: none;\\n}\",\"gridColumns\":\"1\",\"gridRows\":\"1\",\"defaultHeight\":\"100\"},{\"value\":\"custom2\",\"props\":{},\"label\":\"Мобильный сингл 100% x 300px\",\"template\":\"<ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n\\n  <div class=\\\"unit-misc\\\">\\n    <ya-unit-kebab class=\\\"ya-unit-kebab_dark\\\" />\\n    <div class=\\\"unit-meta\\\">\\n      <ya-unit-category class=\\\"unit-category\\\" />\\n      <ya-unit-age class=\\\"unit-age\\\" />\\n    </div>\\n  </div>\\n\\n\\n\\n  <div class=\\\"unit-content\\\">\\n    <div class=\\\"unit-image-block\\\">\\n      <ya-unit-image/>\\n    </div>\\n\\n    <div class=\\\"unit-text-content\\\" data-cols=\\\"1\\\" data-rows=\\\"1\\\">\\n\\n      <div class=\\\"unit-title\\\">\\n        <ya-unit-if condition=\\\"unit.title < 22\\\">\\n          <ya-clamp lines=\\\"3\\\" class=\\\"title-short\\\"><ya-unit-title /></ya-clamp>\\n        </ya-unit-if>\\n\\n        <ya-unit-if condition=\\\"unit.title > 21 & unit.title < 33\\\">\\n          <ya-clamp lines=\\\"3\\\" class=\\\"title-mid\\\"><ya-unit-title /></ya-clamp>\\n        </ya-unit-if>\\n\\n        <ya-unit-if condition=\\\"unit.title > 32\\\">\\n          <ya-clamp lines=\\\"3\\\" class=\\\"title-long\\\"><ya-unit-title /></ya-clamp>\\n        </ya-unit-if>\\n      </div>\\n\\n      <!-- Начало Шаблона ТГО -->\\n      <ya-unit-if condition=\\\"!unit.isRmp\\\">\\n        <div class=\\\"unit-prices\\\"><ya-unit-price /><ya-unit-old-price /></div>\\n        <ya-clamp lines=\\\"2\\\" class=\\\"unit-desc\\\"><ya-unit-desc /></ya-clamp>\\n      </ya-unit-if>\\n      <!-- Конец Шаблона ТГО -->\\n\\n\\n    \\n      <!-- Начало Шаблона РМП -->\\n      <ya-unit-if condition=\\\"unit.isRmp\\\">\\n        <div class=\\\"rmp-app-content\\\">\\n          <ya-unit-app-icon />\\n\\n          <div class=\\\"rmp-text-content\\\">\\n\\n            <div class=\\\"unit-app-name\\\">\\n              <ya-clamp lines=\\\"2\\\">\\n                <ya-unit-app-name />\\n              </ya-clamp>\\n            </div>\\n\\n            <div class=\\\"unit-app-rating\\\">\\n              <ya-unit-rating />\\n              <ya-unit-review-count />\\n            </div>\\n          </div>\\n\\n        </div>\\n\\n      </ya-unit-if>\\n      <!-- Конец Шаблона РМП -->\\n\\n    </div>\\n\\n    <div class=\\\"unit-cta\\\">\\n      <div class=\\\"unit-domain\\\">\\n        <ya-unit-mobile-app-button />\\n        <ya-unit-if condition=\\\"!unit.isRmp\\\">\\n          <span class=\\\"unit-domain-no-wrap\\\">\\n            <span class=\\\"unit-favicon\\\"><ya-unit-favicon size=\\\"32\\\"/></span>\\n            <ya-unit-domain class=\\\"domain\\\"/>\\n          </span>\\n        </ya-unit-if>\\n        \\n      </div>\\n    </div>\\n\\n  </div>\\n\\n</ya-units-grid>\",\"css\":\"/* Шаблон 2: Мобильный сингл размером 100% x 300px \\n   Для использования внутри контента */\\n\\n\\n/* Шаблоны не работают в браузерах IE 11 версии и ниже */\\n\\n/* РМП — Реклама Мобильных Приложений */\\n\\n\\n/* -------- Переменные цветов -------- */\\n/* Изменив значение цвета в переменной, оно одновременно\\n   изменится во всех элементах шаблона, где указано */\\n.ya-container {\\n\\n  --color-blue: #3377FF;\\n  --color-blue-dark: #0055FF;\\n\\n  --color-blue-transparent: #3377FF1A;\\n  --color-blue-dark-transparent: #0055FF1A;\\n\\n  --color-black: #232526;\\n  --color-grey: #575c66;\\n  --color-grey-alt: #A3ACBF;\\n  --color-light: #f4f4f6;\\n  --color-light-alt: #ececef;\\n}\\n\\n/* Переменные цветов для устройств с поддержкой \\n   цветового профиля Display P3 (устройства Apple) */\\n\\n/* Устройства Apple поддерживают цветовой профиль \\n   с более яркими цветами (цветовой профиль Display P3). \\n   Если вы хотите поддержать его, то следует поменять \\n   значения цветов в блоке ниже */\\n@supports (color: color(display-p3)) {\\n  .ya-container {\\n    --color-blue: color(display-p3 0.2 0.47 1.0);\\n    --color-blue-dark: color(display-p3 0.0 0.33 1.0);\\n\\n    --color-blue-transparent: color(display-p3 0.2 0.47 1.0 / 0.1);\\n    --color-blue-dark-transparent: color(display-p3 0.0 0.33 1.0 / 0.1);\\n\\n    --color-yellow: color(display-p3 1.0 0.8 0.2);\\n    --color-yellow-dark: color(display-p3 1.0 0.75 0.0);\\n  }\\n}\\n\\n\\n\\n/* -------- Переменные для отрисовки объявления -------- */\\n\\n.ya-container {\\n\\n  /* Адаптивность объявления по ширине.\\n     Укажите значение none, чтобы зафиксировать размер объявления.\\n     Укажите auto, чтобы объявление занимало всю доступную ширину */\\n  --banner-flex: auto;\\n\\n  /* Фиксированная ширина объявления.\\n     Работает при --banner-flex: none */\\n  --banner-width: 300px;\\n\\n  /* Минимальная и максимальная ширина объявления.\\n     Работает при --banner-flex: auto */\\n  --banner-min-width: 320px;\\n  --banner-max-width: 540px;\\n\\n  /* Минимальная и максимальная высота объявления.\\n     Объявление будет растягиваться по высоте \\n     в зависимости от количества контента */\\n  --banner-min-height: 300px;\\n  --banner-max-height: none;\\n\\n\\n  /* Отображение фавиконки: \\n     вкл - block, выкл - none; */\\n  --display-favicon: block;\\n  /* Отображение изображения: \\n     вкл - block, выкл - none; */\\n  --display-image: block;\\n  /* Отображение текста: \\n     вкл - block, выкл - none; */\\n  --display-desc: inline;\\n  /* Отображение цен: \\n     вкл - inline, выкл - none */\\n  --display-price: inline;\\n  /* Отображение количества отзывов (для РМП): \\n     вкл - inline, выкл - none */\\n  --display-rmp-rating-count: inline;\\n\\n\\n  /* Максимальная ширина картинки */\\n  --image-max-width: 100%;\\n\\n  /* Высота картинки */\\n  --image-height: 160px;\\n\\n  /* Размер иконки приложения.\\n     Только для рекламы мобильных приложений */\\n  --app-icon-size: 48px;\\n\\n  /* Горизонтальное позиционирование сетки баннеров\\n     center - по середине, flex-start - слева,\\n     space-between - по всей ширине, space-around - по всей ширине с отступами\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/justify-content */\\n  --banners-justify-content: center;\\n\\n  /* Отступы вокруг объявления */\\n  --banner-margin: 8px 0;\\n\\n  /* Отступы первых и последних объявлений от края \\n     по горизонтали и вертикали. Значение var(--banner-margin) \\n     повторяет общее значение отступов. \\n     ! Неприменимо для одиночных объявлений */\\n  --banners-grid-first-item-top-margin: 0;\\n  --banners-grid-first-item-left-margin: 0;\\n  --banners-grid-first-item-right-margin: 0;\\n  --banners-grid-first-item-bottom-margin: 0;\\n\\n  /* Цвет фона объявления. Пример: white или #f0f2f8;\\n     Допустимо использование переменных. См. начало документа */\\n  --banner-background: var(--color-light);\\n  /* Цвет фона при наведении на объявление */\\n  --banner-background-hover: var(--color-light);\\n\\n  /* Обводка объявления. Для отключения укажите значение none\\n     Пример: solid 1px rgba(0 0 0 / 15%);\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/border */\\n  --banner-stroke: none;\\n  \\n  /* Тень объявления. Пример: 0px 8px 24px rgba(0, 21, 64, 0.125);\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/box-shadow */\\n  --banner-shadow: none;\\n  /* Тень объявления при наведении */\\n  --banner-shadow-hover: none;\\n  /* Трансформация объявления при наведении. Пример: translateY(-2px); */\\n  --banner-transform-hover: none;\\n  /* Анимация изменений при наведении */\\n  --banner-transition: box-shadow 120ms ease, transform 120ms ease;\\n\\n  /* Скругление углов объявления */\\n  --banner-outer-border-radius: 0px;\\n  /* Скругление углов внутренних элементов объявления (картинка, кнопки) */\\n  --banner-inner-border-radius: 8px;\\n  \\n  /* Отступы элементов от краев объявления */\\n  --banner-padding-outer: 10px;\\n  /* Отступы между элементами объявления */\\n  --banner-padding-inner: 10px;\\n\\n\\n  /* Цвет заголовка в объявлении */\\n  --color-text-header: var(--color-black); \\n  /* Цвет текста в объявлении */\\n  --color-text-desc: var(--color-grey-alt);\\n  /* Цвет цены в объявлении */\\n  --color-text-price: var(--color-black);\\n  /* Цвет ссылки в объявлении */\\n  --color-text-domain: var(--color-blue);\\n  /* Цвет ссылки в объявлении при наведении */\\n  --color-text-domain-hover: var(--color-blue-dark);\\n  /* Фон кнопки действия. Не применимо, если кнопка \\n     не предусмотрена в шаблоне (для форматов маленького размера) */\\n  --color-background-domain: var(--color-blue-transparent);\\n  /* Фон кнопки действия при наведении */\\n  --color-background-domain-hover: var(--color-blue-dark-transparent);\\n\\n  /* Цвет названия приложения в объявления (для РМП) */\\n  --color-text-app-name: var(--color-grey-alt);\\n\\n\\n  /* Цепочка используемых шрифтов в объявлении. По умолчанию указана \\n     цепочка системных шрифтов. Если шрифт не поддерживается, используется \\n     следующий по цепочке. При использовании собственного шрифта, \\n     следует указывать его название в самом начале */\\n  --font-family: \\n    -apple-system, BlinkMacSystemFont, \\\"Segoe UI\\\", Roboto, \\n    Oxygen, Ubuntu, Cantarell, \\\"Open Sans\\\", \\\"Helvetica Neue\\\", sans-serif, \\n    Apple Color Emoji, Segoe UI Emoji;\\n\\n  /* Размер шрифта и межстрочное расстояние для коротких заголовков\\n     (до 21 символа) */\\n  --font-size-title-short: 24px;\\n  --line-height-title-short: calc(1em + 0px);\\n\\n  /* Размер шрифта и межстрочное расстояние для заголовков средней длины \\n     (от 22 до 31 символа) */\\n  --font-size-title-mid: 20px;\\n  --line-height-title-mid: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для длинных заголовков \\n     (от 32 символов) */\\n  --font-size-title-long: 20px;\\n  --line-height-title-long: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для заголовков РМП */\\n  --font-size-title-rmp: 20px;\\n  --line-height-title-rmp: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для цен */\\n  --font-size-price: 16px;\\n  --line-height-price: calc(1em + 4px);\\n\\n  /* Размер шрифта и межстрочное расстояние для текста объявления */\\n  --font-size-desc: 15px;\\n  --line-height-desc: calc(1em + 3px);\\n\\n  /* Размер шрифта и межстрочное расстояние для ссылки */\\n  --font-size-domain: 15px;\\n  --line-height-domain: 20px;\\n\\n  /* Размер шрифта и межстрочное расстояние для названия приложения \\n     (для РМП) */\\n  --font-size-app-name: 15px;\\n  --line-height-app-name: calc(1em + 3px);\\n  \\n\\n  width: 100%;\\n  margin: 0 auto;\\n\\n  height: auto;\\n  padding: 0;\\n  overflow: visible;\\n}\\n\\n/* Специальные переменные для Рекламы Мобильных Приложений */\\n.ya-unit-item-rmp {\\n  /* Цвет текста ссылки */\\n  --color-text-domain: var(--color-blue);\\n  /* Цвет текста ссылки при наведении */\\n  --color-text-domain-hover: var(--color-blue-dark);\\n  /* Цвет фона кнопки объявления.\\n     Не применимо если, кнопки не предусмотрено (для маленьких форматов) */\\n  --color-background-domain: var(--color-blue-transparent);\\n  /* Цвет фона кнопки объявления при наведении */\\n  --color-background-domain-hover: var(--color-blue-dark-transparent);\\n}\\n\\n/* Специальные значения для размеров экрана шире 360px */\\n@media screen and (min-width: 360px) {\\n\\n  .ya-container {\\n    --image-height: 200px;\\n\\n    --app-icon-size: 64px;\\n\\n    --font-size-title: 18px;\\n    --line-height-title: calc(1em + 2px);\\n\\n    --font-size-title-short: 28px;\\n    --line-height-title-short: calc(1em + 0px);\\n  \\n    --font-size-title-mid: 24px;\\n    --line-height-title-mid: calc(1em + 2px);\\n  \\n    --font-size-title-long: 22px;\\n    --line-height-title-long: calc(1em + 2px);\\n\\n    --font-size-price: 20px;\\n    --line-height-price: calc(1em + 0px);\\n\\n    --font-size-desc: 16px;\\n    --line-height-desc: calc(1em + 4px);\\n\\n    --font-size-app-name: 18px;\\n    --line-height-app-name: calc(1em + 2px);\\n\\n    --font-size-domain: 16px;\\n    --line-height-domain: 20px;\\n\\n    --banner-padding-outer: 12px;\\n    --banner-padding-inner: 12px;\\n  }\\n}\\n\\n/* Специальные значения для размеров экрана шире 420px */\\n@media screen and (min-width: 420px) {\\n  .ya-container {\\n    --image-height: 240px;\\n\\n    --font-size-title: 18px;\\n    --line-height-title: calc(1em + 2px);\\n\\n    --font-size-title-short: 32px;\\n    --line-height-title-short: calc(1em + 0px);\\n\\n    --font-size-title-mid: 26px;\\n    --line-height-title-mid: calc(1em + 2px);\\n\\n    --font-size-title-long: 24px;\\n    --line-height-title-long: calc(1em + 2px);\\n\\n    --font-size-desc: 16px;\\n    --line-height-desc: calc(1em + 4px);\\n\\n    --font-size-app-name: 20px;\\n    --line-height-app-name: calc(1em + 2px);\\n\\n    --font-size-domain: 16px;\\n  }\\n}\\n\\n\\n\\n\\n/* -------- Далее — настройка стилей объявления. -------- */\\n/* -------- Не рекомендуется редактировать -------- */\\n\\n.ya-units-grid {\\n  margin: 0px auto;\\n}\\n\\n.grid-row {\\n  justify-content: var(--banners-justify-content);\\n  align-content: var(--banners-align-content);\\n  padding: 0px 0;\\n}\\n\\n.grid-item {\\n  width: var(--banner-width);\\n  min-width: var(--banner-min-width);\\n  max-width: var(--banner-max-width);\\n  \\n  min-height: var(--banner-min-height);\\n  max-height: var(--banner-max-height);\\n\\n  font-family: var(--font-family);\\n  background: var(--banner-background);\\n  border: var(--banner-stroke);\\n\\n  margin: var(--banner-margin, inherit);\\n  border-radius: var(--banner-outer-border-radius);\\n  overflow: hidden;\\n  box-sizing: border-box;\\n  flex: var(--banner-flex);\\n  box-shadow: var(--banner-shadow);\\n  transform: none;\\n  transition: var(--banner-transition);\\n}\\n\\n.grid-item:hover {\\n  transform: var(--banner-transform-hover);\\n  box-shadow: var(--banner-shadow-hover);\\n  background: var(--banner-background-hover);\\n  --color-text-domain: var(--color-text-domain-hover);\\n}\\n\\n.grid-item:first-child {\\n  margin-left: var(--banners-grid-first-item-left-margin);\\n}\\n\\n.grid-item:last-child {\\n  margin-right: var(--banners-grid-first-item-right-margin);\\n}\\n\\n.grid-row:first-child .grid-item {\\n  margin-top: var(--banners-grid-first-item-top-margin);\\n}\\n\\n.grid-row:last-child .grid-item {\\n  margin-bottom: var(--banners-grid-first-item-bottom-margin);\\n}\\n\\n.unit-wrapper {\\n  height: 100%;\\n}\\n\\n.ya-unit-favicon {\\n  display: block !important;\\n}\\n\\na.yrw-url {\\n  color: inherit;\\n  cursor: pointer;\\n}\\n\\n.unit-misc {\\n  position: absolute;\\n  top: 0;\\n  left: 0;\\n  width: 100%;\\n  height: 100%;\\n}\\n\\n.unit-meta {\\n  position: absolute;\\n  top: 10px;\\n  left: var(--banner-padding-outer);\\n  z-index: 2;\\n  padding: 0px 4px 0px;\\n  text-transform: uppercase;\\n  height: 12px;\\n  background: transparent;\\n  color: var(--color-grey);\\n  border-radius: 4px;\\n  font-size: 8px;\\n  line-height: 13px;\\n  font-weight: 500;\\n  letter-spacing: 0.12em;\\n  vertical-align: 5px;\\n  margin: 0;\\n  user-select: none;\\n  -ms-user-select: none;\\n  -moz-user-select: none;\\n  -khtml-user-select: none;\\n  -webkit-user-select: none;\\n}\\n\\n.ya-unit-item-rmp .unit-meta {\\n  background: transparent;\\n}\\n\\n.unit-age::before {\\n  content: \\\" | \\\";\\n}\\n\\n.unit-age:empty {\\n  display: none;\\n}\\n\\n.ya-unit-kebab_button svg circle {\\n  fill: var(--color-grey);\\n}\\n\\n.ya-unit-kebab_bg {\\n  background: transparent;\\n  opacity: 1.0;\\n}\\n\\n.ya-unit-kebab_icon {\\n  filter: var(--display-image, none);\\n}\\n\\n.ya-unit-kebab_icon circle {\\n  fill: var(--color-grey) !important;\\n}\\n\\n.ya-unit-kebab_button {\\n  position: absolute;\\n  z-index: 940;\\n  top: 4px;\\n  right: 4px;\\n  width: 24px;\\n  height: 24px;\\n}\\n\\n.yrw-body_warning {\\n  position: relative;\\n}\\n\\n.yrw-body_warning div {\\n  padding: 0;\\n}\\n\\n.yrw-body_warning div:not(.yrw-warning-wrapper):not(.yrw-warning-text) {\\n  position: relative;\\n  background-color: var(--color-light-alt);\\n  color: #575c66;\\n  display: flex;\\n  padding: 0 calc(var(--inner-border-radius) / 2);\\n}\\n\\n.yrw-body_warning div text {\\n  fill: #575c66;\\n}\\n\\n.yrw-body_warning div:not(.yrw-warning-wrapper) {\\n  padding: 0 calc(var(--inner-border-radius) / 2 + 4px);\\n}\\n\\n.yrw-warning-text {\\n  text-shadow: none;\\n}\\n\\n\\n\\n.unit-container {\\n  box-sizing: border-box;\\n  position: relative;\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: flex-end;\\n  overflow: hidden;\\n  max-width: var(--max-content-width, --banner-max-width, 960px);\\n  margin: auto;\\n}\\n\\n.unit-content {\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: flex-start;\\n  position: relative;\\n  height: 100%;\\n\\n  padding: 8px;\\n  padding: var(--banner-padding-outer);\\n  padding-top: 32px;\\n}\\n\\n.unit-text-content {\\n  display: flex;\\n  justify-content: flex-start;\\n  flex-direction: column;\\n  position: relative;\\n  flex: auto;\\n}\\n\\n.rmp-app-content {\\n  display: flex;\\n  flex-direction: row;\\n}\\n\\n.rmp-text-content {\\n  display: flex;\\n  justify-content: center;\\n  flex-direction: column;\\n}\\n\\n.unit-text-content > div {\\n  margin-top: var(--banner-padding-inner);\\n}\\n\\n.rmp-text-content > div {\\n  margin-top: calc(var(--banner-padding-inner) / 2);\\n}\\n\\n.rmp-text-content > div:first-child {\\n  margin-top: 0;\\n}\\n\\n\\n\\n.ya-unit-title, .unit-title {\\n  color: var(--color-text-header);\\n  font-size: var(--font-size-title);\\n  line-height: var(--line-height-title);\\n  font-weight: 600;\\n  display: flex;\\n}\\n\\n.title-short {\\n  font-size: var(--font-size-title-short);\\n  line-height: var(--line-height-title-short);\\n}\\n\\n.title-mid {\\n  font-size: var(--font-size-title-mid);\\n  line-height: var(--line-height-title-mid);\\n}\\n\\n.title-long {\\n  font-size: var(--font-size-title-long);\\n  line-height: var(--line-height-title-long);\\n}\\n\\n.title-rmp {\\n  font-size: var(--font-size-title-rmp);\\n  line-height: var(--line-height-title-rmp);\\n\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: center;\\n}\\n\\n.unit-app-name {\\n  font-size: var(--font-size-app-name);\\n  line-height: var(--line-height-app-name);\\n  color: var(--color-text-app-name);\\n}\\n\\n\\n.unit-cta {\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: center;\\n\\n  box-sizing: border-box;\\n  padding: 12px;\\n\\n  font-size: var(--domain-font-size);\\n  line-height: var(--domain-line-height);\\n  text-align: center;\\n\\n  color: var(--color-cta-color);\\n  background-color: var(--color-background-domain);\\n  border-radius: var(--banner-inner-border-radius);\\n  margin-top: var(--banner-padding-inner);\\n  transition: var(--cta-transition);\\n}\\n\\n.unit-cta:hover {\\n  color: var(--color-cta-hover-color);\\n  background-color: var(--color-background-domain-hover);\\n}\\n\\n\\n.unit-favicon {\\n  width: var(--line-height-domain);\\n  background-color: transparent;\\n  border-radius: 3px;\\n  align-self: center;\\n  display: var(--display-favicon, inline);\\n}\\n\\n.ya-unit-favicon {\\n  width: var(--line-height-domain);\\n  height: var(--line-height-domain);\\n}\\n\\n.ya-unit-rating {\\n  margin-right: 4px;\\n  height: 16px;\\n  display: inline;\\n}\\n\\n.ya-unit-review-count {\\n  display: var(--display-rmp-rating-count);\\n  transform: translateY(1px);\\n  color: var(--color-grey-alt);\\n  font-size: 13px;\\n  line-height: 16px;\\n}\\n\\n.unit-favicon:empty,\\n.ya-unit-domain:empty,\\n.unit-domain:empty {\\n  display: none;\\n}\\n\\n.unit-domain {\\n  display: flex;\\n  margin-right: auto;\\n  border-radius: 4px;\\n\\n  color: var(--color-text-domain);\\n  font-size: var(--font-size-domain);\\n  line-height: var(--line-height-domain);\\n  padding: 0;\\n\\n  width: 100%;\\n  height: var(--line-height-domain, 16px);\\n\\n  flex-direction: row;\\n  flex-wrap: wrap;\\n  justify-content: center;\\n  align-content: flex-end;\\n\\n  overflow: hidden;\\n}\\n\\n.unit-domain > *,\\n.unit-domain .unit-domain-no-wrap > * {\\n  margin-right: calc(var(--line-height-domain) / 3.5);\\n}\\n\\n.unit-domain span {\\n  flex: none;\\n}\\n\\n.unit-domain-no-wrap {\\n  display: flex;\\n}\\n\\n\\n\\n.unit-app-rating {\\n  display: flex;\\n  flex-direction: row;\\n  align-content: center;\\n}\\n\\n.unit-prices {\\n  display: var(--display-price, inline);\\n  white-space: nowrap;\\n\\n  font-size: var(--font-size-price);\\n  line-height: var(--line-height-price);\\n}\\n\\n.ya-unit-price {\\n  color: var(--color-text-price);\\n  font-weight: 600;\\n\\n  display: inline;\\n  white-space: nowrap;\\n}\\n\\n.ya-unit-old-price {\\n  margin-left: 8px;\\n  font-size: max(0.9em, 12px);\\n  line-height: max(0.9em, 12px);\\n  color: var(--color-grey-alt);\\n\\n  position: relative;\\n  white-space: nowrap;\\n  display: inline;\\n}\\n\\n.ya-unit-old-price::after {\\n  content: \\\"\\\";\\n  position: absolute;\\n  bottom: 0;\\n  left: 0;\\n  width: 100%;\\n  height: 100%;\\n  \\n  background-image: url(\\\"data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='100%' height='100%'><line class='line' x1='0' y1='65%' x2='100%' y2='50%' stroke='%23A3ACBF' stroke-width='8vh' /></svg>\\\");\\n  background-repeat: no-repeat;\\n}\\n\\n.unit-desc {\\n  display: var(--display-desc);\\n  color: var(--color-text-desc);\\n  font-size: var(--font-size-desc);\\n  line-height: var(--line-height-desc);\\n}\\n\\n\\n\\n.unit-image-block {\\n  display: var(--display-image);\\n  width: 100%;\\n  max-width: var(--image-max-width, none);\\n  height: var(--image-height);\\n  flex: none;\\n  border-radius: var(--banner-inner-border-radius);\\n  position: relative;\\n\\n  box-sizing: border-box;\\n  background-color: var(--color-light-alt);\\n  overflow: hidden;\\n}\\n\\n.unit-image {\\n  width: 100%;\\n  height: 100%;\\n  display: var(--display-image);\\n  position: relative;\\n}\\n\\n.video-source-container {\\n  border-radius: var(--banner-inner-border-radius, 8px);\\n  z-index: 1;\\n  overflow: hidden;\\n}\\n\\n.ya-unit-app-icon {\\n  position: relative;\\n\\n  border-radius: calc(var(--app-icon-size) / 4);\\n  margin-right: var(--banner-padding-inner);\\n  display: flex;\\n}\\n\\n.unit-app-icon {\\n  margin: auto;\\n}\\n\\n.ya-unit-app-icon .yrw-img-component {\\n  width: var(--app-icon-size);\\n  height: var(--app-icon-size);\\n}\\n\\n.ya-unit-image {\\n  height: 100%;\\n}\\n\\n.yrw-img-component {\\n  height: 100%;\\n  padding-bottom: 0;\\n}\\n\\n.unit-image .img-source-component {\\n  border-radius: var(--banner-inner-border-radius);\\n  background-image: url(\\\"data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='256' height='256'><rect x='80' y='80' width='96' height='96' rx='19.2' fill='%23405580' fill-opacity='0.15'/><path d='M144.619 110.181H147.619C147.619 108.524 146.276 107.181 144.619 107.181V110.181ZM111.102 147.94L146.74 112.302L142.498 108.06L106.86 143.698L111.102 147.94ZM114.072 113.181H144.619V107.181L114.072 107.181V113.181ZM141.619 110.181V140.728H147.619V110.181L141.619 110.181Z' fill='white'/></svg>\\\");\\n  background-position: center;\\n}\\n\\n.ya-unit-app-icon .img-source-component {\\n  border-radius: calc(var(--app-icon-size) / 4 - 4px);\\n}\\n\\n.ya-clamp {\\n  width: 100%;\\n}\\n\\n.yrw-content {\\n  overflow: visible;\\n}\\n\\n.ya-grid-template:empty {\\n  display: none;\\n}\",\"gridColumns\":\"1\",\"gridRows\":\"1\",\"defaultWidth\":\"500\",\"defaultHeight\":\"450\"},{\"value\":\"6\",\"name\":\"grid\",\"props\":{},\"label\":\"Универсальный слайдер 100% x auto\",\"template\":\"<ya-units-slider>\\n\\n  <div class=\\\"unit-misc\\\">\\n    <ya-unit-kebab class=\\\"ya-unit-kebab_dark\\\" />\\n    <div class=\\\"unit-meta\\\">\\n      <ya-unit-category class=\\\"unit-category\\\" />\\n      <ya-unit-age class=\\\"unit-age\\\" />\\n    </div>\\n  </div>\\n\\n\\n\\n  <div class=\\\"unit-content\\\">\\n\\n    <div class=\\\"unit-image-block\\\">\\n      <ya-unit-image/>\\n    </div>\\n\\n    <div class=\\\"unit-text-content\\\" data-cols=\\\"1\\\" data-rows=\\\"1\\\">\\n\\n      <div class=\\\"unit-title\\\">\\n        <ya-unit-if condition=\\\"unit.title < 22\\\">\\n          <ya-clamp lines=\\\"3\\\" class=\\\"title-short\\\"><ya-unit-title /></ya-clamp>\\n        </ya-unit-if>\\n\\n        <ya-unit-if condition=\\\"unit.title > 21 & unit.title < 33\\\">\\n          <ya-clamp lines=\\\"3\\\" class=\\\"title-mid\\\"><ya-unit-title /></ya-clamp>\\n        </ya-unit-if>\\n\\n        <ya-unit-if condition=\\\"unit.title > 32\\\">\\n          <ya-clamp lines=\\\"3\\\" class=\\\"title-long\\\"><ya-unit-title /></ya-clamp>\\n        </ya-unit-if>\\n      </div>\\n\\n      <!-- Начало Шаблона ТГО -->\\n      <ya-unit-if condition=\\\"!unit.isRmp\\\">\\n\\n        <div class=\\\"unit-prices\\\"><ya-unit-price /><ya-unit-old-price /></div>\\n  \\n        <ya-clamp lines=\\\"4\\\" class=\\\"unit-desc\\\"><ya-unit-desc /></ya-clamp>\\n\\n\\n      </ya-unit-if>\\n      <!-- Конец Шаблона ТГО -->\\n\\n\\n    \\n      <!-- Начало Шаблона РМП -->\\n      <ya-unit-if condition=\\\"unit.isRmp\\\">\\n\\n        <!-- <div class=\\\"unit-title\\\">\\n          <span class=\\\"title-rmp\\\">\\n            <ya-clamp lines=\\\"2\\\"><ya-unit-title /></ya-clamp>\\n          </span>\\n        </div> -->\\n\\n        <div class=\\\"rmp-app-content\\\">\\n          <ya-unit-app-icon />\\n\\n          <div class=\\\"rmp-text-content\\\">\\n\\n            <div class=\\\"unit-app-name\\\">\\n              <ya-clamp lines=\\\"2\\\">\\n                <ya-unit-app-name />\\n              </ya-clamp>\\n            </div>\\n\\n            <div class=\\\"unit-app-rating\\\">\\n              <ya-unit-rating />\\n              <ya-unit-review-count />\\n            </div>\\n          </div>\\n\\n        </div>\\n\\n      </ya-unit-if>\\n      <!-- Конец Шаблона РМП -->\\n\\n    </div>\\n\\n    <div class=\\\"unit-cta\\\">\\n      <div class=\\\"unit-domain\\\">\\n        <ya-unit-mobile-app-button />\\n        <ya-unit-if condition=\\\"!unit.isRmp\\\">\\n          <span class=\\\"unit-domain-no-wrap\\\">\\n            <span class=\\\"unit-favicon\\\"><ya-unit-favicon size=\\\"32\\\"/></span>\\n            <ya-unit-domain class=\\\"domain\\\"/>\\n          </span>\\n        </ya-unit-if>\\n        \\n      </div>\\n    </div>\\n\\n  </div>\\n\\n</ya-units-slider>\",\"css\":\"/* Шаблон 3: Универсальный слайдер размером 100% x Auto (min: 240px)\\n   Размер блока по ширине: 80%.\\n   Для использования внутри контента.\\n   \\n   Подходит для использования на сайтах, использующих \\n   единую верстку для мобильных устройств и десктопов */\\n\\n\\n/* Шаблоны не работают в браузерах IE 11 версии и ниже */\\n\\n/* РМП — Реклама Мобильных Приложений */\\n\\n\\n/* -------- Переменные цветов -------- */\\n/* изменив значение цвета тут — изменится во всех элементах шаблона */\\n.ya-container {\\n\\n  --color-blue: #3377FF;\\n  --color-blue-dark: #0055FF;\\n\\n  --color-blue-transparent: #3377FF1A;\\n  --color-blue-dark-transparent: #0055FF1A;\\n\\n  --color-yellow: #FFCC33;\\n  --color-yellow-dark: #FFBF00;\\n\\n  --color-black: #232526;\\n  --color-grey: #575c66;\\n  --color-grey-alt: #A3ACBF;\\n  --color-light: #f4f4f6;\\n  --color-light-alt: #ececef;\\n}\\n\\n/* Переменные цветов для устройств с поддержкой \\n   цветового профиля Display P3 (устройства Apple) */\\n\\n/* Устройства Apple поддерживают цветовой профиль \\n   с более яркими цветами (цветовой профиль Display P3). \\n   Если вы хотите поддержать его, то следует поменять \\n   значения цветов в блоке ниже */\\n@supports (color: color(display-p3)) {\\n  .ya-container {\\n    --color-blue: color(display-p3 0.2 0.47 1.0);\\n    --color-blue-dark: color(display-p3 0.0 0.33 1.0);\\n\\n    --color-blue-transparent: color(display-p3 0.2 0.47 1.0 / 0.1);\\n    --color-blue-dark-transparent: color(display-p3 0.0 0.33 1.0 / 0.1);\\n\\n    --color-yellow: color(display-p3 1.0 0.8 0.2);\\n    --color-yellow-dark: color(display-p3 1.0 0.75 0.0);\\n  }\\n}\\n\\n\\n\\n/* -------- Переменные для отрисовки объявления -------- */\\n\\n.ya-container {\\n\\n  /* Адаптивность объявления по ширине.\\n     Укажите значение none, чтобы зафиксировать размер объявления.\\n     Укажите auto, чтобы объявление занимало всю доступную ширину */\\n  --banner-flex: none;\\n\\n  /* Фиксированная ширина объявления.\\n     Работает при --banner-flex: none */\\n  --banner-width: 80%;\\n\\n  /* Минимальная и максимальная ширина объявления.\\n     Работает при --banner-flex: auto */\\n  --banner-min-width: 200px;\\n  --banner-max-width: 320px;\\n\\n  /* Минимальная и максимальная высота объявления.\\n     Объявление будет растягиваться по высоте \\n     в зависимости от количества контента */\\n  --banner-min-height: 240px;\\n  --banner-max-height: none;\\n\\n\\n  /* Отображение фавиконки: \\n     вкл - block, выкл - none; */\\n  --display-favicon: block;\\n  /* Отображение изображения: \\n     вкл - block, выкл - none; */\\n  --display-image: block;\\n  /* Отображение текста: \\n     вкл - block, выкл - none; */\\n  --display-desc: inline;\\n  /* Отображение цен: \\n     вкл - inline, выкл - none */\\n  --display-price: inline;\\n  /* Отображение количества отзывов (для РМП): \\n     вкл - inline, выкл - none */\\n  --display-rmp-rating-count: inline;\\n\\n\\n  /* Максимальная ширина картинки */\\n  --image-max-width: 100%;\\n\\n  /* Высота картинки */\\n  --image-height: 160px;\\n\\n  /* Размер иконки приложения.\\n     Только для рекламы мобильных приложений */\\n  --app-icon-size: 48px;\\n\\n  /* Горизонтальное позиционирование сетки баннеров\\n     center - по середине, flex-start - слева,\\n     space-between - по всей ширине, space-around - по всей ширине с отступами\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/justify-content */\\n  --banners-justify-content: center;\\n\\n  /* Отступы вокруг объявления */\\n  --banner-margin: 5px;\\n  \\n  /* Отступы первых и последних объявлений от края \\n     по горизонтали и вертикали. Значение var(--banner-margin) \\n     повторяет общее значение отступов. \\n     ! Неприменимо для одиночных объявлений */\\n  --banners-grid-first-item-top-margin: 0;\\n  --banners-grid-first-item-left-margin: 4px;\\n  --banners-grid-first-item-right-margin: 4px;\\n  --banners-grid-first-item-bottom-margin: 0;\\n\\n  /* Цвет фона объявления. Пример: white или #f0f2f8;\\n     Допустимо использование переменных. См. начало документа */\\n  --banner-background: var(--color-light);\\n  /* Цвет фона при наведении на объявление */\\n  --banner-background-hover: var(--color-light-alt);\\n\\n  /* Обводка объявления. Для отключения укажите значение none\\n     Пример: solid 1px rgba(0 0 0 / 15%);\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/border */\\n  --banner-stroke: none;\\n  \\n  /* Тень объявления. Пример: 0px 8px 24px rgba(0, 21, 64, 0.125);\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/box-shadow */\\n  --banner-shadow: none;\\n  /* Тень объявления при наведении */\\n  --banner-shadow-hover: none;\\n  /* Трансформация объявления при наведении. Пример: translateY(-2px); */\\n  --banner-transform-hover: none;\\n  /* Анимация изменений при наведении */\\n  --banner-transition: box-shadow 120ms ease, transform 120ms ease;\\n\\n  /* Скругление углов объявления */\\n  --banner-outer-border-radius: 8px;\\n  /* Скругление углов внутренних элементов объявления (картинка, кнопки) */\\n  --banner-inner-border-radius: 8px;\\n  \\n  /* Отступы элементов от краев объявления */\\n  --banner-padding-outer: 10px;\\n  /* Отступы между элементами объявления */\\n  --banner-padding-inner: 10px;\\n\\n\\n  /* Цвет заголовка в объявлении */\\n  --color-text-header: var(--color-black); \\n  /* Цвет текста в объявлении */\\n  --color-text-desc: var(--color-grey-alt);\\n  /* Цвет цены в объявлении */\\n  --color-text-price: var(--color-black);\\n  /* Цвет ссылки в объявлении */\\n  --color-text-domain: var(--color-blue);\\n  /* Цвет ссылки в объявлении при наведении */\\n  --color-text-domain-hover: var(--color-blue-dark);\\n  /* Фон кнопки действия. Не применимо, если кнопка \\n     не предусмотрена в шаблоне (для форматов маленького размера) */\\n  --color-background-domain: var(--color-blue-transparent);\\n  /* Фон кнопки действия при наведении */\\n  --color-background-domain-hover: var(--color-blue-dark-transparent);\\n\\n  /* Цвет названия приложения в объявления (для РМП) */\\n  --color-text-app-name: var(--color-grey-alt);\\n\\n\\n  /* Цепочка используемых шрифтов в объявлении. По умолчанию указана \\n     цепочка системных шрифтов. Если шрифт не поддерживается, используется \\n     следующий по цепочке. При использовании собственного шрифта, \\n     следует указывать его название в самом начале */\\n  --font-family: \\n    -apple-system, BlinkMacSystemFont, \\\"Segoe UI\\\", Roboto, \\n    Oxygen, Ubuntu, Cantarell, \\\"Open Sans\\\", \\\"Helvetica Neue\\\", sans-serif, \\n    Apple Color Emoji, Segoe UI Emoji;\\n\\n  /* Размер шрифта и межстрочное расстояние для коротких заголовков\\n     (до 21 символа) */\\n  --font-size-title-short: 24px;\\n  --line-height-title-short: calc(1em + 0px);\\n\\n  /* Размер шрифта и межстрочное расстояние для заголовков средней длины \\n     (от 22 до 31 символа) */\\n  --font-size-title-mid: 20px;\\n  --line-height-title-mid: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для длинных заголовков \\n     (от 32 символов) */\\n  --font-size-title-long: 20px;\\n  --line-height-title-long: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для заголовков РМП */\\n  --font-size-title-rmp: 20px;\\n  --line-height-title-rmp: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для цен */\\n  --font-size-price: 16px;\\n  --line-height-price: calc(1em + 4px);\\n\\n  /* Размер шрифта и межстрочное расстояние для текста объявления */\\n  --font-size-desc: 15px;\\n  --line-height-desc: calc(1em + 3px);\\n\\n  /* Размер шрифта и межстрочное расстояние для ссылки */\\n  --font-size-domain: 15px;\\n  --line-height-domain: 18px;\\n\\n  /* Размер шрифта и межстрочное расстояние для названия приложения \\n     (для РМП) */\\n  --font-size-app-name: 14px;\\n  --line-height-app-name: calc(1em + 2px);\\n\\n\\n  \\n\\n  width: 100%;\\n  margin: 0 auto;\\n\\n  height: auto;\\n  padding: 0;\\n  overflow: visible;\\n}\\n\\n/* Специальные переменные для Рекламы Мобильных Приложений */\\n.ya-unit-item-rmp {\\n  /* Цвет текста ссылки */\\n  --color-text-domain: var(--color-blue);\\n  /* Цвет текста ссылки при наведении */\\n  --color-text-domain-hover: var(--color-blue-dark);\\n  /* Цвет фона кнопки объявления.\\n     Не применимо если, кнопки не предусмотрено (для маленьких форматов) */\\n  --color-background-domain: var(--color-blue-transparent);\\n  /* Цвет фона кнопки объявления при наведении */\\n  --color-background-domain-hover: var(--color-blue-dark-transparent);\\n}\\n\\n/* Специальные значения для размеров экрана шире 400px */\\n@media screen and (min-width: 400px) {\\n\\n  .ya-container {\\n    --image-height: 200px;\\n\\n    --app-icon-size: 64px;\\n\\n    --font-size-title: 18px;\\n    --line-height-title: calc(1em + 2px);\\n\\n    --font-size-title-short: 28px;\\n    --line-height-title-short: calc(1em + 0px);\\n  \\n    --font-size-title-mid: 24px;\\n    --line-height-title-mid: calc(1em + 2px);\\n  \\n    --font-size-title-long: 22px;\\n    --line-height-title-long: calc(1em + 2px);\\n\\n    --font-size-price: 20px;\\n    --line-height-price: calc(1em + 0px);\\n\\n    --font-size-desc: 16px;\\n    --line-height-desc: calc(1em + 4px);\\n\\n    --font-size-app-name: 18px;\\n    --line-height-app-name: calc(1em + 2px);\\n\\n    --font-size-domain: 16px;\\n    --line-height-domain: 20px;\\n\\n    --banner-padding-outer: 12px;\\n    --banner-padding-inner: 12px;\\n  }\\n}\\n\\n\\n\\n/* -------- Далее — настройка стилей объявления. -------- */\\n/* -------- Не рекомендуется редактировать -------- */\\n\\n.ya-units-grid {\\n  margin: 0px auto;\\n}\\n\\n.grid-row {\\n  justify-content: var(--banners-justify-content);\\n  align-content: var(--banners-align-content);\\n  padding: 0px 0;\\n}\\n\\n.grid-item,\\n.ya-slider-item {\\n  width: var(--banner-width);\\n  min-width: var(--banner-min-width);\\n  max-width: var(--banner-max-width);\\n  \\n  min-height: var(--banner-min-height);\\n  max-height: var(--banner-max-height);\\n\\n  font-family: var(--font-family);\\n  background: var(--banner-background);\\n  border: var(--banner-stroke);\\n  margin: var(--banner-margin, inherit);\\n  border-radius: var(--banner-outer-border-radius);\\n  overflow: hidden;\\n  box-sizing: border-box;\\n  flex: var(--banner-flex);\\n\\n  box-shadow: var(--banner-shadow);\\n  transform: none;\\n  transition: var(--banner-transition);\\n}\\n\\n.grid-item:hover,\\n.ya-slider-item:hover {\\n  transform: var(--banner-transform-hover);\\n  box-shadow: var(--banner-shadow-hover);\\n  background: var(--banner-background-hover);\\n  --color-text-domain: var(--color-text-domain-hover);\\n}\\n\\n.grid-item:first-child,\\n.ya-slider-item:first-child {\\n  margin-left: var(--banners-grid-first-item-left-margin);\\n}\\n\\n.grid-item:last-child,\\n.ya-slider-item:last-child {\\n  margin-right: var(--banners-grid-first-item-right-margin);\\n}\\n\\n.grid-row:first-child .grid-item {\\n  margin-top: var(--banners-grid-first-item-top-margin);\\n}\\n\\n.grid-row:last-child .grid-item {\\n  margin-bottom: var(--banners-grid-first-item-bottom-margin);\\n}\\n\\n.unit-wrapper {\\n  height: 100%;\\n}\\n\\n.ya-unit-wrapper  {\\n  opacity: 0.8;\\n  transition: opacity 120ms ease;\\n}\\n\\n.ya-unit-wrapper-visible {\\n  opacity: 1.0;\\n}\\n\\n\\n\\n.ya-unit-favicon {\\n  display: block !important;\\n}\\n\\na.yrw-url {\\n  color: inherit;\\n  cursor: pointer;\\n}\\n\\n.unit-misc {\\n  position: absolute;\\n  top: 0;\\n  left: 0;\\n  width: 100%;\\n  height: 100%;\\n}\\n\\n.unit-meta {\\n  position: absolute;\\n  top: 10px;\\n  left: var(--banner-padding-outer);\\n  z-index: 2;\\n  padding: 0px 4px 0px;\\n  text-transform: uppercase;\\n  height: 12px;\\n  background: transparent;\\n  color: var(--color-grey);\\n  border-radius: 4px;\\n  font-size: 8px;\\n  line-height: 13px;\\n  font-weight: 500;\\n  letter-spacing: 0.12em;\\n  vertical-align: 5px;\\n  margin: 0;\\n  user-select: none;\\n  -ms-user-select: none;\\n  -moz-user-select: none;\\n  -khtml-user-select: none;\\n  -webkit-user-select: none;\\n}\\n\\n.ya-unit-item-rmp .unit-meta {\\n  background: transparent;\\n  /* position: relative; */\\n}\\n\\n.unit-age::before {\\n  content: \\\" | \\\";\\n}\\n\\n.unit-age:empty {\\n  display: none;\\n}\\n\\n.ya-unit-kebab_button svg circle {\\n  fill: var(--color-grey);\\n}\\n\\n.ya-unit-kebab_bg {\\n  background: transparent;\\n  opacity: 1.0;\\n}\\n\\n.ya-unit-kebab_icon {\\n  filter: var(--display-image, none);\\n}\\n\\n.ya-unit-kebab_icon circle {\\n  fill: var(--color-grey) !important;\\n}\\n\\n.ya-unit-kebab_button {\\n  position: absolute;\\n  z-index: 940;\\n  top: 4px;\\n  right: 4px;\\n  width: 24px;\\n  height: 24px;\\n}\\n\\n.yrw-body_warning {\\n  position: relative;\\n}\\n\\n.yrw-body_warning div {\\n  padding: 0;\\n}\\n\\n.yrw-body_warning div:not(.yrw-warning-wrapper):not(.yrw-warning-text) {\\n  position: relative;\\n  background-color: var(--color-light-alt);\\n  color: #575c66;\\n  display: flex;\\n  padding: 0 calc(var(--inner-border-radius) / 2);\\n}\\n\\n.yrw-body_warning div text {\\n  fill: #575c66;\\n}\\n\\n.yrw-body_warning div:not(.yrw-warning-wrapper) {\\n  padding: 0 calc(var(--inner-border-radius) / 2 + 4px);\\n}\\n\\n.yrw-warning-text {\\n  text-shadow: none;\\n}\\n\\n\\n\\n.unit-container {\\n  box-sizing: border-box;\\n  position: relative;\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: flex-end;\\n  overflow: hidden;\\n  max-width: var(--max-content-width, --banner-max-width, 960px);\\n  margin: auto;\\n}\\n\\n.unit-content {\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: flex-start;\\n  position: relative;\\n  height: 100%;\\n  padding: 8px;\\n  padding: var(--banner-padding-outer);\\n  padding-top: 32px;\\n}\\n\\n.unit-text-content {\\n  display: flex;\\n  justify-content: flex-start;\\n  flex-direction: column;\\n  position: relative;\\n  flex: auto;\\n}\\n\\n.rmp-app-content {\\n  display: flex;\\n  flex-direction: row;\\n}\\n\\n.rmp-text-content {\\n  display: flex;\\n  justify-content: center;\\n  flex-direction: column;\\n}\\n\\n.unit-text-content > div {\\n  margin-top: var(--banner-padding-inner);\\n}\\n\\n.rmp-text-content > div {\\n  margin-top: calc(var(--banner-padding-inner) / 2);\\n}\\n\\n.rmp-text-content > div:first-child {\\n  margin-top: 0;\\n}\\n\\n\\n\\n.ya-unit-title, .unit-title {\\n  color: var(--color-text-header);\\n  font-size: var(--font-size-title);\\n  line-height: var(--line-height-title);\\n  font-weight: 600;\\n  display: flex;\\n}\\n\\n.title-short {\\n  font-size: var(--font-size-title-short);\\n  line-height: var(--line-height-title-short);\\n}\\n\\n.title-mid {\\n  font-size: var(--font-size-title-mid);\\n  line-height: var(--line-height-title-mid);\\n}\\n\\n.title-long {\\n  font-size: var(--font-size-title-long);\\n  line-height: var(--line-height-title-long);\\n}\\n\\n.title-rmp {\\n  font-size: var(--font-size-title-rmp);\\n  line-height: var(--line-height-title-rmp);\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: center;\\n}\\n\\n.unit-app-name {\\n  font-size: var(--font-size-app-name);\\n  line-height: var(--line-height-app-name);\\n  color: var(--color-text-app-name);\\n}\\n\\n.unit-cta {\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: center;\\n  box-sizing: border-box;\\n  padding: 12px;\\n\\n  font-size: var(--domain-font-size);\\n  line-height: var(--domain-line-height);\\n  text-align: center;\\n\\n  color: var(--color-cta-color);\\n  background-color: var(--color-background-domain);\\n  border-radius: var(--banner-inner-border-radius);\\n\\n  margin-top: var(--banner-padding-inner);\\n\\n  transition: var(--cta-transition);\\n}\\n\\n.unit-cta:hover {\\n  color: var(--color-cta-hover-color);\\n  background-color: var(--color-background-domain-hover);\\n}\\n\\n.unit-favicon {\\n  width: var(--line-height-domain);\\n  background-color: transparent;\\n  border-radius: 3px;\\n  align-self: center;\\n  display: var(--display-favicon, inline);\\n}\\n\\n.ya-unit-favicon {\\n  width: var(--line-height-domain);\\n  height: var(--line-height-domain);\\n}\\n\\n.ya-unit-rating {\\n  margin-right: 4px;\\n  height: 16px;\\n  display: inline;\\n}\\n\\n.ya-unit-review-count {\\n  display: var(--display-rmp-rating-count);\\n  transform: translateY(1px);\\n  color: var(--color-grey-alt);\\n  font-size: 13px;\\n  line-height: 16px;\\n}\\n\\n.unit-favicon:empty,\\n.ya-unit-domain:empty,\\n.unit-domain:empty {\\n  display: none;\\n}\\n\\n.unit-domain {\\n  display: flex;\\n  margin-right: auto;\\n  border-radius: 4px;\\n  color: var(--color-text-domain);\\n  font-size: var(--font-size-domain);\\n  line-height: var(--line-height-domain);\\n  \\n  padding: 0;\\n  width: 100%;\\n  height: var(--line-height-domain, 16px);\\n  flex-direction: row;\\n  flex-wrap: wrap;\\n  justify-content: center;\\n  align-content: flex-end;\\n  overflow: hidden;\\n}\\n\\n.unit-domain > *,\\n.unit-domain .unit-domain-no-wrap > * {\\n  margin-right: calc(var(--line-height-domain) / 3.5);\\n}\\n\\n.unit-domain span {\\n  flex: none;\\n}\\n\\n.unit-domain-no-wrap {\\n  display: flex;\\n}\\n\\n\\n\\n.unit-app-rating {\\n  display: flex;\\n  flex-direction: row;\\n  align-content: center;\\n}\\n\\n.unit-prices {\\n  display: var(--display-price, inline);\\n  white-space: nowrap;\\n  font-size: var(--font-size-price);\\n  line-height: var(--line-height-price);\\n}\\n\\n.ya-unit-price {\\n  color: var(--color-text-price);\\n  font-weight: 600;\\n  display: inline;\\n  white-space: nowrap;\\n}\\n\\n.ya-unit-old-price {\\n  margin-left: 8px;\\n  font-size: max(0.9em, 12px);\\n  line-height: max(0.9em, 12px);\\n\\n  color: var(--color-grey-alt);\\n  position: relative;\\n  white-space: nowrap;\\n  display: inline;\\n}\\n\\n.ya-unit-old-price::after {\\n  content: \\\"\\\";\\n  position: absolute;\\n  bottom: 0;\\n  left: 0;\\n  width: 100%;\\n  height: 100%;\\n\\n  background-image: url(\\\"data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='100%' height='100%'><line class='line' x1='0' y1='65%' x2='100%' y2='50%' stroke='%23A3ACBF' stroke-width='8vh' /></svg>\\\");\\n  background-repeat: no-repeat;\\n}\\n\\n.unit-desc {\\n  display: var(--display-desc);\\n  color: var(--color-text-desc);\\n  font-size: var(--font-size-desc);\\n  line-height: var(--line-height-desc);\\n}\\n\\n\\n\\n.unit-image-block {\\n  display: var(--display-image);\\n  width: 100%;\\n  max-width: var(--image-max-width, none);\\n  height: var(--image-height);\\n  flex: none;\\n  border-radius: var(--banner-inner-border-radius);\\n  position: relative;\\n  box-sizing: border-box;\\n  background-color: var(--color-light-alt);\\n  overflow: hidden;\\n}\\n\\n.unit-image {\\n  width: 100%;\\n  height: 100%;\\n  display: var(--display-image);\\n  position: relative;\\n}\\n\\n.video-source-container {\\n  border-radius: var(--banner-inner-border-radius, 8px);\\n  z-index: 1;\\n  overflow: hidden;\\n}\\n\\n.ya-unit-app-icon {\\n  position: relative;\\n  border-radius: calc(var(--app-icon-size) / 4);\\n  margin-right: var(--banner-padding-inner);\\n  display: flex;\\n}\\n\\n.unit-app-icon {\\n  margin: auto;\\n}\\n\\n.ya-unit-app-icon .yrw-img-component {\\n  width: var(--app-icon-size);\\n  height: var(--app-icon-size);\\n}\\n\\n.ya-unit-image {\\n  height: 100%;\\n}\\n\\n.yrw-img-component {\\n  height: 100%;\\n  padding-bottom: 0;\\n}\\n\\n.unit-image .img-source-component {\\n  border-radius: var(--banner-inner-border-radius);\\n  background-image: url(\\\"data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='256' height='256'><rect x='80' y='80' width='96' height='96' rx='19.2' fill='%23405580' fill-opacity='0.15'/><path d='M144.619 110.181H147.619C147.619 108.524 146.276 107.181 144.619 107.181V110.181ZM111.102 147.94L146.74 112.302L142.498 108.06L106.86 143.698L111.102 147.94ZM114.072 113.181H144.619V107.181L114.072 107.181V113.181ZM141.619 110.181V140.728H147.619V110.181L141.619 110.181Z' fill='white'/></svg>\\\");\\n  background-position: center;\\n}\\n\\n.ya-unit-app-icon .img-source-component {\\n  border-radius: calc(var(--app-icon-size) / 4 - 4px);\\n}\\n\\n.ya-clamp {\\n  width: 100%;\\n}\\n\\n.yrw-content {\\n  overflow: visible;\\n}\\n\\n.ya-grid-template:empty {\\n  display: none;\\n}\",\"gridColumns\":\"4\",\"gridRows\":\"1\",\"defaultHeight\":\"450\",\"defaultWidth\":\"750\"},{\"value\":\"11\",\"label\":\"Десктопный сингл 100% x 250px\",\"template\":\"<ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n\\n  <div class=\\\"unit-misc\\\">\\n    <ya-unit-kebab class=\\\"ya-unit-kebab_dark\\\" />\\n  </div>\\n\\n  <div class=\\\"unit-content\\\">\\n    <div class=\\\"unit-image-block\\\">\\n      <ya-unit-image/>\\n    </div>\\n\\n    <div class=\\\"unit-text-content\\\" data-cols=\\\"1\\\" data-rows=\\\"1\\\">\\n\\n      <div class=\\\"unit-meta\\\">\\n        <ya-unit-category class=\\\"unit-category\\\" />\\n        <ya-unit-age class=\\\"unit-age\\\" />\\n      </div>\\n\\n      <div class=\\\"unit-title\\\">\\n        <ya-unit-if condition=\\\"unit.title < 22\\\">\\n          <ya-clamp lines=\\\"3\\\" class=\\\"title-short\\\"><ya-unit-title /></ya-clamp>\\n        </ya-unit-if>\\n\\n        <ya-unit-if condition=\\\"unit.title > 21 & unit.title < 33\\\">\\n          <ya-clamp lines=\\\"3\\\" class=\\\"title-mid\\\"><ya-unit-title /></ya-clamp>\\n        </ya-unit-if>\\n\\n        <ya-unit-if condition=\\\"unit.title > 32\\\">\\n          <ya-clamp lines=\\\"3\\\" class=\\\"title-long\\\"><ya-unit-title /></ya-clamp>\\n        </ya-unit-if>\\n      </div>\\n\\n      <!-- Начало Шаблона ТГО -->\\n      <ya-unit-if condition=\\\"!unit.isRmp\\\">\\n        <div class=\\\"unit-prices\\\"><ya-unit-price /><ya-unit-old-price /></div>  \\n        <ya-clamp lines=\\\"2\\\" class=\\\"unit-desc\\\"><ya-unit-desc /></ya-clamp>\\n      </ya-unit-if>\\n      <!-- Конец Шаблона ТГО -->\\n\\n\\n    \\n      <!-- Начало Шаблона РМП -->\\n      <ya-unit-if condition=\\\"unit.isRmp\\\">\\n        \\n        <div class=\\\"rmp-app-content\\\">\\n          <ya-unit-app-icon />\\n\\n          <div class=\\\"rmp-text-content\\\">\\n            <div class=\\\"unit-app-name\\\">\\n              <ya-clamp lines=\\\"2\\\">\\n                <ya-unit-app-name />\\n              </ya-clamp>\\n            </div>\\n\\n            <div class=\\\"unit-app-rating\\\">\\n              <ya-unit-rating />\\n              <ya-unit-review-count />\\n            </div>\\n          </div>\\n        </div>\\n\\n      </ya-unit-if>\\n      <!-- Конец Шаблона РМП -->\\n\\n      <div class=\\\"unit-cta\\\">\\n        <div class=\\\"unit-domain\\\">\\n          <ya-unit-mobile-app-button />\\n          <ya-unit-if condition=\\\"!unit.isRmp\\\">\\n            <span class=\\\"unit-domain-no-wrap\\\">\\n              <span class=\\\"unit-favicon\\\"><ya-unit-favicon size=\\\"32\\\"/></span>\\n              <ya-unit-domain class=\\\"domain\\\"/>\\n            </span>\\n          </ya-unit-if>\\n          \\n        </div>\\n      </div>\\n    </div>\\n  </div>\\n</ya-units-grid>\",\"css\":\"/* Шаблон 4: Десктопный сингл размером 100% x 250px\\n   Для использования в шапке сайта */\\n\\n/* Шаблоны не работают в браузерах IE 11 версии и ниже */\\n\\n/* РМП — Реклама Мобильных Приложений */\\n\\n\\n/* -------- Переменные цветов -------- */\\n/* изменив значение цвета тут — изменится во всех элементах шаблона */\\n.ya-container {\\n\\n  --color-blue: #3377FF;\\n  --color-blue-dark: #0055FF;\\n\\n  --color-blue-transparent: #3377FF1A;\\n  --color-blue-dark-transparent: #0055FF1A;\\n\\n\\n  --color-black: #232526;\\n  --color-grey: #575c66;\\n  --color-grey-alt: #A3ACBF;\\n  --color-light: #f4f4f6;\\n  --color-light-alt: #ececef;\\n}\\n\\n/* Переменные цветов для устройств с поддержкой \\n   цветового профиля Display P3 (устройства Apple) */\\n\\n/* Устройства Apple поддерживают цветовой профиль \\n   с более яркими цветами (цветовой профиль Display P3). \\n   Если вы хотите поддержать его, то следует поменять \\n   значения цветов в блоке ниже */\\n@supports (color: color(display-p3)) {\\n  .ya-container {\\n    --color-blue: color(display-p3 0.2 0.47 1.0);\\n    --color-blue-dark: color(display-p3 0.0 0.33 1.0);\\n\\n    --color-blue-transparent: color(display-p3 0.2 0.47 1.0 / 0.1);\\n    --color-blue-dark-transparent: color(display-p3 0.0 0.33 1.0 / 0.1);\\n\\n    --color-yellow: color(display-p3 1.0 0.8 0.2);\\n    --color-yellow-dark: color(display-p3 1.0 0.75 0.0);\\n  }\\n}\\n\\n\\n\\n/* -------- Переменные для отрисовки объявления -------- */\\n\\n.ya-container {\\n\\n  /* Адаптивность объявления по ширине.\\n     Укажите значение none, чтобы зафиксировать размер объявления.\\n     Укажите auto, чтобы объявление занимало всю доступную ширину */\\n  --banner-flex: auto;\\n\\n  /* Фиксированная ширина объявления.\\n     Работает при --banner-flex: none */\\n  --banner-width: 300px;\\n\\n  /* Минимальная и максимальная ширина объявления.\\n     Работает при --banner-flex: auto */\\n  --banner-min-width: 540px;\\n  --banner-max-width: 100%;\\n\\n  /* Минимальная и максимальная высота объявления.\\n     Объявление будет растягиваться по высоте \\n     в зависимости от количества контента */\\n  --banner-min-height: 250px;\\n  --banner-max-height: 250px;\\n\\n\\n  /* Отображение фавиконки: \\n     вкл - block, выкл - none; */\\n  --display-favicon: block;\\n  /* Отображение изображения: \\n     вкл - block, выкл - none; */\\n  --display-image: block;\\n  /* Отображение текста: \\n     вкл - block, выкл - none; */\\n  --display-desc: inline;\\n  /* Отображение цен: \\n     вкл - inline, выкл - none */\\n  --display-price: inline;\\n  /* Отображение количества отзывов (для РМП): \\n     вкл - inline, выкл - none */\\n  --display-rmp-rating-count: inline;\\n\\n\\n  /* Ширина картинки */\\n  --image-width: 50%;\\n\\n  /* Максимальная ширина (в случае очень широких баннеров) */\\n  --image-max-width: 400px;\\n\\n  /* Высота картинки */\\n  --image-height: 100%;\\n\\n  /* Размер иконки приложения.\\n     Только для рекламы мобильных приложений */\\n  --app-icon-size: 48px;\\n\\n  /* Максимальная ширина контента */\\n  --max-content-width: 960px;\\n\\n  /* Горизонтальное позиционирование сетки баннеров\\n     center - по середине, flex-start - слева,\\n     space-between - по всей ширине, space-around - по всей ширине с отступами\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/justify-content */\\n  --banners-justify-content: center;\\n\\n  /* Отступы вокруг объявления */\\n  --banner-margin: 8px 0;\\n  \\n  /* Отступы первых и последних объявлений от края \\n     по горизонтали и вертикали. Значение var(--banner-margin) \\n     повторяет общее значение отступов. \\n     ! Неприменимо для одиночных объявлений */\\n  --banners-grid-first-item-top-margin: 0;\\n  --banners-grid-first-item-left-margin: 0;\\n  --banners-grid-first-item-right-margin: 0;\\n  --banners-grid-first-item-bottom-margin: 0;\\n\\n  /* Цвет фона объявления. Пример: white или #f0f2f8;\\n     Допустимо использование переменных. См. начало документа */\\n  --banner-background: white;\\n  /* Цвет фона объявления при наведении */\\n  --banner-background-hover: var(--color-light);\\n\\n  /* Обводка объявления. Для отключения укажите значение none\\n     Пример: solid 1px rgba(0 0 0 / 15%);\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/border */\\n  --banner-stroke: solid 1px rgba(0 8 32 / 10%);\\n  \\n  /* Тень объявления. Пример: 0px 8px 24px rgba(0, 21, 64, 0.125);\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/box-shadow */\\n  --banner-shadow: none;\\n  /* Тень объявления при наведении */\\n  --banner-shadow-hover: none;\\n/* Трансформация объявления при наведении. Пример: translateY(-2px); */\\n  --banner-transform-hover: none;\\n  /* Анимация изменений при наведении */\\n  --banner-transition: box-shadow 120ms ease, transform 120ms ease;\\n\\n  /* Скругление углов объявления */\\n  --banner-outer-border-radius: 0px;\\n  /* Скругление углов внутренних элементов объявления (картинка, кнопки) */\\n  --banner-inner-border-radius: 8px;\\n  \\n  /* Отступы элементов от краев объявления */\\n  --banner-padding-outer: 15px;\\n  /* Отступы между элементами объявления */\\n  --banner-padding-inner: 10px;\\n\\n\\n  /* Цвет заголовка в объявлении */\\n  --color-text-header: var(--color-black); \\n  /* Цвет текста в объявлении */\\n  --color-text-desc: var(--color-grey-alt);\\n  /* Цвет цены в объявлении */\\n  --color-text-price: var(--color-black);\\n  /* Цвет ссылки в объявлении */\\n  --color-text-domain: var(--color-blue);\\n  /* Цвет ссылки в объявлении при наведении */\\n  --color-text-domain-hover: var(--color-blue-dark);\\n  /* Фон кнопки действия. Не применимо, если кнопка \\n     не предусмотрена в шаблоне (для форматов маленького размера) */\\n  --color-background-domain: var(--color-blue-transparent);\\n  /* Фон кнопки действия при наведении */\\n  --color-background-domain-hover: var(--color-blue-dark-transparent);\\n\\n  /* Цвет названия приложения в объявления (для РМП) */\\n  --color-text-app-name: var(--color-grey-alt);\\n\\n\\n  /* Цепочка используемых шрифтов в объявлении. По умолчанию указана \\n     цепочка системных шрифтов. Если шрифт не поддерживается, используется \\n     следующий по цепочке. При использовании собственного шрифта, \\n     следует указывать его название в самом начале */\\n  --font-family: \\n    -apple-system, BlinkMacSystemFont, \\\"Segoe UI\\\", Roboto, \\n    Oxygen, Ubuntu, Cantarell, \\\"Open Sans\\\", \\\"Helvetica Neue\\\", sans-serif, \\n    Apple Color Emoji, Segoe UI Emoji;\\n\\n  /* Размер шрифта и межстрочное расстояние для коротких заголовков\\n     (до 21 символа) */\\n  --font-size-title-short: 32px;\\n  --line-height-title-short: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для заголовков средней длины \\n     (от 22 до 31 символа) */\\n  --font-size-title-mid: 28px;\\n  --line-height-title-mid: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для длинных заголовков \\n     (от 32 символов) */\\n  --font-size-title-long: 24px;\\n  --line-height-title-long: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для заголовков РМП */\\n  --font-size-title-rmp: 20px;\\n  --line-height-title-rmp: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для цен */\\n  --font-size-price: 18px;\\n  --line-height-price: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для текста объявления */\\n  --font-size-desc: 16px;\\n  --line-height-desc: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для ссылки */\\n  --font-size-domain: 15px;\\n  --line-height-domain: 20px;\\n\\n  /* Размер шрифта и межстрочное расстояние для названия приложения \\n     (для РМП) */\\n  --font-size-app-name: 15px;\\n  --line-height-app-name: 16px;\\n\\n  \\n\\n  width: 100%;\\n  margin: 0 auto;\\n\\n  height: auto;\\n  padding: 0;\\n  overflow: visible;\\n}\\n\\n/* Специальные переменные для Рекламы Мобильных Приложений */\\n.ya-unit-item-rmp {\\n  /* Цвет текста ссылки */\\n  --color-text-domain: var(--color-blue);\\n  /* Цвет текста ссылки при наведении */\\n  --color-text-domain-hover: var(--color-blue-dark);\\n  /* Цвет фона кнопки объявления.\\n     Не применимо если, кнопки не предусмотрено (для маленьких форматов) */\\n  --color-background-domain: var(--color-blue-transparent);\\n  /* Цвет фона кнопки объявления при наведении */\\n  --color-background-domain-hover: var(--color-blue-dark-transparent);\\n}\\n\\n/* Специальные значения для размеров экрана шире 480px */\\n@media screen and (min-width: 800px) {\\n  .ya-container {\\n\\n    --font-size-price: 20px;\\n    --line-height-price: calc(1em + 4px);\\n  \\n    --font-size-desc: 20px;\\n    --line-height-desc: calc(1em + 4px);\\n\\n    --app-icon-size: 64px;\\n  }\\n}\\n\\n\\n\\n\\n/* -------- Далее — настройка стилей объявления. -------- */\\n/* -------- Не рекомендуется редактировать -------- */\\n\\n.ya-units-grid {\\n  margin: 0px auto;\\n}\\n\\n.grid-row {\\n  justify-content: var(--banners-justify-content);\\n  align-content: var(--banners-align-content);\\n  padding: 0px 0;\\n}\\n\\n.grid-item {\\n  width: var(--banner-width);\\n  min-width: var(--banner-min-width);\\n  max-width: var(--banner-max-width);\\n  \\n  min-height: var(--banner-min-height);\\n  max-height: var(--banner-max-height);\\n\\n  font-family: var(--font-family);\\n  background: var(--banner-background);\\n  border: var(--banner-stroke);\\n  margin: var(--banner-margin, inherit);\\n  border-radius: var(--banner-outer-border-radius);\\n  overflow: hidden;\\n  box-sizing: border-box;\\n  flex: var(--banner-flex);\\n  box-shadow: var(--banner-shadow);\\n  transform: none;\\n  transition: var(--banner-transition);\\n}\\n\\n.grid-item:hover {\\n  transform: var(--banner-transform-hover);\\n  box-shadow: var(--banner-shadow-hover);\\n  background: var(--banner-background-hover);\\n  --color-text-domain: var(--color-text-domain-hover);\\n}\\n\\n.grid-item:first-child {\\n  margin-left: var(--banners-grid-first-item-left-margin);\\n}\\n\\n.grid-item:last-child {\\n  margin-right: var(--banners-grid-first-item-right-margin);\\n}\\n\\n.grid-row:first-child .grid-item {\\n  margin-top: var(--banners-grid-first-item-top-margin);\\n}\\n\\n.grid-row:last-child .grid-item {\\n  margin-bottom: var(--banners-grid-first-item-bottom-margin);\\n}\\n\\n.unit-wrapper {\\n  height: 100%;\\n  max-width: var(--max-content-width, --banner-max-width, 960px);\\n}\\n\\n.ya-unit-favicon {\\n  display: block !important;\\n}\\n\\na.yrw-url {\\n  color: inherit;\\n  cursor: pointer;\\n}\\n\\n.unit-misc {\\n  position: absolute;\\n  top: 0;\\n  left: 0;\\n  width: 100%;\\n  height: 100%;\\n}\\n\\n.unit-meta {\\n  position: relative;\\n  z-index: 2;\\n  padding: 0px 0px 0px;\\n  text-transform: uppercase;\\n  height: 12px;\\n  background: transparent;\\n  color: var(--color-grey);\\n  border-radius: 4px;\\n  font-size: 8px;\\n  line-height: 13px;\\n  font-weight: 500;\\n  letter-spacing: 0.12em;\\n  vertical-align: 5px;\\n  margin: 0;\\n  user-select: none;\\n  -ms-user-select: none;\\n  -moz-user-select: none;\\n  -khtml-user-select: none;\\n  -webkit-user-select: none;\\n}\\n\\n.ya-unit-item-rmp .unit-meta {\\n  background: transparent;\\n}\\n\\n.unit-age::before {\\n  content: \\\" | \\\";\\n}\\n\\n.unit-age:empty {\\n  display: none;\\n}\\n\\n.ya-unit-kebab_button svg circle {\\n  fill: var(--color-grey);\\n}\\n\\n.ya-unit-kebab_bg {\\n  background: transparent;\\n  opacity: 1.0;\\n}\\n\\n.ya-unit-kebab_icon {\\n  filter: var(--display-image, none);\\n}\\n\\n.ya-unit-kebab_icon circle {\\n  fill: var(--color-grey) !important;\\n}\\n\\n.ya-unit-kebab_button {\\n  position: absolute;\\n  z-index: 940;\\n  top: 4px;\\n  right: 4px;\\n  width: 24px;\\n  height: 24px;\\n}\\n\\n.yrw-body_warning {\\n  position: relative;\\n}\\n\\n.yrw-body_warning div {\\n  padding: 0;\\n}\\n\\n.yrw-body_warning div:not(.yrw-warning-wrapper):not(.yrw-warning-text) {\\n  position: relative;\\n  background-color: var(--color-light-alt);\\n  color: #575c66;\\n  display: flex;\\n  padding: 0 calc(var(--inner-border-radius) / 2);\\n}\\n\\n.yrw-body_warning div text {\\n  fill: #575c66;\\n}\\n\\n.yrw-body_warning div:not(.yrw-warning-wrapper) {\\n  padding: 0 calc(var(--inner-border-radius) / 2 + 4px);\\n}\\n\\n.yrw-warning-text {\\n  text-shadow: none;\\n}\\n\\n\\n\\n.unit-container {\\n  box-sizing: border-box;\\n  position: relative;\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: flex-end;\\n  overflow: hidden;\\n  margin: auto;\\n}\\n\\n.unit-content {\\n  display: flex;\\n  flex-direction: row;\\n  justify-content: flex-start;\\n  position: relative;\\n  height: 100%;\\n  padding: 8px;\\n  padding: var(--banner-padding-outer);\\n}\\n\\n.unit-text-content {\\n  display: flex;\\n  justify-content: flex-start;\\n  flex-direction: column;\\n  position: relative;\\n  flex: auto;\\n  padding-left: var(--banner-padding-outer);\\n}\\n\\n.rmp-app-content {\\n  display: flex;\\n  flex-direction: row;\\n}\\n\\n.rmp-text-content {\\n  display: flex;\\n  justify-content: center;\\n  flex-direction: column;\\n}\\n\\n.unit-text-content > div {\\n  margin-top: var(--banner-padding-inner);\\n}\\n\\n.rmp-text-content > div {\\n  margin-top: calc(var(--banner-padding-inner) / 2);\\n}\\n\\n.unit-text-content > *:first-child,\\n.rmp-text-content > *:first-child {\\n  margin-top: 0;\\n}\\n\\n\\n\\n.ya-unit-title, .unit-title {\\n  color: var(--color-text-header);\\n  font-size: var(--font-size-title);\\n  line-height: var(--line-height-title);\\n  font-weight: 600;\\n  display: flex;\\n}\\n\\n.title-short {\\n  font-size: var(--font-size-title-short);\\n  line-height: var(--line-height-title-short);\\n}\\n\\n.title-mid {\\n  font-size: var(--font-size-title-mid);\\n  line-height: var(--line-height-title-mid);\\n}\\n\\n.title-long {\\n  font-size: var(--font-size-title-long);\\n  line-height: var(--line-height-title-long);\\n}\\n\\n.title-rmp {\\n  font-size: var(--font-size-title-rmp);\\n  line-height: var(--line-height-title-rmp);\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: center;\\n}\\n\\n.unit-app-name {\\n  font-size: var(--font-size-app-name);\\n  line-height: var(--line-height-app-name);\\n  color: var(--color-text-app-name);\\n}\\n\\n.unit-cta {\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: center;\\n  box-sizing: border-box;\\n  padding: 12px;\\n\\n  font-size: var(--domain-font-size);\\n  line-height: var(--domain-line-height);\\n  text-align: center;\\n  color: var(--color-cta-color);\\n  background-color: var(--color-background-domain);\\n  border-radius: var(--banner-inner-border-radius);\\n  margin-top: auto !important;\\n  transition: var(--cta-transition);\\n}\\n\\n.unit-cta:hover {\\n  color: var(--color-cta-hover-color);\\n  background-color: var(--color-background-domain-hover);\\n}\\n\\n.unit-favicon {\\n  width: var(--line-height-domain);\\n  background-color: transparent;\\n  border-radius: 3px;\\n  align-self: center;\\n  display: var(--display-favicon, inline);\\n}\\n\\n.ya-unit-favicon {\\n  width: var(--line-height-domain);\\n  height: var(--line-height-domain);\\n}\\n\\n.ya-unit-rating {\\n  margin-right: 4px;\\n  height: 16px;\\n  display: inline;\\n}\\n\\n.ya-unit-review-count {\\n  display: var(--display-rmp-rating-count);\\n  transform: translateY(1px);\\n  color: var(--color-grey-alt);\\n  font-size: 13px;\\n  line-height: 16px;\\n}\\n\\n.unit-favicon:empty,\\n.ya-unit-domain:empty,\\n.unit-domain:empty {\\n  display: none;\\n}\\n\\n.unit-domain {\\n  display: flex;\\n  margin-right: auto;\\n  border-radius: 4px;\\n  color: var(--color-text-domain);\\n  font-size: var(--font-size-domain);\\n  line-height: var(--line-height-domain);\\n  \\n  padding: 0;\\n  width: 100%;\\n  height: var(--line-height-domain, 16px);\\n  flex-direction: row;\\n  flex-wrap: wrap;\\n  justify-content: center;\\n  align-content: flex-end;\\n  overflow: hidden;\\n}\\n\\n.unit-domain > *,\\n.unit-domain .unit-domain-no-wrap > * {\\n  margin-right: calc(var(--line-height-domain) / 3.5);\\n}\\n\\n.unit-domain span {\\n  flex: none;\\n}\\n\\n.unit-domain-no-wrap {\\n  display: flex;\\n}\\n\\n\\n\\n.unit-app-rating {\\n  display: flex;\\n  flex-direction: row;\\n  align-content: center;\\n}\\n\\n.unit-prices {\\n  display: var(--display-price, inline);\\n  white-space: nowrap;\\n  font-size: var(--font-size-price);\\n  line-height: var(--line-height-price);\\n}\\n\\n.ya-unit-price {\\n  color: var(--color-text-price);\\n  font-weight: 600;\\n  display: inline;\\n  white-space: nowrap;\\n}\\n\\n.ya-unit-old-price {\\n  margin-left: 8px;\\n  font-size: max(0.9em, 12px);\\n  line-height: max(0.9em, 12px);\\n  color: var(--color-grey-alt);\\n  position: relative;\\n  white-space: nowrap;\\n  display: inline;\\n}\\n\\n.ya-unit-old-price::after {\\n  content: \\\"\\\";\\n  position: absolute;\\n  bottom: 0;\\n  left: 0;\\n  width: 100%;\\n  height: 100%;\\n  \\n  background-image: url(\\\"data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='100%' height='100%'><line class='line' x1='0' y1='65%' x2='100%' y2='50%' stroke='%23A3ACBF' stroke-width='8vh' /></svg>\\\");\\n  background-repeat: no-repeat;\\n}\\n\\n.unit-desc {\\n  display: var(--display-desc);\\n  color: var(--color-text-desc);\\n  font-size: var(--font-size-desc);\\n  line-height: var(--line-height-desc);\\n}\\n\\n\\n\\n.unit-image-block {\\n  display: var(--display-image);\\n  width: var(--image-width);\\n  max-width: var(--image-max-width, none);\\n  height: var(--image-height);\\n  flex: none;\\n  border-radius: var(--banner-inner-border-radius);\\n  position: relative;\\n  box-sizing: border-box;\\n  background-color: var(--color-light-alt);\\n  overflow: hidden;\\n}\\n\\n.unit-image {\\n  width: 100%;\\n  height: 100%;\\n  display: var(--display-image);\\n  position: relative;\\n}\\n\\n.video-source-container {\\n  border-radius: var(--banner-inner-border-radius, 8px);\\n  z-index: 1;\\n  overflow: hidden;\\n}\\n\\n.ya-unit-app-icon {\\n  position: relative;\\n  border-radius: calc(var(--app-icon-size) / 4);\\n  margin-right: var(--banner-padding-inner);\\n  display: flex;\\n}\\n\\n.unit-app-icon {\\n  margin: auto;\\n}\\n\\n.ya-unit-app-icon .yrw-img-component {\\n  width: var(--app-icon-size);\\n  height: var(--app-icon-size);\\n}\\n\\n.ya-unit-image {\\n  height: 100%;\\n}\\n\\n.yrw-img-component {\\n  height: 100%;\\n  padding-bottom: 0;\\n}\\n\\n.unit-image .img-source-component {\\n  border-radius: var(--banner-inner-border-radius);\\n  background-image: url(\\\"data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='256' height='256'><rect x='80' y='80' width='96' height='96' rx='19.2' fill='%23405580' fill-opacity='0.15'/><path d='M144.619 110.181H147.619C147.619 108.524 146.276 107.181 144.619 107.181V110.181ZM111.102 147.94L146.74 112.302L142.498 108.06L106.86 143.698L111.102 147.94ZM114.072 113.181H144.619V107.181L114.072 107.181V113.181ZM141.619 110.181V140.728H147.619V110.181L141.619 110.181Z' fill='white'/></svg>\\\");\\n  background-position: center;\\n}\\n\\n.ya-unit-app-icon .img-source-component {\\n  border-radius: calc(var(--app-icon-size) / 4 - 4px);\\n}\\n\\n.ya-clamp {\\n  width: 100%;\\n}\\n\\n.yrw-content {\\n  overflow: visible;\\n}\\n\\n.ya-grid-template:empty {\\n  display: none;\\n}\",\"gridColumns\":\"1\",\"gridRows\":\"1\",\"defaultHeight\":\"260\",\"props\":{}},{\"value\":\"7\",\"label\":\"Десктопный грид 3x1 100% x 300px\",\"template\":\"<ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n\\n  <div class=\\\"unit-misc\\\">\\n    <ya-unit-kebab class=\\\"ya-unit-kebab_dark\\\" />\\n    <div class=\\\"unit-meta\\\">\\n      <ya-unit-category class=\\\"unit-category\\\" />\\n      <ya-unit-age class=\\\"unit-age\\\" />\\n    </div>\\n  </div>\\n\\n  <div class=\\\"unit-content\\\">\\n    <div class=\\\"unit-image-block\\\">\\n      <ya-unit-image/>\\n    </div>\\n\\n    <div class=\\\"unit-text-content\\\" cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n\\n      <!-- Начало Шаблона ТГО -->\\n      <ya-unit-if condition=\\\"!unit.isRmp\\\">\\n\\n        <div class=\\\"unit-title\\\">\\n          <ya-unit-if condition=\\\"unit.title < 22\\\">\\n            <ya-clamp lines=\\\"3\\\" class=\\\"title-short\\\"><ya-unit-title /></ya-clamp>\\n          </ya-unit-if>\\n\\n          <ya-unit-if condition=\\\"unit.title > 21 & unit.title < 33\\\">\\n            <ya-clamp lines=\\\"3\\\" class=\\\"title-mid\\\"><ya-unit-title /></ya-clamp>\\n          </ya-unit-if>\\n\\n          <ya-unit-if condition=\\\"unit.title > 32\\\">\\n            <ya-clamp lines=\\\"3\\\" class=\\\"title-long\\\"><ya-unit-title /></ya-clamp>\\n          </ya-unit-if>\\n        </div>\\n\\n        <div class=\\\"unit-prices\\\"><ya-unit-price /><ya-unit-old-price /></div>\\n  \\n        <ya-clamp lines=\\\"2\\\" class=\\\"unit-desc\\\"><ya-unit-desc /></ya-clamp>\\n\\n\\n      </ya-unit-if>\\n      <!-- Конец Шаблона ТГО -->\\n\\n    \\n      <!-- Начало Шаблона РМП -->\\n      <ya-unit-if condition=\\\"unit.isRmp\\\">\\n        <div class=\\\"unit-title\\\">\\n          <span class=\\\"title-rmp\\\">\\n            <ya-clamp lines=\\\"2\\\"><ya-unit-title /></ya-clamp>\\n          </span>\\n        </div>\\n\\n        <div class=\\\"rmp-app-content\\\">\\n          <ya-unit-app-icon />\\n          <div class=\\\"rmp-text-content\\\">\\n\\n            <div class=\\\"unit-app-name\\\">\\n              <ya-clamp lines=\\\"1\\\">\\n                <ya-unit-app-name />\\n              </ya-clamp>\\n            </div>\\n\\n            <div class=\\\"unit-app-rating\\\">\\n              <ya-unit-rating />\\n              <ya-unit-review-count />\\n            </div>\\n          </div>\\n\\n        </div>\\n\\n      </ya-unit-if>\\n      <!-- Конец Шаблона РМП -->\\n\\n    </div>\\n\\n    <div class=\\\"unit-cta\\\">\\n      <div class=\\\"unit-domain\\\">\\n        <ya-unit-mobile-app-button />\\n        <ya-unit-if condition=\\\"!unit.isRmp\\\">\\n          <span class=\\\"unit-domain-no-wrap\\\">\\n            <span class=\\\"unit-favicon\\\"><ya-unit-favicon size=\\\"32\\\"/></span>\\n            <ya-unit-domain class=\\\"domain\\\"/>\\n          </span>\\n        </ya-unit-if>\\n      </div>\\n    </div>\\n  </div>\\n\\n</ya-units-grid>\",\"css\":\"/* Шаблон 5: Десктопный грид 3x1 размером 100% x 300px */\\n\\n\\n/* Шаблоны не работают в браузерах IE 11 версии и ниже */\\n\\n/* РМП — Реклама Мобильных Приложений */\\n\\n\\n/* -------- Переменные цветов -------- */\\n/* изменив значение цвета тут — изменится во всех элементах шаблона */\\n.ya-container {\\n\\n  --color-blue: #3377FF;\\n  --color-blue-dark: #0055FF;\\n\\n  --color-blue-transparent: #3377FF1A;\\n  --color-blue-dark-transparent: #0055FF1A;\\n\\n  --color-yellow: #FFCC33;\\n  --color-yellow-dark: #FFBF00;\\n\\n  --color-black: #232526;\\n  --color-grey: #575c66;\\n  --color-grey-alt: #A3ACBF;\\n  --color-light: #f4f4f6;\\n  --color-light-alt: #ececef;\\n}\\n\\n/* Переменные цветов для устройств с поддержкой \\n   цветового профиля Display P3 (устройства Apple) */\\n\\n/* Устройства Apple поддерживают цветовой профиль \\n   с более яркими цветами (цветовой профиль Display P3). \\n   Если вы хотите поддержать его, то следует поменять \\n   значения цветов в блоке ниже */\\n@supports (color: color(display-p3)) {\\n  .ya-container {\\n    --color-blue: color(display-p3 0.2 0.47 1.0);\\n    --color-blue-dark: color(display-p3 0.0 0.33 1.0);\\n\\n    --color-blue-transparent: color(display-p3 0.2 0.47 1.0 / 0.1);\\n    --color-blue-dark-transparent: color(display-p3 0.0 0.33 1.0 / 0.1);\\n\\n    --color-yellow: color(display-p3 1.0 0.8 0.2);\\n    --color-yellow-dark: color(display-p3 1.0 0.75 0.0);\\n  }\\n}\\n\\n\\n\\n/* -------- Переменные для отрисовки объявления -------- */\\n\\n.ya-container {\\n\\n  /* Адаптивность объявления по ширине.\\n     Укажите значение none, чтобы зафиксировать размер объявления.\\n     Укажите auto, чтобы объявление занимало всю доступную ширину */\\n  --banner-flex: auto;\\n\\n  /* Фиксированная ширина объявления.\\n     Работает при --banner-flex: none */\\n  --banner-width: 300px;\\n\\n  /* Минимальная и максимальная ширина объявления.\\n     Работает при --banner-flex: auto */\\n  --banner-min-width: 200px;\\n  --banner-max-width: 400px;\\n\\n  /* Минимальная и максимальная высота объявления.\\n     Объявление будет растягиваться по высоте \\n     в зависимости от количества контента */\\n  --banner-min-height: 300px;\\n  --banner-max-height: 300px;\\n\\n\\n  /* Отображение фавиконки: \\n     вкл - block, выкл - none; */\\n  --display-favicon: block;\\n  /* Отображение изображения: \\n     вкл - block, выкл - none; */\\n  --display-image: block;\\n  /* Отображение текста: \\n     вкл - block, выкл - none; */\\n  --display-desc: none;\\n  /* Отображение цен: \\n     вкл - inline, выкл - none */\\n  --display-price: inline;\\n  /* Отображение количества отзывов (для РМП): \\n     вкл - inline, выкл - none */\\n  --display-rmp-rating-count: inline;\\n  \\n\\n  /* Максимальная ширина картинки */\\n  --image-max-width: 100%;\\n\\n  /* Высота картинки */\\n  --image-height: 100%;\\n\\n  /* Размер иконки приложения.\\n     Только для рекламы мобильных приложений */\\n  --app-icon-size: 40px;\\n\\n   /* Горизонтальное позиционирование сетки баннеров\\n     center - по середине, flex-start - слева,\\n     space-between - по всей ширине, space-around - по всей ширине с отступами\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/justify-content */\\n  --banners-justify-content: center;\\n\\n  /* Отступы вокруг объявления */\\n  --banner-margin: 2px;\\n  \\n  /* Отступы первых и последних объявлений от края \\n     по горизонтали и вертикали. Значение var(--banner-margin) \\n     повторяет общее значение отступов. \\n     ! Неприменимо для одиночных объявлений */\\n  --banners-grid-first-item-top-margin: var(--banner-margin);\\n  --banners-grid-first-item-left-margin: calc( var(--banner-margin) * 2);\\n  --banners-grid-first-item-right-margin: calc( var(--banner-margin) * 2);\\n  --banners-grid-first-item-bottom-margin: var(--banner-margin);\\n\\n\\n  /* Цвет фона объявления. Пример: white или #f0f2f8;\\n     Допустимо использование переменных. См. начало документа */\\n  --banner-background: white;\\n  /* Цвет фона при наведении на объявление */\\n  --banner-background-hover: white;\\n\\n  /* Обводка объявления. Для отключения укажите значение none\\n     Пример: solid 1px rgba(0 0 0 / 15%);\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/border */\\n  --banner-stroke: solid 1px rgba(0 8 32 / 10%);\\n  \\n  /* Тень объявления. Пример: 0px 8px 24px rgba(0, 21, 64, 0.125);\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/box-shadow */\\n  --banner-shadow: none;\\n  /* Тень объявления при наведении */\\n  --banner-shadow-hover: none;\\n  /* Трансформация объявления при наведении. Пример: translateY(-2px); */\\n  --banner-transform-hover: none;\\n  /* Анимация изменений при наведении */\\n  --banner-transition: box-shadow 120ms ease, transform 120ms ease;\\n\\n  /* Скругление углов объявления */\\n  --banner-outer-border-radius: 8px;\\n  /* Скругление углов внутренних элементов объявления (картинка, кнопки) */\\n  --banner-inner-border-radius: 6px;\\n  \\n  /* Отступы элементов от краев объявления */\\n  --banner-padding-outer: 5px;\\n  /* Отступы между элементами объявления */\\n  --banner-padding-inner: 10px;\\n\\n\\n  /* Цвет заголовка в объявлении */\\n  --color-text-header: var(--color-black); \\n  /* Цвет текста в объявлении */\\n  --color-text-desc: var(--color-grey-alt);\\n  /* Цвет цены в объявлении */\\n  --color-text-price: var(--color-black);\\n  /* Цвет ссылки в объявлении */\\n  --color-text-domain: var(--color-blue);\\n  /* Цвет ссылки в объявлении при наведении */\\n  --color-text-domain-hover: var(--color-blue-dark);\\n  /* Фон кнопки действия. Не применимо, если кнопка \\n     не предусмотрена в шаблоне (для форматов маленького размера) */\\n  --color-background-domain: var(--color-blue-transparent);\\n  /* Фон кнопки действия при наведении */\\n  --color-background-domain-hover: var(--color-blue-dark-transparent);\\n\\n  /* Цвет названия приложения в объявления (для РМП) */\\n  --color-text-app-name: var(--color-grey-alt);\\n\\n\\n  /* Цепочка используемых шрифтов в объявлении. По умолчанию указана \\n     цепочка системных шрифтов. Если шрифт не поддерживается, используется \\n     следующий по цепочке. При использовании собственного шрифта, \\n     следует указывать его название в самом начале */\\n  --font-family: \\n    -apple-system, BlinkMacSystemFont, \\\"Segoe UI\\\", Roboto, \\n    Oxygen, Ubuntu, Cantarell, \\\"Open Sans\\\", \\\"Helvetica Neue\\\", sans-serif, \\n    Apple Color Emoji, Segoe UI Emoji;\\n\\n  /* Размер шрифта и межстрочное расстояние для коротких заголовков\\n     (до 21 символа) */\\n  --font-size-title-short: 26px;\\n  --line-height-title-short: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для заголовков средней длины \\n     (от 22 до 31 символа) */\\n  --font-size-title-mid: 22px;\\n  --line-height-title-mid: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для длинных заголовков \\n     (от 32 символов) */\\n  --font-size-title-long: 18px;\\n  --line-height-title-long: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для заголовков РМП */\\n  --font-size-title-rmp: 16px;\\n  --line-height-title-rmp: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для цен */\\n  --font-size-price: 16px;\\n  --line-height-price: calc(1em);\\n\\n  /* Размер шрифта и межстрочное расстояние для текста объявления */\\n  --font-size-desc: 16px;\\n  --line-height-desc: calc(1em + 4px);\\n\\n  /* Размер шрифта и межстрочное расстояние для ссылки */\\n  --font-size-domain: 14px;\\n  --line-height-domain: 18px;\\n\\n  /* Размер шрифта и межстрочное расстояние для названия приложения \\n     (для РМП) */\\n  --font-size-app-name: 14px;\\n  --line-height-app-name: calc(1em + 2px);\\n\\n\\n  width: 100%;\\n  margin: 0 auto;\\n\\n  height: auto;\\n  padding: 0;\\n  overflow: visible;\\n}\\n\\n/* Специальные переменные для Рекламы Мобильных Приложений */\\n.ya-unit-item-rmp {\\n  /* Цвет текста ссылки */\\n  --color-text-domain: var(--color-blue);\\n  /* Цвет текста ссылки при наведении */\\n  --color-text-domain-hover: var(--color-blue-dark);\\n  /* Цвет фона кнопки объявления.\\n     Не применимо если, кнопки не предусмотрено (для маленьких форматов) */\\n  --color-background-domain: var(--color-blue-transparent);\\n  /* Цвет фона кнопки объявления при наведении */\\n  --color-background-domain-hover: var(--color-blue-dark-transparent);\\n}\\n\\n\\n/* Специальные значения для размеров экрана шире 800px */\\n@media screen and (min-width: 800px) {\\n  .ya-container {\\n    /* Здесь прописываются отдельные значения переменных \\n       для отображения рекламы в окнах браузера шире 800px */\\n  }\\n}\\n\\n\\n\\n\\n\\n/* -------- Далее — настройка стилей объявления. -------- */\\n/* -------- Не рекомендуется редактировать -------- */\\n\\n.ya-units-grid {\\n  margin: 0px auto;\\n}\\n\\n.grid-row {\\n  justify-content: var(--banners-justify-content);\\n  align-content: var(--banners-align-content);\\n  padding: 0px 0;\\n}\\n\\n.grid-item {\\n  width: var(--banner-width);\\n  min-width: var(--banner-min-width);\\n  max-width: var(--banner-max-width);\\n  \\n  min-height: var(--banner-min-height);\\n  max-height: var(--banner-max-height);\\n\\n  font-family: var(--font-family);\\n  background: var(--banner-background);\\n  border: var(--banner-stroke);\\n\\n  margin: var(--banner-margin, inherit);\\n  border-radius: var(--banner-outer-border-radius);\\n  overflow: hidden;\\n  box-sizing: border-box;\\n  flex: var(--banner-flex);\\n  box-shadow: var(--banner-shadow);\\n  transform: none;\\n  transition: var(--banner-transition);\\n}\\n\\n.grid-item:hover {\\n  transform: var(--banner-transform-hover);\\n  box-shadow: var(--banner-shadow-hover);\\n  background: var(--banner-background-hover);\\n  --color-text-domain: var(--color-text-domain-hover);\\n}\\n\\n.grid-item:first-child {\\n  margin-left: var(--banners-grid-first-item-left-margin);\\n}\\n\\n.grid-item:last-child {\\n  margin-right: var(--banners-grid-first-item-right-margin);\\n}\\n\\n.grid-row:first-child .grid-item {\\n  margin-top: var(--banners-grid-first-item-top-margin);\\n}\\n\\n.grid-row:last-child .grid-item {\\n  margin-bottom: var(--banners-grid-first-item-bottom-margin);\\n}\\n\\n.unit-wrapper {\\n  height: 100%;\\n}\\n\\n.ya-unit-favicon {\\n  display: block !important;\\n}\\n\\na.yrw-url {\\n  color: inherit;\\n  cursor: pointer;\\n}\\n\\n.unit-misc {\\n  position: absolute;\\n  top: 0;\\n  left: 0;\\n  width: 100%;\\n  height: 100%;\\n}\\n\\n.unit-meta {\\n  position: absolute;\\n  top: 10px;\\n  left: var(--banner-padding-outer);\\n  z-index: 2;\\n  padding: 0px 4px 0px;\\n  text-transform: uppercase;\\n  height: 12px;\\n  background: transparent;\\n  color: var(--color-grey);\\n  border-radius: 4px;\\n  font-size: 8px;\\n  line-height: 13px;\\n  font-weight: 500;\\n  letter-spacing: 0.12em;\\n  vertical-align: 5px;\\n  margin: 0;\\n  user-select: none;\\n  -ms-user-select: none;\\n  -moz-user-select: none;\\n  -khtml-user-select: none;\\n  -webkit-user-select: none;\\n}\\n\\n.ya-unit-item-rmp .unit-meta {\\n  background: transparent;\\n}\\n\\n.unit-age::before {\\n  content: \\\" | \\\";\\n}\\n\\n.unit-age:empty {\\n  display: none;\\n}\\n\\n.ya-unit-kebab_button svg circle {\\n  fill: var(--color-grey);\\n}\\n\\n.ya-unit-kebab_bg {\\n  background: transparent;\\n  opacity: 1.0;\\n}\\n\\n.ya-unit-kebab_icon {\\n  filter: var(--display-image, none);\\n}\\n\\n.ya-unit-kebab_icon circle {\\n  fill: var(--color-grey) !important;\\n}\\n\\n.ya-unit-kebab_button {\\n  position: absolute;\\n  z-index: 940;\\n  top: 4px;\\n  right: 4px;\\n  width: 24px;\\n  height: 24px;\\n}\\n\\n.yrw-body_warning {\\n  position: relative;\\n}\\n\\n.yrw-body_warning div {\\n  padding: 0;\\n}\\n\\n.yrw-body_warning div:not(.yrw-warning-wrapper):not(.yrw-warning-text) {\\n  position: relative;\\n  background-color: var(--color-light-alt);\\n  color: #575c66;\\n  display: flex;\\n  padding: 0 calc(var(--inner-border-radius) / 2);\\n}\\n\\n.yrw-body_warning div text {\\n  fill: #575c66;\\n}\\n\\n.yrw-body_warning div:not(.yrw-warning-wrapper) {\\n  padding: 0 calc(var(--inner-border-radius) / 2 + 4px);\\n}\\n\\n.yrw-warning-text {\\n  text-shadow: none;\\n}\\n\\n\\n\\n.unit-container {\\n  box-sizing: border-box;\\n  position: relative;\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: flex-end;\\n  overflow: hidden;\\n  max-width: var(--max-content-width, --banner-max-width, 960px);\\n  margin: auto;\\n}\\n\\n.unit-content {\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: flex-start;\\n  position: relative;\\n  height: 100%;\\n  padding: 8px;\\n  padding: var(--banner-padding-outer);\\n  padding-top: 32px;\\n}\\n\\n.unit-text-content {\\n  display: flex;\\n  justify-content: flex-start;\\n  flex-direction: column;\\n  position: relative;\\n  flex: auto;\\n}\\n\\n.rmp-app-content {\\n  display: flex;\\n  flex-direction: row;\\n}\\n\\n.rmp-text-content {\\n  display: flex;\\n  justify-content: center;\\n  flex-direction: column;\\n}\\n\\n.unit-text-content > div {\\n  margin-top: var(--banner-padding-inner);\\n}\\n\\n.rmp-text-content > div {\\n  margin-top: calc(var(--banner-padding-inner) / 2);\\n}\\n\\n.rmp-text-content > div:first-child {\\n  margin-top: 0;\\n}\\n\\n\\n\\n.ya-unit-title, .unit-title {\\n  color: var(--color-text-header);\\n  font-size: var(--font-size-title);\\n  line-height: var(--line-height-title);\\n  font-weight: 600;\\n  display: flex;\\n}\\n\\n.title-short {\\n  font-size: var(--font-size-title-short);\\n  line-height: var(--line-height-title-short);\\n}\\n\\n.title-mid {\\n  font-size: var(--font-size-title-mid);\\n  line-height: var(--line-height-title-mid);\\n}\\n\\n.title-long {\\n  font-size: var(--font-size-title-long);\\n  line-height: var(--line-height-title-long);\\n}\\n\\n.title-rmp {\\n  font-size: var(--font-size-title-rmp);\\n  line-height: var(--line-height-title-rmp);\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: center;\\n}\\n\\n.unit-app-name {\\n  font-size: var(--font-size-app-name);\\n  line-height: var(--line-height-app-name);\\n  color: var(--color-text-app-name);\\n}\\n\\n.unit-cta {\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: center;\\n\\n  box-sizing: border-box;\\n  padding: 8px 8px;\\n  font-size: var(--domain-font-size);\\n  line-height: var(--domain-line-height);\\n  text-align: center;\\n\\n  color: var(--color-cta-color);\\n  background-color: var(--color-background-domain);\\n  border-radius: var(--banner-inner-border-radius);\\n  margin-top: var(--banner-padding-inner);\\n  transition: var(--cta-transition);\\n}\\n\\n.unit-cta:hover {\\n  color: var(--color-cta-hover-color);\\n  background-color: var(--color-background-domain-hover);\\n}\\n\\n.unit-favicon {\\n  width: var(--line-height-domain);\\n  background-color: transparent;\\n  border-radius: 3px;\\n  align-self: center;\\n  display: var(--display-favicon, inline);\\n}\\n\\n.ya-unit-favicon {\\n  width: var(--line-height-domain);\\n  height: var(--line-height-domain);\\n}\\n\\n.ya-unit-rating {\\n  margin-right: 4px;\\n  height: 16px;\\n  display: inline;\\n}\\n\\n.ya-unit-review-count {\\n  display: var(--display-rmp-rating-count);\\n  transform: translateY(1px);\\n  color: var(--color-grey-alt);\\n  font-size: 13px;\\n  line-height: 16px;\\n}\\n\\n.unit-favicon:empty,\\n.ya-unit-domain:empty,\\n.unit-domain:empty {\\n  display: none;\\n}\\n\\n.unit-domain {\\n  display: flex;\\n  margin-right: auto;\\n  border-radius: 4px;\\n\\n  color: var(--color-text-domain);\\n  font-size: var(--font-size-domain);\\n  line-height: var(--line-height-domain);\\n  padding: 0;\\n  width: 100%;\\n  height: var(--line-height-domain, 16px);\\n  flex-direction: row;\\n  flex-wrap: wrap;\\n  justify-content: center;\\n  align-content: flex-end;\\n  overflow: hidden;\\n}\\n\\n.unit-domain > *,\\n.unit-domain .unit-domain-no-wrap > * {\\n  margin-right: calc(var(--line-height-domain) / 3.5);\\n}\\n\\n.unit-domain span {\\n  flex: none;\\n}\\n\\n.unit-domain-no-wrap {\\n  display: flex;\\n}\\n\\n\\n\\n.unit-app-rating {\\n  display: flex;\\n  flex-direction: row;\\n  align-content: center;\\n}\\n\\n.unit-prices {\\n  display: var(--display-price, inline);\\n  white-space: nowrap;\\n  font-size: var(--font-size-price);\\n  line-height: var(--line-height-price);\\n}\\n\\n.ya-unit-price {\\n  color: var(--color-text-price);\\n  font-weight: 600;\\n  display: inline;\\n  white-space: nowrap;\\n}\\n\\n.ya-unit-old-price {\\n  margin-left: 8px;\\n  font-size: max(0.9em, 12px);\\n  line-height: max(0.9em, 12px);\\n  color: var(--color-grey-alt);\\n  position: relative;\\n  white-space: nowrap;\\n  display: inline;\\n}\\n\\n.ya-unit-old-price::after {\\n  content: \\\"\\\";\\n  position: absolute;\\n  bottom: 0;\\n  left: 0;\\n  width: 100%;\\n  height: 100%;\\n  \\n  background-image: url(\\\"data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='100%' height='100%'><line class='line' x1='0' y1='65%' x2='100%' y2='50%' stroke='%23A3ACBF' stroke-width='8vh' /></svg>\\\");\\n  background-repeat: no-repeat;\\n}\\n\\n.unit-desc {\\n  display: var(--display-desc);\\n  color: var(--color-text-desc);\\n  font-size: var(--font-size-desc);\\n  line-height: var(--line-height-desc);\\n}\\n\\n\\n\\n\\n\\n\\n.unit-image-block {\\n  display: var(--display-image);\\n  width: 100%;\\n  max-width: var(--image-max-width, none);\\n  height: var(--image-height);\\n  flex: auto;\\n  border-radius: var(--banner-inner-border-radius);\\n  position: relative;\\n  box-sizing: border-box;\\n  background-color: var(--color-light-alt);\\n  overflow: hidden;\\n}\\n\\n.unit-image {\\n  width: 100%;\\n  height: 100%;\\n  display: var(--display-image);\\n  position: relative;\\n}\\n\\n.video-source-container {\\n  border-radius: var(--banner-inner-border-radius, 8px);\\n  z-index: 1;\\n  overflow: hidden;\\n}\\n\\n.ya-unit-app-icon {\\n  position: relative;\\n  border-radius: calc(var(--app-icon-size) / 4);\\n  margin-right: var(--banner-padding-inner);\\n  display: flex;\\n}\\n\\n.unit-app-icon {\\n  margin: auto;\\n}\\n\\n.ya-unit-app-icon .yrw-img-component {\\n  width: var(--app-icon-size);\\n  height: var(--app-icon-size);\\n}\\n\\n.ya-unit-image {\\n  height: 100%;\\n}\\n\\n.yrw-img-component {\\n  height: 100%;\\n  padding-bottom: 0;\\n}\\n\\n.unit-image .img-source-component {\\n  border-radius: var(--banner-inner-border-radius);\\n  background-image: url(\\\"data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='256' height='256'><rect x='80' y='80' width='96' height='96' rx='19.2' fill='%23405580' fill-opacity='0.15'/><path d='M144.619 110.181H147.619C147.619 108.524 146.276 107.181 144.619 107.181V110.181ZM111.102 147.94L146.74 112.302L142.498 108.06L106.86 143.698L111.102 147.94ZM114.072 113.181H144.619V107.181L114.072 107.181V113.181ZM141.619 110.181V140.728H147.619V110.181L141.619 110.181Z' fill='white'/></svg>\\\");\\n  background-position: center;\\n}\\n\\n.ya-unit-app-icon .img-source-component {\\n  border-radius: calc(var(--app-icon-size) / 4 - 4px);\\n}\\n\\n.ya-clamp {\\n  width: 100%;\\n}\\n\\n.yrw-content {\\n  overflow: visible;\\n}\\n\\n.ya-grid-template:empty {\\n  display: none;\\n}\",\"gridColumns\":\"3\",\"gridRows\":\"1\",\"defaultWidth\":\"800\",\"defaultHeight\":\"320\",\"props\":{}},{\"value\":\"14\",\"label\":\"Десктопный сингл фиксированного размера\",\"template\":\"<ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n\\n  <div class=\\\"unit-misc\\\">\\n    <ya-unit-kebab class=\\\"ya-unit-kebab_dark\\\" />\\n    <div class=\\\"unit-meta\\\">\\n      <ya-unit-category class=\\\"unit-category\\\" />\\n      <ya-unit-age class=\\\"unit-age\\\" />\\n    </div>\\n  </div>\\n\\n\\n\\n  <div class=\\\"unit-content\\\">\\n\\n    <div class=\\\"unit-image-block\\\">\\n      <ya-unit-image/>\\n    </div>\\n\\n    <div class=\\\"unit-text-content\\\" data-cols=\\\"1\\\" data-rows=\\\"1\\\">\\n\\n      <div class=\\\"unit-title\\\">\\n        <ya-unit-if condition=\\\"unit.title < 22\\\">\\n          <ya-clamp lines=\\\"4\\\" class=\\\"title-short\\\"><ya-unit-title /></ya-clamp>\\n        </ya-unit-if>\\n\\n        <ya-unit-if condition=\\\"unit.title > 21 & unit.title < 33\\\">\\n          <ya-clamp lines=\\\"4\\\" class=\\\"title-mid\\\"><ya-unit-title /></ya-clamp>\\n        </ya-unit-if>\\n\\n        <ya-unit-if condition=\\\"unit.title > 32\\\">\\n          <ya-clamp lines=\\\"4\\\" class=\\\"title-long\\\"><ya-unit-title /></ya-clamp>\\n        </ya-unit-if>\\n      </div>\\n\\n      <!-- Начало Шаблона ТГО -->\\n      <ya-unit-if condition=\\\"!unit.isRmp\\\">\\n\\n        <div class=\\\"unit-prices\\\"><ya-unit-price /><ya-unit-old-price /></div>\\n  \\n        <ya-clamp lines=\\\"4\\\" class=\\\"unit-desc\\\"><ya-unit-desc /></ya-clamp>\\n\\n\\n      </ya-unit-if>\\n      <!-- Конец Шаблона ТГО -->\\n\\n\\n    \\n      <!-- Начало Шаблона РМП -->\\n      <ya-unit-if condition=\\\"unit.isRmp\\\">\\n\\n        <div class=\\\"rmp-app-content\\\">\\n          <ya-unit-app-icon />\\n\\n          <div class=\\\"rmp-text-content\\\">\\n\\n            <div class=\\\"unit-app-name\\\">\\n              <ya-clamp lines=\\\"2\\\">\\n                <ya-unit-app-name />\\n              </ya-clamp>\\n            </div>\\n\\n            <div class=\\\"unit-app-rating\\\">\\n              <ya-unit-rating />\\n              <ya-unit-review-count />\\n            </div>\\n          </div>\\n\\n        </div>\\n\\n      </ya-unit-if>\\n      <!-- Конец Шаблона РМП -->\\n\\n    </div>\\n\\n    <div class=\\\"unit-cta\\\">\\n      <div class=\\\"unit-domain\\\">\\n        <ya-unit-mobile-app-button />\\n        <ya-unit-if condition=\\\"!unit.isRmp\\\">\\n          <span class=\\\"unit-domain-no-wrap\\\">\\n            <span class=\\\"unit-favicon\\\"><ya-unit-favicon size=\\\"32\\\"/></span>\\n            <ya-unit-domain class=\\\"domain\\\"/>\\n          </span>\\n        </ya-unit-if>\\n        \\n      </div>\\n    </div>\\n\\n  </div>\\n\\n</ya-units-grid>\",\"css\":\"/* Шаблон 6 (single): Десктопный сингл фиксированного размера\\n   300px x 600px. Для использования в сайдбаре */\\n\\n\\n/* Шаблоны не работают в браузерах IE 11 версии и ниже */\\n\\n/* РМП — Реклама Мобильных Приложений */\\n\\n\\n/* -------- Переменные цветов -------- */\\n/* Изменив значение цвета в переменной, оно одновременно\\n   изменится во всех элементах шаблона, где указано */\\n.ya-container {\\n\\n  --color-blue: #3377FF;\\n  --color-blue-dark: #0055FF;\\n\\n  --color-blue-transparent: #3377FF1A;\\n  --color-blue-dark-transparent: #0055FF1A;\\n\\n  --color-black: #232526;\\n  --color-grey: #575c66;\\n  --color-grey-alt: #A3ACBF;\\n  --color-light: #f4f4f6;\\n  --color-light-alt: #ececef;\\n}\\n\\n/* Переменные цветов для устройств с поддержкой \\n   цветового профиля Display P3 (устройства Apple) */\\n\\n/* Устройства Apple поддерживают цветовой профиль \\n   с более яркими цветами (цветовой профиль Display P3). \\n   Если вы хотите поддержать его, то следует поменять \\n   значения цветов в блоке ниже */\\n@supports (color: color(display-p3)) {\\n  .ya-container {\\n    --color-blue: color(display-p3 0.2 0.47 1.0);\\n    --color-blue-dark: color(display-p3 0.0 0.33 1.0);\\n\\n    --color-blue-transparent: color(display-p3 0.2 0.47 1.0 / 0.1);\\n    --color-blue-dark-transparent: color(display-p3 0.0 0.33 1.0 / 0.1);\\n\\n    --color-yellow: color(display-p3 1.0 0.8 0.2);\\n    --color-yellow-dark: color(display-p3 1.0 0.75 0.0);\\n  }\\n}\\n\\n\\n\\n/* -------- Переменные для отрисовки объявления -------- */\\n\\n.ya-container {\\n\\n  /* Размер объявления по ширине и высоте. */\\n  --adv-width: 300px;\\n  --adv-height: 600px;\\n\\n\\n  /* Отображение фавиконки: \\n     вкл - block, выкл - none; */\\n  --display-favicon: block;\\n  /* Отображение изображения: \\n     вкл - block, выкл - none; */\\n  --display-image: block;\\n  /* Отображение текста: \\n     вкл - block, выкл - none; */\\n  --display-desc: inline;\\n  /* Отображение цен: \\n     вкл - inline, выкл - none */\\n  --display-price: inline;\\n  /* Отображение количества отзывов (для РМП): \\n     вкл - inline, выкл - none */\\n  --display-rmp-rating-count: inline;\\n   \\n\\n  /* Максимальная ширина картинки */\\n  --image-max-width: 100%;\\n\\n  /* Максимальная высота картинки */\\n  --image-max-height: 320px;\\n\\n  /* Размер иконки приложения.\\n     Только для рекламы мобильных приложений */\\n  --app-icon-size: 64px;\\n\\n  /* Горизонтальное позиционирование сетки баннеров\\n     center - по середине, flex-start - слева,\\n     space-between - по всей ширине, space-around - по всей ширине с отступами\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/justify-content */\\n  --banners-justify-content: center;\\n\\n  /* Отступы вокруг объявления */\\n  --banner-margin: 0px;\\n  \\n  /* Отступы первых и последних объявлений от края \\n     по горизонтали и вертикали. Значение var(--banner-margin) \\n     повторяет общее значение отступов. \\n     ! Неприменимо для одиночных объявлений */\\n  --banners-grid-first-item-top-margin: 0;\\n  --banners-grid-first-item-left-margin: 0;\\n  --banners-grid-first-item-right-margin: 0;\\n  --banners-grid-first-item-bottom-margin: 0;\\n\\n  /* Цвет фона объявления. Пример: white или #f0f2f8;\\n     Допустимо использование переменных. См. начало документа */\\n  --banner-background: var(--color-light);\\n  /* Цвет фона при наведении на объявление */\\n  --banner-background-hover: var(--color-light-alt);\\n\\n  /* Обводка объявления. Для отключения укажите значение none\\n     Пример: solid 1px rgba(0 0 0 / 15%);\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/border */\\n  --banner-stroke: none;\\n  \\n  /* Тень объявления. Пример: 0px 8px 24px rgba(0, 21, 64, 0.125);\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/box-shadow */\\n  --banner-shadow: none;\\n  /* Тень объявления при наведении */\\n  --banner-shadow-hover: none;\\n  /* Трансформация объявления при наведении. Пример: translateY(-2px); */\\n  --banner-transform-hover: none;\\n  /* Анимация изменений при наведении */\\n  --banner-transition: box-shadow 120ms ease, transform 120ms ease;\\n\\n  /* Скругление углов объявления */\\n  --banner-outer-border-radius: 8px;\\n  /* Скругление углов внутренних элементов объявления (картинка, кнопки) */\\n  --banner-inner-border-radius: 8px;\\n  \\n  /* Отступы элементов от краев объявления */\\n  --banner-padding-outer: 10px;\\n  /* Отступы между элементами объявления */\\n  --banner-padding-inner: 10px;\\n\\n\\n  /* Цвет заголовка в объявлении */\\n  --color-text-header: var(--color-black); \\n  /* Цвет текста в объявлении */\\n  --color-text-desc: var(--color-grey-alt);\\n  /* Цвет цены в объявлении */\\n  --color-text-price: var(--color-black);\\n  /* Цвет ссылки в объявлении */\\n  --color-text-domain: var(--color-blue);\\n  /* Цвет ссылки в объявлении при наведении */\\n  --color-text-domain-hover: var(--color-blue-dark);\\n  /* Фон кнопки действия. Не применимо, если кнопка \\n     не предусмотрена в шаблоне (для форматов маленького размера) */\\n  --color-background-domain: var(--color-blue-transparent);\\n  /* Фон кнопки действия при наведении */\\n  --color-background-domain-hover: var(--color-blue-dark-transparent);\\n\\n  /* Цвет названия приложения в объявления (для РМП) */\\n  --color-text-app-name: var(--color-grey-alt);\\n\\n\\n  /* Цепочка используемых шрифтов в объявлении. По умолчанию указана \\n     цепочка системных шрифтов. Если шрифт не поддерживается, используется \\n     следующий по цепочке. При использовании собственного шрифта, \\n     следует указывать его название в самом начале */\\n  --font-family: \\n    -apple-system, BlinkMacSystemFont, \\\"Segoe UI\\\", Roboto, \\n    Oxygen, Ubuntu, Cantarell, \\\"Open Sans\\\", \\\"Helvetica Neue\\\", sans-serif, \\n    Apple Color Emoji, Segoe UI Emoji;\\n\\n  /* Размер шрифта и межстрочное расстояние для коротких заголовков\\n     (до 21 символа) */\\n  --font-size-title-short: 36px;\\n  --line-height-title-short: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для заголовков средней длины \\n     (от 22 до 31 символа) */\\n  --font-size-title-mid: 32px;\\n  --line-height-title-mid: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для длинных заголовков \\n     (от 32 символов) */\\n  --font-size-title-long: 28px;\\n  --line-height-title-long: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для цен */\\n  --font-size-price: 20px;\\n  --line-height-price: calc(1em + 4px);\\n\\n  /* Размер шрифта и межстрочное расстояние для текста объявления */\\n  --font-size-desc: 16px;\\n  --line-height-desc: calc(1em + 4px);\\n\\n  /* Размер шрифта и межстрочное расстояние для ссылки */\\n  --font-size-domain: 16px;\\n  --line-height-domain: 20px;\\n\\n  /* Размер шрифта и межстрочное расстояние для названия приложения \\n     (для РМП) */\\n  --font-size-app-name: 16px;\\n  --line-height-app-name: calc(1em + 4px);\\n\\n\\n\\n  width: 100%;\\n  margin: 0 auto;\\n\\n  height: auto;\\n  padding: 0;\\n  overflow: visible;\\n}\\n\\n/* Специальные переменные для Рекламы Мобильных Приложений */\\n.ya-unit-item-rmp {\\n  /* Цвет текста ссылки */\\n  --color-text-domain: var(--color-blue);\\n  /* Цвет текста ссылки при наведении */\\n  --color-text-domain-hover: var(--color-blue-dark);\\n  /* Цвет фона кнопки объявления.\\n     Не применимо если, кнопки не предусмотрено (для маленьких форматов) */\\n  --color-background-domain: var(--color-blue-transparent);\\n  /* Цвет фона кнопки объявления при наведении */\\n  --color-background-domain-hover: var(--color-blue-dark-transparent);\\n}\\n\\n\\n/* -------- Далее — настройка стилей объявления. -------- */\\n/* -------- Не рекомендуется редактировать -------- */\\n\\n.ya-units-grid {\\n  margin: 0px auto;\\n}\\n\\n.grid {\\n  width: var(--adv-width);\\n  min-height: var(--adv-height);\\n}\\n\\n.grid-row {\\n  justify-content: var(--banners-justify-content);\\n  align-content: var(--banners-align-content);\\n  padding: 0px 0;\\n  flex: auto;\\n}\\n\\n.grid-item {\\n  width: 100%;\\n  font-family: var(--font-family);\\n  background: var(--banner-background);\\n  border: var(--banner-stroke);\\n\\n  margin: var(--banner-margin, inherit);\\n  border-radius: var(--banner-outer-border-radius);\\n  overflow: hidden;\\n  box-sizing: border-box;\\n  flex: auto;\\n  box-shadow: var(--banner-shadow);\\n  transform: none;\\n  transition: var(--banner-transition);\\n}\\n\\n.grid-item:hover {\\n  transform: var(--banner-transform-hover);\\n  box-shadow: var(--banner-shadow-hover);\\n  background: var(--banner-background-hover);\\n  --color-text-domain: var(--color-text-domain-hover);\\n}\\n\\n.grid-item:first-child {\\n  margin-left: var(--banners-grid-first-item-left-margin);\\n}\\n\\n.grid-item:last-child {\\n  margin-right: var(--banners-grid-first-item-right-margin);\\n}\\n\\n.grid-row:first-child .grid-item {\\n  margin-top: var(--banners-grid-first-item-top-margin);\\n}\\n\\n.grid-row:last-child .grid-item {\\n  margin-bottom: var(--banners-grid-first-item-bottom-margin);\\n}\\n\\n.unit-wrapper {\\n  height: 100%;\\n}\\n\\n.ya-unit-favicon {\\n  display: block !important;\\n}\\n\\na.yrw-url {\\n  color: inherit;\\n  cursor: pointer;\\n}\\n\\n.unit-misc {\\n  position: absolute;\\n  top: 0;\\n  left: 0;\\n  width: 100%;\\n  height: 100%;\\n}\\n\\n.unit-meta {\\n  position: absolute;\\n  top: 10px;\\n  left: var(--banner-padding-outer);\\n  z-index: 2;\\n  padding: 0px 4px 0px;\\n  text-transform: uppercase;\\n  height: 12px;\\n  background: transparent;\\n  color: var(--color-grey);\\n  border-radius: 4px;\\n  font-size: 8px;\\n  line-height: 13px;\\n  font-weight: 500;\\n  letter-spacing: 0.12em;\\n  vertical-align: 5px;\\n  margin: 0;\\n  user-select: none;\\n  -ms-user-select: none;\\n  -moz-user-select: none;\\n  -khtml-user-select: none;\\n  -webkit-user-select: none;\\n}\\n\\n.ya-unit-item-rmp .unit-meta {\\n  background: transparent;\\n}\\n\\n.unit-age::before {\\n  content: \\\" | \\\";\\n}\\n\\n.unit-age:empty {\\n  display: none;\\n}\\n\\n.ya-unit-kebab_button svg circle {\\n  fill: var(--color-grey);\\n}\\n\\n.ya-unit-kebab_bg {\\n  background: transparent;\\n  opacity: 1.0;\\n}\\n\\n.ya-unit-kebab_icon {\\n  filter: var(--display-image, none);\\n}\\n\\n.ya-unit-kebab_icon circle {\\n  fill: var(--color-grey) !important;\\n}\\n\\n.ya-unit-kebab_button {\\n  position: absolute;\\n  z-index: 940;\\n  top: 4px;\\n  right: 4px;\\n  width: 24px;\\n  height: 24px;\\n}\\n\\n.yrw-body_warning {\\n  position: relative;\\n}\\n\\n.yrw-body_warning div {\\n  padding: 0;\\n}\\n\\n.yrw-body_warning div:not(.yrw-warning-wrapper):not(.yrw-warning-text) {\\n  position: relative;\\n  background-color: var(--color-light-alt);\\n  color: #575c66;\\n  display: flex;\\n  padding: 0 calc(var(--inner-border-radius) / 2);\\n}\\n\\n.yrw-body_warning div text {\\n  fill: #575c66;\\n}\\n\\n.yrw-body_warning div:not(.yrw-warning-wrapper) {\\n  padding: 0 calc(var(--inner-border-radius) / 2 + 4px);\\n}\\n\\n.yrw-warning-text {\\n  text-shadow: none;\\n}\\n\\n\\n\\n.unit-container {\\n  box-sizing: border-box;\\n  position: relative;\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: flex-end;\\n  overflow: hidden;\\n  max-width: var(--max-content-width, --banner-max-width, 960px);\\n  margin: auto;\\n}\\n\\n.unit-content {\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: flex-start;\\n  position: relative;\\n  height: 100%;\\n  padding: 8px;\\n  padding: var(--banner-padding-outer);\\n  padding-top: 32px;\\n}\\n\\n.unit-text-content {\\n  display: flex;\\n  justify-content: flex-start;\\n  flex-direction: column;\\n  position: relative;\\n  flex: auto;\\n}\\n\\n.rmp-app-content {\\n  display: flex;\\n  flex-direction: row;\\n}\\n\\n.rmp-text-content {\\n  display: flex;\\n  justify-content: center;\\n  flex-direction: column;\\n}\\n\\n.unit-text-content > div {\\n  margin-top: var(--banner-padding-inner);\\n}\\n\\n.rmp-text-content > div {\\n  margin-top: calc(var(--banner-padding-inner) / 2);\\n}\\n\\n.rmp-text-content > div:first-child {\\n  margin-top: 0;\\n}\\n\\n\\n\\n.ya-unit-title, .unit-title {\\n  color: var(--color-text-header);\\n  font-size: var(--font-size-title);\\n  line-height: var(--line-height-title);\\n  font-weight: 600;\\n  display: flex;\\n}\\n\\n.title-short {\\n  font-size: var(--font-size-title-short);\\n  line-height: var(--line-height-title-short);\\n}\\n\\n.title-mid {\\n  font-size: var(--font-size-title-mid);\\n  line-height: var(--line-height-title-mid);\\n}\\n\\n.title-long {\\n  font-size: var(--font-size-title-long);\\n  line-height: var(--line-height-title-long);\\n}\\n\\n.title-rmp {\\n  font-size: var(--font-size-title-rmp);\\n  line-height: var(--line-height-title-rmp);\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: center;\\n}\\n\\n.unit-app-name {\\n  font-size: var(--font-size-app-name);\\n  line-height: var(--line-height-app-name);\\n  color: var(--color-text-app-name);\\n}\\n\\n.unit-cta {\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: center;\\n  box-sizing: border-box;\\n  padding: 12px;\\n\\n  font-size: var(--domain-font-size);\\n  line-height: var(--domain-line-height);\\n  text-align: center;\\n  color: var(--color-cta-color);\\n  background-color: var(--color-background-domain);\\n  border-radius: var(--banner-inner-border-radius);\\n  margin-top: var(--banner-padding-inner);\\n  transition: var(--cta-transition);\\n}\\n\\n.unit-cta:hover {\\n  color: var(--color-cta-hover-color);\\n  background-color: var(--color-background-domain-hover);\\n}\\n\\n.unit-favicon {\\n  width: var(--line-height-domain);\\n  background-color: transparent;\\n  border-radius: 3px;\\n  align-self: center;\\n  display: var(--display-favicon, inline);\\n}\\n\\n.ya-unit-favicon {\\n  width: var(--line-height-domain);\\n  height: var(--line-height-domain);\\n}\\n\\n.ya-unit-rating {\\n  margin-right: 4px;\\n  height: 16px;\\n  display: inline;\\n}\\n\\n.ya-unit-review-count {\\n  display: var(--display-rmp-rating-count);\\n  transform: translateY(1px);\\n  color: var(--color-grey-alt);\\n  font-size: 13px;\\n  line-height: 16px;\\n}\\n\\n.unit-favicon:empty,\\n.ya-unit-domain:empty,\\n.unit-domain:empty {\\n  display: none;\\n}\\n\\n.unit-domain {\\n  display: flex;\\n  margin-right: auto;\\n  border-radius: 4px;\\n\\n  color: var(--color-text-domain);\\n  font-size: var(--font-size-domain);\\n  line-height: var(--line-height-domain);\\n  padding: 0;\\n  width: 100%;\\n  height: var(--line-height-domain, 16px);\\n  flex-direction: row;\\n  flex-wrap: wrap;\\n  justify-content: center;\\n  align-content: flex-end;\\n  overflow: hidden;\\n}\\n\\n.unit-domain > *,\\n.unit-domain .unit-domain-no-wrap > * {\\n  margin-right: calc(var(--line-height-domain) / 3.5);\\n}\\n\\n.unit-domain span {\\n  flex: none;\\n}\\n\\n.unit-domain-no-wrap {\\n  display: flex;\\n}\\n\\n\\n\\n.unit-app-rating {\\n  display: flex;\\n  flex-direction: row;\\n  align-content: center;\\n}\\n\\n.unit-prices {\\n  display: var(--display-price, inline);\\n  white-space: nowrap;\\n  font-size: var(--font-size-price);\\n  line-height: var(--line-height-price);\\n}\\n\\n.ya-unit-price {\\n  color: var(--color-text-price);\\n  font-weight: 600;\\n  display: inline;\\n  white-space: nowrap;\\n}\\n\\n.ya-unit-old-price {\\n  margin-left: 8px;\\n  font-size: max(0.9em, 12px);\\n  line-height: max(0.9em, 12px);\\n  color: var(--color-grey-alt);\\n  position: relative;\\n  white-space: nowrap;\\n  display: inline;\\n}\\n\\n.ya-unit-old-price::after {\\n  content: \\\"\\\";\\n  position: absolute;\\n  bottom: 0;\\n  left: 0;\\n  width: 100%;\\n  height: 100%;\\n  \\n  background-image: url(\\\"data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='100%' height='100%'><line class='line' x1='0' y1='65%' x2='100%' y2='50%' stroke='%23A3ACBF' stroke-width='8vh' /></svg>\\\");\\n  background-repeat: no-repeat;\\n}\\n\\n.unit-desc {\\n  display: var(--display-desc);\\n  color: var(--color-text-desc);\\n  font-size: var(--font-size-desc);\\n  line-height: var(--line-height-desc);\\n}\\n\\n\\n\\n.unit-image-block {\\n  display: var(--display-image);\\n  width: 100%;\\n  max-width: var(--image-max-width, none);\\n  height: 100%;\\n  max-height: var(--image-max-height);\\n  flex: auto;\\n  border-radius: var(--banner-inner-border-radius);\\n  position: relative;\\n  box-sizing: border-box;\\n  background-color: var(--color-light-alt);\\n  overflow: hidden;\\n}\\n\\n.unit-image {\\n  width: 100%;\\n  height: 100%;\\n  display: var(--display-image);\\n  position: relative;\\n}\\n\\n.video-source-container {\\n  border-radius: var(--banner-inner-border-radius, 8px);\\n  z-index: 1;\\n  overflow: hidden;\\n}\\n\\n.ya-unit-app-icon {\\n  position: relative;\\n  border-radius: calc(var(--app-icon-size) / 4);\\n  margin-right: var(--banner-padding-inner);\\n  display: flex;\\n}\\n\\n.unit-app-icon {\\n  margin: auto;\\n}\\n\\n.ya-unit-app-icon .yrw-img-component {\\n  width: var(--app-icon-size);\\n  height: var(--app-icon-size);\\n}\\n\\n.ya-unit-image {\\n  height: 100%;\\n}\\n\\n.yrw-img-component {\\n  height: 100%;\\n  padding-bottom: 0;\\n}\\n\\n.unit-image .img-source-component {\\n  border-radius: var(--banner-inner-border-radius);\\n  background-image: url(\\\"data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='256' height='256'><rect x='80' y='80' width='96' height='96' rx='19.2' fill='%23405580' fill-opacity='0.15'/><path d='M144.619 110.181H147.619C147.619 108.524 146.276 107.181 144.619 107.181V110.181ZM111.102 147.94L146.74 112.302L142.498 108.06L106.86 143.698L111.102 147.94ZM114.072 113.181H144.619V107.181L114.072 107.181V113.181ZM141.619 110.181V140.728H147.619V110.181L141.619 110.181Z' fill='white'/></svg>\\\");\\n  background-position: center;\\n}\\n\\n.ya-unit-app-icon .img-source-component {\\n  border-radius: calc(var(--app-icon-size) / 4 - 4px);\\n}\\n\\n.ya-clamp {\\n  width: 100%;\\n}\\n\\n.yrw-content {\\n  overflow: visible;\\n}\\n\\n.ya-grid-template:empty {\\n  display: none;\\n}\",\"gridColumns\":\"1\",\"gridRows\":\"1\",\"defaultWidth\":\"300\",\"defaultHeight\":\"600\",\"props\":{}},{\"value\":\"16\",\"label\":\"Десктопный дабл фиксированного размера\",\"template\":\"<ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n\\n  <div class=\\\"unit-misc\\\">\\n    <ya-unit-kebab class=\\\"ya-unit-kebab_dark\\\" />\\n    <div class=\\\"unit-meta\\\">\\n      <ya-unit-category class=\\\"unit-category\\\" />\\n      <ya-unit-age class=\\\"unit-age\\\" />\\n    </div>\\n  </div>\\n\\n\\n\\n  <div class=\\\"unit-content\\\">\\n\\n    <div class=\\\"unit-image-block\\\">\\n      <ya-unit-image/>\\n    </div>\\n\\n    <div class=\\\"unit-text-content\\\" data-cols=\\\"1\\\" data-rows=\\\"1\\\">\\n\\n      <div class=\\\"unit-title\\\">\\n        <ya-unit-if condition=\\\"unit.title < 22\\\">\\n          <ya-clamp lines=\\\"3\\\" class=\\\"title-short\\\"><ya-unit-title /></ya-clamp>\\n        </ya-unit-if>\\n\\n        <ya-unit-if condition=\\\"unit.title > 21 & unit.title < 33\\\">\\n          <ya-clamp lines=\\\"3\\\" class=\\\"title-mid\\\"><ya-unit-title /></ya-clamp>\\n        </ya-unit-if>\\n\\n        <ya-unit-if condition=\\\"unit.title > 32\\\">\\n          <ya-clamp lines=\\\"3\\\" class=\\\"title-long\\\"><ya-unit-title /></ya-clamp>\\n        </ya-unit-if>\\n      </div>\\n\\n      <!-- Начало Шаблона ТГО -->\\n      <ya-unit-if condition=\\\"!unit.isRmp\\\">\\n\\n        <div class=\\\"unit-prices\\\"><ya-unit-price /><ya-unit-old-price /></div>\\n  \\n        <ya-clamp lines=\\\"2\\\" class=\\\"unit-desc\\\"><ya-unit-desc /></ya-clamp>\\n\\n\\n      </ya-unit-if>\\n      <!-- Конец Шаблона ТГО -->\\n\\n\\n    \\n      <!-- Начало Шаблона РМП -->\\n      <ya-unit-if condition=\\\"unit.isRmp\\\">\\n\\n        <div class=\\\"rmp-app-content\\\">\\n          <ya-unit-app-icon />\\n\\n          <div class=\\\"rmp-text-content\\\">\\n\\n            <div class=\\\"unit-app-name\\\">\\n              <ya-clamp lines=\\\"1\\\">\\n                <ya-unit-app-name />\\n              </ya-clamp>\\n            </div>\\n\\n            <div class=\\\"unit-app-rating\\\">\\n              <ya-unit-rating />\\n              <ya-unit-review-count />\\n            </div>\\n          </div>\\n\\n        </div>\\n\\n      </ya-unit-if>\\n      <!-- Конец Шаблона РМП -->\\n\\n    </div>\\n\\n    <div class=\\\"unit-cta\\\">\\n      <div class=\\\"unit-domain\\\">\\n        <ya-unit-mobile-app-button />\\n        <ya-unit-if condition=\\\"!unit.isRmp\\\">\\n          <span class=\\\"unit-domain-no-wrap\\\">\\n            <span class=\\\"unit-favicon\\\"><ya-unit-favicon size=\\\"32\\\"/></span>\\n            <ya-unit-domain class=\\\"domain\\\"/>\\n          </span>\\n        </ya-unit-if>\\n        \\n      </div>\\n    </div>\\n\\n  </div>\\n\\n</ya-units-grid>\",\"css\":\"/* Шаблон 7 (double): Десктопный дабл фиксированного размера\\n   300px x 600px. Для использования в сайдбаре */\\n\\n\\n/* Шаблоны не работают в браузерах IE 11 версии и ниже */\\n\\n/* РМП — Реклама Мобильных Приложений */\\n\\n\\n/* -------- Переменные цветов -------- */\\n/* Изменив значение цвета в переменной, оно одновременно\\n   изменится во всех элементах шаблона, где указано */\\n.ya-container {\\n\\n  --color-blue: #3377FF;\\n  --color-blue-dark: #0055FF;\\n\\n  --color-blue-transparent: #3377FF1A;\\n  --color-blue-dark-transparent: #0055FF1A;\\n\\n  --color-black: #232526;\\n  --color-grey: #575c66;\\n  --color-grey-alt: #A3ACBF;\\n  --color-light: #f4f4f6;\\n  --color-light-alt: #ececef;\\n}\\n\\n/* Переменные цветов для устройств с поддержкой \\n   цветового профиля Display P3 (устройства Apple) */\\n\\n/* Устройства Apple поддерживают цветовой профиль \\n   с более яркими цветами (цветовой профиль Display P3). \\n   Если вы хотите поддержать его, то следует поменять \\n   значения цветов в блоке ниже */\\n@supports (color: color(display-p3)) {\\n  .ya-container {\\n    --color-blue: color(display-p3 0.2 0.47 1.0);\\n    --color-blue-dark: color(display-p3 0.0 0.33 1.0);\\n\\n    --color-blue-transparent: color(display-p3 0.2 0.47 1.0 / 0.1);\\n    --color-blue-dark-transparent: color(display-p3 0.0 0.33 1.0 / 0.1);\\n\\n    --color-yellow: color(display-p3 1.0 0.8 0.2);\\n    --color-yellow-dark: color(display-p3 1.0 0.75 0.0);\\n  }\\n}\\n\\n\\n\\n/* -------- Переменные для отрисовки объявления -------- */\\n\\n.ya-container {\\n\\n    /* Размер объявления по ширине и высоте. */\\n  --adv-width: 300px;\\n  --adv-height: 600px;\\n\\n\\n  /* Отображение фавиконки: \\n     вкл - block, выкл - none; */\\n  --display-favicon: block;\\n  /* Отображение изображения: \\n     вкл - block, выкл - none; */\\n  --display-image: block;\\n  /* Отображение текста: \\n     вкл - block, выкл - none; */\\n  --display-desc: none;\\n  /* Отображение цен: \\n     вкл - inline, выкл - none */\\n  --display-price: inline;\\n  /* Отображение количества отзывов (для РМП): \\n     вкл - inline, выкл - none */\\n  --display-rmp-rating-count: inline;\\n\\n\\n  /* Максимальная ширина картинки */\\n  --image-max-width: 100%;\\n\\n  /* Высота картинки */\\n  --image-max-height: 320px;\\n\\n  /* Размер иконки приложения.\\n     Только для рекламы мобильных приложений */\\n  --app-icon-size: 40px;\\n\\n  /* Горизонтальное позиционирование сетки баннеров\\n     center - по середине, flex-start - слева,\\n     space-between - по всей ширине, space-around - по всей ширине с отступами\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/justify-content */\\n  --banners-justify-content: center;\\n\\n  /* Отступы вокруг объявления */\\n  --banner-margin: 5px;\\n  \\n  /* Отступы первых и последних объявлений от края \\n     по горизонтали и вертикали. Значение var(--banner-margin) \\n     повторяет общее значение отступов. \\n     ! Неприменимо для одиночных объявлений */\\n  --banners-grid-first-item-top-margin: 0;\\n  --banners-grid-first-item-left-margin: 0;\\n  --banners-grid-first-item-right-margin: 0;\\n  --banners-grid-first-item-bottom-margin: 0;\\n\\n  /* Цвет фона объявления. Пример: white или #f0f2f8;\\n     Допустимо использование переменных. См. начало документа */\\n  --banner-background: var(--color-light);\\n  /* Цвет фона при наведении на объявление */\\n  --banner-background-hover: var(--color-light-alt);\\n\\n  /* Обводка объявления. Для отключения укажите значение none\\n     Пример: solid 1px rgba(0 0 0 / 15%);\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/border */\\n  --banner-stroke: none;\\n  \\n  /* Тень объявления. Пример: 0px 8px 24px rgba(0, 21, 64, 0.125);\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/box-shadow */\\n  --banner-shadow: none;\\n  /* Тень объявления при наведении */\\n  --banner-shadow-hover: none;\\n  /* Трансформация объявления при наведении. Пример: translateY(-2px); */\\n  --banner-transform-hover: none;\\n  /* Анимация изменений при наведении */\\n  --banner-transition: box-shadow 120ms ease, transform 120ms ease;\\n\\n  /* Скругление углов объявления */\\n  --banner-outer-border-radius: 8px;\\n  /* Скругление углов внутренних элементов объявления (картинка, кнопки) */\\n  --banner-inner-border-radius: 8px;\\n  \\n  /* Отступы элементов от краев объявления */\\n  --banner-padding-outer: 8px;\\n  /* Отступы между элементами объявления */\\n  --banner-padding-inner: 8px;\\n\\n\\n  /* Цвет заголовка в объявлении */\\n  --color-text-header: var(--color-black); \\n  /* Цвет текста в объявлении */\\n  --color-text-desc: var(--color-grey-alt);\\n  /* Цвет цены в объявлении */\\n  --color-text-price: var(--color-black);\\n  /* Цвет ссылки в объявлении */\\n  --color-text-domain: var(--color-blue);\\n  /* Цвет ссылки в объявлении при наведении */\\n  --color-text-domain-hover: var(--color-blue-dark);\\n  /* Фон кнопки действия. Не применимо, если кнопка \\n     не предусмотрена в шаблоне (для форматов маленького размера) */\\n  --color-background-domain: var(--color-blue-transparent);\\n  /* Фон кнопки действия при наведении */\\n  --color-background-domain-hover: var(--color-blue-dark-transparent);\\n\\n  /* Цвет названия приложения в объявления (для РМП) */\\n  --color-text-app-name: var(--color-grey-alt);\\n\\n\\n  /* Цепочка используемых шрифтов в объявлении. По умолчанию указана \\n     цепочка системных шрифтов. Если шрифт не поддерживается, используется \\n     следующий по цепочке. При использовании собственного шрифта, \\n     следует указывать его название в самом начале */\\n  --font-family: \\n    -apple-system, BlinkMacSystemFont, \\\"Segoe UI\\\", Roboto, \\n    Oxygen, Ubuntu, Cantarell, \\\"Open Sans\\\", \\\"Helvetica Neue\\\", sans-serif, \\n    Apple Color Emoji, Segoe UI Emoji;\\n\\n  /* Размер шрифта и межстрочное расстояние для коротких заголовков\\n     (до 21 символа) */\\n  --font-size-title-short: 24px;\\n  --line-height-title-short: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для заголовков средней длины \\n     (от 22 до 31 символа) */\\n  --font-size-title-mid: 22px;\\n  --line-height-title-mid: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для длинных заголовков \\n     (от 32 символов) */\\n  --font-size-title-long: 18px;\\n  --line-height-title-long: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для цен */\\n  --font-size-price: 16px;\\n  --line-height-price: calc(1em + 4px);\\n\\n  /* Размер шрифта и межстрочное расстояние для текста объявления */\\n  --font-size-desc: 14px;\\n  --line-height-desc: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для ссылки */\\n  --font-size-domain: 14px;\\n  --line-height-domain: 18px;\\n\\n  /* Размер шрифта и межстрочное расстояние для названия приложения \\n     (для РМП) */\\n  --font-size-app-name: 14px;\\n  --line-height-app-name: calc(1em + 2px);\\n  \\n\\n  width: 100%;\\n  margin: 0 auto;\\n\\n  height: auto;\\n  padding: 0;\\n  overflow: visible;\\n}\\n\\n/* Специальные переменные для Рекламы Мобильных Приложений */\\n.ya-unit-item-rmp {\\n  /* Цвет текста ссылки */\\n  --color-text-domain: var(--color-blue);\\n  /* Цвет текста ссылки при наведении */\\n  --color-text-domain-hover: var(--color-blue-dark);\\n  /* Цвет фона кнопки объявления.\\n     Не применимо если, кнопки не предусмотрено (для маленьких форматов) */\\n  --color-background-domain: var(--color-blue-transparent);\\n  /* Цвет фона кнопки объявления при наведении */\\n  --color-background-domain-hover: var(--color-blue-dark-transparent);\\n}\\n\\n\\n/* -------- Далее — настройка стилей объявления. -------- */\\n/* -------- Не рекомендуется редактировать -------- */\\n\\n.ya-units-grid {\\n  margin: 0px auto;\\n}\\n\\n.grid {\\n  width: var(--adv-width);\\n  min-height: var(--adv-height);\\n}\\n\\n.grid-row {\\n  justify-content: var(--banners-justify-content);\\n  align-content: var(--banners-align-content);\\n  padding: 0px 0;\\n  flex: auto;\\n}\\n\\n.grid-item {\\n  width: 100%;\\n  font-family: var(--font-family);\\n  background: var(--banner-background);\\n  border: var(--banner-stroke);\\n  margin: var(--banner-margin, inherit);\\n  border-radius: var(--banner-outer-border-radius);\\n  overflow: hidden;\\n  box-sizing: border-box;\\n  flex: auto;\\n  box-shadow: var(--banner-shadow);\\n  transform: none;\\n  transition: var(--banner-transition);\\n}\\n\\n.grid-item:hover {\\n  transform: var(--banner-transform-hover);\\n  box-shadow: var(--banner-shadow-hover);\\n  background: var(--banner-background-hover);\\n  --color-text-domain: var(--color-text-domain-hover);\\n}\\n\\n.grid-item:first-child {\\n  margin-left: var(--banners-grid-first-item-left-margin);\\n}\\n\\n.grid-item:last-child {\\n  margin-right: var(--banners-grid-first-item-right-margin);\\n}\\n\\n.grid-row:first-child .grid-item {\\n  margin-top: var(--banners-grid-first-item-top-margin);\\n}\\n\\n.grid-row:last-child .grid-item {\\n  margin-bottom: var(--banners-grid-first-item-bottom-margin);\\n}\\n\\n.unit-wrapper {\\n  height: 100%;\\n}\\n\\n.ya-unit-favicon {\\n  display: block !important;\\n}\\n\\na.yrw-url {\\n  color: inherit;\\n  cursor: pointer;\\n}\\n\\n.unit-misc {\\n  position: absolute;\\n  top: 0;\\n  left: 0;\\n  width: 100%;\\n  height: 100%;\\n}\\n\\n.unit-meta {\\n  position: absolute;\\n  top: 10px;\\n  left: var(--banner-padding-outer);\\n  z-index: 2;\\n  padding: 0px 4px 0px;\\n  text-transform: uppercase;\\n  height: 12px;\\n  background: transparent;\\n  color: var(--color-grey);\\n  border-radius: 4px;\\n  font-size: 8px;\\n  line-height: 13px;\\n  font-weight: 500;\\n  letter-spacing: 0.12em;\\n  vertical-align: 5px;\\n  margin: 0;\\n  user-select: none;\\n  -ms-user-select: none;\\n  -moz-user-select: none;\\n  -khtml-user-select: none;\\n  -webkit-user-select: none;\\n}\\n\\n.ya-unit-item-rmp .unit-meta {\\n  background: transparent;\\n}\\n\\n.unit-age::before {\\n  content: \\\" | \\\";\\n}\\n\\n.unit-age:empty {\\n  display: none;\\n}\\n\\n.ya-unit-kebab_button svg circle {\\n  fill: var(--color-grey);\\n}\\n\\n.ya-unit-kebab_bg {\\n  background: transparent;\\n  opacity: 1.0;\\n}\\n\\n.ya-unit-kebab_icon {\\n  filter: var(--display-image, none);\\n}\\n\\n.ya-unit-kebab_icon circle {\\n  fill: var(--color-grey) !important;\\n}\\n\\n.ya-unit-kebab_button {\\n  position: absolute;\\n  z-index: 940;\\n  top: 4px;\\n  right: 4px;\\n  width: 24px;\\n  height: 24px;\\n}\\n\\n.yrw-body_warning {\\n  position: relative;\\n}\\n\\n.yrw-body_warning div {\\n  padding: 0;\\n}\\n\\n.yrw-body_warning div:not(.yrw-warning-wrapper):not(.yrw-warning-text) {\\n  position: relative;\\n  background-color: var(--color-light-alt);\\n  color: #575c66;\\n  display: flex;\\n  padding: 0 calc(var(--inner-border-radius) / 2);\\n}\\n\\n.yrw-body_warning div text {\\n  fill: #575c66;\\n}\\n\\n.yrw-body_warning div:not(.yrw-warning-wrapper) {\\n  padding: 0 calc(var(--inner-border-radius) / 2 + 4px);\\n}\\n\\n.yrw-warning-text {\\n  text-shadow: none;\\n}\\n\\n\\n\\n.unit-container {\\n  box-sizing: border-box;\\n  position: relative;\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: flex-end;\\n  overflow: hidden;\\n  max-width: var(--max-content-width, --banner-max-width, 960px);\\n  margin: auto;\\n}\\n\\n.unit-content {\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: flex-start;\\n  position: relative;\\n  height: 100%;\\n  padding: 8px;\\n  padding: var(--banner-padding-outer);\\n  padding-top: 32px;\\n}\\n\\n.unit-text-content {\\n  display: flex;\\n  justify-content: flex-start;\\n  flex-direction: column;\\n  position: relative;\\n  flex: auto;\\n}\\n\\n.rmp-app-content {\\n  display: flex;\\n  flex-direction: row;\\n}\\n\\n.rmp-text-content {\\n  display: flex;\\n  justify-content: center;\\n  flex-direction: column;\\n}\\n\\n.unit-text-content > div {\\n  margin-top: var(--banner-padding-inner);\\n}\\n\\n.rmp-text-content > div {\\n  margin-top: calc(var(--banner-padding-inner) / 2);\\n}\\n\\n.rmp-text-content > div:first-child {\\n  margin-top: 0;\\n}\\n\\n\\n\\n.ya-unit-title, .unit-title {\\n  color: var(--color-text-header);\\n  font-size: var(--font-size-title);\\n  line-height: var(--line-height-title);\\n  font-weight: 600;\\n  display: flex;\\n}\\n\\n.title-short {\\n  font-size: var(--font-size-title-short);\\n  line-height: var(--line-height-title-short);\\n}\\n\\n.title-mid {\\n  font-size: var(--font-size-title-mid);\\n  line-height: var(--line-height-title-mid);\\n}\\n\\n.title-long {\\n  font-size: var(--font-size-title-long);\\n  line-height: var(--line-height-title-long);\\n}\\n\\n.title-rmp {\\n  font-size: var(--font-size-title-rmp);\\n  line-height: var(--line-height-title-rmp);\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: center;\\n}\\n\\n.unit-app-name {\\n  font-size: var(--font-size-app-name);\\n  line-height: var(--line-height-app-name);\\n  color: var(--color-text-app-name);\\n}\\n\\n.unit-cta {\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: center;\\n  box-sizing: border-box;\\n  padding: 12px;\\n\\n  font-size: var(--domain-font-size);\\n  line-height: var(--domain-line-height);\\n  text-align: center;\\n  color: var(--color-cta-color);\\n  background-color: var(--color-background-domain);\\n  border-radius: var(--banner-inner-border-radius);\\n  margin-top: var(--banner-padding-inner);\\n  transition: var(--cta-transition);\\n}\\n\\n.unit-cta:hover {\\n  color: var(--color-cta-hover-color);\\n  background-color: var(--color-background-domain-hover);\\n}\\n\\n.unit-favicon {\\n  width: var(--line-height-domain);\\n  background-color: transparent;\\n  border-radius: 3px;\\n  align-self: center;\\n  display: var(--display-favicon, inline);\\n}\\n\\n.ya-unit-favicon {\\n  width: var(--line-height-domain);\\n  height: var(--line-height-domain);\\n}\\n\\n.ya-unit-rating {\\n  margin-right: 4px;\\n  height: 16px;\\n  display: inline;\\n}\\n\\n.ya-unit-review-count {\\n  display: var(--display-rmp-rating-count);\\n  transform: translateY(1px);\\n  color: var(--color-grey-alt);\\n  font-size: 13px;\\n  line-height: 16px;\\n}\\n\\n.unit-favicon:empty,\\n.ya-unit-domain:empty,\\n.unit-domain:empty {\\n  display: none;\\n}\\n\\n.unit-domain {\\n  display: flex;\\n  margin-right: auto;\\n  border-radius: 4px;\\n  color: var(--color-text-domain);\\n  font-size: var(--font-size-domain);\\n  line-height: var(--line-height-domain);\\n  padding: 0;\\n  width: 100%;\\n  height: var(--line-height-domain, 16px);\\n  flex-direction: row;\\n  flex-wrap: wrap;\\n  justify-content: center;\\n  align-content: flex-end;\\n  overflow: hidden;\\n}\\n\\n.unit-domain > *,\\n.unit-domain .unit-domain-no-wrap > * {\\n  margin-right: calc(var(--line-height-domain) / 3.5);\\n}\\n\\n.unit-domain span {\\n  flex: none;\\n}\\n\\n.unit-domain-no-wrap {\\n  display: flex;\\n}\\n\\n\\n\\n.unit-app-rating {\\n  display: flex;\\n  flex-direction: row;\\n  align-content: center;\\n}\\n\\n.unit-prices {\\n  display: var(--display-price, inline);\\n  white-space: nowrap;\\n  font-size: var(--font-size-price);\\n  line-height: var(--line-height-price);\\n}\\n\\n.ya-unit-price {\\n  color: var(--color-text-price);\\n  font-weight: 600;\\n  display: inline;\\n  white-space: nowrap;\\n}\\n\\n.ya-unit-old-price {\\n  margin-left: 8px;\\n  font-size: max(0.9em, 12px);\\n  line-height: max(0.9em, 12px);\\n  color: var(--color-grey-alt);\\n  position: relative;\\n  white-space: nowrap;\\n  display: inline;\\n}\\n\\n.ya-unit-old-price::after {\\n  content: \\\"\\\";\\n  position: absolute;\\n  bottom: 0;\\n  left: 0;\\n  width: 100%;\\n  height: 100%;\\n  \\n  background-image: url(\\\"data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='100%' height='100%'><line class='line' x1='0' y1='65%' x2='100%' y2='50%' stroke='%23A3ACBF' stroke-width='8vh' /></svg>\\\");\\n  background-repeat: no-repeat;\\n}\\n\\n.unit-desc {\\n  display: var(--display-desc);\\n  color: var(--color-text-desc);\\n  font-size: var(--font-size-desc);\\n  line-height: var(--line-height-desc);\\n}\\n\\n\\n\\n.unit-image-block {\\n  display: var(--display-image);\\n  width: 100%;\\n  max-width: var(--image-max-width, none);\\n  height: 100%;\\n  max-height: var(--image-max-height);\\n  flex: auto;\\n  border-radius: var(--banner-inner-border-radius);\\n  position: relative;\\n  box-sizing: border-box;\\n  background-color: var(--color-light-alt);\\n  overflow: hidden;\\n}\\n\\n.unit-image {\\n  width: 100%;\\n  height: 100%;\\n  display: var(--display-image);\\n  position: relative;\\n}\\n\\n.video-source-container {\\n  border-radius: var(--banner-inner-border-radius, 8px);\\n  z-index: 1;\\n  overflow: hidden;\\n}\\n\\n.ya-unit-app-icon {\\n  position: relative;\\n  border-radius: calc(var(--app-icon-size) / 4);\\n  margin-right: var(--banner-padding-inner);\\n  display: flex;\\n}\\n\\n.unit-app-icon {\\n  margin: auto;\\n}\\n\\n.ya-unit-app-icon .yrw-img-component {\\n  width: var(--app-icon-size);\\n  height: var(--app-icon-size);\\n}\\n\\n.ya-unit-image {\\n  height: 100%;\\n}\\n\\n.yrw-img-component {\\n  height: 100%;\\n  padding-bottom: 0;\\n}\\n\\n.unit-image .img-source-component {\\n  border-radius: var(--banner-inner-border-radius);\\n  background-image: url(\\\"data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='256' height='256'><rect x='80' y='80' width='96' height='96' rx='19.2' fill='%23405580' fill-opacity='0.15'/><path d='M144.619 110.181H147.619C147.619 108.524 146.276 107.181 144.619 107.181V110.181ZM111.102 147.94L146.74 112.302L142.498 108.06L106.86 143.698L111.102 147.94ZM114.072 113.181H144.619V107.181L114.072 107.181V113.181ZM141.619 110.181V140.728H147.619V110.181L141.619 110.181Z' fill='white'/></svg>\\\");\\n  background-position: center;\\n}\\n\\n.ya-unit-app-icon .img-source-component {\\n  border-radius: calc(var(--app-icon-size) / 4 - 4px);\\n}\\n\\n.ya-clamp {\\n  width: 100%;\\n}\\n\\n.yrw-content {\\n  overflow: visible;\\n}\\n\\n.ya-grid-template:empty {\\n  display: none;\\n}\",\"gridColumns\":\"1\",\"gridRows\":\"2\",\"defaultWidth\":\"300\",\"defaultHeight\":\"600\",\"props\":{}},{\"value\":\"8\",\"label\":\"Десктопная лента 300px x бесконечно\",\"template\":\"<ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n\\n  <div class=\\\"unit-misc\\\">\\n    <ya-unit-kebab class=\\\"ya-unit-kebab_dark\\\" />\\n    <div class=\\\"unit-meta\\\">\\n      <ya-unit-category class=\\\"unit-category\\\" />\\n      <ya-unit-age class=\\\"unit-age\\\" />\\n    </div>\\n  </div>\\n\\n\\n  <div class=\\\"unit-content\\\">\\n    <div class=\\\"unit-image-block\\\">\\n      <ya-unit-image/>\\n    </div>\\n\\n    <div class=\\\"unit-text-content\\\" data-cols=\\\"1\\\" data-rows=\\\"1\\\">\\n\\n      <div class=\\\"unit-title\\\">\\n        <ya-unit-if condition=\\\"unit.title < 22\\\">\\n          <ya-clamp lines=\\\"3\\\" class=\\\"title-short\\\"><ya-unit-title /></ya-clamp>\\n        </ya-unit-if>\\n\\n        <ya-unit-if condition=\\\"unit.title > 21 & unit.title < 33\\\">\\n          <ya-clamp lines=\\\"3\\\" class=\\\"title-mid\\\"><ya-unit-title /></ya-clamp>\\n        </ya-unit-if>\\n\\n        <ya-unit-if condition=\\\"unit.title > 32\\\">\\n          <ya-clamp lines=\\\"3\\\" class=\\\"title-long\\\"><ya-unit-title /></ya-clamp>\\n        </ya-unit-if>\\n      </div>\\n\\n      <!-- Начало Шаблона ТГО -->\\n      <ya-unit-if condition=\\\"!unit.isRmp\\\">\\n\\n        <div class=\\\"unit-prices\\\"><ya-unit-price /><ya-unit-old-price /></div>\\n  \\n        <ya-clamp lines=\\\"4\\\" class=\\\"unit-desc\\\"><ya-unit-desc /></ya-clamp>\\n\\n\\n      </ya-unit-if>\\n      <!-- Конец Шаблона ТГО -->\\n\\n\\n    \\n      <!-- Начало Шаблона РМП -->\\n      <ya-unit-if condition=\\\"unit.isRmp\\\">\\n\\n        <div class=\\\"rmp-app-content\\\">\\n          <ya-unit-app-icon />\\n\\n          <div class=\\\"rmp-text-content\\\">\\n\\n            <div class=\\\"unit-app-name\\\">\\n              <ya-clamp lines=\\\"2\\\">\\n                <ya-unit-app-name />\\n              </ya-clamp>\\n            </div>\\n\\n            <div class=\\\"unit-app-rating\\\">\\n              <ya-unit-rating />\\n              <ya-unit-review-count />\\n            </div>\\n          </div>\\n        </div>\\n\\n      </ya-unit-if>\\n      <!-- Конец Шаблона РМП -->\\n\\n    </div>\\n\\n    <div class=\\\"unit-cta\\\">\\n      <div class=\\\"unit-domain\\\">\\n        <ya-unit-mobile-app-button />\\n        <ya-unit-if condition=\\\"!unit.isRmp\\\">\\n          <span class=\\\"unit-domain-no-wrap\\\">\\n            <span class=\\\"unit-favicon\\\"><ya-unit-favicon size=\\\"32\\\"/></span>\\n            <ya-unit-domain class=\\\"domain\\\"/>\\n          </span>\\n        </ya-unit-if>\\n      </div>\\n    </div>\\n  </div>\\n\\n</ya-units-grid>\",\"css\":\"/* Шаблон 8: Десктопная лента 300px x бесконечно\\n   Для использования в сайдбаре сайта */\\n\\n\\n/* Шаблоны не работают в браузерах IE 11 версии и ниже */\\n\\n/* РМП — Реклама Мобильных Приложений */\\n\\n\\n/* -------- Переменные цветов -------- */\\n/* Изменив значение цвета в переменной, оно одновременно\\n   изменится во всех элементах шаблона, где указано */\\n.ya-container {\\n\\n  --color-blue: #3377FF;\\n  --color-blue-dark: #0055FF;\\n\\n  --color-blue-transparent: #3377FF1A;\\n  --color-blue-dark-transparent: #0055FF1A;\\n\\n  --color-black: #232526;\\n  --color-grey: #575c66;\\n  --color-grey-alt: #A3ACBF;\\n  --color-light: #f4f4f6;\\n  --color-light-alt: #ececef;\\n}\\n\\n/* Переменные цветов для устройств с поддержкой \\n   цветового профиля Display P3 (устройства Apple) */\\n\\n/* Устройства Apple поддерживают цветовой профиль \\n   с более яркими цветами (цветовой профиль Display P3). \\n   Если вы хотите поддержать его, то следует поменять \\n   значения цветов в блоке ниже */\\n@supports (color: color(display-p3)) {\\n  .ya-container {\\n    --color-blue: color(display-p3 0.2 0.47 1.0);\\n    --color-blue-dark: color(display-p3 0.0 0.33 1.0);\\n\\n    --color-blue-transparent: color(display-p3 0.2 0.47 1.0 / 0.1);\\n    --color-blue-dark-transparent: color(display-p3 0.0 0.33 1.0 / 0.1);\\n\\n    --color-yellow: color(display-p3 1.0 0.8 0.2);\\n    --color-yellow-dark: color(display-p3 1.0 0.75 0.0);\\n  }\\n}\\n\\n\\n\\n/* -------- Переменные для отрисовки объявления -------- */\\n\\n.ya-container {\\n\\n  /* Фиксированная ширина объявления.\\n     Работает при --banner-flex: none */\\n  --banner-width: 300px;\\n\\n  /* Минимальная и максимальная высота объявления.\\n     Объявление будет растягиваться по высоте \\n     в зависимости от количества контента */\\n  --banner-min-height: 280px;\\n  --banner-max-height: none;\\n\\n\\n  /* Отображение фавиконки: \\n     вкл - block, выкл - none; */\\n  --display-favicon: block;\\n  /* Отображение изображения: \\n     вкл - block, выкл - none; */\\n  --display-image: block;\\n  /* Отображение текста: \\n     вкл - block, выкл - none; */\\n  --display-desc: inline;\\n  /* Отображение цен: \\n     вкл - inline, выкл - none */\\n  --display-price: inline;\\n  /* Отображение количества отзывов (для РМП): \\n     вкл - inline, выкл - none */\\n  --display-rmp-rating-count: inline;\\n  \\n\\n  /* Максимальная ширина картинки */\\n  --image-max-width: 100%;\\n\\n  /* Высота картинки */\\n  --image-height: 160px;\\n\\n  /* Размер иконки приложения.\\n     Только для рекламы мобильных приложений */\\n  --app-icon-size: 60px;\\n\\n  /* Горизонтальное позиционирование сетки баннеров\\n     center - по середине, flex-start - слева,\\n     space-between - по всей ширине, space-around - по всей ширине с отступами\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/justify-content */\\n  --banners-justify-content: center;\\n\\n  /* Отступы вокруг объявления */\\n  --banner-margin: 5px 0;\\n  \\n  /* Отступы первых и последних объявлений от края \\n     по горизонтали и вертикали. Значение var(--banner-margin) \\n     повторяет общее значение отступов. \\n     ! Неприменимо для одиночных объявлений */\\n  --banners-grid-first-item-top-margin: 0;\\n  --banners-grid-first-item-left-margin: 0;\\n  --banners-grid-first-item-right-margin: 0;\\n  --banners-grid-first-item-bottom-margin: 0;\\n\\n  /* Цвет фона объявления. Пример: white или #f0f2f8;\\n     Допустимо использование переменных. См. начало документа */\\n  --banner-background: var(--color-light);\\n  /* Цвет фона объявления при наведении */\\n  --banner-background-hover: var(--color-light-alt);\\n\\n  /* Обводка объявления. Для отключения укажите значение none\\n     Пример: solid 1px rgba(0 0 0 / 15%);\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/border */\\n  --banner-stroke: none;\\n  \\n  /* Тень объявления. Пример: 0px 8px 24px rgba(0, 21, 64, 0.125);\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/box-shadow */\\n  --banner-shadow: none;\\n  /* Тень объявления при наведении */\\n  --banner-shadow-hover: none;\\n  /* Трансформация объявления при наведении. Пример: translateY(-2px); */\\n  --banner-transform-hover: none;\\n  /* Анимация изменений при наведении */\\n  --banner-transition: box-shadow 120ms ease, transform 120ms ease;\\n\\n  /* Скругление углов объявления */\\n  --banner-outer-border-radius: 8px;\\n  /* Скругление углов внутренних элементов объявления (картинка, кнопки) */\\n  --banner-inner-border-radius: 8px;\\n  \\n  /* Отступы элементов от краев объявления */\\n  --banner-padding-outer: 8px;\\n  /* Отступы между элементами объявления */\\n  --banner-padding-inner: 12px;\\n\\n\\n  /* Цвет заголовка в объявлении */\\n  --color-text-header: var(--color-black); \\n  /* Цвет текста в объявлении */\\n  --color-text-desc: var(--color-grey-alt);\\n  /* Цвет цены в объявлении */\\n  --color-text-price: var(--color-black);\\n  /* Цвет ссылки в объявлении */\\n  --color-text-domain: var(--color-blue);\\n  /* Цвет ссылки в объявлении при наведении */\\n  --color-text-domain-hover: var(--color-blue-dark);\\n  /* Фон кнопки действия. Не применимо, если кнопка \\n     не предусмотрена в шаблоне (для форматов маленького размера) */\\n  --color-background-domain: var(--color-blue-transparent);\\n  /* Фон кнопки действия при наведении */\\n  --color-background-domain-hover: var(--color-blue-dark-transparent);\\n\\n  /* Цвет названия приложения в объявления (для РМП) */\\n  --color-text-app-name: var(--color-grey-alt);\\n\\n\\n  /* Цепочка используемых шрифтов в объявлении. По умолчанию указана \\n     цепочка системных шрифтов. Если шрифт не поддерживается, используется \\n     следующий по цепочке. При использовании собственного шрифта, \\n     следует указывать его название в самом начале */\\n  --font-family: \\n    -apple-system, BlinkMacSystemFont, \\\"Segoe UI\\\", Roboto, \\n    Oxygen, Ubuntu, Cantarell, \\\"Open Sans\\\", \\\"Helvetica Neue\\\", sans-serif, \\n    Apple Color Emoji, Segoe UI Emoji;\\n\\n  /* Размер шрифта и межстрочное расстояние для коротких заголовков\\n     (до 21 символа) */\\n  --font-size-title-short: 24px;\\n  --line-height-title-short: calc(1em + 0px);\\n\\n  /* Размер шрифта и межстрочное расстояние для заголовков средней длины \\n     (от 22 до 31 символа) */\\n  --font-size-title-mid: 20px;\\n  --line-height-title-mid: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для длинных заголовков \\n     (от 32 символов) */\\n  --font-size-title-long: 20px;\\n  --line-height-title-long: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для заголовков РМП */\\n  --font-size-title-rmp: 20px;\\n  --line-height-title-rmp: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для цен */\\n  --font-size-price: 16px;\\n  --line-height-price: calc(1em + 4px);\\n\\n  /* Размер шрифта и межстрочное расстояние для текста объявления */\\n  --font-size-desc: 15px;\\n  --line-height-desc: calc(1em + 3px);\\n\\n  /* Размер шрифта и межстрочное расстояние для ссылки */\\n  --font-size-domain: 15px;\\n  --line-height-domain: 16px;\\n\\n  /* Размер шрифта и межстрочное расстояние для названия приложения \\n     (для РМП) */\\n  --font-size-app-name: 15px;\\n  --line-height-app-name: calc(1em + 3px);\\n\\n\\n\\n  width: 100%;\\n  margin: 0 auto;\\n\\n  height: auto;\\n  padding: 0;\\n  overflow: visible;\\n}\\n\\n/* Специальные переменные для Рекламы Мобильных Приложений */\\n.ya-unit-item-rmp {\\n  /* Цвет текста ссылки */\\n  --color-text-domain: var(--color-blue);\\n  /* Цвет текста ссылки при наведении */\\n  --color-text-domain-hover: var(--color-blue-dark);\\n  /* Цвет фона кнопки объявления.\\n     Не применимо если, кнопки не предусмотрено (для маленьких форматов) */\\n  --color-background-domain: var(--color-blue-transparent);\\n  /* Цвет фона кнопки объявления при наведении */\\n  --color-background-domain-hover: var(--color-blue-dark-transparent);\\n}\\n\\n\\n\\n\\n\\n/* -------- Далее — настройка стилей объявления. -------- */\\n/* -------- Не рекомендуется редактировать -------- */\\n\\n.ya-units-grid {\\n  margin: 0px auto;\\n}\\n\\n.grid-row {\\n  justify-content: var(--banners-justify-content);\\n  align-content: var(--banners-align-content);\\n  padding: 0px 0;\\n}\\n\\n.grid-item {\\n  width: var(--banner-width);\\n  min-height: var(--banner-min-height);\\n  max-height: var(--banner-max-height);\\n  font-family: var(--font-family);\\n  background: var(--banner-background);\\n  border: var(--banner-stroke);\\n  margin: var(--banner-margin, inherit);\\n  border-radius: var(--banner-outer-border-radius);\\n  overflow: hidden;\\n  box-sizing: border-box;\\n  flex: var(--banner-flex);\\n  box-shadow: var(--banner-shadow);\\n  transform: none;\\n  transition: var(--banner-transition);\\n}\\n\\n.grid-item:hover {\\n  transform: var(--banner-transform-hover);\\n  box-shadow: var(--banner-shadow-hover);\\n  background: var(--banner-background-hover);\\n  --color-text-domain: var(--color-text-domain-hover);\\n}\\n\\n.grid-item:first-child {\\n  margin-left: var(--banners-grid-first-item-left-margin);\\n}\\n\\n.grid-item:last-child {\\n  margin-right: var(--banners-grid-first-item-right-margin);\\n}\\n\\n.grid-row:first-child .grid-item {\\n  margin-top: var(--banners-grid-first-item-top-margin);\\n}\\n\\n.grid-row:last-child .grid-item {\\n  margin-bottom: var(--banners-grid-first-item-bottom-margin);\\n}\\n\\n.unit-wrapper {\\n  height: 100%;\\n}\\n\\n.ya-unit-favicon {\\n  display: block !important;\\n}\\n\\na.yrw-url {\\n  color: inherit;\\n  cursor: pointer;\\n}\\n\\n.unit-misc {\\n  position: absolute;\\n  top: 0;\\n  left: 0;\\n  width: 100%;\\n  height: 100%;\\n}\\n\\n.unit-meta {\\n  position: absolute;\\n  top: 10px;\\n  left: var(--banner-padding-outer);\\n  z-index: 2;\\n  padding: 0px 4px 0px;\\n  text-transform: uppercase;\\n  height: 12px;\\n  background: transparent;\\n  color: var(--color-grey);\\n  border-radius: 4px;\\n  font-size: 8px;\\n  line-height: 13px;\\n  font-weight: 500;\\n  letter-spacing: 0.12em;\\n  vertical-align: 5px;\\n  margin: 0;\\n  user-select: none;\\n  -ms-user-select: none;\\n  -moz-user-select: none;\\n  -khtml-user-select: none;\\n  -webkit-user-select: none;\\n}\\n\\n.ya-unit-item-rmp .unit-meta {\\n  background: transparent;\\n}\\n\\n.unit-age::before {\\n  content: \\\" | \\\";\\n}\\n\\n.unit-age:empty {\\n  display: none;\\n}\\n\\n.ya-unit-kebab_button svg circle {\\n  fill: var(--color-grey);\\n}\\n\\n.ya-unit-kebab_bg {\\n  background: transparent;\\n  opacity: 1.0;\\n}\\n\\n.ya-unit-kebab_icon {\\n  filter: var(--display-image, none);\\n}\\n\\n.ya-unit-kebab_icon circle {\\n  fill: var(--color-grey) !important;\\n}\\n\\n.ya-unit-kebab_button {\\n  position: absolute;\\n  z-index: 940;\\n  top: 4px;\\n  right: 4px;\\n  width: 24px;\\n  height: 24px;\\n}\\n\\n.yrw-body_warning {\\n  position: relative;\\n}\\n\\n.yrw-body_warning div {\\n  padding: 0;\\n}\\n\\n.yrw-body_warning div:not(.yrw-warning-wrapper):not(.yrw-warning-text) {\\n  position: relative;\\n  background-color: var(--color-light-alt);\\n  color: #575c66;\\n  display: flex;\\n  padding: 0 calc(var(--inner-border-radius) / 2);\\n}\\n\\n.yrw-body_warning div text {\\n  fill: #575c66;\\n}\\n\\n.yrw-body_warning div:not(.yrw-warning-wrapper) {\\n  padding: 0 calc(var(--inner-border-radius) / 2 + 4px);\\n}\\n\\n.yrw-warning-text {\\n  text-shadow: none;\\n}\\n\\n\\n\\n.unit-container {\\n  box-sizing: border-box;\\n  position: relative;\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: flex-end;\\n  overflow: hidden;\\n  max-width: var(--max-content-width, --banner-max-width, 960px);\\n  margin: auto;\\n}\\n\\n.unit-content {\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: flex-start;\\n  position: relative;\\n  height: 100%;\\n  padding: 8px;\\n  padding: var(--banner-padding-outer);\\n  padding-top: 32px;\\n}\\n\\n.unit-text-content {\\n  display: flex;\\n  justify-content: flex-start;\\n  flex-direction: column;\\n  position: relative;\\n  flex: auto;\\n}\\n\\n.rmp-app-content {\\n  display: flex;\\n  flex-direction: row;\\n}\\n\\n.rmp-text-content {\\n  display: flex;\\n  justify-content: center;\\n  flex-direction: column;\\n}\\n\\n.unit-text-content > div {\\n  margin-top: var(--banner-padding-inner);\\n}\\n\\n.rmp-text-content > div {\\n  margin-top: calc(var(--banner-padding-inner) / 2);\\n}\\n\\n.rmp-text-content > div:first-child {\\n  margin-top: 0;\\n}\\n\\n\\n\\n.ya-unit-title, .unit-title {\\n  color: var(--color-text-header);\\n  font-size: var(--font-size-title);\\n  line-height: var(--line-height-title);\\n  font-weight: 600;\\n  display: flex;\\n}\\n\\n.title-short {\\n  font-size: var(--font-size-title-short);\\n  line-height: var(--line-height-title-short);\\n}\\n\\n.title-mid {\\n  font-size: var(--font-size-title-mid);\\n  line-height: var(--line-height-title-mid);\\n}\\n\\n.title-long {\\n  font-size: var(--font-size-title-long);\\n  line-height: var(--line-height-title-long);\\n}\\n\\n.title-rmp {\\n  font-size: var(--font-size-title-rmp);\\n  line-height: var(--line-height-title-rmp);\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: center;\\n}\\n\\n.unit-app-name {\\n  font-size: var(--font-size-app-name);\\n  line-height: var(--line-height-app-name);\\n  color: var(--color-text-app-name);\\n}\\n\\n.unit-cta {\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: center;\\n  box-sizing: border-box;\\n  padding: 12px;\\n\\n  font-size: var(--domain-font-size);\\n  line-height: var(--domain-line-height);\\n  text-align: center;\\n  color: var(--color-cta-color);\\n  background-color: var(--color-background-domain);\\n  border-radius: var(--banner-inner-border-radius);\\n  margin-top: var(--banner-padding-inner);\\n  transition: var(--cta-transition);\\n}\\n\\n.unit-cta:hover {\\n  color: var(--color-cta-hover-color);\\n  background-color: var(--color-background-domain-hover);\\n}\\n\\n.unit-favicon {\\n  width: var(--line-height-domain);\\n  background-color: transparent;\\n  border-radius: 3px;\\n  align-self: center;\\n  display: var(--display-favicon, inline);\\n}\\n\\n.ya-unit-favicon {\\n  width: var(--line-height-domain);\\n  height: var(--line-height-domain);\\n}\\n\\n.ya-unit-rating {\\n  margin-right: 4px;\\n  height: 16px;\\n  display: inline;\\n}\\n\\n.ya-unit-review-count {\\n  display: var(--display-rmp-rating-count);\\n  transform: translateY(1px);\\n  color: var(--color-grey-alt);\\n  font-size: 13px;\\n  line-height: 16px;\\n}\\n\\n.unit-favicon:empty,\\n.ya-unit-domain:empty,\\n.unit-domain:empty {\\n  display: none;\\n}\\n\\n.unit-domain {\\n  display: flex;\\n  margin-right: auto;\\n  border-radius: 4px;\\n  color: var(--color-text-domain);\\n  font-size: var(--font-size-domain);\\n  line-height: var(--line-height-domain);\\n  \\n  padding: 0;\\n  width: 100%;\\n  height: var(--line-height-domain, 16px);\\n  flex-direction: row;\\n  flex-wrap: wrap;\\n  justify-content: center;\\n  align-content: flex-end;\\n  overflow: hidden;\\n}\\n\\n.unit-domain > *,\\n.unit-domain .unit-domain-no-wrap > * {\\n  margin-right: calc(var(--line-height-domain) / 3.5);\\n}\\n\\n.unit-domain span {\\n  flex: none;\\n}\\n\\n.unit-domain-no-wrap {\\n  display: flex;\\n}\\n\\n\\n\\n.unit-app-rating {\\n  display: flex;\\n  flex-direction: row;\\n  align-content: center;\\n}\\n\\n.unit-prices {\\n  display: var(--display-price, inline);\\n  white-space: nowrap;\\n  font-size: var(--font-size-price);\\n  line-height: var(--line-height-price);\\n}\\n\\n.ya-unit-price {\\n  color: var(--color-text-price);\\n  font-weight: 600;\\n  display: inline;\\n  white-space: nowrap;\\n}\\n\\n.ya-unit-old-price {\\n  margin-left: 8px;\\n  font-size: max(0.9em, 12px);\\n  line-height: max(0.9em, 12px);\\n  color: var(--color-grey-alt);\\n  position: relative;\\n  white-space: nowrap;\\n  display: inline;\\n}\\n\\n.ya-unit-old-price::after {\\n  content: \\\"\\\";\\n  position: absolute;\\n  bottom: 0;\\n  left: 0;\\n  width: 100%;\\n  height: 100%;\\n  \\n  background-image: url(\\\"data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='100%' height='100%'><line class='line' x1='0' y1='65%' x2='100%' y2='50%' stroke='%23A3ACBF' stroke-width='8vh' /></svg>\\\");\\n  background-repeat: no-repeat;\\n}\\n\\n.unit-desc {\\n  display: var(--display-desc);\\n  color: var(--color-text-desc);\\n  font-size: var(--font-size-desc);\\n  line-height: var(--line-height-desc);\\n}\\n\\n\\n\\n.unit-image-block {\\n  display: var(--display-image);\\n  width: 100%;\\n  max-width: var(--image-max-width, none);\\n  height: var(--image-height);\\n  flex: none;\\n  border-radius: var(--banner-inner-border-radius);\\n  position: relative;\\n  box-sizing: border-box;\\n  background-color: var(--color-light-alt);\\n  overflow: hidden;\\n}\\n\\n.unit-image {\\n  width: 100%;\\n  height: 100%;\\n  display: var(--display-image);\\n  position: relative;\\n}\\n\\n.video-source-container {\\n  border-radius: var(--banner-inner-border-radius, 8px);\\n  z-index: 1;\\n  overflow: hidden;\\n}\\n\\n.ya-unit-app-icon {\\n  position: relative;\\n  border-radius: calc(var(--app-icon-size) / 4);\\n  margin-right: var(--banner-padding-inner);\\n  display: flex;\\n}\\n\\n.unit-app-icon {\\n  margin: auto;\\n}\\n\\n.ya-unit-app-icon .yrw-img-component {\\n  width: var(--app-icon-size);\\n  height: var(--app-icon-size);\\n}\\n\\n.ya-unit-image {\\n  height: 100%;\\n}\\n\\n.yrw-img-component {\\n  height: 100%;\\n  padding-bottom: 0;\\n}\\n\\n.unit-image .img-source-component {\\n  border-radius: var(--banner-inner-border-radius);\\n  background-image: url(\\\"data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='256' height='256'><rect x='80' y='80' width='96' height='96' rx='19.2' fill='%23405580' fill-opacity='0.15'/><path d='M144.619 110.181H147.619C147.619 108.524 146.276 107.181 144.619 107.181V110.181ZM111.102 147.94L146.74 112.302L142.498 108.06L106.86 143.698L111.102 147.94ZM114.072 113.181H144.619V107.181L114.072 107.181V113.181ZM141.619 110.181V140.728H147.619V110.181L141.619 110.181Z' fill='white'/></svg>\\\");\\n  background-position: center;\\n}\\n\\n.ya-unit-app-icon .img-source-component {\\n  border-radius: calc(var(--app-icon-size) / 4 - 4px);\\n}\\n\\n.ya-clamp {\\n  width: 100%;\\n}\\n\\n.yrw-content {\\n  overflow: visible;\\n}\\n\\n.ya-grid-template:empty {\\n  display: none;\\n}\",\"gridColumns\":\"1\",\"gridRows\":\"3\",\"defaultWidth\":\"300\",\"defaultHeight\":\"1100\",\"props\":{}},{\"value\":\"13\",\"label\":\"Универсальный сингл размером 100% x auto\",\"template\":\"<ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n\\n  <div class=\\\"unit-content\\\">\\n\\n    <div class=\\\"unit-misc\\\">\\n      <ya-unit-kebab class=\\\"ya-unit-kebab_dark\\\" />\\n    </div>\\n\\n    <div class=\\\"unit-image-block\\\">\\n      <ya-unit-image/>\\n    </div>\\n\\n    <div class=\\\"unit-text-content\\\" data-cols=\\\"1\\\" data-rows=\\\"1\\\">\\n\\n      <div class=\\\"unit-meta\\\">\\n        <ya-unit-category class=\\\"unit-category\\\" />\\n        <ya-unit-age class=\\\"unit-age\\\" />\\n      </div>\\n\\n      <div class=\\\"unit-title\\\">\\n        <ya-unit-if condition=\\\"unit.title < 22\\\">\\n          <ya-clamp lines=\\\"3\\\" class=\\\"title-short\\\"><ya-unit-title /></ya-clamp>\\n        </ya-unit-if>\\n\\n        <ya-unit-if condition=\\\"unit.title > 21 & unit.title < 33\\\">\\n          <ya-clamp lines=\\\"3\\\" class=\\\"title-mid\\\"><ya-unit-title /></ya-clamp>\\n        </ya-unit-if>\\n\\n        <ya-unit-if condition=\\\"unit.title > 32\\\">\\n          <ya-clamp lines=\\\"3\\\" class=\\\"title-long\\\"><ya-unit-title /></ya-clamp>\\n        </ya-unit-if>\\n      </div>\\n\\n      <!-- Начало Шаблона ТГО -->\\n      <ya-unit-if condition=\\\"!unit.isRmp\\\">\\n        <div class=\\\"unit-prices\\\"><ya-unit-price /><ya-unit-old-price /></div>\\n        <ya-clamp lines=\\\"2\\\" class=\\\"unit-desc\\\"><ya-unit-desc /></ya-clamp>\\n      </ya-unit-if>\\n      <!-- Конец Шаблона ТГО -->\\n\\n\\n    \\n      <!-- Начало Шаблона РМП -->\\n      <ya-unit-if condition=\\\"unit.isRmp\\\">\\n        <div class=\\\"rmp-app-content\\\">\\n          <ya-unit-app-icon />\\n\\n          <div class=\\\"rmp-text-content\\\">\\n\\n            <div class=\\\"unit-app-name\\\">\\n              <ya-clamp lines=\\\"2\\\">\\n                <ya-unit-app-name />\\n              </ya-clamp>\\n            </div>\\n\\n            <div class=\\\"unit-app-rating\\\">\\n              <ya-unit-rating />\\n              <ya-unit-review-count />\\n            </div>\\n          </div>\\n\\n        </div>\\n\\n      </ya-unit-if>\\n      <!-- Конец Шаблона РМП -->\\n\\n      <div class=\\\"unit-cta\\\">\\n        <div class=\\\"unit-domain\\\">\\n          <ya-unit-mobile-app-button />\\n          <ya-unit-if condition=\\\"!unit.isRmp\\\">\\n            <span class=\\\"unit-domain-no-wrap\\\">\\n              <span class=\\\"unit-favicon\\\"><ya-unit-favicon size=\\\"32\\\"/></span>\\n              <ya-unit-domain class=\\\"domain\\\"/>\\n            </span>\\n          </ya-unit-if>\\n          \\n        </div>\\n      </div>\\n\\n    </div>\\n  </div>\\n\\n</ya-units-grid>\",\"css\":\"/* Шаблон 9: Универсайльный сингл размером 100% x Auto.\\n   Подходит для использования на сайтах, использующих \\n   единую верстку для мобильных устройств и десктопов */\\n\\n/* Шаблоны не работают в браузерах IE 11 версии и ниже */\\n\\n/* РМП — Реклама Мобильных Приложений */\\n\\n\\n/* -------- Переменные цветов -------- */\\n/* Изменив значение цвета в переменной, оно одновременно\\n   изменится во всех элементах шаблона, где указано */\\n.ya-container {\\n\\n  --color-blue: #3377FF;\\n  --color-blue-dark: #0055FF;\\n\\n  --color-blue-transparent: #3377FF1A;\\n  --color-blue-dark-transparent: #0055FF1A;\\n\\n  --color-black: #232526;\\n  --color-grey: #575c66;\\n  --color-grey-alt: #A3ACBF;\\n  --color-light: #f4f4f6;\\n  --color-light-alt: #ececef;\\n}\\n\\n/* Переменные цветов для устройств с поддержкой \\n   цветового профиля Display P3 (устройства Apple) */\\n\\n/* Устройства Apple поддерживают цветовой профиль \\n   с более яркими цветами (цветовой профиль Display P3). \\n   Если вы хотите поддержать его, то следует поменять \\n   значения цветов в блоке ниже */\\n@supports (color: color(display-p3)) {\\n  .ya-container {\\n    --color-blue: color(display-p3 0.2 0.47 1.0);\\n    --color-blue-dark: color(display-p3 0.0 0.33 1.0);\\n\\n    --color-blue-transparent: color(display-p3 0.2 0.47 1.0 / 0.1);\\n    --color-blue-dark-transparent: color(display-p3 0.0 0.33 1.0 / 0.1);\\n\\n    --color-yellow: color(display-p3 1.0 0.8 0.2);\\n    --color-yellow-dark: color(display-p3 1.0 0.75 0.0);\\n  }\\n}\\n\\n\\n\\n/* -------- Переменные для отрисовки объявления -------- */\\n\\n.ya-container {\\n\\n  /* Адаптивность объявления по ширине.\\n     Укажите значение none, чтобы зафиксировать размер объявления.\\n     Укажите auto, чтобы объявление занимало всю доступную ширину */\\n  --banner-flex: auto;\\n\\n  /* Фиксированная ширина объявления.\\n     Работает при --banner-flex: none */\\n  --banner-width: 300px;\\n\\n  /* Минимальная и максимальная ширина объявления.\\n     Работает при --banner-flex: auto */\\n  --banner-min-width: 320px;\\n  --banner-max-width: 100%;\\n\\n  --content-max-width: 960px;\\n\\n  /* Минимальная и максимальная высота объявления.\\n     Объявление будет растягиваться по высоте \\n     в зависимости от количества контента */\\n  --banner-min-height: 300px;\\n  --banner-max-height: none;\\n\\n\\n  /* Отображение фавиконки: \\n     вкл - block, выкл - none; */\\n  --display-favicon: block;\\n  /* Отображение изображения: \\n     вкл - block, выкл - none; */\\n  --display-image: block;\\n  /* Отображение текста: \\n     вкл - block, выкл - none; */\\n  --display-desc: inline;\\n  /* Отображение цен: \\n     вкл - inline, выкл - none */\\n  --display-price: inline;\\n  /* Отображение количества отзывов (для РМП): \\n     вкл - inline, выкл - none */\\n  --display-rmp-rating-count: inline;\\n\\n\\n  /* Ширина картинки */\\n  --image-width: 100%;\\n\\n  /* Максимальная ширина картинки */\\n  --image-max-width: 100%;\\n\\n  /* Высота картинки */\\n  --image-height: 160px;\\n\\n  /* Размер иконки приложения.\\n     Только для рекламы мобильных приложений */\\n  --app-icon-size: 48px;\\n\\n  /* Горизонтальное позиционирование сетки баннеров\\n     center - по середине, flex-start - слева,\\n     space-between - по всей ширине, space-around - по всей ширине с отступами\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/justify-content */\\n  --banners-justify-content: center;\\n\\n  /* Отступы вокруг объявления */\\n  --banner-margin: 8px 0;\\n\\n  /* Отступы первых и последних объявлений от края \\n     по горизонтали и вертикали. Значение var(--banner-margin) \\n     повторяет общее значение отступов. \\n     ! Неприменимо для одиночных объявлений */\\n  --banners-grid-first-item-top-margin: 0;\\n  --banners-grid-first-item-left-margin: 0;\\n  --banners-grid-first-item-right-margin: 0;\\n  --banners-grid-first-item-bottom-margin: 0;\\n\\n  /* Цвет фона объявления. Пример: white или #f0f2f8;\\n     Допустимо использование переменных. См. начало документа */\\n  --banner-background: var(--color-light);\\n  /* Цвет фона при наведении на объявление */\\n  --banner-background-hover: var(--color-light);\\n\\n  /* Обводка объявления. Для отключения укажите значение none\\n     Пример: solid 1px rgba(0 0 0 / 15%);\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/border */\\n  --banner-stroke: none;\\n  \\n  /* Тень объявления. Пример: 0px 8px 24px rgba(0, 21, 64, 0.125);\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/box-shadow */\\n  --banner-shadow: none;\\n  /* Тень объявления при наведении */\\n  --banner-shadow-hover: none;\\n  /* Трансформация объявления при наведении. Пример: translateY(-2px); */\\n  --banner-transform-hover: none;\\n  /* Анимация изменений при наведении */\\n  --banner-transition: box-shadow 120ms ease, transform 120ms ease;\\n\\n  /* Скругление углов объявления */\\n  --banner-outer-border-radius: 0px;\\n  /* Скругление углов внутренних элементов объявления (картинка, кнопки) */\\n  --banner-inner-border-radius: 8px;\\n  \\n  /* Отступы элементов от краев объявления */\\n  --banner-padding-outer: 10px;\\n  /* Отступы между элементами объявления */\\n  --banner-padding-inner: 10px;\\n\\n\\n  /* Цвет заголовка в объявлении */\\n  --color-text-header: var(--color-black); \\n  /* Цвет текста в объявлении */\\n  --color-text-desc: var(--color-grey-alt);\\n  /* Цвет цены в объявлении */\\n  --color-text-price: var(--color-black);\\n  /* Цвет ссылки в объявлении */\\n  --color-text-domain: var(--color-blue);\\n  /* Цвет ссылки в объявлении при наведении */\\n  --color-text-domain-hover: var(--color-blue-dark);\\n  /* Фон кнопки действия. Не применимо, если кнопка \\n     не предусмотрена в шаблоне (для форматов маленького размера) */\\n  --color-background-domain: var(--color-blue-transparent);\\n  /* Фон кнопки действия при наведении */\\n  --color-background-domain-hover: var(--color-blue-dark-transparent);\\n\\n  /* Цвет названия приложения в объявления (для РМП) */\\n  --color-text-app-name: var(--color-grey-alt);\\n\\n\\n  /* Цепочка используемых шрифтов в объявлении. По умолчанию указана \\n     цепочка системных шрифтов. Если шрифт не поддерживается, используется \\n     следующий по цепочке. При использовании собственного шрифта, \\n     следует указывать его название в самом начале */\\n  --font-family: \\n    -apple-system, BlinkMacSystemFont, \\\"Segoe UI\\\", Roboto, \\n    Oxygen, Ubuntu, Cantarell, \\\"Open Sans\\\", \\\"Helvetica Neue\\\", sans-serif, \\n    Apple Color Emoji, Segoe UI Emoji;\\n\\n  /* Размер шрифта и межстрочное расстояние для коротких заголовков\\n     (до 21 символа) */\\n  --font-size-title-short: 24px;\\n  --line-height-title-short: calc(1em + 0px);\\n\\n  /* Размер шрифта и межстрочное расстояние для заголовков средней длины \\n     (от 22 до 31 символа) */\\n  --font-size-title-mid: 20px;\\n  --line-height-title-mid: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для длинных заголовков \\n     (от 32 символов) */\\n  --font-size-title-long: 20px;\\n  --line-height-title-long: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для заголовков РМП */\\n  --font-size-title-rmp: 20px;\\n  --line-height-title-rmp: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для цен */\\n  --font-size-price: 16px;\\n  --line-height-price: calc(1em + 4px);\\n\\n  /* Размер шрифта и межстрочное расстояние для текста объявления */\\n  --font-size-desc: 15px;\\n  --line-height-desc: calc(1em + 3px);\\n\\n  /* Размер шрифта и межстрочное расстояние для ссылки */\\n  --font-size-domain: 15px;\\n  --line-height-domain: 20px;\\n\\n  /* Размер шрифта и межстрочное расстояние для названия приложения \\n     (для РМП) */\\n  --font-size-app-name: 15px;\\n  --line-height-app-name: calc(1em + 3px);\\n  \\n\\n  width: 100%;\\n  margin: 0 auto;\\n\\n  height: auto;\\n  padding: 0;\\n  overflow: visible;\\n}\\n\\n/* Специальные переменные для Рекламы Мобильных Приложений */\\n.ya-unit-item-rmp {\\n  /* Цвет текста ссылки */\\n  --color-text-domain: var(--color-blue);\\n  /* Цвет текста ссылки при наведении */\\n  --color-text-domain-hover: var(--color-blue-dark);\\n  /* Цвет фона кнопки объявления.\\n     Не применимо если, кнопки не предусмотрено (для маленьких форматов) */\\n  --color-background-domain: var(--color-blue-transparent);\\n  /* Цвет фона кнопки объявления при наведении */\\n  --color-background-domain-hover: var(--color-blue-dark-transparent);\\n}\\n\\n/* Специальные значения для размеров экрана шире 360px */\\n@media screen and (min-width: 360px) {\\n\\n  .ya-container {\\n    --image-height: 200px;\\n\\n    --app-icon-size: 64px;\\n\\n    --font-size-title: 18px;\\n    --line-height-title: calc(1em + 2px);\\n\\n    --font-size-title-short: 28px;\\n    --line-height-title-short: calc(1em + 0px);\\n  \\n    --font-size-title-mid: 24px;\\n    --line-height-title-mid: calc(1em + 2px);\\n  \\n    --font-size-title-long: 22px;\\n    --line-height-title-long: calc(1em + 2px);\\n\\n    --font-size-price: 20px;\\n    --line-height-price: calc(1em + 0px);\\n\\n    --font-size-desc: 16px;\\n    --line-height-desc: calc(1em + 4px);\\n\\n    --font-size-app-name: 18px;\\n    --line-height-app-name: calc(1em + 2px);\\n\\n    --font-size-domain: 16px;\\n    --line-height-domain: 20px;\\n\\n    --banner-padding-outer: 12px;\\n    --banner-padding-inner: 12px;\\n  }\\n}\\n\\n/* Специальные значения для размеров экрана шире 420px */\\n@media screen and (min-width: 420px) {\\n  .ya-container {\\n    --image-height: 240px;\\n\\n    --font-size-title: 18px;\\n    --line-height-title: calc(1em + 2px);\\n\\n    --font-size-title-short: 32px;\\n    --line-height-title-short: calc(1em + 0px);\\n\\n    --font-size-title-mid: 26px;\\n    --line-height-title-mid: calc(1em + 2px);\\n\\n    --font-size-title-long: 24px;\\n    --line-height-title-long: calc(1em + 2px);\\n\\n    --font-size-desc: 16px;\\n    --line-height-desc: calc(1em + 4px);\\n\\n    --font-size-app-name: 20px;\\n    --line-height-app-name: calc(1em + 2px);\\n\\n    --font-size-domain: 16px;\\n  }\\n}\\n\\n/* Специальные значения для размеров экрана шире 540px */\\n@media screen and (min-width: 540px) {\\n  .ya-container {\\n\\n    /* Максимальная ширина картинки */\\n    --image-width: 50%;\\n\\n    /* Максимальная ширина картинки */\\n    --image-max-width: 400px;\\n\\n    /* Высота картинки */\\n    --image-height: 100%;\\n  }\\n\\n  .unit-container .unit-content {\\n    flex-direction: row;\\n    padding: var(--banner-padding-outer);\\n  }\\n\\n  .unit-container .unit-text-content {\\n    position: relative;\\n    padding-left: 16px;\\n    width: 50%;\\n  }\\n\\n  .unit-text-content .unit-meta {\\n    position: relative;\\n    margin-top: 0;\\n    top: 0;\\n    left: 0;\\n    padding: 0;\\n  }\\n\\n  .unit-cta {\\n    margin-top: auto !important;\\n  }\\n}\\n\\n\\n\\n\\n/* -------- Далее — настройка стилей объявления. -------- */\\n/* -------- Не рекомендуется редактировать -------- */\\n\\n.ya-units-grid {\\n  margin: 0px auto;\\n}\\n\\n.grid-row {\\n  justify-content: var(--banners-justify-content);\\n  align-content: var(--banners-align-content);\\n  padding: 0px 0;\\n}\\n\\n.grid-item {\\n  width: var(--banner-width);\\n  min-width: var(--banner-min-width);\\n  max-width: var(--banner-max-width);\\n  \\n  min-height: var(--banner-min-height);\\n  max-height: var(--banner-max-height);\\n\\n  font-family: var(--font-family);\\n  background: var(--banner-background);\\n  border: var(--banner-stroke);\\n\\n  margin: var(--banner-margin, inherit);\\n  border-radius: var(--banner-outer-border-radius);\\n  overflow: hidden;\\n  box-sizing: border-box;\\n  flex: var(--banner-flex);\\n  box-shadow: var(--banner-shadow);\\n  transform: none;\\n  transition: var(--banner-transition);\\n}\\n\\n.grid-item:hover {\\n  transform: var(--banner-transform-hover);\\n  box-shadow: var(--banner-shadow-hover);\\n  background: var(--banner-background-hover);\\n  --color-text-domain: var(--color-text-domain-hover);\\n}\\n\\n.grid-item:first-child {\\n  margin-left: var(--banners-grid-first-item-left-margin);\\n}\\n\\n.grid-item:last-child {\\n  margin-right: var(--banners-grid-first-item-right-margin);\\n}\\n\\n.grid-row:first-child .grid-item {\\n  margin-top: var(--banners-grid-first-item-top-margin);\\n}\\n\\n.grid-row:last-child .grid-item {\\n  margin-bottom: var(--banners-grid-first-item-bottom-margin);\\n}\\n\\n.unit-wrapper {\\n  height: 100%;\\n}\\n\\n.ya-unit-favicon {\\n  display: block !important;\\n}\\n\\na.yrw-url {\\n  color: inherit;\\n  cursor: pointer;\\n}\\n\\n.unit-misc {\\n  position: absolute;\\n  top: 0;\\n  left: 0;\\n  width: 100%;\\n  height: 100%;\\n}\\n\\n.unit-meta {\\n  position: absolute;\\n  top: 10px;\\n  left: var(--banner-padding-outer);\\n  z-index: 2;\\n  padding: 0px 4px 0px;\\n  text-transform: uppercase;\\n  height: 12px;\\n  background: transparent;\\n  color: var(--color-grey);\\n  border-radius: 4px;\\n  font-size: 8px;\\n  line-height: 13px;\\n  font-weight: 500;\\n  letter-spacing: 0.12em;\\n  vertical-align: 5px;\\n  margin: 0;\\n  user-select: none;\\n  -ms-user-select: none;\\n  -moz-user-select: none;\\n  -khtml-user-select: none;\\n  -webkit-user-select: none;\\n}\\n\\n.ya-unit-item-rmp .unit-meta {\\n  background: transparent;\\n}\\n\\n.unit-age::before {\\n  content: \\\" | \\\";\\n}\\n\\n.unit-age:empty {\\n  display: none;\\n}\\n\\n.ya-unit-kebab_button svg circle {\\n  fill: var(--color-grey);\\n}\\n\\n.ya-unit-kebab_bg {\\n  background: transparent;\\n  opacity: 1.0;\\n}\\n\\n.ya-unit-kebab_icon {\\n  filter: var(--display-image, none);\\n}\\n\\n.ya-unit-kebab_icon circle {\\n  fill: var(--color-grey) !important;\\n}\\n\\n.ya-unit-kebab_button {\\n  position: absolute;\\n  z-index: 940;\\n  top: 4px;\\n  right: 4px;\\n  width: 24px;\\n  height: 24px;\\n}\\n\\n.yrw-body_warning {\\n  position: relative;\\n}\\n\\n.yrw-body_warning div {\\n  padding: 0;\\n}\\n\\n.yrw-body_warning div:not(.yrw-warning-wrapper):not(.yrw-warning-text) {\\n  position: relative;\\n  background-color: var(--color-light-alt);\\n  color: #575c66;\\n  display: flex;\\n  padding: 0 calc(var(--inner-border-radius) / 2);\\n}\\n\\n.yrw-body_warning div text {\\n  fill: #575c66;\\n}\\n\\n.yrw-body_warning div:not(.yrw-warning-wrapper) {\\n  padding: 0 calc(var(--inner-border-radius) / 2 + 4px);\\n}\\n\\n.yrw-warning-text {\\n  text-shadow: none;\\n}\\n\\n\\n\\n.unit-container {\\n  box-sizing: border-box;\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: flex-end;\\n  overflow: hidden;\\n  max-width: var(--content-max-width, --banner-max-width, 960px);\\n  margin: auto;\\n}\\n\\n.unit-content {\\n  position: relative;\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: flex-start;\\n  height: 100%;\\n  margin: 0;\\n  padding: 8px;\\n  padding: var(--banner-padding-outer);\\n  padding-top: 32px;\\n}\\n\\n.unit-text-content {\\n  display: flex;\\n  justify-content: flex-start;\\n  flex-direction: column;\\n  flex: auto;\\n}\\n\\n.rmp-app-content {\\n  display: flex;\\n  flex-direction: row;\\n}\\n\\n.rmp-text-content {\\n  display: flex;\\n  justify-content: center;\\n  flex-direction: column;\\n}\\n\\n.unit-text-content > div {\\n  margin-top: var(--banner-padding-inner);\\n}\\n\\n.rmp-text-content > div {\\n  margin-top: calc(var(--banner-padding-inner) / 2);\\n}\\n\\n.rmp-text-content > div:first-child {\\n  margin-top: 0;\\n}\\n\\n.unit-text-content > .unit-meta,\\n.rmp-text-content > .unit-meta {\\n  margin-top: 0;\\n}\\n\\n\\n\\n.ya-unit-title, .unit-title {\\n  color: var(--color-text-header);\\n  font-size: var(--font-size-title);\\n  line-height: var(--line-height-title);\\n  font-weight: 600;\\n  display: flex;\\n}\\n\\n.title-short {\\n  font-size: var(--font-size-title-short);\\n  line-height: var(--line-height-title-short);\\n}\\n\\n.title-mid {\\n  font-size: var(--font-size-title-mid);\\n  line-height: var(--line-height-title-mid);\\n}\\n\\n.title-long {\\n  font-size: var(--font-size-title-long);\\n  line-height: var(--line-height-title-long);\\n}\\n\\n.title-rmp {\\n  font-size: var(--font-size-title-rmp);\\n  line-height: var(--line-height-title-rmp);\\n\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: center;\\n}\\n\\n.unit-app-name {\\n  font-size: var(--font-size-app-name);\\n  line-height: var(--line-height-app-name);\\n  color: var(--color-text-app-name);\\n}\\n\\n\\n.unit-cta {\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: center;\\n\\n  box-sizing: border-box;\\n  padding: 12px;\\n\\n  font-size: var(--domain-font-size);\\n  line-height: var(--domain-line-height);\\n  text-align: center;\\n\\n  color: var(--color-cta-color);\\n  background-color: var(--color-background-domain);\\n  border-radius: var(--banner-inner-border-radius);\\n  margin-top: var(--banner-padding-inner);\\n  transition: var(--cta-transition);\\n}\\n\\n.unit-cta:hover {\\n  color: var(--color-cta-hover-color);\\n  background-color: var(--color-background-domain-hover);\\n}\\n\\n\\n.unit-favicon {\\n  width: var(--line-height-domain);\\n  background-color: transparent;\\n  border-radius: 3px;\\n  align-self: center;\\n  display: var(--display-favicon, inline);\\n}\\n\\n.ya-unit-favicon {\\n  width: var(--line-height-domain);\\n  height: var(--line-height-domain);\\n}\\n\\n.ya-unit-rating {\\n  margin-right: 4px;\\n  height: 16px;\\n  display: inline;\\n}\\n\\n.ya-unit-review-count {\\n  display: var(--display-rmp-rating-count);\\n  transform: translateY(1px);\\n  color: var(--color-grey-alt);\\n  font-size: 13px;\\n  line-height: 16px;\\n}\\n\\n.unit-favicon:empty,\\n.ya-unit-domain:empty,\\n.unit-domain:empty {\\n  display: none;\\n}\\n\\n.unit-domain {\\n  display: flex;\\n  margin-right: auto;\\n  border-radius: 4px;\\n\\n  color: var(--color-text-domain);\\n  font-size: var(--font-size-domain);\\n  line-height: var(--line-height-domain);\\n  padding: 0;\\n\\n  width: 100%;\\n  height: var(--line-height-domain, 16px);\\n\\n  flex-direction: row;\\n  flex-wrap: wrap;\\n  justify-content: center;\\n  align-content: flex-end;\\n\\n  overflow: hidden;\\n}\\n\\n.unit-domain > *,\\n.unit-domain .unit-domain-no-wrap > * {\\n  margin-right: calc(var(--line-height-domain) / 3.5);\\n}\\n\\n.unit-domain span {\\n  flex: none;\\n}\\n\\n.unit-domain-no-wrap {\\n  display: flex;\\n}\\n\\n\\n\\n.unit-app-rating {\\n  display: flex;\\n  flex-direction: row;\\n  align-content: center;\\n}\\n\\n.unit-prices {\\n  display: var(--display-price, inline);\\n  white-space: nowrap;\\n\\n  font-size: var(--font-size-price);\\n  line-height: var(--line-height-price);\\n}\\n\\n.ya-unit-price {\\n  color: var(--color-text-price);\\n  font-weight: 600;\\n\\n  display: inline;\\n  white-space: nowrap;\\n}\\n\\n.ya-unit-old-price {\\n  margin-left: 8px;\\n  font-size: max(0.9em, 12px);\\n  line-height: max(0.9em, 12px);\\n  color: var(--color-grey-alt);\\n\\n  position: relative;\\n  white-space: nowrap;\\n  display: inline;\\n}\\n\\n.ya-unit-old-price::after {\\n  content: \\\"\\\";\\n  position: absolute;\\n  bottom: 0;\\n  left: 0;\\n  width: 100%;\\n  height: 100%;\\n  \\n  background-image: url(\\\"data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='100%' height='100%'><line class='line' x1='0' y1='65%' x2='100%' y2='50%' stroke='%23A3ACBF' stroke-width='8vh' /></svg>\\\");\\n  background-repeat: no-repeat;\\n}\\n\\n.unit-desc {\\n  display: var(--display-desc);\\n  color: var(--color-text-desc);\\n  font-size: var(--font-size-desc);\\n  line-height: var(--line-height-desc);\\n}\\n\\n\\n\\n.unit-image-block {\\n  display: var(--display-image);\\n  width: var(--image-width);\\n  max-width: var(--image-max-width, none);\\n  height: var(--image-height);\\n  flex: none;\\n  border-radius: var(--banner-inner-border-radius);\\n  position: relative;\\n\\n  box-sizing: border-box;\\n  background-color: var(--color-light-alt);\\n  overflow: hidden;\\n}\\n\\n.unit-image {\\n  width: 100%;\\n  height: 100%;\\n  display: var(--display-image);\\n  position: relative;\\n}\\n\\n.video-source-container {\\n  border-radius: var(--banner-inner-border-radius, 8px);\\n  z-index: 1;\\n  overflow: hidden;\\n}\\n\\n.ya-unit-app-icon {\\n  position: relative;\\n\\n  border-radius: calc(var(--app-icon-size) / 4);\\n  margin-right: var(--banner-padding-inner);\\n  display: flex;\\n}\\n\\n.unit-app-icon {\\n  margin: auto;\\n}\\n\\n.ya-unit-app-icon .yrw-img-component {\\n  width: var(--app-icon-size);\\n  height: var(--app-icon-size);\\n}\\n\\n.ya-unit-image {\\n  height: 100%;\\n}\\n\\n.yrw-img-component {\\n  height: 100%;\\n  padding-bottom: 0;\\n}\\n\\n.unit-image .img-source-component {\\n  border-radius: var(--banner-inner-border-radius);\\n  background-image: url(\\\"data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='256' height='256'><rect x='80' y='80' width='96' height='96' rx='19.2' fill='%23405580' fill-opacity='0.15'/><path d='M144.619 110.181H147.619C147.619 108.524 146.276 107.181 144.619 107.181V110.181ZM111.102 147.94L146.74 112.302L142.498 108.06L106.86 143.698L111.102 147.94ZM114.072 113.181H144.619V107.181L114.072 107.181V113.181ZM141.619 110.181V140.728H147.619V110.181L141.619 110.181Z' fill='white'/></svg>\\\");\\n  background-position: center;\\n}\\n\\n.ya-unit-app-icon .img-source-component {\\n  border-radius: calc(var(--app-icon-size) / 4 - 4px);\\n}\\n\\n.ya-clamp {\\n  width: 100%;\\n}\\n\\n.yrw-content {\\n  overflow: visible;\\n}\\n\\n.ya-grid-template:empty {\\n  display: none;\\n}\",\"gridColumns\":\"1\",\"gridRows\":\"1\",\"defaultWidth\":\"700\",\"props\":{}},{\"value\":\"24\",\"label\":\"300x600\",\"template\":\"<div class=\\\"wrapper\\\">\\n  <ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n    <div class=\\\"container\\\">\\n      <div class=\\\"image\\\">\\n        <ya-unit-image ratio=\\\"1\\\" />\\n        <div class=\\\"img-source\\\"></div>\\n      </div>\\n      <ya-clamp lines=\\\"3\\\" class=\\\"title\\\">\\n        <ya-unit-title />\\n      </ya-clamp>\\n      <ya-clamp lines=\\\"1\\\" class=\\\"category\\\">\\n        <ya-unit-category />\\n      </ya-clamp>\\n      <ya-clamp lines=\\\"1\\\" class=\\\"domain\\\">\\n        <ya-unit-domain />\\n      </ya-clamp>\\n    </div>\\n  </ya-units-grid>\\n</div>\\n\",\"css\":\".headline {\\n  font-size: 18px;\\n  line-height: 24px;\\n  color: #000;\\n  padding-bottom: 1px;\\n  padding-top: 1px;\\n}\\n\\n.grid-row {\\n  margin-top: 20px;\\n}\\n\\n.grid-item {\\n  margin-left: 10px;\\n}\\n\\n.unit-wrapper {\\n  width: 293px;\\n  height: 290px;\\n}\\n\\n.image {\\n  width: 293px;\\n  height: 290px;\\n}\\n\\n.container {\\n  width: 293px;\\n  height: 290px;\\n}\\n\\n.title {\\n  font-size: 26px;\\n  display: block;\\n  display: -webkit-box;\\n  overflow: hidden;\\n  max-height: 180px;\\n  line-height: 30px;\\n  text-overflow: ellipsis;\\n  color: #fff;\\n  width: 253px;\\n  font-weight: 900;\\n  word-break: break-word;\\n  word-wrap: break-word;\\n  text-decoration: none;\\n  margin-left: 20px;\\n  position: absolute;\\n  bottom: 60px;\\n  box-sizing: border-box;\\n}\\n\\n.meta {\\n  font-size: 13px;\\n}\\n\\n.category {\\n  padding-top: 0px;\\n  font-size: 13px;\\n  line-height: 15px;\\n  white-space: nowrap;\\n  color: #fff;\\n  position: absolute;\\n  bottom: 25px;\\n  box-sizing: border-box;\\n  margin: 20px 15px 0px 20px;\\n}\\n\\n.domain {\\n  margin-right: 15px;\\n  padding-top: 0px;\\n  font-size: 13px;\\n  line-height: 15px;\\n  white-space: nowrap;\\n  color: #8d96b2;\\n  margin-left: 90px;\\n  position: absolute;\\n  bottom: 25px;\\n  box-sizing: border-box;\\n}\\n\\n.unit-wrapper:hover .image {\\n  opacity: 0.9;\\n}\\n\\n.img-source:after {\\n  content: \\\"\\\";\\n  position: absolute;\\n  top: 0;\\n  bottom: 0;\\n  left: 0;\\n  right: 0;\\n  background-color: #000;\\n  opacity: 0.4;\\n}\\n\\n.ya-container {\\n  font-family: inherit!important;\\n}\\n\\n.ya-recommendation-widget {\\n  font-family: inherit!important;\\n}\\n\",\"gridColumns\":\"3\",\"gridRows\":\"1\",\"allowedOwnerIds\":[120143188],\"defaultWidth\":\"1000\",\"props\":{}},{\"value\":\"25\",\"label\":\"Desktop 3\",\"template\":\"<div class=\\\"wrapper\\\">\\n  <ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n    <div class=\\\"container\\\">\\n      <div class=\\\"image\\\">\\n        <ya-unit-image ratio=\\\"1\\\" />\\n        <div class=\\\"img-source\\\"></div>\\n      </div>\\n      <ya-clamp lines=\\\"3\\\" class=\\\"title\\\"><ya-unit-title /></ya-clamp>\\n      <ya-clamp lines=\\\"1\\\" class=\\\"category\\\"><ya-unit-category /></ya-clamp>\\n      <ya-clamp lines=\\\"1\\\" class=\\\"domain\\\"><ya-unit-domain /></ya-clamp>\\n    </div>\\n  </ya-units-grid>\\n</div>\\n\",\"css\":\".headline {\\n  font-size: 18px;\\n  line-height: 24px;\\n  color: #000;\\n  padding-bottom: 1px;\\n  padding-top: 1px;\\n}\\n\\n.grid-row {\\n  margin-top: 20px;\\n}\\n\\n.grid-item {\\n  margin-left: 23px;\\n}\\n\\n.unit-wrapper {\\n  width: 293px;\\n  height: 290px;\\n}\\n\\n.image {\\n  width: 293px;\\n  height: 290px;\\n}\\n\\n.container {\\n  max-width: 100%;\\n  max-width: 1240px;\\n  height: 290px;\\n}\\n\\n.title {\\n  font-size: 26px;\\n  display: block;\\n  display: -webkit-box;\\n  overflow: hidden;\\n  max-height: 180px;\\n  line-height: 30px;\\n  text-overflow: ellipsis;\\n  color: #fff;\\n  width: 253px;\\n  font-weight: 900;\\n  word-break: break-word;\\n  word-wrap: break-word;\\n  text-decoration: none;\\n  margin-left: 20px;\\n  position: absolute;\\n  bottom: 60px;\\n  box-sizing: border-box;\\n}\\n\\n.meta {\\n  font-size: 13px;\\n}\\n\\n.category {\\n  padding-top: 0px;\\n  font-size: 13px;\\n  line-height: 15px;\\n  white-space: nowrap;\\n  color: #fff;\\n  position: absolute;\\n  bottom: 25px;\\n  box-sizing: border-box;\\n  margin: 20px 15px 0px 20px;\\n}\\n\\n.domain {\\n  margin-right: 15px;\\n  padding-top: 0px;\\n  font-size: 13px;\\n  line-height: 15px;\\n  white-space: nowrap;\\n  color: #8d96b2;\\n  margin-left: 90px;\\n  position: absolute;\\n  bottom: 25px;\\n  box-sizing: border-box;\\n}\\n\\n.unit-wrapper:hover .image {\\n  opacity: 0.9;\\n}\\n\\n.img-source:after {\\n  content: \\\"\\\";\\n  position: absolute;\\n  top: 0;\\n  bottom: 0;\\n  left: 0;\\n  right: 0;\\n  background-color: #000;\\n  opacity: 0.4;\\n}\\n\\n.ya-container {\\n  font-family: inherit!important;\\n}\\n\\n.ya-recommendation-widget {\\n  font-family: inherit!important;\\n}\\n\",\"gridColumns\":\"3\",\"gridRows\":\"1\",\"allowedOwnerIds\":[120143188],\"defaultWidth\":\"1000\",\"props\":{}},{\"value\":\"26\",\"label\":\"Desktop 4\",\"template\":\"<div class=\\\"wrapper\\\">\\n  <ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n    <div class=\\\"container\\\">\\n      <div class=\\\"image\\\">\\n        <ya-unit-image ratio=\\\"1\\\" />\\n        <div class=\\\"img-source\\\"></div>\\n      </div>\\n      <ya-clamp lines=\\\"3\\\" class=\\\"title\\\"><ya-unit-title /></ya-clamp>\\n      <ya-clamp lines=\\\"1\\\" class=\\\"category\\\"><ya-unit-category /></ya-clamp>\\n      <ya-clamp lines=\\\"1\\\" class=\\\"domain\\\"><ya-unit-domain /></ya-clamp>\\n    </div>\\n  </ya-units-grid>\\n</div>\\n\",\"css\":\".headline {\\n  font-size: 18px;\\n  line-height: 24px;\\n  color: #000;\\n  padding-bottom: 1px;\\n  padding-top: 1px;\\n}\\n\\n.grid-row {\\n  margin-top: 20px;\\n}\\n\\n.grid-item {\\n  margin-left: 23px;\\n}\\n\\n.unit-wrapper {\\n  width: 293px;\\n  height: 290px;\\n}\\n\\n.image {\\n  width: 293px;\\n  height: 290px;\\n}\\n\\n.container {\\n  max-width: 100%;\\n  max-width: 1240px;\\n  height: 290px;\\n}\\n\\n.title {\\n  font-size: 26px;\\n  display: block;\\n  display: -webkit-box;\\n  overflow: hidden;\\n  max-height: 180px;\\n  line-height: 30px;\\n  text-overflow: ellipsis;\\n  color: #fff;\\n  width: 253px;\\n  font-weight: 900;\\n  word-break: break-word;\\n  word-wrap: break-word;\\n  text-decoration: none;\\n  margin-left: 20px;\\n  position: absolute;\\n  bottom: 60px;\\n  box-sizing: border-box;\\n}\\n\\n.meta {\\n  font-size: 13px;\\n}\\n\\n.category {\\n  padding-top: 0px;\\n  font-size: 13px;\\n  line-height: 15px;\\n  white-space: nowrap;\\n  color: #fff;\\n  position: absolute;\\n  bottom: 25px;\\n  box-sizing: border-box;\\n  margin: 20px 15px 0px 20px;\\n}\\n\\n.domain {\\n  margin-right: 15px;\\n  padding-top: 0px;\\n  font-size: 13px;\\n  line-height: 15px;\\n  white-space: nowrap;\\n  color: #8d96b2;\\n  margin-left: 90px;\\n  position: absolute;\\n  bottom: 25px;\\n  box-sizing: border-box;\\n}\\n\\n.unit-wrapper:hover .image {\\n  opacity: 0.9;\\n}\\n\\n.img-source:after {\\n  content: \\\"\\\";\\n  position: absolute;\\n  top: 0;\\n  bottom: 0;\\n  left: 0;\\n  right: 0;\\n  background-color: #000;\\n  opacity: 0.4;\\n}\\n\\n.ya-container {\\n  font-family: inherit!important;\\n}\\n\\n.ya-recommendation-widget {\\n  font-family: inherit!important;\\n}\\n\",\"gridColumns\":\"3\",\"gridRows\":\"1\",\"allowedOwnerIds\":[120143188],\"defaultWidth\":\"1000\",\"props\":{}},{\"value\":\"27\",\"label\":\"Mobile 100\",\"template\":\"<div class=\\\"wrapper\\\">\\n  <ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n    <div class=\\\"container\\\">\\n      <div class=\\\"image\\\">\\n        <ya-unit-image ratio=\\\"1\\\" />\\n        <div class=\\\"img-source\\\"></div>\\n      </div>\\n      <ya-clamp lines=\\\"3\\\" class=\\\"title\\\"><ya-unit-title /></ya-clamp>\\n      <ya-clamp lines=\\\"1\\\" class=\\\"category\\\"><ya-unit-category /></ya-clamp>\\n      <ya-clamp lines=\\\"1\\\" class=\\\"domain\\\"><ya-unit-domain /></ya-clamp>\\n      <ya-clamp lines=\\\"2\\\" class=\\\"warning\\\"><ya-unit-warning /></ya-clamp>\\n    </div>\\n  </ya-units-grid>\\n</div>\\n\",\"css\":\".headline {\\n  font-size: 18px;\\n  line-height: 24px;\\n  color: #000;\\n  padding-bottom: 1px;\\n  padding-top: 1px;\\n}\\n\\n.grid-row {\\n  margin-top: 20px;\\n}\\n\\n.grid-item {\\n  margin-left: 10px;\\n}\\n\\n.unit-wrapper {\\n  widthf: 100%;\\n  height: 250px;\\n}\\n\\n.image {\\n  width: 100%;\\n  height: 250px;\\n}\\n\\n.container {\\n  width: 100%;\\n  height: 250px;\\n}\\n\\n.title {\\n  font-size: 26px;\\n  display: block;\\n  display: -webkit-box;\\n  overflow: hidden;\\n  max-height: 180px;\\n  line-height: 30px;\\n  text-overflow: ellipsis;\\n  color: #fff;\\n  width: 253px;\\n  font-weight: 900;\\n  word-break: break-word;\\n  word-wrap: break-word;\\n  text-decoration: none;\\n  margin-left: 20px;\\n  position: absolute;\\n  bottom: 60px;\\n  box-sizing: border-box;\\n}\\n\\n.meta {\\n  font-size: 13px;\\n}\\n\\n.category {\\n  padding-top: 0px;\\n  font-size: 13px;\\n  line-height: 15px;\\n  white-space: nowrap;\\n  color: #fff;\\n  position: absolute;\\n  bottom: 25px;\\n  box-sizing: border-box;\\n  margin: 20px 15px 0px 20px;\\n}\\n\\n.domain {\\n  margin-right: 15px;\\n  padding-top: 0px;\\n  font-size: 13px;\\n  line-height: 15px;\\n  white-space: nowrap;\\n  color: #8d96b2;\\n  margin-left: 90px;\\n  position: absolute;\\n  bottom: 25px;\\n  box-sizing: border-box;\\n}\\n\\n.unit-wrapper:hover .image {\\n  opacity: 0.9;\\n}\\n\\n.img-source:after {\\n  content: \\\"\\\";\\n  position: absolute;\\n  top: 0;\\n  bottom: 0;\\n  left: 0;\\n  right: 0;\\n  background-color: #000;\\n  opacity: 0.4;\\n}\\n\\n.ya-container {\\n  font-family: inherit!important;\\n}\\n\\n.ya-recommendation-widget {\\n  font-family: inherit!important;\\n}\\n\\n.warning {\\n  position: absolute;\\n  bottom: 0;\\n  font-size: 13px;\\n  line-height: 15px;\\n  white-space: nowrap;\\n  color: #fff;\\n  margin: 0px 0px 0px 0px;\\n}\\n\",\"gridColumns\":\"3\",\"gridRows\":\"1\",\"allowedOwnerIds\":[120143188],\"defaultWidth\":\"1000\",\"props\":{}},{\"value\":\"28\",\"label\":\"Native 2\",\"template\":\"<div class=\\\"wrapper\\\">\\n  <ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n    <div class=\\\"container\\\">\\n      <div class=\\\"image\\\">\\n        <ya-unit-image ratio=\\\"1\\\" />\\n        <div class=\\\"img-source\\\"></div>\\n      </div>\\n      <ya-clamp lines=\\\"3\\\" class=\\\"title\\\"><ya-unit-title /></ya-clamp>\\n      <ya-clamp lines=\\\"1\\\" class=\\\"category\\\"><ya-unit-category /></ya-clamp>\\n      <ya-clamp lines=\\\"1\\\" class=\\\"domain\\\"><ya-unit-domain /></ya-clamp>\\n    </div>\\n  </ya-units-grid>\\n</div>\\n\",\"css\":\".headline {\\n  font-size: 18px;\\n  line-height: 24px;\\n  color: #000;\\n  padding-bottom: 1px;\\n  padding-top: 1px;\\n}\\n\\n.grid-row {\\n  margin-top: 20px;\\n}\\n\\n.grid-item {\\n  margin-left: 10px;\\n}\\n\\n.unit-wrapper {\\n  width: 293px;\\n  height: 290px;\\n}\\n\\n.image {\\n  width: 293px;\\n  height: 290px;\\n}\\n\\n.container {\\n  width: 293px;\\n  height: 290px;\\n}\\n\\n.title {\\n  font-size: 26px;\\n  display: block;\\n  display: -webkit-box;\\n  overflow: hidden;\\n  max-height: 180px;\\n  line-height: 30px;\\n  text-overflow: ellipsis;\\n  color: #fff;\\n  width: 253px;\\n  font-weight: 900;\\n  word-break: break-word;\\n  word-wrap: break-word;\\n  text-decoration: none;\\n  margin-left: 20px;\\n  position: absolute;\\n  bottom: 60px;\\n  box-sizing: border-box;\\n}\\n\\n.meta {\\n  font-size: 13px;\\n}\\n\\n.category {\\n  padding-top: 0px;\\n  font-size: 13px;\\n  line-height: 15px;\\n  white-space: nowrap;\\n  color: #fff;\\n  position: absolute;\\n  bottom: 25px;\\n  box-sizing: border-box;\\n  margin: 20px 15px 0px 20px;\\n}\\n\\n.domain {\\n  margin-right: 15px;\\n  padding-top: 0px;\\n  font-size: 13px;\\n  line-height: 15px;\\n  white-space: nowrap;\\n  color: #8d96b2;\\n  margin-left: 90px;\\n  position: absolute;\\n  bottom: 25px;\\n  box-sizing: border-box;\\n}\\n\\n.unit-wrapper:hover .image {\\n  opacity: 0.9;\\n}\\n\\n.img-source:after {\\n  content: \\\"\\\";\\n  position: absolute;\\n  top: 0;\\n  bottom: 0;\\n  left: 0;\\n  right: 0;\\n  background-color: #000;\\n  opacity: 0.4;\\n}\\n\\n.ya-container {\\n  font-family: inherit!important;\\n}\\n\\n.ya-recommendation-widget {\\n  font-family: inherit!important;\\n}\\n\",\"gridColumns\":\"3\",\"gridRows\":\"1\",\"allowedOwnerIds\":[120143188],\"defaultWidth\":\"1000\",\"props\":{}},{\"value\":\"drive2-0\",\"template\":\"<div class=\\\"wrapper\\\">\\n    <ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n    <div class=\\\"container\\\">\\n        <div class=\\\"image\\\">\\n            <ya-unit-image ratio=\\\"0.5625\\\"/>\\n        </div>\\n        <div class=\\\"title\\\">\\n            <span class=\\\"link\\\"><ya-unit-title/></span>\\n        </div>\\n        <div class=\\\"info\\\">\\n            <div class=\\\"domain\\\">\\n                <span class=\\\"link\\\"><ya-unit-domain/></span>\\n            </div>\\n            <div class=\\\"category\\\">\\n                <ya-unit-category/>\\n            </div>\\n        </div>\\n    </div>\\n    <ya-unit-close />\\n</ya-units-grid>\\n</div>\",\"name\":\"grid\",\"css\":\".unit-wrapper {\\n    height: 100%;\\n    background-color: #fff;\\n}\\n.container {\\n    position: relative;\\n    height: 100%;\\n    display: -webkit-box;\\n    display: flex;\\n    -webkit-box-orient: vertical;\\n    -webkit-box-direction: normal;\\n    flex-direction: column;\\n    font-family: sans-serif;\\n    line-height: 1.25;\\n    word-wrap: break-word;\\n    font-size: 18px;\\n    border-radius: 6px;\\n    background-color: #fff;\\n}\\n\\n.image {\\n    position: relative;\\n    border-radius: 6px 6px 0 0;\\n    overflow: hidden;\\n}\\n\\n.title {\\n    -webkit-box-flex: 1;\\n    flex: 1 1 auto;\\n    margin: 12px 10px;\\n    word-break: break-word;\\n    font-size: 18px;\\n    font-weight: bold;\\n    line-height: 21px;\\n}\\n\\n.info {\\n    display: -webkit-box;\\n    display: flex;\\n    margin: -7px 10px 14px;\\n    white-space: nowrap;\\n    font-size: 12px;\\n    line-height: 1.4;\\n}\\n\\n.category {\\n    color: #808080;\\n}\\n\\n.domain {\\n    -webkit-box-flex: 1;\\n    flex: 1 1 auto;\\n    min-width: 0;\\n    margin-right: 5px;\\n    overflow: hidden;\\n    font-weight: bold;\\n    -webkit-mask: linear-gradient(-90deg,rgba(0,0,0,0),#000 40px,#000);\\n    mask: linear-gradient(-90deg,rgba(0,0,0,0),#000 40px,#000);\\n}\\n\\n.link {\\n    color: #333;\\n}\\n\\n@media (max-width: 639px) {\\n    .container:before,\\n    .container {\\n        border-radius: 3px;\\n    }\\n\\n    .image {\\n        border-radius: 3px 3px 0 0;\\n    }\\n\\n    .title {\\n        margin: 10px;\\n        font-size: 15px;\\n        line-height: 18px;\\n    }\\n}\",\"gridColumns\":\"1\",\"gridRows\":\"1\",\"props\":{}},{\"value\":\"9\",\"template\":\"<div class=\\\"wrapper\\\">\\n  <ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n    <div class=\\\"card\\\">\\n      <div class=\\\"image\\\">\\n        <ya-unit-image ratio=\\\"1.21\\\" />\\n      </div>\\n      <div class=\\\"text-wrap\\\">\\n        <ya-clamp class=\\\"title\\\" lines=\\\"3\\\"><ya-unit-title /></ya-clamp>\\n        <ya-clamp class=\\\"desc\\\" lines=\\\"6\\\"><ya-unit-desc /></ya-clamp>\\n        <div class=\\\"shadow\\\"></div>\\n        <div>\\n          <span class=\\\"button\\\"><ya-unit-domain /></span>\\n        </div>\\n      </div>\\n    </div>\\n    <ya-unit-close />\\n  </ya-units-grid>\\n  <a class=\\\"icon-link\\\" href=\\\"https://direct.yandex.ru/?partner\\\" target=\\\"_blank\\\">\\n    <span class=\\\"icon-link__text\\\">Яндекс Директ</span>\\n    ₽\\n  </a>\\n</div>\\n\",\"css\":\".wrapper {\\n  width: 320px;\\n  height: 600px;\\n  background: #EBEDEE;\\n}\\n@media (max-width: 1020px) {\\n  .wrapper {\\n    width: 310px;\\n    margin: -5px;\\n  }\\n}\\n.grid-row {\\n  margin-top: 9px;\\n}\\n.grid-item {\\n  font-family: Arial, sans-serif;\\n  font-weight: normal;\\n}\\n.card {\\n  height: 194px;\\n  display: flex;\\n}\\n.unit-wrapper {\\n  background-color: #fff;\\n  border-radius: 6px;\\n}\\n.unit-wrapper:hover .button {\\n  background-color: rgba(0, 153, 255, 0.25);\\n}\\n.unit-image {\\n  height: 100%;\\n  width: 161px;\\n}\\n.image {\\n  height: 194px;\\n  border-top-left-radius: 6px;\\n  border-top-right-radius: 6px;\\n}\\n.text-wrap {\\n  position: relative;\\n  padding: 8px 10px;\\n  width: 139px;\\n}\\n@media (max-width: 1020px) {\\n  .text-wrap {\\n    width: 129px;\\n  }\\n}\\n.title {\\n  margin: 0 0 6px;\\n  font-size: 16px;\\n  line-height: 19px;\\n  font-weight: bold;\\n  color: #000;\\n}\\n.yrw-content {\\n  max-width: 50px;\\n}\\n.desc {\\n  position: relative;\\n  min-height: 102px;\\n  font-size: 12px;\\n  line-height: 16px;\\n  color: #7f7f7f;\\n}\\n.shadow {\\n  position: absolute;\\n  bottom: 21px;\\n  left: 0;\\n  z-index: 0;\\n  width: 100%;\\n  height: 34px;\\n  background-image: linear-gradient(180deg, rgba(255, 255, 255, 0) 0%, #fff 45%);\\n}\\n.button {\\n  position: absolute;\\n  z-index: 2;\\n  bottom: 10px;\\n  left: 0;\\n  margin: 12px 10px 0;\\n  padding: 6px 20px 7px 10px;\\n  display: block;\\n  width: max-content;\\n  max-width: calc(100% - 50px);\\n  background-color: #e6f4ff;\\n  border-radius: 5px;\\n  color: #0099ff;\\n  font-size: 13px;\\n  line-height: 15px;\\n  font-family: Arial, sans-serif;\\n  text-decoration: none;\\n  text-overflow: ellipsis;\\n  white-space: nowrap;\\n  overflow: hidden;\\n  outline: none;\\n}\\n.button::after {\\n  content: '';\\n  position: absolute;\\n  top: 0;\\n  right: 10px;\\n  width: 5px;\\n  height: 100%;\\n  background-image: url(\\\"data:image/svg+xml,%3Csvg width='5' height='10' fill='none' xmlns='http://www.w3.org/2000/svg'%3E%3Cpath d='M.465 9.5a.456.456 0 00.333-.14l4.054-4.013A.486.486 0 005 5a.461.461 0 00-.148-.347L.802.645A.46.46 0 00.466.5.462.462 0 000 .976c0 .125.051.249.133.337L3.855 5 .133 8.687A.495.495 0 000 9.024c0 .269.2.476.465.476z' fill='%2309F'/%3E%3C/svg%3E\\\");\\n  background-repeat: no-repeat;\\n  background-position: center center;\\n  color: #0099ff;\\n  font-size: 13px;\\n  line-height: 15px;\\n}\\n.icon-link {\\n  position: absolute;\\n  bottom: 174px;\\n  left: 269px;\\n  z-index: 959;\\n  display: flex;\\n  justify-content: center;\\n  align-items: center;\\n  width: 20px;\\n  height: 20px;\\n  font-size: 13px;\\n  font-family: Verdana, Geneva, Tahoma, sans-serif;\\n  color: rgba(255, 255, 255, 0.8);\\n  text-decoration: none;\\n  background-color: rgba(0, 0, 0, 0.5);\\n  border-bottom-left-radius: 5px;\\n  border-bottom-right-radius: 5px;\\n  opacity: 0.5;\\n}\\n@media (max-width: 1020px) {\\n  .icon-link {\\n    left: 264px;\\n  }\\n}\\n.icon-link::before {\\n  content: '';\\n  position: absolute;\\n  top: 2px;\\n  right: 20px;\\n  visibility: hidden;\\n  display: block;\\n  width: 5px;\\n  height: 16px;\\n}\\n.icon-link__text {\\n  position: absolute;\\n  top: 2px;\\n  right: 25px;\\n  visibility: hidden;\\n  padding: 2px 5px 3px 3px;\\n  display: block;\\n  border-radius: 1px;\\n  background-color: rgba(0, 0, 0, 0.5);\\n  font-size: 10px;\\n  color: #fff;\\n  white-space: nowrap;\\n}\\n.icon-link::after {\\n  content: '';\\n  position: absolute;\\n  top: 5px;\\n  right: 21px;\\n  visibility: hidden;\\n  width: 0;\\n  height: 0;\\n  border-style: solid;\\n  border-width: 4px 0 4px 4px;\\n  border-color: transparent transparent transparent rgba(0, 0, 0, 0.5);\\n  display: block;\\n}\\n.icon-link:hover {\\n  opacity: 1;\\n}\\n.icon-link:hover .icon-link__text {\\n  visibility: visible;\\n}\\n.icon-link:hover::before,\\n.icon-link:hover::after {\\n  visibility: visible;\\n}\\n\",\"gridColumns\":\"1\",\"gridRows\":\"3\",\"defaultWidth\":\"322\",\"props\":{}},{\"value\":\"10\",\"template\":\"<div class=\\\"wrapper\\\">\\n  <ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n    <div class=\\\"card\\\">\\n      <div class=\\\"text-wrap\\\">\\n        <ya-clamp lines=\\\"3\\\" class=\\\"title\\\"><ya-unit-title /></ya-clamp>\\n        <ya-clamp lines=\\\"5\\\" class=\\\"desc\\\"><ya-unit-desc /></ya-clamp>\\n        <span class=\\\"button\\\"><ya-unit-domain /></span>\\n      </div>\\n      <div class=\\\"image\\\">\\n        <ya-unit-image ratio=\\\"1\\\" />\\n      </div>\\n    </div>\\n    <ya-unit-close />\\n  </ya-units-grid>\\n  <a class=\\\"icon-link\\\" href=\\\"https://direct.yandex.ru/?partner\\\" target=\\\"_blank\\\">\\n  <span class=\\\"icon-link__text\\\">Яндекс Директ</span>\\n  &#8381;\\n  </a>\\n</div>\\n\",\"css\":\".wrapper {\\n  width: 100%;\\n  border-radius: 9px;\\n  position: relative;\\n}\\n.headline {\\n  line-height: 24px;\\n  color: #373e44;\\n  padding-bottom: 20px;\\n  padding-top: 15px;\\n}\\n.unit-wrapper {\\n  height: 100%;\\n  background-color: #eee;\\n  border-radius: 9px;\\n}\\n.card {\\n  display: flex;\\n  min-width: 500px;\\n}\\n.image {\\n  position: relative;\\n}\\n.image::after {\\n  content: '';\\n  position: absolute;\\n  top: 0;\\n  left: 0;\\n  width: 100px;\\n  height: 100%;\\n  background-image: linear-gradient(to right, rgba(238, 238, 238, 1) 0, rgba(238, 238, 238, 0.7) 40px, rgba(238, 238, 238, 0))\\n}\\n.text-wrap {\\n  position: relative;\\n  z-index: 1;\\n  margin-right: -30px;\\n  padding: 20px 0 20px 23px;\\n}\\n.title {\\n  color: #000;\\n  font-size: 20px;\\n  font-weight: bold;\\n  hyphens: auto;\\n}\\n.desc {\\n  padding-top: 12px;\\n  font-size: 14px;\\n  color: #000;\\n  opacity: 0.6;\\n  hyphens: auto;\\n}\\n.button {\\n  position: absolute;\\n  bottom: 20px;\\n  left: 23px;\\n  text-transform: uppercase;\\n  font-size: 14px;\\n  font-weight: bold;\\n  color: #000;\\n  opacity: 0.6;\\n}\\n.meta {\\n  color: #757575;\\n  font-size: 12px;\\n  padding-left: 10px;\\n  padding-right: 10px;\\n  padding-top: 7px;\\n  padding-bottom: 10px\\n}\\n.category {\\n  color: gray;\\n  padding-right: 20px;\\n}\\n.recommendation-label {\\n  color: red;\\n  text-align: left;\\n}\\n.unit-image {\\n  width: 360px;\\n  height: 320px;\\n}\\n.grid {\\n  display: flex;\\n  flex-direction: column;\\n  flex-wrap: wrap;\\n  justify-content: flex-start;\\n  align-items: stretch;\\n  align-content: flex-start;\\n  width: 100%;\\n  box-sizing: border-box;\\n  max-width: 640px;\\n}\\n.icon-link {\\n  position: absolute;\\n  top: 0;\\n  right: 22px;\\n  z-index: 959;\\n  display: flex;\\n  justify-content: center;\\n  align-items: center;\\n  width: 20px;\\n  height: 20px;\\n  font-size: 13px;\\n  font-family: Verdana, Geneva, Tahoma, sans-serif;\\n  color: #fff;\\n  text-decoration: none;\\n  background-color: rgba(0, 0, 0, 0.5);\\n  border-bottom-left-radius: 5px;\\n  border-bottom-right-radius: 5px;\\n  opacity: 0.5;\\n}\\n.icon-link::before {\\n  content: '';\\n  position: absolute;\\n  top: 2px;\\n  right: 20px;\\n  visibility: hidden;\\n  display: block;\\n  width: 5px;\\n  height: 16px;\\n}\\n.icon-link__text {\\n  position: absolute;\\n  top: 2px;\\n  right: 25px;\\n  visibility: hidden;\\n  padding: 2px 5px 3px 3px;\\n  display: block;\\n  border-radius: 1px;\\n  background-color: rgba(0, 0, 0, 0.5);\\n  font-size: 10px;\\n  color: #fff;\\n  white-space: nowrap;\\n}\\n.icon-link::after {\\n  content: '';\\n  position: absolute;\\n  top: 5px;\\n  right: 21px;\\n  visibility: hidden;\\n  width: 0;\\n  height: 0;\\n  border-style: solid;\\n  border-width: 4px 0 4px 4px;\\n  border-color: transparent transparent transparent rgba(0, 0, 0, 0.5);\\n  display: block;\\n}\\n.icon-link:hover {\\n  opacity: 1;\\n}\\n.icon-link:hover .icon-link__text {\\n  visibility: visible;\\n}\\n.icon-link:hover::before,\\n.icon-link:hover::after {\\n  visibility: visible;\\n}\\n\",\"gridColumns\":\"1\",\"gridRows\":\"1\",\"defaultWidth\":\"550\",\"props\":{}},{\"value\":\"12\",\"template\":\"<div class=\\\"wrapper\\\">\\n  <ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n    <div class=\\\"card\\\">\\n      <div class=\\\"image\\\">\\n        <ya-unit-image ratio=\\\"0.7\\\" />\\n      </div>\\n    </div>\\n    <div class=\\\"meta\\\">\\n      <ya-clamp lines=\\\"3\\\" class=\\\"title\\\"><ya-unit-title /></ya-clamp>\\n    <span class=\\\"category\\\"><ya-unit-category /></span>\\n    <span class=\\\"separator\\\">&#8226;</span>\\n    <span class=\\\"domain\\\"><ya-unit-domain /></span>\\n    </div>\\n  <span class=\\\"warning\\\"><ya-unit-warning /></span>\\n    <ya-unit-close />\\n  </ya-units-grid>\\n</div>\\n\",\"css\":\".headline {\\n  padding-bottom: 20px;\\n  padding-top: 15px;\\n}\\n.card {\\n  max-width: 250px;\\n}\\n.grid-row {\\n  margin-top: 10px;\\n}\\n.grid-item {\\n  margin-left: 10px;\\n}\\n.unit-wrapper {\\n  height: 100%;\\n  background-color: #fff;\\n}\\n.image {\\n  margin-bottom: 0px;\\n  max-width: 250px;\\n  min-width: 200px;\\n  max-height: 140px;\\n}\\n.title {\\n  color: #262626;\\n  font-weight: 700;\\n  font-stretch: normal;\\n  margin-top: 8px;\\n  font-size: 16px;\\n  line-height: 20px;\\n  font-family: Arial,Helvetica,sans-seriff;\\n}\\n.meta {\\n  max-width: 250px;\\n  max-height: 125px;\\n}\\n.category {\\n  font-family: Roboto,Arial,Helvetica,sans-serif;\\n  font-size: 10px;\\n  line-height: 20px;\\n  letter-spacing: 0.6px;\\n  text-transform: uppercase;\\n  color: #8d96b2;\\n  font-weight: 400;\\n  margin-top: 6px;\\n}\\n.separator {\\n  font-family: Roboto,Arial,Helvetica,sans-serif;\\n  font-size: 10px;\\n  line-height: 20px;\\n  letter-spacing: 1.3px;\\n  text-transform: uppercase;\\n  color: #8d96b2;\\n  font-weight: 400;\\n  margin-top: 6px;\\n}\\n.unit-image {\\n  max-width: 250px;\\n  max-height: 140px;\\n}\\n.grid {\\n  display: flex;\\n  flex-direction: column;\\n  flex-wrap: wrap;\\n  justify-content: flex-start;\\n  align-items: stretch;\\n  align-content: flex-start;\\n  width: 100%;\\n  box-sizing: border-box;\\n}\\n.domain {\\n  font-family: Roboto,Arial,Helvetica,sans-serif;\\n  font-size: 10px;\\n  line-height: 20px;\\n  letter-spacing: 0.6px;\\n  text-transform: uppercase;\\n  color: #8d96b2;\\n  font-weight: 400;\\n  margin-top: 6px;\\n}\\n.warning {\\n  display: none;\\n}\\n.unit-wrapper:hover .title {\\n  color: #315efb;\\n}\\n.unit-wrapper:hover .domain {\\n  color: #315efb;\\n}\\n.unit-wrapper:hover .category {\\n  color: #315efb;\\n}\\n\",\"gridColumns\":\"1\",\"gridRows\":\"1\",\"defaultWidth\":\"250\",\"props\":{}},{\"value\":\"15\",\"template\":\"<div class=\\\"wrapper\\\">\\n  <ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\" class=\\\"item\\\">\\n    <div class=\\\"header\\\">\\n      <div class=\\\"info\\\">\\n        <div class=\\\"avatar\\\"></div>\\n        <div class=\\\"about\\\">\\n          <ya-clamp lines=\\\"1\\\" class=\\\"title\\\">\\n            <ya-unit-title/>\\n          </ya-clamp>\\n          <div class=\\\"domain\\\">\\n            <ya-unit-domain class=\\\"domain-unit\\\" />\\n            <ya-unit-age class=\\\"age\\\" />\\n          </div>\\n        </div>\\n      </div>\\n    </div>\\n    <div class=\\\"body\\\">\\n      <ya-clamp lines=\\\"2\\\" class=\\\"description\\\">\\n        <ya-unit-desc/>\\n      </ya-clamp>\\n      <div class=\\\"image-wrapper\\\">\\n        <ya-unit-image class=\\\"image\\\" ratio=\\\"0.55\\\" />\\n      </div>\\n    </div>\\n    <div class=\\\"button\\\">\\n      <div class=\\\"button-icon\\\"></div>\\n      Перейти\\n    </div>\\n    <ya-unit-close />\\n  </ya-units-grid>\\n</div>\\n\",\"css\":\".unit-image {\\n  background: linear-gradient(0deg, rgba(0, 0, 0, 0.3), rgba(0, 0, 0, 0.3));\\n}\\n.unit-wrapper {\\n  min-width: 250px;\\n}\\n.age {\\n  font-family: YS Text;\\n  font-size: 12px;\\n  line-height: 16px;\\n  color: rgba(32, 35, 51, 0.7);\\n}\\n.age:before {\\n  content: ' · ';\\n}\\n.age:empty {\\n  display: none;\\n}\\n.body {\\n  position: relative;\\n}\\n.image-wrapper {\\n  position: relative;\\n  max-height: 166px;\\n  display: flex;\\n  flex-direction: row;\\n  flex-wrap: nowrap;\\n  justify-content: center;\\n  align-content: center;\\n  align-items: flex-end;\\n  overflow: hidden;\\n  box-shadow: inset 0 -1px 0 rgba(0, 0, 0, 0.1);\\n  border-radius: 8px;\\n  margin-top: 8px;\\n}\\n.image {\\n  width: 100%;\\n  border-radius: 8px;\\n}\\n.domain-unit {\\n  font-family: \\\"YS Text\\\";\\n  font-style: normal;\\n  font-weight: normal;\\n  font-size: 12px;\\n  line-height: 16px;\\n  color: #067aff;\\n}\\n.domain-unit:after {\\n  content: \\\" · Реклама\\\";\\n  color: rgba(32, 35, 51, 0.7);\\n}\\n.domain-unit:empty {\\n  display: none;\\n}\\n.button-icon {\\n  height: 15px;\\n  width: 14px;\\n  min-width: 14px;\\n  margin-right: 8px;\\n  background-image: url(\\\"data:image/svg+xml,%3Csvg width='14' height='15' fill='none' xmlns='http://www.w3.org/2000/svg'%3E%3Cpath d='M13 8.503a1 1 0 011 1v3a1.5 1.5 0 01-1.5 1.5h-11a1.5 1.5 0 01-1.5-1.5v-11a1.5 1.5 0 011.5-1.5h3a1 1 0 110 2H2v10h10v-2.5a1 1 0 011-1zm-1.7-6.716v-.323l-1.15.314a6.258 6.258 0 01-1.65.221c-.6 0-1-.447-1-1a1 1 0 011-1H13a1 1 0 011 1v4.504a1 1 0 01-1 1c-.552 0-1-.403-1-1a6.3 6.3 0 01.222-1.656l.313-1.147h-.32l-1.078 1.437a9.996 9.996 0 01-.93 1.072l-3.5 3.498a1 1 0 11-1.414-1.414l3.5-3.5c.334-.332.69-.64 1.065-.923L11.3 1.787z' fill='%23067AFF'/%3E%3C/svg%3E%0A\\\");\\n}\\n.button {\\n  background: rgba(6, 122, 255, 0.1);\\n  border-radius: 100px;\\n  font-family: \\\"YS Text\\\";\\n  font-style: normal;\\n  font-weight: 500;\\n  font-size: 14px;\\n  line-height: 20px;\\n  display: flex;\\n  flex-direction: row;\\n  flex-wrap: nowrap;\\n  justify-content: center;\\n  align-content: center;\\n  align-items: center;\\n  color: #067aff;\\n  padding: 8px 15px;\\n  margin-left: auto;\\n  margin-top: 12px;\\n}\\n.title {\\n  font-family: \\\"YS Text\\\";\\n  font-style: normal;\\n  font-weight: 500;\\n  font-size: 14px;\\n  line-height: 20px;\\n  color: #000;\\n}\\n.description {\\n  font-family: \\\"YS Text\\\";\\n  font-style: normal;\\n  font-weight: normal;\\n  font-size: 16px;\\n  line-height: 24px;\\n  color: #000;\\n}\\n.avatar {\\n  background: rgba(32, 35, 51, 0.07);\\n  border: 1px solid rgba(32, 35, 51, 0.07);\\n  box-sizing: border-box;\\n  border-radius: 100%;\\n  width: 44px;\\n  height: 44px;\\n  min-width: 44px;\\n  min-height: 44px;\\n  background-repeat: no-repeat;\\n  background-position: center center;\\n  background-image: url(\\\"data:image/svg+xml,%3Csvg width='13' height='18' fill='none' xmlns='http://www.w3.org/2000/svg'%3E%3Cpath d='M2.712 8.52V.792h4.056c1.792 0 3.184.392 4.176 1.176 1.008.784 1.512 1.968 1.512 3.552 0 .816-.144 1.52-.432 2.112a3.683 3.683 0 01-1.2 1.464c-.512.368-1.128.648-1.848.84-.72.176-1.52.264-2.4.264H4.968v2.04h5.016v1.68H4.968V18H2.712v-4.08H.744v-1.68h1.968V10.2H.744V8.52h1.968zm2.256-5.784V8.52h1.608c1.168 0 2.056-.24 2.664-.72.624-.496.936-1.256.936-2.28 0-.944-.272-1.64-.816-2.088-.528-.464-1.392-.696-2.592-.696h-1.8z' fill='%23202333' fill-opacity='.3'/%3E%3C/svg%3E%0A\\\");\\n}\\n.header {\\n  display: flex;\\n  flex-direction: row;\\n  flex-wrap: nowrap;\\n  justify-content: flex-start;\\n  align-content: center;\\n  align-items: center;\\n  margin-bottom: 10px;\\n}\\n.info {\\n  display: flex;\\n  flex-direction: row;\\n  flex-wrap: nowrap;\\n  justify-content: flex-start;\\n  align-content: stretch;\\n  align-items: stretch;\\n}\\n.about {\\n  display: flex;\\n  flex-direction: column;\\n  flex-wrap: nowrap;\\n  justify-content: center;\\n  align-items: flex-start;\\n  align-content: stretch;\\n  margin-left: 12px;\\n}\\n.close {\\n  display: none;\\n}\\n\",\"gridColumns\":\"1\",\"gridRows\":\"1\",\"defaultWidth\":\"300\",\"props\":{}},{\"value\":\"17\",\"template\":\"<div class=\\\"wrapper\\\">\\n  <ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n    <div class=\\\"box\\\">\\n      <div class=\\\"body\\\">\\n        <ya-clamp lines=\\\"2\\\" class=\\\"title\\\"><ya-unit-title /></ya-clamp>\\n        <div class=\\\"meta\\\">\\n          <span class=\\\"meta-group\\\">\\n            <ya-unit-category class=\\\"category\\\" />\\n            <ya-unit-domain class=\\\"domain\\\" />\\n          </span>\\n          <span class=\\\"desc\\\"><ya-unit-desc /></span>\\n          <span class=\\\"warning\\\"><ya-unit-warning /></span>\\n        </div>\\n      </div>\\n      <div class=\\\"image\\\">\\n        <ya-unit-image class=\\\"square\\\" ratio=\\\"1\\\" src=\\\"https://avatars.mds.yandex.net/get-ynews/1882860/a1300d270d02b90e0cda9a22993c9704/orig\\\" />\\n        <ya-unit-image class=\\\"rect\\\" ratio=\\\"0.5\\\" src=\\\"https://avatars.mds.yandex.net/get-ynews/1882860/a1300d270d02b90e0cda9a22993c9704/orig\\\" />\\n        <ya-unit-age class=\\\"age\\\" />\\n      </div>\\n    </div>\\n    <ya-unit-close />\\n  </ya-units-grid>\\n</div>\\n\",\"css\":\".wrapper {\\n  font-family: YS Text,Helvetica Neue,Arial,sans-serif;\\n  -webkit-font-feature-settings: \\\"liga\\\",\\\"kern\\\";\\n  -moz-font-feature-settings: \\\"liga\\\",\\\"kern\\\";\\n  font-feature-settings: \\\"liga\\\",\\\"kern\\\";\\n}\\n.unit-wrapper {\\n  overflow: visible;\\n  background: #fff;\\n}\\n.box {\\n  display: flex;\\n}\\n.image {\\n  position: relative;\\n  flex-shrink: 0;\\n}\\n.square {\\n  width: 64px;\\n}\\n.rect {\\n  display: none;\\n  width: 128px;\\n  margin-right: 5px;\\n}\\n.square,\\n.rect {\\n  position: relative;\\n  overflow: hidden;\\n  border-radius: 4px;\\n}\\n.square::after,\\n.rect::after {\\n  content: \\\"\\\";\\n  position: absolute;\\n  top: 0;\\n  right: 0;\\n  bottom: 0;\\n  left: 0;\\n  background: rgba(18,27,73,.05);\\n}\\n.age {\\n  position: absolute;\\n  z-index: 10;\\n  right: 3px;\\n  bottom: 3px;\\n  font-size: 8px;\\n  line-height: 12px;\\n  font-weight: 500;\\n  padding: 2px 1px 0;\\n  border-radius: 3px;\\n  min-width: 14px;\\n  color: #939cb0;\\n  background: #eceef2;\\n  opacity: 0.6;\\n}\\n.age:empty {\\n  display: none;\\n}\\n.body {\\n  padding-right: 12px;\\n  flex-grow: 1;\\n  position: relative;\\n  top: -2px;\\n}\\n.title {\\n  font-size: 16px;\\n  line-height: 18px;\\n  font-weight: 700;\\n  color: #000;\\n}\\n.unit-with-warning .desc {\\n  display: none;\\n}\\n.meta {\\n  font-size: 12px;\\n  line-height: 14px;\\n  margin-top: 4px;\\n  color: #939cb0;\\n  overflow: hidden;\\n  text-overflow: ellipsis;\\n  display: -webkit-box;\\n  -webkit-box-orient: vertical;\\n  -webkit-line-clamp: 2;\\n}\\n.meta-group {\\n  display: inline-flex;\\n}\\n.category {\\n  display: inline-flex;\\n}\\n.category:not(:empty)::after {\\n  content: ',\\\\00a0';\\n}\\n.domain {\\n  display: inline-block;\\n  overflow: hidden;\\n  white-space: nowrap;\\n  text-overflow: ellipsis;\\n  max-width: 170px;\\n}\\n.domain:not(:empty)::after {\\n  content: '•';\\n} \\n@media (orientation: landscape) {\\n  .title {\\n    font-size: 18px;\\n    line-height: 20px;\\n  }\\n\\n  .meta {\\n    font-size: 14px;\\n  }\\n}\\n@media (min-width: 495px) {\\n  .rect {\\n    display: block;\\n  }\\n\\n  .square {\\n    display: none;\\n  }\\n\\n  .unit-wrapper {\\n    padding: 12px 16px;\\n  }\\n}\\n@media (min-width: 490px) {\\n  .unit-wrapper {\\n    border-radius: 12px;\\n  }\\n}\\n@media (max-width: 320px) {\\n  .domain {\\n    max-width: 128px;\\n  }\\n}\\n\",\"gridColumns\":\"1\",\"gridRows\":\"1\",\"props\":{}},{\"value\":\"18\",\"template\":\"<div class=\\\"wrapper\\\">\\n  <ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n    <div class=\\\"box\\\">\\n      <div class=\\\"body\\\">\\n        <ya-clamp lines=\\\"2\\\" class=\\\"title\\\"><ya-unit-title /></ya-clamp>\\n        <div class=\\\"meta\\\">\\n          <ya-unit-category class=\\\"category\\\" /><span class=\\\"warning\\\"><ya-unit-warning /></span>\\n        </div>\\n      </div>\\n      <div class=\\\"image\\\">\\n        <ya-unit-image class=\\\"square\\\" ratio=\\\"1\\\" src=\\\"http://avatars.mds.yandex.net/get-ynews/1882860/a1300d270d02b90e0cda9a22993c9704/orig\\\" />\\n        <ya-unit-image class=\\\"rect\\\" ratio=\\\"0.5\\\" src=\\\"http://avatars.mds.yandex.net/get-ynews/1882860/a1300d270d02b90e0cda9a22993c9704/orig\\\" />\\n        <ya-unit-age class=\\\"age\\\" />\\n      </div>\\n    </div>\\n    <ya-unit-close />\\n  </ya-units-grid>\\n</div>\\n\",\"css\":\".wrapper {\\n  font-family: YS Text,Helvetica Neue,Arial,sans-serif;\\n  -webkit-font-feature-settings: \\\"liga\\\",\\\"kern\\\";\\n  -moz-font-feature-settings: \\\"liga\\\",\\\"kern\\\";\\n  font-feature-settings: \\\"liga\\\",\\\"kern\\\";\\n}\\n.unit-wrapper {\\n  overflow: visible;\\n  background: #fff;\\n}\\n.box {\\n  display: flex;\\n  flex-direction: row-reverse;\\n}\\n.image {\\n  position: relative;\\n  flex-shrink: 0;\\n}\\n.square {\\n  width: 64px;\\n}\\n.rect {\\n  display: none;\\n  width: 128px;\\n}\\n.square,\\n.rect {\\n  position: relative;\\n  overflow: hidden;\\n  border-radius: 4px;\\n}\\n.square::after,\\n.rect::after {\\n  content: \\\"\\\";\\n  position: absolute;\\n  top: 0;\\n  right: 0;\\n  bottom: 0;\\n  left: 0;\\n  background: rgba(18,27,73,.05);\\n} \\n.age {\\n  position: absolute;\\n  z-index: 10;\\n  left: 3px;\\n  top: 3px;\\n  font-size: 8px;\\n  line-height: 12px;\\n  font-weight: 500;\\n  padding: 2px 1px 0;\\n  border-radius: 3px;\\n  mid-width: 14px;\\n  color: #939cb0;\\n  background: #eceef2;\\n  opacity: 0.6;\\n} \\n.age:empty {\\n  display: none;\\n}\\n.body {\\n  padding-left: 12px;\\n  flex-grow: 1;\\n  position: relative;\\n  top: -2px;\\n  margin: auto 0;\\n}\\n.title {\\n  font-size: 16px;\\n  line-height: 18px;\\n  font-weight: 700;\\n  color: #000;\\n} \\n.meta {\\n  font-size: 12px;\\n  line-height: 14px;\\n  margin-top: 4px;\\n  color: #000;\\n  overflow: hidden;\\n  text-overflow: ellipsis;\\n  display: -webkit-box;\\n  -webkit-box-orient: vertical;\\n  -webkit-line-clamp: 2;\\n}\\n.category {\\n  display: inline-flex;\\n}\\n@media (orientation: landscape) {\\n  .title {\\n    font-size: 18px;\\n    line-height: 20px;\\n  }\\n\\n  .meta {\\n    font-size: 14px;\\n  }\\n}\\n@media (min-width: 495px) {\\n  .unit-wrapper {\\n    padding: 12px 16px;\\n  }\\n}\\n@media (min-width: 321px) {\\n  .rect {\\n    display: block;\\n  }\\n\\n  .square {\\n    display: none;\\n  }\\n}\\n@media (min-width: 490px) {\\n  .unit-wrapper {\\n    border-radius: 12px;\\n  }\\n}\\n.warning .ya-grid-template:not(:empty)::before {\\n  content: '.'; \\n}\\n\",\"gridColumns\":\"1\",\"gridRows\":\"1\",\"props\":{}},{\"value\":\"19\",\"template\":\"<div class=\\\"wrapper\\\">\\n    <ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n  <div class=\\\"image\\\">\\n    <div class=\\\"disclaimer\\\">₽</div>\\n      <ya-unit-image ratio=\\\"0.5\\\" />\\n  </div>\\n  <ya-clamp lines=\\\"2\\\" class=\\\"title\\\">\\n    <ya-unit-title />\\n  </ya-clamp>\\n  <div class=\\\"meta\\\">\\n    <span class=\\\"domain\\\">\\n      <ya-unit-domain />\\n    </span>\\n  </div>\\n  <ya-unit-close />\\n</ya-units-grid>\\n</div>\",\"css\":\".unit-wrapper {\\n  font-family: YS Text, Helvetica, Arial, sans-serif;\\n  min-width: 250px;\\n  padding: 16px 0;\\n  border-bottom: solid 1px #e5e5e5;\\n}\\n.grid-row:first-child .unit-wrapper {\\n  padding-top: 0;\\n}\\n.image {\\n  position: relative;\\n}\\n.disclaimer {\\n  position: absolute;\\n  top: 0;\\n  right: 25px;\\n  z-index: 10;\\n  font-size: 11px;\\n  line-height: 20px;\\n  color: #fff;\\n  background: rgba(0, 0, 0, 0.5);\\n  opacity: 0.5;\\n  width: 20px;\\n  height: 20px;\\n  text-align: center;\\n  border-bottom-left-radius: 4px;\\n  border-bottom-right-radius: 4px;\\n}\\n.title {\\n  font-size: 16px;\\n  line-height: 20px;\\n  font-weight: 500;\\n  padding: 12px 0 0;\\n  color: #222;\\n  transition: color 0.1s ease-out;\\n}\\n.unit-wrapper:hover .title {\\n  color: #d00;\\n}\\n.meta {\\n  font-size: 13px;\\n  line-height: 16px;\\n  padding: 4px 0 0;\\n  color: #999;\\n}\\n\",\"gridColumns\":\"1\",\"gridRows\":\"1\",\"defaultWidth\":\"300\",\"props\":{}},{\"value\":\"20\",\"template\":\"<div class=\\\"wrapper\\\">\\n    <ya-units-grid class=\\\"wrapper\\\" cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n  <div class=\\\"category\\\">\\n    <ya-unit-category />\\n  </div>\\n  <div class=\\\"image\\\">\\n    <ya-unit-image class=\\\"portrait\\\" ratio=\\\"0.5\\\" />\\n    <ya-unit-image class=\\\"square\\\" ratio=\\\"1\\\" />\\n    <ya-unit-age class=\\\"unit-age\\\" />\\n    <div class=\\\"warning\\\">\\n      <i class=\\\"warning__center\\\"></i>\\n      <i class=\\\"warning__right\\\"></i>\\n      <span class=\\\"warning__wrap\\\">\\n        <ya-unit-warning class=\\\"unit-warning\\\" />\\n      </span>\\n    </div>\\n  </div>\\n  <div class=\\\"box\\\" />\\n    <ya-clamp lines=\\\"2\\\" class=\\\"title\\\">\\n      <ya-unit-title />\\n    </ya-clamp>\\n    <ya-clamp lines=\\\"3\\\" class=\\\"desc\\\">\\n        <ya-unit-desc />\\n    </ya-clamp>\\n    <div class=\\\"domain\\\">\\n      <ya-unit-domain class=\\\"unit-domain\\\" />\\n    </div>\\n    <ya-clamp lines=\\\"2\\\" class=\\\"warning\\\">\\n      <ya-unit-warning class=\\\"unit-warning\\\" />\\n    </ya-clamp>\\n  </div>\\n  <ya-unit-close />\\n</ya-units-grid>\\n</div>\",\"css\":\".grid {\\n  font-family: YS Text,Helvetica Neue,Arial,sans-serif;\\n  -webkit-font-feature-settings: \\\"liga\\\",\\\"kern\\\";\\n  -moz-font-feature-settings: \\\"liga\\\",\\\"kern\\\";\\n  font-feature-settings: \\\"liga\\\",\\\"kern\\\";\\n  overflow: hidden;\\n  background: #fff;\\n  border-radius: 12px;\\n}\\n.unit-age:empty,\\n.unit-domain:empty,\\n.unit-wrapper:not(.unit-with-warning) .warning,\\n.grid-row:first-child .square,\\n.grid-row:first-child .box .warning,\\n.grid-row:not(:first-child) .category,\\n.grid-row:not(:first-child) .portrait,\\n.grid-row:not(:first-child) .image .warning,\\n.grid-row:not(:first-child) .desc {\\n  display: none;\\n}\\n.unit-wrapper {\\n  position: relative;\\n  min-width: 250px;\\n}\\n.category {\\n  font-size: 10px;\\n  line-height: 12px;\\n  position: absolute;\\n  top: 0;\\n  left: 12px;\\n  display: block;\\n  padding: 2px 4px;\\n  z-index: 10;\\n  border-radius: 0 0 4px 4px;\\n}\\n.unit-age {\\n  position: absolute;\\n  z-index: 20;\\n  text-align: center;\\n  border-radius: 4px;\\n}\\n.category,\\n.unit-age {\\n  color: #222426;\\n  background: #eceef2;\\n  opacity: 0.6;\\n}\\n.square .unit-image {\\n  width: 88px;\\n  border-radius: 6px;\\n}\\n.grid-row:not(:first-child) .unit-container {\\n  display: flex;\\n  flex-direction: row-reverse;\\n}\\n.box {\\n  flex-grow: 1;\\n  padding-right: 12px;\\n}\\n.image {\\n  position: relative;\\n  flex-shrink: 0;\\n  flex-grow: 0;\\n  margin-bottom: auto;\\n}\\n.image::before {\\n  content: '';\\n  display: block;\\n  position: absolute;\\n  top: 0;\\n  right: 0;\\n  bottom: 0;\\n  left: 0;\\n  z-index: 5;\\n  background: rgba(34, 36, 38, 0.05);\\n  border-radius: 6px;\\n}\\n.grid-row:first-child .unit-age {\\n  font-size: 10px;\\n  line-height: 13px;\\n  right: 12px;\\n  bottom: 8px;\\n  padding: 2px 2px 1px;\\n  min-width: 16px;\\n}\\n.grid-row:first-child .unit-with-warning .unit-age {\\n  bottom: 32px;\\n}\\n.grid-row:first-child .unit-with-warning .warning {\\n  font-size: 11px;\\n  line-height: 14px;\\n  position: absolute;\\n  right: 0;\\n  bottom: 0;\\n  left: 0;\\n  overflow: hidden;\\n  padding: 5px 7px;\\n  white-space: nowrap;\\n  color: #fff;\\n  text-shadow: 0 1px 1px rgba(0, 0, 0, 0.3);\\n  background: rgba(0, 0, 0, 0.3);\\n}\\n.grid-row:first-child .unit-warning {\\n  display: inline-block;\\n  min-width: 100%;\\n  animation: 7s 0.3s 1 warning-content;\\n}\\n.warning__wrap {\\n  display: block;\\n  max-width: 100%;\\n  animation: 7s 0.3s 1 warning-wrap;\\n}\\n.warning__wrap,\\n.grid-row:first-child .unit-warning {\\n  transition: transform 1s;\\n}\\n.warning__right,\\n.warning__center {\\n  position: absolute;\\n  top: 0;\\n  bottom: 0;\\n  width: 30%;\\n  z-index: 10;\\n  animation: 8.3s hide-controls;\\n}\\n.warning__right {\\n  right: 0;\\n}\\n.warning__center {\\n  width: auto;\\n  left: 30%;\\n  right: 30%;\\n}\\n@keyframes warning-content {\\n  0% {\\n    transform: translateX(0);\\n  }\\n  35% {\\n    transform: translateX(-100%);\\n  }\\n  65% {\\n    transform: translateX(-100%);\\n  }\\n  100% {\\n    transform: translateX(0);\\n  }\\n}\\n@keyframes warning-wrap {\\n  0% {\\n    transform: translateX(0);\\n  }\\n  35% {\\n    transform: translateX(100%);\\n  }\\n  65% {\\n    transform: translateX(100%);\\n  }\\n  100% {\\n    transform: translateX(0);\\n  }\\n}\\n@keyframes hide-controls {\\n  0% {\\n    transform: translateY(0);\\n  }\\n  5% {\\n    transform: translateY(100%);\\n  }\\n  95% {\\n    transform: translateY(100%);\\n  }\\n  100% {\\n    transform: translateY(0);\\n  }\\n}\\n.warning__right:hover ~ .warning__wrap {\\n  transform: translateX(100%);\\n}\\n.warning__right:hover ~ .warning__wrap .unit-warning {\\n  transform: translateX(-100%);\\n}\\n.warning__center:hover ~ .warning__wrap {\\n  transform: translateX(50%);\\n}\\n.warning__center:hover ~ .warning__wrap .unit-warning {\\n  transform: translateX(-50%);\\n}\\n.grid-row:not(:first-child) .unit-age {\\n  font-size: 8px;\\n  line-height: 12px;\\n  font-weight: 500;\\n  right: 3px;\\n  bottom: 3px;\\n  padding: 2px 1px 0;\\n  min-width: 14px;\\n}\\n.title {\\n  font-size: 18px;\\n  line-height: 22px;\\n  font-weight: 700;\\n  color: #222426;\\n}\\n.unit-wrapper:hover .title {\\n  color: #d00;\\n}\\n.grid-row:first-child .title {\\n  font-size: 20px;\\n  line-height: 24px;\\n  margin-top: 12px;\\n}\\n.desc {\\n  font-size: 16px;\\n  line-height: 20px;\\n  margin-top: 2px;\\n  color: #222426;\\n}\\n.domain {\\n  margin-top: 2px;\\n}\\n.domain,\\n.box .warning {\\n  font-size: 12px;\\n  line-height: 14px;\\n  color: #939cb0;\\n}\\n.grid-row:first-child .domain {\\n  margin-top: 4px;\\n}\\n.grid-row:first-child .box {\\n  padding: 0 12px 12px;\\n}\\n.grid-row:not(:first-child) .unit-wrapper {\\n  padding: 0 12px 12px;\\n}\\n.grid-row:not(:first-child) .unit-container {\\n  padding-top: 12px;\\n  border-top: 1px solid #e9ebef;\\n}\\n@media (max-width: 1599px) {\\n  .square .unit-image {\\n    width: 80px;\\n  }\\n  .title {\\n    font-size: 16px;\\n    line-height: 18px;\\n  }\\n  .grid-row:first-child .title {\\n    font-size: 18px;\\n    line-height: 22px;\\n  }\\n  .grid-row:not(:first-child) .title {\\n    margin-top: -2px;\\n  }\\n}\\n\",\"gridColumns\":\"1\",\"gridRows\":\"3\",\"props\":{}},{\"value\":\"21\",\"template\":\"<div class=\\\"wrapper\\\">\\n  <ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n    <div class=\\\"lol\\\">\\n      <div class=\\\"image\\\">\\n        <ya-unit-image ratio=\\\"1\\\" />\\n      </div>\\n      <div class=\\\"meta\\\">\\n        <ya-unit-category ad-only />\\n      </div>\\n      <ya-clamp lines=\\\"2\\\" class=\\\"title\\\">\\n        <ya-unit-title />\\n      </ya-clamp>\\n    </div>\\n    <ya-unit-close />\\n  </ya-units-grid>\\n</div>\\n\",\"css\":\".headline {\\n  font-family: Arial, Helvetica, sans-serif;\\n  font-weight: 400;\\n  font-size: 18px;\\n  line-height: 1.2;\\n  margin: 0 0 20px;\\n  color: #7f7f7f;\\n  text-transform: uppercase;\\n  padding-top: 12px;\\n  text-align: left;\\n  border-top: 1px solid #c6c6c6;\\n}\\n.grid {\\n  padding-bottom: 10px;\\n  border-bottom: 1px solid #F0F0F0;\\n}\\n.grid-row {\\n  margin-top: 10px;\\n}\\n.grid-item {\\n  width: 23.5%;\\n  margin: 0 7px;\\n}\\n.unit-wrapper {\\n  height: 100%;\\n  background-color: #fff;\\n}\\n.image {\\n  margin-bottom: 0px;\\n}\\n.unit-image {\\n  border-radius: 50%;\\n  transition: all 0.3s;\\n}\\n.title {\\n  font-family: Verdana, sans;\\n  font-weight: 400;\\n  font-size: 11px;\\n  line-height: 16px;\\n  padding: 0;\\n  color: #000;\\n  opacity: 0.9;\\n  text-align: center;\\n  min-height: 32px;\\n  width: 100%;\\n  float: left;\\n}\\n.unit-wrapper:hover .unit-image {\\n  border-radius: 8px;\\n}\\n.unit-wrapper:hover .title {\\n  text-decoration: underline;\\n}\\n.lol {\\n  overflow: hidden;\\n}\\n.meta {\\n  font-family: Verdana, sans;\\n  font-size: 10px;\\n  float: right;\\n  margin-top: -22px;\\n  margin-right: 5px;\\n  padding: 2px 3px 3px 5px;\\n  border-radius: 2px;\\n  color: #fff;\\n  position: relative;\\n  background: rgba(0, 0, 0, 0.3);\\n}\\n.unit-warning {\\n  position: relative;\\n  height: 24px;\\n}\\nya-units-grid[cols=\\\"1\\\"] .meta, ya-units-grid[cols=\\\"2\\\"] .meta, ya-units-grid[cols=\\\"3\\\"] .meta {\\n  position: absolute;\\n  top: 5px;\\n  right: 5px;\\n  margin-top: 0px;\\n  margin-right: 0px;\\n}\",\"gridColumns\":\"3\",\"gridRows\":\"1\",\"props\":{}},{\"value\":\"22\",\"template\":\"<div class=\\\"wrapper\\\">\\n    <ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n  <ya-clamp lines=\\\"2\\\" class=\\\"title\\\">\\n    <ya-unit-title />\\n  </ya-clamp>\\n  <div class=\\\"desc\\\">\\n    <ya-unit-desc />\\n  </div>\\n  <div class=\\\"category-wrapper\\\">\\n    <span class=\\\"category\\\">\\n      <ya-unit-category />\\n    </span>\\n  </div>\\n  <ya-unit-close />\\n</ya-units-grid>\\n</div>\",\"css\":\".grid-item {\\n  margin: 0;\\n}\\n.unit-warning {\\n  margin-top: 20px !important;\\n}\\n.unit-wrapper {\\n  min-width: 400px;\\n  display: block;\\n  background-color: #fff;\\n  border: 1px solid #f2f2f2;\\n  border-radius: 3px;\\n  -webkit-box-shadow: 0 3px 8px rgba(0, 0, 0, .05);\\n  box-shadow: 0 3px 8px rgba(0, 0, 0, .05);\\n  padding: 12px;\\n  position: relative;\\n  margin-bottom: 10px;\\n  -webkit-transition: all .3s;\\n  transition: all .3s;\\n}\\n.title {\\n  font-family: 'Open Sans', 'Segoe UI', Arial, Tahoma, Geneva, Verdana, sans-serif;\\n  font-weight: bold;\\n  display: block;\\n  width: 100%;\\n  color: #199edb;\\n  font-weight: 700;\\n  font-size: 16px;\\n  line-height: 22px;\\n  word-break: break-word;\\n}\\n.desc {\\n  font-family: 'Open Sans', 'Segoe UI', Arial, Tahoma, Geneva, Verdana, sans-serif;\\n  color: #444;\\n  font-size: 13px;\\n  line-height: 16px;\\n  word-break: break-word;\\n  max-height: 53px;\\n  overflow: hidden;\\n  margin: 6px 0;\\n}\\n.category {\\n  font-family: 'Open Sans', 'Segoe UI', Arial, Tahoma, Geneva, Verdana, sans-serif;\\n  font-weight: 400;\\n  font-size: 11px;\\n  color: #4e4e4e;\\n  opacity: 0.6;\\n  vertical-align: top;\\n  line-height: 16px;\\n  margin-right: 20px;\\n}\\n.category-wrapper {\\n  margin-top: 10px;\\n  display: -webkit-box;\\n  display: -ms-flexbox;\\n  display: flex;\\n  justify-content: end;\\n}\\n@media screen and (min-width:992px) {\\n  .unit-wrapper {\\n    padding: 25px 22px;\\n  }\\n  .unit-wrapper:hover {\\n    -webkit-box-shadow: 0 6px 26px rgba(0, 0, 0, .09);\\n    box-shadow: 0 6px 26px rgba(0, 0, 0, .09);\\n  }\\n  .title {\\n    font-size: 23px;\\n    line-height: 28px;\\n  }\\n  .category {\\n    position: absolute;\\n    top: 0px;\\n    right: 5px;\\n  }\\n  .category-wrapper {\\n    margin-top: 0;\\n  }\\n}\\n\",\"gridColumns\":\"1\",\"gridRows\":\"1\",\"props\":{}},{\"value\":\"23\",\"template\":\"<div class=\\\"wrapper\\\">\\n  <ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n    <div class=\\\"lol\\\">\\n      <div class=\\\"image\\\">\\n        <ya-unit-image ratio=\\\"1\\\" />\\n      </div>\\n      <div class=\\\"text\\\">\\n        <div class=\\\"title\\\">\\n          <ya-unit-title />\\n        </div>\\n        <div class=\\\"meta\\\">\\n          <span class=\\\"category\\\"><ya-unit-category /></span>\\n        </div>\\n        <div>\\n          <span class=\\\"button\\\"><ya-unit-domain /></span>\\n        </div>\\n      </div>\\n    </div>\\n    <ya-unit-close />\\n  </ya-units-grid>\\n</div>\\n\",\"css\":\"@charset \\\"UTF-8\\\";\\n.grid, .grid-row, .wrapper {\\n  height: 100%;\\n}\\n.headline {\\n  font-size: 15px;\\n  font-weight: 700;\\n  line-height: 18px;\\n  color: #373e44;\\n  padding-bottom: 20px;\\n  padding-top: 15px;\\n}\\n.button, .category, .meta, .title, .title:hover, .unit-wrapper:hover .title {\\n  color:#444;\\n}\\n.grid-row {\\n  margin-top: 10px;\\n}\\n.grid-item {\\n  margin-left: 20px;\\n  min-height: 400px;\\n}\\n.unit-wrapper {\\n  min-width: 250px;\\n  max-width: 350px;\\n  height: 100%;\\n  background-color: #fff;\\n  border-radius: 0;\\n  border: none;\\n}\\n.text {\\n  padding: 12px 15px 0px;\\n}\\n.title {\\n  line-height: 24px;\\n  font-size: 18px;\\n  font-weight: 700;\\n  text-decoration: none;\\n}\\n.title:hover {\\n  text-decoration: underline;\\n}\\n.meta {\\n  font-size: 14px;\\n  line-height: 22px;\\n  margin-bottom: 15px;\\n}\\n.category {\\n  padding-right: 0;\\n  padding-left: 0;\\n  opacity: 0.6;\\n  font: 300 14px/1.3;\\n}\\n.button, .button * {\\n  white-space: nowrap;\\n  overflow: hidden;\\n  font-size: 13px;\\n  line-height: 31px;\\n  font-weight: 700;\\n  text-transform: uppercase;\\n  text-align: center;\\n  text-overflow: ellipsis;\\n  display: block;\\n}\\n.unit-image {\\n  min-height: 219px;\\n  height: 219px;\\n  border-bottom: solid 1px #f1f1f1;\\n}\\n.button {\\n  background: #efbf00;\\n  border-radius: 5px;\\n  line-height: 30px;\\n  outline: 0;\\n  padding: 5px 0;\\n  z-index: 10;\\n  transition: all .5s;\\n}\\n.button:hover {\\n  background:#e9bb05;\\n  color:#444;\\n}\\n\",\"gridColumns\":\"1\",\"gridRows\":\"1\",\"defaultWidth\":\"300\",\"props\":{}}]"),
    (0, NOW(), NOW(), 'NativeContextEnTemplates', "[{\"value\":\"5\",\"name\":\"grid\",\"label\":\"Mobile single 100% x 100px\",\"props\":{},\"template\":\"<ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n\\n  <div class=\\\"unit-misc\\\">\\n    <ya-unit-kebab class=\\\"ya-unit-kebab_dark\\\" />\\n  </div>\\n\\n  <div class=\\\"unit-content\\\">\\n\\n    <!-- Начало Шаблона ТГО -->\\n    <ya-unit-if condition=\\\"!unit.isRmp\\\">\\n      <div class=\\\"unit-meta\\\">\\n        <ya-unit-category class=\\\"unit-category\\\" />\\n        <ya-unit-age class=\\\"unit-age\\\" />\\n      </div>\\n\\n      <div class=\\\"unit-image-block\\\">\\n        <ya-unit-image disable-disclaimer />\\n      </div>\\n\\n      <div class=\\\"unit-text-content\\\" data-cols=\\\"1\\\" data-rows=\\\"1\\\">\\n\\n        <div class=\\\"unit-title\\\">\\n          <ya-unit-if condition=\\\"unit.title < 22\\\">\\n            <span class=\\\"title-short\\\">\\n              <ya-clamp lines=\\\"3\\\"><ya-unit-title /></ya-clamp>\\n            </span>\\n          </ya-unit-if>\\n\\n          <ya-unit-if condition=\\\"unit.title > 21 & unit.title < 37\\\">\\n            <span class=\\\"title-mid\\\">\\n              <ya-clamp lines=\\\"3\\\"><ya-unit-title /></ya-clamp>\\n            </span>\\n          </ya-unit-if>\\n\\n          <ya-unit-if condition=\\\"unit.title > 36\\\">\\n            <span class=\\\"title-long\\\">\\n              <ya-clamp lines=\\\"3\\\"><ya-unit-title /></ya-clamp>\\n            </span>\\n          </ya-unit-if>\\n        </div>\\n\\n        <div class=\\\"unit-prices\\\"><ya-unit-price /><ya-unit-old-price /></div>\\n  \\n        <div class=\\\"unit-desc\\\">\\n          <ya-clamp lines=\\\"2\\\">\\n            <ya-unit-desc class=\\\"desc\\\" />\\n          </ya-clamp>\\n        </div>\\n\\n        <div class=\\\"unit-cta\\\">\\n          <div class=\\\"unit-domain\\\">\\n            <span class=\\\"unit-domain-no-wrap\\\">\\n              <span class=\\\"unit-favicon\\\"><ya-unit-favicon size=\\\"32\\\"/></span>\\n              <ya-unit-domain class=\\\"domain\\\"/>\\n            </span>\\n          </div>\\n        </div>\\n\\n      </div>\\n\\n    </ya-unit-if>\\n    <!-- Конец Шаблона ТГО -->\\n\\n\\n    \\n    <!-- Начало Шаблона РМП -->\\n    <ya-unit-if condition=\\\"unit.isRmp\\\">\\n\\n      <div class=\\\"unit-image-block\\\">\\n        <ya-unit-app-icon />\\n      </div>\\n\\n      <div class=\\\"unit-text-content unit-rmp-content\\\" data-cols=\\\"1\\\" data-rows=\\\"1\\\">\\n\\n        <div class=\\\"unit-title\\\">\\n          <span class=\\\"title-rmp\\\">\\n            <ya-clamp lines=\\\"2\\\"><ya-unit-title /></ya-clamp>\\n          </span>\\n        </div>\\n\\n        <div class=\\\"unit-app-name\\\">\\n          <ya-clamp lines=\\\"1\\\">\\n            <ya-unit-app-name />\\n          </ya-clamp>\\n        </div>\\n\\n        <div class=\\\"unit-app-rating\\\">\\n          <ya-unit-rating />\\n          <ya-unit-review-count />\\n          <div class=\\\"unit-meta\\\">\\n            <ya-unit-category class=\\\"unit-category\\\" />\\n            <ya-unit-age class=\\\"unit-age\\\" />\\n          </div>\\n        </div>\\n\\n        <div class=\\\"unit-cta\\\">\\n          <div class=\\\"unit-domain\\\">\\n            <ya-unit-mobile-app-button />\\n          </div>\\n        </div>\\n  \\n      </div>\\n\\n    </ya-unit-if>\\n    <!-- Конец Шаблона РМП -->\\n\\n  </div>\\n</ya-units-grid>\",\"css\":\"/* Шаблон 1: Мобильный сингл размером 100% x 100px\\n   Для использования в шапках сайта или \\\"подвалах\\\" */\\n\\n\\n/* Шаблоны не работают в браузерах IE 11 версии и ниже */\\n\\n/* РМП — Реклама Мобильных Приложений */\\n\\n\\n/* -------- Переменные цветов -------- */\\n/* изменив значение цвета тут — изменится во всех элементах шаблона */\\n.ya-container {\\n\\n  --color-blue: #3377FF;\\n  --color-blue-dark: #0055FF;\\n\\n  --color-blue-transparent: #3377FF1A;\\n  --color-blue-dark-transparent: #0055FF1A;\\n\\n  --color-yellow: #FFCC33;\\n  --color-yellow-dark: #FFBF00;\\n\\n  --color-black: #232526;\\n  --color-grey: #575c66;\\n  --color-grey-alt: #A3ACBF;\\n  --color-light: #f4f4f6;\\n  --color-light-alt: #ececef;\\n}\\n\\n/* Переменные цветов для устройств с поддержкой \\n   цветового профиля Display P3 (устройства Apple) */\\n\\n/* Устройства Apple поддерживают цветовой профиль \\n   с более яркими цветами (цветовой профиль Display P3). \\n   Если вы хотите поддержать его, то следует поменять \\n   значения цветов в блоке ниже */\\n@supports (color: color(display-p3)) {\\n  .ya-container {\\n    --color-blue: color(display-p3 0.2 0.47 1.0);\\n    --color-blue-dark: color(display-p3 0.0 0.33 1.0);\\n\\n    --color-blue-transparent: color(display-p3 0.2 0.47 1.0 / 0.1);\\n    --color-blue-dark-transparent: color(display-p3 0.0 0.33 1.0 / 0.1);\\n\\n    --color-yellow: color(display-p3 1.0 0.8 0.2);\\n    --color-yellow-dark: color(display-p3 1.0 0.75 0.0);\\n  }\\n}\\n\\n\\n\\n/* -------- Переменные для отрисовки объявления -------- */\\n\\n.ya-container {\\n\\n  /* Адаптивность объявления по ширине.\\n     Укажите значение none, чтобы зафиксировать размер объявления.\\n     Укажите auto, чтобы объявление занимало всю доступную ширину */\\n  --banner-flex: auto;\\n\\n  /* Фиксированная ширина объявления.\\n     Работает при --banner-flex: none */\\n  --banner-width: 320px;\\n\\n  /* Минимальная и максимальная ширина объявления.\\n     Работает при --banner-flex: auto */\\n  --banner-min-width: 300px;\\n  --banner-max-width: 640px;\\n\\n  /* Минимальная и максимальная высота объявления.\\n     Объявление будет растягиваться по высоте \\n     в зависимости от количества контента */\\n  --banner-min-height: 100px;\\n  --banner-max-height: 100px;\\n\\n\\n  /* Отображение фавиконки: \\n     вкл - block, выкл - none; */\\n  --display-favicon: block;\\n  /* Отображение изображения: \\n     вкл - block, выкл - none; */\\n  --display-image: block;\\n  /* Отображение текста: \\n     вкл - block, выкл - none; */\\n  --display-desc: none;\\n  /* Отображение цен: \\n     вкл - inline, выкл - none */\\n  --display-price: inline;\\n  /* Отображение количества отзывов (для РМП): \\n     вкл - inline, выкл - none */\\n  --display-rmp-rating-count: none;\\n\\n\\n  /* Максимальная ширина картинки */\\n  --image-max-width: 96px;\\n\\n  /* Высота картинки */\\n  --image-height: 100%;\\n\\n  /* Размер иконки приложения.\\n     Только для рекламы мобильных приложений */\\n  --app-icon-size: 80px;\\n\\n  /* Горизонтальное позиционирование сетки баннеров\\n     center - по середине, flex-start - слева,\\n     space-between - по всей ширине, space-around - по всей ширине с отступами\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/justify-content */\\n  --banners-justify-content: center;\\n\\n  /* Отступы вокруг объявления */\\n  --banner-margin: 0px;\\n  \\n  /* Отступы первых и последних объявлений от края \\n     по горизонтали и вертикали. Значение var(--banner-margin) \\n     повторяет общее значение отступов. \\n     ! Неприменимо для одиночных объявлений */\\n  --banners-grid-first-item-top-margin: var(--banner-margin);\\n  --banners-grid-first-item-left-margin: var(--banner-margin);\\n  --banners-grid-first-item-right-margin: var(--banner-margin);\\n  --banners-grid-first-item-bottom-margin: var(--banner-margin);\\n\\n  /* Цвет фона объявления. Пример: white или #f0f2f8;\\n     Допустимо использование переменных. См. начало документа */\\n  --banner-background: white;\\n  /* Цвет фона при наведении на объявление */\\n  --banner-background-hover: white;\\n\\n  /* Обводка объявления. Для отключения укажите значение none\\n     Пример: solid 1px rgba(0 0 0 / 15%);\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/border */\\n  --banner-stroke: solid 1px rgba(0 0 0 / 15%);\\n  \\n  /* Тень объявления. Пример: 0px 8px 24px rgba(0, 21, 64, 0.125);\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/box-shadow */\\n  --banner-shadow: none;\\n  /* Тень объявления при наведении */\\n  --banner-shadow-hover: none;\\n  /* Трансформация объявления при наведении. Пример: translateY(-2px); */\\n  --banner-transform-hover: none;\\n  /* Анимация изменений при наведении */\\n  --banner-transition: box-shadow 120ms ease, transform 120ms ease;\\n\\n  /* Скругление углов объявления */\\n  --banner-outer-border-radius: 0px;\\n  /* Скругление углов внутренних элементов объявления (картинка, кнопки) */\\n  --banner-inner-border-radius: 8px;\\n  \\n  /* Отступы элементов от краев объявления */\\n  --banner-padding-outer: 0px 12px;\\n  /* Отступы между элементами объявления */\\n  --banner-padding-inner: 4px;\\n\\n\\n  /* Цвет заголовка в объявлении */\\n  --color-text-header: var(--color-black); \\n  /* Цвет текста в объявлении */\\n  --color-text-desc: var(--color-grey-alt);\\n  /* Цвет цены в объявлении */\\n  --color-text-price: var(--color-black);\\n  /* Цвет ссылки в объявлении */\\n  --color-text-domain: var(--color-blue);\\n  /* Цвет ссылки в объявлении при наведении */\\n  --color-text-domain-hover: var(--color-blue-dark);\\n  /* Фон кнопки действия. Не применимо, если кнопка \\n     не предусмотрена в шаблоне (для форматов маленького размера) */\\n  --color-background-domain: var(--color-blue-transparent);\\n  /* Фон кнопки действия при наведении */\\n  --color-background-domain-hover: var(--color-blue-dark-transparent);\\n\\n  /* Цвет названия приложения в объявления (для РМП) */\\n  --color-text-app-name: var(--color-grey-alt);\\n\\n\\n  /* Цепочка используемых шрифтов в объявлении. По умолчанию указана \\n     цепочка системных шрифтов. Если шрифт не поддерживается, используется \\n     следующий по цепочке. При использовании собственного шрифта, \\n     следует указывать его название в самом начале */\\n  --font-family: \\n    -apple-system, BlinkMacSystemFont, \\\"Segoe UI\\\", Roboto, \\n    Oxygen, Ubuntu, Cantarell, \\\"Open Sans\\\", \\\"Helvetica Neue\\\", sans-serif, \\n    Apple Color Emoji, Segoe UI Emoji;\\n\\n  /* Размер шрифта и межстрочное расстояние для коротких заголовков\\n     (до 21 символа) */\\n  --font-size-title-short: 22px;\\n  --line-height-title-short: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для заголовков средней длины \\n     (от 22 до 36 символа) */\\n  --font-size-title-mid: 16px;\\n  --line-height-title-mid: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для длинных заголовков \\n     (от 37 символов) */\\n  --font-size-title-long: 14px;\\n  --line-height-title-long: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для заголовков РМП */\\n  --font-size-title-rmp: 14px;\\n  --line-height-title-rmp: calc(1em + 0px);\\n\\n  /* Размер шрифта и межстрочное расстояние для цен */\\n  --font-size-price: 14px;\\n  --line-height-price: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для текста объявления */\\n  --font-size-desc: 14px;\\n  --line-height-desc: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для ссылки */\\n  --font-size-domain: 12px;\\n  --line-height-domain: 16px;\\n\\n  /* Размер шрифта и межстрочное расстояние для названия приложения \\n     (для РМП) */\\n  --font-size-app-name: 12px;\\n  --line-height-app-name: calc(1em + 4px);\\n  \\n\\n  width: 100%;\\n  margin: 0 auto;\\n\\n  height: auto;\\n  padding: 0;\\n  overflow: visible;\\n}\\n\\n/* Специальные переменные для Рекламы Мобильных Приложений */\\n.unit-rmp-content {\\n  /* Цвет ссылки */\\n  --color-text-domain: var(--color-blue);\\n  /* Цвет ссылки при наведении */\\n  --color-text-domain-hover: var(--color-blue-dark);\\n  /* Цвет фона кнопки объявления.\\n     Не применимо если, кнопки не предусмотрено (для маленьких форматов) */\\n  --color-background-domain: var(--color-blue-transparent);\\n  /* Цвет фона кнопки объявления при наведении */\\n  --color-background-domain-hover: var(--color-blue-dark-transparent);\\n}\\n\\n/* Специальные значения для размеров экрана шире 400px */\\n@media screen and (min-width: 400px) {\\n\\n  .ya-container {\\n    --banner-padding-outer: 0px 16px;\\n\\n    --font-size-title: 18px;\\n    --line-height-title: calc(1em + 2px);\\n\\n    --font-size-title-short: 24px;\\n    --line-height-title-short: calc(1em + 2px);\\n\\n    --font-size-title-mid: 20px;\\n    --line-height-title-mid: calc(1em + 2px);\\n\\n    --font-size-title-long: 16px;\\n    --line-height-title-long: calc(1em + 2px);\\n\\n    --font-size-desc: 15px;\\n    --line-height-desc: calc(1em + 4px);\\n\\n    --font-size-domain: 14px;\\n    --line-height-domain: 16px;\\n  }\\n\\n  .ya-unit-review-count {\\n    --display-rmp-rating-count: inline;\\n  }\\n}\\n\\n/* Специальные значения для размеров экрана шире 480px */\\n@media screen and (min-width: 480px) {\\n  .ya-container {\\n    --image-width: 160px;\\n    --image-max-width: 160px;\\n  }\\n}\\n\\n\\n\\n\\n/* -------- Далее — настройка стилей объявления. -------- */\\n/* -------- Не рекомендуется редактировать -------- */\\n\\n.ya-units-grid {\\n  margin: 0px auto;\\n}\\n\\n.grid-row {\\n  justify-content: var(--banners-justify-content);\\n  align-content: var(--banners-align-content);\\n  padding: 0px 0;\\n}\\n\\n.grid-item {\\n  width: var(--banner-width);\\n  min-width: var(--banner-min-width);\\n  max-width: var(--banner-max-width);\\n  \\n  min-height: var(--banner-min-height);\\n  max-height: var(--banner-max-height);\\n\\n  font-family: var(--font-family);\\n  background: var(--banner-background);\\n\\n  border: var(--banner-stroke);\\n\\n  margin: var(--banner-margin, inherit);\\n  border-radius: var(--banner-outer-border-radius);\\n  overflow: hidden;\\n  box-sizing: border-box;\\n\\n  flex: var(--banner-flex);\\n\\n  box-shadow: var(--banner-shadow);\\n  transform: none;\\n  transition: var(--banner-transition);\\n}\\n\\n.grid-item:hover {\\n  transform: var(--banner-transform-hover);\\n  box-shadow: var(--banner-shadow-hover);\\n  background: var(--banner-background-hover);\\n  --color-text-domain: var(--color-text-domain-hover);\\n}\\n\\n.grid-item:first-child {\\n  margin-left: var(--banners-grid-first-item-left-margin);\\n}\\n\\n.grid-item:last-child {\\n  margin-right: var(--banners-grid-first-item-right-margin);\\n}\\n\\n.grid-row:first-child .grid-item {\\n  margin-top: var(--banners-grid-first-item-top-margin);\\n}\\n\\n.grid-row:last-child .grid-item {\\n  margin-bottom: var(--banners-grid-first-item-bottom-margin);\\n}\\n\\n.unit-wrapper {\\n  height: 100%;\\n}\\n\\n.ya-unit-favicon {\\n  display: block !important;\\n}\\n\\na.yrw-url {\\n  color: inherit;\\n  cursor: pointer;\\n}\\n\\n.unit-misc {\\n  position: absolute;\\n  top: 0;\\n  left: 0;\\n  width: 100%;\\n  height: 100%;\\n}\\n\\n.unit-meta {\\n  position: absolute;\\n  top: 4px;\\n  left: 4px;\\n  z-index: 2;\\n  padding: 0px 4px 0px;\\n  text-transform: uppercase;\\n  height: 12px;\\n  background: white;\\n  color: var(--color-grey);\\n  border-radius: 4px;\\n  font-size: 8px;\\n  line-height: 13px;\\n  font-weight: 500;\\n  letter-spacing: 0.12em;\\n  vertical-align: 5px;\\n  margin: 0;\\n  user-select: none;\\n  -ms-user-select: none;\\n  -moz-user-select: none;\\n  -khtml-user-select: none;\\n  -webkit-user-select: none;\\n}\\n\\n.unit-rmp-content .unit-meta {\\n  background: transparent;\\n  position: relative;\\n}\\n\\n.unit-age::before {\\n  content: \\\" | \\\";\\n}\\n\\n.unit-age:empty {\\n  display: none;\\n}\\n\\n.ya-unit-kebab_button svg circle {\\n  fill: var(--color-grey);\\n}\\n\\n.ya-unit-kebab_bg {\\n  background: white;\\n  opacity: 1.0;\\n}\\n\\n.ya-unit-kebab_icon {\\n  filter: var(--display-image, none);\\n}\\n\\n.ya-unit-kebab_icon circle {\\n  fill: var(--color-grey) !important;\\n}\\n\\n.ya-unit-kebab_button {\\n  position: absolute;\\n  z-index: 940;\\n  top: 4px;\\n  right: 4px;\\n  width: 24px;\\n  height: 24px;\\n}\\n\\n.yrw-body_warning {\\n  position: relative;\\n}\\n\\n.yrw-body_warning div {\\n  padding: 0;\\n}\\n\\n.yrw-body_warning div:not(.yrw-warning-wrapper):not(.yrw-warning-text) {\\n  position: relative;\\n  background-color: var(--color-light-alt);\\n  color: #575c66;\\n  display: flex;\\n  padding: 0 calc(var(--inner-border-radius) / 2);\\n}\\n\\n.yrw-body_warning div text {\\n  fill: #575c66;\\n}\\n\\n.yrw-body_warning div:not(.yrw-warning-wrapper) {\\n  padding: 0 calc(var(--inner-border-radius) / 2 + 4px);\\n}\\n\\n.yrw-warning-text {\\n  text-shadow: none;\\n}\\n\\n\\n\\n.unit-container {\\n  box-sizing: border-box;\\n  position: relative;\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: flex-end;\\n  overflow: hidden;\\n  max-width: var(--max-content-width, --banner-max-width, 960px);\\n  margin: auto;\\n}\\n\\n.unit-content {\\n  display: flex;\\n  flex-direction: row;\\n  justify-content: flex-start;\\n  position: relative;\\n  height: 100%;\\n}\\n\\n.unit-text-content {\\n  display: flex;\\n  justify-content: center;\\n  flex-direction: column;\\n  flex: auto;\\n  height: 100%;\\n  padding: var(--banner-padding-outer);\\n  padding-right: 32px;\\n}\\n\\n.unit-text-content > div {\\n  margin-top: var(--banner-padding-inner);\\n}\\n\\n.unit-text-content > div:first-child {\\n  margin-top: 0;\\n}\\n\\n\\n\\n.ya-unit-title, .unit-title {\\n  color: var(--color-text-header);\\n  font-size: var(--font-size-title);\\n  line-height: var(--line-height-title);\\n  font-weight: 600;\\n  display: flex;\\n}\\n\\n.title-short {\\n  font-size: var(--font-size-title-short);\\n  line-height: var(--line-height-title-short);\\n}\\n\\n.title-mid {\\n  font-size: var(--font-size-title-mid);\\n  line-height: var(--line-height-title-mid);\\n}\\n\\n.title-long {\\n  font-size: var(--font-size-title-long);\\n  line-height: var(--line-height-title-long);\\n}\\n\\n.title-rmp {\\n  font-size: var(--font-size-title-rmp);\\n  line-height: var(--line-height-title-rmp);\\n\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: center;\\n}\\n\\n.unit-app-name {\\n  font-size: var(--font-size-app-name);\\n  line-height: var(--line-height-app-name);\\n  color: var(--color-text-app-name);\\n}\\n\\n\\n\\n.unit-favicon {\\n  width: var(--font-size-domain);\\n  background-color: white;\\n  border-radius: 3px;\\n  margin-right: calc(var(--font-size-domain) / 3.5);\\n  align-self: center;\\n  display: var(--display-favicon, inline);\\n}\\n\\n.ya-unit-favicon {\\n  width: var(--font-size-domain);\\n  height: var(--font-size-domain);\\n}\\n\\n.ya-unit-rating {\\n  margin-right: 4px;\\n  height: 16px;\\n  display: inline;\\n}\\n\\n.ya-unit-review-count {\\n  display: var(--display-rmp-rating-count);\\n}\\n\\n.unit-favicon:empty,\\n.ya-unit-domain:empty,\\n.unit-domain:empty {\\n  display: none;\\n}\\n\\n.unit-domain {\\n  display: flex;\\n  margin-right: auto;\\n  border-radius: 4px;\\n  color: var(--color-text-domain);\\n  font-size: var(--font-size-domain);\\n  line-height: var(--line-height-domain);\\n  \\n  padding: 0;\\n  width: 100%;\\n  height: var(--line-height-domain, 16px);\\n  flex-direction: row;\\n  flex-wrap: wrap;\\n  justify-content: flex-start;\\n  align-content: flex-end;\\n  overflow: hidden;\\n}\\n\\n.unit-domain span {\\n  flex: none;\\n}\\n\\n.unit-domain-no-wrap {\\n  display: flex;\\n}\\n\\n.unit-with-warning .ya-unit-item-rmp .unit-cta {\\n  display: none;\\n}\\n\\n\\n\\n.unit-app-rating {\\n  display: flex;\\n  flex-direction: row;\\n  align-content: center;\\n}\\n\\n.unit-prices {\\n  display: var(--display-price, inline);\\n  white-space: nowrap;\\n  font-size: var(--font-size-price);\\n  line-height: var(--line-height-price);\\n}\\n\\n.ya-unit-price {\\n  color: var(--color-text-price);\\n  font-weight: 600;\\n  display: inline;\\n  white-space: nowrap;\\n}\\n\\n.ya-unit-old-price {\\n  margin-left: 8px;\\n  font-size: max(0.9em, 12px);\\n  line-height: max(0.9em, 12px);\\n  color: var(--color-grey-alt);\\n\\n  position: relative;\\n  white-space: nowrap;\\n  display: inline;\\n}\\n\\n.ya-unit-old-price::after {\\n  content: \\\"\\\";\\n  position: absolute;\\n  bottom: 0;\\n  left: 0;\\n  width: 100%;\\n  height: 100%;\\n  \\n  background-image: url(\\\"data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='100%' height='100%'><line class='line' x1='0' y1='65%' x2='100%' y2='50%' stroke='%23A3ACBF' stroke-width='8vh' /></svg>\\\");\\n  background-repeat: no-repeat;\\n}\\n\\n.ya-unit-review-count {\\n  transform: translateY(1px);\\n  color: var(--color-grey-alt);\\n  font-size: 13px;\\n  line-height: var(--line-height-domain);\\n}\\n\\n.unit-desc {\\n  display: var(--display-desc);\\n  color: var(--color-text-desc);\\n  font-size: var(--font-size-desc);\\n  line-height: var(--line-height-desc);\\n}\\n\\n\\n\\n.unit-image-block {\\n  display: var(--display-image);\\n  width: 100%;\\n  max-width: var(--image-max-width, none);\\n  height: var(--image-height);\\n  flex: none;\\n  border-radius: 0 var(--banner-inner-border-radius) var(--banner-inner-border-radius) 0;\\n  position: relative;\\n\\n  box-sizing: border-box;\\n  padding-right: var(--banner-padding-outer);\\n  background-color: var(--color-light-alt);\\n  overflow: hidden;\\n}\\n\\n.unit-image {\\n  width: 100%;\\n  height: 100%;\\n  display: var(--display-image);\\n  position: relative;\\n}\\n\\n.video-source-container {\\n  border-radius: 0 var(--banner-inner-border-radius) var(--banner-inner-border-radius) 0;\\n  z-index: 1;\\n  overflow: hidden;\\n}\\n\\n.unit-rmp-content .unit-image-block {\\n  overflow: visible;\\n}\\n\\n.unit-rmp-content .unit-image-block {\\n  margin-bottom: 16px;\\n}\\n\\n.ya-unit-app-icon {\\n  width: 100%;\\n  height: 100%;\\n  position: relative;\\n  display: flex;\\n}\\n\\n.unit-app-icon {\\n  margin: auto;\\n}\\n\\n.ya-unit-app-icon .yrw-img-component {\\n  width: var(--app-icon-size);\\n  height: var(--app-icon-size);\\n}\\n\\n.ya-unit-image {\\n  height: 100%;\\n}\\n\\n.yrw-img-component {\\n  height: 100%;\\n  padding-bottom: 0;\\n}\\n\\n.unit-image .img-source-component {\\n  border-radius: 0 var(--banner-inner-border-radius) var(--banner-inner-border-radius) 0;\\n  background-image: url(\\\"data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='256' height='256'><rect x='80' y='80' width='96' height='96' rx='19.2' fill='%23405580' fill-opacity='0.15'/><path d='M144.619 110.181H147.619C147.619 108.524 146.276 107.181 144.619 107.181V110.181ZM111.102 147.94L146.74 112.302L142.498 108.06L106.86 143.698L111.102 147.94ZM114.072 113.181H144.619V107.181L114.072 107.181V113.181ZM141.619 110.181V140.728H147.619V110.181L141.619 110.181Z' fill='white'/></svg>\\\");\\n  background-position: center;\\n}\\n\\n.ya-unit-app-icon .img-source-component {\\n  border-radius: calc(var(--app-icon-size) / 4 - 4px);\\n}\\n\\n.ya-clamp {\\n  width: 100%;\\n}\\n\\n.yrw-content {\\n  overflow: visible;\\n}\\n\\n.ya-grid-template:empty {\\n  display: none;\\n}\",\"gridColumns\":\"1\",\"gridRows\":\"1\",\"defaultHeight\":\"100\"},{\"value\":\"custom2\",\"props\":{},\"label\":\"Mobile single 100% x 300px\",\"template\":\"<ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n\\n  <div class=\\\"unit-misc\\\">\\n    <ya-unit-kebab class=\\\"ya-unit-kebab_dark\\\" />\\n    <div class=\\\"unit-meta\\\">\\n      <ya-unit-category class=\\\"unit-category\\\" />\\n      <ya-unit-age class=\\\"unit-age\\\" />\\n    </div>\\n  </div>\\n\\n\\n\\n  <div class=\\\"unit-content\\\">\\n    <div class=\\\"unit-image-block\\\">\\n      <ya-unit-image/>\\n    </div>\\n\\n    <div class=\\\"unit-text-content\\\" data-cols=\\\"1\\\" data-rows=\\\"1\\\">\\n\\n      <div class=\\\"unit-title\\\">\\n        <ya-unit-if condition=\\\"unit.title < 22\\\">\\n          <ya-clamp lines=\\\"3\\\" class=\\\"title-short\\\"><ya-unit-title /></ya-clamp>\\n        </ya-unit-if>\\n\\n        <ya-unit-if condition=\\\"unit.title > 21 & unit.title < 33\\\">\\n          <ya-clamp lines=\\\"3\\\" class=\\\"title-mid\\\"><ya-unit-title /></ya-clamp>\\n        </ya-unit-if>\\n\\n        <ya-unit-if condition=\\\"unit.title > 32\\\">\\n          <ya-clamp lines=\\\"3\\\" class=\\\"title-long\\\"><ya-unit-title /></ya-clamp>\\n        </ya-unit-if>\\n      </div>\\n\\n      <!-- Начало Шаблона ТГО -->\\n      <ya-unit-if condition=\\\"!unit.isRmp\\\">\\n        <div class=\\\"unit-prices\\\"><ya-unit-price /><ya-unit-old-price /></div>\\n        <ya-clamp lines=\\\"2\\\" class=\\\"unit-desc\\\"><ya-unit-desc /></ya-clamp>\\n      </ya-unit-if>\\n      <!-- Конец Шаблона ТГО -->\\n\\n\\n    \\n      <!-- Начало Шаблона РМП -->\\n      <ya-unit-if condition=\\\"unit.isRmp\\\">\\n        <div class=\\\"rmp-app-content\\\">\\n          <ya-unit-app-icon />\\n\\n          <div class=\\\"rmp-text-content\\\">\\n\\n            <div class=\\\"unit-app-name\\\">\\n              <ya-clamp lines=\\\"2\\\">\\n                <ya-unit-app-name />\\n              </ya-clamp>\\n            </div>\\n\\n            <div class=\\\"unit-app-rating\\\">\\n              <ya-unit-rating />\\n              <ya-unit-review-count />\\n            </div>\\n          </div>\\n\\n        </div>\\n\\n      </ya-unit-if>\\n      <!-- Конец Шаблона РМП -->\\n\\n    </div>\\n\\n    <div class=\\\"unit-cta\\\">\\n      <div class=\\\"unit-domain\\\">\\n        <ya-unit-mobile-app-button />\\n        <ya-unit-if condition=\\\"!unit.isRmp\\\">\\n          <span class=\\\"unit-domain-no-wrap\\\">\\n            <span class=\\\"unit-favicon\\\"><ya-unit-favicon size=\\\"32\\\"/></span>\\n            <ya-unit-domain class=\\\"domain\\\"/>\\n          </span>\\n        </ya-unit-if>\\n        \\n      </div>\\n    </div>\\n\\n  </div>\\n\\n</ya-units-grid>\",\"css\":\"/* Шаблон 2: Мобильный сингл размером 100% x 300px \\n   Для использования внутри контента */\\n\\n\\n/* Шаблоны не работают в браузерах IE 11 версии и ниже */\\n\\n/* РМП — Реклама Мобильных Приложений */\\n\\n\\n/* -------- Переменные цветов -------- */\\n/* Изменив значение цвета в переменной, оно одновременно\\n   изменится во всех элементах шаблона, где указано */\\n.ya-container {\\n\\n  --color-blue: #3377FF;\\n  --color-blue-dark: #0055FF;\\n\\n  --color-blue-transparent: #3377FF1A;\\n  --color-blue-dark-transparent: #0055FF1A;\\n\\n  --color-black: #232526;\\n  --color-grey: #575c66;\\n  --color-grey-alt: #A3ACBF;\\n  --color-light: #f4f4f6;\\n  --color-light-alt: #ececef;\\n}\\n\\n/* Переменные цветов для устройств с поддержкой \\n   цветового профиля Display P3 (устройства Apple) */\\n\\n/* Устройства Apple поддерживают цветовой профиль \\n   с более яркими цветами (цветовой профиль Display P3). \\n   Если вы хотите поддержать его, то следует поменять \\n   значения цветов в блоке ниже */\\n@supports (color: color(display-p3)) {\\n  .ya-container {\\n    --color-blue: color(display-p3 0.2 0.47 1.0);\\n    --color-blue-dark: color(display-p3 0.0 0.33 1.0);\\n\\n    --color-blue-transparent: color(display-p3 0.2 0.47 1.0 / 0.1);\\n    --color-blue-dark-transparent: color(display-p3 0.0 0.33 1.0 / 0.1);\\n\\n    --color-yellow: color(display-p3 1.0 0.8 0.2);\\n    --color-yellow-dark: color(display-p3 1.0 0.75 0.0);\\n  }\\n}\\n\\n\\n\\n/* -------- Переменные для отрисовки объявления -------- */\\n\\n.ya-container {\\n\\n  /* Адаптивность объявления по ширине.\\n     Укажите значение none, чтобы зафиксировать размер объявления.\\n     Укажите auto, чтобы объявление занимало всю доступную ширину */\\n  --banner-flex: auto;\\n\\n  /* Фиксированная ширина объявления.\\n     Работает при --banner-flex: none */\\n  --banner-width: 300px;\\n\\n  /* Минимальная и максимальная ширина объявления.\\n     Работает при --banner-flex: auto */\\n  --banner-min-width: 320px;\\n  --banner-max-width: 540px;\\n\\n  /* Минимальная и максимальная высота объявления.\\n     Объявление будет растягиваться по высоте \\n     в зависимости от количества контента */\\n  --banner-min-height: 300px;\\n  --banner-max-height: none;\\n\\n\\n  /* Отображение фавиконки: \\n     вкл - block, выкл - none; */\\n  --display-favicon: block;\\n  /* Отображение изображения: \\n     вкл - block, выкл - none; */\\n  --display-image: block;\\n  /* Отображение текста: \\n     вкл - block, выкл - none; */\\n  --display-desc: inline;\\n  /* Отображение цен: \\n     вкл - inline, выкл - none */\\n  --display-price: inline;\\n  /* Отображение количества отзывов (для РМП): \\n     вкл - inline, выкл - none */\\n  --display-rmp-rating-count: inline;\\n\\n\\n  /* Максимальная ширина картинки */\\n  --image-max-width: 100%;\\n\\n  /* Высота картинки */\\n  --image-height: 160px;\\n\\n  /* Размер иконки приложения.\\n     Только для рекламы мобильных приложений */\\n  --app-icon-size: 48px;\\n\\n  /* Горизонтальное позиционирование сетки баннеров\\n     center - по середине, flex-start - слева,\\n     space-between - по всей ширине, space-around - по всей ширине с отступами\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/justify-content */\\n  --banners-justify-content: center;\\n\\n  /* Отступы вокруг объявления */\\n  --banner-margin: 8px 0;\\n\\n  /* Отступы первых и последних объявлений от края \\n     по горизонтали и вертикали. Значение var(--banner-margin) \\n     повторяет общее значение отступов. \\n     ! Неприменимо для одиночных объявлений */\\n  --banners-grid-first-item-top-margin: 0;\\n  --banners-grid-first-item-left-margin: 0;\\n  --banners-grid-first-item-right-margin: 0;\\n  --banners-grid-first-item-bottom-margin: 0;\\n\\n  /* Цвет фона объявления. Пример: white или #f0f2f8;\\n     Допустимо использование переменных. См. начало документа */\\n  --banner-background: var(--color-light);\\n  /* Цвет фона при наведении на объявление */\\n  --banner-background-hover: var(--color-light);\\n\\n  /* Обводка объявления. Для отключения укажите значение none\\n     Пример: solid 1px rgba(0 0 0 / 15%);\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/border */\\n  --banner-stroke: none;\\n  \\n  /* Тень объявления. Пример: 0px 8px 24px rgba(0, 21, 64, 0.125);\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/box-shadow */\\n  --banner-shadow: none;\\n  /* Тень объявления при наведении */\\n  --banner-shadow-hover: none;\\n  /* Трансформация объявления при наведении. Пример: translateY(-2px); */\\n  --banner-transform-hover: none;\\n  /* Анимация изменений при наведении */\\n  --banner-transition: box-shadow 120ms ease, transform 120ms ease;\\n\\n  /* Скругление углов объявления */\\n  --banner-outer-border-radius: 0px;\\n  /* Скругление углов внутренних элементов объявления (картинка, кнопки) */\\n  --banner-inner-border-radius: 8px;\\n  \\n  /* Отступы элементов от краев объявления */\\n  --banner-padding-outer: 10px;\\n  /* Отступы между элементами объявления */\\n  --banner-padding-inner: 10px;\\n\\n\\n  /* Цвет заголовка в объявлении */\\n  --color-text-header: var(--color-black); \\n  /* Цвет текста в объявлении */\\n  --color-text-desc: var(--color-grey-alt);\\n  /* Цвет цены в объявлении */\\n  --color-text-price: var(--color-black);\\n  /* Цвет ссылки в объявлении */\\n  --color-text-domain: var(--color-blue);\\n  /* Цвет ссылки в объявлении при наведении */\\n  --color-text-domain-hover: var(--color-blue-dark);\\n  /* Фон кнопки действия. Не применимо, если кнопка \\n     не предусмотрена в шаблоне (для форматов маленького размера) */\\n  --color-background-domain: var(--color-blue-transparent);\\n  /* Фон кнопки действия при наведении */\\n  --color-background-domain-hover: var(--color-blue-dark-transparent);\\n\\n  /* Цвет названия приложения в объявления (для РМП) */\\n  --color-text-app-name: var(--color-grey-alt);\\n\\n\\n  /* Цепочка используемых шрифтов в объявлении. По умолчанию указана \\n     цепочка системных шрифтов. Если шрифт не поддерживается, используется \\n     следующий по цепочке. При использовании собственного шрифта, \\n     следует указывать его название в самом начале */\\n  --font-family: \\n    -apple-system, BlinkMacSystemFont, \\\"Segoe UI\\\", Roboto, \\n    Oxygen, Ubuntu, Cantarell, \\\"Open Sans\\\", \\\"Helvetica Neue\\\", sans-serif, \\n    Apple Color Emoji, Segoe UI Emoji;\\n\\n  /* Размер шрифта и межстрочное расстояние для коротких заголовков\\n     (до 21 символа) */\\n  --font-size-title-short: 24px;\\n  --line-height-title-short: calc(1em + 0px);\\n\\n  /* Размер шрифта и межстрочное расстояние для заголовков средней длины \\n     (от 22 до 31 символа) */\\n  --font-size-title-mid: 20px;\\n  --line-height-title-mid: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для длинных заголовков \\n     (от 32 символов) */\\n  --font-size-title-long: 20px;\\n  --line-height-title-long: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для заголовков РМП */\\n  --font-size-title-rmp: 20px;\\n  --line-height-title-rmp: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для цен */\\n  --font-size-price: 16px;\\n  --line-height-price: calc(1em + 4px);\\n\\n  /* Размер шрифта и межстрочное расстояние для текста объявления */\\n  --font-size-desc: 15px;\\n  --line-height-desc: calc(1em + 3px);\\n\\n  /* Размер шрифта и межстрочное расстояние для ссылки */\\n  --font-size-domain: 15px;\\n  --line-height-domain: 20px;\\n\\n  /* Размер шрифта и межстрочное расстояние для названия приложения \\n     (для РМП) */\\n  --font-size-app-name: 15px;\\n  --line-height-app-name: calc(1em + 3px);\\n  \\n\\n  width: 100%;\\n  margin: 0 auto;\\n\\n  height: auto;\\n  padding: 0;\\n  overflow: visible;\\n}\\n\\n/* Специальные переменные для Рекламы Мобильных Приложений */\\n.ya-unit-item-rmp {\\n  /* Цвет текста ссылки */\\n  --color-text-domain: var(--color-blue);\\n  /* Цвет текста ссылки при наведении */\\n  --color-text-domain-hover: var(--color-blue-dark);\\n  /* Цвет фона кнопки объявления.\\n     Не применимо если, кнопки не предусмотрено (для маленьких форматов) */\\n  --color-background-domain: var(--color-blue-transparent);\\n  /* Цвет фона кнопки объявления при наведении */\\n  --color-background-domain-hover: var(--color-blue-dark-transparent);\\n}\\n\\n/* Специальные значения для размеров экрана шире 360px */\\n@media screen and (min-width: 360px) {\\n\\n  .ya-container {\\n    --image-height: 200px;\\n\\n    --app-icon-size: 64px;\\n\\n    --font-size-title: 18px;\\n    --line-height-title: calc(1em + 2px);\\n\\n    --font-size-title-short: 28px;\\n    --line-height-title-short: calc(1em + 0px);\\n  \\n    --font-size-title-mid: 24px;\\n    --line-height-title-mid: calc(1em + 2px);\\n  \\n    --font-size-title-long: 22px;\\n    --line-height-title-long: calc(1em + 2px);\\n\\n    --font-size-price: 20px;\\n    --line-height-price: calc(1em + 0px);\\n\\n    --font-size-desc: 16px;\\n    --line-height-desc: calc(1em + 4px);\\n\\n    --font-size-app-name: 18px;\\n    --line-height-app-name: calc(1em + 2px);\\n\\n    --font-size-domain: 16px;\\n    --line-height-domain: 20px;\\n\\n    --banner-padding-outer: 12px;\\n    --banner-padding-inner: 12px;\\n  }\\n}\\n\\n/* Специальные значения для размеров экрана шире 420px */\\n@media screen and (min-width: 420px) {\\n  .ya-container {\\n    --image-height: 240px;\\n\\n    --font-size-title: 18px;\\n    --line-height-title: calc(1em + 2px);\\n\\n    --font-size-title-short: 32px;\\n    --line-height-title-short: calc(1em + 0px);\\n\\n    --font-size-title-mid: 26px;\\n    --line-height-title-mid: calc(1em + 2px);\\n\\n    --font-size-title-long: 24px;\\n    --line-height-title-long: calc(1em + 2px);\\n\\n    --font-size-desc: 16px;\\n    --line-height-desc: calc(1em + 4px);\\n\\n    --font-size-app-name: 20px;\\n    --line-height-app-name: calc(1em + 2px);\\n\\n    --font-size-domain: 16px;\\n  }\\n}\\n\\n\\n\\n\\n/* -------- Далее — настройка стилей объявления. -------- */\\n/* -------- Не рекомендуется редактировать -------- */\\n\\n.ya-units-grid {\\n  margin: 0px auto;\\n}\\n\\n.grid-row {\\n  justify-content: var(--banners-justify-content);\\n  align-content: var(--banners-align-content);\\n  padding: 0px 0;\\n}\\n\\n.grid-item {\\n  width: var(--banner-width);\\n  min-width: var(--banner-min-width);\\n  max-width: var(--banner-max-width);\\n  \\n  min-height: var(--banner-min-height);\\n  max-height: var(--banner-max-height);\\n\\n  font-family: var(--font-family);\\n  background: var(--banner-background);\\n  border: var(--banner-stroke);\\n\\n  margin: var(--banner-margin, inherit);\\n  border-radius: var(--banner-outer-border-radius);\\n  overflow: hidden;\\n  box-sizing: border-box;\\n  flex: var(--banner-flex);\\n  box-shadow: var(--banner-shadow);\\n  transform: none;\\n  transition: var(--banner-transition);\\n}\\n\\n.grid-item:hover {\\n  transform: var(--banner-transform-hover);\\n  box-shadow: var(--banner-shadow-hover);\\n  background: var(--banner-background-hover);\\n  --color-text-domain: var(--color-text-domain-hover);\\n}\\n\\n.grid-item:first-child {\\n  margin-left: var(--banners-grid-first-item-left-margin);\\n}\\n\\n.grid-item:last-child {\\n  margin-right: var(--banners-grid-first-item-right-margin);\\n}\\n\\n.grid-row:first-child .grid-item {\\n  margin-top: var(--banners-grid-first-item-top-margin);\\n}\\n\\n.grid-row:last-child .grid-item {\\n  margin-bottom: var(--banners-grid-first-item-bottom-margin);\\n}\\n\\n.unit-wrapper {\\n  height: 100%;\\n}\\n\\n.ya-unit-favicon {\\n  display: block !important;\\n}\\n\\na.yrw-url {\\n  color: inherit;\\n  cursor: pointer;\\n}\\n\\n.unit-misc {\\n  position: absolute;\\n  top: 0;\\n  left: 0;\\n  width: 100%;\\n  height: 100%;\\n}\\n\\n.unit-meta {\\n  position: absolute;\\n  top: 10px;\\n  left: var(--banner-padding-outer);\\n  z-index: 2;\\n  padding: 0px 4px 0px;\\n  text-transform: uppercase;\\n  height: 12px;\\n  background: transparent;\\n  color: var(--color-grey);\\n  border-radius: 4px;\\n  font-size: 8px;\\n  line-height: 13px;\\n  font-weight: 500;\\n  letter-spacing: 0.12em;\\n  vertical-align: 5px;\\n  margin: 0;\\n  user-select: none;\\n  -ms-user-select: none;\\n  -moz-user-select: none;\\n  -khtml-user-select: none;\\n  -webkit-user-select: none;\\n}\\n\\n.ya-unit-item-rmp .unit-meta {\\n  background: transparent;\\n}\\n\\n.unit-age::before {\\n  content: \\\" | \\\";\\n}\\n\\n.unit-age:empty {\\n  display: none;\\n}\\n\\n.ya-unit-kebab_button svg circle {\\n  fill: var(--color-grey);\\n}\\n\\n.ya-unit-kebab_bg {\\n  background: transparent;\\n  opacity: 1.0;\\n}\\n\\n.ya-unit-kebab_icon {\\n  filter: var(--display-image, none);\\n}\\n\\n.ya-unit-kebab_icon circle {\\n  fill: var(--color-grey) !important;\\n}\\n\\n.ya-unit-kebab_button {\\n  position: absolute;\\n  z-index: 940;\\n  top: 4px;\\n  right: 4px;\\n  width: 24px;\\n  height: 24px;\\n}\\n\\n.yrw-body_warning {\\n  position: relative;\\n}\\n\\n.yrw-body_warning div {\\n  padding: 0;\\n}\\n\\n.yrw-body_warning div:not(.yrw-warning-wrapper):not(.yrw-warning-text) {\\n  position: relative;\\n  background-color: var(--color-light-alt);\\n  color: #575c66;\\n  display: flex;\\n  padding: 0 calc(var(--inner-border-radius) / 2);\\n}\\n\\n.yrw-body_warning div text {\\n  fill: #575c66;\\n}\\n\\n.yrw-body_warning div:not(.yrw-warning-wrapper) {\\n  padding: 0 calc(var(--inner-border-radius) / 2 + 4px);\\n}\\n\\n.yrw-warning-text {\\n  text-shadow: none;\\n}\\n\\n\\n\\n.unit-container {\\n  box-sizing: border-box;\\n  position: relative;\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: flex-end;\\n  overflow: hidden;\\n  max-width: var(--max-content-width, --banner-max-width, 960px);\\n  margin: auto;\\n}\\n\\n.unit-content {\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: flex-start;\\n  position: relative;\\n  height: 100%;\\n\\n  padding: 8px;\\n  padding: var(--banner-padding-outer);\\n  padding-top: 32px;\\n}\\n\\n.unit-text-content {\\n  display: flex;\\n  justify-content: flex-start;\\n  flex-direction: column;\\n  position: relative;\\n  flex: auto;\\n}\\n\\n.rmp-app-content {\\n  display: flex;\\n  flex-direction: row;\\n}\\n\\n.rmp-text-content {\\n  display: flex;\\n  justify-content: center;\\n  flex-direction: column;\\n}\\n\\n.unit-text-content > div {\\n  margin-top: var(--banner-padding-inner);\\n}\\n\\n.rmp-text-content > div {\\n  margin-top: calc(var(--banner-padding-inner) / 2);\\n}\\n\\n.rmp-text-content > div:first-child {\\n  margin-top: 0;\\n}\\n\\n\\n\\n.ya-unit-title, .unit-title {\\n  color: var(--color-text-header);\\n  font-size: var(--font-size-title);\\n  line-height: var(--line-height-title);\\n  font-weight: 600;\\n  display: flex;\\n}\\n\\n.title-short {\\n  font-size: var(--font-size-title-short);\\n  line-height: var(--line-height-title-short);\\n}\\n\\n.title-mid {\\n  font-size: var(--font-size-title-mid);\\n  line-height: var(--line-height-title-mid);\\n}\\n\\n.title-long {\\n  font-size: var(--font-size-title-long);\\n  line-height: var(--line-height-title-long);\\n}\\n\\n.title-rmp {\\n  font-size: var(--font-size-title-rmp);\\n  line-height: var(--line-height-title-rmp);\\n\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: center;\\n}\\n\\n.unit-app-name {\\n  font-size: var(--font-size-app-name);\\n  line-height: var(--line-height-app-name);\\n  color: var(--color-text-app-name);\\n}\\n\\n\\n.unit-cta {\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: center;\\n\\n  box-sizing: border-box;\\n  padding: 12px;\\n\\n  font-size: var(--domain-font-size);\\n  line-height: var(--domain-line-height);\\n  text-align: center;\\n\\n  color: var(--color-cta-color);\\n  background-color: var(--color-background-domain);\\n  border-radius: var(--banner-inner-border-radius);\\n  margin-top: var(--banner-padding-inner);\\n  transition: var(--cta-transition);\\n}\\n\\n.unit-cta:hover {\\n  color: var(--color-cta-hover-color);\\n  background-color: var(--color-background-domain-hover);\\n}\\n\\n\\n.unit-favicon {\\n  width: var(--line-height-domain);\\n  background-color: transparent;\\n  border-radius: 3px;\\n  align-self: center;\\n  display: var(--display-favicon, inline);\\n}\\n\\n.ya-unit-favicon {\\n  width: var(--line-height-domain);\\n  height: var(--line-height-domain);\\n}\\n\\n.ya-unit-rating {\\n  margin-right: 4px;\\n  height: 16px;\\n  display: inline;\\n}\\n\\n.ya-unit-review-count {\\n  display: var(--display-rmp-rating-count);\\n  transform: translateY(1px);\\n  color: var(--color-grey-alt);\\n  font-size: 13px;\\n  line-height: 16px;\\n}\\n\\n.unit-favicon:empty,\\n.ya-unit-domain:empty,\\n.unit-domain:empty {\\n  display: none;\\n}\\n\\n.unit-domain {\\n  display: flex;\\n  margin-right: auto;\\n  border-radius: 4px;\\n\\n  color: var(--color-text-domain);\\n  font-size: var(--font-size-domain);\\n  line-height: var(--line-height-domain);\\n  padding: 0;\\n\\n  width: 100%;\\n  height: var(--line-height-domain, 16px);\\n\\n  flex-direction: row;\\n  flex-wrap: wrap;\\n  justify-content: center;\\n  align-content: flex-end;\\n\\n  overflow: hidden;\\n}\\n\\n.unit-domain > *,\\n.unit-domain .unit-domain-no-wrap > * {\\n  margin-right: calc(var(--line-height-domain) / 3.5);\\n}\\n\\n.unit-domain span {\\n  flex: none;\\n}\\n\\n.unit-domain-no-wrap {\\n  display: flex;\\n}\\n\\n\\n\\n.unit-app-rating {\\n  display: flex;\\n  flex-direction: row;\\n  align-content: center;\\n}\\n\\n.unit-prices {\\n  display: var(--display-price, inline);\\n  white-space: nowrap;\\n\\n  font-size: var(--font-size-price);\\n  line-height: var(--line-height-price);\\n}\\n\\n.ya-unit-price {\\n  color: var(--color-text-price);\\n  font-weight: 600;\\n\\n  display: inline;\\n  white-space: nowrap;\\n}\\n\\n.ya-unit-old-price {\\n  margin-left: 8px;\\n  font-size: max(0.9em, 12px);\\n  line-height: max(0.9em, 12px);\\n  color: var(--color-grey-alt);\\n\\n  position: relative;\\n  white-space: nowrap;\\n  display: inline;\\n}\\n\\n.ya-unit-old-price::after {\\n  content: \\\"\\\";\\n  position: absolute;\\n  bottom: 0;\\n  left: 0;\\n  width: 100%;\\n  height: 100%;\\n  \\n  background-image: url(\\\"data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='100%' height='100%'><line class='line' x1='0' y1='65%' x2='100%' y2='50%' stroke='%23A3ACBF' stroke-width='8vh' /></svg>\\\");\\n  background-repeat: no-repeat;\\n}\\n\\n.unit-desc {\\n  display: var(--display-desc);\\n  color: var(--color-text-desc);\\n  font-size: var(--font-size-desc);\\n  line-height: var(--line-height-desc);\\n}\\n\\n\\n\\n.unit-image-block {\\n  display: var(--display-image);\\n  width: 100%;\\n  max-width: var(--image-max-width, none);\\n  height: var(--image-height);\\n  flex: none;\\n  border-radius: var(--banner-inner-border-radius);\\n  position: relative;\\n\\n  box-sizing: border-box;\\n  background-color: var(--color-light-alt);\\n  overflow: hidden;\\n}\\n\\n.unit-image {\\n  width: 100%;\\n  height: 100%;\\n  display: var(--display-image);\\n  position: relative;\\n}\\n\\n.video-source-container {\\n  border-radius: var(--banner-inner-border-radius, 8px);\\n  z-index: 1;\\n  overflow: hidden;\\n}\\n\\n.ya-unit-app-icon {\\n  position: relative;\\n\\n  border-radius: calc(var(--app-icon-size) / 4);\\n  margin-right: var(--banner-padding-inner);\\n  display: flex;\\n}\\n\\n.unit-app-icon {\\n  margin: auto;\\n}\\n\\n.ya-unit-app-icon .yrw-img-component {\\n  width: var(--app-icon-size);\\n  height: var(--app-icon-size);\\n}\\n\\n.ya-unit-image {\\n  height: 100%;\\n}\\n\\n.yrw-img-component {\\n  height: 100%;\\n  padding-bottom: 0;\\n}\\n\\n.unit-image .img-source-component {\\n  border-radius: var(--banner-inner-border-radius);\\n  background-image: url(\\\"data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='256' height='256'><rect x='80' y='80' width='96' height='96' rx='19.2' fill='%23405580' fill-opacity='0.15'/><path d='M144.619 110.181H147.619C147.619 108.524 146.276 107.181 144.619 107.181V110.181ZM111.102 147.94L146.74 112.302L142.498 108.06L106.86 143.698L111.102 147.94ZM114.072 113.181H144.619V107.181L114.072 107.181V113.181ZM141.619 110.181V140.728H147.619V110.181L141.619 110.181Z' fill='white'/></svg>\\\");\\n  background-position: center;\\n}\\n\\n.ya-unit-app-icon .img-source-component {\\n  border-radius: calc(var(--app-icon-size) / 4 - 4px);\\n}\\n\\n.ya-clamp {\\n  width: 100%;\\n}\\n\\n.yrw-content {\\n  overflow: visible;\\n}\\n\\n.ya-grid-template:empty {\\n  display: none;\\n}\",\"gridColumns\":\"1\",\"gridRows\":\"1\",\"defaultWidth\":\"500\",\"defaultHeight\":\"450\"},{\"value\":\"6\",\"name\":\"grid\",\"props\":{},\"label\":\"Universal slider 100% x auto\",\"template\":\"<ya-units-slider>\\n\\n  <div class=\\\"unit-misc\\\">\\n    <ya-unit-kebab class=\\\"ya-unit-kebab_dark\\\" />\\n    <div class=\\\"unit-meta\\\">\\n      <ya-unit-category class=\\\"unit-category\\\" />\\n      <ya-unit-age class=\\\"unit-age\\\" />\\n    </div>\\n  </div>\\n\\n\\n\\n  <div class=\\\"unit-content\\\">\\n\\n    <div class=\\\"unit-image-block\\\">\\n      <ya-unit-image/>\\n    </div>\\n\\n    <div class=\\\"unit-text-content\\\" data-cols=\\\"1\\\" data-rows=\\\"1\\\">\\n\\n      <div class=\\\"unit-title\\\">\\n        <ya-unit-if condition=\\\"unit.title < 22\\\">\\n          <ya-clamp lines=\\\"3\\\" class=\\\"title-short\\\"><ya-unit-title /></ya-clamp>\\n        </ya-unit-if>\\n\\n        <ya-unit-if condition=\\\"unit.title > 21 & unit.title < 33\\\">\\n          <ya-clamp lines=\\\"3\\\" class=\\\"title-mid\\\"><ya-unit-title /></ya-clamp>\\n        </ya-unit-if>\\n\\n        <ya-unit-if condition=\\\"unit.title > 32\\\">\\n          <ya-clamp lines=\\\"3\\\" class=\\\"title-long\\\"><ya-unit-title /></ya-clamp>\\n        </ya-unit-if>\\n      </div>\\n\\n      <!-- Начало Шаблона ТГО -->\\n      <ya-unit-if condition=\\\"!unit.isRmp\\\">\\n\\n        <div class=\\\"unit-prices\\\"><ya-unit-price /><ya-unit-old-price /></div>\\n  \\n        <ya-clamp lines=\\\"4\\\" class=\\\"unit-desc\\\"><ya-unit-desc /></ya-clamp>\\n\\n\\n      </ya-unit-if>\\n      <!-- Конец Шаблона ТГО -->\\n\\n\\n    \\n      <!-- Начало Шаблона РМП -->\\n      <ya-unit-if condition=\\\"unit.isRmp\\\">\\n\\n        <!-- <div class=\\\"unit-title\\\">\\n          <span class=\\\"title-rmp\\\">\\n            <ya-clamp lines=\\\"2\\\"><ya-unit-title /></ya-clamp>\\n          </span>\\n        </div> -->\\n\\n        <div class=\\\"rmp-app-content\\\">\\n          <ya-unit-app-icon />\\n\\n          <div class=\\\"rmp-text-content\\\">\\n\\n            <div class=\\\"unit-app-name\\\">\\n              <ya-clamp lines=\\\"2\\\">\\n                <ya-unit-app-name />\\n              </ya-clamp>\\n            </div>\\n\\n            <div class=\\\"unit-app-rating\\\">\\n              <ya-unit-rating />\\n              <ya-unit-review-count />\\n            </div>\\n          </div>\\n\\n        </div>\\n\\n      </ya-unit-if>\\n      <!-- Конец Шаблона РМП -->\\n\\n    </div>\\n\\n    <div class=\\\"unit-cta\\\">\\n      <div class=\\\"unit-domain\\\">\\n        <ya-unit-mobile-app-button />\\n        <ya-unit-if condition=\\\"!unit.isRmp\\\">\\n          <span class=\\\"unit-domain-no-wrap\\\">\\n            <span class=\\\"unit-favicon\\\"><ya-unit-favicon size=\\\"32\\\"/></span>\\n            <ya-unit-domain class=\\\"domain\\\"/>\\n          </span>\\n        </ya-unit-if>\\n        \\n      </div>\\n    </div>\\n\\n  </div>\\n\\n</ya-units-slider>\",\"css\":\"/* Шаблон 3: Универсальный слайдер размером 100% x Auto (min: 240px)\\n   Размер блока по ширине: 80%.\\n   Для использования внутри контента.\\n   \\n   Подходит для использования на сайтах, использующих \\n   единую верстку для мобильных устройств и десктопов */\\n\\n\\n/* Шаблоны не работают в браузерах IE 11 версии и ниже */\\n\\n/* РМП — Реклама Мобильных Приложений */\\n\\n\\n/* -------- Переменные цветов -------- */\\n/* изменив значение цвета тут — изменится во всех элементах шаблона */\\n.ya-container {\\n\\n  --color-blue: #3377FF;\\n  --color-blue-dark: #0055FF;\\n\\n  --color-blue-transparent: #3377FF1A;\\n  --color-blue-dark-transparent: #0055FF1A;\\n\\n  --color-yellow: #FFCC33;\\n  --color-yellow-dark: #FFBF00;\\n\\n  --color-black: #232526;\\n  --color-grey: #575c66;\\n  --color-grey-alt: #A3ACBF;\\n  --color-light: #f4f4f6;\\n  --color-light-alt: #ececef;\\n}\\n\\n/* Переменные цветов для устройств с поддержкой \\n   цветового профиля Display P3 (устройства Apple) */\\n\\n/* Устройства Apple поддерживают цветовой профиль \\n   с более яркими цветами (цветовой профиль Display P3). \\n   Если вы хотите поддержать его, то следует поменять \\n   значения цветов в блоке ниже */\\n@supports (color: color(display-p3)) {\\n  .ya-container {\\n    --color-blue: color(display-p3 0.2 0.47 1.0);\\n    --color-blue-dark: color(display-p3 0.0 0.33 1.0);\\n\\n    --color-blue-transparent: color(display-p3 0.2 0.47 1.0 / 0.1);\\n    --color-blue-dark-transparent: color(display-p3 0.0 0.33 1.0 / 0.1);\\n\\n    --color-yellow: color(display-p3 1.0 0.8 0.2);\\n    --color-yellow-dark: color(display-p3 1.0 0.75 0.0);\\n  }\\n}\\n\\n\\n\\n/* -------- Переменные для отрисовки объявления -------- */\\n\\n.ya-container {\\n\\n  /* Адаптивность объявления по ширине.\\n     Укажите значение none, чтобы зафиксировать размер объявления.\\n     Укажите auto, чтобы объявление занимало всю доступную ширину */\\n  --banner-flex: none;\\n\\n  /* Фиксированная ширина объявления.\\n     Работает при --banner-flex: none */\\n  --banner-width: 80%;\\n\\n  /* Минимальная и максимальная ширина объявления.\\n     Работает при --banner-flex: auto */\\n  --banner-min-width: 200px;\\n  --banner-max-width: 320px;\\n\\n  /* Минимальная и максимальная высота объявления.\\n     Объявление будет растягиваться по высоте \\n     в зависимости от количества контента */\\n  --banner-min-height: 240px;\\n  --banner-max-height: none;\\n\\n\\n  /* Отображение фавиконки: \\n     вкл - block, выкл - none; */\\n  --display-favicon: block;\\n  /* Отображение изображения: \\n     вкл - block, выкл - none; */\\n  --display-image: block;\\n  /* Отображение текста: \\n     вкл - block, выкл - none; */\\n  --display-desc: inline;\\n  /* Отображение цен: \\n     вкл - inline, выкл - none */\\n  --display-price: inline;\\n  /* Отображение количества отзывов (для РМП): \\n     вкл - inline, выкл - none */\\n  --display-rmp-rating-count: inline;\\n\\n\\n  /* Максимальная ширина картинки */\\n  --image-max-width: 100%;\\n\\n  /* Высота картинки */\\n  --image-height: 160px;\\n\\n  /* Размер иконки приложения.\\n     Только для рекламы мобильных приложений */\\n  --app-icon-size: 48px;\\n\\n  /* Горизонтальное позиционирование сетки баннеров\\n     center - по середине, flex-start - слева,\\n     space-between - по всей ширине, space-around - по всей ширине с отступами\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/justify-content */\\n  --banners-justify-content: center;\\n\\n  /* Отступы вокруг объявления */\\n  --banner-margin: 5px;\\n  \\n  /* Отступы первых и последних объявлений от края \\n     по горизонтали и вертикали. Значение var(--banner-margin) \\n     повторяет общее значение отступов. \\n     ! Неприменимо для одиночных объявлений */\\n  --banners-grid-first-item-top-margin: 0;\\n  --banners-grid-first-item-left-margin: 4px;\\n  --banners-grid-first-item-right-margin: 4px;\\n  --banners-grid-first-item-bottom-margin: 0;\\n\\n  /* Цвет фона объявления. Пример: white или #f0f2f8;\\n     Допустимо использование переменных. См. начало документа */\\n  --banner-background: var(--color-light);\\n  /* Цвет фона при наведении на объявление */\\n  --banner-background-hover: var(--color-light-alt);\\n\\n  /* Обводка объявления. Для отключения укажите значение none\\n     Пример: solid 1px rgba(0 0 0 / 15%);\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/border */\\n  --banner-stroke: none;\\n  \\n  /* Тень объявления. Пример: 0px 8px 24px rgba(0, 21, 64, 0.125);\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/box-shadow */\\n  --banner-shadow: none;\\n  /* Тень объявления при наведении */\\n  --banner-shadow-hover: none;\\n  /* Трансформация объявления при наведении. Пример: translateY(-2px); */\\n  --banner-transform-hover: none;\\n  /* Анимация изменений при наведении */\\n  --banner-transition: box-shadow 120ms ease, transform 120ms ease;\\n\\n  /* Скругление углов объявления */\\n  --banner-outer-border-radius: 8px;\\n  /* Скругление углов внутренних элементов объявления (картинка, кнопки) */\\n  --banner-inner-border-radius: 8px;\\n  \\n  /* Отступы элементов от краев объявления */\\n  --banner-padding-outer: 10px;\\n  /* Отступы между элементами объявления */\\n  --banner-padding-inner: 10px;\\n\\n\\n  /* Цвет заголовка в объявлении */\\n  --color-text-header: var(--color-black); \\n  /* Цвет текста в объявлении */\\n  --color-text-desc: var(--color-grey-alt);\\n  /* Цвет цены в объявлении */\\n  --color-text-price: var(--color-black);\\n  /* Цвет ссылки в объявлении */\\n  --color-text-domain: var(--color-blue);\\n  /* Цвет ссылки в объявлении при наведении */\\n  --color-text-domain-hover: var(--color-blue-dark);\\n  /* Фон кнопки действия. Не применимо, если кнопка \\n     не предусмотрена в шаблоне (для форматов маленького размера) */\\n  --color-background-domain: var(--color-blue-transparent);\\n  /* Фон кнопки действия при наведении */\\n  --color-background-domain-hover: var(--color-blue-dark-transparent);\\n\\n  /* Цвет названия приложения в объявления (для РМП) */\\n  --color-text-app-name: var(--color-grey-alt);\\n\\n\\n  /* Цепочка используемых шрифтов в объявлении. По умолчанию указана \\n     цепочка системных шрифтов. Если шрифт не поддерживается, используется \\n     следующий по цепочке. При использовании собственного шрифта, \\n     следует указывать его название в самом начале */\\n  --font-family: \\n    -apple-system, BlinkMacSystemFont, \\\"Segoe UI\\\", Roboto, \\n    Oxygen, Ubuntu, Cantarell, \\\"Open Sans\\\", \\\"Helvetica Neue\\\", sans-serif, \\n    Apple Color Emoji, Segoe UI Emoji;\\n\\n  /* Размер шрифта и межстрочное расстояние для коротких заголовков\\n     (до 21 символа) */\\n  --font-size-title-short: 24px;\\n  --line-height-title-short: calc(1em + 0px);\\n\\n  /* Размер шрифта и межстрочное расстояние для заголовков средней длины \\n     (от 22 до 31 символа) */\\n  --font-size-title-mid: 20px;\\n  --line-height-title-mid: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для длинных заголовков \\n     (от 32 символов) */\\n  --font-size-title-long: 20px;\\n  --line-height-title-long: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для заголовков РМП */\\n  --font-size-title-rmp: 20px;\\n  --line-height-title-rmp: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для цен */\\n  --font-size-price: 16px;\\n  --line-height-price: calc(1em + 4px);\\n\\n  /* Размер шрифта и межстрочное расстояние для текста объявления */\\n  --font-size-desc: 15px;\\n  --line-height-desc: calc(1em + 3px);\\n\\n  /* Размер шрифта и межстрочное расстояние для ссылки */\\n  --font-size-domain: 15px;\\n  --line-height-domain: 18px;\\n\\n  /* Размер шрифта и межстрочное расстояние для названия приложения \\n     (для РМП) */\\n  --font-size-app-name: 14px;\\n  --line-height-app-name: calc(1em + 2px);\\n\\n\\n  \\n\\n  width: 100%;\\n  margin: 0 auto;\\n\\n  height: auto;\\n  padding: 0;\\n  overflow: visible;\\n}\\n\\n/* Специальные переменные для Рекламы Мобильных Приложений */\\n.ya-unit-item-rmp {\\n  /* Цвет текста ссылки */\\n  --color-text-domain: var(--color-blue);\\n  /* Цвет текста ссылки при наведении */\\n  --color-text-domain-hover: var(--color-blue-dark);\\n  /* Цвет фона кнопки объявления.\\n     Не применимо если, кнопки не предусмотрено (для маленьких форматов) */\\n  --color-background-domain: var(--color-blue-transparent);\\n  /* Цвет фона кнопки объявления при наведении */\\n  --color-background-domain-hover: var(--color-blue-dark-transparent);\\n}\\n\\n/* Специальные значения для размеров экрана шире 400px */\\n@media screen and (min-width: 400px) {\\n\\n  .ya-container {\\n    --image-height: 200px;\\n\\n    --app-icon-size: 64px;\\n\\n    --font-size-title: 18px;\\n    --line-height-title: calc(1em + 2px);\\n\\n    --font-size-title-short: 28px;\\n    --line-height-title-short: calc(1em + 0px);\\n  \\n    --font-size-title-mid: 24px;\\n    --line-height-title-mid: calc(1em + 2px);\\n  \\n    --font-size-title-long: 22px;\\n    --line-height-title-long: calc(1em + 2px);\\n\\n    --font-size-price: 20px;\\n    --line-height-price: calc(1em + 0px);\\n\\n    --font-size-desc: 16px;\\n    --line-height-desc: calc(1em + 4px);\\n\\n    --font-size-app-name: 18px;\\n    --line-height-app-name: calc(1em + 2px);\\n\\n    --font-size-domain: 16px;\\n    --line-height-domain: 20px;\\n\\n    --banner-padding-outer: 12px;\\n    --banner-padding-inner: 12px;\\n  }\\n}\\n\\n\\n\\n/* -------- Далее — настройка стилей объявления. -------- */\\n/* -------- Не рекомендуется редактировать -------- */\\n\\n.ya-units-grid {\\n  margin: 0px auto;\\n}\\n\\n.grid-row {\\n  justify-content: var(--banners-justify-content);\\n  align-content: var(--banners-align-content);\\n  padding: 0px 0;\\n}\\n\\n.grid-item,\\n.ya-slider-item {\\n  width: var(--banner-width);\\n  min-width: var(--banner-min-width);\\n  max-width: var(--banner-max-width);\\n  \\n  min-height: var(--banner-min-height);\\n  max-height: var(--banner-max-height);\\n\\n  font-family: var(--font-family);\\n  background: var(--banner-background);\\n  border: var(--banner-stroke);\\n  margin: var(--banner-margin, inherit);\\n  border-radius: var(--banner-outer-border-radius);\\n  overflow: hidden;\\n  box-sizing: border-box;\\n  flex: var(--banner-flex);\\n\\n  box-shadow: var(--banner-shadow);\\n  transform: none;\\n  transition: var(--banner-transition);\\n}\\n\\n.grid-item:hover,\\n.ya-slider-item:hover {\\n  transform: var(--banner-transform-hover);\\n  box-shadow: var(--banner-shadow-hover);\\n  background: var(--banner-background-hover);\\n  --color-text-domain: var(--color-text-domain-hover);\\n}\\n\\n.grid-item:first-child,\\n.ya-slider-item:first-child {\\n  margin-left: var(--banners-grid-first-item-left-margin);\\n}\\n\\n.grid-item:last-child,\\n.ya-slider-item:last-child {\\n  margin-right: var(--banners-grid-first-item-right-margin);\\n}\\n\\n.grid-row:first-child .grid-item {\\n  margin-top: var(--banners-grid-first-item-top-margin);\\n}\\n\\n.grid-row:last-child .grid-item {\\n  margin-bottom: var(--banners-grid-first-item-bottom-margin);\\n}\\n\\n.unit-wrapper {\\n  height: 100%;\\n}\\n\\n.ya-unit-wrapper  {\\n  opacity: 0.8;\\n  transition: opacity 120ms ease;\\n}\\n\\n.ya-unit-wrapper-visible {\\n  opacity: 1.0;\\n}\\n\\n\\n\\n.ya-unit-favicon {\\n  display: block !important;\\n}\\n\\na.yrw-url {\\n  color: inherit;\\n  cursor: pointer;\\n}\\n\\n.unit-misc {\\n  position: absolute;\\n  top: 0;\\n  left: 0;\\n  width: 100%;\\n  height: 100%;\\n}\\n\\n.unit-meta {\\n  position: absolute;\\n  top: 10px;\\n  left: var(--banner-padding-outer);\\n  z-index: 2;\\n  padding: 0px 4px 0px;\\n  text-transform: uppercase;\\n  height: 12px;\\n  background: transparent;\\n  color: var(--color-grey);\\n  border-radius: 4px;\\n  font-size: 8px;\\n  line-height: 13px;\\n  font-weight: 500;\\n  letter-spacing: 0.12em;\\n  vertical-align: 5px;\\n  margin: 0;\\n  user-select: none;\\n  -ms-user-select: none;\\n  -moz-user-select: none;\\n  -khtml-user-select: none;\\n  -webkit-user-select: none;\\n}\\n\\n.ya-unit-item-rmp .unit-meta {\\n  background: transparent;\\n  /* position: relative; */\\n}\\n\\n.unit-age::before {\\n  content: \\\" | \\\";\\n}\\n\\n.unit-age:empty {\\n  display: none;\\n}\\n\\n.ya-unit-kebab_button svg circle {\\n  fill: var(--color-grey);\\n}\\n\\n.ya-unit-kebab_bg {\\n  background: transparent;\\n  opacity: 1.0;\\n}\\n\\n.ya-unit-kebab_icon {\\n  filter: var(--display-image, none);\\n}\\n\\n.ya-unit-kebab_icon circle {\\n  fill: var(--color-grey) !important;\\n}\\n\\n.ya-unit-kebab_button {\\n  position: absolute;\\n  z-index: 940;\\n  top: 4px;\\n  right: 4px;\\n  width: 24px;\\n  height: 24px;\\n}\\n\\n.yrw-body_warning {\\n  position: relative;\\n}\\n\\n.yrw-body_warning div {\\n  padding: 0;\\n}\\n\\n.yrw-body_warning div:not(.yrw-warning-wrapper):not(.yrw-warning-text) {\\n  position: relative;\\n  background-color: var(--color-light-alt);\\n  color: #575c66;\\n  display: flex;\\n  padding: 0 calc(var(--inner-border-radius) / 2);\\n}\\n\\n.yrw-body_warning div text {\\n  fill: #575c66;\\n}\\n\\n.yrw-body_warning div:not(.yrw-warning-wrapper) {\\n  padding: 0 calc(var(--inner-border-radius) / 2 + 4px);\\n}\\n\\n.yrw-warning-text {\\n  text-shadow: none;\\n}\\n\\n\\n\\n.unit-container {\\n  box-sizing: border-box;\\n  position: relative;\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: flex-end;\\n  overflow: hidden;\\n  max-width: var(--max-content-width, --banner-max-width, 960px);\\n  margin: auto;\\n}\\n\\n.unit-content {\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: flex-start;\\n  position: relative;\\n  height: 100%;\\n  padding: 8px;\\n  padding: var(--banner-padding-outer);\\n  padding-top: 32px;\\n}\\n\\n.unit-text-content {\\n  display: flex;\\n  justify-content: flex-start;\\n  flex-direction: column;\\n  position: relative;\\n  flex: auto;\\n}\\n\\n.rmp-app-content {\\n  display: flex;\\n  flex-direction: row;\\n}\\n\\n.rmp-text-content {\\n  display: flex;\\n  justify-content: center;\\n  flex-direction: column;\\n}\\n\\n.unit-text-content > div {\\n  margin-top: var(--banner-padding-inner);\\n}\\n\\n.rmp-text-content > div {\\n  margin-top: calc(var(--banner-padding-inner) / 2);\\n}\\n\\n.rmp-text-content > div:first-child {\\n  margin-top: 0;\\n}\\n\\n\\n\\n.ya-unit-title, .unit-title {\\n  color: var(--color-text-header);\\n  font-size: var(--font-size-title);\\n  line-height: var(--line-height-title);\\n  font-weight: 600;\\n  display: flex;\\n}\\n\\n.title-short {\\n  font-size: var(--font-size-title-short);\\n  line-height: var(--line-height-title-short);\\n}\\n\\n.title-mid {\\n  font-size: var(--font-size-title-mid);\\n  line-height: var(--line-height-title-mid);\\n}\\n\\n.title-long {\\n  font-size: var(--font-size-title-long);\\n  line-height: var(--line-height-title-long);\\n}\\n\\n.title-rmp {\\n  font-size: var(--font-size-title-rmp);\\n  line-height: var(--line-height-title-rmp);\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: center;\\n}\\n\\n.unit-app-name {\\n  font-size: var(--font-size-app-name);\\n  line-height: var(--line-height-app-name);\\n  color: var(--color-text-app-name);\\n}\\n\\n.unit-cta {\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: center;\\n  box-sizing: border-box;\\n  padding: 12px;\\n\\n  font-size: var(--domain-font-size);\\n  line-height: var(--domain-line-height);\\n  text-align: center;\\n\\n  color: var(--color-cta-color);\\n  background-color: var(--color-background-domain);\\n  border-radius: var(--banner-inner-border-radius);\\n\\n  margin-top: var(--banner-padding-inner);\\n\\n  transition: var(--cta-transition);\\n}\\n\\n.unit-cta:hover {\\n  color: var(--color-cta-hover-color);\\n  background-color: var(--color-background-domain-hover);\\n}\\n\\n.unit-favicon {\\n  width: var(--line-height-domain);\\n  background-color: transparent;\\n  border-radius: 3px;\\n  align-self: center;\\n  display: var(--display-favicon, inline);\\n}\\n\\n.ya-unit-favicon {\\n  width: var(--line-height-domain);\\n  height: var(--line-height-domain);\\n}\\n\\n.ya-unit-rating {\\n  margin-right: 4px;\\n  height: 16px;\\n  display: inline;\\n}\\n\\n.ya-unit-review-count {\\n  display: var(--display-rmp-rating-count);\\n  transform: translateY(1px);\\n  color: var(--color-grey-alt);\\n  font-size: 13px;\\n  line-height: 16px;\\n}\\n\\n.unit-favicon:empty,\\n.ya-unit-domain:empty,\\n.unit-domain:empty {\\n  display: none;\\n}\\n\\n.unit-domain {\\n  display: flex;\\n  margin-right: auto;\\n  border-radius: 4px;\\n  color: var(--color-text-domain);\\n  font-size: var(--font-size-domain);\\n  line-height: var(--line-height-domain);\\n  \\n  padding: 0;\\n  width: 100%;\\n  height: var(--line-height-domain, 16px);\\n  flex-direction: row;\\n  flex-wrap: wrap;\\n  justify-content: center;\\n  align-content: flex-end;\\n  overflow: hidden;\\n}\\n\\n.unit-domain > *,\\n.unit-domain .unit-domain-no-wrap > * {\\n  margin-right: calc(var(--line-height-domain) / 3.5);\\n}\\n\\n.unit-domain span {\\n  flex: none;\\n}\\n\\n.unit-domain-no-wrap {\\n  display: flex;\\n}\\n\\n\\n\\n.unit-app-rating {\\n  display: flex;\\n  flex-direction: row;\\n  align-content: center;\\n}\\n\\n.unit-prices {\\n  display: var(--display-price, inline);\\n  white-space: nowrap;\\n  font-size: var(--font-size-price);\\n  line-height: var(--line-height-price);\\n}\\n\\n.ya-unit-price {\\n  color: var(--color-text-price);\\n  font-weight: 600;\\n  display: inline;\\n  white-space: nowrap;\\n}\\n\\n.ya-unit-old-price {\\n  margin-left: 8px;\\n  font-size: max(0.9em, 12px);\\n  line-height: max(0.9em, 12px);\\n\\n  color: var(--color-grey-alt);\\n  position: relative;\\n  white-space: nowrap;\\n  display: inline;\\n}\\n\\n.ya-unit-old-price::after {\\n  content: \\\"\\\";\\n  position: absolute;\\n  bottom: 0;\\n  left: 0;\\n  width: 100%;\\n  height: 100%;\\n\\n  background-image: url(\\\"data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='100%' height='100%'><line class='line' x1='0' y1='65%' x2='100%' y2='50%' stroke='%23A3ACBF' stroke-width='8vh' /></svg>\\\");\\n  background-repeat: no-repeat;\\n}\\n\\n.unit-desc {\\n  display: var(--display-desc);\\n  color: var(--color-text-desc);\\n  font-size: var(--font-size-desc);\\n  line-height: var(--line-height-desc);\\n}\\n\\n\\n\\n.unit-image-block {\\n  display: var(--display-image);\\n  width: 100%;\\n  max-width: var(--image-max-width, none);\\n  height: var(--image-height);\\n  flex: none;\\n  border-radius: var(--banner-inner-border-radius);\\n  position: relative;\\n  box-sizing: border-box;\\n  background-color: var(--color-light-alt);\\n  overflow: hidden;\\n}\\n\\n.unit-image {\\n  width: 100%;\\n  height: 100%;\\n  display: var(--display-image);\\n  position: relative;\\n}\\n\\n.video-source-container {\\n  border-radius: var(--banner-inner-border-radius, 8px);\\n  z-index: 1;\\n  overflow: hidden;\\n}\\n\\n.ya-unit-app-icon {\\n  position: relative;\\n  border-radius: calc(var(--app-icon-size) / 4);\\n  margin-right: var(--banner-padding-inner);\\n  display: flex;\\n}\\n\\n.unit-app-icon {\\n  margin: auto;\\n}\\n\\n.ya-unit-app-icon .yrw-img-component {\\n  width: var(--app-icon-size);\\n  height: var(--app-icon-size);\\n}\\n\\n.ya-unit-image {\\n  height: 100%;\\n}\\n\\n.yrw-img-component {\\n  height: 100%;\\n  padding-bottom: 0;\\n}\\n\\n.unit-image .img-source-component {\\n  border-radius: var(--banner-inner-border-radius);\\n  background-image: url(\\\"data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='256' height='256'><rect x='80' y='80' width='96' height='96' rx='19.2' fill='%23405580' fill-opacity='0.15'/><path d='M144.619 110.181H147.619C147.619 108.524 146.276 107.181 144.619 107.181V110.181ZM111.102 147.94L146.74 112.302L142.498 108.06L106.86 143.698L111.102 147.94ZM114.072 113.181H144.619V107.181L114.072 107.181V113.181ZM141.619 110.181V140.728H147.619V110.181L141.619 110.181Z' fill='white'/></svg>\\\");\\n  background-position: center;\\n}\\n\\n.ya-unit-app-icon .img-source-component {\\n  border-radius: calc(var(--app-icon-size) / 4 - 4px);\\n}\\n\\n.ya-clamp {\\n  width: 100%;\\n}\\n\\n.yrw-content {\\n  overflow: visible;\\n}\\n\\n.ya-grid-template:empty {\\n  display: none;\\n}\",\"gridColumns\":\"4\",\"gridRows\":\"1\",\"defaultHeight\":\"450\",\"defaultWidth\":\"750\"},{\"value\":\"11\",\"label\":\"Desktop single 100% x 250px\",\"template\":\"<ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n\\n  <div class=\\\"unit-misc\\\">\\n    <ya-unit-kebab class=\\\"ya-unit-kebab_dark\\\" />\\n  </div>\\n\\n  <div class=\\\"unit-content\\\">\\n    <div class=\\\"unit-image-block\\\">\\n      <ya-unit-image/>\\n    </div>\\n\\n    <div class=\\\"unit-text-content\\\" data-cols=\\\"1\\\" data-rows=\\\"1\\\">\\n\\n      <div class=\\\"unit-meta\\\">\\n        <ya-unit-category class=\\\"unit-category\\\" />\\n        <ya-unit-age class=\\\"unit-age\\\" />\\n      </div>\\n\\n      <div class=\\\"unit-title\\\">\\n        <ya-unit-if condition=\\\"unit.title < 22\\\">\\n          <ya-clamp lines=\\\"3\\\" class=\\\"title-short\\\"><ya-unit-title /></ya-clamp>\\n        </ya-unit-if>\\n\\n        <ya-unit-if condition=\\\"unit.title > 21 & unit.title < 33\\\">\\n          <ya-clamp lines=\\\"3\\\" class=\\\"title-mid\\\"><ya-unit-title /></ya-clamp>\\n        </ya-unit-if>\\n\\n        <ya-unit-if condition=\\\"unit.title > 32\\\">\\n          <ya-clamp lines=\\\"3\\\" class=\\\"title-long\\\"><ya-unit-title /></ya-clamp>\\n        </ya-unit-if>\\n      </div>\\n\\n      <!-- Начало Шаблона ТГО -->\\n      <ya-unit-if condition=\\\"!unit.isRmp\\\">\\n        <div class=\\\"unit-prices\\\"><ya-unit-price /><ya-unit-old-price /></div>  \\n        <ya-clamp lines=\\\"2\\\" class=\\\"unit-desc\\\"><ya-unit-desc /></ya-clamp>\\n      </ya-unit-if>\\n      <!-- Конец Шаблона ТГО -->\\n\\n\\n    \\n      <!-- Начало Шаблона РМП -->\\n      <ya-unit-if condition=\\\"unit.isRmp\\\">\\n        \\n        <div class=\\\"rmp-app-content\\\">\\n          <ya-unit-app-icon />\\n\\n          <div class=\\\"rmp-text-content\\\">\\n            <div class=\\\"unit-app-name\\\">\\n              <ya-clamp lines=\\\"2\\\">\\n                <ya-unit-app-name />\\n              </ya-clamp>\\n            </div>\\n\\n            <div class=\\\"unit-app-rating\\\">\\n              <ya-unit-rating />\\n              <ya-unit-review-count />\\n            </div>\\n          </div>\\n        </div>\\n\\n      </ya-unit-if>\\n      <!-- Конец Шаблона РМП -->\\n\\n      <div class=\\\"unit-cta\\\">\\n        <div class=\\\"unit-domain\\\">\\n          <ya-unit-mobile-app-button />\\n          <ya-unit-if condition=\\\"!unit.isRmp\\\">\\n            <span class=\\\"unit-domain-no-wrap\\\">\\n              <span class=\\\"unit-favicon\\\"><ya-unit-favicon size=\\\"32\\\"/></span>\\n              <ya-unit-domain class=\\\"domain\\\"/>\\n            </span>\\n          </ya-unit-if>\\n          \\n        </div>\\n      </div>\\n    </div>\\n  </div>\\n</ya-units-grid>\",\"css\":\"/* Шаблон 4: Десктопный сингл размером 100% x 250px\\n   Для использования в шапке сайта */\\n\\n/* Шаблоны не работают в браузерах IE 11 версии и ниже */\\n\\n/* РМП — Реклама Мобильных Приложений */\\n\\n\\n/* -------- Переменные цветов -------- */\\n/* изменив значение цвета тут — изменится во всех элементах шаблона */\\n.ya-container {\\n\\n  --color-blue: #3377FF;\\n  --color-blue-dark: #0055FF;\\n\\n  --color-blue-transparent: #3377FF1A;\\n  --color-blue-dark-transparent: #0055FF1A;\\n\\n\\n  --color-black: #232526;\\n  --color-grey: #575c66;\\n  --color-grey-alt: #A3ACBF;\\n  --color-light: #f4f4f6;\\n  --color-light-alt: #ececef;\\n}\\n\\n/* Переменные цветов для устройств с поддержкой \\n   цветового профиля Display P3 (устройства Apple) */\\n\\n/* Устройства Apple поддерживают цветовой профиль \\n   с более яркими цветами (цветовой профиль Display P3). \\n   Если вы хотите поддержать его, то следует поменять \\n   значения цветов в блоке ниже */\\n@supports (color: color(display-p3)) {\\n  .ya-container {\\n    --color-blue: color(display-p3 0.2 0.47 1.0);\\n    --color-blue-dark: color(display-p3 0.0 0.33 1.0);\\n\\n    --color-blue-transparent: color(display-p3 0.2 0.47 1.0 / 0.1);\\n    --color-blue-dark-transparent: color(display-p3 0.0 0.33 1.0 / 0.1);\\n\\n    --color-yellow: color(display-p3 1.0 0.8 0.2);\\n    --color-yellow-dark: color(display-p3 1.0 0.75 0.0);\\n  }\\n}\\n\\n\\n\\n/* -------- Переменные для отрисовки объявления -------- */\\n\\n.ya-container {\\n\\n  /* Адаптивность объявления по ширине.\\n     Укажите значение none, чтобы зафиксировать размер объявления.\\n     Укажите auto, чтобы объявление занимало всю доступную ширину */\\n  --banner-flex: auto;\\n\\n  /* Фиксированная ширина объявления.\\n     Работает при --banner-flex: none */\\n  --banner-width: 300px;\\n\\n  /* Минимальная и максимальная ширина объявления.\\n     Работает при --banner-flex: auto */\\n  --banner-min-width: 540px;\\n  --banner-max-width: 100%;\\n\\n  /* Минимальная и максимальная высота объявления.\\n     Объявление будет растягиваться по высоте \\n     в зависимости от количества контента */\\n  --banner-min-height: 250px;\\n  --banner-max-height: 250px;\\n\\n\\n  /* Отображение фавиконки: \\n     вкл - block, выкл - none; */\\n  --display-favicon: block;\\n  /* Отображение изображения: \\n     вкл - block, выкл - none; */\\n  --display-image: block;\\n  /* Отображение текста: \\n     вкл - block, выкл - none; */\\n  --display-desc: inline;\\n  /* Отображение цен: \\n     вкл - inline, выкл - none */\\n  --display-price: inline;\\n  /* Отображение количества отзывов (для РМП): \\n     вкл - inline, выкл - none */\\n  --display-rmp-rating-count: inline;\\n\\n\\n  /* Ширина картинки */\\n  --image-width: 50%;\\n\\n  /* Максимальная ширина (в случае очень широких баннеров) */\\n  --image-max-width: 400px;\\n\\n  /* Высота картинки */\\n  --image-height: 100%;\\n\\n  /* Размер иконки приложения.\\n     Только для рекламы мобильных приложений */\\n  --app-icon-size: 48px;\\n\\n  /* Максимальная ширина контента */\\n  --max-content-width: 960px;\\n\\n  /* Горизонтальное позиционирование сетки баннеров\\n     center - по середине, flex-start - слева,\\n     space-between - по всей ширине, space-around - по всей ширине с отступами\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/justify-content */\\n  --banners-justify-content: center;\\n\\n  /* Отступы вокруг объявления */\\n  --banner-margin: 8px 0;\\n  \\n  /* Отступы первых и последних объявлений от края \\n     по горизонтали и вертикали. Значение var(--banner-margin) \\n     повторяет общее значение отступов. \\n     ! Неприменимо для одиночных объявлений */\\n  --banners-grid-first-item-top-margin: 0;\\n  --banners-grid-first-item-left-margin: 0;\\n  --banners-grid-first-item-right-margin: 0;\\n  --banners-grid-first-item-bottom-margin: 0;\\n\\n  /* Цвет фона объявления. Пример: white или #f0f2f8;\\n     Допустимо использование переменных. См. начало документа */\\n  --banner-background: white;\\n  /* Цвет фона объявления при наведении */\\n  --banner-background-hover: var(--color-light);\\n\\n  /* Обводка объявления. Для отключения укажите значение none\\n     Пример: solid 1px rgba(0 0 0 / 15%);\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/border */\\n  --banner-stroke: solid 1px rgba(0 8 32 / 10%);\\n  \\n  /* Тень объявления. Пример: 0px 8px 24px rgba(0, 21, 64, 0.125);\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/box-shadow */\\n  --banner-shadow: none;\\n  /* Тень объявления при наведении */\\n  --banner-shadow-hover: none;\\n/* Трансформация объявления при наведении. Пример: translateY(-2px); */\\n  --banner-transform-hover: none;\\n  /* Анимация изменений при наведении */\\n  --banner-transition: box-shadow 120ms ease, transform 120ms ease;\\n\\n  /* Скругление углов объявления */\\n  --banner-outer-border-radius: 0px;\\n  /* Скругление углов внутренних элементов объявления (картинка, кнопки) */\\n  --banner-inner-border-radius: 8px;\\n  \\n  /* Отступы элементов от краев объявления */\\n  --banner-padding-outer: 15px;\\n  /* Отступы между элементами объявления */\\n  --banner-padding-inner: 10px;\\n\\n\\n  /* Цвет заголовка в объявлении */\\n  --color-text-header: var(--color-black); \\n  /* Цвет текста в объявлении */\\n  --color-text-desc: var(--color-grey-alt);\\n  /* Цвет цены в объявлении */\\n  --color-text-price: var(--color-black);\\n  /* Цвет ссылки в объявлении */\\n  --color-text-domain: var(--color-blue);\\n  /* Цвет ссылки в объявлении при наведении */\\n  --color-text-domain-hover: var(--color-blue-dark);\\n  /* Фон кнопки действия. Не применимо, если кнопка \\n     не предусмотрена в шаблоне (для форматов маленького размера) */\\n  --color-background-domain: var(--color-blue-transparent);\\n  /* Фон кнопки действия при наведении */\\n  --color-background-domain-hover: var(--color-blue-dark-transparent);\\n\\n  /* Цвет названия приложения в объявления (для РМП) */\\n  --color-text-app-name: var(--color-grey-alt);\\n\\n\\n  /* Цепочка используемых шрифтов в объявлении. По умолчанию указана \\n     цепочка системных шрифтов. Если шрифт не поддерживается, используется \\n     следующий по цепочке. При использовании собственного шрифта, \\n     следует указывать его название в самом начале */\\n  --font-family: \\n    -apple-system, BlinkMacSystemFont, \\\"Segoe UI\\\", Roboto, \\n    Oxygen, Ubuntu, Cantarell, \\\"Open Sans\\\", \\\"Helvetica Neue\\\", sans-serif, \\n    Apple Color Emoji, Segoe UI Emoji;\\n\\n  /* Размер шрифта и межстрочное расстояние для коротких заголовков\\n     (до 21 символа) */\\n  --font-size-title-short: 32px;\\n  --line-height-title-short: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для заголовков средней длины \\n     (от 22 до 31 символа) */\\n  --font-size-title-mid: 28px;\\n  --line-height-title-mid: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для длинных заголовков \\n     (от 32 символов) */\\n  --font-size-title-long: 24px;\\n  --line-height-title-long: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для заголовков РМП */\\n  --font-size-title-rmp: 20px;\\n  --line-height-title-rmp: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для цен */\\n  --font-size-price: 18px;\\n  --line-height-price: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для текста объявления */\\n  --font-size-desc: 16px;\\n  --line-height-desc: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для ссылки */\\n  --font-size-domain: 15px;\\n  --line-height-domain: 20px;\\n\\n  /* Размер шрифта и межстрочное расстояние для названия приложения \\n     (для РМП) */\\n  --font-size-app-name: 15px;\\n  --line-height-app-name: 16px;\\n\\n  \\n\\n  width: 100%;\\n  margin: 0 auto;\\n\\n  height: auto;\\n  padding: 0;\\n  overflow: visible;\\n}\\n\\n/* Специальные переменные для Рекламы Мобильных Приложений */\\n.ya-unit-item-rmp {\\n  /* Цвет текста ссылки */\\n  --color-text-domain: var(--color-blue);\\n  /* Цвет текста ссылки при наведении */\\n  --color-text-domain-hover: var(--color-blue-dark);\\n  /* Цвет фона кнопки объявления.\\n     Не применимо если, кнопки не предусмотрено (для маленьких форматов) */\\n  --color-background-domain: var(--color-blue-transparent);\\n  /* Цвет фона кнопки объявления при наведении */\\n  --color-background-domain-hover: var(--color-blue-dark-transparent);\\n}\\n\\n/* Специальные значения для размеров экрана шире 480px */\\n@media screen and (min-width: 800px) {\\n  .ya-container {\\n\\n    --font-size-price: 20px;\\n    --line-height-price: calc(1em + 4px);\\n  \\n    --font-size-desc: 20px;\\n    --line-height-desc: calc(1em + 4px);\\n\\n    --app-icon-size: 64px;\\n  }\\n}\\n\\n\\n\\n\\n/* -------- Далее — настройка стилей объявления. -------- */\\n/* -------- Не рекомендуется редактировать -------- */\\n\\n.ya-units-grid {\\n  margin: 0px auto;\\n}\\n\\n.grid-row {\\n  justify-content: var(--banners-justify-content);\\n  align-content: var(--banners-align-content);\\n  padding: 0px 0;\\n}\\n\\n.grid-item {\\n  width: var(--banner-width);\\n  min-width: var(--banner-min-width);\\n  max-width: var(--banner-max-width);\\n  \\n  min-height: var(--banner-min-height);\\n  max-height: var(--banner-max-height);\\n\\n  font-family: var(--font-family);\\n  background: var(--banner-background);\\n  border: var(--banner-stroke);\\n  margin: var(--banner-margin, inherit);\\n  border-radius: var(--banner-outer-border-radius);\\n  overflow: hidden;\\n  box-sizing: border-box;\\n  flex: var(--banner-flex);\\n  box-shadow: var(--banner-shadow);\\n  transform: none;\\n  transition: var(--banner-transition);\\n}\\n\\n.grid-item:hover {\\n  transform: var(--banner-transform-hover);\\n  box-shadow: var(--banner-shadow-hover);\\n  background: var(--banner-background-hover);\\n  --color-text-domain: var(--color-text-domain-hover);\\n}\\n\\n.grid-item:first-child {\\n  margin-left: var(--banners-grid-first-item-left-margin);\\n}\\n\\n.grid-item:last-child {\\n  margin-right: var(--banners-grid-first-item-right-margin);\\n}\\n\\n.grid-row:first-child .grid-item {\\n  margin-top: var(--banners-grid-first-item-top-margin);\\n}\\n\\n.grid-row:last-child .grid-item {\\n  margin-bottom: var(--banners-grid-first-item-bottom-margin);\\n}\\n\\n.unit-wrapper {\\n  height: 100%;\\n  max-width: var(--max-content-width, --banner-max-width, 960px);\\n}\\n\\n.ya-unit-favicon {\\n  display: block !important;\\n}\\n\\na.yrw-url {\\n  color: inherit;\\n  cursor: pointer;\\n}\\n\\n.unit-misc {\\n  position: absolute;\\n  top: 0;\\n  left: 0;\\n  width: 100%;\\n  height: 100%;\\n}\\n\\n.unit-meta {\\n  position: relative;\\n  z-index: 2;\\n  padding: 0px 0px 0px;\\n  text-transform: uppercase;\\n  height: 12px;\\n  background: transparent;\\n  color: var(--color-grey);\\n  border-radius: 4px;\\n  font-size: 8px;\\n  line-height: 13px;\\n  font-weight: 500;\\n  letter-spacing: 0.12em;\\n  vertical-align: 5px;\\n  margin: 0;\\n  user-select: none;\\n  -ms-user-select: none;\\n  -moz-user-select: none;\\n  -khtml-user-select: none;\\n  -webkit-user-select: none;\\n}\\n\\n.ya-unit-item-rmp .unit-meta {\\n  background: transparent;\\n}\\n\\n.unit-age::before {\\n  content: \\\" | \\\";\\n}\\n\\n.unit-age:empty {\\n  display: none;\\n}\\n\\n.ya-unit-kebab_button svg circle {\\n  fill: var(--color-grey);\\n}\\n\\n.ya-unit-kebab_bg {\\n  background: transparent;\\n  opacity: 1.0;\\n}\\n\\n.ya-unit-kebab_icon {\\n  filter: var(--display-image, none);\\n}\\n\\n.ya-unit-kebab_icon circle {\\n  fill: var(--color-grey) !important;\\n}\\n\\n.ya-unit-kebab_button {\\n  position: absolute;\\n  z-index: 940;\\n  top: 4px;\\n  right: 4px;\\n  width: 24px;\\n  height: 24px;\\n}\\n\\n.yrw-body_warning {\\n  position: relative;\\n}\\n\\n.yrw-body_warning div {\\n  padding: 0;\\n}\\n\\n.yrw-body_warning div:not(.yrw-warning-wrapper):not(.yrw-warning-text) {\\n  position: relative;\\n  background-color: var(--color-light-alt);\\n  color: #575c66;\\n  display: flex;\\n  padding: 0 calc(var(--inner-border-radius) / 2);\\n}\\n\\n.yrw-body_warning div text {\\n  fill: #575c66;\\n}\\n\\n.yrw-body_warning div:not(.yrw-warning-wrapper) {\\n  padding: 0 calc(var(--inner-border-radius) / 2 + 4px);\\n}\\n\\n.yrw-warning-text {\\n  text-shadow: none;\\n}\\n\\n\\n\\n.unit-container {\\n  box-sizing: border-box;\\n  position: relative;\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: flex-end;\\n  overflow: hidden;\\n  margin: auto;\\n}\\n\\n.unit-content {\\n  display: flex;\\n  flex-direction: row;\\n  justify-content: flex-start;\\n  position: relative;\\n  height: 100%;\\n  padding: 8px;\\n  padding: var(--banner-padding-outer);\\n}\\n\\n.unit-text-content {\\n  display: flex;\\n  justify-content: flex-start;\\n  flex-direction: column;\\n  position: relative;\\n  flex: auto;\\n  padding-left: var(--banner-padding-outer);\\n}\\n\\n.rmp-app-content {\\n  display: flex;\\n  flex-direction: row;\\n}\\n\\n.rmp-text-content {\\n  display: flex;\\n  justify-content: center;\\n  flex-direction: column;\\n}\\n\\n.unit-text-content > div {\\n  margin-top: var(--banner-padding-inner);\\n}\\n\\n.rmp-text-content > div {\\n  margin-top: calc(var(--banner-padding-inner) / 2);\\n}\\n\\n.unit-text-content > *:first-child,\\n.rmp-text-content > *:first-child {\\n  margin-top: 0;\\n}\\n\\n\\n\\n.ya-unit-title, .unit-title {\\n  color: var(--color-text-header);\\n  font-size: var(--font-size-title);\\n  line-height: var(--line-height-title);\\n  font-weight: 600;\\n  display: flex;\\n}\\n\\n.title-short {\\n  font-size: var(--font-size-title-short);\\n  line-height: var(--line-height-title-short);\\n}\\n\\n.title-mid {\\n  font-size: var(--font-size-title-mid);\\n  line-height: var(--line-height-title-mid);\\n}\\n\\n.title-long {\\n  font-size: var(--font-size-title-long);\\n  line-height: var(--line-height-title-long);\\n}\\n\\n.title-rmp {\\n  font-size: var(--font-size-title-rmp);\\n  line-height: var(--line-height-title-rmp);\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: center;\\n}\\n\\n.unit-app-name {\\n  font-size: var(--font-size-app-name);\\n  line-height: var(--line-height-app-name);\\n  color: var(--color-text-app-name);\\n}\\n\\n.unit-cta {\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: center;\\n  box-sizing: border-box;\\n  padding: 12px;\\n\\n  font-size: var(--domain-font-size);\\n  line-height: var(--domain-line-height);\\n  text-align: center;\\n  color: var(--color-cta-color);\\n  background-color: var(--color-background-domain);\\n  border-radius: var(--banner-inner-border-radius);\\n  margin-top: auto !important;\\n  transition: var(--cta-transition);\\n}\\n\\n.unit-cta:hover {\\n  color: var(--color-cta-hover-color);\\n  background-color: var(--color-background-domain-hover);\\n}\\n\\n.unit-favicon {\\n  width: var(--line-height-domain);\\n  background-color: transparent;\\n  border-radius: 3px;\\n  align-self: center;\\n  display: var(--display-favicon, inline);\\n}\\n\\n.ya-unit-favicon {\\n  width: var(--line-height-domain);\\n  height: var(--line-height-domain);\\n}\\n\\n.ya-unit-rating {\\n  margin-right: 4px;\\n  height: 16px;\\n  display: inline;\\n}\\n\\n.ya-unit-review-count {\\n  display: var(--display-rmp-rating-count);\\n  transform: translateY(1px);\\n  color: var(--color-grey-alt);\\n  font-size: 13px;\\n  line-height: 16px;\\n}\\n\\n.unit-favicon:empty,\\n.ya-unit-domain:empty,\\n.unit-domain:empty {\\n  display: none;\\n}\\n\\n.unit-domain {\\n  display: flex;\\n  margin-right: auto;\\n  border-radius: 4px;\\n  color: var(--color-text-domain);\\n  font-size: var(--font-size-domain);\\n  line-height: var(--line-height-domain);\\n  \\n  padding: 0;\\n  width: 100%;\\n  height: var(--line-height-domain, 16px);\\n  flex-direction: row;\\n  flex-wrap: wrap;\\n  justify-content: center;\\n  align-content: flex-end;\\n  overflow: hidden;\\n}\\n\\n.unit-domain > *,\\n.unit-domain .unit-domain-no-wrap > * {\\n  margin-right: calc(var(--line-height-domain) / 3.5);\\n}\\n\\n.unit-domain span {\\n  flex: none;\\n}\\n\\n.unit-domain-no-wrap {\\n  display: flex;\\n}\\n\\n\\n\\n.unit-app-rating {\\n  display: flex;\\n  flex-direction: row;\\n  align-content: center;\\n}\\n\\n.unit-prices {\\n  display: var(--display-price, inline);\\n  white-space: nowrap;\\n  font-size: var(--font-size-price);\\n  line-height: var(--line-height-price);\\n}\\n\\n.ya-unit-price {\\n  color: var(--color-text-price);\\n  font-weight: 600;\\n  display: inline;\\n  white-space: nowrap;\\n}\\n\\n.ya-unit-old-price {\\n  margin-left: 8px;\\n  font-size: max(0.9em, 12px);\\n  line-height: max(0.9em, 12px);\\n  color: var(--color-grey-alt);\\n  position: relative;\\n  white-space: nowrap;\\n  display: inline;\\n}\\n\\n.ya-unit-old-price::after {\\n  content: \\\"\\\";\\n  position: absolute;\\n  bottom: 0;\\n  left: 0;\\n  width: 100%;\\n  height: 100%;\\n  \\n  background-image: url(\\\"data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='100%' height='100%'><line class='line' x1='0' y1='65%' x2='100%' y2='50%' stroke='%23A3ACBF' stroke-width='8vh' /></svg>\\\");\\n  background-repeat: no-repeat;\\n}\\n\\n.unit-desc {\\n  display: var(--display-desc);\\n  color: var(--color-text-desc);\\n  font-size: var(--font-size-desc);\\n  line-height: var(--line-height-desc);\\n}\\n\\n\\n\\n.unit-image-block {\\n  display: var(--display-image);\\n  width: var(--image-width);\\n  max-width: var(--image-max-width, none);\\n  height: var(--image-height);\\n  flex: none;\\n  border-radius: var(--banner-inner-border-radius);\\n  position: relative;\\n  box-sizing: border-box;\\n  background-color: var(--color-light-alt);\\n  overflow: hidden;\\n}\\n\\n.unit-image {\\n  width: 100%;\\n  height: 100%;\\n  display: var(--display-image);\\n  position: relative;\\n}\\n\\n.video-source-container {\\n  border-radius: var(--banner-inner-border-radius, 8px);\\n  z-index: 1;\\n  overflow: hidden;\\n}\\n\\n.ya-unit-app-icon {\\n  position: relative;\\n  border-radius: calc(var(--app-icon-size) / 4);\\n  margin-right: var(--banner-padding-inner);\\n  display: flex;\\n}\\n\\n.unit-app-icon {\\n  margin: auto;\\n}\\n\\n.ya-unit-app-icon .yrw-img-component {\\n  width: var(--app-icon-size);\\n  height: var(--app-icon-size);\\n}\\n\\n.ya-unit-image {\\n  height: 100%;\\n}\\n\\n.yrw-img-component {\\n  height: 100%;\\n  padding-bottom: 0;\\n}\\n\\n.unit-image .img-source-component {\\n  border-radius: var(--banner-inner-border-radius);\\n  background-image: url(\\\"data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='256' height='256'><rect x='80' y='80' width='96' height='96' rx='19.2' fill='%23405580' fill-opacity='0.15'/><path d='M144.619 110.181H147.619C147.619 108.524 146.276 107.181 144.619 107.181V110.181ZM111.102 147.94L146.74 112.302L142.498 108.06L106.86 143.698L111.102 147.94ZM114.072 113.181H144.619V107.181L114.072 107.181V113.181ZM141.619 110.181V140.728H147.619V110.181L141.619 110.181Z' fill='white'/></svg>\\\");\\n  background-position: center;\\n}\\n\\n.ya-unit-app-icon .img-source-component {\\n  border-radius: calc(var(--app-icon-size) / 4 - 4px);\\n}\\n\\n.ya-clamp {\\n  width: 100%;\\n}\\n\\n.yrw-content {\\n  overflow: visible;\\n}\\n\\n.ya-grid-template:empty {\\n  display: none;\\n}\",\"gridColumns\":\"1\",\"gridRows\":\"1\",\"defaultHeight\":\"260\",\"props\":{}},{\"value\":\"7\",\"label\":\"Desktop grid 3x1 100% x 300px\",\"template\":\"<ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n\\n  <div class=\\\"unit-misc\\\">\\n    <ya-unit-kebab class=\\\"ya-unit-kebab_dark\\\" />\\n    <div class=\\\"unit-meta\\\">\\n      <ya-unit-category class=\\\"unit-category\\\" />\\n      <ya-unit-age class=\\\"unit-age\\\" />\\n    </div>\\n  </div>\\n\\n  <div class=\\\"unit-content\\\">\\n    <div class=\\\"unit-image-block\\\">\\n      <ya-unit-image/>\\n    </div>\\n\\n    <div class=\\\"unit-text-content\\\" cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n\\n      <!-- Начало Шаблона ТГО -->\\n      <ya-unit-if condition=\\\"!unit.isRmp\\\">\\n\\n        <div class=\\\"unit-title\\\">\\n          <ya-unit-if condition=\\\"unit.title < 22\\\">\\n            <ya-clamp lines=\\\"3\\\" class=\\\"title-short\\\"><ya-unit-title /></ya-clamp>\\n          </ya-unit-if>\\n\\n          <ya-unit-if condition=\\\"unit.title > 21 & unit.title < 33\\\">\\n            <ya-clamp lines=\\\"3\\\" class=\\\"title-mid\\\"><ya-unit-title /></ya-clamp>\\n          </ya-unit-if>\\n\\n          <ya-unit-if condition=\\\"unit.title > 32\\\">\\n            <ya-clamp lines=\\\"3\\\" class=\\\"title-long\\\"><ya-unit-title /></ya-clamp>\\n          </ya-unit-if>\\n        </div>\\n\\n        <div class=\\\"unit-prices\\\"><ya-unit-price /><ya-unit-old-price /></div>\\n  \\n        <ya-clamp lines=\\\"2\\\" class=\\\"unit-desc\\\"><ya-unit-desc /></ya-clamp>\\n\\n\\n      </ya-unit-if>\\n      <!-- Конец Шаблона ТГО -->\\n\\n    \\n      <!-- Начало Шаблона РМП -->\\n      <ya-unit-if condition=\\\"unit.isRmp\\\">\\n        <div class=\\\"unit-title\\\">\\n          <span class=\\\"title-rmp\\\">\\n            <ya-clamp lines=\\\"2\\\"><ya-unit-title /></ya-clamp>\\n          </span>\\n        </div>\\n\\n        <div class=\\\"rmp-app-content\\\">\\n          <ya-unit-app-icon />\\n          <div class=\\\"rmp-text-content\\\">\\n\\n            <div class=\\\"unit-app-name\\\">\\n              <ya-clamp lines=\\\"1\\\">\\n                <ya-unit-app-name />\\n              </ya-clamp>\\n            </div>\\n\\n            <div class=\\\"unit-app-rating\\\">\\n              <ya-unit-rating />\\n              <ya-unit-review-count />\\n            </div>\\n          </div>\\n\\n        </div>\\n\\n      </ya-unit-if>\\n      <!-- Конец Шаблона РМП -->\\n\\n    </div>\\n\\n    <div class=\\\"unit-cta\\\">\\n      <div class=\\\"unit-domain\\\">\\n        <ya-unit-mobile-app-button />\\n        <ya-unit-if condition=\\\"!unit.isRmp\\\">\\n          <span class=\\\"unit-domain-no-wrap\\\">\\n            <span class=\\\"unit-favicon\\\"><ya-unit-favicon size=\\\"32\\\"/></span>\\n            <ya-unit-domain class=\\\"domain\\\"/>\\n          </span>\\n        </ya-unit-if>\\n      </div>\\n    </div>\\n  </div>\\n\\n</ya-units-grid>\",\"css\":\"/* Шаблон 5: Десктопный грид 3x1 размером 100% x 300px */\\n\\n\\n/* Шаблоны не работают в браузерах IE 11 версии и ниже */\\n\\n/* РМП — Реклама Мобильных Приложений */\\n\\n\\n/* -------- Переменные цветов -------- */\\n/* изменив значение цвета тут — изменится во всех элементах шаблона */\\n.ya-container {\\n\\n  --color-blue: #3377FF;\\n  --color-blue-dark: #0055FF;\\n\\n  --color-blue-transparent: #3377FF1A;\\n  --color-blue-dark-transparent: #0055FF1A;\\n\\n  --color-yellow: #FFCC33;\\n  --color-yellow-dark: #FFBF00;\\n\\n  --color-black: #232526;\\n  --color-grey: #575c66;\\n  --color-grey-alt: #A3ACBF;\\n  --color-light: #f4f4f6;\\n  --color-light-alt: #ececef;\\n}\\n\\n/* Переменные цветов для устройств с поддержкой \\n   цветового профиля Display P3 (устройства Apple) */\\n\\n/* Устройства Apple поддерживают цветовой профиль \\n   с более яркими цветами (цветовой профиль Display P3). \\n   Если вы хотите поддержать его, то следует поменять \\n   значения цветов в блоке ниже */\\n@supports (color: color(display-p3)) {\\n  .ya-container {\\n    --color-blue: color(display-p3 0.2 0.47 1.0);\\n    --color-blue-dark: color(display-p3 0.0 0.33 1.0);\\n\\n    --color-blue-transparent: color(display-p3 0.2 0.47 1.0 / 0.1);\\n    --color-blue-dark-transparent: color(display-p3 0.0 0.33 1.0 / 0.1);\\n\\n    --color-yellow: color(display-p3 1.0 0.8 0.2);\\n    --color-yellow-dark: color(display-p3 1.0 0.75 0.0);\\n  }\\n}\\n\\n\\n\\n/* -------- Переменные для отрисовки объявления -------- */\\n\\n.ya-container {\\n\\n  /* Адаптивность объявления по ширине.\\n     Укажите значение none, чтобы зафиксировать размер объявления.\\n     Укажите auto, чтобы объявление занимало всю доступную ширину */\\n  --banner-flex: auto;\\n\\n  /* Фиксированная ширина объявления.\\n     Работает при --banner-flex: none */\\n  --banner-width: 300px;\\n\\n  /* Минимальная и максимальная ширина объявления.\\n     Работает при --banner-flex: auto */\\n  --banner-min-width: 200px;\\n  --banner-max-width: 400px;\\n\\n  /* Минимальная и максимальная высота объявления.\\n     Объявление будет растягиваться по высоте \\n     в зависимости от количества контента */\\n  --banner-min-height: 300px;\\n  --banner-max-height: 300px;\\n\\n\\n  /* Отображение фавиконки: \\n     вкл - block, выкл - none; */\\n  --display-favicon: block;\\n  /* Отображение изображения: \\n     вкл - block, выкл - none; */\\n  --display-image: block;\\n  /* Отображение текста: \\n     вкл - block, выкл - none; */\\n  --display-desc: none;\\n  /* Отображение цен: \\n     вкл - inline, выкл - none */\\n  --display-price: inline;\\n  /* Отображение количества отзывов (для РМП): \\n     вкл - inline, выкл - none */\\n  --display-rmp-rating-count: inline;\\n  \\n\\n  /* Максимальная ширина картинки */\\n  --image-max-width: 100%;\\n\\n  /* Высота картинки */\\n  --image-height: 100%;\\n\\n  /* Размер иконки приложения.\\n     Только для рекламы мобильных приложений */\\n  --app-icon-size: 40px;\\n\\n   /* Горизонтальное позиционирование сетки баннеров\\n     center - по середине, flex-start - слева,\\n     space-between - по всей ширине, space-around - по всей ширине с отступами\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/justify-content */\\n  --banners-justify-content: center;\\n\\n  /* Отступы вокруг объявления */\\n  --banner-margin: 2px;\\n  \\n  /* Отступы первых и последних объявлений от края \\n     по горизонтали и вертикали. Значение var(--banner-margin) \\n     повторяет общее значение отступов. \\n     ! Неприменимо для одиночных объявлений */\\n  --banners-grid-first-item-top-margin: var(--banner-margin);\\n  --banners-grid-first-item-left-margin: calc( var(--banner-margin) * 2);\\n  --banners-grid-first-item-right-margin: calc( var(--banner-margin) * 2);\\n  --banners-grid-first-item-bottom-margin: var(--banner-margin);\\n\\n\\n  /* Цвет фона объявления. Пример: white или #f0f2f8;\\n     Допустимо использование переменных. См. начало документа */\\n  --banner-background: white;\\n  /* Цвет фона при наведении на объявление */\\n  --banner-background-hover: white;\\n\\n  /* Обводка объявления. Для отключения укажите значение none\\n     Пример: solid 1px rgba(0 0 0 / 15%);\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/border */\\n  --banner-stroke: solid 1px rgba(0 8 32 / 10%);\\n  \\n  /* Тень объявления. Пример: 0px 8px 24px rgba(0, 21, 64, 0.125);\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/box-shadow */\\n  --banner-shadow: none;\\n  /* Тень объявления при наведении */\\n  --banner-shadow-hover: none;\\n  /* Трансформация объявления при наведении. Пример: translateY(-2px); */\\n  --banner-transform-hover: none;\\n  /* Анимация изменений при наведении */\\n  --banner-transition: box-shadow 120ms ease, transform 120ms ease;\\n\\n  /* Скругление углов объявления */\\n  --banner-outer-border-radius: 8px;\\n  /* Скругление углов внутренних элементов объявления (картинка, кнопки) */\\n  --banner-inner-border-radius: 6px;\\n  \\n  /* Отступы элементов от краев объявления */\\n  --banner-padding-outer: 5px;\\n  /* Отступы между элементами объявления */\\n  --banner-padding-inner: 10px;\\n\\n\\n  /* Цвет заголовка в объявлении */\\n  --color-text-header: var(--color-black); \\n  /* Цвет текста в объявлении */\\n  --color-text-desc: var(--color-grey-alt);\\n  /* Цвет цены в объявлении */\\n  --color-text-price: var(--color-black);\\n  /* Цвет ссылки в объявлении */\\n  --color-text-domain: var(--color-blue);\\n  /* Цвет ссылки в объявлении при наведении */\\n  --color-text-domain-hover: var(--color-blue-dark);\\n  /* Фон кнопки действия. Не применимо, если кнопка \\n     не предусмотрена в шаблоне (для форматов маленького размера) */\\n  --color-background-domain: var(--color-blue-transparent);\\n  /* Фон кнопки действия при наведении */\\n  --color-background-domain-hover: var(--color-blue-dark-transparent);\\n\\n  /* Цвет названия приложения в объявления (для РМП) */\\n  --color-text-app-name: var(--color-grey-alt);\\n\\n\\n  /* Цепочка используемых шрифтов в объявлении. По умолчанию указана \\n     цепочка системных шрифтов. Если шрифт не поддерживается, используется \\n     следующий по цепочке. При использовании собственного шрифта, \\n     следует указывать его название в самом начале */\\n  --font-family: \\n    -apple-system, BlinkMacSystemFont, \\\"Segoe UI\\\", Roboto, \\n    Oxygen, Ubuntu, Cantarell, \\\"Open Sans\\\", \\\"Helvetica Neue\\\", sans-serif, \\n    Apple Color Emoji, Segoe UI Emoji;\\n\\n  /* Размер шрифта и межстрочное расстояние для коротких заголовков\\n     (до 21 символа) */\\n  --font-size-title-short: 26px;\\n  --line-height-title-short: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для заголовков средней длины \\n     (от 22 до 31 символа) */\\n  --font-size-title-mid: 22px;\\n  --line-height-title-mid: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для длинных заголовков \\n     (от 32 символов) */\\n  --font-size-title-long: 18px;\\n  --line-height-title-long: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для заголовков РМП */\\n  --font-size-title-rmp: 16px;\\n  --line-height-title-rmp: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для цен */\\n  --font-size-price: 16px;\\n  --line-height-price: calc(1em);\\n\\n  /* Размер шрифта и межстрочное расстояние для текста объявления */\\n  --font-size-desc: 16px;\\n  --line-height-desc: calc(1em + 4px);\\n\\n  /* Размер шрифта и межстрочное расстояние для ссылки */\\n  --font-size-domain: 14px;\\n  --line-height-domain: 18px;\\n\\n  /* Размер шрифта и межстрочное расстояние для названия приложения \\n     (для РМП) */\\n  --font-size-app-name: 14px;\\n  --line-height-app-name: calc(1em + 2px);\\n\\n\\n  width: 100%;\\n  margin: 0 auto;\\n\\n  height: auto;\\n  padding: 0;\\n  overflow: visible;\\n}\\n\\n/* Специальные переменные для Рекламы Мобильных Приложений */\\n.ya-unit-item-rmp {\\n  /* Цвет текста ссылки */\\n  --color-text-domain: var(--color-blue);\\n  /* Цвет текста ссылки при наведении */\\n  --color-text-domain-hover: var(--color-blue-dark);\\n  /* Цвет фона кнопки объявления.\\n     Не применимо если, кнопки не предусмотрено (для маленьких форматов) */\\n  --color-background-domain: var(--color-blue-transparent);\\n  /* Цвет фона кнопки объявления при наведении */\\n  --color-background-domain-hover: var(--color-blue-dark-transparent);\\n}\\n\\n\\n/* Специальные значения для размеров экрана шире 800px */\\n@media screen and (min-width: 800px) {\\n  .ya-container {\\n    /* Здесь прописываются отдельные значения переменных \\n       для отображения рекламы в окнах браузера шире 800px */\\n  }\\n}\\n\\n\\n\\n\\n\\n/* -------- Далее — настройка стилей объявления. -------- */\\n/* -------- Не рекомендуется редактировать -------- */\\n\\n.ya-units-grid {\\n  margin: 0px auto;\\n}\\n\\n.grid-row {\\n  justify-content: var(--banners-justify-content);\\n  align-content: var(--banners-align-content);\\n  padding: 0px 0;\\n}\\n\\n.grid-item {\\n  width: var(--banner-width);\\n  min-width: var(--banner-min-width);\\n  max-width: var(--banner-max-width);\\n  \\n  min-height: var(--banner-min-height);\\n  max-height: var(--banner-max-height);\\n\\n  font-family: var(--font-family);\\n  background: var(--banner-background);\\n  border: var(--banner-stroke);\\n\\n  margin: var(--banner-margin, inherit);\\n  border-radius: var(--banner-outer-border-radius);\\n  overflow: hidden;\\n  box-sizing: border-box;\\n  flex: var(--banner-flex);\\n  box-shadow: var(--banner-shadow);\\n  transform: none;\\n  transition: var(--banner-transition);\\n}\\n\\n.grid-item:hover {\\n  transform: var(--banner-transform-hover);\\n  box-shadow: var(--banner-shadow-hover);\\n  background: var(--banner-background-hover);\\n  --color-text-domain: var(--color-text-domain-hover);\\n}\\n\\n.grid-item:first-child {\\n  margin-left: var(--banners-grid-first-item-left-margin);\\n}\\n\\n.grid-item:last-child {\\n  margin-right: var(--banners-grid-first-item-right-margin);\\n}\\n\\n.grid-row:first-child .grid-item {\\n  margin-top: var(--banners-grid-first-item-top-margin);\\n}\\n\\n.grid-row:last-child .grid-item {\\n  margin-bottom: var(--banners-grid-first-item-bottom-margin);\\n}\\n\\n.unit-wrapper {\\n  height: 100%;\\n}\\n\\n.ya-unit-favicon {\\n  display: block !important;\\n}\\n\\na.yrw-url {\\n  color: inherit;\\n  cursor: pointer;\\n}\\n\\n.unit-misc {\\n  position: absolute;\\n  top: 0;\\n  left: 0;\\n  width: 100%;\\n  height: 100%;\\n}\\n\\n.unit-meta {\\n  position: absolute;\\n  top: 10px;\\n  left: var(--banner-padding-outer);\\n  z-index: 2;\\n  padding: 0px 4px 0px;\\n  text-transform: uppercase;\\n  height: 12px;\\n  background: transparent;\\n  color: var(--color-grey);\\n  border-radius: 4px;\\n  font-size: 8px;\\n  line-height: 13px;\\n  font-weight: 500;\\n  letter-spacing: 0.12em;\\n  vertical-align: 5px;\\n  margin: 0;\\n  user-select: none;\\n  -ms-user-select: none;\\n  -moz-user-select: none;\\n  -khtml-user-select: none;\\n  -webkit-user-select: none;\\n}\\n\\n.ya-unit-item-rmp .unit-meta {\\n  background: transparent;\\n}\\n\\n.unit-age::before {\\n  content: \\\" | \\\";\\n}\\n\\n.unit-age:empty {\\n  display: none;\\n}\\n\\n.ya-unit-kebab_button svg circle {\\n  fill: var(--color-grey);\\n}\\n\\n.ya-unit-kebab_bg {\\n  background: transparent;\\n  opacity: 1.0;\\n}\\n\\n.ya-unit-kebab_icon {\\n  filter: var(--display-image, none);\\n}\\n\\n.ya-unit-kebab_icon circle {\\n  fill: var(--color-grey) !important;\\n}\\n\\n.ya-unit-kebab_button {\\n  position: absolute;\\n  z-index: 940;\\n  top: 4px;\\n  right: 4px;\\n  width: 24px;\\n  height: 24px;\\n}\\n\\n.yrw-body_warning {\\n  position: relative;\\n}\\n\\n.yrw-body_warning div {\\n  padding: 0;\\n}\\n\\n.yrw-body_warning div:not(.yrw-warning-wrapper):not(.yrw-warning-text) {\\n  position: relative;\\n  background-color: var(--color-light-alt);\\n  color: #575c66;\\n  display: flex;\\n  padding: 0 calc(var(--inner-border-radius) / 2);\\n}\\n\\n.yrw-body_warning div text {\\n  fill: #575c66;\\n}\\n\\n.yrw-body_warning div:not(.yrw-warning-wrapper) {\\n  padding: 0 calc(var(--inner-border-radius) / 2 + 4px);\\n}\\n\\n.yrw-warning-text {\\n  text-shadow: none;\\n}\\n\\n\\n\\n.unit-container {\\n  box-sizing: border-box;\\n  position: relative;\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: flex-end;\\n  overflow: hidden;\\n  max-width: var(--max-content-width, --banner-max-width, 960px);\\n  margin: auto;\\n}\\n\\n.unit-content {\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: flex-start;\\n  position: relative;\\n  height: 100%;\\n  padding: 8px;\\n  padding: var(--banner-padding-outer);\\n  padding-top: 32px;\\n}\\n\\n.unit-text-content {\\n  display: flex;\\n  justify-content: flex-start;\\n  flex-direction: column;\\n  position: relative;\\n  flex: auto;\\n}\\n\\n.rmp-app-content {\\n  display: flex;\\n  flex-direction: row;\\n}\\n\\n.rmp-text-content {\\n  display: flex;\\n  justify-content: center;\\n  flex-direction: column;\\n}\\n\\n.unit-text-content > div {\\n  margin-top: var(--banner-padding-inner);\\n}\\n\\n.rmp-text-content > div {\\n  margin-top: calc(var(--banner-padding-inner) / 2);\\n}\\n\\n.rmp-text-content > div:first-child {\\n  margin-top: 0;\\n}\\n\\n\\n\\n.ya-unit-title, .unit-title {\\n  color: var(--color-text-header);\\n  font-size: var(--font-size-title);\\n  line-height: var(--line-height-title);\\n  font-weight: 600;\\n  display: flex;\\n}\\n\\n.title-short {\\n  font-size: var(--font-size-title-short);\\n  line-height: var(--line-height-title-short);\\n}\\n\\n.title-mid {\\n  font-size: var(--font-size-title-mid);\\n  line-height: var(--line-height-title-mid);\\n}\\n\\n.title-long {\\n  font-size: var(--font-size-title-long);\\n  line-height: var(--line-height-title-long);\\n}\\n\\n.title-rmp {\\n  font-size: var(--font-size-title-rmp);\\n  line-height: var(--line-height-title-rmp);\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: center;\\n}\\n\\n.unit-app-name {\\n  font-size: var(--font-size-app-name);\\n  line-height: var(--line-height-app-name);\\n  color: var(--color-text-app-name);\\n}\\n\\n.unit-cta {\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: center;\\n\\n  box-sizing: border-box;\\n  padding: 8px 8px;\\n  font-size: var(--domain-font-size);\\n  line-height: var(--domain-line-height);\\n  text-align: center;\\n\\n  color: var(--color-cta-color);\\n  background-color: var(--color-background-domain);\\n  border-radius: var(--banner-inner-border-radius);\\n  margin-top: var(--banner-padding-inner);\\n  transition: var(--cta-transition);\\n}\\n\\n.unit-cta:hover {\\n  color: var(--color-cta-hover-color);\\n  background-color: var(--color-background-domain-hover);\\n}\\n\\n.unit-favicon {\\n  width: var(--line-height-domain);\\n  background-color: transparent;\\n  border-radius: 3px;\\n  align-self: center;\\n  display: var(--display-favicon, inline);\\n}\\n\\n.ya-unit-favicon {\\n  width: var(--line-height-domain);\\n  height: var(--line-height-domain);\\n}\\n\\n.ya-unit-rating {\\n  margin-right: 4px;\\n  height: 16px;\\n  display: inline;\\n}\\n\\n.ya-unit-review-count {\\n  display: var(--display-rmp-rating-count);\\n  transform: translateY(1px);\\n  color: var(--color-grey-alt);\\n  font-size: 13px;\\n  line-height: 16px;\\n}\\n\\n.unit-favicon:empty,\\n.ya-unit-domain:empty,\\n.unit-domain:empty {\\n  display: none;\\n}\\n\\n.unit-domain {\\n  display: flex;\\n  margin-right: auto;\\n  border-radius: 4px;\\n\\n  color: var(--color-text-domain);\\n  font-size: var(--font-size-domain);\\n  line-height: var(--line-height-domain);\\n  padding: 0;\\n  width: 100%;\\n  height: var(--line-height-domain, 16px);\\n  flex-direction: row;\\n  flex-wrap: wrap;\\n  justify-content: center;\\n  align-content: flex-end;\\n  overflow: hidden;\\n}\\n\\n.unit-domain > *,\\n.unit-domain .unit-domain-no-wrap > * {\\n  margin-right: calc(var(--line-height-domain) / 3.5);\\n}\\n\\n.unit-domain span {\\n  flex: none;\\n}\\n\\n.unit-domain-no-wrap {\\n  display: flex;\\n}\\n\\n\\n\\n.unit-app-rating {\\n  display: flex;\\n  flex-direction: row;\\n  align-content: center;\\n}\\n\\n.unit-prices {\\n  display: var(--display-price, inline);\\n  white-space: nowrap;\\n  font-size: var(--font-size-price);\\n  line-height: var(--line-height-price);\\n}\\n\\n.ya-unit-price {\\n  color: var(--color-text-price);\\n  font-weight: 600;\\n  display: inline;\\n  white-space: nowrap;\\n}\\n\\n.ya-unit-old-price {\\n  margin-left: 8px;\\n  font-size: max(0.9em, 12px);\\n  line-height: max(0.9em, 12px);\\n  color: var(--color-grey-alt);\\n  position: relative;\\n  white-space: nowrap;\\n  display: inline;\\n}\\n\\n.ya-unit-old-price::after {\\n  content: \\\"\\\";\\n  position: absolute;\\n  bottom: 0;\\n  left: 0;\\n  width: 100%;\\n  height: 100%;\\n  \\n  background-image: url(\\\"data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='100%' height='100%'><line class='line' x1='0' y1='65%' x2='100%' y2='50%' stroke='%23A3ACBF' stroke-width='8vh' /></svg>\\\");\\n  background-repeat: no-repeat;\\n}\\n\\n.unit-desc {\\n  display: var(--display-desc);\\n  color: var(--color-text-desc);\\n  font-size: var(--font-size-desc);\\n  line-height: var(--line-height-desc);\\n}\\n\\n\\n\\n\\n\\n\\n.unit-image-block {\\n  display: var(--display-image);\\n  width: 100%;\\n  max-width: var(--image-max-width, none);\\n  height: var(--image-height);\\n  flex: auto;\\n  border-radius: var(--banner-inner-border-radius);\\n  position: relative;\\n  box-sizing: border-box;\\n  background-color: var(--color-light-alt);\\n  overflow: hidden;\\n}\\n\\n.unit-image {\\n  width: 100%;\\n  height: 100%;\\n  display: var(--display-image);\\n  position: relative;\\n}\\n\\n.video-source-container {\\n  border-radius: var(--banner-inner-border-radius, 8px);\\n  z-index: 1;\\n  overflow: hidden;\\n}\\n\\n.ya-unit-app-icon {\\n  position: relative;\\n  border-radius: calc(var(--app-icon-size) / 4);\\n  margin-right: var(--banner-padding-inner);\\n  display: flex;\\n}\\n\\n.unit-app-icon {\\n  margin: auto;\\n}\\n\\n.ya-unit-app-icon .yrw-img-component {\\n  width: var(--app-icon-size);\\n  height: var(--app-icon-size);\\n}\\n\\n.ya-unit-image {\\n  height: 100%;\\n}\\n\\n.yrw-img-component {\\n  height: 100%;\\n  padding-bottom: 0;\\n}\\n\\n.unit-image .img-source-component {\\n  border-radius: var(--banner-inner-border-radius);\\n  background-image: url(\\\"data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='256' height='256'><rect x='80' y='80' width='96' height='96' rx='19.2' fill='%23405580' fill-opacity='0.15'/><path d='M144.619 110.181H147.619C147.619 108.524 146.276 107.181 144.619 107.181V110.181ZM111.102 147.94L146.74 112.302L142.498 108.06L106.86 143.698L111.102 147.94ZM114.072 113.181H144.619V107.181L114.072 107.181V113.181ZM141.619 110.181V140.728H147.619V110.181L141.619 110.181Z' fill='white'/></svg>\\\");\\n  background-position: center;\\n}\\n\\n.ya-unit-app-icon .img-source-component {\\n  border-radius: calc(var(--app-icon-size) / 4 - 4px);\\n}\\n\\n.ya-clamp {\\n  width: 100%;\\n}\\n\\n.yrw-content {\\n  overflow: visible;\\n}\\n\\n.ya-grid-template:empty {\\n  display: none;\\n}\",\"gridColumns\":\"3\",\"gridRows\":\"1\",\"defaultWidth\":\"800\",\"defaultHeight\":\"320\",\"props\":{}},{\"value\":\"14\",\"label\":\"Desktop single with fixed size\",\"template\":\"<ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n\\n  <div class=\\\"unit-misc\\\">\\n    <ya-unit-kebab class=\\\"ya-unit-kebab_dark\\\" />\\n    <div class=\\\"unit-meta\\\">\\n      <ya-unit-category class=\\\"unit-category\\\" />\\n      <ya-unit-age class=\\\"unit-age\\\" />\\n    </div>\\n  </div>\\n\\n\\n\\n  <div class=\\\"unit-content\\\">\\n\\n    <div class=\\\"unit-image-block\\\">\\n      <ya-unit-image/>\\n    </div>\\n\\n    <div class=\\\"unit-text-content\\\" data-cols=\\\"1\\\" data-rows=\\\"1\\\">\\n\\n      <div class=\\\"unit-title\\\">\\n        <ya-unit-if condition=\\\"unit.title < 22\\\">\\n          <ya-clamp lines=\\\"4\\\" class=\\\"title-short\\\"><ya-unit-title /></ya-clamp>\\n        </ya-unit-if>\\n\\n        <ya-unit-if condition=\\\"unit.title > 21 & unit.title < 33\\\">\\n          <ya-clamp lines=\\\"4\\\" class=\\\"title-mid\\\"><ya-unit-title /></ya-clamp>\\n        </ya-unit-if>\\n\\n        <ya-unit-if condition=\\\"unit.title > 32\\\">\\n          <ya-clamp lines=\\\"4\\\" class=\\\"title-long\\\"><ya-unit-title /></ya-clamp>\\n        </ya-unit-if>\\n      </div>\\n\\n      <!-- Начало Шаблона ТГО -->\\n      <ya-unit-if condition=\\\"!unit.isRmp\\\">\\n\\n        <div class=\\\"unit-prices\\\"><ya-unit-price /><ya-unit-old-price /></div>\\n  \\n        <ya-clamp lines=\\\"4\\\" class=\\\"unit-desc\\\"><ya-unit-desc /></ya-clamp>\\n\\n\\n      </ya-unit-if>\\n      <!-- Конец Шаблона ТГО -->\\n\\n\\n    \\n      <!-- Начало Шаблона РМП -->\\n      <ya-unit-if condition=\\\"unit.isRmp\\\">\\n\\n        <div class=\\\"rmp-app-content\\\">\\n          <ya-unit-app-icon />\\n\\n          <div class=\\\"rmp-text-content\\\">\\n\\n            <div class=\\\"unit-app-name\\\">\\n              <ya-clamp lines=\\\"2\\\">\\n                <ya-unit-app-name />\\n              </ya-clamp>\\n            </div>\\n\\n            <div class=\\\"unit-app-rating\\\">\\n              <ya-unit-rating />\\n              <ya-unit-review-count />\\n            </div>\\n          </div>\\n\\n        </div>\\n\\n      </ya-unit-if>\\n      <!-- Конец Шаблона РМП -->\\n\\n    </div>\\n\\n    <div class=\\\"unit-cta\\\">\\n      <div class=\\\"unit-domain\\\">\\n        <ya-unit-mobile-app-button />\\n        <ya-unit-if condition=\\\"!unit.isRmp\\\">\\n          <span class=\\\"unit-domain-no-wrap\\\">\\n            <span class=\\\"unit-favicon\\\"><ya-unit-favicon size=\\\"32\\\"/></span>\\n            <ya-unit-domain class=\\\"domain\\\"/>\\n          </span>\\n        </ya-unit-if>\\n        \\n      </div>\\n    </div>\\n\\n  </div>\\n\\n</ya-units-grid>\",\"css\":\"/* Шаблон 6 (single): Десктопный сингл фиксированного размера\\n   300px x 600px. Для использования в сайдбаре */\\n\\n\\n/* Шаблоны не работают в браузерах IE 11 версии и ниже */\\n\\n/* РМП — Реклама Мобильных Приложений */\\n\\n\\n/* -------- Переменные цветов -------- */\\n/* Изменив значение цвета в переменной, оно одновременно\\n   изменится во всех элементах шаблона, где указано */\\n.ya-container {\\n\\n  --color-blue: #3377FF;\\n  --color-blue-dark: #0055FF;\\n\\n  --color-blue-transparent: #3377FF1A;\\n  --color-blue-dark-transparent: #0055FF1A;\\n\\n  --color-black: #232526;\\n  --color-grey: #575c66;\\n  --color-grey-alt: #A3ACBF;\\n  --color-light: #f4f4f6;\\n  --color-light-alt: #ececef;\\n}\\n\\n/* Переменные цветов для устройств с поддержкой \\n   цветового профиля Display P3 (устройства Apple) */\\n\\n/* Устройства Apple поддерживают цветовой профиль \\n   с более яркими цветами (цветовой профиль Display P3). \\n   Если вы хотите поддержать его, то следует поменять \\n   значения цветов в блоке ниже */\\n@supports (color: color(display-p3)) {\\n  .ya-container {\\n    --color-blue: color(display-p3 0.2 0.47 1.0);\\n    --color-blue-dark: color(display-p3 0.0 0.33 1.0);\\n\\n    --color-blue-transparent: color(display-p3 0.2 0.47 1.0 / 0.1);\\n    --color-blue-dark-transparent: color(display-p3 0.0 0.33 1.0 / 0.1);\\n\\n    --color-yellow: color(display-p3 1.0 0.8 0.2);\\n    --color-yellow-dark: color(display-p3 1.0 0.75 0.0);\\n  }\\n}\\n\\n\\n\\n/* -------- Переменные для отрисовки объявления -------- */\\n\\n.ya-container {\\n\\n  /* Размер объявления по ширине и высоте. */\\n  --adv-width: 300px;\\n  --adv-height: 600px;\\n\\n\\n  /* Отображение фавиконки: \\n     вкл - block, выкл - none; */\\n  --display-favicon: block;\\n  /* Отображение изображения: \\n     вкл - block, выкл - none; */\\n  --display-image: block;\\n  /* Отображение текста: \\n     вкл - block, выкл - none; */\\n  --display-desc: inline;\\n  /* Отображение цен: \\n     вкл - inline, выкл - none */\\n  --display-price: inline;\\n  /* Отображение количества отзывов (для РМП): \\n     вкл - inline, выкл - none */\\n  --display-rmp-rating-count: inline;\\n   \\n\\n  /* Максимальная ширина картинки */\\n  --image-max-width: 100%;\\n\\n  /* Максимальная высота картинки */\\n  --image-max-height: 320px;\\n\\n  /* Размер иконки приложения.\\n     Только для рекламы мобильных приложений */\\n  --app-icon-size: 64px;\\n\\n  /* Горизонтальное позиционирование сетки баннеров\\n     center - по середине, flex-start - слева,\\n     space-between - по всей ширине, space-around - по всей ширине с отступами\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/justify-content */\\n  --banners-justify-content: center;\\n\\n  /* Отступы вокруг объявления */\\n  --banner-margin: 0px;\\n  \\n  /* Отступы первых и последних объявлений от края \\n     по горизонтали и вертикали. Значение var(--banner-margin) \\n     повторяет общее значение отступов. \\n     ! Неприменимо для одиночных объявлений */\\n  --banners-grid-first-item-top-margin: 0;\\n  --banners-grid-first-item-left-margin: 0;\\n  --banners-grid-first-item-right-margin: 0;\\n  --banners-grid-first-item-bottom-margin: 0;\\n\\n  /* Цвет фона объявления. Пример: white или #f0f2f8;\\n     Допустимо использование переменных. См. начало документа */\\n  --banner-background: var(--color-light);\\n  /* Цвет фона при наведении на объявление */\\n  --banner-background-hover: var(--color-light-alt);\\n\\n  /* Обводка объявления. Для отключения укажите значение none\\n     Пример: solid 1px rgba(0 0 0 / 15%);\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/border */\\n  --banner-stroke: none;\\n  \\n  /* Тень объявления. Пример: 0px 8px 24px rgba(0, 21, 64, 0.125);\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/box-shadow */\\n  --banner-shadow: none;\\n  /* Тень объявления при наведении */\\n  --banner-shadow-hover: none;\\n  /* Трансформация объявления при наведении. Пример: translateY(-2px); */\\n  --banner-transform-hover: none;\\n  /* Анимация изменений при наведении */\\n  --banner-transition: box-shadow 120ms ease, transform 120ms ease;\\n\\n  /* Скругление углов объявления */\\n  --banner-outer-border-radius: 8px;\\n  /* Скругление углов внутренних элементов объявления (картинка, кнопки) */\\n  --banner-inner-border-radius: 8px;\\n  \\n  /* Отступы элементов от краев объявления */\\n  --banner-padding-outer: 10px;\\n  /* Отступы между элементами объявления */\\n  --banner-padding-inner: 10px;\\n\\n\\n  /* Цвет заголовка в объявлении */\\n  --color-text-header: var(--color-black); \\n  /* Цвет текста в объявлении */\\n  --color-text-desc: var(--color-grey-alt);\\n  /* Цвет цены в объявлении */\\n  --color-text-price: var(--color-black);\\n  /* Цвет ссылки в объявлении */\\n  --color-text-domain: var(--color-blue);\\n  /* Цвет ссылки в объявлении при наведении */\\n  --color-text-domain-hover: var(--color-blue-dark);\\n  /* Фон кнопки действия. Не применимо, если кнопка \\n     не предусмотрена в шаблоне (для форматов маленького размера) */\\n  --color-background-domain: var(--color-blue-transparent);\\n  /* Фон кнопки действия при наведении */\\n  --color-background-domain-hover: var(--color-blue-dark-transparent);\\n\\n  /* Цвет названия приложения в объявления (для РМП) */\\n  --color-text-app-name: var(--color-grey-alt);\\n\\n\\n  /* Цепочка используемых шрифтов в объявлении. По умолчанию указана \\n     цепочка системных шрифтов. Если шрифт не поддерживается, используется \\n     следующий по цепочке. При использовании собственного шрифта, \\n     следует указывать его название в самом начале */\\n  --font-family: \\n    -apple-system, BlinkMacSystemFont, \\\"Segoe UI\\\", Roboto, \\n    Oxygen, Ubuntu, Cantarell, \\\"Open Sans\\\", \\\"Helvetica Neue\\\", sans-serif, \\n    Apple Color Emoji, Segoe UI Emoji;\\n\\n  /* Размер шрифта и межстрочное расстояние для коротких заголовков\\n     (до 21 символа) */\\n  --font-size-title-short: 36px;\\n  --line-height-title-short: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для заголовков средней длины \\n     (от 22 до 31 символа) */\\n  --font-size-title-mid: 32px;\\n  --line-height-title-mid: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для длинных заголовков \\n     (от 32 символов) */\\n  --font-size-title-long: 28px;\\n  --line-height-title-long: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для цен */\\n  --font-size-price: 20px;\\n  --line-height-price: calc(1em + 4px);\\n\\n  /* Размер шрифта и межстрочное расстояние для текста объявления */\\n  --font-size-desc: 16px;\\n  --line-height-desc: calc(1em + 4px);\\n\\n  /* Размер шрифта и межстрочное расстояние для ссылки */\\n  --font-size-domain: 16px;\\n  --line-height-domain: 20px;\\n\\n  /* Размер шрифта и межстрочное расстояние для названия приложения \\n     (для РМП) */\\n  --font-size-app-name: 16px;\\n  --line-height-app-name: calc(1em + 4px);\\n\\n\\n\\n  width: 100%;\\n  margin: 0 auto;\\n\\n  height: auto;\\n  padding: 0;\\n  overflow: visible;\\n}\\n\\n/* Специальные переменные для Рекламы Мобильных Приложений */\\n.ya-unit-item-rmp {\\n  /* Цвет текста ссылки */\\n  --color-text-domain: var(--color-blue);\\n  /* Цвет текста ссылки при наведении */\\n  --color-text-domain-hover: var(--color-blue-dark);\\n  /* Цвет фона кнопки объявления.\\n     Не применимо если, кнопки не предусмотрено (для маленьких форматов) */\\n  --color-background-domain: var(--color-blue-transparent);\\n  /* Цвет фона кнопки объявления при наведении */\\n  --color-background-domain-hover: var(--color-blue-dark-transparent);\\n}\\n\\n\\n/* -------- Далее — настройка стилей объявления. -------- */\\n/* -------- Не рекомендуется редактировать -------- */\\n\\n.ya-units-grid {\\n  margin: 0px auto;\\n}\\n\\n.grid {\\n  width: var(--adv-width);\\n  min-height: var(--adv-height);\\n}\\n\\n.grid-row {\\n  justify-content: var(--banners-justify-content);\\n  align-content: var(--banners-align-content);\\n  padding: 0px 0;\\n  flex: auto;\\n}\\n\\n.grid-item {\\n  width: 100%;\\n  font-family: var(--font-family);\\n  background: var(--banner-background);\\n  border: var(--banner-stroke);\\n\\n  margin: var(--banner-margin, inherit);\\n  border-radius: var(--banner-outer-border-radius);\\n  overflow: hidden;\\n  box-sizing: border-box;\\n  flex: auto;\\n  box-shadow: var(--banner-shadow);\\n  transform: none;\\n  transition: var(--banner-transition);\\n}\\n\\n.grid-item:hover {\\n  transform: var(--banner-transform-hover);\\n  box-shadow: var(--banner-shadow-hover);\\n  background: var(--banner-background-hover);\\n  --color-text-domain: var(--color-text-domain-hover);\\n}\\n\\n.grid-item:first-child {\\n  margin-left: var(--banners-grid-first-item-left-margin);\\n}\\n\\n.grid-item:last-child {\\n  margin-right: var(--banners-grid-first-item-right-margin);\\n}\\n\\n.grid-row:first-child .grid-item {\\n  margin-top: var(--banners-grid-first-item-top-margin);\\n}\\n\\n.grid-row:last-child .grid-item {\\n  margin-bottom: var(--banners-grid-first-item-bottom-margin);\\n}\\n\\n.unit-wrapper {\\n  height: 100%;\\n}\\n\\n.ya-unit-favicon {\\n  display: block !important;\\n}\\n\\na.yrw-url {\\n  color: inherit;\\n  cursor: pointer;\\n}\\n\\n.unit-misc {\\n  position: absolute;\\n  top: 0;\\n  left: 0;\\n  width: 100%;\\n  height: 100%;\\n}\\n\\n.unit-meta {\\n  position: absolute;\\n  top: 10px;\\n  left: var(--banner-padding-outer);\\n  z-index: 2;\\n  padding: 0px 4px 0px;\\n  text-transform: uppercase;\\n  height: 12px;\\n  background: transparent;\\n  color: var(--color-grey);\\n  border-radius: 4px;\\n  font-size: 8px;\\n  line-height: 13px;\\n  font-weight: 500;\\n  letter-spacing: 0.12em;\\n  vertical-align: 5px;\\n  margin: 0;\\n  user-select: none;\\n  -ms-user-select: none;\\n  -moz-user-select: none;\\n  -khtml-user-select: none;\\n  -webkit-user-select: none;\\n}\\n\\n.ya-unit-item-rmp .unit-meta {\\n  background: transparent;\\n}\\n\\n.unit-age::before {\\n  content: \\\" | \\\";\\n}\\n\\n.unit-age:empty {\\n  display: none;\\n}\\n\\n.ya-unit-kebab_button svg circle {\\n  fill: var(--color-grey);\\n}\\n\\n.ya-unit-kebab_bg {\\n  background: transparent;\\n  opacity: 1.0;\\n}\\n\\n.ya-unit-kebab_icon {\\n  filter: var(--display-image, none);\\n}\\n\\n.ya-unit-kebab_icon circle {\\n  fill: var(--color-grey) !important;\\n}\\n\\n.ya-unit-kebab_button {\\n  position: absolute;\\n  z-index: 940;\\n  top: 4px;\\n  right: 4px;\\n  width: 24px;\\n  height: 24px;\\n}\\n\\n.yrw-body_warning {\\n  position: relative;\\n}\\n\\n.yrw-body_warning div {\\n  padding: 0;\\n}\\n\\n.yrw-body_warning div:not(.yrw-warning-wrapper):not(.yrw-warning-text) {\\n  position: relative;\\n  background-color: var(--color-light-alt);\\n  color: #575c66;\\n  display: flex;\\n  padding: 0 calc(var(--inner-border-radius) / 2);\\n}\\n\\n.yrw-body_warning div text {\\n  fill: #575c66;\\n}\\n\\n.yrw-body_warning div:not(.yrw-warning-wrapper) {\\n  padding: 0 calc(var(--inner-border-radius) / 2 + 4px);\\n}\\n\\n.yrw-warning-text {\\n  text-shadow: none;\\n}\\n\\n\\n\\n.unit-container {\\n  box-sizing: border-box;\\n  position: relative;\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: flex-end;\\n  overflow: hidden;\\n  max-width: var(--max-content-width, --banner-max-width, 960px);\\n  margin: auto;\\n}\\n\\n.unit-content {\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: flex-start;\\n  position: relative;\\n  height: 100%;\\n  padding: 8px;\\n  padding: var(--banner-padding-outer);\\n  padding-top: 32px;\\n}\\n\\n.unit-text-content {\\n  display: flex;\\n  justify-content: flex-start;\\n  flex-direction: column;\\n  position: relative;\\n  flex: auto;\\n}\\n\\n.rmp-app-content {\\n  display: flex;\\n  flex-direction: row;\\n}\\n\\n.rmp-text-content {\\n  display: flex;\\n  justify-content: center;\\n  flex-direction: column;\\n}\\n\\n.unit-text-content > div {\\n  margin-top: var(--banner-padding-inner);\\n}\\n\\n.rmp-text-content > div {\\n  margin-top: calc(var(--banner-padding-inner) / 2);\\n}\\n\\n.rmp-text-content > div:first-child {\\n  margin-top: 0;\\n}\\n\\n\\n\\n.ya-unit-title, .unit-title {\\n  color: var(--color-text-header);\\n  font-size: var(--font-size-title);\\n  line-height: var(--line-height-title);\\n  font-weight: 600;\\n  display: flex;\\n}\\n\\n.title-short {\\n  font-size: var(--font-size-title-short);\\n  line-height: var(--line-height-title-short);\\n}\\n\\n.title-mid {\\n  font-size: var(--font-size-title-mid);\\n  line-height: var(--line-height-title-mid);\\n}\\n\\n.title-long {\\n  font-size: var(--font-size-title-long);\\n  line-height: var(--line-height-title-long);\\n}\\n\\n.title-rmp {\\n  font-size: var(--font-size-title-rmp);\\n  line-height: var(--line-height-title-rmp);\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: center;\\n}\\n\\n.unit-app-name {\\n  font-size: var(--font-size-app-name);\\n  line-height: var(--line-height-app-name);\\n  color: var(--color-text-app-name);\\n}\\n\\n.unit-cta {\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: center;\\n  box-sizing: border-box;\\n  padding: 12px;\\n\\n  font-size: var(--domain-font-size);\\n  line-height: var(--domain-line-height);\\n  text-align: center;\\n  color: var(--color-cta-color);\\n  background-color: var(--color-background-domain);\\n  border-radius: var(--banner-inner-border-radius);\\n  margin-top: var(--banner-padding-inner);\\n  transition: var(--cta-transition);\\n}\\n\\n.unit-cta:hover {\\n  color: var(--color-cta-hover-color);\\n  background-color: var(--color-background-domain-hover);\\n}\\n\\n.unit-favicon {\\n  width: var(--line-height-domain);\\n  background-color: transparent;\\n  border-radius: 3px;\\n  align-self: center;\\n  display: var(--display-favicon, inline);\\n}\\n\\n.ya-unit-favicon {\\n  width: var(--line-height-domain);\\n  height: var(--line-height-domain);\\n}\\n\\n.ya-unit-rating {\\n  margin-right: 4px;\\n  height: 16px;\\n  display: inline;\\n}\\n\\n.ya-unit-review-count {\\n  display: var(--display-rmp-rating-count);\\n  transform: translateY(1px);\\n  color: var(--color-grey-alt);\\n  font-size: 13px;\\n  line-height: 16px;\\n}\\n\\n.unit-favicon:empty,\\n.ya-unit-domain:empty,\\n.unit-domain:empty {\\n  display: none;\\n}\\n\\n.unit-domain {\\n  display: flex;\\n  margin-right: auto;\\n  border-radius: 4px;\\n\\n  color: var(--color-text-domain);\\n  font-size: var(--font-size-domain);\\n  line-height: var(--line-height-domain);\\n  padding: 0;\\n  width: 100%;\\n  height: var(--line-height-domain, 16px);\\n  flex-direction: row;\\n  flex-wrap: wrap;\\n  justify-content: center;\\n  align-content: flex-end;\\n  overflow: hidden;\\n}\\n\\n.unit-domain > *,\\n.unit-domain .unit-domain-no-wrap > * {\\n  margin-right: calc(var(--line-height-domain) / 3.5);\\n}\\n\\n.unit-domain span {\\n  flex: none;\\n}\\n\\n.unit-domain-no-wrap {\\n  display: flex;\\n}\\n\\n\\n\\n.unit-app-rating {\\n  display: flex;\\n  flex-direction: row;\\n  align-content: center;\\n}\\n\\n.unit-prices {\\n  display: var(--display-price, inline);\\n  white-space: nowrap;\\n  font-size: var(--font-size-price);\\n  line-height: var(--line-height-price);\\n}\\n\\n.ya-unit-price {\\n  color: var(--color-text-price);\\n  font-weight: 600;\\n  display: inline;\\n  white-space: nowrap;\\n}\\n\\n.ya-unit-old-price {\\n  margin-left: 8px;\\n  font-size: max(0.9em, 12px);\\n  line-height: max(0.9em, 12px);\\n  color: var(--color-grey-alt);\\n  position: relative;\\n  white-space: nowrap;\\n  display: inline;\\n}\\n\\n.ya-unit-old-price::after {\\n  content: \\\"\\\";\\n  position: absolute;\\n  bottom: 0;\\n  left: 0;\\n  width: 100%;\\n  height: 100%;\\n  \\n  background-image: url(\\\"data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='100%' height='100%'><line class='line' x1='0' y1='65%' x2='100%' y2='50%' stroke='%23A3ACBF' stroke-width='8vh' /></svg>\\\");\\n  background-repeat: no-repeat;\\n}\\n\\n.unit-desc {\\n  display: var(--display-desc);\\n  color: var(--color-text-desc);\\n  font-size: var(--font-size-desc);\\n  line-height: var(--line-height-desc);\\n}\\n\\n\\n\\n.unit-image-block {\\n  display: var(--display-image);\\n  width: 100%;\\n  max-width: var(--image-max-width, none);\\n  height: 100%;\\n  max-height: var(--image-max-height);\\n  flex: auto;\\n  border-radius: var(--banner-inner-border-radius);\\n  position: relative;\\n  box-sizing: border-box;\\n  background-color: var(--color-light-alt);\\n  overflow: hidden;\\n}\\n\\n.unit-image {\\n  width: 100%;\\n  height: 100%;\\n  display: var(--display-image);\\n  position: relative;\\n}\\n\\n.video-source-container {\\n  border-radius: var(--banner-inner-border-radius, 8px);\\n  z-index: 1;\\n  overflow: hidden;\\n}\\n\\n.ya-unit-app-icon {\\n  position: relative;\\n  border-radius: calc(var(--app-icon-size) / 4);\\n  margin-right: var(--banner-padding-inner);\\n  display: flex;\\n}\\n\\n.unit-app-icon {\\n  margin: auto;\\n}\\n\\n.ya-unit-app-icon .yrw-img-component {\\n  width: var(--app-icon-size);\\n  height: var(--app-icon-size);\\n}\\n\\n.ya-unit-image {\\n  height: 100%;\\n}\\n\\n.yrw-img-component {\\n  height: 100%;\\n  padding-bottom: 0;\\n}\\n\\n.unit-image .img-source-component {\\n  border-radius: var(--banner-inner-border-radius);\\n  background-image: url(\\\"data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='256' height='256'><rect x='80' y='80' width='96' height='96' rx='19.2' fill='%23405580' fill-opacity='0.15'/><path d='M144.619 110.181H147.619C147.619 108.524 146.276 107.181 144.619 107.181V110.181ZM111.102 147.94L146.74 112.302L142.498 108.06L106.86 143.698L111.102 147.94ZM114.072 113.181H144.619V107.181L114.072 107.181V113.181ZM141.619 110.181V140.728H147.619V110.181L141.619 110.181Z' fill='white'/></svg>\\\");\\n  background-position: center;\\n}\\n\\n.ya-unit-app-icon .img-source-component {\\n  border-radius: calc(var(--app-icon-size) / 4 - 4px);\\n}\\n\\n.ya-clamp {\\n  width: 100%;\\n}\\n\\n.yrw-content {\\n  overflow: visible;\\n}\\n\\n.ya-grid-template:empty {\\n  display: none;\\n}\",\"gridColumns\":\"1\",\"gridRows\":\"1\",\"defaultWidth\":\"300\",\"defaultHeight\":\"600\",\"props\":{}},{\"value\":\"16\",\"label\":\"Desktop double with fixed size\",\"template\":\"<ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n\\n  <div class=\\\"unit-misc\\\">\\n    <ya-unit-kebab class=\\\"ya-unit-kebab_dark\\\" />\\n    <div class=\\\"unit-meta\\\">\\n      <ya-unit-category class=\\\"unit-category\\\" />\\n      <ya-unit-age class=\\\"unit-age\\\" />\\n    </div>\\n  </div>\\n\\n\\n\\n  <div class=\\\"unit-content\\\">\\n\\n    <div class=\\\"unit-image-block\\\">\\n      <ya-unit-image/>\\n    </div>\\n\\n    <div class=\\\"unit-text-content\\\" data-cols=\\\"1\\\" data-rows=\\\"1\\\">\\n\\n      <div class=\\\"unit-title\\\">\\n        <ya-unit-if condition=\\\"unit.title < 22\\\">\\n          <ya-clamp lines=\\\"3\\\" class=\\\"title-short\\\"><ya-unit-title /></ya-clamp>\\n        </ya-unit-if>\\n\\n        <ya-unit-if condition=\\\"unit.title > 21 & unit.title < 33\\\">\\n          <ya-clamp lines=\\\"3\\\" class=\\\"title-mid\\\"><ya-unit-title /></ya-clamp>\\n        </ya-unit-if>\\n\\n        <ya-unit-if condition=\\\"unit.title > 32\\\">\\n          <ya-clamp lines=\\\"3\\\" class=\\\"title-long\\\"><ya-unit-title /></ya-clamp>\\n        </ya-unit-if>\\n      </div>\\n\\n      <!-- Начало Шаблона ТГО -->\\n      <ya-unit-if condition=\\\"!unit.isRmp\\\">\\n\\n        <div class=\\\"unit-prices\\\"><ya-unit-price /><ya-unit-old-price /></div>\\n  \\n        <ya-clamp lines=\\\"2\\\" class=\\\"unit-desc\\\"><ya-unit-desc /></ya-clamp>\\n\\n\\n      </ya-unit-if>\\n      <!-- Конец Шаблона ТГО -->\\n\\n\\n    \\n      <!-- Начало Шаблона РМП -->\\n      <ya-unit-if condition=\\\"unit.isRmp\\\">\\n\\n        <div class=\\\"rmp-app-content\\\">\\n          <ya-unit-app-icon />\\n\\n          <div class=\\\"rmp-text-content\\\">\\n\\n            <div class=\\\"unit-app-name\\\">\\n              <ya-clamp lines=\\\"1\\\">\\n                <ya-unit-app-name />\\n              </ya-clamp>\\n            </div>\\n\\n            <div class=\\\"unit-app-rating\\\">\\n              <ya-unit-rating />\\n              <ya-unit-review-count />\\n            </div>\\n          </div>\\n\\n        </div>\\n\\n      </ya-unit-if>\\n      <!-- Конец Шаблона РМП -->\\n\\n    </div>\\n\\n    <div class=\\\"unit-cta\\\">\\n      <div class=\\\"unit-domain\\\">\\n        <ya-unit-mobile-app-button />\\n        <ya-unit-if condition=\\\"!unit.isRmp\\\">\\n          <span class=\\\"unit-domain-no-wrap\\\">\\n            <span class=\\\"unit-favicon\\\"><ya-unit-favicon size=\\\"32\\\"/></span>\\n            <ya-unit-domain class=\\\"domain\\\"/>\\n          </span>\\n        </ya-unit-if>\\n        \\n      </div>\\n    </div>\\n\\n  </div>\\n\\n</ya-units-grid>\",\"css\":\"/* Шаблон 7 (double): Десктопный дабл фиксированного размера\\n   300px x 600px. Для использования в сайдбаре */\\n\\n\\n/* Шаблоны не работают в браузерах IE 11 версии и ниже */\\n\\n/* РМП — Реклама Мобильных Приложений */\\n\\n\\n/* -------- Переменные цветов -------- */\\n/* Изменив значение цвета в переменной, оно одновременно\\n   изменится во всех элементах шаблона, где указано */\\n.ya-container {\\n\\n  --color-blue: #3377FF;\\n  --color-blue-dark: #0055FF;\\n\\n  --color-blue-transparent: #3377FF1A;\\n  --color-blue-dark-transparent: #0055FF1A;\\n\\n  --color-black: #232526;\\n  --color-grey: #575c66;\\n  --color-grey-alt: #A3ACBF;\\n  --color-light: #f4f4f6;\\n  --color-light-alt: #ececef;\\n}\\n\\n/* Переменные цветов для устройств с поддержкой \\n   цветового профиля Display P3 (устройства Apple) */\\n\\n/* Устройства Apple поддерживают цветовой профиль \\n   с более яркими цветами (цветовой профиль Display P3). \\n   Если вы хотите поддержать его, то следует поменять \\n   значения цветов в блоке ниже */\\n@supports (color: color(display-p3)) {\\n  .ya-container {\\n    --color-blue: color(display-p3 0.2 0.47 1.0);\\n    --color-blue-dark: color(display-p3 0.0 0.33 1.0);\\n\\n    --color-blue-transparent: color(display-p3 0.2 0.47 1.0 / 0.1);\\n    --color-blue-dark-transparent: color(display-p3 0.0 0.33 1.0 / 0.1);\\n\\n    --color-yellow: color(display-p3 1.0 0.8 0.2);\\n    --color-yellow-dark: color(display-p3 1.0 0.75 0.0);\\n  }\\n}\\n\\n\\n\\n/* -------- Переменные для отрисовки объявления -------- */\\n\\n.ya-container {\\n\\n    /* Размер объявления по ширине и высоте. */\\n  --adv-width: 300px;\\n  --adv-height: 600px;\\n\\n\\n  /* Отображение фавиконки: \\n     вкл - block, выкл - none; */\\n  --display-favicon: block;\\n  /* Отображение изображения: \\n     вкл - block, выкл - none; */\\n  --display-image: block;\\n  /* Отображение текста: \\n     вкл - block, выкл - none; */\\n  --display-desc: none;\\n  /* Отображение цен: \\n     вкл - inline, выкл - none */\\n  --display-price: inline;\\n  /* Отображение количества отзывов (для РМП): \\n     вкл - inline, выкл - none */\\n  --display-rmp-rating-count: inline;\\n\\n\\n  /* Максимальная ширина картинки */\\n  --image-max-width: 100%;\\n\\n  /* Высота картинки */\\n  --image-max-height: 320px;\\n\\n  /* Размер иконки приложения.\\n     Только для рекламы мобильных приложений */\\n  --app-icon-size: 40px;\\n\\n  /* Горизонтальное позиционирование сетки баннеров\\n     center - по середине, flex-start - слева,\\n     space-between - по всей ширине, space-around - по всей ширине с отступами\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/justify-content */\\n  --banners-justify-content: center;\\n\\n  /* Отступы вокруг объявления */\\n  --banner-margin: 5px;\\n  \\n  /* Отступы первых и последних объявлений от края \\n     по горизонтали и вертикали. Значение var(--banner-margin) \\n     повторяет общее значение отступов. \\n     ! Неприменимо для одиночных объявлений */\\n  --banners-grid-first-item-top-margin: 0;\\n  --banners-grid-first-item-left-margin: 0;\\n  --banners-grid-first-item-right-margin: 0;\\n  --banners-grid-first-item-bottom-margin: 0;\\n\\n  /* Цвет фона объявления. Пример: white или #f0f2f8;\\n     Допустимо использование переменных. См. начало документа */\\n  --banner-background: var(--color-light);\\n  /* Цвет фона при наведении на объявление */\\n  --banner-background-hover: var(--color-light-alt);\\n\\n  /* Обводка объявления. Для отключения укажите значение none\\n     Пример: solid 1px rgba(0 0 0 / 15%);\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/border */\\n  --banner-stroke: none;\\n  \\n  /* Тень объявления. Пример: 0px 8px 24px rgba(0, 21, 64, 0.125);\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/box-shadow */\\n  --banner-shadow: none;\\n  /* Тень объявления при наведении */\\n  --banner-shadow-hover: none;\\n  /* Трансформация объявления при наведении. Пример: translateY(-2px); */\\n  --banner-transform-hover: none;\\n  /* Анимация изменений при наведении */\\n  --banner-transition: box-shadow 120ms ease, transform 120ms ease;\\n\\n  /* Скругление углов объявления */\\n  --banner-outer-border-radius: 8px;\\n  /* Скругление углов внутренних элементов объявления (картинка, кнопки) */\\n  --banner-inner-border-radius: 8px;\\n  \\n  /* Отступы элементов от краев объявления */\\n  --banner-padding-outer: 8px;\\n  /* Отступы между элементами объявления */\\n  --banner-padding-inner: 8px;\\n\\n\\n  /* Цвет заголовка в объявлении */\\n  --color-text-header: var(--color-black); \\n  /* Цвет текста в объявлении */\\n  --color-text-desc: var(--color-grey-alt);\\n  /* Цвет цены в объявлении */\\n  --color-text-price: var(--color-black);\\n  /* Цвет ссылки в объявлении */\\n  --color-text-domain: var(--color-blue);\\n  /* Цвет ссылки в объявлении при наведении */\\n  --color-text-domain-hover: var(--color-blue-dark);\\n  /* Фон кнопки действия. Не применимо, если кнопка \\n     не предусмотрена в шаблоне (для форматов маленького размера) */\\n  --color-background-domain: var(--color-blue-transparent);\\n  /* Фон кнопки действия при наведении */\\n  --color-background-domain-hover: var(--color-blue-dark-transparent);\\n\\n  /* Цвет названия приложения в объявления (для РМП) */\\n  --color-text-app-name: var(--color-grey-alt);\\n\\n\\n  /* Цепочка используемых шрифтов в объявлении. По умолчанию указана \\n     цепочка системных шрифтов. Если шрифт не поддерживается, используется \\n     следующий по цепочке. При использовании собственного шрифта, \\n     следует указывать его название в самом начале */\\n  --font-family: \\n    -apple-system, BlinkMacSystemFont, \\\"Segoe UI\\\", Roboto, \\n    Oxygen, Ubuntu, Cantarell, \\\"Open Sans\\\", \\\"Helvetica Neue\\\", sans-serif, \\n    Apple Color Emoji, Segoe UI Emoji;\\n\\n  /* Размер шрифта и межстрочное расстояние для коротких заголовков\\n     (до 21 символа) */\\n  --font-size-title-short: 24px;\\n  --line-height-title-short: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для заголовков средней длины \\n     (от 22 до 31 символа) */\\n  --font-size-title-mid: 22px;\\n  --line-height-title-mid: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для длинных заголовков \\n     (от 32 символов) */\\n  --font-size-title-long: 18px;\\n  --line-height-title-long: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для цен */\\n  --font-size-price: 16px;\\n  --line-height-price: calc(1em + 4px);\\n\\n  /* Размер шрифта и межстрочное расстояние для текста объявления */\\n  --font-size-desc: 14px;\\n  --line-height-desc: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для ссылки */\\n  --font-size-domain: 14px;\\n  --line-height-domain: 18px;\\n\\n  /* Размер шрифта и межстрочное расстояние для названия приложения \\n     (для РМП) */\\n  --font-size-app-name: 14px;\\n  --line-height-app-name: calc(1em + 2px);\\n  \\n\\n  width: 100%;\\n  margin: 0 auto;\\n\\n  height: auto;\\n  padding: 0;\\n  overflow: visible;\\n}\\n\\n/* Специальные переменные для Рекламы Мобильных Приложений */\\n.ya-unit-item-rmp {\\n  /* Цвет текста ссылки */\\n  --color-text-domain: var(--color-blue);\\n  /* Цвет текста ссылки при наведении */\\n  --color-text-domain-hover: var(--color-blue-dark);\\n  /* Цвет фона кнопки объявления.\\n     Не применимо если, кнопки не предусмотрено (для маленьких форматов) */\\n  --color-background-domain: var(--color-blue-transparent);\\n  /* Цвет фона кнопки объявления при наведении */\\n  --color-background-domain-hover: var(--color-blue-dark-transparent);\\n}\\n\\n\\n/* -------- Далее — настройка стилей объявления. -------- */\\n/* -------- Не рекомендуется редактировать -------- */\\n\\n.ya-units-grid {\\n  margin: 0px auto;\\n}\\n\\n.grid {\\n  width: var(--adv-width);\\n  min-height: var(--adv-height);\\n}\\n\\n.grid-row {\\n  justify-content: var(--banners-justify-content);\\n  align-content: var(--banners-align-content);\\n  padding: 0px 0;\\n  flex: auto;\\n}\\n\\n.grid-item {\\n  width: 100%;\\n  font-family: var(--font-family);\\n  background: var(--banner-background);\\n  border: var(--banner-stroke);\\n  margin: var(--banner-margin, inherit);\\n  border-radius: var(--banner-outer-border-radius);\\n  overflow: hidden;\\n  box-sizing: border-box;\\n  flex: auto;\\n  box-shadow: var(--banner-shadow);\\n  transform: none;\\n  transition: var(--banner-transition);\\n}\\n\\n.grid-item:hover {\\n  transform: var(--banner-transform-hover);\\n  box-shadow: var(--banner-shadow-hover);\\n  background: var(--banner-background-hover);\\n  --color-text-domain: var(--color-text-domain-hover);\\n}\\n\\n.grid-item:first-child {\\n  margin-left: var(--banners-grid-first-item-left-margin);\\n}\\n\\n.grid-item:last-child {\\n  margin-right: var(--banners-grid-first-item-right-margin);\\n}\\n\\n.grid-row:first-child .grid-item {\\n  margin-top: var(--banners-grid-first-item-top-margin);\\n}\\n\\n.grid-row:last-child .grid-item {\\n  margin-bottom: var(--banners-grid-first-item-bottom-margin);\\n}\\n\\n.unit-wrapper {\\n  height: 100%;\\n}\\n\\n.ya-unit-favicon {\\n  display: block !important;\\n}\\n\\na.yrw-url {\\n  color: inherit;\\n  cursor: pointer;\\n}\\n\\n.unit-misc {\\n  position: absolute;\\n  top: 0;\\n  left: 0;\\n  width: 100%;\\n  height: 100%;\\n}\\n\\n.unit-meta {\\n  position: absolute;\\n  top: 10px;\\n  left: var(--banner-padding-outer);\\n  z-index: 2;\\n  padding: 0px 4px 0px;\\n  text-transform: uppercase;\\n  height: 12px;\\n  background: transparent;\\n  color: var(--color-grey);\\n  border-radius: 4px;\\n  font-size: 8px;\\n  line-height: 13px;\\n  font-weight: 500;\\n  letter-spacing: 0.12em;\\n  vertical-align: 5px;\\n  margin: 0;\\n  user-select: none;\\n  -ms-user-select: none;\\n  -moz-user-select: none;\\n  -khtml-user-select: none;\\n  -webkit-user-select: none;\\n}\\n\\n.ya-unit-item-rmp .unit-meta {\\n  background: transparent;\\n}\\n\\n.unit-age::before {\\n  content: \\\" | \\\";\\n}\\n\\n.unit-age:empty {\\n  display: none;\\n}\\n\\n.ya-unit-kebab_button svg circle {\\n  fill: var(--color-grey);\\n}\\n\\n.ya-unit-kebab_bg {\\n  background: transparent;\\n  opacity: 1.0;\\n}\\n\\n.ya-unit-kebab_icon {\\n  filter: var(--display-image, none);\\n}\\n\\n.ya-unit-kebab_icon circle {\\n  fill: var(--color-grey) !important;\\n}\\n\\n.ya-unit-kebab_button {\\n  position: absolute;\\n  z-index: 940;\\n  top: 4px;\\n  right: 4px;\\n  width: 24px;\\n  height: 24px;\\n}\\n\\n.yrw-body_warning {\\n  position: relative;\\n}\\n\\n.yrw-body_warning div {\\n  padding: 0;\\n}\\n\\n.yrw-body_warning div:not(.yrw-warning-wrapper):not(.yrw-warning-text) {\\n  position: relative;\\n  background-color: var(--color-light-alt);\\n  color: #575c66;\\n  display: flex;\\n  padding: 0 calc(var(--inner-border-radius) / 2);\\n}\\n\\n.yrw-body_warning div text {\\n  fill: #575c66;\\n}\\n\\n.yrw-body_warning div:not(.yrw-warning-wrapper) {\\n  padding: 0 calc(var(--inner-border-radius) / 2 + 4px);\\n}\\n\\n.yrw-warning-text {\\n  text-shadow: none;\\n}\\n\\n\\n\\n.unit-container {\\n  box-sizing: border-box;\\n  position: relative;\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: flex-end;\\n  overflow: hidden;\\n  max-width: var(--max-content-width, --banner-max-width, 960px);\\n  margin: auto;\\n}\\n\\n.unit-content {\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: flex-start;\\n  position: relative;\\n  height: 100%;\\n  padding: 8px;\\n  padding: var(--banner-padding-outer);\\n  padding-top: 32px;\\n}\\n\\n.unit-text-content {\\n  display: flex;\\n  justify-content: flex-start;\\n  flex-direction: column;\\n  position: relative;\\n  flex: auto;\\n}\\n\\n.rmp-app-content {\\n  display: flex;\\n  flex-direction: row;\\n}\\n\\n.rmp-text-content {\\n  display: flex;\\n  justify-content: center;\\n  flex-direction: column;\\n}\\n\\n.unit-text-content > div {\\n  margin-top: var(--banner-padding-inner);\\n}\\n\\n.rmp-text-content > div {\\n  margin-top: calc(var(--banner-padding-inner) / 2);\\n}\\n\\n.rmp-text-content > div:first-child {\\n  margin-top: 0;\\n}\\n\\n\\n\\n.ya-unit-title, .unit-title {\\n  color: var(--color-text-header);\\n  font-size: var(--font-size-title);\\n  line-height: var(--line-height-title);\\n  font-weight: 600;\\n  display: flex;\\n}\\n\\n.title-short {\\n  font-size: var(--font-size-title-short);\\n  line-height: var(--line-height-title-short);\\n}\\n\\n.title-mid {\\n  font-size: var(--font-size-title-mid);\\n  line-height: var(--line-height-title-mid);\\n}\\n\\n.title-long {\\n  font-size: var(--font-size-title-long);\\n  line-height: var(--line-height-title-long);\\n}\\n\\n.title-rmp {\\n  font-size: var(--font-size-title-rmp);\\n  line-height: var(--line-height-title-rmp);\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: center;\\n}\\n\\n.unit-app-name {\\n  font-size: var(--font-size-app-name);\\n  line-height: var(--line-height-app-name);\\n  color: var(--color-text-app-name);\\n}\\n\\n.unit-cta {\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: center;\\n  box-sizing: border-box;\\n  padding: 12px;\\n\\n  font-size: var(--domain-font-size);\\n  line-height: var(--domain-line-height);\\n  text-align: center;\\n  color: var(--color-cta-color);\\n  background-color: var(--color-background-domain);\\n  border-radius: var(--banner-inner-border-radius);\\n  margin-top: var(--banner-padding-inner);\\n  transition: var(--cta-transition);\\n}\\n\\n.unit-cta:hover {\\n  color: var(--color-cta-hover-color);\\n  background-color: var(--color-background-domain-hover);\\n}\\n\\n.unit-favicon {\\n  width: var(--line-height-domain);\\n  background-color: transparent;\\n  border-radius: 3px;\\n  align-self: center;\\n  display: var(--display-favicon, inline);\\n}\\n\\n.ya-unit-favicon {\\n  width: var(--line-height-domain);\\n  height: var(--line-height-domain);\\n}\\n\\n.ya-unit-rating {\\n  margin-right: 4px;\\n  height: 16px;\\n  display: inline;\\n}\\n\\n.ya-unit-review-count {\\n  display: var(--display-rmp-rating-count);\\n  transform: translateY(1px);\\n  color: var(--color-grey-alt);\\n  font-size: 13px;\\n  line-height: 16px;\\n}\\n\\n.unit-favicon:empty,\\n.ya-unit-domain:empty,\\n.unit-domain:empty {\\n  display: none;\\n}\\n\\n.unit-domain {\\n  display: flex;\\n  margin-right: auto;\\n  border-radius: 4px;\\n  color: var(--color-text-domain);\\n  font-size: var(--font-size-domain);\\n  line-height: var(--line-height-domain);\\n  padding: 0;\\n  width: 100%;\\n  height: var(--line-height-domain, 16px);\\n  flex-direction: row;\\n  flex-wrap: wrap;\\n  justify-content: center;\\n  align-content: flex-end;\\n  overflow: hidden;\\n}\\n\\n.unit-domain > *,\\n.unit-domain .unit-domain-no-wrap > * {\\n  margin-right: calc(var(--line-height-domain) / 3.5);\\n}\\n\\n.unit-domain span {\\n  flex: none;\\n}\\n\\n.unit-domain-no-wrap {\\n  display: flex;\\n}\\n\\n\\n\\n.unit-app-rating {\\n  display: flex;\\n  flex-direction: row;\\n  align-content: center;\\n}\\n\\n.unit-prices {\\n  display: var(--display-price, inline);\\n  white-space: nowrap;\\n  font-size: var(--font-size-price);\\n  line-height: var(--line-height-price);\\n}\\n\\n.ya-unit-price {\\n  color: var(--color-text-price);\\n  font-weight: 600;\\n  display: inline;\\n  white-space: nowrap;\\n}\\n\\n.ya-unit-old-price {\\n  margin-left: 8px;\\n  font-size: max(0.9em, 12px);\\n  line-height: max(0.9em, 12px);\\n  color: var(--color-grey-alt);\\n  position: relative;\\n  white-space: nowrap;\\n  display: inline;\\n}\\n\\n.ya-unit-old-price::after {\\n  content: \\\"\\\";\\n  position: absolute;\\n  bottom: 0;\\n  left: 0;\\n  width: 100%;\\n  height: 100%;\\n  \\n  background-image: url(\\\"data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='100%' height='100%'><line class='line' x1='0' y1='65%' x2='100%' y2='50%' stroke='%23A3ACBF' stroke-width='8vh' /></svg>\\\");\\n  background-repeat: no-repeat;\\n}\\n\\n.unit-desc {\\n  display: var(--display-desc);\\n  color: var(--color-text-desc);\\n  font-size: var(--font-size-desc);\\n  line-height: var(--line-height-desc);\\n}\\n\\n\\n\\n.unit-image-block {\\n  display: var(--display-image);\\n  width: 100%;\\n  max-width: var(--image-max-width, none);\\n  height: 100%;\\n  max-height: var(--image-max-height);\\n  flex: auto;\\n  border-radius: var(--banner-inner-border-radius);\\n  position: relative;\\n  box-sizing: border-box;\\n  background-color: var(--color-light-alt);\\n  overflow: hidden;\\n}\\n\\n.unit-image {\\n  width: 100%;\\n  height: 100%;\\n  display: var(--display-image);\\n  position: relative;\\n}\\n\\n.video-source-container {\\n  border-radius: var(--banner-inner-border-radius, 8px);\\n  z-index: 1;\\n  overflow: hidden;\\n}\\n\\n.ya-unit-app-icon {\\n  position: relative;\\n  border-radius: calc(var(--app-icon-size) / 4);\\n  margin-right: var(--banner-padding-inner);\\n  display: flex;\\n}\\n\\n.unit-app-icon {\\n  margin: auto;\\n}\\n\\n.ya-unit-app-icon .yrw-img-component {\\n  width: var(--app-icon-size);\\n  height: var(--app-icon-size);\\n}\\n\\n.ya-unit-image {\\n  height: 100%;\\n}\\n\\n.yrw-img-component {\\n  height: 100%;\\n  padding-bottom: 0;\\n}\\n\\n.unit-image .img-source-component {\\n  border-radius: var(--banner-inner-border-radius);\\n  background-image: url(\\\"data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='256' height='256'><rect x='80' y='80' width='96' height='96' rx='19.2' fill='%23405580' fill-opacity='0.15'/><path d='M144.619 110.181H147.619C147.619 108.524 146.276 107.181 144.619 107.181V110.181ZM111.102 147.94L146.74 112.302L142.498 108.06L106.86 143.698L111.102 147.94ZM114.072 113.181H144.619V107.181L114.072 107.181V113.181ZM141.619 110.181V140.728H147.619V110.181L141.619 110.181Z' fill='white'/></svg>\\\");\\n  background-position: center;\\n}\\n\\n.ya-unit-app-icon .img-source-component {\\n  border-radius: calc(var(--app-icon-size) / 4 - 4px);\\n}\\n\\n.ya-clamp {\\n  width: 100%;\\n}\\n\\n.yrw-content {\\n  overflow: visible;\\n}\\n\\n.ya-grid-template:empty {\\n  display: none;\\n}\",\"gridColumns\":\"1\",\"gridRows\":\"2\",\"defaultWidth\":\"300\",\"defaultHeight\":\"600\",\"props\":{}},{\"value\":\"8\",\"label\":\"Desktop ribbon 300px x infinitely\",\"template\":\"<ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n\\n  <div class=\\\"unit-misc\\\">\\n    <ya-unit-kebab class=\\\"ya-unit-kebab_dark\\\" />\\n    <div class=\\\"unit-meta\\\">\\n      <ya-unit-category class=\\\"unit-category\\\" />\\n      <ya-unit-age class=\\\"unit-age\\\" />\\n    </div>\\n  </div>\\n\\n\\n  <div class=\\\"unit-content\\\">\\n    <div class=\\\"unit-image-block\\\">\\n      <ya-unit-image/>\\n    </div>\\n\\n    <div class=\\\"unit-text-content\\\" data-cols=\\\"1\\\" data-rows=\\\"1\\\">\\n\\n      <div class=\\\"unit-title\\\">\\n        <ya-unit-if condition=\\\"unit.title < 22\\\">\\n          <ya-clamp lines=\\\"3\\\" class=\\\"title-short\\\"><ya-unit-title /></ya-clamp>\\n        </ya-unit-if>\\n\\n        <ya-unit-if condition=\\\"unit.title > 21 & unit.title < 33\\\">\\n          <ya-clamp lines=\\\"3\\\" class=\\\"title-mid\\\"><ya-unit-title /></ya-clamp>\\n        </ya-unit-if>\\n\\n        <ya-unit-if condition=\\\"unit.title > 32\\\">\\n          <ya-clamp lines=\\\"3\\\" class=\\\"title-long\\\"><ya-unit-title /></ya-clamp>\\n        </ya-unit-if>\\n      </div>\\n\\n      <!-- Начало Шаблона ТГО -->\\n      <ya-unit-if condition=\\\"!unit.isRmp\\\">\\n\\n        <div class=\\\"unit-prices\\\"><ya-unit-price /><ya-unit-old-price /></div>\\n  \\n        <ya-clamp lines=\\\"4\\\" class=\\\"unit-desc\\\"><ya-unit-desc /></ya-clamp>\\n\\n\\n      </ya-unit-if>\\n      <!-- Конец Шаблона ТГО -->\\n\\n\\n    \\n      <!-- Начало Шаблона РМП -->\\n      <ya-unit-if condition=\\\"unit.isRmp\\\">\\n\\n        <div class=\\\"rmp-app-content\\\">\\n          <ya-unit-app-icon />\\n\\n          <div class=\\\"rmp-text-content\\\">\\n\\n            <div class=\\\"unit-app-name\\\">\\n              <ya-clamp lines=\\\"2\\\">\\n                <ya-unit-app-name />\\n              </ya-clamp>\\n            </div>\\n\\n            <div class=\\\"unit-app-rating\\\">\\n              <ya-unit-rating />\\n              <ya-unit-review-count />\\n            </div>\\n          </div>\\n        </div>\\n\\n      </ya-unit-if>\\n      <!-- Конец Шаблона РМП -->\\n\\n    </div>\\n\\n    <div class=\\\"unit-cta\\\">\\n      <div class=\\\"unit-domain\\\">\\n        <ya-unit-mobile-app-button />\\n        <ya-unit-if condition=\\\"!unit.isRmp\\\">\\n          <span class=\\\"unit-domain-no-wrap\\\">\\n            <span class=\\\"unit-favicon\\\"><ya-unit-favicon size=\\\"32\\\"/></span>\\n            <ya-unit-domain class=\\\"domain\\\"/>\\n          </span>\\n        </ya-unit-if>\\n      </div>\\n    </div>\\n  </div>\\n\\n</ya-units-grid>\",\"css\":\"/* Шаблон 8: Десктопная лента 300px x бесконечно\\n   Для использования в сайдбаре сайта */\\n\\n\\n/* Шаблоны не работают в браузерах IE 11 версии и ниже */\\n\\n/* РМП — Реклама Мобильных Приложений */\\n\\n\\n/* -------- Переменные цветов -------- */\\n/* Изменив значение цвета в переменной, оно одновременно\\n   изменится во всех элементах шаблона, где указано */\\n.ya-container {\\n\\n  --color-blue: #3377FF;\\n  --color-blue-dark: #0055FF;\\n\\n  --color-blue-transparent: #3377FF1A;\\n  --color-blue-dark-transparent: #0055FF1A;\\n\\n  --color-black: #232526;\\n  --color-grey: #575c66;\\n  --color-grey-alt: #A3ACBF;\\n  --color-light: #f4f4f6;\\n  --color-light-alt: #ececef;\\n}\\n\\n/* Переменные цветов для устройств с поддержкой \\n   цветового профиля Display P3 (устройства Apple) */\\n\\n/* Устройства Apple поддерживают цветовой профиль \\n   с более яркими цветами (цветовой профиль Display P3). \\n   Если вы хотите поддержать его, то следует поменять \\n   значения цветов в блоке ниже */\\n@supports (color: color(display-p3)) {\\n  .ya-container {\\n    --color-blue: color(display-p3 0.2 0.47 1.0);\\n    --color-blue-dark: color(display-p3 0.0 0.33 1.0);\\n\\n    --color-blue-transparent: color(display-p3 0.2 0.47 1.0 / 0.1);\\n    --color-blue-dark-transparent: color(display-p3 0.0 0.33 1.0 / 0.1);\\n\\n    --color-yellow: color(display-p3 1.0 0.8 0.2);\\n    --color-yellow-dark: color(display-p3 1.0 0.75 0.0);\\n  }\\n}\\n\\n\\n\\n/* -------- Переменные для отрисовки объявления -------- */\\n\\n.ya-container {\\n\\n  /* Фиксированная ширина объявления.\\n     Работает при --banner-flex: none */\\n  --banner-width: 300px;\\n\\n  /* Минимальная и максимальная высота объявления.\\n     Объявление будет растягиваться по высоте \\n     в зависимости от количества контента */\\n  --banner-min-height: 280px;\\n  --banner-max-height: none;\\n\\n\\n  /* Отображение фавиконки: \\n     вкл - block, выкл - none; */\\n  --display-favicon: block;\\n  /* Отображение изображения: \\n     вкл - block, выкл - none; */\\n  --display-image: block;\\n  /* Отображение текста: \\n     вкл - block, выкл - none; */\\n  --display-desc: inline;\\n  /* Отображение цен: \\n     вкл - inline, выкл - none */\\n  --display-price: inline;\\n  /* Отображение количества отзывов (для РМП): \\n     вкл - inline, выкл - none */\\n  --display-rmp-rating-count: inline;\\n  \\n\\n  /* Максимальная ширина картинки */\\n  --image-max-width: 100%;\\n\\n  /* Высота картинки */\\n  --image-height: 160px;\\n\\n  /* Размер иконки приложения.\\n     Только для рекламы мобильных приложений */\\n  --app-icon-size: 60px;\\n\\n  /* Горизонтальное позиционирование сетки баннеров\\n     center - по середине, flex-start - слева,\\n     space-between - по всей ширине, space-around - по всей ширине с отступами\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/justify-content */\\n  --banners-justify-content: center;\\n\\n  /* Отступы вокруг объявления */\\n  --banner-margin: 5px 0;\\n  \\n  /* Отступы первых и последних объявлений от края \\n     по горизонтали и вертикали. Значение var(--banner-margin) \\n     повторяет общее значение отступов. \\n     ! Неприменимо для одиночных объявлений */\\n  --banners-grid-first-item-top-margin: 0;\\n  --banners-grid-first-item-left-margin: 0;\\n  --banners-grid-first-item-right-margin: 0;\\n  --banners-grid-first-item-bottom-margin: 0;\\n\\n  /* Цвет фона объявления. Пример: white или #f0f2f8;\\n     Допустимо использование переменных. См. начало документа */\\n  --banner-background: var(--color-light);\\n  /* Цвет фона объявления при наведении */\\n  --banner-background-hover: var(--color-light-alt);\\n\\n  /* Обводка объявления. Для отключения укажите значение none\\n     Пример: solid 1px rgba(0 0 0 / 15%);\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/border */\\n  --banner-stroke: none;\\n  \\n  /* Тень объявления. Пример: 0px 8px 24px rgba(0, 21, 64, 0.125);\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/box-shadow */\\n  --banner-shadow: none;\\n  /* Тень объявления при наведении */\\n  --banner-shadow-hover: none;\\n  /* Трансформация объявления при наведении. Пример: translateY(-2px); */\\n  --banner-transform-hover: none;\\n  /* Анимация изменений при наведении */\\n  --banner-transition: box-shadow 120ms ease, transform 120ms ease;\\n\\n  /* Скругление углов объявления */\\n  --banner-outer-border-radius: 8px;\\n  /* Скругление углов внутренних элементов объявления (картинка, кнопки) */\\n  --banner-inner-border-radius: 8px;\\n  \\n  /* Отступы элементов от краев объявления */\\n  --banner-padding-outer: 8px;\\n  /* Отступы между элементами объявления */\\n  --banner-padding-inner: 12px;\\n\\n\\n  /* Цвет заголовка в объявлении */\\n  --color-text-header: var(--color-black); \\n  /* Цвет текста в объявлении */\\n  --color-text-desc: var(--color-grey-alt);\\n  /* Цвет цены в объявлении */\\n  --color-text-price: var(--color-black);\\n  /* Цвет ссылки в объявлении */\\n  --color-text-domain: var(--color-blue);\\n  /* Цвет ссылки в объявлении при наведении */\\n  --color-text-domain-hover: var(--color-blue-dark);\\n  /* Фон кнопки действия. Не применимо, если кнопка \\n     не предусмотрена в шаблоне (для форматов маленького размера) */\\n  --color-background-domain: var(--color-blue-transparent);\\n  /* Фон кнопки действия при наведении */\\n  --color-background-domain-hover: var(--color-blue-dark-transparent);\\n\\n  /* Цвет названия приложения в объявления (для РМП) */\\n  --color-text-app-name: var(--color-grey-alt);\\n\\n\\n  /* Цепочка используемых шрифтов в объявлении. По умолчанию указана \\n     цепочка системных шрифтов. Если шрифт не поддерживается, используется \\n     следующий по цепочке. При использовании собственного шрифта, \\n     следует указывать его название в самом начале */\\n  --font-family: \\n    -apple-system, BlinkMacSystemFont, \\\"Segoe UI\\\", Roboto, \\n    Oxygen, Ubuntu, Cantarell, \\\"Open Sans\\\", \\\"Helvetica Neue\\\", sans-serif, \\n    Apple Color Emoji, Segoe UI Emoji;\\n\\n  /* Размер шрифта и межстрочное расстояние для коротких заголовков\\n     (до 21 символа) */\\n  --font-size-title-short: 24px;\\n  --line-height-title-short: calc(1em + 0px);\\n\\n  /* Размер шрифта и межстрочное расстояние для заголовков средней длины \\n     (от 22 до 31 символа) */\\n  --font-size-title-mid: 20px;\\n  --line-height-title-mid: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для длинных заголовков \\n     (от 32 символов) */\\n  --font-size-title-long: 20px;\\n  --line-height-title-long: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для заголовков РМП */\\n  --font-size-title-rmp: 20px;\\n  --line-height-title-rmp: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для цен */\\n  --font-size-price: 16px;\\n  --line-height-price: calc(1em + 4px);\\n\\n  /* Размер шрифта и межстрочное расстояние для текста объявления */\\n  --font-size-desc: 15px;\\n  --line-height-desc: calc(1em + 3px);\\n\\n  /* Размер шрифта и межстрочное расстояние для ссылки */\\n  --font-size-domain: 15px;\\n  --line-height-domain: 16px;\\n\\n  /* Размер шрифта и межстрочное расстояние для названия приложения \\n     (для РМП) */\\n  --font-size-app-name: 15px;\\n  --line-height-app-name: calc(1em + 3px);\\n\\n\\n\\n  width: 100%;\\n  margin: 0 auto;\\n\\n  height: auto;\\n  padding: 0;\\n  overflow: visible;\\n}\\n\\n/* Специальные переменные для Рекламы Мобильных Приложений */\\n.ya-unit-item-rmp {\\n  /* Цвет текста ссылки */\\n  --color-text-domain: var(--color-blue);\\n  /* Цвет текста ссылки при наведении */\\n  --color-text-domain-hover: var(--color-blue-dark);\\n  /* Цвет фона кнопки объявления.\\n     Не применимо если, кнопки не предусмотрено (для маленьких форматов) */\\n  --color-background-domain: var(--color-blue-transparent);\\n  /* Цвет фона кнопки объявления при наведении */\\n  --color-background-domain-hover: var(--color-blue-dark-transparent);\\n}\\n\\n\\n\\n\\n\\n/* -------- Далее — настройка стилей объявления. -------- */\\n/* -------- Не рекомендуется редактировать -------- */\\n\\n.ya-units-grid {\\n  margin: 0px auto;\\n}\\n\\n.grid-row {\\n  justify-content: var(--banners-justify-content);\\n  align-content: var(--banners-align-content);\\n  padding: 0px 0;\\n}\\n\\n.grid-item {\\n  width: var(--banner-width);\\n  min-height: var(--banner-min-height);\\n  max-height: var(--banner-max-height);\\n  font-family: var(--font-family);\\n  background: var(--banner-background);\\n  border: var(--banner-stroke);\\n  margin: var(--banner-margin, inherit);\\n  border-radius: var(--banner-outer-border-radius);\\n  overflow: hidden;\\n  box-sizing: border-box;\\n  flex: var(--banner-flex);\\n  box-shadow: var(--banner-shadow);\\n  transform: none;\\n  transition: var(--banner-transition);\\n}\\n\\n.grid-item:hover {\\n  transform: var(--banner-transform-hover);\\n  box-shadow: var(--banner-shadow-hover);\\n  background: var(--banner-background-hover);\\n  --color-text-domain: var(--color-text-domain-hover);\\n}\\n\\n.grid-item:first-child {\\n  margin-left: var(--banners-grid-first-item-left-margin);\\n}\\n\\n.grid-item:last-child {\\n  margin-right: var(--banners-grid-first-item-right-margin);\\n}\\n\\n.grid-row:first-child .grid-item {\\n  margin-top: var(--banners-grid-first-item-top-margin);\\n}\\n\\n.grid-row:last-child .grid-item {\\n  margin-bottom: var(--banners-grid-first-item-bottom-margin);\\n}\\n\\n.unit-wrapper {\\n  height: 100%;\\n}\\n\\n.ya-unit-favicon {\\n  display: block !important;\\n}\\n\\na.yrw-url {\\n  color: inherit;\\n  cursor: pointer;\\n}\\n\\n.unit-misc {\\n  position: absolute;\\n  top: 0;\\n  left: 0;\\n  width: 100%;\\n  height: 100%;\\n}\\n\\n.unit-meta {\\n  position: absolute;\\n  top: 10px;\\n  left: var(--banner-padding-outer);\\n  z-index: 2;\\n  padding: 0px 4px 0px;\\n  text-transform: uppercase;\\n  height: 12px;\\n  background: transparent;\\n  color: var(--color-grey);\\n  border-radius: 4px;\\n  font-size: 8px;\\n  line-height: 13px;\\n  font-weight: 500;\\n  letter-spacing: 0.12em;\\n  vertical-align: 5px;\\n  margin: 0;\\n  user-select: none;\\n  -ms-user-select: none;\\n  -moz-user-select: none;\\n  -khtml-user-select: none;\\n  -webkit-user-select: none;\\n}\\n\\n.ya-unit-item-rmp .unit-meta {\\n  background: transparent;\\n}\\n\\n.unit-age::before {\\n  content: \\\" | \\\";\\n}\\n\\n.unit-age:empty {\\n  display: none;\\n}\\n\\n.ya-unit-kebab_button svg circle {\\n  fill: var(--color-grey);\\n}\\n\\n.ya-unit-kebab_bg {\\n  background: transparent;\\n  opacity: 1.0;\\n}\\n\\n.ya-unit-kebab_icon {\\n  filter: var(--display-image, none);\\n}\\n\\n.ya-unit-kebab_icon circle {\\n  fill: var(--color-grey) !important;\\n}\\n\\n.ya-unit-kebab_button {\\n  position: absolute;\\n  z-index: 940;\\n  top: 4px;\\n  right: 4px;\\n  width: 24px;\\n  height: 24px;\\n}\\n\\n.yrw-body_warning {\\n  position: relative;\\n}\\n\\n.yrw-body_warning div {\\n  padding: 0;\\n}\\n\\n.yrw-body_warning div:not(.yrw-warning-wrapper):not(.yrw-warning-text) {\\n  position: relative;\\n  background-color: var(--color-light-alt);\\n  color: #575c66;\\n  display: flex;\\n  padding: 0 calc(var(--inner-border-radius) / 2);\\n}\\n\\n.yrw-body_warning div text {\\n  fill: #575c66;\\n}\\n\\n.yrw-body_warning div:not(.yrw-warning-wrapper) {\\n  padding: 0 calc(var(--inner-border-radius) / 2 + 4px);\\n}\\n\\n.yrw-warning-text {\\n  text-shadow: none;\\n}\\n\\n\\n\\n.unit-container {\\n  box-sizing: border-box;\\n  position: relative;\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: flex-end;\\n  overflow: hidden;\\n  max-width: var(--max-content-width, --banner-max-width, 960px);\\n  margin: auto;\\n}\\n\\n.unit-content {\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: flex-start;\\n  position: relative;\\n  height: 100%;\\n  padding: 8px;\\n  padding: var(--banner-padding-outer);\\n  padding-top: 32px;\\n}\\n\\n.unit-text-content {\\n  display: flex;\\n  justify-content: flex-start;\\n  flex-direction: column;\\n  position: relative;\\n  flex: auto;\\n}\\n\\n.rmp-app-content {\\n  display: flex;\\n  flex-direction: row;\\n}\\n\\n.rmp-text-content {\\n  display: flex;\\n  justify-content: center;\\n  flex-direction: column;\\n}\\n\\n.unit-text-content > div {\\n  margin-top: var(--banner-padding-inner);\\n}\\n\\n.rmp-text-content > div {\\n  margin-top: calc(var(--banner-padding-inner) / 2);\\n}\\n\\n.rmp-text-content > div:first-child {\\n  margin-top: 0;\\n}\\n\\n\\n\\n.ya-unit-title, .unit-title {\\n  color: var(--color-text-header);\\n  font-size: var(--font-size-title);\\n  line-height: var(--line-height-title);\\n  font-weight: 600;\\n  display: flex;\\n}\\n\\n.title-short {\\n  font-size: var(--font-size-title-short);\\n  line-height: var(--line-height-title-short);\\n}\\n\\n.title-mid {\\n  font-size: var(--font-size-title-mid);\\n  line-height: var(--line-height-title-mid);\\n}\\n\\n.title-long {\\n  font-size: var(--font-size-title-long);\\n  line-height: var(--line-height-title-long);\\n}\\n\\n.title-rmp {\\n  font-size: var(--font-size-title-rmp);\\n  line-height: var(--line-height-title-rmp);\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: center;\\n}\\n\\n.unit-app-name {\\n  font-size: var(--font-size-app-name);\\n  line-height: var(--line-height-app-name);\\n  color: var(--color-text-app-name);\\n}\\n\\n.unit-cta {\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: center;\\n  box-sizing: border-box;\\n  padding: 12px;\\n\\n  font-size: var(--domain-font-size);\\n  line-height: var(--domain-line-height);\\n  text-align: center;\\n  color: var(--color-cta-color);\\n  background-color: var(--color-background-domain);\\n  border-radius: var(--banner-inner-border-radius);\\n  margin-top: var(--banner-padding-inner);\\n  transition: var(--cta-transition);\\n}\\n\\n.unit-cta:hover {\\n  color: var(--color-cta-hover-color);\\n  background-color: var(--color-background-domain-hover);\\n}\\n\\n.unit-favicon {\\n  width: var(--line-height-domain);\\n  background-color: transparent;\\n  border-radius: 3px;\\n  align-self: center;\\n  display: var(--display-favicon, inline);\\n}\\n\\n.ya-unit-favicon {\\n  width: var(--line-height-domain);\\n  height: var(--line-height-domain);\\n}\\n\\n.ya-unit-rating {\\n  margin-right: 4px;\\n  height: 16px;\\n  display: inline;\\n}\\n\\n.ya-unit-review-count {\\n  display: var(--display-rmp-rating-count);\\n  transform: translateY(1px);\\n  color: var(--color-grey-alt);\\n  font-size: 13px;\\n  line-height: 16px;\\n}\\n\\n.unit-favicon:empty,\\n.ya-unit-domain:empty,\\n.unit-domain:empty {\\n  display: none;\\n}\\n\\n.unit-domain {\\n  display: flex;\\n  margin-right: auto;\\n  border-radius: 4px;\\n  color: var(--color-text-domain);\\n  font-size: var(--font-size-domain);\\n  line-height: var(--line-height-domain);\\n  \\n  padding: 0;\\n  width: 100%;\\n  height: var(--line-height-domain, 16px);\\n  flex-direction: row;\\n  flex-wrap: wrap;\\n  justify-content: center;\\n  align-content: flex-end;\\n  overflow: hidden;\\n}\\n\\n.unit-domain > *,\\n.unit-domain .unit-domain-no-wrap > * {\\n  margin-right: calc(var(--line-height-domain) / 3.5);\\n}\\n\\n.unit-domain span {\\n  flex: none;\\n}\\n\\n.unit-domain-no-wrap {\\n  display: flex;\\n}\\n\\n\\n\\n.unit-app-rating {\\n  display: flex;\\n  flex-direction: row;\\n  align-content: center;\\n}\\n\\n.unit-prices {\\n  display: var(--display-price, inline);\\n  white-space: nowrap;\\n  font-size: var(--font-size-price);\\n  line-height: var(--line-height-price);\\n}\\n\\n.ya-unit-price {\\n  color: var(--color-text-price);\\n  font-weight: 600;\\n  display: inline;\\n  white-space: nowrap;\\n}\\n\\n.ya-unit-old-price {\\n  margin-left: 8px;\\n  font-size: max(0.9em, 12px);\\n  line-height: max(0.9em, 12px);\\n  color: var(--color-grey-alt);\\n  position: relative;\\n  white-space: nowrap;\\n  display: inline;\\n}\\n\\n.ya-unit-old-price::after {\\n  content: \\\"\\\";\\n  position: absolute;\\n  bottom: 0;\\n  left: 0;\\n  width: 100%;\\n  height: 100%;\\n  \\n  background-image: url(\\\"data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='100%' height='100%'><line class='line' x1='0' y1='65%' x2='100%' y2='50%' stroke='%23A3ACBF' stroke-width='8vh' /></svg>\\\");\\n  background-repeat: no-repeat;\\n}\\n\\n.unit-desc {\\n  display: var(--display-desc);\\n  color: var(--color-text-desc);\\n  font-size: var(--font-size-desc);\\n  line-height: var(--line-height-desc);\\n}\\n\\n\\n\\n.unit-image-block {\\n  display: var(--display-image);\\n  width: 100%;\\n  max-width: var(--image-max-width, none);\\n  height: var(--image-height);\\n  flex: none;\\n  border-radius: var(--banner-inner-border-radius);\\n  position: relative;\\n  box-sizing: border-box;\\n  background-color: var(--color-light-alt);\\n  overflow: hidden;\\n}\\n\\n.unit-image {\\n  width: 100%;\\n  height: 100%;\\n  display: var(--display-image);\\n  position: relative;\\n}\\n\\n.video-source-container {\\n  border-radius: var(--banner-inner-border-radius, 8px);\\n  z-index: 1;\\n  overflow: hidden;\\n}\\n\\n.ya-unit-app-icon {\\n  position: relative;\\n  border-radius: calc(var(--app-icon-size) / 4);\\n  margin-right: var(--banner-padding-inner);\\n  display: flex;\\n}\\n\\n.unit-app-icon {\\n  margin: auto;\\n}\\n\\n.ya-unit-app-icon .yrw-img-component {\\n  width: var(--app-icon-size);\\n  height: var(--app-icon-size);\\n}\\n\\n.ya-unit-image {\\n  height: 100%;\\n}\\n\\n.yrw-img-component {\\n  height: 100%;\\n  padding-bottom: 0;\\n}\\n\\n.unit-image .img-source-component {\\n  border-radius: var(--banner-inner-border-radius);\\n  background-image: url(\\\"data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='256' height='256'><rect x='80' y='80' width='96' height='96' rx='19.2' fill='%23405580' fill-opacity='0.15'/><path d='M144.619 110.181H147.619C147.619 108.524 146.276 107.181 144.619 107.181V110.181ZM111.102 147.94L146.74 112.302L142.498 108.06L106.86 143.698L111.102 147.94ZM114.072 113.181H144.619V107.181L114.072 107.181V113.181ZM141.619 110.181V140.728H147.619V110.181L141.619 110.181Z' fill='white'/></svg>\\\");\\n  background-position: center;\\n}\\n\\n.ya-unit-app-icon .img-source-component {\\n  border-radius: calc(var(--app-icon-size) / 4 - 4px);\\n}\\n\\n.ya-clamp {\\n  width: 100%;\\n}\\n\\n.yrw-content {\\n  overflow: visible;\\n}\\n\\n.ya-grid-template:empty {\\n  display: none;\\n}\",\"gridColumns\":\"1\",\"gridRows\":\"3\",\"defaultWidth\":\"300\",\"defaultHeight\":\"1100\",\"props\":{}},{\"value\":\"13\",\"label\":\"Universal single 100% x auto\",\"template\":\"<ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n\\n  <div class=\\\"unit-content\\\">\\n\\n    <div class=\\\"unit-misc\\\">\\n      <ya-unit-kebab class=\\\"ya-unit-kebab_dark\\\" />\\n    </div>\\n\\n    <div class=\\\"unit-image-block\\\">\\n      <ya-unit-image/>\\n    </div>\\n\\n    <div class=\\\"unit-text-content\\\" data-cols=\\\"1\\\" data-rows=\\\"1\\\">\\n\\n      <div class=\\\"unit-meta\\\">\\n        <ya-unit-category class=\\\"unit-category\\\" />\\n        <ya-unit-age class=\\\"unit-age\\\" />\\n      </div>\\n\\n      <div class=\\\"unit-title\\\">\\n        <ya-unit-if condition=\\\"unit.title < 22\\\">\\n          <ya-clamp lines=\\\"3\\\" class=\\\"title-short\\\"><ya-unit-title /></ya-clamp>\\n        </ya-unit-if>\\n\\n        <ya-unit-if condition=\\\"unit.title > 21 & unit.title < 33\\\">\\n          <ya-clamp lines=\\\"3\\\" class=\\\"title-mid\\\"><ya-unit-title /></ya-clamp>\\n        </ya-unit-if>\\n\\n        <ya-unit-if condition=\\\"unit.title > 32\\\">\\n          <ya-clamp lines=\\\"3\\\" class=\\\"title-long\\\"><ya-unit-title /></ya-clamp>\\n        </ya-unit-if>\\n      </div>\\n\\n      <!-- Начало Шаблона ТГО -->\\n      <ya-unit-if condition=\\\"!unit.isRmp\\\">\\n        <div class=\\\"unit-prices\\\"><ya-unit-price /><ya-unit-old-price /></div>\\n        <ya-clamp lines=\\\"2\\\" class=\\\"unit-desc\\\"><ya-unit-desc /></ya-clamp>\\n      </ya-unit-if>\\n      <!-- Конец Шаблона ТГО -->\\n\\n\\n    \\n      <!-- Начало Шаблона РМП -->\\n      <ya-unit-if condition=\\\"unit.isRmp\\\">\\n        <div class=\\\"rmp-app-content\\\">\\n          <ya-unit-app-icon />\\n\\n          <div class=\\\"rmp-text-content\\\">\\n\\n            <div class=\\\"unit-app-name\\\">\\n              <ya-clamp lines=\\\"2\\\">\\n                <ya-unit-app-name />\\n              </ya-clamp>\\n            </div>\\n\\n            <div class=\\\"unit-app-rating\\\">\\n              <ya-unit-rating />\\n              <ya-unit-review-count />\\n            </div>\\n          </div>\\n\\n        </div>\\n\\n      </ya-unit-if>\\n      <!-- Конец Шаблона РМП -->\\n\\n      <div class=\\\"unit-cta\\\">\\n        <div class=\\\"unit-domain\\\">\\n          <ya-unit-mobile-app-button />\\n          <ya-unit-if condition=\\\"!unit.isRmp\\\">\\n            <span class=\\\"unit-domain-no-wrap\\\">\\n              <span class=\\\"unit-favicon\\\"><ya-unit-favicon size=\\\"32\\\"/></span>\\n              <ya-unit-domain class=\\\"domain\\\"/>\\n            </span>\\n          </ya-unit-if>\\n          \\n        </div>\\n      </div>\\n\\n    </div>\\n  </div>\\n\\n</ya-units-grid>\",\"css\":\"/* Шаблон 9: Универсайльный сингл размером 100% x Auto.\\n   Подходит для использования на сайтах, использующих \\n   единую верстку для мобильных устройств и десктопов */\\n\\n/* Шаблоны не работают в браузерах IE 11 версии и ниже */\\n\\n/* РМП — Реклама Мобильных Приложений */\\n\\n\\n/* -------- Переменные цветов -------- */\\n/* Изменив значение цвета в переменной, оно одновременно\\n   изменится во всех элементах шаблона, где указано */\\n.ya-container {\\n\\n  --color-blue: #3377FF;\\n  --color-blue-dark: #0055FF;\\n\\n  --color-blue-transparent: #3377FF1A;\\n  --color-blue-dark-transparent: #0055FF1A;\\n\\n  --color-black: #232526;\\n  --color-grey: #575c66;\\n  --color-grey-alt: #A3ACBF;\\n  --color-light: #f4f4f6;\\n  --color-light-alt: #ececef;\\n}\\n\\n/* Переменные цветов для устройств с поддержкой \\n   цветового профиля Display P3 (устройства Apple) */\\n\\n/* Устройства Apple поддерживают цветовой профиль \\n   с более яркими цветами (цветовой профиль Display P3). \\n   Если вы хотите поддержать его, то следует поменять \\n   значения цветов в блоке ниже */\\n@supports (color: color(display-p3)) {\\n  .ya-container {\\n    --color-blue: color(display-p3 0.2 0.47 1.0);\\n    --color-blue-dark: color(display-p3 0.0 0.33 1.0);\\n\\n    --color-blue-transparent: color(display-p3 0.2 0.47 1.0 / 0.1);\\n    --color-blue-dark-transparent: color(display-p3 0.0 0.33 1.0 / 0.1);\\n\\n    --color-yellow: color(display-p3 1.0 0.8 0.2);\\n    --color-yellow-dark: color(display-p3 1.0 0.75 0.0);\\n  }\\n}\\n\\n\\n\\n/* -------- Переменные для отрисовки объявления -------- */\\n\\n.ya-container {\\n\\n  /* Адаптивность объявления по ширине.\\n     Укажите значение none, чтобы зафиксировать размер объявления.\\n     Укажите auto, чтобы объявление занимало всю доступную ширину */\\n  --banner-flex: auto;\\n\\n  /* Фиксированная ширина объявления.\\n     Работает при --banner-flex: none */\\n  --banner-width: 300px;\\n\\n  /* Минимальная и максимальная ширина объявления.\\n     Работает при --banner-flex: auto */\\n  --banner-min-width: 320px;\\n  --banner-max-width: 100%;\\n\\n  --content-max-width: 960px;\\n\\n  /* Минимальная и максимальная высота объявления.\\n     Объявление будет растягиваться по высоте \\n     в зависимости от количества контента */\\n  --banner-min-height: 300px;\\n  --banner-max-height: none;\\n\\n\\n  /* Отображение фавиконки: \\n     вкл - block, выкл - none; */\\n  --display-favicon: block;\\n  /* Отображение изображения: \\n     вкл - block, выкл - none; */\\n  --display-image: block;\\n  /* Отображение текста: \\n     вкл - block, выкл - none; */\\n  --display-desc: inline;\\n  /* Отображение цен: \\n     вкл - inline, выкл - none */\\n  --display-price: inline;\\n  /* Отображение количества отзывов (для РМП): \\n     вкл - inline, выкл - none */\\n  --display-rmp-rating-count: inline;\\n\\n\\n  /* Ширина картинки */\\n  --image-width: 100%;\\n\\n  /* Максимальная ширина картинки */\\n  --image-max-width: 100%;\\n\\n  /* Высота картинки */\\n  --image-height: 160px;\\n\\n  /* Размер иконки приложения.\\n     Только для рекламы мобильных приложений */\\n  --app-icon-size: 48px;\\n\\n  /* Горизонтальное позиционирование сетки баннеров\\n     center - по середине, flex-start - слева,\\n     space-between - по всей ширине, space-around - по всей ширине с отступами\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/justify-content */\\n  --banners-justify-content: center;\\n\\n  /* Отступы вокруг объявления */\\n  --banner-margin: 8px 0;\\n\\n  /* Отступы первых и последних объявлений от края \\n     по горизонтали и вертикали. Значение var(--banner-margin) \\n     повторяет общее значение отступов. \\n     ! Неприменимо для одиночных объявлений */\\n  --banners-grid-first-item-top-margin: 0;\\n  --banners-grid-first-item-left-margin: 0;\\n  --banners-grid-first-item-right-margin: 0;\\n  --banners-grid-first-item-bottom-margin: 0;\\n\\n  /* Цвет фона объявления. Пример: white или #f0f2f8;\\n     Допустимо использование переменных. См. начало документа */\\n  --banner-background: var(--color-light);\\n  /* Цвет фона при наведении на объявление */\\n  --banner-background-hover: var(--color-light);\\n\\n  /* Обводка объявления. Для отключения укажите значение none\\n     Пример: solid 1px rgba(0 0 0 / 15%);\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/border */\\n  --banner-stroke: none;\\n  \\n  /* Тень объявления. Пример: 0px 8px 24px rgba(0, 21, 64, 0.125);\\n     Подробнее: https://developer.mozilla.org/ru/docs/Web/CSS/box-shadow */\\n  --banner-shadow: none;\\n  /* Тень объявления при наведении */\\n  --banner-shadow-hover: none;\\n  /* Трансформация объявления при наведении. Пример: translateY(-2px); */\\n  --banner-transform-hover: none;\\n  /* Анимация изменений при наведении */\\n  --banner-transition: box-shadow 120ms ease, transform 120ms ease;\\n\\n  /* Скругление углов объявления */\\n  --banner-outer-border-radius: 0px;\\n  /* Скругление углов внутренних элементов объявления (картинка, кнопки) */\\n  --banner-inner-border-radius: 8px;\\n  \\n  /* Отступы элементов от краев объявления */\\n  --banner-padding-outer: 10px;\\n  /* Отступы между элементами объявления */\\n  --banner-padding-inner: 10px;\\n\\n\\n  /* Цвет заголовка в объявлении */\\n  --color-text-header: var(--color-black); \\n  /* Цвет текста в объявлении */\\n  --color-text-desc: var(--color-grey-alt);\\n  /* Цвет цены в объявлении */\\n  --color-text-price: var(--color-black);\\n  /* Цвет ссылки в объявлении */\\n  --color-text-domain: var(--color-blue);\\n  /* Цвет ссылки в объявлении при наведении */\\n  --color-text-domain-hover: var(--color-blue-dark);\\n  /* Фон кнопки действия. Не применимо, если кнопка \\n     не предусмотрена в шаблоне (для форматов маленького размера) */\\n  --color-background-domain: var(--color-blue-transparent);\\n  /* Фон кнопки действия при наведении */\\n  --color-background-domain-hover: var(--color-blue-dark-transparent);\\n\\n  /* Цвет названия приложения в объявления (для РМП) */\\n  --color-text-app-name: var(--color-grey-alt);\\n\\n\\n  /* Цепочка используемых шрифтов в объявлении. По умолчанию указана \\n     цепочка системных шрифтов. Если шрифт не поддерживается, используется \\n     следующий по цепочке. При использовании собственного шрифта, \\n     следует указывать его название в самом начале */\\n  --font-family: \\n    -apple-system, BlinkMacSystemFont, \\\"Segoe UI\\\", Roboto, \\n    Oxygen, Ubuntu, Cantarell, \\\"Open Sans\\\", \\\"Helvetica Neue\\\", sans-serif, \\n    Apple Color Emoji, Segoe UI Emoji;\\n\\n  /* Размер шрифта и межстрочное расстояние для коротких заголовков\\n     (до 21 символа) */\\n  --font-size-title-short: 24px;\\n  --line-height-title-short: calc(1em + 0px);\\n\\n  /* Размер шрифта и межстрочное расстояние для заголовков средней длины \\n     (от 22 до 31 символа) */\\n  --font-size-title-mid: 20px;\\n  --line-height-title-mid: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для длинных заголовков \\n     (от 32 символов) */\\n  --font-size-title-long: 20px;\\n  --line-height-title-long: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для заголовков РМП */\\n  --font-size-title-rmp: 20px;\\n  --line-height-title-rmp: calc(1em + 2px);\\n\\n  /* Размер шрифта и межстрочное расстояние для цен */\\n  --font-size-price: 16px;\\n  --line-height-price: calc(1em + 4px);\\n\\n  /* Размер шрифта и межстрочное расстояние для текста объявления */\\n  --font-size-desc: 15px;\\n  --line-height-desc: calc(1em + 3px);\\n\\n  /* Размер шрифта и межстрочное расстояние для ссылки */\\n  --font-size-domain: 15px;\\n  --line-height-domain: 20px;\\n\\n  /* Размер шрифта и межстрочное расстояние для названия приложения \\n     (для РМП) */\\n  --font-size-app-name: 15px;\\n  --line-height-app-name: calc(1em + 3px);\\n  \\n\\n  width: 100%;\\n  margin: 0 auto;\\n\\n  height: auto;\\n  padding: 0;\\n  overflow: visible;\\n}\\n\\n/* Специальные переменные для Рекламы Мобильных Приложений */\\n.ya-unit-item-rmp {\\n  /* Цвет текста ссылки */\\n  --color-text-domain: var(--color-blue);\\n  /* Цвет текста ссылки при наведении */\\n  --color-text-domain-hover: var(--color-blue-dark);\\n  /* Цвет фона кнопки объявления.\\n     Не применимо если, кнопки не предусмотрено (для маленьких форматов) */\\n  --color-background-domain: var(--color-blue-transparent);\\n  /* Цвет фона кнопки объявления при наведении */\\n  --color-background-domain-hover: var(--color-blue-dark-transparent);\\n}\\n\\n/* Специальные значения для размеров экрана шире 360px */\\n@media screen and (min-width: 360px) {\\n\\n  .ya-container {\\n    --image-height: 200px;\\n\\n    --app-icon-size: 64px;\\n\\n    --font-size-title: 18px;\\n    --line-height-title: calc(1em + 2px);\\n\\n    --font-size-title-short: 28px;\\n    --line-height-title-short: calc(1em + 0px);\\n  \\n    --font-size-title-mid: 24px;\\n    --line-height-title-mid: calc(1em + 2px);\\n  \\n    --font-size-title-long: 22px;\\n    --line-height-title-long: calc(1em + 2px);\\n\\n    --font-size-price: 20px;\\n    --line-height-price: calc(1em + 0px);\\n\\n    --font-size-desc: 16px;\\n    --line-height-desc: calc(1em + 4px);\\n\\n    --font-size-app-name: 18px;\\n    --line-height-app-name: calc(1em + 2px);\\n\\n    --font-size-domain: 16px;\\n    --line-height-domain: 20px;\\n\\n    --banner-padding-outer: 12px;\\n    --banner-padding-inner: 12px;\\n  }\\n}\\n\\n/* Специальные значения для размеров экрана шире 420px */\\n@media screen and (min-width: 420px) {\\n  .ya-container {\\n    --image-height: 240px;\\n\\n    --font-size-title: 18px;\\n    --line-height-title: calc(1em + 2px);\\n\\n    --font-size-title-short: 32px;\\n    --line-height-title-short: calc(1em + 0px);\\n\\n    --font-size-title-mid: 26px;\\n    --line-height-title-mid: calc(1em + 2px);\\n\\n    --font-size-title-long: 24px;\\n    --line-height-title-long: calc(1em + 2px);\\n\\n    --font-size-desc: 16px;\\n    --line-height-desc: calc(1em + 4px);\\n\\n    --font-size-app-name: 20px;\\n    --line-height-app-name: calc(1em + 2px);\\n\\n    --font-size-domain: 16px;\\n  }\\n}\\n\\n/* Специальные значения для размеров экрана шире 540px */\\n@media screen and (min-width: 540px) {\\n  .ya-container {\\n\\n    /* Максимальная ширина картинки */\\n    --image-width: 50%;\\n\\n    /* Максимальная ширина картинки */\\n    --image-max-width: 400px;\\n\\n    /* Высота картинки */\\n    --image-height: 100%;\\n  }\\n\\n  .unit-container .unit-content {\\n    flex-direction: row;\\n    padding: var(--banner-padding-outer);\\n  }\\n\\n  .unit-container .unit-text-content {\\n    position: relative;\\n    padding-left: 16px;\\n    width: 50%;\\n  }\\n\\n  .unit-text-content .unit-meta {\\n    position: relative;\\n    margin-top: 0;\\n    top: 0;\\n    left: 0;\\n    padding: 0;\\n  }\\n\\n  .unit-cta {\\n    margin-top: auto !important;\\n  }\\n}\\n\\n\\n\\n\\n/* -------- Далее — настройка стилей объявления. -------- */\\n/* -------- Не рекомендуется редактировать -------- */\\n\\n.ya-units-grid {\\n  margin: 0px auto;\\n}\\n\\n.grid-row {\\n  justify-content: var(--banners-justify-content);\\n  align-content: var(--banners-align-content);\\n  padding: 0px 0;\\n}\\n\\n.grid-item {\\n  width: var(--banner-width);\\n  min-width: var(--banner-min-width);\\n  max-width: var(--banner-max-width);\\n  \\n  min-height: var(--banner-min-height);\\n  max-height: var(--banner-max-height);\\n\\n  font-family: var(--font-family);\\n  background: var(--banner-background);\\n  border: var(--banner-stroke);\\n\\n  margin: var(--banner-margin, inherit);\\n  border-radius: var(--banner-outer-border-radius);\\n  overflow: hidden;\\n  box-sizing: border-box;\\n  flex: var(--banner-flex);\\n  box-shadow: var(--banner-shadow);\\n  transform: none;\\n  transition: var(--banner-transition);\\n}\\n\\n.grid-item:hover {\\n  transform: var(--banner-transform-hover);\\n  box-shadow: var(--banner-shadow-hover);\\n  background: var(--banner-background-hover);\\n  --color-text-domain: var(--color-text-domain-hover);\\n}\\n\\n.grid-item:first-child {\\n  margin-left: var(--banners-grid-first-item-left-margin);\\n}\\n\\n.grid-item:last-child {\\n  margin-right: var(--banners-grid-first-item-right-margin);\\n}\\n\\n.grid-row:first-child .grid-item {\\n  margin-top: var(--banners-grid-first-item-top-margin);\\n}\\n\\n.grid-row:last-child .grid-item {\\n  margin-bottom: var(--banners-grid-first-item-bottom-margin);\\n}\\n\\n.unit-wrapper {\\n  height: 100%;\\n}\\n\\n.ya-unit-favicon {\\n  display: block !important;\\n}\\n\\na.yrw-url {\\n  color: inherit;\\n  cursor: pointer;\\n}\\n\\n.unit-misc {\\n  position: absolute;\\n  top: 0;\\n  left: 0;\\n  width: 100%;\\n  height: 100%;\\n}\\n\\n.unit-meta {\\n  position: absolute;\\n  top: 10px;\\n  left: var(--banner-padding-outer);\\n  z-index: 2;\\n  padding: 0px 4px 0px;\\n  text-transform: uppercase;\\n  height: 12px;\\n  background: transparent;\\n  color: var(--color-grey);\\n  border-radius: 4px;\\n  font-size: 8px;\\n  line-height: 13px;\\n  font-weight: 500;\\n  letter-spacing: 0.12em;\\n  vertical-align: 5px;\\n  margin: 0;\\n  user-select: none;\\n  -ms-user-select: none;\\n  -moz-user-select: none;\\n  -khtml-user-select: none;\\n  -webkit-user-select: none;\\n}\\n\\n.ya-unit-item-rmp .unit-meta {\\n  background: transparent;\\n}\\n\\n.unit-age::before {\\n  content: \\\" | \\\";\\n}\\n\\n.unit-age:empty {\\n  display: none;\\n}\\n\\n.ya-unit-kebab_button svg circle {\\n  fill: var(--color-grey);\\n}\\n\\n.ya-unit-kebab_bg {\\n  background: transparent;\\n  opacity: 1.0;\\n}\\n\\n.ya-unit-kebab_icon {\\n  filter: var(--display-image, none);\\n}\\n\\n.ya-unit-kebab_icon circle {\\n  fill: var(--color-grey) !important;\\n}\\n\\n.ya-unit-kebab_button {\\n  position: absolute;\\n  z-index: 940;\\n  top: 4px;\\n  right: 4px;\\n  width: 24px;\\n  height: 24px;\\n}\\n\\n.yrw-body_warning {\\n  position: relative;\\n}\\n\\n.yrw-body_warning div {\\n  padding: 0;\\n}\\n\\n.yrw-body_warning div:not(.yrw-warning-wrapper):not(.yrw-warning-text) {\\n  position: relative;\\n  background-color: var(--color-light-alt);\\n  color: #575c66;\\n  display: flex;\\n  padding: 0 calc(var(--inner-border-radius) / 2);\\n}\\n\\n.yrw-body_warning div text {\\n  fill: #575c66;\\n}\\n\\n.yrw-body_warning div:not(.yrw-warning-wrapper) {\\n  padding: 0 calc(var(--inner-border-radius) / 2 + 4px);\\n}\\n\\n.yrw-warning-text {\\n  text-shadow: none;\\n}\\n\\n\\n\\n.unit-container {\\n  box-sizing: border-box;\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: flex-end;\\n  overflow: hidden;\\n  max-width: var(--content-max-width, --banner-max-width, 960px);\\n  margin: auto;\\n}\\n\\n.unit-content {\\n  position: relative;\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: flex-start;\\n  height: 100%;\\n  margin: 0;\\n  padding: 8px;\\n  padding: var(--banner-padding-outer);\\n  padding-top: 32px;\\n}\\n\\n.unit-text-content {\\n  display: flex;\\n  justify-content: flex-start;\\n  flex-direction: column;\\n  flex: auto;\\n}\\n\\n.rmp-app-content {\\n  display: flex;\\n  flex-direction: row;\\n}\\n\\n.rmp-text-content {\\n  display: flex;\\n  justify-content: center;\\n  flex-direction: column;\\n}\\n\\n.unit-text-content > div {\\n  margin-top: var(--banner-padding-inner);\\n}\\n\\n.rmp-text-content > div {\\n  margin-top: calc(var(--banner-padding-inner) / 2);\\n}\\n\\n.rmp-text-content > div:first-child {\\n  margin-top: 0;\\n}\\n\\n.unit-text-content > .unit-meta,\\n.rmp-text-content > .unit-meta {\\n  margin-top: 0;\\n}\\n\\n\\n\\n.ya-unit-title, .unit-title {\\n  color: var(--color-text-header);\\n  font-size: var(--font-size-title);\\n  line-height: var(--line-height-title);\\n  font-weight: 600;\\n  display: flex;\\n}\\n\\n.title-short {\\n  font-size: var(--font-size-title-short);\\n  line-height: var(--line-height-title-short);\\n}\\n\\n.title-mid {\\n  font-size: var(--font-size-title-mid);\\n  line-height: var(--line-height-title-mid);\\n}\\n\\n.title-long {\\n  font-size: var(--font-size-title-long);\\n  line-height: var(--line-height-title-long);\\n}\\n\\n.title-rmp {\\n  font-size: var(--font-size-title-rmp);\\n  line-height: var(--line-height-title-rmp);\\n\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: center;\\n}\\n\\n.unit-app-name {\\n  font-size: var(--font-size-app-name);\\n  line-height: var(--line-height-app-name);\\n  color: var(--color-text-app-name);\\n}\\n\\n\\n.unit-cta {\\n  display: flex;\\n  flex-direction: column;\\n  justify-content: center;\\n\\n  box-sizing: border-box;\\n  padding: 12px;\\n\\n  font-size: var(--domain-font-size);\\n  line-height: var(--domain-line-height);\\n  text-align: center;\\n\\n  color: var(--color-cta-color);\\n  background-color: var(--color-background-domain);\\n  border-radius: var(--banner-inner-border-radius);\\n  margin-top: var(--banner-padding-inner);\\n  transition: var(--cta-transition);\\n}\\n\\n.unit-cta:hover {\\n  color: var(--color-cta-hover-color);\\n  background-color: var(--color-background-domain-hover);\\n}\\n\\n\\n.unit-favicon {\\n  width: var(--line-height-domain);\\n  background-color: transparent;\\n  border-radius: 3px;\\n  align-self: center;\\n  display: var(--display-favicon, inline);\\n}\\n\\n.ya-unit-favicon {\\n  width: var(--line-height-domain);\\n  height: var(--line-height-domain);\\n}\\n\\n.ya-unit-rating {\\n  margin-right: 4px;\\n  height: 16px;\\n  display: inline;\\n}\\n\\n.ya-unit-review-count {\\n  display: var(--display-rmp-rating-count);\\n  transform: translateY(1px);\\n  color: var(--color-grey-alt);\\n  font-size: 13px;\\n  line-height: 16px;\\n}\\n\\n.unit-favicon:empty,\\n.ya-unit-domain:empty,\\n.unit-domain:empty {\\n  display: none;\\n}\\n\\n.unit-domain {\\n  display: flex;\\n  margin-right: auto;\\n  border-radius: 4px;\\n\\n  color: var(--color-text-domain);\\n  font-size: var(--font-size-domain);\\n  line-height: var(--line-height-domain);\\n  padding: 0;\\n\\n  width: 100%;\\n  height: var(--line-height-domain, 16px);\\n\\n  flex-direction: row;\\n  flex-wrap: wrap;\\n  justify-content: center;\\n  align-content: flex-end;\\n\\n  overflow: hidden;\\n}\\n\\n.unit-domain > *,\\n.unit-domain .unit-domain-no-wrap > * {\\n  margin-right: calc(var(--line-height-domain) / 3.5);\\n}\\n\\n.unit-domain span {\\n  flex: none;\\n}\\n\\n.unit-domain-no-wrap {\\n  display: flex;\\n}\\n\\n\\n\\n.unit-app-rating {\\n  display: flex;\\n  flex-direction: row;\\n  align-content: center;\\n}\\n\\n.unit-prices {\\n  display: var(--display-price, inline);\\n  white-space: nowrap;\\n\\n  font-size: var(--font-size-price);\\n  line-height: var(--line-height-price);\\n}\\n\\n.ya-unit-price {\\n  color: var(--color-text-price);\\n  font-weight: 600;\\n\\n  display: inline;\\n  white-space: nowrap;\\n}\\n\\n.ya-unit-old-price {\\n  margin-left: 8px;\\n  font-size: max(0.9em, 12px);\\n  line-height: max(0.9em, 12px);\\n  color: var(--color-grey-alt);\\n\\n  position: relative;\\n  white-space: nowrap;\\n  display: inline;\\n}\\n\\n.ya-unit-old-price::after {\\n  content: \\\"\\\";\\n  position: absolute;\\n  bottom: 0;\\n  left: 0;\\n  width: 100%;\\n  height: 100%;\\n  \\n  background-image: url(\\\"data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='100%' height='100%'><line class='line' x1='0' y1='65%' x2='100%' y2='50%' stroke='%23A3ACBF' stroke-width='8vh' /></svg>\\\");\\n  background-repeat: no-repeat;\\n}\\n\\n.unit-desc {\\n  display: var(--display-desc);\\n  color: var(--color-text-desc);\\n  font-size: var(--font-size-desc);\\n  line-height: var(--line-height-desc);\\n}\\n\\n\\n\\n.unit-image-block {\\n  display: var(--display-image);\\n  width: var(--image-width);\\n  max-width: var(--image-max-width, none);\\n  height: var(--image-height);\\n  flex: none;\\n  border-radius: var(--banner-inner-border-radius);\\n  position: relative;\\n\\n  box-sizing: border-box;\\n  background-color: var(--color-light-alt);\\n  overflow: hidden;\\n}\\n\\n.unit-image {\\n  width: 100%;\\n  height: 100%;\\n  display: var(--display-image);\\n  position: relative;\\n}\\n\\n.video-source-container {\\n  border-radius: var(--banner-inner-border-radius, 8px);\\n  z-index: 1;\\n  overflow: hidden;\\n}\\n\\n.ya-unit-app-icon {\\n  position: relative;\\n\\n  border-radius: calc(var(--app-icon-size) / 4);\\n  margin-right: var(--banner-padding-inner);\\n  display: flex;\\n}\\n\\n.unit-app-icon {\\n  margin: auto;\\n}\\n\\n.ya-unit-app-icon .yrw-img-component {\\n  width: var(--app-icon-size);\\n  height: var(--app-icon-size);\\n}\\n\\n.ya-unit-image {\\n  height: 100%;\\n}\\n\\n.yrw-img-component {\\n  height: 100%;\\n  padding-bottom: 0;\\n}\\n\\n.unit-image .img-source-component {\\n  border-radius: var(--banner-inner-border-radius);\\n  background-image: url(\\\"data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='256' height='256'><rect x='80' y='80' width='96' height='96' rx='19.2' fill='%23405580' fill-opacity='0.15'/><path d='M144.619 110.181H147.619C147.619 108.524 146.276 107.181 144.619 107.181V110.181ZM111.102 147.94L146.74 112.302L142.498 108.06L106.86 143.698L111.102 147.94ZM114.072 113.181H144.619V107.181L114.072 107.181V113.181ZM141.619 110.181V140.728H147.619V110.181L141.619 110.181Z' fill='white'/></svg>\\\");\\n  background-position: center;\\n}\\n\\n.ya-unit-app-icon .img-source-component {\\n  border-radius: calc(var(--app-icon-size) / 4 - 4px);\\n}\\n\\n.ya-clamp {\\n  width: 100%;\\n}\\n\\n.yrw-content {\\n  overflow: visible;\\n}\\n\\n.ya-grid-template:empty {\\n  display: none;\\n}\",\"gridColumns\":\"1\",\"gridRows\":\"1\",\"defaultWidth\":\"700\",\"props\":{}},{\"value\":\"24\",\"label\":\"300x600\",\"template\":\"<div class=\\\"wrapper\\\">\\n  <ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n    <div class=\\\"container\\\">\\n      <div class=\\\"image\\\">\\n        <ya-unit-image ratio=\\\"1\\\" />\\n        <div class=\\\"img-source\\\"></div>\\n      </div>\\n      <ya-clamp lines=\\\"3\\\" class=\\\"title\\\">\\n        <ya-unit-title />\\n      </ya-clamp>\\n      <ya-clamp lines=\\\"1\\\" class=\\\"category\\\">\\n        <ya-unit-category />\\n      </ya-clamp>\\n      <ya-clamp lines=\\\"1\\\" class=\\\"domain\\\">\\n        <ya-unit-domain />\\n      </ya-clamp>\\n    </div>\\n  </ya-units-grid>\\n</div>\\n\",\"css\":\".headline {\\n  font-size: 18px;\\n  line-height: 24px;\\n  color: #000;\\n  padding-bottom: 1px;\\n  padding-top: 1px;\\n}\\n\\n.grid-row {\\n  margin-top: 20px;\\n}\\n\\n.grid-item {\\n  margin-left: 10px;\\n}\\n\\n.unit-wrapper {\\n  width: 293px;\\n  height: 290px;\\n}\\n\\n.image {\\n  width: 293px;\\n  height: 290px;\\n}\\n\\n.container {\\n  width: 293px;\\n  height: 290px;\\n}\\n\\n.title {\\n  font-size: 26px;\\n  display: block;\\n  display: -webkit-box;\\n  overflow: hidden;\\n  max-height: 180px;\\n  line-height: 30px;\\n  text-overflow: ellipsis;\\n  color: #fff;\\n  width: 253px;\\n  font-weight: 900;\\n  word-break: break-word;\\n  word-wrap: break-word;\\n  text-decoration: none;\\n  margin-left: 20px;\\n  position: absolute;\\n  bottom: 60px;\\n  box-sizing: border-box;\\n}\\n\\n.meta {\\n  font-size: 13px;\\n}\\n\\n.category {\\n  padding-top: 0px;\\n  font-size: 13px;\\n  line-height: 15px;\\n  white-space: nowrap;\\n  color: #fff;\\n  position: absolute;\\n  bottom: 25px;\\n  box-sizing: border-box;\\n  margin: 20px 15px 0px 20px;\\n}\\n\\n.domain {\\n  margin-right: 15px;\\n  padding-top: 0px;\\n  font-size: 13px;\\n  line-height: 15px;\\n  white-space: nowrap;\\n  color: #8d96b2;\\n  margin-left: 90px;\\n  position: absolute;\\n  bottom: 25px;\\n  box-sizing: border-box;\\n}\\n\\n.unit-wrapper:hover .image {\\n  opacity: 0.9;\\n}\\n\\n.img-source:after {\\n  content: \\\"\\\";\\n  position: absolute;\\n  top: 0;\\n  bottom: 0;\\n  left: 0;\\n  right: 0;\\n  background-color: #000;\\n  opacity: 0.4;\\n}\\n\\n.ya-container {\\n  font-family: inherit!important;\\n}\\n\\n.ya-recommendation-widget {\\n  font-family: inherit!important;\\n}\\n\",\"gridColumns\":\"3\",\"gridRows\":\"1\",\"allowedOwnerIds\":[120143188],\"defaultWidth\":\"1000\",\"props\":{}},{\"value\":\"25\",\"label\":\"Desktop 3\",\"template\":\"<div class=\\\"wrapper\\\">\\n  <ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n    <div class=\\\"container\\\">\\n      <div class=\\\"image\\\">\\n        <ya-unit-image ratio=\\\"1\\\" />\\n        <div class=\\\"img-source\\\"></div>\\n      </div>\\n      <ya-clamp lines=\\\"3\\\" class=\\\"title\\\"><ya-unit-title /></ya-clamp>\\n      <ya-clamp lines=\\\"1\\\" class=\\\"category\\\"><ya-unit-category /></ya-clamp>\\n      <ya-clamp lines=\\\"1\\\" class=\\\"domain\\\"><ya-unit-domain /></ya-clamp>\\n    </div>\\n  </ya-units-grid>\\n</div>\\n\",\"css\":\".headline {\\n  font-size: 18px;\\n  line-height: 24px;\\n  color: #000;\\n  padding-bottom: 1px;\\n  padding-top: 1px;\\n}\\n\\n.grid-row {\\n  margin-top: 20px;\\n}\\n\\n.grid-item {\\n  margin-left: 23px;\\n}\\n\\n.unit-wrapper {\\n  width: 293px;\\n  height: 290px;\\n}\\n\\n.image {\\n  width: 293px;\\n  height: 290px;\\n}\\n\\n.container {\\n  max-width: 100%;\\n  max-width: 1240px;\\n  height: 290px;\\n}\\n\\n.title {\\n  font-size: 26px;\\n  display: block;\\n  display: -webkit-box;\\n  overflow: hidden;\\n  max-height: 180px;\\n  line-height: 30px;\\n  text-overflow: ellipsis;\\n  color: #fff;\\n  width: 253px;\\n  font-weight: 900;\\n  word-break: break-word;\\n  word-wrap: break-word;\\n  text-decoration: none;\\n  margin-left: 20px;\\n  position: absolute;\\n  bottom: 60px;\\n  box-sizing: border-box;\\n}\\n\\n.meta {\\n  font-size: 13px;\\n}\\n\\n.category {\\n  padding-top: 0px;\\n  font-size: 13px;\\n  line-height: 15px;\\n  white-space: nowrap;\\n  color: #fff;\\n  position: absolute;\\n  bottom: 25px;\\n  box-sizing: border-box;\\n  margin: 20px 15px 0px 20px;\\n}\\n\\n.domain {\\n  margin-right: 15px;\\n  padding-top: 0px;\\n  font-size: 13px;\\n  line-height: 15px;\\n  white-space: nowrap;\\n  color: #8d96b2;\\n  margin-left: 90px;\\n  position: absolute;\\n  bottom: 25px;\\n  box-sizing: border-box;\\n}\\n\\n.unit-wrapper:hover .image {\\n  opacity: 0.9;\\n}\\n\\n.img-source:after {\\n  content: \\\"\\\";\\n  position: absolute;\\n  top: 0;\\n  bottom: 0;\\n  left: 0;\\n  right: 0;\\n  background-color: #000;\\n  opacity: 0.4;\\n}\\n\\n.ya-container {\\n  font-family: inherit!important;\\n}\\n\\n.ya-recommendation-widget {\\n  font-family: inherit!important;\\n}\\n\",\"gridColumns\":\"3\",\"gridRows\":\"1\",\"allowedOwnerIds\":[120143188],\"defaultWidth\":\"1000\",\"props\":{}},{\"value\":\"26\",\"label\":\"Desktop 4\",\"template\":\"<div class=\\\"wrapper\\\">\\n  <ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n    <div class=\\\"container\\\">\\n      <div class=\\\"image\\\">\\n        <ya-unit-image ratio=\\\"1\\\" />\\n        <div class=\\\"img-source\\\"></div>\\n      </div>\\n      <ya-clamp lines=\\\"3\\\" class=\\\"title\\\"><ya-unit-title /></ya-clamp>\\n      <ya-clamp lines=\\\"1\\\" class=\\\"category\\\"><ya-unit-category /></ya-clamp>\\n      <ya-clamp lines=\\\"1\\\" class=\\\"domain\\\"><ya-unit-domain /></ya-clamp>\\n    </div>\\n  </ya-units-grid>\\n</div>\\n\",\"css\":\".headline {\\n  font-size: 18px;\\n  line-height: 24px;\\n  color: #000;\\n  padding-bottom: 1px;\\n  padding-top: 1px;\\n}\\n\\n.grid-row {\\n  margin-top: 20px;\\n}\\n\\n.grid-item {\\n  margin-left: 23px;\\n}\\n\\n.unit-wrapper {\\n  width: 293px;\\n  height: 290px;\\n}\\n\\n.image {\\n  width: 293px;\\n  height: 290px;\\n}\\n\\n.container {\\n  max-width: 100%;\\n  max-width: 1240px;\\n  height: 290px;\\n}\\n\\n.title {\\n  font-size: 26px;\\n  display: block;\\n  display: -webkit-box;\\n  overflow: hidden;\\n  max-height: 180px;\\n  line-height: 30px;\\n  text-overflow: ellipsis;\\n  color: #fff;\\n  width: 253px;\\n  font-weight: 900;\\n  word-break: break-word;\\n  word-wrap: break-word;\\n  text-decoration: none;\\n  margin-left: 20px;\\n  position: absolute;\\n  bottom: 60px;\\n  box-sizing: border-box;\\n}\\n\\n.meta {\\n  font-size: 13px;\\n}\\n\\n.category {\\n  padding-top: 0px;\\n  font-size: 13px;\\n  line-height: 15px;\\n  white-space: nowrap;\\n  color: #fff;\\n  position: absolute;\\n  bottom: 25px;\\n  box-sizing: border-box;\\n  margin: 20px 15px 0px 20px;\\n}\\n\\n.domain {\\n  margin-right: 15px;\\n  padding-top: 0px;\\n  font-size: 13px;\\n  line-height: 15px;\\n  white-space: nowrap;\\n  color: #8d96b2;\\n  margin-left: 90px;\\n  position: absolute;\\n  bottom: 25px;\\n  box-sizing: border-box;\\n}\\n\\n.unit-wrapper:hover .image {\\n  opacity: 0.9;\\n}\\n\\n.img-source:after {\\n  content: \\\"\\\";\\n  position: absolute;\\n  top: 0;\\n  bottom: 0;\\n  left: 0;\\n  right: 0;\\n  background-color: #000;\\n  opacity: 0.4;\\n}\\n\\n.ya-container {\\n  font-family: inherit!important;\\n}\\n\\n.ya-recommendation-widget {\\n  font-family: inherit!important;\\n}\\n\",\"gridColumns\":\"3\",\"gridRows\":\"1\",\"allowedOwnerIds\":[120143188],\"defaultWidth\":\"1000\",\"props\":{}},{\"value\":\"27\",\"label\":\"Mobile 100\",\"template\":\"<div class=\\\"wrapper\\\">\\n  <ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n    <div class=\\\"container\\\">\\n      <div class=\\\"image\\\">\\n        <ya-unit-image ratio=\\\"1\\\" />\\n        <div class=\\\"img-source\\\"></div>\\n      </div>\\n      <ya-clamp lines=\\\"3\\\" class=\\\"title\\\"><ya-unit-title /></ya-clamp>\\n      <ya-clamp lines=\\\"1\\\" class=\\\"category\\\"><ya-unit-category /></ya-clamp>\\n      <ya-clamp lines=\\\"1\\\" class=\\\"domain\\\"><ya-unit-domain /></ya-clamp>\\n      <ya-clamp lines=\\\"2\\\" class=\\\"warning\\\"><ya-unit-warning /></ya-clamp>\\n    </div>\\n  </ya-units-grid>\\n</div>\\n\",\"css\":\".headline {\\n  font-size: 18px;\\n  line-height: 24px;\\n  color: #000;\\n  padding-bottom: 1px;\\n  padding-top: 1px;\\n}\\n\\n.grid-row {\\n  margin-top: 20px;\\n}\\n\\n.grid-item {\\n  margin-left: 10px;\\n}\\n\\n.unit-wrapper {\\n  widthf: 100%;\\n  height: 250px;\\n}\\n\\n.image {\\n  width: 100%;\\n  height: 250px;\\n}\\n\\n.container {\\n  width: 100%;\\n  height: 250px;\\n}\\n\\n.title {\\n  font-size: 26px;\\n  display: block;\\n  display: -webkit-box;\\n  overflow: hidden;\\n  max-height: 180px;\\n  line-height: 30px;\\n  text-overflow: ellipsis;\\n  color: #fff;\\n  width: 253px;\\n  font-weight: 900;\\n  word-break: break-word;\\n  word-wrap: break-word;\\n  text-decoration: none;\\n  margin-left: 20px;\\n  position: absolute;\\n  bottom: 60px;\\n  box-sizing: border-box;\\n}\\n\\n.meta {\\n  font-size: 13px;\\n}\\n\\n.category {\\n  padding-top: 0px;\\n  font-size: 13px;\\n  line-height: 15px;\\n  white-space: nowrap;\\n  color: #fff;\\n  position: absolute;\\n  bottom: 25px;\\n  box-sizing: border-box;\\n  margin: 20px 15px 0px 20px;\\n}\\n\\n.domain {\\n  margin-right: 15px;\\n  padding-top: 0px;\\n  font-size: 13px;\\n  line-height: 15px;\\n  white-space: nowrap;\\n  color: #8d96b2;\\n  margin-left: 90px;\\n  position: absolute;\\n  bottom: 25px;\\n  box-sizing: border-box;\\n}\\n\\n.unit-wrapper:hover .image {\\n  opacity: 0.9;\\n}\\n\\n.img-source:after {\\n  content: \\\"\\\";\\n  position: absolute;\\n  top: 0;\\n  bottom: 0;\\n  left: 0;\\n  right: 0;\\n  background-color: #000;\\n  opacity: 0.4;\\n}\\n\\n.ya-container {\\n  font-family: inherit!important;\\n}\\n\\n.ya-recommendation-widget {\\n  font-family: inherit!important;\\n}\\n\\n.warning {\\n  position: absolute;\\n  bottom: 0;\\n  font-size: 13px;\\n  line-height: 15px;\\n  white-space: nowrap;\\n  color: #fff;\\n  margin: 0px 0px 0px 0px;\\n}\\n\",\"gridColumns\":\"3\",\"gridRows\":\"1\",\"allowedOwnerIds\":[120143188],\"defaultWidth\":\"1000\",\"props\":{}},{\"value\":\"28\",\"label\":\"Native 2\",\"template\":\"<div class=\\\"wrapper\\\">\\n  <ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n    <div class=\\\"container\\\">\\n      <div class=\\\"image\\\">\\n        <ya-unit-image ratio=\\\"1\\\" />\\n        <div class=\\\"img-source\\\"></div>\\n      </div>\\n      <ya-clamp lines=\\\"3\\\" class=\\\"title\\\"><ya-unit-title /></ya-clamp>\\n      <ya-clamp lines=\\\"1\\\" class=\\\"category\\\"><ya-unit-category /></ya-clamp>\\n      <ya-clamp lines=\\\"1\\\" class=\\\"domain\\\"><ya-unit-domain /></ya-clamp>\\n    </div>\\n  </ya-units-grid>\\n</div>\\n\",\"css\":\".headline {\\n  font-size: 18px;\\n  line-height: 24px;\\n  color: #000;\\n  padding-bottom: 1px;\\n  padding-top: 1px;\\n}\\n\\n.grid-row {\\n  margin-top: 20px;\\n}\\n\\n.grid-item {\\n  margin-left: 10px;\\n}\\n\\n.unit-wrapper {\\n  width: 293px;\\n  height: 290px;\\n}\\n\\n.image {\\n  width: 293px;\\n  height: 290px;\\n}\\n\\n.container {\\n  width: 293px;\\n  height: 290px;\\n}\\n\\n.title {\\n  font-size: 26px;\\n  display: block;\\n  display: -webkit-box;\\n  overflow: hidden;\\n  max-height: 180px;\\n  line-height: 30px;\\n  text-overflow: ellipsis;\\n  color: #fff;\\n  width: 253px;\\n  font-weight: 900;\\n  word-break: break-word;\\n  word-wrap: break-word;\\n  text-decoration: none;\\n  margin-left: 20px;\\n  position: absolute;\\n  bottom: 60px;\\n  box-sizing: border-box;\\n}\\n\\n.meta {\\n  font-size: 13px;\\n}\\n\\n.category {\\n  padding-top: 0px;\\n  font-size: 13px;\\n  line-height: 15px;\\n  white-space: nowrap;\\n  color: #fff;\\n  position: absolute;\\n  bottom: 25px;\\n  box-sizing: border-box;\\n  margin: 20px 15px 0px 20px;\\n}\\n\\n.domain {\\n  margin-right: 15px;\\n  padding-top: 0px;\\n  font-size: 13px;\\n  line-height: 15px;\\n  white-space: nowrap;\\n  color: #8d96b2;\\n  margin-left: 90px;\\n  position: absolute;\\n  bottom: 25px;\\n  box-sizing: border-box;\\n}\\n\\n.unit-wrapper:hover .image {\\n  opacity: 0.9;\\n}\\n\\n.img-source:after {\\n  content: \\\"\\\";\\n  position: absolute;\\n  top: 0;\\n  bottom: 0;\\n  left: 0;\\n  right: 0;\\n  background-color: #000;\\n  opacity: 0.4;\\n}\\n\\n.ya-container {\\n  font-family: inherit!important;\\n}\\n\\n.ya-recommendation-widget {\\n  font-family: inherit!important;\\n}\\n\",\"gridColumns\":\"3\",\"gridRows\":\"1\",\"allowedOwnerIds\":[120143188],\"defaultWidth\":\"1000\",\"props\":{}},{\"value\":\"drive2-0\",\"template\":\"<div class=\\\"wrapper\\\">\\n    <ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n    <div class=\\\"container\\\">\\n        <div class=\\\"image\\\">\\n            <ya-unit-image ratio=\\\"0.5625\\\"/>\\n        </div>\\n        <div class=\\\"title\\\">\\n            <span class=\\\"link\\\"><ya-unit-title/></span>\\n        </div>\\n        <div class=\\\"info\\\">\\n            <div class=\\\"domain\\\">\\n                <span class=\\\"link\\\"><ya-unit-domain/></span>\\n            </div>\\n            <div class=\\\"category\\\">\\n                <ya-unit-category/>\\n            </div>\\n        </div>\\n    </div>\\n    <ya-unit-close />\\n</ya-units-grid>\\n</div>\",\"name\":\"grid\",\"css\":\".unit-wrapper {\\n    height: 100%;\\n    background-color: #fff;\\n}\\n.container {\\n    position: relative;\\n    height: 100%;\\n    display: -webkit-box;\\n    display: flex;\\n    -webkit-box-orient: vertical;\\n    -webkit-box-direction: normal;\\n    flex-direction: column;\\n    font-family: sans-serif;\\n    line-height: 1.25;\\n    word-wrap: break-word;\\n    font-size: 18px;\\n    border-radius: 6px;\\n    background-color: #fff;\\n}\\n\\n.image {\\n    position: relative;\\n    border-radius: 6px 6px 0 0;\\n    overflow: hidden;\\n}\\n\\n.title {\\n    -webkit-box-flex: 1;\\n    flex: 1 1 auto;\\n    margin: 12px 10px;\\n    word-break: break-word;\\n    font-size: 18px;\\n    font-weight: bold;\\n    line-height: 21px;\\n}\\n\\n.info {\\n    display: -webkit-box;\\n    display: flex;\\n    margin: -7px 10px 14px;\\n    white-space: nowrap;\\n    font-size: 12px;\\n    line-height: 1.4;\\n}\\n\\n.category {\\n    color: #808080;\\n}\\n\\n.domain {\\n    -webkit-box-flex: 1;\\n    flex: 1 1 auto;\\n    min-width: 0;\\n    margin-right: 5px;\\n    overflow: hidden;\\n    font-weight: bold;\\n    -webkit-mask: linear-gradient(-90deg,rgba(0,0,0,0),#000 40px,#000);\\n    mask: linear-gradient(-90deg,rgba(0,0,0,0),#000 40px,#000);\\n}\\n\\n.link {\\n    color: #333;\\n}\\n\\n@media (max-width: 639px) {\\n    .container:before,\\n    .container {\\n        border-radius: 3px;\\n    }\\n\\n    .image {\\n        border-radius: 3px 3px 0 0;\\n    }\\n\\n    .title {\\n        margin: 10px;\\n        font-size: 15px;\\n        line-height: 18px;\\n    }\\n}\",\"gridColumns\":\"1\",\"gridRows\":\"1\",\"props\":{}},{\"value\":\"9\",\"template\":\"<div class=\\\"wrapper\\\">\\n  <ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n    <div class=\\\"card\\\">\\n      <div class=\\\"image\\\">\\n        <ya-unit-image ratio=\\\"1.21\\\" />\\n      </div>\\n      <div class=\\\"text-wrap\\\">\\n        <ya-clamp class=\\\"title\\\" lines=\\\"3\\\"><ya-unit-title /></ya-clamp>\\n        <ya-clamp class=\\\"desc\\\" lines=\\\"6\\\"><ya-unit-desc /></ya-clamp>\\n        <div class=\\\"shadow\\\"></div>\\n        <div>\\n          <span class=\\\"button\\\"><ya-unit-domain /></span>\\n        </div>\\n      </div>\\n    </div>\\n    <ya-unit-close />\\n  </ya-units-grid>\\n  <a class=\\\"icon-link\\\" href=\\\"https://direct.yandex.ru/?partner\\\" target=\\\"_blank\\\">\\n    <span class=\\\"icon-link__text\\\">Яндекс Директ</span>\\n    ₽\\n  </a>\\n</div>\\n\",\"css\":\".wrapper {\\n  width: 320px;\\n  height: 600px;\\n  background: #EBEDEE;\\n}\\n@media (max-width: 1020px) {\\n  .wrapper {\\n    width: 310px;\\n    margin: -5px;\\n  }\\n}\\n.grid-row {\\n  margin-top: 9px;\\n}\\n.grid-item {\\n  font-family: Arial, sans-serif;\\n  font-weight: normal;\\n}\\n.card {\\n  height: 194px;\\n  display: flex;\\n}\\n.unit-wrapper {\\n  background-color: #fff;\\n  border-radius: 6px;\\n}\\n.unit-wrapper:hover .button {\\n  background-color: rgba(0, 153, 255, 0.25);\\n}\\n.unit-image {\\n  height: 100%;\\n  width: 161px;\\n}\\n.image {\\n  height: 194px;\\n  border-top-left-radius: 6px;\\n  border-top-right-radius: 6px;\\n}\\n.text-wrap {\\n  position: relative;\\n  padding: 8px 10px;\\n  width: 139px;\\n}\\n@media (max-width: 1020px) {\\n  .text-wrap {\\n    width: 129px;\\n  }\\n}\\n.title {\\n  margin: 0 0 6px;\\n  font-size: 16px;\\n  line-height: 19px;\\n  font-weight: bold;\\n  color: #000;\\n}\\n.yrw-content {\\n  max-width: 50px;\\n}\\n.desc {\\n  position: relative;\\n  min-height: 102px;\\n  font-size: 12px;\\n  line-height: 16px;\\n  color: #7f7f7f;\\n}\\n.shadow {\\n  position: absolute;\\n  bottom: 21px;\\n  left: 0;\\n  z-index: 0;\\n  width: 100%;\\n  height: 34px;\\n  background-image: linear-gradient(180deg, rgba(255, 255, 255, 0) 0%, #fff 45%);\\n}\\n.button {\\n  position: absolute;\\n  z-index: 2;\\n  bottom: 10px;\\n  left: 0;\\n  margin: 12px 10px 0;\\n  padding: 6px 20px 7px 10px;\\n  display: block;\\n  width: max-content;\\n  max-width: calc(100% - 50px);\\n  background-color: #e6f4ff;\\n  border-radius: 5px;\\n  color: #0099ff;\\n  font-size: 13px;\\n  line-height: 15px;\\n  font-family: Arial, sans-serif;\\n  text-decoration: none;\\n  text-overflow: ellipsis;\\n  white-space: nowrap;\\n  overflow: hidden;\\n  outline: none;\\n}\\n.button::after {\\n  content: '';\\n  position: absolute;\\n  top: 0;\\n  right: 10px;\\n  width: 5px;\\n  height: 100%;\\n  background-image: url(\\\"data:image/svg+xml,%3Csvg width='5' height='10' fill='none' xmlns='http://www.w3.org/2000/svg'%3E%3Cpath d='M.465 9.5a.456.456 0 00.333-.14l4.054-4.013A.486.486 0 005 5a.461.461 0 00-.148-.347L.802.645A.46.46 0 00.466.5.462.462 0 000 .976c0 .125.051.249.133.337L3.855 5 .133 8.687A.495.495 0 000 9.024c0 .269.2.476.465.476z' fill='%2309F'/%3E%3C/svg%3E\\\");\\n  background-repeat: no-repeat;\\n  background-position: center center;\\n  color: #0099ff;\\n  font-size: 13px;\\n  line-height: 15px;\\n}\\n.icon-link {\\n  position: absolute;\\n  bottom: 174px;\\n  left: 269px;\\n  z-index: 959;\\n  display: flex;\\n  justify-content: center;\\n  align-items: center;\\n  width: 20px;\\n  height: 20px;\\n  font-size: 13px;\\n  font-family: Verdana, Geneva, Tahoma, sans-serif;\\n  color: rgba(255, 255, 255, 0.8);\\n  text-decoration: none;\\n  background-color: rgba(0, 0, 0, 0.5);\\n  border-bottom-left-radius: 5px;\\n  border-bottom-right-radius: 5px;\\n  opacity: 0.5;\\n}\\n@media (max-width: 1020px) {\\n  .icon-link {\\n    left: 264px;\\n  }\\n}\\n.icon-link::before {\\n  content: '';\\n  position: absolute;\\n  top: 2px;\\n  right: 20px;\\n  visibility: hidden;\\n  display: block;\\n  width: 5px;\\n  height: 16px;\\n}\\n.icon-link__text {\\n  position: absolute;\\n  top: 2px;\\n  right: 25px;\\n  visibility: hidden;\\n  padding: 2px 5px 3px 3px;\\n  display: block;\\n  border-radius: 1px;\\n  background-color: rgba(0, 0, 0, 0.5);\\n  font-size: 10px;\\n  color: #fff;\\n  white-space: nowrap;\\n}\\n.icon-link::after {\\n  content: '';\\n  position: absolute;\\n  top: 5px;\\n  right: 21px;\\n  visibility: hidden;\\n  width: 0;\\n  height: 0;\\n  border-style: solid;\\n  border-width: 4px 0 4px 4px;\\n  border-color: transparent transparent transparent rgba(0, 0, 0, 0.5);\\n  display: block;\\n}\\n.icon-link:hover {\\n  opacity: 1;\\n}\\n.icon-link:hover .icon-link__text {\\n  visibility: visible;\\n}\\n.icon-link:hover::before,\\n.icon-link:hover::after {\\n  visibility: visible;\\n}\\n\",\"gridColumns\":\"1\",\"gridRows\":\"3\",\"defaultWidth\":\"322\",\"props\":{}},{\"value\":\"10\",\"template\":\"<div class=\\\"wrapper\\\">\\n  <ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n    <div class=\\\"card\\\">\\n      <div class=\\\"text-wrap\\\">\\n        <ya-clamp lines=\\\"3\\\" class=\\\"title\\\"><ya-unit-title /></ya-clamp>\\n        <ya-clamp lines=\\\"5\\\" class=\\\"desc\\\"><ya-unit-desc /></ya-clamp>\\n        <span class=\\\"button\\\"><ya-unit-domain /></span>\\n      </div>\\n      <div class=\\\"image\\\">\\n        <ya-unit-image ratio=\\\"1\\\" />\\n      </div>\\n    </div>\\n    <ya-unit-close />\\n  </ya-units-grid>\\n  <a class=\\\"icon-link\\\" href=\\\"https://direct.yandex.ru/?partner\\\" target=\\\"_blank\\\">\\n  <span class=\\\"icon-link__text\\\">Яндекс Директ</span>\\n  &#8381;\\n  </a>\\n</div>\\n\",\"css\":\".wrapper {\\n  width: 100%;\\n  border-radius: 9px;\\n  position: relative;\\n}\\n.headline {\\n  line-height: 24px;\\n  color: #373e44;\\n  padding-bottom: 20px;\\n  padding-top: 15px;\\n}\\n.unit-wrapper {\\n  height: 100%;\\n  background-color: #eee;\\n  border-radius: 9px;\\n}\\n.card {\\n  display: flex;\\n  min-width: 500px;\\n}\\n.image {\\n  position: relative;\\n}\\n.image::after {\\n  content: '';\\n  position: absolute;\\n  top: 0;\\n  left: 0;\\n  width: 100px;\\n  height: 100%;\\n  background-image: linear-gradient(to right, rgba(238, 238, 238, 1) 0, rgba(238, 238, 238, 0.7) 40px, rgba(238, 238, 238, 0))\\n}\\n.text-wrap {\\n  position: relative;\\n  z-index: 1;\\n  margin-right: -30px;\\n  padding: 20px 0 20px 23px;\\n}\\n.title {\\n  color: #000;\\n  font-size: 20px;\\n  font-weight: bold;\\n  hyphens: auto;\\n}\\n.desc {\\n  padding-top: 12px;\\n  font-size: 14px;\\n  color: #000;\\n  opacity: 0.6;\\n  hyphens: auto;\\n}\\n.button {\\n  position: absolute;\\n  bottom: 20px;\\n  left: 23px;\\n  text-transform: uppercase;\\n  font-size: 14px;\\n  font-weight: bold;\\n  color: #000;\\n  opacity: 0.6;\\n}\\n.meta {\\n  color: #757575;\\n  font-size: 12px;\\n  padding-left: 10px;\\n  padding-right: 10px;\\n  padding-top: 7px;\\n  padding-bottom: 10px\\n}\\n.category {\\n  color: gray;\\n  padding-right: 20px;\\n}\\n.recommendation-label {\\n  color: red;\\n  text-align: left;\\n}\\n.unit-image {\\n  width: 360px;\\n  height: 320px;\\n}\\n.grid {\\n  display: flex;\\n  flex-direction: column;\\n  flex-wrap: wrap;\\n  justify-content: flex-start;\\n  align-items: stretch;\\n  align-content: flex-start;\\n  width: 100%;\\n  box-sizing: border-box;\\n  max-width: 640px;\\n}\\n.icon-link {\\n  position: absolute;\\n  top: 0;\\n  right: 22px;\\n  z-index: 959;\\n  display: flex;\\n  justify-content: center;\\n  align-items: center;\\n  width: 20px;\\n  height: 20px;\\n  font-size: 13px;\\n  font-family: Verdana, Geneva, Tahoma, sans-serif;\\n  color: #fff;\\n  text-decoration: none;\\n  background-color: rgba(0, 0, 0, 0.5);\\n  border-bottom-left-radius: 5px;\\n  border-bottom-right-radius: 5px;\\n  opacity: 0.5;\\n}\\n.icon-link::before {\\n  content: '';\\n  position: absolute;\\n  top: 2px;\\n  right: 20px;\\n  visibility: hidden;\\n  display: block;\\n  width: 5px;\\n  height: 16px;\\n}\\n.icon-link__text {\\n  position: absolute;\\n  top: 2px;\\n  right: 25px;\\n  visibility: hidden;\\n  padding: 2px 5px 3px 3px;\\n  display: block;\\n  border-radius: 1px;\\n  background-color: rgba(0, 0, 0, 0.5);\\n  font-size: 10px;\\n  color: #fff;\\n  white-space: nowrap;\\n}\\n.icon-link::after {\\n  content: '';\\n  position: absolute;\\n  top: 5px;\\n  right: 21px;\\n  visibility: hidden;\\n  width: 0;\\n  height: 0;\\n  border-style: solid;\\n  border-width: 4px 0 4px 4px;\\n  border-color: transparent transparent transparent rgba(0, 0, 0, 0.5);\\n  display: block;\\n}\\n.icon-link:hover {\\n  opacity: 1;\\n}\\n.icon-link:hover .icon-link__text {\\n  visibility: visible;\\n}\\n.icon-link:hover::before,\\n.icon-link:hover::after {\\n  visibility: visible;\\n}\\n\",\"gridColumns\":\"1\",\"gridRows\":\"1\",\"defaultWidth\":\"550\",\"props\":{}},{\"value\":\"12\",\"template\":\"<div class=\\\"wrapper\\\">\\n  <ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n    <div class=\\\"card\\\">\\n      <div class=\\\"image\\\">\\n        <ya-unit-image ratio=\\\"0.7\\\" />\\n      </div>\\n    </div>\\n    <div class=\\\"meta\\\">\\n      <ya-clamp lines=\\\"3\\\" class=\\\"title\\\"><ya-unit-title /></ya-clamp>\\n    <span class=\\\"category\\\"><ya-unit-category /></span>\\n    <span class=\\\"separator\\\">&#8226;</span>\\n    <span class=\\\"domain\\\"><ya-unit-domain /></span>\\n    </div>\\n  <span class=\\\"warning\\\"><ya-unit-warning /></span>\\n    <ya-unit-close />\\n  </ya-units-grid>\\n</div>\\n\",\"css\":\".headline {\\n  padding-bottom: 20px;\\n  padding-top: 15px;\\n}\\n.card {\\n  max-width: 250px;\\n}\\n.grid-row {\\n  margin-top: 10px;\\n}\\n.grid-item {\\n  margin-left: 10px;\\n}\\n.unit-wrapper {\\n  height: 100%;\\n  background-color: #fff;\\n}\\n.image {\\n  margin-bottom: 0px;\\n  max-width: 250px;\\n  min-width: 200px;\\n  max-height: 140px;\\n}\\n.title {\\n  color: #262626;\\n  font-weight: 700;\\n  font-stretch: normal;\\n  margin-top: 8px;\\n  font-size: 16px;\\n  line-height: 20px;\\n  font-family: Arial,Helvetica,sans-seriff;\\n}\\n.meta {\\n  max-width: 250px;\\n  max-height: 125px;\\n}\\n.category {\\n  font-family: Roboto,Arial,Helvetica,sans-serif;\\n  font-size: 10px;\\n  line-height: 20px;\\n  letter-spacing: 0.6px;\\n  text-transform: uppercase;\\n  color: #8d96b2;\\n  font-weight: 400;\\n  margin-top: 6px;\\n}\\n.separator {\\n  font-family: Roboto,Arial,Helvetica,sans-serif;\\n  font-size: 10px;\\n  line-height: 20px;\\n  letter-spacing: 1.3px;\\n  text-transform: uppercase;\\n  color: #8d96b2;\\n  font-weight: 400;\\n  margin-top: 6px;\\n}\\n.unit-image {\\n  max-width: 250px;\\n  max-height: 140px;\\n}\\n.grid {\\n  display: flex;\\n  flex-direction: column;\\n  flex-wrap: wrap;\\n  justify-content: flex-start;\\n  align-items: stretch;\\n  align-content: flex-start;\\n  width: 100%;\\n  box-sizing: border-box;\\n}\\n.domain {\\n  font-family: Roboto,Arial,Helvetica,sans-serif;\\n  font-size: 10px;\\n  line-height: 20px;\\n  letter-spacing: 0.6px;\\n  text-transform: uppercase;\\n  color: #8d96b2;\\n  font-weight: 400;\\n  margin-top: 6px;\\n}\\n.warning {\\n  display: none;\\n}\\n.unit-wrapper:hover .title {\\n  color: #315efb;\\n}\\n.unit-wrapper:hover .domain {\\n  color: #315efb;\\n}\\n.unit-wrapper:hover .category {\\n  color: #315efb;\\n}\\n\",\"gridColumns\":\"1\",\"gridRows\":\"1\",\"defaultWidth\":\"250\",\"props\":{}},{\"value\":\"15\",\"template\":\"<div class=\\\"wrapper\\\">\\n  <ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\" class=\\\"item\\\">\\n    <div class=\\\"header\\\">\\n      <div class=\\\"info\\\">\\n        <div class=\\\"avatar\\\"></div>\\n        <div class=\\\"about\\\">\\n          <ya-clamp lines=\\\"1\\\" class=\\\"title\\\">\\n            <ya-unit-title/>\\n          </ya-clamp>\\n          <div class=\\\"domain\\\">\\n            <ya-unit-domain class=\\\"domain-unit\\\" />\\n            <ya-unit-age class=\\\"age\\\" />\\n          </div>\\n        </div>\\n      </div>\\n    </div>\\n    <div class=\\\"body\\\">\\n      <ya-clamp lines=\\\"2\\\" class=\\\"description\\\">\\n        <ya-unit-desc/>\\n      </ya-clamp>\\n      <div class=\\\"image-wrapper\\\">\\n        <ya-unit-image class=\\\"image\\\" ratio=\\\"0.55\\\" />\\n      </div>\\n    </div>\\n    <div class=\\\"button\\\">\\n      <div class=\\\"button-icon\\\"></div>\\n      Перейти\\n    </div>\\n    <ya-unit-close />\\n  </ya-units-grid>\\n</div>\\n\",\"css\":\".unit-image {\\n  background: linear-gradient(0deg, rgba(0, 0, 0, 0.3), rgba(0, 0, 0, 0.3));\\n}\\n.unit-wrapper {\\n  min-width: 250px;\\n}\\n.age {\\n  font-family: YS Text;\\n  font-size: 12px;\\n  line-height: 16px;\\n  color: rgba(32, 35, 51, 0.7);\\n}\\n.age:before {\\n  content: ' · ';\\n}\\n.age:empty {\\n  display: none;\\n}\\n.body {\\n  position: relative;\\n}\\n.image-wrapper {\\n  position: relative;\\n  max-height: 166px;\\n  display: flex;\\n  flex-direction: row;\\n  flex-wrap: nowrap;\\n  justify-content: center;\\n  align-content: center;\\n  align-items: flex-end;\\n  overflow: hidden;\\n  box-shadow: inset 0 -1px 0 rgba(0, 0, 0, 0.1);\\n  border-radius: 8px;\\n  margin-top: 8px;\\n}\\n.image {\\n  width: 100%;\\n  border-radius: 8px;\\n}\\n.domain-unit {\\n  font-family: \\\"YS Text\\\";\\n  font-style: normal;\\n  font-weight: normal;\\n  font-size: 12px;\\n  line-height: 16px;\\n  color: #067aff;\\n}\\n.domain-unit:after {\\n  content: \\\" · Реклама\\\";\\n  color: rgba(32, 35, 51, 0.7);\\n}\\n.domain-unit:empty {\\n  display: none;\\n}\\n.button-icon {\\n  height: 15px;\\n  width: 14px;\\n  min-width: 14px;\\n  margin-right: 8px;\\n  background-image: url(\\\"data:image/svg+xml,%3Csvg width='14' height='15' fill='none' xmlns='http://www.w3.org/2000/svg'%3E%3Cpath d='M13 8.503a1 1 0 011 1v3a1.5 1.5 0 01-1.5 1.5h-11a1.5 1.5 0 01-1.5-1.5v-11a1.5 1.5 0 011.5-1.5h3a1 1 0 110 2H2v10h10v-2.5a1 1 0 011-1zm-1.7-6.716v-.323l-1.15.314a6.258 6.258 0 01-1.65.221c-.6 0-1-.447-1-1a1 1 0 011-1H13a1 1 0 011 1v4.504a1 1 0 01-1 1c-.552 0-1-.403-1-1a6.3 6.3 0 01.222-1.656l.313-1.147h-.32l-1.078 1.437a9.996 9.996 0 01-.93 1.072l-3.5 3.498a1 1 0 11-1.414-1.414l3.5-3.5c.334-.332.69-.64 1.065-.923L11.3 1.787z' fill='%23067AFF'/%3E%3C/svg%3E%0A\\\");\\n}\\n.button {\\n  background: rgba(6, 122, 255, 0.1);\\n  border-radius: 100px;\\n  font-family: \\\"YS Text\\\";\\n  font-style: normal;\\n  font-weight: 500;\\n  font-size: 14px;\\n  line-height: 20px;\\n  display: flex;\\n  flex-direction: row;\\n  flex-wrap: nowrap;\\n  justify-content: center;\\n  align-content: center;\\n  align-items: center;\\n  color: #067aff;\\n  padding: 8px 15px;\\n  margin-left: auto;\\n  margin-top: 12px;\\n}\\n.title {\\n  font-family: \\\"YS Text\\\";\\n  font-style: normal;\\n  font-weight: 500;\\n  font-size: 14px;\\n  line-height: 20px;\\n  color: #000;\\n}\\n.description {\\n  font-family: \\\"YS Text\\\";\\n  font-style: normal;\\n  font-weight: normal;\\n  font-size: 16px;\\n  line-height: 24px;\\n  color: #000;\\n}\\n.avatar {\\n  background: rgba(32, 35, 51, 0.07);\\n  border: 1px solid rgba(32, 35, 51, 0.07);\\n  box-sizing: border-box;\\n  border-radius: 100%;\\n  width: 44px;\\n  height: 44px;\\n  min-width: 44px;\\n  min-height: 44px;\\n  background-repeat: no-repeat;\\n  background-position: center center;\\n  background-image: url(\\\"data:image/svg+xml,%3Csvg width='13' height='18' fill='none' xmlns='http://www.w3.org/2000/svg'%3E%3Cpath d='M2.712 8.52V.792h4.056c1.792 0 3.184.392 4.176 1.176 1.008.784 1.512 1.968 1.512 3.552 0 .816-.144 1.52-.432 2.112a3.683 3.683 0 01-1.2 1.464c-.512.368-1.128.648-1.848.84-.72.176-1.52.264-2.4.264H4.968v2.04h5.016v1.68H4.968V18H2.712v-4.08H.744v-1.68h1.968V10.2H.744V8.52h1.968zm2.256-5.784V8.52h1.608c1.168 0 2.056-.24 2.664-.72.624-.496.936-1.256.936-2.28 0-.944-.272-1.64-.816-2.088-.528-.464-1.392-.696-2.592-.696h-1.8z' fill='%23202333' fill-opacity='.3'/%3E%3C/svg%3E%0A\\\");\\n}\\n.header {\\n  display: flex;\\n  flex-direction: row;\\n  flex-wrap: nowrap;\\n  justify-content: flex-start;\\n  align-content: center;\\n  align-items: center;\\n  margin-bottom: 10px;\\n}\\n.info {\\n  display: flex;\\n  flex-direction: row;\\n  flex-wrap: nowrap;\\n  justify-content: flex-start;\\n  align-content: stretch;\\n  align-items: stretch;\\n}\\n.about {\\n  display: flex;\\n  flex-direction: column;\\n  flex-wrap: nowrap;\\n  justify-content: center;\\n  align-items: flex-start;\\n  align-content: stretch;\\n  margin-left: 12px;\\n}\\n.close {\\n  display: none;\\n}\\n\",\"gridColumns\":\"1\",\"gridRows\":\"1\",\"defaultWidth\":\"300\",\"props\":{}},{\"value\":\"17\",\"template\":\"<div class=\\\"wrapper\\\">\\n  <ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n    <div class=\\\"box\\\">\\n      <div class=\\\"body\\\">\\n        <ya-clamp lines=\\\"2\\\" class=\\\"title\\\"><ya-unit-title /></ya-clamp>\\n        <div class=\\\"meta\\\">\\n          <span class=\\\"meta-group\\\">\\n            <ya-unit-category class=\\\"category\\\" />\\n            <ya-unit-domain class=\\\"domain\\\" />\\n          </span>\\n          <span class=\\\"desc\\\"><ya-unit-desc /></span>\\n          <span class=\\\"warning\\\"><ya-unit-warning /></span>\\n        </div>\\n      </div>\\n      <div class=\\\"image\\\">\\n        <ya-unit-image class=\\\"square\\\" ratio=\\\"1\\\" src=\\\"https://avatars.mds.yandex.net/get-ynews/1882860/a1300d270d02b90e0cda9a22993c9704/orig\\\" />\\n        <ya-unit-image class=\\\"rect\\\" ratio=\\\"0.5\\\" src=\\\"https://avatars.mds.yandex.net/get-ynews/1882860/a1300d270d02b90e0cda9a22993c9704/orig\\\" />\\n        <ya-unit-age class=\\\"age\\\" />\\n      </div>\\n    </div>\\n    <ya-unit-close />\\n  </ya-units-grid>\\n</div>\\n\",\"css\":\".wrapper {\\n  font-family: YS Text,Helvetica Neue,Arial,sans-serif;\\n  -webkit-font-feature-settings: \\\"liga\\\",\\\"kern\\\";\\n  -moz-font-feature-settings: \\\"liga\\\",\\\"kern\\\";\\n  font-feature-settings: \\\"liga\\\",\\\"kern\\\";\\n}\\n.unit-wrapper {\\n  overflow: visible;\\n  background: #fff;\\n}\\n.box {\\n  display: flex;\\n}\\n.image {\\n  position: relative;\\n  flex-shrink: 0;\\n}\\n.square {\\n  width: 64px;\\n}\\n.rect {\\n  display: none;\\n  width: 128px;\\n  margin-right: 5px;\\n}\\n.square,\\n.rect {\\n  position: relative;\\n  overflow: hidden;\\n  border-radius: 4px;\\n}\\n.square::after,\\n.rect::after {\\n  content: \\\"\\\";\\n  position: absolute;\\n  top: 0;\\n  right: 0;\\n  bottom: 0;\\n  left: 0;\\n  background: rgba(18,27,73,.05);\\n}\\n.age {\\n  position: absolute;\\n  z-index: 10;\\n  right: 3px;\\n  bottom: 3px;\\n  font-size: 8px;\\n  line-height: 12px;\\n  font-weight: 500;\\n  padding: 2px 1px 0;\\n  border-radius: 3px;\\n  min-width: 14px;\\n  color: #939cb0;\\n  background: #eceef2;\\n  opacity: 0.6;\\n}\\n.age:empty {\\n  display: none;\\n}\\n.body {\\n  padding-right: 12px;\\n  flex-grow: 1;\\n  position: relative;\\n  top: -2px;\\n}\\n.title {\\n  font-size: 16px;\\n  line-height: 18px;\\n  font-weight: 700;\\n  color: #000;\\n}\\n.unit-with-warning .desc {\\n  display: none;\\n}\\n.meta {\\n  font-size: 12px;\\n  line-height: 14px;\\n  margin-top: 4px;\\n  color: #939cb0;\\n  overflow: hidden;\\n  text-overflow: ellipsis;\\n  display: -webkit-box;\\n  -webkit-box-orient: vertical;\\n  -webkit-line-clamp: 2;\\n}\\n.meta-group {\\n  display: inline-flex;\\n}\\n.category {\\n  display: inline-flex;\\n}\\n.category:not(:empty)::after {\\n  content: ',\\\\00a0';\\n}\\n.domain {\\n  display: inline-block;\\n  overflow: hidden;\\n  white-space: nowrap;\\n  text-overflow: ellipsis;\\n  max-width: 170px;\\n}\\n.domain:not(:empty)::after {\\n  content: '•';\\n} \\n@media (orientation: landscape) {\\n  .title {\\n    font-size: 18px;\\n    line-height: 20px;\\n  }\\n\\n  .meta {\\n    font-size: 14px;\\n  }\\n}\\n@media (min-width: 495px) {\\n  .rect {\\n    display: block;\\n  }\\n\\n  .square {\\n    display: none;\\n  }\\n\\n  .unit-wrapper {\\n    padding: 12px 16px;\\n  }\\n}\\n@media (min-width: 490px) {\\n  .unit-wrapper {\\n    border-radius: 12px;\\n  }\\n}\\n@media (max-width: 320px) {\\n  .domain {\\n    max-width: 128px;\\n  }\\n}\\n\",\"gridColumns\":\"1\",\"gridRows\":\"1\",\"props\":{}},{\"value\":\"18\",\"template\":\"<div class=\\\"wrapper\\\">\\n  <ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n    <div class=\\\"box\\\">\\n      <div class=\\\"body\\\">\\n        <ya-clamp lines=\\\"2\\\" class=\\\"title\\\"><ya-unit-title /></ya-clamp>\\n        <div class=\\\"meta\\\">\\n          <ya-unit-category class=\\\"category\\\" /><span class=\\\"warning\\\"><ya-unit-warning /></span>\\n        </div>\\n      </div>\\n      <div class=\\\"image\\\">\\n        <ya-unit-image class=\\\"square\\\" ratio=\\\"1\\\" src=\\\"http://avatars.mds.yandex.net/get-ynews/1882860/a1300d270d02b90e0cda9a22993c9704/orig\\\" />\\n        <ya-unit-image class=\\\"rect\\\" ratio=\\\"0.5\\\" src=\\\"http://avatars.mds.yandex.net/get-ynews/1882860/a1300d270d02b90e0cda9a22993c9704/orig\\\" />\\n        <ya-unit-age class=\\\"age\\\" />\\n      </div>\\n    </div>\\n    <ya-unit-close />\\n  </ya-units-grid>\\n</div>\\n\",\"css\":\".wrapper {\\n  font-family: YS Text,Helvetica Neue,Arial,sans-serif;\\n  -webkit-font-feature-settings: \\\"liga\\\",\\\"kern\\\";\\n  -moz-font-feature-settings: \\\"liga\\\",\\\"kern\\\";\\n  font-feature-settings: \\\"liga\\\",\\\"kern\\\";\\n}\\n.unit-wrapper {\\n  overflow: visible;\\n  background: #fff;\\n}\\n.box {\\n  display: flex;\\n  flex-direction: row-reverse;\\n}\\n.image {\\n  position: relative;\\n  flex-shrink: 0;\\n}\\n.square {\\n  width: 64px;\\n}\\n.rect {\\n  display: none;\\n  width: 128px;\\n}\\n.square,\\n.rect {\\n  position: relative;\\n  overflow: hidden;\\n  border-radius: 4px;\\n}\\n.square::after,\\n.rect::after {\\n  content: \\\"\\\";\\n  position: absolute;\\n  top: 0;\\n  right: 0;\\n  bottom: 0;\\n  left: 0;\\n  background: rgba(18,27,73,.05);\\n} \\n.age {\\n  position: absolute;\\n  z-index: 10;\\n  left: 3px;\\n  top: 3px;\\n  font-size: 8px;\\n  line-height: 12px;\\n  font-weight: 500;\\n  padding: 2px 1px 0;\\n  border-radius: 3px;\\n  mid-width: 14px;\\n  color: #939cb0;\\n  background: #eceef2;\\n  opacity: 0.6;\\n} \\n.age:empty {\\n  display: none;\\n}\\n.body {\\n  padding-left: 12px;\\n  flex-grow: 1;\\n  position: relative;\\n  top: -2px;\\n  margin: auto 0;\\n}\\n.title {\\n  font-size: 16px;\\n  line-height: 18px;\\n  font-weight: 700;\\n  color: #000;\\n} \\n.meta {\\n  font-size: 12px;\\n  line-height: 14px;\\n  margin-top: 4px;\\n  color: #000;\\n  overflow: hidden;\\n  text-overflow: ellipsis;\\n  display: -webkit-box;\\n  -webkit-box-orient: vertical;\\n  -webkit-line-clamp: 2;\\n}\\n.category {\\n  display: inline-flex;\\n}\\n@media (orientation: landscape) {\\n  .title {\\n    font-size: 18px;\\n    line-height: 20px;\\n  }\\n\\n  .meta {\\n    font-size: 14px;\\n  }\\n}\\n@media (min-width: 495px) {\\n  .unit-wrapper {\\n    padding: 12px 16px;\\n  }\\n}\\n@media (min-width: 321px) {\\n  .rect {\\n    display: block;\\n  }\\n\\n  .square {\\n    display: none;\\n  }\\n}\\n@media (min-width: 490px) {\\n  .unit-wrapper {\\n    border-radius: 12px;\\n  }\\n}\\n.warning .ya-grid-template:not(:empty)::before {\\n  content: '.'; \\n}\\n\",\"gridColumns\":\"1\",\"gridRows\":\"1\",\"props\":{}},{\"value\":\"19\",\"template\":\"<div class=\\\"wrapper\\\">\\n    <ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n  <div class=\\\"image\\\">\\n    <div class=\\\"disclaimer\\\">₽</div>\\n      <ya-unit-image ratio=\\\"0.5\\\" />\\n  </div>\\n  <ya-clamp lines=\\\"2\\\" class=\\\"title\\\">\\n    <ya-unit-title />\\n  </ya-clamp>\\n  <div class=\\\"meta\\\">\\n    <span class=\\\"domain\\\">\\n      <ya-unit-domain />\\n    </span>\\n  </div>\\n  <ya-unit-close />\\n</ya-units-grid>\\n</div>\",\"css\":\".unit-wrapper {\\n  font-family: YS Text, Helvetica, Arial, sans-serif;\\n  min-width: 250px;\\n  padding: 16px 0;\\n  border-bottom: solid 1px #e5e5e5;\\n}\\n.grid-row:first-child .unit-wrapper {\\n  padding-top: 0;\\n}\\n.image {\\n  position: relative;\\n}\\n.disclaimer {\\n  position: absolute;\\n  top: 0;\\n  right: 25px;\\n  z-index: 10;\\n  font-size: 11px;\\n  line-height: 20px;\\n  color: #fff;\\n  background: rgba(0, 0, 0, 0.5);\\n  opacity: 0.5;\\n  width: 20px;\\n  height: 20px;\\n  text-align: center;\\n  border-bottom-left-radius: 4px;\\n  border-bottom-right-radius: 4px;\\n}\\n.title {\\n  font-size: 16px;\\n  line-height: 20px;\\n  font-weight: 500;\\n  padding: 12px 0 0;\\n  color: #222;\\n  transition: color 0.1s ease-out;\\n}\\n.unit-wrapper:hover .title {\\n  color: #d00;\\n}\\n.meta {\\n  font-size: 13px;\\n  line-height: 16px;\\n  padding: 4px 0 0;\\n  color: #999;\\n}\\n\",\"gridColumns\":\"1\",\"gridRows\":\"1\",\"defaultWidth\":\"300\",\"props\":{}},{\"value\":\"20\",\"template\":\"<div class=\\\"wrapper\\\">\\n    <ya-units-grid class=\\\"wrapper\\\" cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n  <div class=\\\"category\\\">\\n    <ya-unit-category />\\n  </div>\\n  <div class=\\\"image\\\">\\n    <ya-unit-image class=\\\"portrait\\\" ratio=\\\"0.5\\\" />\\n    <ya-unit-image class=\\\"square\\\" ratio=\\\"1\\\" />\\n    <ya-unit-age class=\\\"unit-age\\\" />\\n    <div class=\\\"warning\\\">\\n      <i class=\\\"warning__center\\\"></i>\\n      <i class=\\\"warning__right\\\"></i>\\n      <span class=\\\"warning__wrap\\\">\\n        <ya-unit-warning class=\\\"unit-warning\\\" />\\n      </span>\\n    </div>\\n  </div>\\n  <div class=\\\"box\\\" />\\n    <ya-clamp lines=\\\"2\\\" class=\\\"title\\\">\\n      <ya-unit-title />\\n    </ya-clamp>\\n    <ya-clamp lines=\\\"3\\\" class=\\\"desc\\\">\\n        <ya-unit-desc />\\n    </ya-clamp>\\n    <div class=\\\"domain\\\">\\n      <ya-unit-domain class=\\\"unit-domain\\\" />\\n    </div>\\n    <ya-clamp lines=\\\"2\\\" class=\\\"warning\\\">\\n      <ya-unit-warning class=\\\"unit-warning\\\" />\\n    </ya-clamp>\\n  </div>\\n  <ya-unit-close />\\n</ya-units-grid>\\n</div>\",\"css\":\".grid {\\n  font-family: YS Text,Helvetica Neue,Arial,sans-serif;\\n  -webkit-font-feature-settings: \\\"liga\\\",\\\"kern\\\";\\n  -moz-font-feature-settings: \\\"liga\\\",\\\"kern\\\";\\n  font-feature-settings: \\\"liga\\\",\\\"kern\\\";\\n  overflow: hidden;\\n  background: #fff;\\n  border-radius: 12px;\\n}\\n.unit-age:empty,\\n.unit-domain:empty,\\n.unit-wrapper:not(.unit-with-warning) .warning,\\n.grid-row:first-child .square,\\n.grid-row:first-child .box .warning,\\n.grid-row:not(:first-child) .category,\\n.grid-row:not(:first-child) .portrait,\\n.grid-row:not(:first-child) .image .warning,\\n.grid-row:not(:first-child) .desc {\\n  display: none;\\n}\\n.unit-wrapper {\\n  position: relative;\\n  min-width: 250px;\\n}\\n.category {\\n  font-size: 10px;\\n  line-height: 12px;\\n  position: absolute;\\n  top: 0;\\n  left: 12px;\\n  display: block;\\n  padding: 2px 4px;\\n  z-index: 10;\\n  border-radius: 0 0 4px 4px;\\n}\\n.unit-age {\\n  position: absolute;\\n  z-index: 20;\\n  text-align: center;\\n  border-radius: 4px;\\n}\\n.category,\\n.unit-age {\\n  color: #222426;\\n  background: #eceef2;\\n  opacity: 0.6;\\n}\\n.square .unit-image {\\n  width: 88px;\\n  border-radius: 6px;\\n}\\n.grid-row:not(:first-child) .unit-container {\\n  display: flex;\\n  flex-direction: row-reverse;\\n}\\n.box {\\n  flex-grow: 1;\\n  padding-right: 12px;\\n}\\n.image {\\n  position: relative;\\n  flex-shrink: 0;\\n  flex-grow: 0;\\n  margin-bottom: auto;\\n}\\n.image::before {\\n  content: '';\\n  display: block;\\n  position: absolute;\\n  top: 0;\\n  right: 0;\\n  bottom: 0;\\n  left: 0;\\n  z-index: 5;\\n  background: rgba(34, 36, 38, 0.05);\\n  border-radius: 6px;\\n}\\n.grid-row:first-child .unit-age {\\n  font-size: 10px;\\n  line-height: 13px;\\n  right: 12px;\\n  bottom: 8px;\\n  padding: 2px 2px 1px;\\n  min-width: 16px;\\n}\\n.grid-row:first-child .unit-with-warning .unit-age {\\n  bottom: 32px;\\n}\\n.grid-row:first-child .unit-with-warning .warning {\\n  font-size: 11px;\\n  line-height: 14px;\\n  position: absolute;\\n  right: 0;\\n  bottom: 0;\\n  left: 0;\\n  overflow: hidden;\\n  padding: 5px 7px;\\n  white-space: nowrap;\\n  color: #fff;\\n  text-shadow: 0 1px 1px rgba(0, 0, 0, 0.3);\\n  background: rgba(0, 0, 0, 0.3);\\n}\\n.grid-row:first-child .unit-warning {\\n  display: inline-block;\\n  min-width: 100%;\\n  animation: 7s 0.3s 1 warning-content;\\n}\\n.warning__wrap {\\n  display: block;\\n  max-width: 100%;\\n  animation: 7s 0.3s 1 warning-wrap;\\n}\\n.warning__wrap,\\n.grid-row:first-child .unit-warning {\\n  transition: transform 1s;\\n}\\n.warning__right,\\n.warning__center {\\n  position: absolute;\\n  top: 0;\\n  bottom: 0;\\n  width: 30%;\\n  z-index: 10;\\n  animation: 8.3s hide-controls;\\n}\\n.warning__right {\\n  right: 0;\\n}\\n.warning__center {\\n  width: auto;\\n  left: 30%;\\n  right: 30%;\\n}\\n@keyframes warning-content {\\n  0% {\\n    transform: translateX(0);\\n  }\\n  35% {\\n    transform: translateX(-100%);\\n  }\\n  65% {\\n    transform: translateX(-100%);\\n  }\\n  100% {\\n    transform: translateX(0);\\n  }\\n}\\n@keyframes warning-wrap {\\n  0% {\\n    transform: translateX(0);\\n  }\\n  35% {\\n    transform: translateX(100%);\\n  }\\n  65% {\\n    transform: translateX(100%);\\n  }\\n  100% {\\n    transform: translateX(0);\\n  }\\n}\\n@keyframes hide-controls {\\n  0% {\\n    transform: translateY(0);\\n  }\\n  5% {\\n    transform: translateY(100%);\\n  }\\n  95% {\\n    transform: translateY(100%);\\n  }\\n  100% {\\n    transform: translateY(0);\\n  }\\n}\\n.warning__right:hover ~ .warning__wrap {\\n  transform: translateX(100%);\\n}\\n.warning__right:hover ~ .warning__wrap .unit-warning {\\n  transform: translateX(-100%);\\n}\\n.warning__center:hover ~ .warning__wrap {\\n  transform: translateX(50%);\\n}\\n.warning__center:hover ~ .warning__wrap .unit-warning {\\n  transform: translateX(-50%);\\n}\\n.grid-row:not(:first-child) .unit-age {\\n  font-size: 8px;\\n  line-height: 12px;\\n  font-weight: 500;\\n  right: 3px;\\n  bottom: 3px;\\n  padding: 2px 1px 0;\\n  min-width: 14px;\\n}\\n.title {\\n  font-size: 18px;\\n  line-height: 22px;\\n  font-weight: 700;\\n  color: #222426;\\n}\\n.unit-wrapper:hover .title {\\n  color: #d00;\\n}\\n.grid-row:first-child .title {\\n  font-size: 20px;\\n  line-height: 24px;\\n  margin-top: 12px;\\n}\\n.desc {\\n  font-size: 16px;\\n  line-height: 20px;\\n  margin-top: 2px;\\n  color: #222426;\\n}\\n.domain {\\n  margin-top: 2px;\\n}\\n.domain,\\n.box .warning {\\n  font-size: 12px;\\n  line-height: 14px;\\n  color: #939cb0;\\n}\\n.grid-row:first-child .domain {\\n  margin-top: 4px;\\n}\\n.grid-row:first-child .box {\\n  padding: 0 12px 12px;\\n}\\n.grid-row:not(:first-child) .unit-wrapper {\\n  padding: 0 12px 12px;\\n}\\n.grid-row:not(:first-child) .unit-container {\\n  padding-top: 12px;\\n  border-top: 1px solid #e9ebef;\\n}\\n@media (max-width: 1599px) {\\n  .square .unit-image {\\n    width: 80px;\\n  }\\n  .title {\\n    font-size: 16px;\\n    line-height: 18px;\\n  }\\n  .grid-row:first-child .title {\\n    font-size: 18px;\\n    line-height: 22px;\\n  }\\n  .grid-row:not(:first-child) .title {\\n    margin-top: -2px;\\n  }\\n}\\n\",\"gridColumns\":\"1\",\"gridRows\":\"3\",\"props\":{}},{\"value\":\"21\",\"template\":\"<div class=\\\"wrapper\\\">\\n  <ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n    <div class=\\\"lol\\\">\\n      <div class=\\\"image\\\">\\n        <ya-unit-image ratio=\\\"1\\\" />\\n      </div>\\n      <div class=\\\"meta\\\">\\n        <ya-unit-category ad-only />\\n      </div>\\n      <ya-clamp lines=\\\"2\\\" class=\\\"title\\\">\\n        <ya-unit-title />\\n      </ya-clamp>\\n    </div>\\n    <ya-unit-close />\\n  </ya-units-grid>\\n</div>\\n\",\"css\":\".headline {\\n  font-family: Arial, Helvetica, sans-serif;\\n  font-weight: 400;\\n  font-size: 18px;\\n  line-height: 1.2;\\n  margin: 0 0 20px;\\n  color: #7f7f7f;\\n  text-transform: uppercase;\\n  padding-top: 12px;\\n  text-align: left;\\n  border-top: 1px solid #c6c6c6;\\n}\\n.grid {\\n  padding-bottom: 10px;\\n  border-bottom: 1px solid #F0F0F0;\\n}\\n.grid-row {\\n  margin-top: 10px;\\n}\\n.grid-item {\\n  width: 23.5%;\\n  margin: 0 7px;\\n}\\n.unit-wrapper {\\n  height: 100%;\\n  background-color: #fff;\\n}\\n.image {\\n  margin-bottom: 0px;\\n}\\n.unit-image {\\n  border-radius: 50%;\\n  transition: all 0.3s;\\n}\\n.title {\\n  font-family: Verdana, sans;\\n  font-weight: 400;\\n  font-size: 11px;\\n  line-height: 16px;\\n  padding: 0;\\n  color: #000;\\n  opacity: 0.9;\\n  text-align: center;\\n  min-height: 32px;\\n  width: 100%;\\n  float: left;\\n}\\n.unit-wrapper:hover .unit-image {\\n  border-radius: 8px;\\n}\\n.unit-wrapper:hover .title {\\n  text-decoration: underline;\\n}\\n.lol {\\n  overflow: hidden;\\n}\\n.meta {\\n  font-family: Verdana, sans;\\n  font-size: 10px;\\n  float: right;\\n  margin-top: -22px;\\n  margin-right: 5px;\\n  padding: 2px 3px 3px 5px;\\n  border-radius: 2px;\\n  color: #fff;\\n  position: relative;\\n  background: rgba(0, 0, 0, 0.3);\\n}\\n.unit-warning {\\n  position: relative;\\n  height: 24px;\\n}\\nya-units-grid[cols=\\\"1\\\"] .meta, ya-units-grid[cols=\\\"2\\\"] .meta, ya-units-grid[cols=\\\"3\\\"] .meta {\\n  position: absolute;\\n  top: 5px;\\n  right: 5px;\\n  margin-top: 0px;\\n  margin-right: 0px;\\n}\",\"gridColumns\":\"3\",\"gridRows\":\"1\",\"props\":{}},{\"value\":\"22\",\"template\":\"<div class=\\\"wrapper\\\">\\n    <ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n  <ya-clamp lines=\\\"2\\\" class=\\\"title\\\">\\n    <ya-unit-title />\\n  </ya-clamp>\\n  <div class=\\\"desc\\\">\\n    <ya-unit-desc />\\n  </div>\\n  <div class=\\\"category-wrapper\\\">\\n    <span class=\\\"category\\\">\\n      <ya-unit-category />\\n    </span>\\n  </div>\\n  <ya-unit-close />\\n</ya-units-grid>\\n</div>\",\"css\":\".grid-item {\\n  margin: 0;\\n}\\n.unit-warning {\\n  margin-top: 20px !important;\\n}\\n.unit-wrapper {\\n  min-width: 400px;\\n  display: block;\\n  background-color: #fff;\\n  border: 1px solid #f2f2f2;\\n  border-radius: 3px;\\n  -webkit-box-shadow: 0 3px 8px rgba(0, 0, 0, .05);\\n  box-shadow: 0 3px 8px rgba(0, 0, 0, .05);\\n  padding: 12px;\\n  position: relative;\\n  margin-bottom: 10px;\\n  -webkit-transition: all .3s;\\n  transition: all .3s;\\n}\\n.title {\\n  font-family: 'Open Sans', 'Segoe UI', Arial, Tahoma, Geneva, Verdana, sans-serif;\\n  font-weight: bold;\\n  display: block;\\n  width: 100%;\\n  color: #199edb;\\n  font-weight: 700;\\n  font-size: 16px;\\n  line-height: 22px;\\n  word-break: break-word;\\n}\\n.desc {\\n  font-family: 'Open Sans', 'Segoe UI', Arial, Tahoma, Geneva, Verdana, sans-serif;\\n  color: #444;\\n  font-size: 13px;\\n  line-height: 16px;\\n  word-break: break-word;\\n  max-height: 53px;\\n  overflow: hidden;\\n  margin: 6px 0;\\n}\\n.category {\\n  font-family: 'Open Sans', 'Segoe UI', Arial, Tahoma, Geneva, Verdana, sans-serif;\\n  font-weight: 400;\\n  font-size: 11px;\\n  color: #4e4e4e;\\n  opacity: 0.6;\\n  vertical-align: top;\\n  line-height: 16px;\\n  margin-right: 20px;\\n}\\n.category-wrapper {\\n  margin-top: 10px;\\n  display: -webkit-box;\\n  display: -ms-flexbox;\\n  display: flex;\\n  justify-content: end;\\n}\\n@media screen and (min-width:992px) {\\n  .unit-wrapper {\\n    padding: 25px 22px;\\n  }\\n  .unit-wrapper:hover {\\n    -webkit-box-shadow: 0 6px 26px rgba(0, 0, 0, .09);\\n    box-shadow: 0 6px 26px rgba(0, 0, 0, .09);\\n  }\\n  .title {\\n    font-size: 23px;\\n    line-height: 28px;\\n  }\\n  .category {\\n    position: absolute;\\n    top: 0px;\\n    right: 5px;\\n  }\\n  .category-wrapper {\\n    margin-top: 0;\\n  }\\n}\\n\",\"gridColumns\":\"1\",\"gridRows\":\"1\",\"props\":{}},{\"value\":\"23\",\"template\":\"<div class=\\\"wrapper\\\">\\n  <ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n    <div class=\\\"lol\\\">\\n      <div class=\\\"image\\\">\\n        <ya-unit-image ratio=\\\"1\\\" />\\n      </div>\\n      <div class=\\\"text\\\">\\n        <div class=\\\"title\\\">\\n          <ya-unit-title />\\n        </div>\\n        <div class=\\\"meta\\\">\\n          <span class=\\\"category\\\"><ya-unit-category /></span>\\n        </div>\\n        <div>\\n          <span class=\\\"button\\\"><ya-unit-domain /></span>\\n        </div>\\n      </div>\\n    </div>\\n    <ya-unit-close />\\n  </ya-units-grid>\\n</div>\\n\",\"css\":\"@charset \\\"UTF-8\\\";\\n.grid, .grid-row, .wrapper {\\n  height: 100%;\\n}\\n.headline {\\n  font-size: 15px;\\n  font-weight: 700;\\n  line-height: 18px;\\n  color: #373e44;\\n  padding-bottom: 20px;\\n  padding-top: 15px;\\n}\\n.button, .category, .meta, .title, .title:hover, .unit-wrapper:hover .title {\\n  color:#444;\\n}\\n.grid-row {\\n  margin-top: 10px;\\n}\\n.grid-item {\\n  margin-left: 20px;\\n  min-height: 400px;\\n}\\n.unit-wrapper {\\n  min-width: 250px;\\n  max-width: 350px;\\n  height: 100%;\\n  background-color: #fff;\\n  border-radius: 0;\\n  border: none;\\n}\\n.text {\\n  padding: 12px 15px 0px;\\n}\\n.title {\\n  line-height: 24px;\\n  font-size: 18px;\\n  font-weight: 700;\\n  text-decoration: none;\\n}\\n.title:hover {\\n  text-decoration: underline;\\n}\\n.meta {\\n  font-size: 14px;\\n  line-height: 22px;\\n  margin-bottom: 15px;\\n}\\n.category {\\n  padding-right: 0;\\n  padding-left: 0;\\n  opacity: 0.6;\\n  font: 300 14px/1.3;\\n}\\n.button, .button * {\\n  white-space: nowrap;\\n  overflow: hidden;\\n  font-size: 13px;\\n  line-height: 31px;\\n  font-weight: 700;\\n  text-transform: uppercase;\\n  text-align: center;\\n  text-overflow: ellipsis;\\n  display: block;\\n}\\n.unit-image {\\n  min-height: 219px;\\n  height: 219px;\\n  border-bottom: solid 1px #f1f1f1;\\n}\\n.button {\\n  background: #efbf00;\\n  border-radius: 5px;\\n  line-height: 30px;\\n  outline: 0;\\n  padding: 5px 0;\\n  z-index: 10;\\n  transition: all .5s;\\n}\\n.button:hover {\\n  background:#e9bb05;\\n  color:#444;\\n}\\n\",\"gridColumns\":\"1\",\"gridRows\":\"1\",\"defaultWidth\":\"300\",\"props\":{}}]"),
    (0, NOW(), NOW(), 'ContentContextRuTemplates', "[{\"value\":\"1\",\"name\":\"grid\",\"label\":\"4x2 картинка сверху\",\"props\":{},\"template\":\"<div class=\\\"block\\\">\\n    <div class=\\\"headline\\\">Читайте также</div>\\n    <ya-units-grid rows=\\\"${grid_rows}\\\" cols=\\\"${grid_columns}\\\">\\n        <div class=\\\"unit\\\">\\n            <div class=\\\"image\\\">\\n                <ya-unit-image ratio=\\\"0.5\\\" />\\n            </div>\\n            <div class=\\\"body\\\">\\n                <div class=\\\"title\\\">\\n                    <ya-clamp lines=\\\"3\\\"><ya-unit-title /></ya-clamp>\\n                </div>\\n                <div class=\\\"meta\\\">\\n                    <ya-unit-category class=\\\"category\\\"/>\\n                    <ya-unit-date class=\\\"date\\\"/>\\n                    <ya-unit-domain class=\\\"domain\\\"/>\\n                </div>\\n            </div>\\n        </div>\\n        <ya-unit-kebab />\\n    </ya-units-grid>\\n    <ya-recommendation-label />\\n</div>\",\"css\":\".block {\\n    padding: 15px 0;\\n}\\n.block-label {\\n    display: block;\\n    width: 100%;\\n    margin-top: 16px;\\n    text-align: right;\\n}\\n.label {\\n    display: block;\\n    font-family: Helvetica, Arial, sans-serif;\\n    font-size: 12px;\\n    color: #999999;\\n}\\n.headline {\\n    font-family: \\\"Open Sans\\\", Arial, sans-serif;\\n    font-size: 18px;\\n    font-weight: bold;\\n    line-height: 24px;\\n    color: #373e44;\\n    padding-bottom: 20px;\\n    padding-top: 15px;\\n}\\n.grid {\\n    display: flex;\\n    flex-direction: column;\\n    flex-wrap: wrap;\\n    justify-content: flex-start;\\n    align-items: stretch;\\n    align-content: flex-start;\\n    width: 100%;\\n    box-sizing: border-box;\\n}\\n.grid-row {\\n    position: relative;\\n    display: flex;\\n    flex-direction: row;\\n    flex-wrap: nowrap;\\n    justify-content: flex-start;\\n    align-items: stretch;\\n    align-content: flex-start;\\n    width: 100%;\\n    margin-top: 10px;\\n}\\n.grid-row:first-child {\\n    margin-top: 0;\\n}\\n.grid-item {\\n    position: relative;\\n    flex: 1 1 0px;\\n    margin-left: 10px;\\n}\\n.grid-item:first-child {\\n    margin-left: 0;\\n}\\n.unit-wrapper {\\n    position: relative;\\n    display: flex;\\n    box-sizing: border-box;\\n    margin: 0 auto;\\n    overflow: hidden;\\n        font-family: \\\"Open Sans\\\", Arial, sans-serif;\\n        width: 100%;\\n        height: 100%;\\n        box-shadow: inset 0 0 1px 0 #666;\\n        border-radius: 2px;\\n        background-color: #fff;\\n}\\n.unit {\\n    position: relative;\\n    display: flex;\\n    flex-direction: column;\\n    flex-wrap: nowrap;\\n    text-decoration: none;\\n    color: black;\\n    width: 100%;\\n    cursor: pointer;\\n}\\n.image {\\n    position: relative;\\n    display: block;\\n    flex-grow: 0;\\n    flex-shrink: 0;\\n    margin-bottom: 10px;\\n}\\n.body {\\n    position: relative;\\n    display: flex;\\n    flex-direction: column;\\n    width: 100%;\\n}\\nya-image {\\n    max-height: 100px;\\n}\\n.title {\\n    color: #000;\\n    line-height: 20px;\\n    font-size: 15px;\\n    font-weight: bold;\\n    padding-left: 10px;\\n    padding-right: 10px;\\n}\\n.meta {\\n    color: #757575;\\n    font-size: 12px;\\n    padding-left: 10px;\\n    padding-right: 10px;\\n    padding-top: 7px;\\n    padding-bottom: 10px;\\n}\\n.category {\\n    color: #093;\\n    padding-right: 20px;\\n}\",\"gridColumns\":\"4\",\"gridRows\":\"2\"},{\"value\":\"2\",\"label\":\"1х4 картинка слева\",\"name\":\"grid\",\"props\":{},\"template\":\"<div class=\\\"headline\\\">Читайте также</div>\\n<ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n    <div class=\\\"container\\\">\\n        <div class=\\\"image\\\">\\n            <ya-unit-image />\\n        </div>\\n        <div class=\\\"body\\\">\\n            <div class=\\\"title\\\">\\n                <ya-unit-title />\\n            </div>\\n            <div class=\\\"meta\\\">\\n                <ya-unit-category class=\\\"category\\\"/>\\n                <ya-unit-date class=\\\"date\\\"/>\\n                <ya-unit-domain class=\\\"domain\\\" />\\n            </div>\\n        </div>\\n    </div>\\n    <ya-unit-kebab />\\n</ya-units-grid>\\n<ya-recommendation-label />\",\"css\":\".headline {\\n    font-size: 18px;\\n    font-weight: bold;\\n    line-height: 24px;\\n    color: #373e44;\\n    padding-bottom: 20px;\\n    padding-top: 15px;\\n}\\n.grid-row {\\n    margin-top: 10px;\\n}\\n.grid-item {\\n    margin-left: 10px;\\n}\\n.unit-wrapper {\\n    height: 100%;\\n    box-shadow: inset 0 0 1px 0 #666;\\n    border-radius: 2px;\\n    background-color: #fff;\\n}\\n.container {\\n    position: relative;\\n    display: flex;\\n    flex-direction: row;\\n    flex-wrap: nowrap;\\n    width: 100%;\\n}\\n.image {\\n    width: 200px;\\n    margin-right: 10px;\\n    flex:0 0 auto;\\n}\\n.title {\\n    color: #000;\\n    line-height: 24px;\\n    font-size: 18px;\\n    font-weight: bold;\\n    padding-left: 10px;\\n    padding-right: 10px;\\n}\\n.meta {\\n    color: #757575;\\n    font-size: 12px;\\n    padding-left: 10px;\\n    padding-right: 10px;\\n    padding-top: 7px;\\n    padding-bottom: 10px;\\n}\\n.category {\\n    color: #093;\\n    padding-right: 20px;\\n}\",\"gridColumns\":\"1\",\"gridRows\":\"4\"},{\"value\":\"3\",\"label\":\"3x2 картинка сверху\",\"name\":\"grid\",\"props\":{},\"template\":\"<div class=\\\"wrapper\\\">\\n    <div class=\\\"headline\\\">Читайте также</div>\\n    <ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\" target-blank>\\n        <div class=\\\"card\\\">\\n            <div class=\\\"image\\\">\\n                <ya-unit-image ratio=\\\"0.5\\\" />\\n            </div><ya-clamp lines=\\\"2\\\" class=\\\"title\\\"><ya-unit-title /></ya-clamp>\\n            <div class=\\\"meta\\\">\\n                <ya-unit-category class=\\\"category\\\"/>\\n            </div>\\n        </div>\\n        <ya-unit-kebab />\\n    </ya-units-grid>\\n    <ya-recommendation-label />\\n</div>\",\"css\":\".headline {\\n    font-size: 18px;\\n    font-weight: bold;\\n    line-height: 24px;\\n    color: #373e44;\\n    padding-bottom: 20px;\\n    padding-top: 15px;\\n}\\n.grid-row {\\n    margin-top: 10px;\\n}\\n.grid-item {\\n    margin-left: 10px;\\n}\\n.unit-wrapper {\\n    height: 100%;\\n    border: 1px solid gray;\\n    border-radius: 2px;\\n    background-color: #fff;\\n}\\n.image {\\n    margin-bottom: 10px;\\n}\\n.title {\\n    color: #000;\\n    line-height: 24px;\\n    font-size: 18px;\\n    font-weight: bold;\\n    padding-left: 10px;\\n    padding-right: 10px;\\n}\\n.meta {\\n    color: #757575;\\n    font-size: 12px;\\n    padding-left: 10px;\\n    padding-right: 10px;\\n    padding-top: 7px;\\n    padding-bottom: 10px;\\n}\\n.category {\\n    color: #093;\\n    padding-right: 20px;\\n}\\n.unit-wrapper:hover{\\n    border: 1px solid #093;\\n    background-color: #eee;\\n}\\n.unit-wrapper:hover .title {\\n    color: red;\\n}\",\"gridColumns\":\"3\",\"gridRows\":\"2\"},{\"value\":\"4\",\"label\":\"3х2 картинка сверху, с описанием\",\"name\":\"grid\",\"props\":{},\"template\":\"<div class=\\\"wrapper\\\">\\n    <div class=\\\"headline\\\">Читайте также</div>\\n    <ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n        <div class=\\\"card\\\">\\n            <div class=\\\"image\\\">\\n                <ya-unit-image ratio=\\\"0.5\\\" />\\n            </div>\\n            <div class=\\\"title\\\">\\n                <ya-clamp lines=\\\"2\\\"><ya-unit-title /></ya-clamp>\\n            </div>\\n            <div class=\\\"desc\\\">\\n                <ya-clamp lines=\\\"3\\\"><ya-unit-desc /></ya-clamp>\\n            </div>\\n            <div class=\\\"meta\\\">\\n                <ya-unit-category class=\\\"category\\\"/>\\n                <ya-unit-date class=\\\"date\\\"/>\\n                <ya-unit-domain class=\\\"domain\\\" />\\n            </div>\\n        </div>\\n    <ya-unit-kebab />\\n    </ya-units-grid>\\n    <ya-recommendation-label />\\n</div>\",\"css\":\".headline {\\n    font-size: 18px;\\n    font-weight: bold;\\n    line-height: 18px;\\n    color: #373e44;\\n    padding-bottom: 20px;\\n    padding-top: 15px;\\n}\\n.grid-row {\\n    margin-top: 10px;\\n}\\n.grid-item {\\n    margin-left: 10px;\\n}\\n.unit-wrapper {\\n    height: 100%;\\n    border: 1px solid gray;\\n    border-radius: 2px;\\n    background-color: #fff;\\n}\\n.image {\\n    margin-bottom: 10px;\\n}\\n.title {\\n    color: #000;\\n    font-size: 15px;\\n    font-weight: bold;\\n    padding-left: 10px;\\n    padding-right: 10px;\\n}\\n.meta {\\n    color: #757575;\\n    font-size: 12px;\\n    padding-left: 10px;\\n    padding-right: 10px;\\n    padding-top: 7px;\\n    padding-bottom: 10px;\\n}\\n.desc {\\n    color: #757575;\\n    font-size: 12px;\\n    padding-left: 10px;\\n    padding-right: 10px;\\n    padding-top: 7px;\\n    padding-bottom: 10px;\\n}\\n.category {\\n    color: #093;\\n    padding-right: 20px;\\n}\\n.unit-wrapper:hover {\\n    border: 1px solid #093;\\n    background-color: #eee;\\n}\\n.unit-wrapper:hover .title {\\n    color: red;\\n}\",\"gridColumns\":\"3\",\"gridRows\":\"2\"},{\"value\":\"6\",\"label\":\"5х1 картинка на фоне с градиентом\",\"name\":\"grid\",\"props\":{},\"template\":\"<div class=\\\"wrapper\\\">\\n    <div class=\\\"headline\\\">Рекомендуем</div>\\n    <ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n        <div class=\\\"image\\\">\\n            <ya-unit-image ratio=\\\"1.35\\\" />\\n        </div>\\n        <div class=\\\"card\\\">\\n            <ya-clamp lines=\\\"7\\\" class=\\\"title\\\"><ya-unit-title /></ya-clamp>\\n            <div class=\\\"meta\\\">\\n                <ya-unit-category ad-only />\\n            </div>\\n        </div>\\n        <ya-unit-kebab />\\n    </ya-units-grid>\\n    <ya-recommendation-label />\\n</div>\",\"css\":\".headline {\\n    font-size: 24px;\\n    font-weight: bold;\\n    line-height: 30px;\\n    color: #000;\\n    padding-bottom: 10px;\\n    padding-top: 10px;\\n}\\n\\n.grid-item {\\n    margin-left: 15px;\\n    min-width: 175px;\\n    max-width: 175px;\\n    height: 235px;\\n}\\n\\n.unit-wrapper {\\n    height: 100%;\\n    border-radius: 3px;\\n    position: relative;\\n}\\n\\n.image {\\n    margin-bottom: 10px;\\n}\\n\\n.card:before {\\n    content: \\\"\\\";\\n    position: absolute;\\n    top: -15px;\\n    bottom: -15px;\\n    left: 0;\\n    right: 0;\\n    background: red;\\n    background: linear-gradient(\\t\\n                to bottom,\\t\\n                rgba(var(--unit-average-color-rgb, 125, 125, 125), 0.0) 0%,\\t\\n                rgba(var(--unit-average-color-rgb, 125, 125, 125), 0.7) 30%,\\n                rgba(var(--unit-average-color-rgb, 125, 125, 125), 1) 100%\\t\\n            );\\n}\\n\\n.card {\\n    position: absolute;\\n    bottom: 15px;\\n}\\n\\n.title {\\n    color: #fff;\\n    text-shadow: 0px 0px 3px rgba(0, 0, 0, 0.5);\\n    line-height: 17px;\\n    font-size: 14px;\\n    font-weight: bold;\\n    padding-left: 10px;\\n    padding-right: 10px;\\n}\\n\\n.meta {\\n    position: relative;\\n    color: #fff;\\n    text-shadow: 0px 0px 3px rgba(0, 0, 0, 0.5);\\n    font-size: 13px;\\n    padding-left: 10px;\\n    padding-right: 10px;\\n    padding-top: 15px;\\n    padding-bottom: 10px;\\n}\",\"gridColumns\":\"5\",\"gridRows\":\"1\"},{\"value\":\"8\",\"label\":\"4x3 картинка сверху, адаптивная сетка со скруглением\",\"name\":\"grid\",\"template\":\"<div class=\\\"wrapper\\\">\\n    <div class=\\\"headline\\\">Смотрите также</div>\\n    <ya-units-grid sizes=\\\"(max-width: 959px) 3x3, (max-width: 639px) 3x2, ${grid_rows}x${grid_columns}\\\">\\n        <div class=\\\"unit-wrapper\\\">\\n            <div class=\\\"image\\\"><ya-unit-image ratio=\\\"0.5625\\\" /></div>\\n            <ya-clamp lines=\\\"4\\\" class=\\\"title\\\"><ya-unit-title /></ya-clamp>\\n            <ya-unit-category class=\\\"category\\\"/>\\n        </div>\\n        <ya-unit-kebab />\\n    </ya-units-grid>\\n    <ya-recommendation-label />\\n</div>\",\"css\":\".headline {\\n    margin-bottom: 12px;\\n    font-weight: bold;\\n    font-size: 20px;\\n    line-height: 1;\\n    color: #333;\\n}\\n.grid-row {\\n    margin-top: 20px;\\n}\\n.grid-item {\\n    margin-left: 20px;\\n}\\n.image {\\n    margin-bottom: 5px;\\n    overflow: hidden;\\n    -webkit-transform: translateZ(0);\\n    transform: translateZ(0);\\n    border-radius: 6px;\\n}\\n.unit-image {\\n    -webkit-filter: brightness(95%);\\n    filter: brightness(95%);\\n}\\n.unit-wrapper {\\n    border-radius: 6px;\\n}\\n.title {\\n    margin-bottom: 2px;\\n    font-weight: bold;\\n    font-size: 17px;\\n    line-height: 1.25;\\n    color: #333;\\n}\\n.category {\\n    margin-top: 3px;\\n    font-size: 12px;\\n    color: #808080;\\n}\\n@media (min-width: 640px) {\\n    .unit-image {\\n        -webkit-transition: all .15s ease-in-out;\\n        transition: all .15s ease-in-out;\\n    }\\n    .unit-wrapper:hover .unit-image {\\n        opacity: 0.9;\\n        -webkit-transform: translateZ(0) scale(1.1);\\n        transform: translateZ(0) scale(1.1);\\n    }\\n}\\n@media (max-width: 639px) {\\n    .headline {\\n        margin-bottom: 10px;\\n        font-size: 17px;\\n        line-height: 1.25;\\n    }\\n    .grid-row {\\n        margin-top: 10px;\\n    }\\n    .grid-item {\\n        margin-left: 10px;\\n    }\\n    .image {\\n        margin-bottom: 6px;\\n    }\\n    .title {\\n        font-size: 13px;\\n    }\\n    .category {\\n        font-size: 11px;\\n    }\\n}\",\"gridColumns\":\"4\",\"gridRows\":\"3\"},{\"value\":\"9\",\"label\":\"4x2 картинка сверху, с описанием и скруглением\",\"name\":\"grid\",\"props\":{},\"template\":\"<div class=\\\"wrapper\\\">\\n    <div class=\\\"headline\\\">Читайте также</div>\\n    <ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n        <div>\\n            <div class=\\\"image\\\">\\n                <ya-unit-image ratio=\\\"0.55\\\" />\\n             </div>\\n            <div class=\\\"title\\\">\\n                <ya-clamp lines=\\\"2\\\"><ya-unit-title /></ya-clamp>\\n            </div>\\n            <div class=\\\"desc\\\">\\n                <ya-clamp lines=\\\"3\\\"><ya-unit-desc /></ya-clamp>\\n            </div>\\n            <div class=\\\"meta\\\">\\n                <ya-unit-category class=\\\"category\\\"/>\\n                <ya-unit-date class=\\\"date\\\"/>\\n                <ya-unit-domain class=\\\"domain\\\" />\\n            </div>\\n        </div>\\n        <ya-unit-kebab />\\n    </ya-units-grid>\\n    <ya-recommendation-label />\\n</div>\",\"css\":\".headline {\\n    font-size: 18px;\\n    font-weight: bold;\\n    line-height: 18px;\\n    color: #373e44;\\n    padding-bottom: 20px;\\n    padding-top: 15px;\\n}\\n.grid-row {\\n    margin-top: 10px;\\n}\\n.grid-item {\\n    margin-left: 10px;\\n}\\n.unit-wrapper {\\n    border: 1px solid gray;\\n    border-radius: 10px;\\n    height: 100%;\\n    background-color: #fff;\\n}\\n.image {\\n    margin-bottom: 10px;\\n}\\n.title {\\n    color: #000;\\n    font-size: 14px;\\n    font-weight: bold;\\n    padding-left: 10px;\\n    padding-right: 10px;\\n}\\n.meta {\\n    color: #757575;\\n    font-size: 12px;\\n    padding-left: 10px;\\n    padding-right: 10px;\\n    padding-top: 7px;\\n    padding-bottom: 10px;\\n}\\n.desc {\\n    color: #757575;\\n    font-size: 12px;\\n    padding-left: 10px;\\n    padding-right: 10px;\\n    padding-top: 7px;\\n    padding-bottom: 10px;\\n}\\n.category {\\n    color: #093;\\n    padding-right: 20px;\\n}\\n.date {\\n    float: right;\\n}\\n.domain {\\n    float: right;\\n}\\n.unit-wrapper:hover {\\n    border: 1px solid #093;\\n    background-color: #eee;\\n}\\n.unit-wrapper:hover .title {\\n    color: red;\\n}\",\"gridColumns\":\"4\",\"gridRows\":\"2\"},{\"value\":\"10\",\"label\":\"1x5 картинка слева, для мобильных\",\"name\":\"grid\",\"props\":{},\"template\":\"<ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n    <div class=\\\"container\\\">\\n        <div class=\\\"image\\\">\\n            <ya-unit-image />\\n        </div>\\n        <div class=\\\"body\\\">\\n            <ya-clamp lines=\\\"3\\\" class=\\\"title\\\">\\n                <ya-unit-title />\\n            </ya-clamp>\\n            <div class=\\\"category\\\">\\n                <ya-unit-category ad-only />\\n            </div>\\n        </div>\\n    </div>\\n  <ya-unit-kebab />\\n</ya-units-grid>\\n<ya-recommendation-label />\",\"css\":\".headline {\\n    font-size: 18px;\\n    font-weight: bold;\\n    line-height: 24px;\\n    color: #373e44;\\n    padding-bottom: 20px\\n    padding-top: 15px;\\n}\\n.grid-row {\\n    margin-top: 6px;\\n}\\n.grid-item {\\n    margin-left: 10px;\\n}\\n.unit-wrapper {\\n    height: 100%;\\n    background-color: #fff;\\n}\\n.container {\\n    position: relative;\\n    display: flex;\\n    flex-direction: row;\\n    flex-wrap: nowrap;\\n    max-width: 340px;\\n    max-height: 84px;\\n}\\n.image {\\n    width: 162px;\\n    height: 85px;\\n    margin-right: 10px;\\n    flex: 0 0 auto;\\n}\\n.title {\\n    font-family: \\\"Roboto\\\", Roboto, Arial, sans-serif;\\n    color: #000;\\n    line-height: 17px;\\n    font-size: 14px;\\n    font-weight: bold;\\n    padding-top: 9px;\\n}\\n.meta {\\n    color: #757575;\\n    font-size: 12px;\\n    padding-left: 10px;\\n    padding-right: 10px;\\n    padding-top: 7px;\\n    padding-bottom: 10px;\\n}\\n.category {\\n    color: #999999;\\n    font-size: 12px;\\n    padding-top: 20px;\\n    padding-bottom: 10px;\\n}\\n.grid {\\n    display: flex;\\n    flex-direction: column;\\n    flex-wrap: wrap;\\n    justify-content: flex-start;\\n    align-items: stretch;\\n    align-content: flex-start;\\n    width: 100%;\\n    box-sizing: border-box;\\n    margin-bottom: 2px;\\n}\",\"gridColumns\":\"1\",\"gridRows\":\"5\"},{\"value\":\"11\",\"label\":\"3x2 картинка сверху, адаптивная сетка, без рамки\",\"name\":\"grid\",\"props\":{},\"template\":\"<div class=\\\"wrapper\\\">\\n    <div class=\\\"headline\\\">Читайте также</div>\\n    <ya-units-grid sizes=\\\"(max-width: 1024px) 2x3, (max-width: 600px) 6x1, ${grid_rows}x${grid_columns}\\\" target_top>\\n        <div class=\\\"card\\\">\\n            <div class=\\\"image\\\">\\n                <ya-unit-image ratio=\\\"0.5\\\" />\\n            </div>\\n            <ya-clamp lines=\\\"2\\\" class=\\\"title\\\"><ya-unit-title /></ya-clamp>\\n            <div class=\\\"meta\\\">\\n                <ya-unit-category class=\\\"category\\\" />\\n            </div>\\n        </div>\\n        <ya-unit-kebab />\\n    </ya-units-grid>\\n    <ya-recommendation-label />\\n</div>\",\"css\":\".headline {\\n    font-size: 18px;\\n    font-weight: bold;\\n    font-family: Roboto Condensed, sans-serif;\\n    line-height: 24px;color: #373e44;\\n    padding-bottom: 20px;\\n    padding-top: 15px;\\n}\\n.grid-row {\\n    margin-top: 10px;\\n    min-height: 230px;\\n}\\n.grid-item {\\n    margin-left: 10px;\\n}\\n.unit-wrapper {\\n    height: 100%;\\n    border: 0px #dee2e3;\\n    border-radius: 2px;\\n    background-color: #fff;\\n}\\n.image {\\n    margin-bottom: 10px;\\n}\\n.title {\\n    color: #000;\\n    line-height: 24px;\\n    font-size: 18px;\\n    font-family: Roboto Condensed, sans-serif;\\n    font-stretch: condensed;\\n    font-weight: 700;\\n    font-style: normal;\\n    padding-left: 10px;\\n    padding-right: 10px;\\n}\\n.meta {\\n    display: inline-block;\\n    vertical-align: bottom;\\n    border-radius: 3px;\\n    padding: 4px 5px 2px 5px;\\n    border: 1px solid;\\n    border-color: #fff;\\n    line-height: 1;\\n    margin-bottom: 10px;\\n    margin-top: 10px;\\n    margin-left: 2px;\\n    background: #fff;\\n    padding: 2px 8px;\\n    font-size: 11px;\\n    line-height: 1.45;\\n    letter-spacing: 1px;\\n    text-transform: uppercase;\\n}\\n.category {\\n    color: #3670f9;\\n    font-family: Roboto Condensed, sans-serif;\\n    padding-right: 0px;\\n    font-size: 12px;\\n    font-stretch: condensed;\\n    font-weight: bold;\\n    font-style: normal;\\n}\\n.ya-recommendation-label {\\n    color: #e7e7e7;\\n    font-size: 10px;\\n    font-family: Roboto Condensed, sans-serif;\\n    font-style: normal;\\n}\\n.unit-wrapper:hover .title {\\n    color: #ED5E42;\\n}\",\"gridColumns\":\"3\",\"gridRows\":\"2\"},{\"value\":\"12\",\"label\":\"Слайдер: картинка сверху, с фоном\",\"props\":{},\"template\":\"<div class=\\\"headline\\\">Читайте также</div>\\n<ya-units-slider>\\n<div class=\\\"unit\\\">\\n    <ya-unit-kebab />\\n    <div class=\\\"image\\\">\\n        <ya-unit-image ratio=\\\"0.667\\\" />\\n    </div>\\n    <div class=\\\"body\\\">\\n        <ya-clamp class=\\\"title\\\" lines=\\\"3\\\">\\n            <ya-unit-title />\\n        </ya-clamp>\\n        <ya-clamp class=\\\"description\\\" lines=\\\"2\\\">\\n            <ya-unit-desc />\\n        </ya-clamp>\\n        <div class=\\\"meta\\\">\\n            <ya-unit-category class=\\\"meta-span category\\\" />\\n            <ya-unit-date class=\\\"meta-span date\\\" />\\n            <ya-unit-age class=\\\"meta-span age\\\" />\\n        </div>\\n        <div class=\\\"domain-block\\\">\\n            <ya-unit-domain class=\\\"domain\\\" />\\n            <span class=\\\"favicon\\\">\\n                <ya-unit-favicon size=\\\"16\\\" />\\n            </span>\\n        </div>\\n    </div>\\n</div>\\n<ya-slider-button direction=\\\"left\\\">\\n    <div class=\\\"button button-left\\\"></div>\\n</ya-slider-button>\\n<ya-slider-button direction=\\\"right\\\">\\n    <div class=\\\"button button-right\\\"></div>\\n</ya-slider-button>\\n</ya-units-slider>\\n<ya-recommendation-label />\",\"css\":\".headline {\\n    font-family: Helvetica,Arial,sans-serif;\\n    font-size: 20px;\\n    font-weight: 700;\\n    line-height: 24px;\\n    color: #373e44;\\n    padding-bottom: 12px;\\n    padding-top: 12px;\\n}\\n\\n.ya-units-slider {\\n    width: 100%;\\n}\\n\\n.ya-slider-item:not(:first-child) {\\n    margin-left: 12px;\\n}\\n\\n.label {\\n    display: block;\\n    font-family: Helvetica,Arial,sans-serif;\\n    font-size: 12px;\\n    color: #999;\\n}\\n\\n.unit-wrapper {\\n    height: 100%;\\n}\\n\\n.image,.unit {\\n    position: relative;\\n    overflow: hidden;\\n}\\n\\n.unit {\\n    display: flex;\\n    flex-direction: column;\\n    flex-wrap: nowrap;\\n    text-decoration: none;\\n    color: #000;\\n    width: 240px;\\n    cursor: pointer;\\n    box-sizing: border-box;\\n    margin: 0 auto;\\n    -webkit-transform: translateZ(0);\\n    font-family: Helvetica,Arial,sans-serif;\\n    height: 100%;\\n    background: #f0f1f5;\\n    border-radius: 8px;\\n}\\n\\n.unit:hover {\\n    background: #e1e2e5;\\n}\\n\\n.unit:active {\\n    background: #d7d8db;\\n}\\n\\n.image {\\n    display: block;\\n    flex-grow: 0;\\n    flex-shrink: 0;\\n}\\n\\n.img-source-component {\\n    transition: transform 100ms ease;\\n    border-radius: 0;\\n}\\n\\n.unit-wrapper:hover .unit-image .img-source-component {\\n    transform: scale(1.05);\\n    -webkit-transform: scale(1.05);\\n}\\n\\n.unit:active .unit-image .img-source-component {\\n    transform: scale(1.025);\\n    -webkit-transform: scale(1.025);\\n}\\n\\n.ya-ad-close {\\n    transform: translateZ(0);\\n}\\n\\n.unit-image {\\n    max-height: 160px;\\n}\\n\\n.body {\\n    position: relative;\\n    display: flex;\\n    flex-direction: column;\\n    width: 100%;\\n}\\n\\n.title {\\n    color: #000;\\n    font-style: normal;\\n    font-weight: 700;\\n    font-size: 15px;\\n    line-height: 20px;\\n    margin-top: 12px;\\n    padding-left: 16px;\\n    padding-right: 16px;\\n}\\n\\n.description,.domain-block {\\n    font-style: normal;\\n    font-weight: 400;\\n    font-size: 14px;\\n    margin-top: 8px;\\n}\\n\\n.description {\\n    line-height: 20px;\\n    color: #505050;\\n    padding-left: 16px;\\n    padding-right: 16px;\\n}\\n\\n.domain-block {\\n    color: #000;\\n    line-height: 16px;\\n    margin-left: 16px;\\n    margin-right: 16px;\\n    display: flex;\\n    align-items: center;\\n    position: relative;\\n}\\n\\n.domain:empty,.domain:empty~.favicon {\\n    display: none;\\n}\\n\\n.domain,.favicon {\\n    margin-bottom: 16px;\\n}\\n\\n.domain {\\n    padding-left: 24px;\\n}\\n\\n.favicon {\\n    width: 16px;\\n    height: 16px;\\n    background-color: rgba(0 0 0/10%);\\n    display: inline-block;\\n    margin-right: 8px;\\n    position: absolute;\\n    top: 0;\\n    left: 0;\\n    border-radius: 4px;\\n}\\n\\n.meta {\\n    color: silver;\\n    font-style: normal;\\n    font-weight: 400;\\n    font-size: 12px;\\n    line-height: 16px;\\n    margin-top: 12px;\\n    padding-left: 16px;\\n    padding-right: 16px;\\n}\\n\\n.meta:last-child {\\n    padding-bottom: 16px;\\n}\\n\\n.meta-span {\\n    padding: 0;\\n}\\n\\n.meta-span:before {\\n    content: \\\" · \\\";\\n}\\n\\n.meta-span:first-child:before {\\n    content: none;\\n}\\n\\n.meta-span:empty {\\n    display: none;\\n}\\n\\n.button {\\n    width: 40px;\\n    height: 40px;\\n    border-radius: 20px;\\n    position: absolute;\\n    cursor: pointer;\\n    z-index: 999;\\n    bottom: 47%;\\n    background-color: #fff;\\n    background-image: url(data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDBweCIgaGVpZ2h0PSI0MHB4IiB2aWV3Qm94PSIwIDAgNDAgNDAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PGcgdHJhbnNmb3JtPSJ0cmFuc2xhdGUoMTEuMCwgMTMuMCkiIHN0cm9rZT0iIzE4MTgxOCIgc3Ryb2tlLXdpZHRoPSIxLjgiIGZpbGw9Im5vbmUiPjxsaW5lIHgxPSIwLjUiIHkxPSI3IiB4Mj0iMTYuNSIgeTI9IjciPjwvbGluZT48cG9seWxpbmUgcG9pbnRzPSI5LjUgMCAxNi41IDcgOS41IDE0Ij48L3BvbHlsaW5lPjwvZz48L3N2Zz4=);\\n    background-position: 50%;\\n    background-repeat: no-repeat;\\n    background-origin: content-box;\\n    background-size: 40px 40px;\\n    box-shadow: 0 1px 1px rgba(0,0,0,.05),0 2px 2px rgba(0,0,0,.05),0 4px 4px rgba(0,0,0,.05);\\n    transition: transform 50ms ease-out;\\n}\\n\\n.button:hover {\\n    transform: scale(1.2);\\n}\\n\\n.button:active {\\n    transform: scale(1.1);\\n    transition: transform 50ms ease-in;\\n    background-color: #f0f0f0;\\n}\\n\\n.button-left {\\n    left: 8px;\\n    transform: scaleX(-1);\\n}\\n\\n.button-left:hover {\\n    transform: scaleX(-1) scale(1.2);\\n}\\n\\n.button-right {\\n    right: 8px;\\n}\\n\\n.ya-slider-leftmost .button-left,.ya-slider-rightmost .button-right {\\n    display: none;\\n}\\n\\n.recommendation-label {\\n    display: block;\\n    width: 100%;\\n    color: #ddd;\\n    text-align: right;\\n}\",\"gridColumns\":\"7\",\"gridRows\":\"1\"},{\"value\":\"13\",\"label\":\"Слайдер: картинка сверху, без фона\",\"props\":{},\"template\":\"<div class=\\\"headline\\\">Читайте также</div>\\n<ya-units-slider>\\n<div class=\\\"unit\\\">\\n    <ya-unit-kebab />\\n    <div class=\\\"image\\\">\\n        <ya-unit-image ratio=\\\"0.667\\\" />\\n    </div>\\n    <div class=\\\"body\\\">\\n        <ya-clamp class=\\\"title\\\" lines=\\\"3\\\">\\n            <ya-unit-title />\\n        </ya-clamp>\\n        <ya-clamp class=\\\"description\\\" lines=\\\"2\\\">\\n            <ya-unit-desc />\\n        </ya-clamp>\\n        <div class=\\\"meta\\\">\\n            <ya-unit-category class=\\\"meta-span category\\\" />\\n            <ya-unit-date class=\\\"meta-span date\\\" />\\n            <ya-unit-age class=\\\"meta-span age\\\" />\\n        </div>\\n        <div class=\\\"domain-block\\\">\\n            <ya-unit-domain class=\\\"domain\\\" />\\n            <span class=\\\"favicon\\\">\\n                <ya-unit-favicon size=\\\"16\\\" />\\n            </span>\\n        </div>\\n    </div>\\n</div>\\n<ya-slider-button direction=\\\"left\\\">\\n    <div class=\\\"button button-left\\\"></div>\\n</ya-slider-button>\\n<ya-slider-button direction=\\\"right\\\">\\n    <div class=\\\"button button-right\\\"></div>\\n</ya-slider-button>\\n</ya-units-slider>\\n<ya-recommendation-label />\",\"css\":\".headline {\\n    font-family: Helvetica,Arial,sans-serif;\\n    font-size: 20px;\\n    font-weight: 700;\\n    line-height: 24px;\\n    color: #373e44;\\n    padding-bottom: 12px;\\n    padding-top: 12px;\\n}\\n\\n.ya-units-slider {\\n    width: 100%;\\n}\\n\\n.ya-slider-item:not(:first-child) {\\n    margin-left: 12px;\\n}\\n\\n.label {\\n    display: block;\\n    font-family: Helvetica,Arial,sans-serif;\\n    font-size: 12px;\\n    color: #999;\\n}\\n\\n.unit-wrapper {\\n    height: 100%;\\n}\\n\\n.image,.unit {\\n    position: relative;\\n    overflow: hidden;\\n}\\n\\n.unit {\\n    display: flex;\\n    flex-direction: column;\\n    flex-wrap: nowrap;\\n    text-decoration: none;\\n    color: #000;\\n    width: 240px;\\n    cursor: pointer;\\n    box-sizing: border-box;\\n    margin: 0 auto;\\n    -webkit-transform: translateZ(0);\\n    font-family: Helvetica,Arial,sans-serif;\\n    height: 100%;\\n    border-radius: 8px;\\n}\\n\\n.unit:hover {\\n    background: #e1e2e5;\\n}\\n\\n.unit:active {\\n    background: #d7d8db;\\n}\\n\\n.image {\\n    display: block;\\n    flex-grow: 0;\\n    flex-shrink: 0;\\n}\\n\\n.img-source-component {\\n    transition: transform 100ms ease;\\n    border-radius: 0;\\n}\\n\\n.unit-wrapper:hover .unit-image .img-source-component {\\n    transform: scale(1.05);\\n    -webkit-transform: scale(1.05);\\n}\\n\\n.unit:active .unit-image .img-source-component {\\n    transform: scale(1.025);\\n    -webkit-transform: scale(1.025);\\n}\\n\\n.ya-ad-close {\\n    transform: translateZ(0);\\n}\\n\\n.unit-image {\\n    max-height: 160px;\\n}\\n\\n.body {\\n    position: relative;\\n    display: flex;\\n    flex-direction: column;\\n    width: 100%;\\n}\\n\\n.title {\\n    color: #000;\\n    font-style: normal;\\n    font-weight: 700;\\n    font-size: 15px;\\n    line-height: 20px;\\n    margin-top: 12px;\\n    padding-left: 16px;\\n    padding-right: 16px;\\n}\\n\\n.description,.domain-block {\\n    font-style: normal;\\n    font-weight: 400;\\n    font-size: 14px;\\n    margin-top: 8px;\\n}\\n\\n.description {\\n    line-height: 20px;\\n    color: #505050;\\n    padding-left: 16px;\\n    padding-right: 16px;\\n}\\n\\n.domain-block {\\n    color: #000;\\n    line-height: 16px;\\n    margin-left: 16px;\\n    margin-right: 16px;\\n    display: flex;\\n    align-items: center;\\n    position: relative;\\n}\\n\\n.domain:empty,.domain:empty~.favicon {\\n    display: none;\\n}\\n\\n.domain,.favicon {\\n    margin-bottom: 16px;\\n}\\n\\n.domain {\\n    padding-left: 24px;\\n}\\n\\n.favicon {\\n    width: 16px;\\n    height: 16px;\\n    background-color: rgba(0 0 0/10%);\\n    display: inline-block;\\n    margin-right: 8px;\\n    position: absolute;\\n    top: 0;\\n    left: 0;\\n    border-radius: 4px;\\n}\\n\\n.meta {\\n    color: silver;\\n    font-style: normal;\\n    font-weight: 400;\\n    font-size: 12px;\\n    line-height: 16px;\\n    margin-top: 12px;\\n    padding-left: 16px;\\n    padding-right: 16px;\\n}\\n\\n.meta:last-child {\\n    padding-bottom: 16px;\\n}\\n\\n.meta-span {\\n    padding: 0;\\n}\\n\\n.meta-span:before {\\n    content: \\\" · \\\";\\n}\\n\\n.meta-span:first-child:before {\\n    content: none;\\n}\\n\\n.meta-span:empty {\\n    display: none;\\n}\\n\\n.button {\\n    width: 40px;\\n    height: 40px;\\n    border-radius: 20px;\\n    position: absolute;\\n    cursor: pointer;\\n    z-index: 999;\\n    bottom: 47%;\\n    background-color: #fff;\\n    background-image: url(data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDBweCIgaGVpZ2h0PSI0MHB4IiB2aWV3Qm94PSIwIDAgNDAgNDAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PGcgdHJhbnNmb3JtPSJ0cmFuc2xhdGUoMTEuMCwgMTMuMCkiIHN0cm9rZT0iIzE4MTgxOCIgc3Ryb2tlLXdpZHRoPSIxLjgiIGZpbGw9Im5vbmUiPjxsaW5lIHgxPSIwLjUiIHkxPSI3IiB4Mj0iMTYuNSIgeTI9IjciPjwvbGluZT48cG9seWxpbmUgcG9pbnRzPSI5LjUgMCAxNi41IDcgOS41IDE0Ij48L3BvbHlsaW5lPjwvZz48L3N2Zz4=);\\n    background-position: 50%;\\n    background-repeat: no-repeat;\\n    background-origin: content-box;\\n    background-size: 40px 40px;\\n    box-shadow: 0 1px 1px rgba(0,0,0,.05),0 2px 2px rgba(0,0,0,.05),0 4px 4px rgba(0,0,0,.05);\\n    transition: transform 50ms ease-out;\\n}\\n\\n.button:hover {\\n    transform: scale(1.2);\\n}\\n\\n.button:active {\\n    transform: scale(1.1);\\n    transition: transform 50ms ease-in;\\n    background-color: #f0f0f0;\\n}\\n\\n.button-left {\\n    left: 8px;\\n    transform: scaleX(-1);\\n}\\n\\n.button-left:hover {\\n    transform: scaleX(-1) scale(1.2);\\n}\\n\\n.button-right {\\n    right: 8px;\\n}\\n\\n.ya-slider-leftmost .button-left,.ya-slider-rightmost .button-right {\\n    display: none;\\n}\\n\\n.recommendation-label {\\n    display: block;\\n    width: 100%;\\n    color: #ddd;\\n    text-align: right;\\n}\",\"gridColumns\":\"7\",\"gridRows\":\"1\"},{\"value\":\"14\",\"label\":\"Слайдер: картинка снизу, с фоном\",\"props\":{},\"template\":\"<div class=\\\"headline\\\">Читайте также</div>\\n<ya-units-slider class=\\\"slider\\\">\\n<div class=\\\"unit\\\">\\n    <ya-unit-kebab />\\n    <div class=\\\"text-block\\\">\\n        <div class=\\\"meta\\\">\\n            <ya-unit-category class=\\\"meta-span category\\\" />\\n            <ya-unit-date class=\\\"meta-span date\\\" />\\n            <ya-unit-age class=\\\"meta-span age\\\" />\\n        </div>\\n        <ya-clamp class=\\\"title\\\" lines=\\\"3\\\">\\n            <ya-unit-title />\\n        </ya-clamp>\\n        <ya-clamp class=\\\"description\\\" lines=\\\"2\\\">\\n            <ya-unit-desc />\\n        </ya-clamp>\\n        <div class=\\\"domain-block\\\">\\n            <ya-unit-domain class=\\\"domain\\\" /><span class=\\\"favicon\\\">\\n                <ya-unit-favicon size=\\\"16\\\" /></span></div>\\n    </div>\\n    <div class=\\\"image\\\">\\n        <ya-unit-image ratio=\\\"0.667\\\" />\\n    </div>\\n</div>\\n<ya-slider-button direction=\\\"left\\\">\\n    <div class=\\\"button button-left\\\"></div>\\n</ya-slider-button>\\n<ya-slider-button direction=\\\"right\\\">\\n    <div class=\\\"button button-right\\\"></div>\\n</ya-slider-button>\\n</ya-units-slider>\\n<ya-recommendation-label />\",\"css\":\".headline {\\n    font-family: Helvetica,Arial,sans-serif;\\n    font-size: 20px;\\n    font-weight: 700;\\n    line-height: 24px;\\n    padding-bottom: 12px;\\n    padding-top: 20px;\\n    color: #333;\\n}\\n\\n.ya-units-slider {\\n    width: 100%;\\n}\\n\\n.ya-slider-item {\\n    display: -webkit-flex;\\n    display: -ms-flexbox;\\n    display: flex;\\n    width: 240px;\\n    background: #f0f1f5;\\n    border-radius: 8px;\\n}\\n\\n.ya-slider-item:not(:first-child) {\\n    margin-left: 12px;\\n}\\n\\n.ya-slider-item:hover {\\n    background: #e1e2e5;\\n}\\n\\n.ya-slider-item:active {\\n    background: #d7d8db;\\n}\\n\\n.unit,.yrw-url {\\n    height: 100%;\\n}\\n\\n.unit {\\n    font-family: Helvetica,Arial,sans-serif;\\n    text-decoration: none;\\n    position: relative;\\n    display: flex;\\n    flex-direction: column;\\n    flex-wrap: nowrap;\\n    box-sizing: border-box;\\n    cursor: pointer;\\n    margin: 0 auto;\\n    width: 240px;\\n    border-radius: 8px;\\n    overflow: hidden;\\n    -webkit-transform: translateZ(0);\\n}\\n\\n.text-block {\\n    padding: 12px;\\n}\\n\\n.title {\\n    color: #000;\\n    font-size: 15px;\\n    line-height: 20px;\\n    font-style: normal;\\n    font-weight: 700;\\n    margin-top: 4px;\\n}\\n\\n.description,.meta {\\n    font-style: normal;\\n    font-weight: 400;\\n}\\n\\n.description {\\n    font-size: 14px;\\n    line-height: 20px;\\n    color: #505050;\\n    margin-top: 4px;\\n}\\n\\n.meta {\\n    color: silver;\\n    font-size: 12px;\\n    line-height: 16px;\\n}\\n\\n.meta-span {\\n    padding: 0;\\n}\\n\\n.meta-span:before {\\n    content: \\\" · \\\";\\n}\\n\\n.meta-span:first-child:before {\\n    content: none;\\n}\\n\\n.domain:empty,.domain:empty~.favicon,.meta-span:empty {\\n    display: none;\\n}\\n\\n.domain-block {\\n    color: #000;\\n    font-style: normal;\\n    font-weight: 400;\\n    font-size: 14px;\\n    line-height: 12px;\\n    display: flex;\\n    align-items: center;\\n    position: relative;\\n}\\n\\n.domain {\\n    margin-top: 8px;\\n    padding-left: 24px;\\n}\\n\\n.favicon {\\n    width: 16px;\\n    height: 16px;\\n    background-color: rgba(0 0 0/10%);\\n    display: inline-block;\\n    margin-right: 8px;\\n    position: absolute;\\n    top: 0;\\n    left: 0;\\n    margin-top: 8px;\\n    border-radius: 4px;\\n}\\n\\n.image {\\n    margin-top: auto;\\n    margin-bottom: 0;\\n}\\n\\n.img-source-component {\\n    transition: transform 100ms ease;\\n    border-radius: 0;\\n}\\n\\n.unit-wrapper:hover .unit-image .img-source-component {\\n    transform: scale(1.05);\\n    -webkit-transform: scale(1.05);\\n}\\n\\n.unit:active .unit-image .img-source-component {\\n    transform: scale(1.025);\\n    -webkit-transform: scale(1.025);\\n}\\n\\n.ya-ad-warning,.yrw-ya-unit-image-footer {\\n    transform: translateZ(0);\\n}\\n\\n.unit-image {\\n    max-height: 180px;\\n}\\n\\n.recommendation-label {\\n    display: block;\\n    width: 100%;\\n    color: #ddd;\\n    text-align: right;\\n}\\n\\n.button {\\n    width: 40px;\\n    height: 40px;\\n    border-radius: 20px;\\n    position: absolute;\\n    cursor: pointer;\\n    z-index: 999;\\n    top: 41%;\\n    background-color: #fff;\\n    background-image: url(data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDBweCIgaGVpZ2h0PSI0MHB4IiB2aWV3Qm94PSIwIDAgNDAgNDAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PGcgdHJhbnNmb3JtPSJ0cmFuc2xhdGUoMTEuMCwgMTMuMCkiIHN0cm9rZT0iIzE4MTgxOCIgc3Ryb2tlLXdpZHRoPSIxLjgiIGZpbGw9Im5vbmUiPjxsaW5lIHgxPSIwLjUiIHkxPSI3IiB4Mj0iMTYuNSIgeTI9IjciPjwvbGluZT48cG9seWxpbmUgcG9pbnRzPSI5LjUgMCAxNi41IDcgOS41IDE0Ij48L3BvbHlsaW5lPjwvZz48L3N2Zz4=);\\n    background-position: 50%;\\n    background-repeat: no-repeat;\\n    background-origin: content-box;\\n    background-size: 40px 40px;\\n    box-shadow: 0 1px 1px rgba(0,0,0,.05),0 2px 2px rgba(0,0,0,.05),0 4px 4px rgba(0,0,0,.05);\\n    transition: transform 50ms ease-out;\\n}\\n\\n.button:hover {\\n    transform: scale(1.2);\\n}\\n\\n.button:active {\\n    transform: scale(1.1);\\n    transition: transform 50ms ease-in;\\n    background-color: #f0f0f0;\\n}\\n\\n.button-left {\\n    left: 8px;\\n    transform: scaleX(-1);\\n}\\n\\n.button-left:hover {\\n    transform: scaleX(-1) scale(1.2);\\n}\\n\\n.button-right {\\n    right: 8px;\\n}\\n\\n.ya-slider-leftmost .button-left,.ya-slider-rightmost .button-right {\\n    display: none;\\n}\",\"gridColumns\":\"7\",\"gridRows\":\"1\"},{\"value\":\"15\",\"label\":\"Слайдер: картинка снизу, без фона\",\"props\":{},\"template\":\"<div class=\\\"headline\\\">Читайте также</div>\\n<ya-units-slider class=\\\"slider\\\">\\n<div class=\\\"unit\\\">\\n    <ya-unit-kebab />\\n    <div class=\\\"text-block\\\">\\n        <div class=\\\"meta\\\">\\n            <ya-unit-category class=\\\"meta-span category\\\" />\\n            <ya-unit-date class=\\\"meta-span date\\\" />\\n            <ya-unit-age class=\\\"meta-span age\\\" />\\n        </div>\\n        <ya-clamp class=\\\"title\\\" lines=\\\"3\\\">\\n            <ya-unit-title />\\n        </ya-clamp>\\n        <ya-clamp class=\\\"description\\\" lines=\\\"2\\\">\\n            <ya-unit-desc />\\n        </ya-clamp>\\n        <div class=\\\"domain-block\\\">\\n            <ya-unit-domain class=\\\"domain\\\" />\\n            <span class=\\\"favicon\\\">\\n                <ya-unit-favicon size=\\\"16\\\" />\\n            </span>\\n        </div>\\n    </div>\\n    <div class=\\\"image\\\">\\n        <ya-unit-image ratio=\\\"0.667\\\" />\\n    </div>\\n</div>\\n<ya-slider-button direction=\\\"left\\\">\\n    <div class=\\\"button button-left\\\"></div>\\n</ya-slider-button>\\n<ya-slider-button direction=\\\"right\\\">\\n    <div class=\\\"button button-right\\\"></div>\\n</ya-slider-button>\\n</ya-units-slider>\\n<ya-recommendation-label />\",\"css\":\".headline {\\n    font-family: Helvetica,Arial,sans-serif;\\n    font-size: 20px;\\n    font-weight: 700;\\n    line-height: 24px;\\n    padding-bottom: 12px;\\n    padding-top: 20px;\\n    color: #333;\\n}\\n\\n.ya-units-slider {\\n    width: 100%;\\n}\\n\\n.ya-slider-item {\\n    display: -webkit-flex;\\n    display: -ms-flexbox;\\n    display: flex;\\n    width: 240px;\\n    border-radius: 8px;\\n}\\n\\n.ya-slider-item:not(:first-child) {\\n    margin-left: 12px;\\n}\\n\\n.ya-ad-close {\\n    background: none;\\n    width: 20px;\\n    height: 20px;\\n}\\n\\n.yrw-url {\\n    height: 100%;\\n}\\n\\n.unit {\\n    font-family: Helvetica,Arial,sans-serif;\\n    text-decoration: none;\\n    position: relative;\\n    display: flex;\\n    flex-direction: column;\\n    flex-wrap: nowrap;\\n    box-sizing: border-box;\\n    height: 100%;\\n    cursor: pointer;\\n    margin: 0 auto;\\n    width: 240px;\\n    border-radius: 8px;\\n    overflow: hidden;\\n    -webkit-transform: translateZ(0);\\n}\\n\\n.text-block {\\n    padding-top: 12px;\\n    padding-bottom: 12px;\\n}\\n\\n.title {\\n    color: #000;\\n    font-size: 15px;\\n    line-height: 20px;\\n    font-style: normal;\\n    font-weight: 700;\\n    margin-top: 8px;\\n}\\n\\n.description {\\n    font-size: 14px;\\n    line-height: 20px;\\n    color: #505050;\\n    font-style: normal;\\n    font-weight: 400;\\n    margin-top: 4px;\\n}\\n\\n.meta {\\n    color: silver;\\n    font-style: normal;\\n    font-weight: 400;\\n    font-size: 12px;\\n    line-height: 16px;\\n}\\n\\n.meta-span {\\n    padding: 0;\\n}\\n\\n.meta-span:before {\\n    content: \\\" · \\\";\\n}\\n\\n.meta-span:first-child:before {\\n    content: none;\\n}\\n\\n.meta-span:empty {\\n    display: none;\\n}\\n\\n.domain-block {\\n    color: #000;\\n    font-style: normal;\\n    font-weight: 400;\\n    font-size: 14px;\\n    line-height: 12px;\\n    display: flex;\\n    align-items: center;\\n    position: relative;\\n}\\n\\n.domain:empty,.domain:empty ~ .favicon {\\n    display: none;\\n}\\n\\n.domain {\\n    margin-top: 8px;\\n    padding-left: 24px;\\n}\\n\\n.favicon {\\n    width: 16px;\\n    height: 16px;\\n    background-color: rgba(0 0 0 / 10%);\\n    display: inline-block;\\n    margin-right: 8px;\\n    position: absolute;\\n    top: 0;\\n    left: 0;\\n    margin-top: 8px;\\n    border-radius: 4px;\\n}\\n\\n.unit:hover .title {\\n    color: #4A4C4F;\\n}\\n\\n.unit:hover .description {\\n    color: gray;\\n}\\n\\n.unit:hover .domain-block {\\n    color: #4A4C4F;\\n}\\n\\n.image {\\n    margin-top: auto;\\n    margin-bottom: 0;\\n    border-radius: 8px;\\n    overflow: hidden;\\n    -webkit-transform: translateZ(0);\\n}\\n\\n.img-source-component {\\n    transition: transform 100ms ease;\\n    border-radius: 0;\\n}\\n\\n.unit-wrapper:hover .unit-image .img-source-component {\\n    transform: scale(1.05);\\n    -webkit-transform: scale(1.05);\\n}\\n\\n.unit:active .unit-image .img-source-component {\\n    transform: scale(1.025);\\n    -webkit-transform: scale(1.025);\\n}\\n\\n.ya-ad-warning,.yrw-ya-unit-image-footer {\\n    transform: translateZ(0);\\n}\\n\\n.unit-image {\\n    max-height: 180px;\\n}\\n\\n.recommendation-label {\\n    display: block;\\n    width: 100%;\\n    color: #ddd;\\n    text-align: right;\\n}\\n\\n.button {\\n    width: 40px;\\n    height: 40px;\\n    border-radius: 20px;\\n    position: absolute;\\n    cursor: pointer;\\n    z-index: 999;\\n    top: 43%;\\n    background-color: #FFF;\\n    background-image: url(data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDBweCIgaGVpZ2h0PSI0MHB4IiB2aWV3Qm94PSIwIDAgNDAgNDAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PGcgdHJhbnNmb3JtPSJ0cmFuc2xhdGUoMTEuMCwgMTMuMCkiIHN0cm9rZT0iIzE4MTgxOCIgc3Ryb2tlLXdpZHRoPSIxLjgiIGZpbGw9Im5vbmUiPjxsaW5lIHgxPSIwLjUiIHkxPSI3IiB4Mj0iMTYuNSIgeTI9IjciPjwvbGluZT48cG9seWxpbmUgcG9pbnRzPSI5LjUgMCAxNi41IDcgOS41IDE0Ij48L3BvbHlsaW5lPjwvZz48L3N2Zz4=);\\n    background-position: 50%;\\n    background-repeat: no-repeat;\\n    background-origin: content-box;\\n    background-size: 40px 40px;\\n    box-shadow: 0 1px 1px rgba(0,0,0,0.05),0 2px 2px rgba(0,0,0,0.05),0 4px 4px rgba(0,0,0,0.05);\\n    transition: transform 50ms ease-out;\\n}\\n\\n.button:hover {\\n    transform: scale(1.2);\\n}\\n\\n.button:active {\\n    transform: scale(1.1);\\n    transition: transform 50ms ease-in;\\n    background-color: #f0f0f0;\\n}\\n\\n.button-left {\\n    left: 8px;\\n    transform: scaleX(-1);\\n}\\n\\n.button-left:hover {\\n    transform: scaleX(-1) scale(1.2);\\n}\\n\\n.button-right {\\n    right: 8px;\\n}\\n\\n.ya-slider-leftmost .button-left,.ya-slider-rightmost .button-right {\\n    display: none;\\n}\",\"gridColumns\":\"7\",\"gridRows\":\"1\"},{\"value\":\"16\",\"label\":\"Слайдер: квадратная картинка, с фоном\",\"props\":{},\"template\":\"<div class=\\\"headline\\\">Читайте также</div>\\n<ya-units-slider>\\n<div class=\\\"container\\\">\\n    <div class=\\\"image\\\">\\n        <ya-unit-image ratio=\\\"1\\\" />\\n    </div>\\n    <div class=\\\"body\\\">\\n        <div>\\n            <ya-unit-kebab />\\n            <ya-unit-title class=\\\"title\\\" />\\n        </div>\\n        <ya-clamp class=\\\"description\\\" lines=\\\"3\\\">\\n            <ya-unit-desc />\\n        </ya-clamp>\\n        <div class=\\\"meta\\\">\\n            <ya-unit-category class=\\\"meta-span category\\\" />\\n            <ya-unit-date class=\\\"meta-span date\\\"/>\\n            <ya-unit-age class=\\\"meta-span age\\\" />\\n        </div>\\n        <div class=\\\"domain-block\\\">\\n            <ya-unit-domain class=\\\"domain\\\"/>\\n            <span class=\\\"favicon\\\">\\n                <ya-unit-favicon size=\\\"16\\\"/>\\n            </span>\\n        </div>\\n        <ya-unit-warning class=\\\"warning\\\" />\\n    </div>\\n</div>\\n<ya-slider-button direction=\\\"left\\\">\\n    <div class=\\\"button button-left\\\"></div>\\n</ya-slider-button>\\n<ya-slider-button direction=\\\"right\\\">\\n    <div class=\\\"button button-right\\\"></div>\\n</ya-slider-button>\\n</ya-units-slider>\\n<ya-recommendation-label />\",\"css\":\".headline {\\n    font-family: Helvetica,Arial,sans-serif;\\n    font-size: 20px;\\n    font-weight: 700;\\n    line-height: 24px;\\n    color: #373e44;\\n    padding-bottom: 20px;\\n    padding-top: 20px;\\n}\\n\\n.ya-units-slider {\\n    width: 100%;\\n}\\n\\n.ya-slider-item:not(:first-child) {\\n    margin-left: 20px;\\n}\\n\\n.unit-wrapper {\\n    width: 280px;\\n    height: 100%;\\n    background: #f0f1f5;\\n    overflow: hidden;\\n    border-radius: 8px;\\n}\\n\\n.unit-wrapper:hover {\\n    background: #e1e2e5;\\n}\\n\\n.unit-wrapper:active {\\n    background: #d7d8db;\\n}\\n\\n.container {\\n    position: relative;\\n    display: flex;\\n    flex-direction: row;\\n    flex-wrap: nowrap;\\n    width: 100%;\\n}\\n\\n.image {\\n    flex: 0 0 auto;\\n    width: 64px;\\n    margin-left: 16px;\\n    margin-top: 16px;\\n}\\n\\n.unit-image {\\n    border-radius: 8px;\\n}\\n\\n.description,.domain-block,.title {\\n    color: #000;\\n    font-style: normal;\\n    font-weight: 700;\\n    font-size: 16px;\\n    line-height: 20px;\\n    margin-top: 16px;\\n    margin-left: 16px;\\n    margin-right: 16px;\\n}\\n\\n.ya-unit-close~.ya-unit-title {\\n    margin-right: 16px;\\n}\\n\\n.description,.domain-block {\\n    font-weight: 400;\\n    font-size: 14px;\\n    color: #666;\\n    margin-top: 12px;\\n}\\n\\n.domain-block {\\n    color: #000;\\n    line-height: 16px;\\n    display: flex;\\n    align-items: center;\\n    position: relative;\\n}\\n\\n.domain:empty~.favicon,.meta-span:empty,.ya-unit-warning:empty {\\n    display: none;\\n}\\n\\n.domain {\\n    padding-left: 24px;\\n}\\n\\n.favicon {\\n    width: 16px;\\n    height: 16px;\\n    background-color: rgba(0 0 0/10%);\\n    display: inline-block;\\n    margin-right: 8px;\\n    position: absolute;\\n    top: 0;\\n    left: 0;\\n    border-radius: 4px;\\n}\\n\\n.meta {\\n    color: silver;\\n    font-style: normal;\\n    font-weight: 400;\\n    font-size: 12px;\\n    line-height: 16px;\\n    margin-top: 12px;\\n    margin-left: 16px;\\n    margin-right: 16px;\\n}\\n\\n.meta-span {\\n    padding: 0;\\n}\\n\\n.meta-span:before {\\n    content: \\\" · \\\";\\n}\\n\\n.meta-span:first-child:before {\\n    content: none;\\n}\\n\\n.warning {\\n    color: silver;\\n    font-style: normal;\\n    font-weight: 400;\\n    font-size: 12px;\\n    line-height: 16px;\\n    margin-top: 12px;\\n    margin-left: 16px;\\n    margin-right: 16px;\\n}\\n\\n.button {\\n    width: 40px;\\n    height: 40px;\\n    border-radius: 20px;\\n    position: absolute;\\n    cursor: pointer;\\n    z-index: 999;\\n    bottom: 39%;\\n    background-color: #fff;\\n    background-image: url(data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDAiIGhlaWdodD0iNDAiIHZpZXdCb3g9IjAgMCA0MCA0MCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTI3LjY2NjYgMjBMMjguMzczNyAyMC43MDcxQzI4Ljc2NDMgMjAuMzE2NiAyOC43NjQzIDE5LjY4MzQgMjguMzczNyAxOS4yOTI5TDI3LjY2NjYgMjBaTTExLjMzMzMgMjFIMjcuNjY2NlYxOUgxMS4zMzMzVjIxWk0xOS45NTk1IDEzLjcwNzFMMjYuOTU5NSAyMC43MDcxTDI4LjM3MzcgMTkuMjkyOUwyMS4zNzM3IDEyLjI5MjlMMTkuOTU5NSAxMy43MDcxWk0yNi45NTk1IDE5LjI5MjlMMTkuOTU5NSAyNi4yOTI5TDIxLjM3MzcgMjcuNzA3MUwyOC4zNzM3IDIwLjcwNzFMMjYuOTU5NSAxOS4yOTI5WiIgZmlsbD0iYmxhY2siIGZpbGwtb3BhY2l0eT0iMC45Ii8+Cjwvc3ZnPgo=);\\n    background-position: 50%;\\n    background-repeat: no-repeat;\\n    background-origin: content-box;\\n    background-size: 40px 40px;\\n    box-shadow: 0 1px 1px rgba(0,0,0,.05),0 2px 2px rgba(0,0,0,.05),0 4px 4px rgba(0,0,0,.05);\\n    transition: transform 50ms ease-out;\\n}\\n\\n.button:hover {\\n    transform: scale(1.2);\\n}\\n\\n.button:active {\\n    transform: scale(1.1);\\n    transition: transform 50ms ease-in;\\n    background-color: #f0f0f0;\\n}\\n\\n.button-left {\\n    left: 8px;\\n    transform: scaleX(-1);\\n}\\n\\n.button-left:hover {\\n    transform: scaleX(-1) scale(1.2);\\n}\\n\\n.button-right {\\n    right: 8px;\\n}\\n\\n.ya-slider-leftmost .button-left,.ya-slider-rightmost .button-right {\\n    display: none;\\n}\\n\\n.recommendation-label {\\n    display: block;\\n    width: 100%;\\n    color: #ddd;\\n    text-align: right;\\n}\",\"gridColumns\":\"7\",\"gridRows\":\"1\"},{\"value\":\"17\",\"label\":\"Слайдер: квадратная картинка, без фона\",\"props\":{},\"template\":\"<div class=\\\"headline\\\">Читайте также</div>\\n<ya-units-slider>\\n<div class=\\\"container\\\">\\n    <div class=\\\"image\\\">\\n        <ya-unit-image ratio=\\\"1\\\" />\\n    </div>\\n    <div class=\\\"body\\\">\\n        <div>\\n            <ya-unit-kebab />\\n            <ya-unit-title class=\\\"title\\\" />\\n        </div>\\n        <ya-clamp class=\\\"description\\\" lines=\\\"3\\\">\\n            <ya-unit-desc />\\n        </ya-clamp>\\n        <div class=\\\"meta\\\">\\n            <ya-unit-category class=\\\"meta-span category\\\" />\\n            <ya-unit-date class=\\\"meta-span date\\\"/>\\n            <ya-unit-age class=\\\"meta-span age\\\" />\\n        </div>\\n        <div class=\\\"domain-block\\\">\\n            <ya-unit-domain class=\\\"domain\\\"/>\\n            <span class=\\\"favicon\\\">\\n                <ya-unit-favicon size=\\\"16\\\"/>\\n            </span>\\n        </div>\\n        <ya-unit-warning class=\\\"warning\\\" />\\n    </div>\\n</div>\\n<ya-slider-button direction=\\\"left\\\">\\n    <div class=\\\"button button-left\\\"></div>\\n</ya-slider-button>\\n<ya-slider-button direction=\\\"right\\\">\\n    <div class=\\\"button button-right\\\"></div>\\n</ya-slider-button>\\n</ya-units-slider>\\n<ya-recommendation-label />\",\"css\":\".headline {\\n    font-family: Helvetica,Arial,sans-serif;\\n    font-size: 20px;\\n    font-weight: 700;\\n    line-height: 24px;\\n    color: #373e44;\\n    padding-bottom: 20px;\\n    padding-top: 20px;\\n}\\n\\n.ya-units-slider {\\n    width: 100%;\\n}\\n\\n.ya-slider-item:not(:first-child) {\\n    margin-left: 20px;\\n}\\n\\n.ya-ad-close {\\n    background: 0 0;\\n    width: 20px;\\n    height: 20px;\\n}\\n\\n.unit-wrapper {\\n    width: 280px;\\n    height: 100%;\\n    background-color: #fff;\\n    transition: transform 50ms ease-out;\\n}\\n\\n.unit-wrapper:hover {\\n    transform: translateY(2px);\\n}\\n\\n.unit-wrapper:active {\\n    transform: translateY(4px);\\n}\\n\\n.container {\\n    position: relative;\\n    display: flex;\\n    flex-direction: row;\\n    flex-wrap: nowrap;\\n    width: 100%;\\n}\\n\\n.image {\\n    flex: 0 0 auto;\\n    width: 64px;\\n    margin-right: 16px;\\n}\\n\\n.unit-image {\\n    border-radius: 8px;\\n}\\n\\n.description,.domain-block,.title {\\n    color: #000;\\n    font-style: normal;\\n    font-weight: 700;\\n    font-size: 16px;\\n    line-height: 20px;\\n}\\n\\n.ya-unit-close~.ya-unit-title {\\n    margin-right: 16px;\\n}\\n\\n.description,.domain-block {\\n    font-weight: 400;\\n    font-size: 14px;\\n    color: #666;\\n    margin-top: 12px;\\n}\\n\\n.domain-block {\\n    color: #000;\\n    line-height: 16px;\\n    display: flex;\\n    align-items: center;\\n    position: relative;\\n}\\n\\n.domain:empty~.favicon,.meta-span:empty,.ya-unit-warning:empty {\\n    display: none;\\n}\\n\\n.domain {\\n    padding-left: 24px;\\n}\\n\\n.favicon {\\n    width: 16px;\\n    height: 16px;\\n    background-color: rgba(0 0 0/10%);\\n    display: inline-block;\\n    margin-right: 8px;\\n    position: absolute;\\n    top: 0;\\n    left: 0;\\n    border-radius: 4px;\\n}\\n\\n.meta {\\n    color: silver;\\n    font-style: normal;\\n    font-weight: 400;\\n    font-size: 12px;\\n    line-height: 16px;\\n    margin-top: 12px;\\n}\\n\\n.meta-span {\\n    padding: 0;\\n}\\n\\n.meta-span:before {\\n    content: \\\" · \\\";\\n}\\n\\n.meta-span:first-child:before {\\n    content: none;\\n}\\n\\n.warning {\\n    color: silver;\\n    font-style: normal;\\n    font-weight: 400;\\n    font-size: 12px;\\n    line-height: 16px;\\n    margin-top: 12px;\\n}\\n\\n.button {\\n    width: 40px;\\n    height: 40px;\\n    border-radius: 20px;\\n    position: absolute;\\n    cursor: pointer;\\n    z-index: 999;\\n    bottom: 39%;\\n    background-color: #fff;\\n    background-image: url(data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDAiIGhlaWdodD0iNDAiIHZpZXdCb3g9IjAgMCA0MCA0MCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTI3LjY2NjYgMjBMMjguMzczNyAyMC43MDcxQzI4Ljc2NDMgMjAuMzE2NiAyOC43NjQzIDE5LjY4MzQgMjguMzczNyAxOS4yOTI5TDI3LjY2NjYgMjBaTTExLjMzMzMgMjFIMjcuNjY2NlYxOUgxMS4zMzMzVjIxWk0xOS45NTk1IDEzLjcwNzFMMjYuOTU5NSAyMC43MDcxTDI4LjM3MzcgMTkuMjkyOUwyMS4zNzM3IDEyLjI5MjlMMTkuOTU5NSAxMy43MDcxWk0yNi45NTk1IDE5LjI5MjlMMTkuOTU5NSAyNi4yOTI5TDIxLjM3MzcgMjcuNzA3MUwyOC4zNzM3IDIwLjcwNzFMMjYuOTU5NSAxOS4yOTI5WiIgZmlsbD0iYmxhY2siIGZpbGwtb3BhY2l0eT0iMC45Ii8+Cjwvc3ZnPgo=);\\n    background-position: 50%;\\n    background-repeat: no-repeat;\\n    background-origin: content-box;\\n    background-size: 40px 40px;\\n    box-shadow: 0 1px 1px rgba(0,0,0,.05),0 2px 2px rgba(0,0,0,.05),0 4px 4px rgba(0,0,0,.05);\\n    transition: transform 50ms ease-out;\\n}\\n\\n.button:hover {\\n    transform: scale(1.2);\\n}\\n\\n.button:active {\\n    transform: scale(1.1);\\n    transition: transform 50ms ease-in;\\n    background-color: #f0f0f0;\\n}\\n\\n.button-left {\\n    left: 8px;\\n    transform: scaleX(-1);\\n}\\n\\n.button-left:hover {\\n    transform: scaleX(-1) scale(1.2);\\n}\\n\\n.button-right {\\n    right: 8px;\\n}\\n\\n.ya-slider-leftmost .button-left,.ya-slider-rightmost .button-right {\\n    display: none;\\n}\\n\\n.recommendation-label {\\n    display: block;\\n    width: 100%;\\n    color: #ddd;\\n    text-align: right;\\n}\",\"gridColumns\":\"7\",\"gridRows\":\"1\"},{\"value\":\"18\",\"label\":\"Слайдер: без картинки, с фоном\",\"props\":{},\"template\":\"<div class=\\\"block\\\">\\n<div class=\\\"headline\\\">Читайте также</div>\\n<ya-units-slider>\\n    <div class=\\\"unit\\\">\\n        <ya-unit-kebab />\\n        <div class=\\\"body\\\">\\n            <ya-clamp class=\\\"title\\\" lines=\\\"3\\\">\\n                <ya-unit-title />\\n            </ya-clamp>\\n            <ya-clamp class=\\\"description\\\" lines=\\\"3\\\">\\n                <ya-unit-desc />\\n            </ya-clamp>\\n            <div class=\\\"meta\\\">\\n                <ya-unit-category class=\\\"meta-span category\\\" />\\n                <ya-unit-date class=\\\"meta-span date\\\" />\\n                <ya-unit-age class=\\\"meta-span age\\\" />\\n            </div>\\n            <div class=\\\"domain-block\\\">\\n                <ya-unit-domain class=\\\"domain\\\" /><span class=\\\"favicon\\\">\\n                    <ya-unit-favicon size=\\\"16\\\" /></span></div>\\n            <div class=\\\"warning\\\"></div>\\n        </div>\\n    </div>\\n    <ya-slider-button direction=\\\"left\\\">\\n        <div class=\\\"button button-left\\\"></div>\\n    </ya-slider-button>\\n    <ya-slider-button direction=\\\"right\\\">\\n        <div class=\\\"button button-right\\\"></div>\\n    </ya-slider-button>\\n</ya-units-slider>\\n<div class=\\\"recommendation-label\\\">\\n    <ya-recommendation-label class=\\\"label\\\" />\\n</div>\\n</div>\",\"css\":\".ya-units-slider {\\n    width: 100%;\\n}\\n\\n.ya-slider-item:not(:first-child) {\\n    margin-left: 12px;\\n}\\n\\n.block {\\n    padding: 0;\\n}\\n\\n.headline,.label {\\n    font-family: Helvetica,Arial,sans-serif;\\n}\\n\\n.label {\\n    display: block;\\n    font-size: 12px;\\n    color: #999;\\n}\\n\\n.headline {\\n    font-size: 20px;\\n    font-weight: 700;\\n    line-height: 24px;\\n    color: #373e44;\\n    padding-bottom: 12px;\\n    padding-top: 20px;\\n}\\n\\n.unit-wrapper {\\n    height: 100%;\\n}\\n\\n.image,.unit {\\n    position: relative;\\n    overflow: hidden;\\n}\\n\\n.unit {\\n    width: 240px;\\n    box-sizing: border-box;\\n    margin: 0 auto;\\n    -webkit-transform: translateZ(0);\\n    font-family: Helvetica,Arial,sans-serif;\\n    height: 100%;\\n    background: #f0f1f5;\\n    border-radius: 8px;\\n    display: flex;\\n    flex-direction: column;\\n    flex-wrap: nowrap;\\n    text-decoration: none;\\n    color: #000;\\n    cursor: pointer;\\n}\\n\\n.unit:hover {\\n    background: #e1e2e5;\\n}\\n\\n.unit:active {\\n    background: #d7d8db;\\n}\\n\\n.unit-container .ya-ad-warning {\\n    border-radius: 0 0 8px 8px;\\n}\\n\\n.image {\\n    display: block;\\n    flex-grow: 0;\\n    flex-shrink: 0;\\n}\\n\\n.img-source-component {\\n    transition: transform 100ms ease;\\n    border-radius: 0;\\n}\\n\\n.unit-wrapper:hover .unit-image .img-source-component {\\n    transform: scale(1.05);\\n}\\n\\n.unit-image {\\n    max-height: 200px;\\n}\\n\\n.body {\\n    position: relative;\\n    display: flex;\\n    flex-direction: column;\\n    width: 100%;\\n}\\n\\nya-image {\\n    max-height: 100px;\\n}\\n\\n.title {\\n    color: #000;\\n    font-style: normal;\\n    font-weight: 700;\\n    font-size: 16px;\\n    line-height: 20px;\\n    margin-top: 16px;\\n    padding-left: 16px;\\n    padding-right: 16px;\\n}\\n\\n.description,.domain-block {\\n    font-style: normal;\\n    font-weight: 400;\\n    font-size: 14px;\\n    margin-top: 12px;\\n}\\n\\n.description {\\n    line-height: 20px;\\n    color: #505050;\\n    padding-left: 16px;\\n    padding-right: 16px;\\n}\\n\\n.domain-block {\\n    color: #000;\\n    line-height: 16px;\\n    margin-left: 16px;\\n    margin-right: 16px;\\n    display: flex;\\n    align-items: center;\\n    position: relative;\\n}\\n\\n.domain:empty~.favicon {\\n    display: none;\\n}\\n\\n.domain {\\n    padding-left: 24px;\\n}\\n\\n.favicon {\\n    width: 16px;\\n    height: 16px;\\n    background-color: rgba(0 0 0/10%);\\n    display: inline-block;\\n    margin-right: 8px;\\n    position: absolute;\\n    top: 0;\\n    left: 0;\\n    border-radius: 4px;\\n}\\n\\n.meta {\\n    color: silver;\\n    font-style: normal;\\n    font-weight: 400;\\n    font-size: 12px;\\n    line-height: 16px;\\n    margin-top: 12px;\\n    padding-left: 16px;\\n    padding-right: 16px;\\n}\\n\\n.meta:last-child {\\n    padding-bottom: 16px;\\n}\\n\\n.meta-span {\\n    padding: 0;\\n}\\n\\n.meta-span:before {\\n    content: \\\" · \\\";\\n}\\n\\n.meta-span:first-child:before {\\n    content: none;\\n}\\n\\n.meta-span:empty,.unit-warning:empty {\\n    display: none;\\n}\\n\\n.unit-warning {\\n    position: relative;\\n    height: 24px;\\n    bottom: 24px;\\n    border-radius: 0 0 8px 8px;\\n    overflow: hidden;\\n    z-index: 99;\\n}\\n\\n.warning {\\n    min-height: 16px;\\n}\\n\\n.button {\\n    width: 40px;\\n    height: 40px;\\n    border-radius: 20px;\\n    position: absolute;\\n    cursor: pointer;\\n    z-index: 999;\\n    bottom: 39%;\\n    background-color: #fff;\\n    background-image: url(data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDBweCIgaGVpZ2h0PSI0MHB4IiB2aWV3Qm94PSIwIDAgNDAgNDAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PGcgdHJhbnNmb3JtPSJ0cmFuc2xhdGUoMTEuMCwgMTMuMCkiIHN0cm9rZT0iIzE4MTgxOCIgc3Ryb2tlLXdpZHRoPSIxLjgiIGZpbGw9Im5vbmUiPjxsaW5lIHgxPSIwLjUiIHkxPSI3IiB4Mj0iMTYuNSIgeTI9IjciPjwvbGluZT48cG9seWxpbmUgcG9pbnRzPSI5LjUgMCAxNi41IDcgOS41IDE0Ij48L3BvbHlsaW5lPjwvZz48L3N2Zz4=);\\n    background-position: 50%;\\n    background-repeat: no-repeat;\\n    background-origin: content-box;\\n    background-size: 40px 40px;\\n    box-shadow: 0 1px 1px rgba(0,0,0,.05),0 2px 2px rgba(0,0,0,.05),0 4px 4px rgba(0,0,0,.05);\\n    transition: transform 50ms ease-out;\\n}\\n\\n.button:hover {\\n    transform: scale(1.2);\\n}\\n\\n.button:active {\\n    transform: scale(1.1);\\n    transition: transform 50ms ease-in;\\n    background-color: #f0f0f0;\\n}\\n\\n.button-left {\\n    left: 8px;\\n    transform: scaleX(-1);\\n}\\n\\n.button-left:hover {\\n    transform: scaleX(-1) scale(1.2);\\n}\\n\\n.button-right {\\n    right: 8px;\\n}\\n\\n.ya-slider-leftmost .button-left,.ya-slider-rightmost .button-right {\\n    display: none;\\n}\\n\\n.recommendation-label {\\n    display: block;\\n    width: 100%;\\n    color: #ddd;\\n    text-align: right;\\n}\",\"gridColumns\":\"7\",\"gridRows\":\"1\"},{\"value\":\"19\",\"label\":\"Слайдер: без картинки, без фона\",\"props\":{},\"template\":\"<div class=\\\"headline\\\">Читайте также</div>\\n<ya-units-slider>\\n<div class=\\\"container\\\">\\n    <div class=\\\"body\\\">\\n        <div>\\n            <ya-unit-kebab />\\n            <ya-unit-title class=\\\"title\\\" />\\n        </div>\\n        <ya-clamp class=\\\"description\\\" lines=\\\"3\\\">\\n            <ya-unit-desc />\\n        </ya-clamp>\\n        <div class=\\\"meta\\\">\\n            <ya-unit-category class=\\\"meta-span category\\\" />\\n            <ya-unit-date class=\\\"meta-span date\\\" />\\n            <ya-unit-age class=\\\"meta-span age\\\" />\\n        </div>\\n        <div class=\\\"domain-block\\\">\\n            <ya-unit-domain class=\\\"domain\\\" />\\n            <span class=\\\"favicon\\\">\\n                <ya-unit-favicon size=\\\"16\\\" />\\n            </span>\\n        </div>\\n        <div class=\\\"meta\\\">\\n            <ya-unit-warning class=\\\"meta-span warning\\\" />\\n        </div>\\n    </div>\\n</div>\\n<ya-slider-button direction=\\\"left\\\">\\n    <div class=\\\"button button-left\\\"></div>\\n</ya-slider-button>\\n<ya-slider-button direction=\\\"right\\\">\\n    <div class=\\\"button button-right\\\"></div>\\n</ya-slider-button>\\n</ya-units-slider>\\n<ya-recommendation-label />\",\"css\":\".headline {\\n    font-family: Helvetica,Arial,sans-serif;\\n    font-size: 20px;\\n    font-weight: 700;\\n    line-height: 24px;\\n    color: #373e44;\\n    padding-bottom: 20px;\\n    padding-top: 12px;\\n}\\n\\n.ya-units-slider {\\n    width: 100%;\\n}\\n\\n.ya-slider-item:not(:first-child) {\\n    margin-left: 20px;\\n}\\n\\n.ya-ad-close {\\n    background: 0 0;\\n    width: 20px;\\n    height: 20px;\\n}\\n\\n.unit-wrapper {\\n    width: 280px;\\n    height: 100%;\\n    background-color: #fff;\\n    transition: transform 50ms ease-out;\\n}\\n\\n.unit-wrapper:hover {\\n    transform: translateY(2px);\\n}\\n\\n.unit-wrapper:active {\\n    transform: translateY(4px);\\n}\\n\\n.container {\\n    position: relative;\\n    display: flex;\\n    flex-direction: row;\\n    flex-wrap: nowrap;\\n    width: 100%;\\n}\\n\\n.image {\\n    flex: 0 0 auto;\\n    width: 64px;\\n    margin-right: 16px;\\n}\\n\\n.unit-image {\\n    border-radius: 8px;\\n}\\n\\n.description {\\n    line-height: 20px;\\n}\\n\\n.description,.domain-block,.title {\\n    font-style: normal;\\n}\\n\\n.title {\\n    color: #000;\\n    font-weight: 700;\\n    font-size: 16px;\\n    line-height: 20px;\\n}\\n\\n.ya-unit-close~.ya-unit-title {\\n    margin-right: 16px;\\n}\\n\\n.description,.domain-block {\\n    font-weight: 400;\\n    font-size: 14px;\\n    color: #666;\\n    margin-top: 12px;\\n}\\n\\n.domain-block {\\n    color: #000;\\n    line-height: 16px;\\n    display: flex;\\n    align-items: center;\\n    position: relative;\\n}\\n\\n.domain:empty~.favicon,.meta-span:empty {\\n    display: none;\\n}\\n\\n.domain {\\n    padding-left: 24px;\\n}\\n\\n.favicon {\\n    width: 16px;\\n    height: 16px;\\n    background-color: rgba(0 0 0/10%);\\n    display: inline-block;\\n    margin-right: 8px;\\n    position: absolute;\\n    top: 0;\\n    left: 0;\\n    border-radius: 4px;\\n}\\n\\n.meta {\\n    color: silver;\\n    font-style: normal;\\n    font-weight: 400;\\n    font-size: 12px;\\n    line-height: 16px;\\n    margin-top: 12px;\\n}\\n\\n.meta-span {\\n    padding: 0;\\n}\\n\\n.meta-span:before {\\n    content: \\\" · \\\";\\n}\\n\\n.meta-span:first-child:before {\\n    content: none;\\n}\\n\\n.button {\\n    width: 40px;\\n    height: 40px;\\n    border-radius: 20px;\\n    position: absolute;\\n    cursor: pointer;\\n    z-index: 999;\\n    bottom: 45%;\\n    background-color: #fff;\\n    background-image: url(data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDAiIGhlaWdodD0iNDAiIHZpZXdCb3g9IjAgMCA0MCA0MCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTI3LjY2NjYgMjBMMjguMzczNyAyMC43MDcxQzI4Ljc2NDMgMjAuMzE2NiAyOC43NjQzIDE5LjY4MzQgMjguMzczNyAxOS4yOTI5TDI3LjY2NjYgMjBaTTExLjMzMzMgMjFIMjcuNjY2NlYxOUgxMS4zMzMzVjIxWk0xOS45NTk1IDEzLjcwNzFMMjYuOTU5NSAyMC43MDcxTDI4LjM3MzcgMTkuMjkyOUwyMS4zNzM3IDEyLjI5MjlMMTkuOTU5NSAxMy43MDcxWk0yNi45NTk1IDE5LjI5MjlMMTkuOTU5NSAyNi4yOTI5TDIxLjM3MzcgMjcuNzA3MUwyOC4zNzM3IDIwLjcwNzFMMjYuOTU5NSAxOS4yOTI5WiIgZmlsbD0iYmxhY2siIGZpbGwtb3BhY2l0eT0iMC45Ii8+Cjwvc3ZnPgo=);\\n    background-position: 50%;\\n    background-repeat: no-repeat;\\n    background-origin: content-box;\\n    background-size: 40px 40px;\\n    box-shadow: 0 1px 1px rgba(0,0,0,.05),0 2px 2px rgba(0,0,0,.05),0 4px 4px rgba(0,0,0,.05);\\n    transition: transform 50ms ease-out;\\n}\\n\\n.button:hover {\\n    transform: scale(1.2);\\n}\\n\\n.button:active {\\n    transform: scale(1.1);\\n    transition: transform 50ms ease-in;\\n    background-color: #f0f0f0;\\n}\\n\\n.button-left {\\n    left: 8px;\\n    transform: scaleX(-1);\\n}\\n\\n.button-left:hover {\\n    transform: scaleX(-1) scale(1.2);\\n}\\n\\n.button-right {\\n    right: 8px;\\n}\\n\\n.ya-slider-leftmost .button-left,.ya-slider-rightmost .button-right {\\n    display: none;\\n}\\n\\n.recommendation-label {\\n    display: block;\\n    width: 100%;\\n    color: #ddd;\\n    text-align: right;\\n}\",\"gridColumns\":\"7\",\"gridRows\":\"1\"}]"),
    (0, NOW(), NOW(), 'ContentContextEnTemplates', "[{\"value\":\"1\",\"name\":\"grid\",\"label\":\"4x2 image, above\",\"props\":{},\"template\":\"<div class=\\\"block\\\">\\n    <div class=\\\"headline\\\">Читайте также</div>\\n    <ya-units-grid rows=\\\"${grid_rows}\\\" cols=\\\"${grid_columns}\\\">\\n        <div class=\\\"unit\\\">\\n            <div class=\\\"image\\\">\\n                <ya-unit-image ratio=\\\"0.5\\\" />\\n            </div>\\n            <div class=\\\"body\\\">\\n                <div class=\\\"title\\\">\\n                    <ya-clamp lines=\\\"3\\\"><ya-unit-title /></ya-clamp>\\n                </div>\\n                <div class=\\\"meta\\\">\\n                    <ya-unit-category class=\\\"category\\\"/>\\n                    <ya-unit-date class=\\\"date\\\"/>\\n                    <ya-unit-domain class=\\\"domain\\\"/>\\n                </div>\\n            </div>\\n        </div>\\n        <ya-unit-kebab />\\n    </ya-units-grid>\\n    <ya-recommendation-label />\\n</div>\",\"css\":\".block {\\n    padding: 15px 0;\\n}\\n.block-label {\\n    display: block;\\n    width: 100%;\\n    margin-top: 16px;\\n    text-align: right;\\n}\\n.label {\\n    display: block;\\n    font-family: Helvetica, Arial, sans-serif;\\n    font-size: 12px;\\n    color: #999999;\\n}\\n.headline {\\n    font-family: \\\"Open Sans\\\", Arial, sans-serif;\\n    font-size: 18px;\\n    font-weight: bold;\\n    line-height: 24px;\\n    color: #373e44;\\n    padding-bottom: 20px;\\n    padding-top: 15px;\\n}\\n.grid {\\n    display: flex;\\n    flex-direction: column;\\n    flex-wrap: wrap;\\n    justify-content: flex-start;\\n    align-items: stretch;\\n    align-content: flex-start;\\n    width: 100%;\\n    box-sizing: border-box;\\n}\\n.grid-row {\\n    position: relative;\\n    display: flex;\\n    flex-direction: row;\\n    flex-wrap: nowrap;\\n    justify-content: flex-start;\\n    align-items: stretch;\\n    align-content: flex-start;\\n    width: 100%;\\n    margin-top: 10px;\\n}\\n.grid-row:first-child {\\n    margin-top: 0;\\n}\\n.grid-item {\\n    position: relative;\\n    flex: 1 1 0px;\\n    margin-left: 10px;\\n}\\n.grid-item:first-child {\\n    margin-left: 0;\\n}\\n.unit-wrapper {\\n    position: relative;\\n    display: flex;\\n    box-sizing: border-box;\\n    margin: 0 auto;\\n    overflow: hidden;\\n        font-family: \\\"Open Sans\\\", Arial, sans-serif;\\n        width: 100%;\\n        height: 100%;\\n        box-shadow: inset 0 0 1px 0 #666;\\n        border-radius: 2px;\\n        background-color: #fff;\\n}\\n.unit {\\n    position: relative;\\n    display: flex;\\n    flex-direction: column;\\n    flex-wrap: nowrap;\\n    text-decoration: none;\\n    color: black;\\n    width: 100%;\\n    cursor: pointer;\\n}\\n.image {\\n    position: relative;\\n    display: block;\\n    flex-grow: 0;\\n    flex-shrink: 0;\\n    margin-bottom: 10px;\\n}\\n.body {\\n    position: relative;\\n    display: flex;\\n    flex-direction: column;\\n    width: 100%;\\n}\\nya-image {\\n    max-height: 100px;\\n}\\n.title {\\n    color: #000;\\n    line-height: 20px;\\n    font-size: 15px;\\n    font-weight: bold;\\n    padding-left: 10px;\\n    padding-right: 10px;\\n}\\n.meta {\\n    color: #757575;\\n    font-size: 12px;\\n    padding-left: 10px;\\n    padding-right: 10px;\\n    padding-top: 7px;\\n    padding-bottom: 10px;\\n}\\n.category {\\n    color: #093;\\n    padding-right: 20px;\\n}\",\"gridColumns\":\"4\",\"gridRows\":\"2\"},{\"value\":\"2\",\"label\":\"1x4 image on the left\",\"name\":\"grid\",\"props\":{},\"template\":\"<div class=\\\"headline\\\">Читайте также</div>\\n<ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n    <div class=\\\"container\\\">\\n        <div class=\\\"image\\\">\\n            <ya-unit-image />\\n        </div>\\n        <div class=\\\"body\\\">\\n            <div class=\\\"title\\\">\\n                <ya-unit-title />\\n            </div>\\n            <div class=\\\"meta\\\">\\n                <ya-unit-category class=\\\"category\\\"/>\\n                <ya-unit-date class=\\\"date\\\"/>\\n                <ya-unit-domain class=\\\"domain\\\" />\\n            </div>\\n        </div>\\n    </div>\\n    <ya-unit-kebab />\\n</ya-units-grid>\\n<ya-recommendation-label />\",\"css\":\".headline {\\n    font-size: 18px;\\n    font-weight: bold;\\n    line-height: 24px;\\n    color: #373e44;\\n    padding-bottom: 20px;\\n    padding-top: 15px;\\n}\\n.grid-row {\\n    margin-top: 10px;\\n}\\n.grid-item {\\n    margin-left: 10px;\\n}\\n.unit-wrapper {\\n    height: 100%;\\n    box-shadow: inset 0 0 1px 0 #666;\\n    border-radius: 2px;\\n    background-color: #fff;\\n}\\n.container {\\n    position: relative;\\n    display: flex;\\n    flex-direction: row;\\n    flex-wrap: nowrap;\\n    width: 100%;\\n}\\n.image {\\n    width: 200px;\\n    margin-right: 10px;\\n    flex:0 0 auto;\\n}\\n.title {\\n    color: #000;\\n    line-height: 24px;\\n    font-size: 18px;\\n    font-weight: bold;\\n    padding-left: 10px;\\n    padding-right: 10px;\\n}\\n.meta {\\n    color: #757575;\\n    font-size: 12px;\\n    padding-left: 10px;\\n    padding-right: 10px;\\n    padding-top: 7px;\\n    padding-bottom: 10px;\\n}\\n.category {\\n    color: #093;\\n    padding-right: 20px;\\n}\",\"gridColumns\":\"1\",\"gridRows\":\"4\"},{\"value\":\"3\",\"label\":\"3x2 image above\",\"name\":\"grid\",\"props\":{},\"template\":\"<div class=\\\"wrapper\\\">\\n    <div class=\\\"headline\\\">Читайте также</div>\\n    <ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\" target-blank>\\n        <div class=\\\"card\\\">\\n            <div class=\\\"image\\\">\\n                <ya-unit-image ratio=\\\"0.5\\\" />\\n            </div><ya-clamp lines=\\\"2\\\" class=\\\"title\\\"><ya-unit-title /></ya-clamp>\\n            <div class=\\\"meta\\\">\\n                <ya-unit-category class=\\\"category\\\"/>\\n            </div>\\n        </div>\\n        <ya-unit-kebab />\\n    </ya-units-grid>\\n    <ya-recommendation-label />\\n</div>\",\"css\":\".headline {\\n    font-size: 18px;\\n    font-weight: bold;\\n    line-height: 24px;\\n    color: #373e44;\\n    padding-bottom: 20px;\\n    padding-top: 15px;\\n}\\n.grid-row {\\n    margin-top: 10px;\\n}\\n.grid-item {\\n    margin-left: 10px;\\n}\\n.unit-wrapper {\\n    height: 100%;\\n    border: 1px solid gray;\\n    border-radius: 2px;\\n    background-color: #fff;\\n}\\n.image {\\n    margin-bottom: 10px;\\n}\\n.title {\\n    color: #000;\\n    line-height: 24px;\\n    font-size: 18px;\\n    font-weight: bold;\\n    padding-left: 10px;\\n    padding-right: 10px;\\n}\\n.meta {\\n    color: #757575;\\n    font-size: 12px;\\n    padding-left: 10px;\\n    padding-right: 10px;\\n    padding-top: 7px;\\n    padding-bottom: 10px;\\n}\\n.category {\\n    color: #093;\\n    padding-right: 20px;\\n}\\n.unit-wrapper:hover{\\n    border: 1px solid #093;\\n    background-color: #eee;\\n}\\n.unit-wrapper:hover .title {\\n    color: red;\\n}\",\"gridColumns\":\"3\",\"gridRows\":\"2\"},{\"value\":\"4\",\"label\":\"3x2 image, above, with a description\",\"name\":\"grid\",\"props\":{},\"template\":\"<div class=\\\"wrapper\\\">\\n    <div class=\\\"headline\\\">Читайте также</div>\\n    <ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n        <div class=\\\"card\\\">\\n            <div class=\\\"image\\\">\\n                <ya-unit-image ratio=\\\"0.5\\\" />\\n            </div>\\n            <div class=\\\"title\\\">\\n                <ya-clamp lines=\\\"2\\\"><ya-unit-title /></ya-clamp>\\n            </div>\\n            <div class=\\\"desc\\\">\\n                <ya-clamp lines=\\\"3\\\"><ya-unit-desc /></ya-clamp>\\n            </div>\\n            <div class=\\\"meta\\\">\\n                <ya-unit-category class=\\\"category\\\"/>\\n                <ya-unit-date class=\\\"date\\\"/>\\n                <ya-unit-domain class=\\\"domain\\\" />\\n            </div>\\n        </div>\\n    <ya-unit-kebab />\\n    </ya-units-grid>\\n    <ya-recommendation-label />\\n</div>\",\"css\":\".headline {\\n    font-size: 18px;\\n    font-weight: bold;\\n    line-height: 18px;\\n    color: #373e44;\\n    padding-bottom: 20px;\\n    padding-top: 15px;\\n}\\n.grid-row {\\n    margin-top: 10px;\\n}\\n.grid-item {\\n    margin-left: 10px;\\n}\\n.unit-wrapper {\\n    height: 100%;\\n    border: 1px solid gray;\\n    border-radius: 2px;\\n    background-color: #fff;\\n}\\n.image {\\n    margin-bottom: 10px;\\n}\\n.title {\\n    color: #000;\\n    font-size: 15px;\\n    font-weight: bold;\\n    padding-left: 10px;\\n    padding-right: 10px;\\n}\\n.meta {\\n    color: #757575;\\n    font-size: 12px;\\n    padding-left: 10px;\\n    padding-right: 10px;\\n    padding-top: 7px;\\n    padding-bottom: 10px;\\n}\\n.desc {\\n    color: #757575;\\n    font-size: 12px;\\n    padding-left: 10px;\\n    padding-right: 10px;\\n    padding-top: 7px;\\n    padding-bottom: 10px;\\n}\\n.category {\\n    color: #093;\\n    padding-right: 20px;\\n}\\n.unit-wrapper:hover {\\n    border: 1px solid #093;\\n    background-color: #eee;\\n}\\n.unit-wrapper:hover .title {\\n    color: red;\\n}\",\"gridColumns\":\"3\",\"gridRows\":\"2\"},{\"value\":\"6\",\"label\":\"5x1 image, background, with gradient\",\"name\":\"grid\",\"props\":{},\"template\":\"<div class=\\\"wrapper\\\">\\n    <div class=\\\"headline\\\">Рекомендуем</div>\\n    <ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n        <div class=\\\"image\\\">\\n            <ya-unit-image ratio=\\\"1.35\\\" />\\n        </div>\\n        <div class=\\\"card\\\">\\n            <ya-clamp lines=\\\"7\\\" class=\\\"title\\\"><ya-unit-title /></ya-clamp>\\n            <div class=\\\"meta\\\">\\n                <ya-unit-category ad-only />\\n            </div>\\n        </div>\\n        <ya-unit-kebab />\\n    </ya-units-grid>\\n    <ya-recommendation-label />\\n</div>\",\"css\":\".headline {\\n    font-size: 24px;\\n    font-weight: bold;\\n    line-height: 30px;\\n    color: #000;\\n    padding-bottom: 10px;\\n    padding-top: 10px;\\n}\\n\\n.grid-item {\\n    margin-left: 15px;\\n    min-width: 175px;\\n    max-width: 175px;\\n    height: 235px;\\n}\\n\\n.unit-wrapper {\\n    height: 100%;\\n    border-radius: 3px;\\n    position: relative;\\n}\\n\\n.image {\\n    margin-bottom: 10px;\\n}\\n\\n.card:before {\\n    content: \\\"\\\";\\n    position: absolute;\\n    top: -15px;\\n    bottom: -15px;\\n    left: 0;\\n    right: 0;\\n    background: red;\\n    background: linear-gradient(\\t\\n                to bottom,\\t\\n                rgba(var(--unit-average-color-rgb, 125, 125, 125), 0.0) 0%,\\t\\n                rgba(var(--unit-average-color-rgb, 125, 125, 125), 0.7) 30%,\\n                rgba(var(--unit-average-color-rgb, 125, 125, 125), 1) 100%\\t\\n            );\\n}\\n\\n.card {\\n    position: absolute;\\n    bottom: 15px;\\n}\\n\\n.title {\\n    color: #fff;\\n    text-shadow: 0px 0px 3px rgba(0, 0, 0, 0.5);\\n    line-height: 17px;\\n    font-size: 14px;\\n    font-weight: bold;\\n    padding-left: 10px;\\n    padding-right: 10px;\\n}\\n\\n.meta {\\n    position: relative;\\n    color: #fff;\\n    text-shadow: 0px 0px 3px rgba(0, 0, 0, 0.5);\\n    font-size: 13px;\\n    padding-left: 10px;\\n    padding-right: 10px;\\n    padding-top: 15px;\\n    padding-bottom: 10px;\\n}\",\"gridColumns\":\"5\",\"gridRows\":\"1\"},{\"value\":\"8\",\"label\":\"4x3 image above, adaptive grid, rounded border\",\"name\":\"grid\",\"template\":\"<div class=\\\"wrapper\\\">\\n    <div class=\\\"headline\\\">Смотрите также</div>\\n    <ya-units-grid sizes=\\\"(max-width: 959px) 3x3, (max-width: 639px) 3x2, ${grid_rows}x${grid_columns}\\\">\\n        <div class=\\\"unit-wrapper\\\">\\n            <div class=\\\"image\\\"><ya-unit-image ratio=\\\"0.5625\\\" /></div>\\n            <ya-clamp lines=\\\"4\\\" class=\\\"title\\\"><ya-unit-title /></ya-clamp>\\n            <ya-unit-category class=\\\"category\\\"/>\\n        </div>\\n        <ya-unit-kebab />\\n    </ya-units-grid>\\n    <ya-recommendation-label />\\n</div>\",\"css\":\".headline {\\n    margin-bottom: 12px;\\n    font-weight: bold;\\n    font-size: 20px;\\n    line-height: 1;\\n    color: #333;\\n}\\n.grid-row {\\n    margin-top: 20px;\\n}\\n.grid-item {\\n    margin-left: 20px;\\n}\\n.image {\\n    margin-bottom: 5px;\\n    overflow: hidden;\\n    -webkit-transform: translateZ(0);\\n    transform: translateZ(0);\\n    border-radius: 6px;\\n}\\n.unit-image {\\n    -webkit-filter: brightness(95%);\\n    filter: brightness(95%);\\n}\\n.unit-wrapper {\\n    border-radius: 6px;\\n}\\n.title {\\n    margin-bottom: 2px;\\n    font-weight: bold;\\n    font-size: 17px;\\n    line-height: 1.25;\\n    color: #333;\\n}\\n.category {\\n    margin-top: 3px;\\n    font-size: 12px;\\n    color: #808080;\\n}\\n@media (min-width: 640px) {\\n    .unit-image {\\n        -webkit-transition: all .15s ease-in-out;\\n        transition: all .15s ease-in-out;\\n    }\\n    .unit-wrapper:hover .unit-image {\\n        opacity: 0.9;\\n        -webkit-transform: translateZ(0) scale(1.1);\\n        transform: translateZ(0) scale(1.1);\\n    }\\n}\\n@media (max-width: 639px) {\\n    .headline {\\n        margin-bottom: 10px;\\n        font-size: 17px;\\n        line-height: 1.25;\\n    }\\n    .grid-row {\\n        margin-top: 10px;\\n    }\\n    .grid-item {\\n        margin-left: 10px;\\n    }\\n    .image {\\n        margin-bottom: 6px;\\n    }\\n    .title {\\n        font-size: 13px;\\n    }\\n    .category {\\n        font-size: 11px;\\n    }\\n}\",\"gridColumns\":\"4\",\"gridRows\":\"3\"},{\"value\":\"9\",\"label\":\"4x2 image above, with a description and rounded border\",\"name\":\"grid\",\"props\":{},\"template\":\"<div class=\\\"wrapper\\\">\\n    <div class=\\\"headline\\\">Читайте также</div>\\n    <ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n        <div>\\n            <div class=\\\"image\\\">\\n                <ya-unit-image ratio=\\\"0.55\\\" />\\n             </div>\\n            <div class=\\\"title\\\">\\n                <ya-clamp lines=\\\"2\\\"><ya-unit-title /></ya-clamp>\\n            </div>\\n            <div class=\\\"desc\\\">\\n                <ya-clamp lines=\\\"3\\\"><ya-unit-desc /></ya-clamp>\\n            </div>\\n            <div class=\\\"meta\\\">\\n                <ya-unit-category class=\\\"category\\\"/>\\n                <ya-unit-date class=\\\"date\\\"/>\\n                <ya-unit-domain class=\\\"domain\\\" />\\n            </div>\\n        </div>\\n        <ya-unit-kebab />\\n    </ya-units-grid>\\n    <ya-recommendation-label />\\n</div>\",\"css\":\".headline {\\n    font-size: 18px;\\n    font-weight: bold;\\n    line-height: 18px;\\n    color: #373e44;\\n    padding-bottom: 20px;\\n    padding-top: 15px;\\n}\\n.grid-row {\\n    margin-top: 10px;\\n}\\n.grid-item {\\n    margin-left: 10px;\\n}\\n.unit-wrapper {\\n    border: 1px solid gray;\\n    border-radius: 10px;\\n    height: 100%;\\n    background-color: #fff;\\n}\\n.image {\\n    margin-bottom: 10px;\\n}\\n.title {\\n    color: #000;\\n    font-size: 14px;\\n    font-weight: bold;\\n    padding-left: 10px;\\n    padding-right: 10px;\\n}\\n.meta {\\n    color: #757575;\\n    font-size: 12px;\\n    padding-left: 10px;\\n    padding-right: 10px;\\n    padding-top: 7px;\\n    padding-bottom: 10px;\\n}\\n.desc {\\n    color: #757575;\\n    font-size: 12px;\\n    padding-left: 10px;\\n    padding-right: 10px;\\n    padding-top: 7px;\\n    padding-bottom: 10px;\\n}\\n.category {\\n    color: #093;\\n    padding-right: 20px;\\n}\\n.date {\\n    float: right;\\n}\\n.domain {\\n    float: right;\\n}\\n.unit-wrapper:hover {\\n    border: 1px solid #093;\\n    background-color: #eee;\\n}\\n.unit-wrapper:hover .title {\\n    color: red;\\n}\",\"gridColumns\":\"4\",\"gridRows\":\"2\"},{\"value\":\"10\",\"label\":\"1x5 image on the left, for mobile\",\"name\":\"grid\",\"props\":{},\"template\":\"<ya-units-grid cols=\\\"${grid_columns}\\\" rows=\\\"${grid_rows}\\\">\\n    <div class=\\\"container\\\">\\n        <div class=\\\"image\\\">\\n            <ya-unit-image />\\n        </div>\\n        <div class=\\\"body\\\">\\n            <ya-clamp lines=\\\"3\\\" class=\\\"title\\\">\\n                <ya-unit-title />\\n            </ya-clamp>\\n            <div class=\\\"category\\\">\\n                <ya-unit-category ad-only />\\n            </div>\\n        </div>\\n    </div>\\n  <ya-unit-kebab />\\n</ya-units-grid>\\n<ya-recommendation-label />\",\"css\":\".headline {\\n    font-size: 18px;\\n    font-weight: bold;\\n    line-height: 24px;\\n    color: #373e44;\\n    padding-bottom: 20px\\n    padding-top: 15px;\\n}\\n.grid-row {\\n    margin-top: 6px;\\n}\\n.grid-item {\\n    margin-left: 10px;\\n}\\n.unit-wrapper {\\n    height: 100%;\\n    background-color: #fff;\\n}\\n.container {\\n    position: relative;\\n    display: flex;\\n    flex-direction: row;\\n    flex-wrap: nowrap;\\n    max-width: 340px;\\n    max-height: 84px;\\n}\\n.image {\\n    width: 162px;\\n    height: 85px;\\n    margin-right: 10px;\\n    flex: 0 0 auto;\\n}\\n.title {\\n    font-family: \\\"Roboto\\\", Roboto, Arial, sans-serif;\\n    color: #000;\\n    line-height: 17px;\\n    font-size: 14px;\\n    font-weight: bold;\\n    padding-top: 9px;\\n}\\n.meta {\\n    color: #757575;\\n    font-size: 12px;\\n    padding-left: 10px;\\n    padding-right: 10px;\\n    padding-top: 7px;\\n    padding-bottom: 10px;\\n}\\n.category {\\n    color: #999999;\\n    font-size: 12px;\\n    padding-top: 20px;\\n    padding-bottom: 10px;\\n}\\n.grid {\\n    display: flex;\\n    flex-direction: column;\\n    flex-wrap: wrap;\\n    justify-content: flex-start;\\n    align-items: stretch;\\n    align-content: flex-start;\\n    width: 100%;\\n    box-sizing: border-box;\\n    margin-bottom: 2px;\\n}\",\"gridColumns\":\"1\",\"gridRows\":\"5\"},{\"value\":\"11\",\"label\":\"3x2 image above, adaptive grid, no border\",\"name\":\"grid\",\"props\":{},\"template\":\"<div class=\\\"wrapper\\\">\\n    <div class=\\\"headline\\\">Читайте также</div>\\n    <ya-units-grid sizes=\\\"(max-width: 1024px) 2x3, (max-width: 600px) 6x1, ${grid_rows}x${grid_columns}\\\" target_top>\\n        <div class=\\\"card\\\">\\n            <div class=\\\"image\\\">\\n                <ya-unit-image ratio=\\\"0.5\\\" />\\n            </div>\\n            <ya-clamp lines=\\\"2\\\" class=\\\"title\\\"><ya-unit-title /></ya-clamp>\\n            <div class=\\\"meta\\\">\\n                <ya-unit-category class=\\\"category\\\" />\\n            </div>\\n        </div>\\n        <ya-unit-kebab />\\n    </ya-units-grid>\\n    <ya-recommendation-label />\\n</div>\",\"css\":\".headline {\\n    font-size: 18px;\\n    font-weight: bold;\\n    font-family: Roboto Condensed, sans-serif;\\n    line-height: 24px;color: #373e44;\\n    padding-bottom: 20px;\\n    padding-top: 15px;\\n}\\n.grid-row {\\n    margin-top: 10px;\\n    min-height: 230px;\\n}\\n.grid-item {\\n    margin-left: 10px;\\n}\\n.unit-wrapper {\\n    height: 100%;\\n    border: 0px #dee2e3;\\n    border-radius: 2px;\\n    background-color: #fff;\\n}\\n.image {\\n    margin-bottom: 10px;\\n}\\n.title {\\n    color: #000;\\n    line-height: 24px;\\n    font-size: 18px;\\n    font-family: Roboto Condensed, sans-serif;\\n    font-stretch: condensed;\\n    font-weight: 700;\\n    font-style: normal;\\n    padding-left: 10px;\\n    padding-right: 10px;\\n}\\n.meta {\\n    display: inline-block;\\n    vertical-align: bottom;\\n    border-radius: 3px;\\n    padding: 4px 5px 2px 5px;\\n    border: 1px solid;\\n    border-color: #fff;\\n    line-height: 1;\\n    margin-bottom: 10px;\\n    margin-top: 10px;\\n    margin-left: 2px;\\n    background: #fff;\\n    padding: 2px 8px;\\n    font-size: 11px;\\n    line-height: 1.45;\\n    letter-spacing: 1px;\\n    text-transform: uppercase;\\n}\\n.category {\\n    color: #3670f9;\\n    font-family: Roboto Condensed, sans-serif;\\n    padding-right: 0px;\\n    font-size: 12px;\\n    font-stretch: condensed;\\n    font-weight: bold;\\n    font-style: normal;\\n}\\n.ya-recommendation-label {\\n    color: #e7e7e7;\\n    font-size: 10px;\\n    font-family: Roboto Condensed, sans-serif;\\n    font-style: normal;\\n}\\n.unit-wrapper:hover .title {\\n    color: #ED5E42;\\n}\",\"gridColumns\":\"3\",\"gridRows\":\"2\"},{\"value\":\"12\",\"label\":\"Slider: image at the top, with a background\",\"props\":{},\"template\":\"<div class=\\\"headline\\\">Читайте также</div>\\n<ya-units-slider>\\n<div class=\\\"unit\\\">\\n    <ya-unit-kebab />\\n    <div class=\\\"image\\\">\\n        <ya-unit-image ratio=\\\"0.667\\\" />\\n    </div>\\n    <div class=\\\"body\\\">\\n        <ya-clamp class=\\\"title\\\" lines=\\\"3\\\">\\n            <ya-unit-title />\\n        </ya-clamp>\\n        <ya-clamp class=\\\"description\\\" lines=\\\"2\\\">\\n            <ya-unit-desc />\\n        </ya-clamp>\\n        <div class=\\\"meta\\\">\\n            <ya-unit-category class=\\\"meta-span category\\\" />\\n            <ya-unit-date class=\\\"meta-span date\\\" />\\n            <ya-unit-age class=\\\"meta-span age\\\" />\\n        </div>\\n        <div class=\\\"domain-block\\\">\\n            <ya-unit-domain class=\\\"domain\\\" />\\n            <span class=\\\"favicon\\\">\\n                <ya-unit-favicon size=\\\"16\\\" />\\n            </span>\\n        </div>\\n    </div>\\n</div>\\n<ya-slider-button direction=\\\"left\\\">\\n    <div class=\\\"button button-left\\\"></div>\\n</ya-slider-button>\\n<ya-slider-button direction=\\\"right\\\">\\n    <div class=\\\"button button-right\\\"></div>\\n</ya-slider-button>\\n</ya-units-slider>\\n<ya-recommendation-label />\",\"css\":\".headline {\\n    font-family: Helvetica,Arial,sans-serif;\\n    font-size: 20px;\\n    font-weight: 700;\\n    line-height: 24px;\\n    color: #373e44;\\n    padding-bottom: 12px;\\n    padding-top: 12px;\\n}\\n\\n.ya-units-slider {\\n    width: 100%;\\n}\\n\\n.ya-slider-item:not(:first-child) {\\n    margin-left: 12px;\\n}\\n\\n.label {\\n    display: block;\\n    font-family: Helvetica,Arial,sans-serif;\\n    font-size: 12px;\\n    color: #999;\\n}\\n\\n.unit-wrapper {\\n    height: 100%;\\n}\\n\\n.image,.unit {\\n    position: relative;\\n    overflow: hidden;\\n}\\n\\n.unit {\\n    display: flex;\\n    flex-direction: column;\\n    flex-wrap: nowrap;\\n    text-decoration: none;\\n    color: #000;\\n    width: 240px;\\n    cursor: pointer;\\n    box-sizing: border-box;\\n    margin: 0 auto;\\n    -webkit-transform: translateZ(0);\\n    font-family: Helvetica,Arial,sans-serif;\\n    height: 100%;\\n    background: #f0f1f5;\\n    border-radius: 8px;\\n}\\n\\n.unit:hover {\\n    background: #e1e2e5;\\n}\\n\\n.unit:active {\\n    background: #d7d8db;\\n}\\n\\n.image {\\n    display: block;\\n    flex-grow: 0;\\n    flex-shrink: 0;\\n}\\n\\n.img-source-component {\\n    transition: transform 100ms ease;\\n    border-radius: 0;\\n}\\n\\n.unit-wrapper:hover .unit-image .img-source-component {\\n    transform: scale(1.05);\\n    -webkit-transform: scale(1.05);\\n}\\n\\n.unit:active .unit-image .img-source-component {\\n    transform: scale(1.025);\\n    -webkit-transform: scale(1.025);\\n}\\n\\n.ya-ad-close {\\n    transform: translateZ(0);\\n}\\n\\n.unit-image {\\n    max-height: 160px;\\n}\\n\\n.body {\\n    position: relative;\\n    display: flex;\\n    flex-direction: column;\\n    width: 100%;\\n}\\n\\n.title {\\n    color: #000;\\n    font-style: normal;\\n    font-weight: 700;\\n    font-size: 15px;\\n    line-height: 20px;\\n    margin-top: 12px;\\n    padding-left: 16px;\\n    padding-right: 16px;\\n}\\n\\n.description,.domain-block {\\n    font-style: normal;\\n    font-weight: 400;\\n    font-size: 14px;\\n    margin-top: 8px;\\n}\\n\\n.description {\\n    line-height: 20px;\\n    color: #505050;\\n    padding-left: 16px;\\n    padding-right: 16px;\\n}\\n\\n.domain-block {\\n    color: #000;\\n    line-height: 16px;\\n    margin-left: 16px;\\n    margin-right: 16px;\\n    display: flex;\\n    align-items: center;\\n    position: relative;\\n}\\n\\n.domain:empty,.domain:empty~.favicon {\\n    display: none;\\n}\\n\\n.domain,.favicon {\\n    margin-bottom: 16px;\\n}\\n\\n.domain {\\n    padding-left: 24px;\\n}\\n\\n.favicon {\\n    width: 16px;\\n    height: 16px;\\n    background-color: rgba(0 0 0/10%);\\n    display: inline-block;\\n    margin-right: 8px;\\n    position: absolute;\\n    top: 0;\\n    left: 0;\\n    border-radius: 4px;\\n}\\n\\n.meta {\\n    color: silver;\\n    font-style: normal;\\n    font-weight: 400;\\n    font-size: 12px;\\n    line-height: 16px;\\n    margin-top: 12px;\\n    padding-left: 16px;\\n    padding-right: 16px;\\n}\\n\\n.meta:last-child {\\n    padding-bottom: 16px;\\n}\\n\\n.meta-span {\\n    padding: 0;\\n}\\n\\n.meta-span:before {\\n    content: \\\" · \\\";\\n}\\n\\n.meta-span:first-child:before {\\n    content: none;\\n}\\n\\n.meta-span:empty {\\n    display: none;\\n}\\n\\n.button {\\n    width: 40px;\\n    height: 40px;\\n    border-radius: 20px;\\n    position: absolute;\\n    cursor: pointer;\\n    z-index: 999;\\n    bottom: 47%;\\n    background-color: #fff;\\n    background-image: url(data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDBweCIgaGVpZ2h0PSI0MHB4IiB2aWV3Qm94PSIwIDAgNDAgNDAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PGcgdHJhbnNmb3JtPSJ0cmFuc2xhdGUoMTEuMCwgMTMuMCkiIHN0cm9rZT0iIzE4MTgxOCIgc3Ryb2tlLXdpZHRoPSIxLjgiIGZpbGw9Im5vbmUiPjxsaW5lIHgxPSIwLjUiIHkxPSI3IiB4Mj0iMTYuNSIgeTI9IjciPjwvbGluZT48cG9seWxpbmUgcG9pbnRzPSI5LjUgMCAxNi41IDcgOS41IDE0Ij48L3BvbHlsaW5lPjwvZz48L3N2Zz4=);\\n    background-position: 50%;\\n    background-repeat: no-repeat;\\n    background-origin: content-box;\\n    background-size: 40px 40px;\\n    box-shadow: 0 1px 1px rgba(0,0,0,.05),0 2px 2px rgba(0,0,0,.05),0 4px 4px rgba(0,0,0,.05);\\n    transition: transform 50ms ease-out;\\n}\\n\\n.button:hover {\\n    transform: scale(1.2);\\n}\\n\\n.button:active {\\n    transform: scale(1.1);\\n    transition: transform 50ms ease-in;\\n    background-color: #f0f0f0;\\n}\\n\\n.button-left {\\n    left: 8px;\\n    transform: scaleX(-1);\\n}\\n\\n.button-left:hover {\\n    transform: scaleX(-1) scale(1.2);\\n}\\n\\n.button-right {\\n    right: 8px;\\n}\\n\\n.ya-slider-leftmost .button-left,.ya-slider-rightmost .button-right {\\n    display: none;\\n}\\n\\n.recommendation-label {\\n    display: block;\\n    width: 100%;\\n    color: #ddd;\\n    text-align: right;\\n}\",\"gridColumns\":\"7\",\"gridRows\":\"1\"},{\"value\":\"13\",\"label\":\"Slider: image at the top, no background\",\"props\":{},\"template\":\"<div class=\\\"headline\\\">Читайте также</div>\\n<ya-units-slider>\\n<div class=\\\"unit\\\">\\n    <ya-unit-kebab />\\n    <div class=\\\"image\\\">\\n        <ya-unit-image ratio=\\\"0.667\\\" />\\n    </div>\\n    <div class=\\\"body\\\">\\n        <ya-clamp class=\\\"title\\\" lines=\\\"3\\\">\\n            <ya-unit-title />\\n        </ya-clamp>\\n        <ya-clamp class=\\\"description\\\" lines=\\\"2\\\">\\n            <ya-unit-desc />\\n        </ya-clamp>\\n        <div class=\\\"meta\\\">\\n            <ya-unit-category class=\\\"meta-span category\\\" />\\n            <ya-unit-date class=\\\"meta-span date\\\" />\\n            <ya-unit-age class=\\\"meta-span age\\\" />\\n        </div>\\n        <div class=\\\"domain-block\\\">\\n            <ya-unit-domain class=\\\"domain\\\" />\\n            <span class=\\\"favicon\\\">\\n                <ya-unit-favicon size=\\\"16\\\" />\\n            </span>\\n        </div>\\n    </div>\\n</div>\\n<ya-slider-button direction=\\\"left\\\">\\n    <div class=\\\"button button-left\\\"></div>\\n</ya-slider-button>\\n<ya-slider-button direction=\\\"right\\\">\\n    <div class=\\\"button button-right\\\"></div>\\n</ya-slider-button>\\n</ya-units-slider>\\n<ya-recommendation-label />\",\"css\":\".headline {\\n    font-family: Helvetica,Arial,sans-serif;\\n    font-size: 20px;\\n    font-weight: 700;\\n    line-height: 24px;\\n    color: #373e44;\\n    padding-bottom: 12px;\\n    padding-top: 12px;\\n}\\n\\n.ya-units-slider {\\n    width: 100%;\\n}\\n\\n.ya-slider-item:not(:first-child) {\\n    margin-left: 12px;\\n}\\n\\n.label {\\n    display: block;\\n    font-family: Helvetica,Arial,sans-serif;\\n    font-size: 12px;\\n    color: #999;\\n}\\n\\n.unit-wrapper {\\n    height: 100%;\\n}\\n\\n.image,.unit {\\n    position: relative;\\n    overflow: hidden;\\n}\\n\\n.unit {\\n    display: flex;\\n    flex-direction: column;\\n    flex-wrap: nowrap;\\n    text-decoration: none;\\n    color: #000;\\n    width: 240px;\\n    cursor: pointer;\\n    box-sizing: border-box;\\n    margin: 0 auto;\\n    -webkit-transform: translateZ(0);\\n    font-family: Helvetica,Arial,sans-serif;\\n    height: 100%;\\n    border-radius: 8px;\\n}\\n\\n.unit:hover {\\n    background: #e1e2e5;\\n}\\n\\n.unit:active {\\n    background: #d7d8db;\\n}\\n\\n.image {\\n    display: block;\\n    flex-grow: 0;\\n    flex-shrink: 0;\\n}\\n\\n.img-source-component {\\n    transition: transform 100ms ease;\\n    border-radius: 0;\\n}\\n\\n.unit-wrapper:hover .unit-image .img-source-component {\\n    transform: scale(1.05);\\n    -webkit-transform: scale(1.05);\\n}\\n\\n.unit:active .unit-image .img-source-component {\\n    transform: scale(1.025);\\n    -webkit-transform: scale(1.025);\\n}\\n\\n.ya-ad-close {\\n    transform: translateZ(0);\\n}\\n\\n.unit-image {\\n    max-height: 160px;\\n}\\n\\n.body {\\n    position: relative;\\n    display: flex;\\n    flex-direction: column;\\n    width: 100%;\\n}\\n\\n.title {\\n    color: #000;\\n    font-style: normal;\\n    font-weight: 700;\\n    font-size: 15px;\\n    line-height: 20px;\\n    margin-top: 12px;\\n    padding-left: 16px;\\n    padding-right: 16px;\\n}\\n\\n.description,.domain-block {\\n    font-style: normal;\\n    font-weight: 400;\\n    font-size: 14px;\\n    margin-top: 8px;\\n}\\n\\n.description {\\n    line-height: 20px;\\n    color: #505050;\\n    padding-left: 16px;\\n    padding-right: 16px;\\n}\\n\\n.domain-block {\\n    color: #000;\\n    line-height: 16px;\\n    margin-left: 16px;\\n    margin-right: 16px;\\n    display: flex;\\n    align-items: center;\\n    position: relative;\\n}\\n\\n.domain:empty,.domain:empty~.favicon {\\n    display: none;\\n}\\n\\n.domain,.favicon {\\n    margin-bottom: 16px;\\n}\\n\\n.domain {\\n    padding-left: 24px;\\n}\\n\\n.favicon {\\n    width: 16px;\\n    height: 16px;\\n    background-color: rgba(0 0 0/10%);\\n    display: inline-block;\\n    margin-right: 8px;\\n    position: absolute;\\n    top: 0;\\n    left: 0;\\n    border-radius: 4px;\\n}\\n\\n.meta {\\n    color: silver;\\n    font-style: normal;\\n    font-weight: 400;\\n    font-size: 12px;\\n    line-height: 16px;\\n    margin-top: 12px;\\n    padding-left: 16px;\\n    padding-right: 16px;\\n}\\n\\n.meta:last-child {\\n    padding-bottom: 16px;\\n}\\n\\n.meta-span {\\n    padding: 0;\\n}\\n\\n.meta-span:before {\\n    content: \\\" · \\\";\\n}\\n\\n.meta-span:first-child:before {\\n    content: none;\\n}\\n\\n.meta-span:empty {\\n    display: none;\\n}\\n\\n.button {\\n    width: 40px;\\n    height: 40px;\\n    border-radius: 20px;\\n    position: absolute;\\n    cursor: pointer;\\n    z-index: 999;\\n    bottom: 47%;\\n    background-color: #fff;\\n    background-image: url(data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDBweCIgaGVpZ2h0PSI0MHB4IiB2aWV3Qm94PSIwIDAgNDAgNDAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PGcgdHJhbnNmb3JtPSJ0cmFuc2xhdGUoMTEuMCwgMTMuMCkiIHN0cm9rZT0iIzE4MTgxOCIgc3Ryb2tlLXdpZHRoPSIxLjgiIGZpbGw9Im5vbmUiPjxsaW5lIHgxPSIwLjUiIHkxPSI3IiB4Mj0iMTYuNSIgeTI9IjciPjwvbGluZT48cG9seWxpbmUgcG9pbnRzPSI5LjUgMCAxNi41IDcgOS41IDE0Ij48L3BvbHlsaW5lPjwvZz48L3N2Zz4=);\\n    background-position: 50%;\\n    background-repeat: no-repeat;\\n    background-origin: content-box;\\n    background-size: 40px 40px;\\n    box-shadow: 0 1px 1px rgba(0,0,0,.05),0 2px 2px rgba(0,0,0,.05),0 4px 4px rgba(0,0,0,.05);\\n    transition: transform 50ms ease-out;\\n}\\n\\n.button:hover {\\n    transform: scale(1.2);\\n}\\n\\n.button:active {\\n    transform: scale(1.1);\\n    transition: transform 50ms ease-in;\\n    background-color: #f0f0f0;\\n}\\n\\n.button-left {\\n    left: 8px;\\n    transform: scaleX(-1);\\n}\\n\\n.button-left:hover {\\n    transform: scaleX(-1) scale(1.2);\\n}\\n\\n.button-right {\\n    right: 8px;\\n}\\n\\n.ya-slider-leftmost .button-left,.ya-slider-rightmost .button-right {\\n    display: none;\\n}\\n\\n.recommendation-label {\\n    display: block;\\n    width: 100%;\\n    color: #ddd;\\n    text-align: right;\\n}\",\"gridColumns\":\"7\",\"gridRows\":\"1\"},{\"value\":\"14\",\"label\":\"Slider: image at the bottom, with a background\",\"props\":{},\"template\":\"<div class=\\\"headline\\\">Читайте также</div>\\n<ya-units-slider class=\\\"slider\\\">\\n<div class=\\\"unit\\\">\\n    <ya-unit-kebab />\\n    <div class=\\\"text-block\\\">\\n        <div class=\\\"meta\\\">\\n            <ya-unit-category class=\\\"meta-span category\\\" />\\n            <ya-unit-date class=\\\"meta-span date\\\" />\\n            <ya-unit-age class=\\\"meta-span age\\\" />\\n        </div>\\n        <ya-clamp class=\\\"title\\\" lines=\\\"3\\\">\\n            <ya-unit-title />\\n        </ya-clamp>\\n        <ya-clamp class=\\\"description\\\" lines=\\\"2\\\">\\n            <ya-unit-desc />\\n        </ya-clamp>\\n        <div class=\\\"domain-block\\\">\\n            <ya-unit-domain class=\\\"domain\\\" /><span class=\\\"favicon\\\">\\n                <ya-unit-favicon size=\\\"16\\\" /></span></div>\\n    </div>\\n    <div class=\\\"image\\\">\\n        <ya-unit-image ratio=\\\"0.667\\\" />\\n    </div>\\n</div>\\n<ya-slider-button direction=\\\"left\\\">\\n    <div class=\\\"button button-left\\\"></div>\\n</ya-slider-button>\\n<ya-slider-button direction=\\\"right\\\">\\n    <div class=\\\"button button-right\\\"></div>\\n</ya-slider-button>\\n</ya-units-slider>\\n<ya-recommendation-label />\",\"css\":\".headline {\\n    font-family: Helvetica,Arial,sans-serif;\\n    font-size: 20px;\\n    font-weight: 700;\\n    line-height: 24px;\\n    padding-bottom: 12px;\\n    padding-top: 20px;\\n    color: #333;\\n}\\n\\n.ya-units-slider {\\n    width: 100%;\\n}\\n\\n.ya-slider-item {\\n    display: -webkit-flex;\\n    display: -ms-flexbox;\\n    display: flex;\\n    width: 240px;\\n    background: #f0f1f5;\\n    border-radius: 8px;\\n}\\n\\n.ya-slider-item:not(:first-child) {\\n    margin-left: 12px;\\n}\\n\\n.ya-slider-item:hover {\\n    background: #e1e2e5;\\n}\\n\\n.ya-slider-item:active {\\n    background: #d7d8db;\\n}\\n\\n.unit,.yrw-url {\\n    height: 100%;\\n}\\n\\n.unit {\\n    font-family: Helvetica,Arial,sans-serif;\\n    text-decoration: none;\\n    position: relative;\\n    display: flex;\\n    flex-direction: column;\\n    flex-wrap: nowrap;\\n    box-sizing: border-box;\\n    cursor: pointer;\\n    margin: 0 auto;\\n    width: 240px;\\n    border-radius: 8px;\\n    overflow: hidden;\\n    -webkit-transform: translateZ(0);\\n}\\n\\n.text-block {\\n    padding: 12px;\\n}\\n\\n.title {\\n    color: #000;\\n    font-size: 15px;\\n    line-height: 20px;\\n    font-style: normal;\\n    font-weight: 700;\\n    margin-top: 4px;\\n}\\n\\n.description,.meta {\\n    font-style: normal;\\n    font-weight: 400;\\n}\\n\\n.description {\\n    font-size: 14px;\\n    line-height: 20px;\\n    color: #505050;\\n    margin-top: 4px;\\n}\\n\\n.meta {\\n    color: silver;\\n    font-size: 12px;\\n    line-height: 16px;\\n}\\n\\n.meta-span {\\n    padding: 0;\\n}\\n\\n.meta-span:before {\\n    content: \\\" · \\\";\\n}\\n\\n.meta-span:first-child:before {\\n    content: none;\\n}\\n\\n.domain:empty,.domain:empty~.favicon,.meta-span:empty {\\n    display: none;\\n}\\n\\n.domain-block {\\n    color: #000;\\n    font-style: normal;\\n    font-weight: 400;\\n    font-size: 14px;\\n    line-height: 12px;\\n    display: flex;\\n    align-items: center;\\n    position: relative;\\n}\\n\\n.domain {\\n    margin-top: 8px;\\n    padding-left: 24px;\\n}\\n\\n.favicon {\\n    width: 16px;\\n    height: 16px;\\n    background-color: rgba(0 0 0/10%);\\n    display: inline-block;\\n    margin-right: 8px;\\n    position: absolute;\\n    top: 0;\\n    left: 0;\\n    margin-top: 8px;\\n    border-radius: 4px;\\n}\\n\\n.image {\\n    margin-top: auto;\\n    margin-bottom: 0;\\n}\\n\\n.img-source-component {\\n    transition: transform 100ms ease;\\n    border-radius: 0;\\n}\\n\\n.unit-wrapper:hover .unit-image .img-source-component {\\n    transform: scale(1.05);\\n    -webkit-transform: scale(1.05);\\n}\\n\\n.unit:active .unit-image .img-source-component {\\n    transform: scale(1.025);\\n    -webkit-transform: scale(1.025);\\n}\\n\\n.ya-ad-warning,.yrw-ya-unit-image-footer {\\n    transform: translateZ(0);\\n}\\n\\n.unit-image {\\n    max-height: 180px;\\n}\\n\\n.recommendation-label {\\n    display: block;\\n    width: 100%;\\n    color: #ddd;\\n    text-align: right;\\n}\\n\\n.button {\\n    width: 40px;\\n    height: 40px;\\n    border-radius: 20px;\\n    position: absolute;\\n    cursor: pointer;\\n    z-index: 999;\\n    top: 41%;\\n    background-color: #fff;\\n    background-image: url(data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDBweCIgaGVpZ2h0PSI0MHB4IiB2aWV3Qm94PSIwIDAgNDAgNDAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PGcgdHJhbnNmb3JtPSJ0cmFuc2xhdGUoMTEuMCwgMTMuMCkiIHN0cm9rZT0iIzE4MTgxOCIgc3Ryb2tlLXdpZHRoPSIxLjgiIGZpbGw9Im5vbmUiPjxsaW5lIHgxPSIwLjUiIHkxPSI3IiB4Mj0iMTYuNSIgeTI9IjciPjwvbGluZT48cG9seWxpbmUgcG9pbnRzPSI5LjUgMCAxNi41IDcgOS41IDE0Ij48L3BvbHlsaW5lPjwvZz48L3N2Zz4=);\\n    background-position: 50%;\\n    background-repeat: no-repeat;\\n    background-origin: content-box;\\n    background-size: 40px 40px;\\n    box-shadow: 0 1px 1px rgba(0,0,0,.05),0 2px 2px rgba(0,0,0,.05),0 4px 4px rgba(0,0,0,.05);\\n    transition: transform 50ms ease-out;\\n}\\n\\n.button:hover {\\n    transform: scale(1.2);\\n}\\n\\n.button:active {\\n    transform: scale(1.1);\\n    transition: transform 50ms ease-in;\\n    background-color: #f0f0f0;\\n}\\n\\n.button-left {\\n    left: 8px;\\n    transform: scaleX(-1);\\n}\\n\\n.button-left:hover {\\n    transform: scaleX(-1) scale(1.2);\\n}\\n\\n.button-right {\\n    right: 8px;\\n}\\n\\n.ya-slider-leftmost .button-left,.ya-slider-rightmost .button-right {\\n    display: none;\\n}\",\"gridColumns\":\"7\",\"gridRows\":\"1\"},{\"value\":\"15\",\"label\":\"Slider: image at the bottom, no background\",\"props\":{},\"template\":\"<div class=\\\"headline\\\">Читайте также</div>\\n<ya-units-slider class=\\\"slider\\\">\\n<div class=\\\"unit\\\">\\n    <ya-unit-kebab />\\n    <div class=\\\"text-block\\\">\\n        <div class=\\\"meta\\\">\\n            <ya-unit-category class=\\\"meta-span category\\\" />\\n            <ya-unit-date class=\\\"meta-span date\\\" />\\n            <ya-unit-age class=\\\"meta-span age\\\" />\\n        </div>\\n        <ya-clamp class=\\\"title\\\" lines=\\\"3\\\">\\n            <ya-unit-title />\\n        </ya-clamp>\\n        <ya-clamp class=\\\"description\\\" lines=\\\"2\\\">\\n            <ya-unit-desc />\\n        </ya-clamp>\\n        <div class=\\\"domain-block\\\">\\n            <ya-unit-domain class=\\\"domain\\\" />\\n            <span class=\\\"favicon\\\">\\n                <ya-unit-favicon size=\\\"16\\\" />\\n            </span>\\n        </div>\\n    </div>\\n    <div class=\\\"image\\\">\\n        <ya-unit-image ratio=\\\"0.667\\\" />\\n    </div>\\n</div>\\n<ya-slider-button direction=\\\"left\\\">\\n    <div class=\\\"button button-left\\\"></div>\\n</ya-slider-button>\\n<ya-slider-button direction=\\\"right\\\">\\n    <div class=\\\"button button-right\\\"></div>\\n</ya-slider-button>\\n</ya-units-slider>\\n<ya-recommendation-label />\",\"css\":\".headline {\\n    font-family: Helvetica,Arial,sans-serif;\\n    font-size: 20px;\\n    font-weight: 700;\\n    line-height: 24px;\\n    padding-bottom: 12px;\\n    padding-top: 20px;\\n    color: #333;\\n}\\n\\n.ya-units-slider {\\n    width: 100%;\\n}\\n\\n.ya-slider-item {\\n    display: -webkit-flex;\\n    display: -ms-flexbox;\\n    display: flex;\\n    width: 240px;\\n    border-radius: 8px;\\n}\\n\\n.ya-slider-item:not(:first-child) {\\n    margin-left: 12px;\\n}\\n\\n.ya-ad-close {\\n    background: none;\\n    width: 20px;\\n    height: 20px;\\n}\\n\\n.yrw-url {\\n    height: 100%;\\n}\\n\\n.unit {\\n    font-family: Helvetica,Arial,sans-serif;\\n    text-decoration: none;\\n    position: relative;\\n    display: flex;\\n    flex-direction: column;\\n    flex-wrap: nowrap;\\n    box-sizing: border-box;\\n    height: 100%;\\n    cursor: pointer;\\n    margin: 0 auto;\\n    width: 240px;\\n    border-radius: 8px;\\n    overflow: hidden;\\n    -webkit-transform: translateZ(0);\\n}\\n\\n.text-block {\\n    padding-top: 12px;\\n    padding-bottom: 12px;\\n}\\n\\n.title {\\n    color: #000;\\n    font-size: 15px;\\n    line-height: 20px;\\n    font-style: normal;\\n    font-weight: 700;\\n    margin-top: 8px;\\n}\\n\\n.description {\\n    font-size: 14px;\\n    line-height: 20px;\\n    color: #505050;\\n    font-style: normal;\\n    font-weight: 400;\\n    margin-top: 4px;\\n}\\n\\n.meta {\\n    color: silver;\\n    font-style: normal;\\n    font-weight: 400;\\n    font-size: 12px;\\n    line-height: 16px;\\n}\\n\\n.meta-span {\\n    padding: 0;\\n}\\n\\n.meta-span:before {\\n    content: \\\" · \\\";\\n}\\n\\n.meta-span:first-child:before {\\n    content: none;\\n}\\n\\n.meta-span:empty {\\n    display: none;\\n}\\n\\n.domain-block {\\n    color: #000;\\n    font-style: normal;\\n    font-weight: 400;\\n    font-size: 14px;\\n    line-height: 12px;\\n    display: flex;\\n    align-items: center;\\n    position: relative;\\n}\\n\\n.domain:empty,.domain:empty ~ .favicon {\\n    display: none;\\n}\\n\\n.domain {\\n    margin-top: 8px;\\n    padding-left: 24px;\\n}\\n\\n.favicon {\\n    width: 16px;\\n    height: 16px;\\n    background-color: rgba(0 0 0 / 10%);\\n    display: inline-block;\\n    margin-right: 8px;\\n    position: absolute;\\n    top: 0;\\n    left: 0;\\n    margin-top: 8px;\\n    border-radius: 4px;\\n}\\n\\n.unit:hover .title {\\n    color: #4A4C4F;\\n}\\n\\n.unit:hover .description {\\n    color: gray;\\n}\\n\\n.unit:hover .domain-block {\\n    color: #4A4C4F;\\n}\\n\\n.image {\\n    margin-top: auto;\\n    margin-bottom: 0;\\n    border-radius: 8px;\\n    overflow: hidden;\\n    -webkit-transform: translateZ(0);\\n}\\n\\n.img-source-component {\\n    transition: transform 100ms ease;\\n    border-radius: 0;\\n}\\n\\n.unit-wrapper:hover .unit-image .img-source-component {\\n    transform: scale(1.05);\\n    -webkit-transform: scale(1.05);\\n}\\n\\n.unit:active .unit-image .img-source-component {\\n    transform: scale(1.025);\\n    -webkit-transform: scale(1.025);\\n}\\n\\n.ya-ad-warning,.yrw-ya-unit-image-footer {\\n    transform: translateZ(0);\\n}\\n\\n.unit-image {\\n    max-height: 180px;\\n}\\n\\n.recommendation-label {\\n    display: block;\\n    width: 100%;\\n    color: #ddd;\\n    text-align: right;\\n}\\n\\n.button {\\n    width: 40px;\\n    height: 40px;\\n    border-radius: 20px;\\n    position: absolute;\\n    cursor: pointer;\\n    z-index: 999;\\n    top: 43%;\\n    background-color: #FFF;\\n    background-image: url(data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDBweCIgaGVpZ2h0PSI0MHB4IiB2aWV3Qm94PSIwIDAgNDAgNDAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PGcgdHJhbnNmb3JtPSJ0cmFuc2xhdGUoMTEuMCwgMTMuMCkiIHN0cm9rZT0iIzE4MTgxOCIgc3Ryb2tlLXdpZHRoPSIxLjgiIGZpbGw9Im5vbmUiPjxsaW5lIHgxPSIwLjUiIHkxPSI3IiB4Mj0iMTYuNSIgeTI9IjciPjwvbGluZT48cG9seWxpbmUgcG9pbnRzPSI5LjUgMCAxNi41IDcgOS41IDE0Ij48L3BvbHlsaW5lPjwvZz48L3N2Zz4=);\\n    background-position: 50%;\\n    background-repeat: no-repeat;\\n    background-origin: content-box;\\n    background-size: 40px 40px;\\n    box-shadow: 0 1px 1px rgba(0,0,0,0.05),0 2px 2px rgba(0,0,0,0.05),0 4px 4px rgba(0,0,0,0.05);\\n    transition: transform 50ms ease-out;\\n}\\n\\n.button:hover {\\n    transform: scale(1.2);\\n}\\n\\n.button:active {\\n    transform: scale(1.1);\\n    transition: transform 50ms ease-in;\\n    background-color: #f0f0f0;\\n}\\n\\n.button-left {\\n    left: 8px;\\n    transform: scaleX(-1);\\n}\\n\\n.button-left:hover {\\n    transform: scaleX(-1) scale(1.2);\\n}\\n\\n.button-right {\\n    right: 8px;\\n}\\n\\n.ya-slider-leftmost .button-left,.ya-slider-rightmost .button-right {\\n    display: none;\\n}\",\"gridColumns\":\"7\",\"gridRows\":\"1\"},{\"value\":\"16\",\"label\":\"Slider: square image, with a background\",\"props\":{},\"template\":\"<div class=\\\"headline\\\">Читайте также</div>\\n<ya-units-slider>\\n<div class=\\\"container\\\">\\n    <div class=\\\"image\\\">\\n        <ya-unit-image ratio=\\\"1\\\" />\\n    </div>\\n    <div class=\\\"body\\\">\\n        <div>\\n            <ya-unit-kebab />\\n            <ya-unit-title class=\\\"title\\\" />\\n        </div>\\n        <ya-clamp class=\\\"description\\\" lines=\\\"3\\\">\\n            <ya-unit-desc />\\n        </ya-clamp>\\n        <div class=\\\"meta\\\">\\n            <ya-unit-category class=\\\"meta-span category\\\" />\\n            <ya-unit-date class=\\\"meta-span date\\\"/>\\n            <ya-unit-age class=\\\"meta-span age\\\" />\\n        </div>\\n        <div class=\\\"domain-block\\\">\\n            <ya-unit-domain class=\\\"domain\\\"/>\\n            <span class=\\\"favicon\\\">\\n                <ya-unit-favicon size=\\\"16\\\"/>\\n            </span>\\n        </div>\\n        <ya-unit-warning class=\\\"warning\\\" />\\n    </div>\\n</div>\\n<ya-slider-button direction=\\\"left\\\">\\n    <div class=\\\"button button-left\\\"></div>\\n</ya-slider-button>\\n<ya-slider-button direction=\\\"right\\\">\\n    <div class=\\\"button button-right\\\"></div>\\n</ya-slider-button>\\n</ya-units-slider>\\n<ya-recommendation-label />\",\"css\":\".headline {\\n    font-family: Helvetica,Arial,sans-serif;\\n    font-size: 20px;\\n    font-weight: 700;\\n    line-height: 24px;\\n    color: #373e44;\\n    padding-bottom: 20px;\\n    padding-top: 20px;\\n}\\n\\n.ya-units-slider {\\n    width: 100%;\\n}\\n\\n.ya-slider-item:not(:first-child) {\\n    margin-left: 20px;\\n}\\n\\n.unit-wrapper {\\n    width: 280px;\\n    height: 100%;\\n    background: #f0f1f5;\\n    overflow: hidden;\\n    border-radius: 8px;\\n}\\n\\n.unit-wrapper:hover {\\n    background: #e1e2e5;\\n}\\n\\n.unit-wrapper:active {\\n    background: #d7d8db;\\n}\\n\\n.container {\\n    position: relative;\\n    display: flex;\\n    flex-direction: row;\\n    flex-wrap: nowrap;\\n    width: 100%;\\n}\\n\\n.image {\\n    flex: 0 0 auto;\\n    width: 64px;\\n    margin-left: 16px;\\n    margin-top: 16px;\\n}\\n\\n.unit-image {\\n    border-radius: 8px;\\n}\\n\\n.description,.domain-block,.title {\\n    color: #000;\\n    font-style: normal;\\n    font-weight: 700;\\n    font-size: 16px;\\n    line-height: 20px;\\n    margin-top: 16px;\\n    margin-left: 16px;\\n    margin-right: 16px;\\n}\\n\\n.ya-unit-close~.ya-unit-title {\\n    margin-right: 16px;\\n}\\n\\n.description,.domain-block {\\n    font-weight: 400;\\n    font-size: 14px;\\n    color: #666;\\n    margin-top: 12px;\\n}\\n\\n.domain-block {\\n    color: #000;\\n    line-height: 16px;\\n    display: flex;\\n    align-items: center;\\n    position: relative;\\n}\\n\\n.domain:empty~.favicon,.meta-span:empty,.ya-unit-warning:empty {\\n    display: none;\\n}\\n\\n.domain {\\n    padding-left: 24px;\\n}\\n\\n.favicon {\\n    width: 16px;\\n    height: 16px;\\n    background-color: rgba(0 0 0/10%);\\n    display: inline-block;\\n    margin-right: 8px;\\n    position: absolute;\\n    top: 0;\\n    left: 0;\\n    border-radius: 4px;\\n}\\n\\n.meta {\\n    color: silver;\\n    font-style: normal;\\n    font-weight: 400;\\n    font-size: 12px;\\n    line-height: 16px;\\n    margin-top: 12px;\\n    margin-left: 16px;\\n    margin-right: 16px;\\n}\\n\\n.meta-span {\\n    padding: 0;\\n}\\n\\n.meta-span:before {\\n    content: \\\" · \\\";\\n}\\n\\n.meta-span:first-child:before {\\n    content: none;\\n}\\n\\n.warning {\\n    color: silver;\\n    font-style: normal;\\n    font-weight: 400;\\n    font-size: 12px;\\n    line-height: 16px;\\n    margin-top: 12px;\\n    margin-left: 16px;\\n    margin-right: 16px;\\n}\\n\\n.button {\\n    width: 40px;\\n    height: 40px;\\n    border-radius: 20px;\\n    position: absolute;\\n    cursor: pointer;\\n    z-index: 999;\\n    bottom: 39%;\\n    background-color: #fff;\\n    background-image: url(data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDAiIGhlaWdodD0iNDAiIHZpZXdCb3g9IjAgMCA0MCA0MCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTI3LjY2NjYgMjBMMjguMzczNyAyMC43MDcxQzI4Ljc2NDMgMjAuMzE2NiAyOC43NjQzIDE5LjY4MzQgMjguMzczNyAxOS4yOTI5TDI3LjY2NjYgMjBaTTExLjMzMzMgMjFIMjcuNjY2NlYxOUgxMS4zMzMzVjIxWk0xOS45NTk1IDEzLjcwNzFMMjYuOTU5NSAyMC43MDcxTDI4LjM3MzcgMTkuMjkyOUwyMS4zNzM3IDEyLjI5MjlMMTkuOTU5NSAxMy43MDcxWk0yNi45NTk1IDE5LjI5MjlMMTkuOTU5NSAyNi4yOTI5TDIxLjM3MzcgMjcuNzA3MUwyOC4zNzM3IDIwLjcwNzFMMjYuOTU5NSAxOS4yOTI5WiIgZmlsbD0iYmxhY2siIGZpbGwtb3BhY2l0eT0iMC45Ii8+Cjwvc3ZnPgo=);\\n    background-position: 50%;\\n    background-repeat: no-repeat;\\n    background-origin: content-box;\\n    background-size: 40px 40px;\\n    box-shadow: 0 1px 1px rgba(0,0,0,.05),0 2px 2px rgba(0,0,0,.05),0 4px 4px rgba(0,0,0,.05);\\n    transition: transform 50ms ease-out;\\n}\\n\\n.button:hover {\\n    transform: scale(1.2);\\n}\\n\\n.button:active {\\n    transform: scale(1.1);\\n    transition: transform 50ms ease-in;\\n    background-color: #f0f0f0;\\n}\\n\\n.button-left {\\n    left: 8px;\\n    transform: scaleX(-1);\\n}\\n\\n.button-left:hover {\\n    transform: scaleX(-1) scale(1.2);\\n}\\n\\n.button-right {\\n    right: 8px;\\n}\\n\\n.ya-slider-leftmost .button-left,.ya-slider-rightmost .button-right {\\n    display: none;\\n}\\n\\n.recommendation-label {\\n    display: block;\\n    width: 100%;\\n    color: #ddd;\\n    text-align: right;\\n}\",\"gridColumns\":\"7\",\"gridRows\":\"1\"},{\"value\":\"17\",\"label\":\"Slider: square image, no background\",\"props\":{},\"template\":\"<div class=\\\"headline\\\">Читайте также</div>\\n<ya-units-slider>\\n<div class=\\\"container\\\">\\n    <div class=\\\"image\\\">\\n        <ya-unit-image ratio=\\\"1\\\" />\\n    </div>\\n    <div class=\\\"body\\\">\\n        <div>\\n            <ya-unit-kebab />\\n            <ya-unit-title class=\\\"title\\\" />\\n        </div>\\n        <ya-clamp class=\\\"description\\\" lines=\\\"3\\\">\\n            <ya-unit-desc />\\n        </ya-clamp>\\n        <div class=\\\"meta\\\">\\n            <ya-unit-category class=\\\"meta-span category\\\" />\\n            <ya-unit-date class=\\\"meta-span date\\\"/>\\n            <ya-unit-age class=\\\"meta-span age\\\" />\\n        </div>\\n        <div class=\\\"domain-block\\\">\\n            <ya-unit-domain class=\\\"domain\\\"/>\\n            <span class=\\\"favicon\\\">\\n                <ya-unit-favicon size=\\\"16\\\"/>\\n            </span>\\n        </div>\\n        <ya-unit-warning class=\\\"warning\\\" />\\n    </div>\\n</div>\\n<ya-slider-button direction=\\\"left\\\">\\n    <div class=\\\"button button-left\\\"></div>\\n</ya-slider-button>\\n<ya-slider-button direction=\\\"right\\\">\\n    <div class=\\\"button button-right\\\"></div>\\n</ya-slider-button>\\n</ya-units-slider>\\n<ya-recommendation-label />\",\"css\":\".headline {\\n    font-family: Helvetica,Arial,sans-serif;\\n    font-size: 20px;\\n    font-weight: 700;\\n    line-height: 24px;\\n    color: #373e44;\\n    padding-bottom: 20px;\\n    padding-top: 20px;\\n}\\n\\n.ya-units-slider {\\n    width: 100%;\\n}\\n\\n.ya-slider-item:not(:first-child) {\\n    margin-left: 20px;\\n}\\n\\n.ya-ad-close {\\n    background: 0 0;\\n    width: 20px;\\n    height: 20px;\\n}\\n\\n.unit-wrapper {\\n    width: 280px;\\n    height: 100%;\\n    background-color: #fff;\\n    transition: transform 50ms ease-out;\\n}\\n\\n.unit-wrapper:hover {\\n    transform: translateY(2px);\\n}\\n\\n.unit-wrapper:active {\\n    transform: translateY(4px);\\n}\\n\\n.container {\\n    position: relative;\\n    display: flex;\\n    flex-direction: row;\\n    flex-wrap: nowrap;\\n    width: 100%;\\n}\\n\\n.image {\\n    flex: 0 0 auto;\\n    width: 64px;\\n    margin-right: 16px;\\n}\\n\\n.unit-image {\\n    border-radius: 8px;\\n}\\n\\n.description,.domain-block,.title {\\n    color: #000;\\n    font-style: normal;\\n    font-weight: 700;\\n    font-size: 16px;\\n    line-height: 20px;\\n}\\n\\n.ya-unit-close~.ya-unit-title {\\n    margin-right: 16px;\\n}\\n\\n.description,.domain-block {\\n    font-weight: 400;\\n    font-size: 14px;\\n    color: #666;\\n    margin-top: 12px;\\n}\\n\\n.domain-block {\\n    color: #000;\\n    line-height: 16px;\\n    display: flex;\\n    align-items: center;\\n    position: relative;\\n}\\n\\n.domain:empty~.favicon,.meta-span:empty,.ya-unit-warning:empty {\\n    display: none;\\n}\\n\\n.domain {\\n    padding-left: 24px;\\n}\\n\\n.favicon {\\n    width: 16px;\\n    height: 16px;\\n    background-color: rgba(0 0 0/10%);\\n    display: inline-block;\\n    margin-right: 8px;\\n    position: absolute;\\n    top: 0;\\n    left: 0;\\n    border-radius: 4px;\\n}\\n\\n.meta {\\n    color: silver;\\n    font-style: normal;\\n    font-weight: 400;\\n    font-size: 12px;\\n    line-height: 16px;\\n    margin-top: 12px;\\n}\\n\\n.meta-span {\\n    padding: 0;\\n}\\n\\n.meta-span:before {\\n    content: \\\" · \\\";\\n}\\n\\n.meta-span:first-child:before {\\n    content: none;\\n}\\n\\n.warning {\\n    color: silver;\\n    font-style: normal;\\n    font-weight: 400;\\n    font-size: 12px;\\n    line-height: 16px;\\n    margin-top: 12px;\\n}\\n\\n.button {\\n    width: 40px;\\n    height: 40px;\\n    border-radius: 20px;\\n    position: absolute;\\n    cursor: pointer;\\n    z-index: 999;\\n    bottom: 39%;\\n    background-color: #fff;\\n    background-image: url(data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDAiIGhlaWdodD0iNDAiIHZpZXdCb3g9IjAgMCA0MCA0MCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTI3LjY2NjYgMjBMMjguMzczNyAyMC43MDcxQzI4Ljc2NDMgMjAuMzE2NiAyOC43NjQzIDE5LjY4MzQgMjguMzczNyAxOS4yOTI5TDI3LjY2NjYgMjBaTTExLjMzMzMgMjFIMjcuNjY2NlYxOUgxMS4zMzMzVjIxWk0xOS45NTk1IDEzLjcwNzFMMjYuOTU5NSAyMC43MDcxTDI4LjM3MzcgMTkuMjkyOUwyMS4zNzM3IDEyLjI5MjlMMTkuOTU5NSAxMy43MDcxWk0yNi45NTk1IDE5LjI5MjlMMTkuOTU5NSAyNi4yOTI5TDIxLjM3MzcgMjcuNzA3MUwyOC4zNzM3IDIwLjcwNzFMMjYuOTU5NSAxOS4yOTI5WiIgZmlsbD0iYmxhY2siIGZpbGwtb3BhY2l0eT0iMC45Ii8+Cjwvc3ZnPgo=);\\n    background-position: 50%;\\n    background-repeat: no-repeat;\\n    background-origin: content-box;\\n    background-size: 40px 40px;\\n    box-shadow: 0 1px 1px rgba(0,0,0,.05),0 2px 2px rgba(0,0,0,.05),0 4px 4px rgba(0,0,0,.05);\\n    transition: transform 50ms ease-out;\\n}\\n\\n.button:hover {\\n    transform: scale(1.2);\\n}\\n\\n.button:active {\\n    transform: scale(1.1);\\n    transition: transform 50ms ease-in;\\n    background-color: #f0f0f0;\\n}\\n\\n.button-left {\\n    left: 8px;\\n    transform: scaleX(-1);\\n}\\n\\n.button-left:hover {\\n    transform: scaleX(-1) scale(1.2);\\n}\\n\\n.button-right {\\n    right: 8px;\\n}\\n\\n.ya-slider-leftmost .button-left,.ya-slider-rightmost .button-right {\\n    display: none;\\n}\\n\\n.recommendation-label {\\n    display: block;\\n    width: 100%;\\n    color: #ddd;\\n    text-align: right;\\n}\",\"gridColumns\":\"7\",\"gridRows\":\"1\"},{\"value\":\"18\",\"label\":\"Slider: no image, with a background\",\"props\":{},\"template\":\"<div class=\\\"block\\\">\\n<div class=\\\"headline\\\">Читайте также</div>\\n<ya-units-slider>\\n    <div class=\\\"unit\\\">\\n        <ya-unit-kebab />\\n        <div class=\\\"body\\\">\\n            <ya-clamp class=\\\"title\\\" lines=\\\"3\\\">\\n                <ya-unit-title />\\n            </ya-clamp>\\n            <ya-clamp class=\\\"description\\\" lines=\\\"3\\\">\\n                <ya-unit-desc />\\n            </ya-clamp>\\n            <div class=\\\"meta\\\">\\n                <ya-unit-category class=\\\"meta-span category\\\" />\\n                <ya-unit-date class=\\\"meta-span date\\\" />\\n                <ya-unit-age class=\\\"meta-span age\\\" />\\n            </div>\\n            <div class=\\\"domain-block\\\">\\n                <ya-unit-domain class=\\\"domain\\\" /><span class=\\\"favicon\\\">\\n                    <ya-unit-favicon size=\\\"16\\\" /></span></div>\\n            <div class=\\\"warning\\\"></div>\\n        </div>\\n    </div>\\n    <ya-slider-button direction=\\\"left\\\">\\n        <div class=\\\"button button-left\\\"></div>\\n    </ya-slider-button>\\n    <ya-slider-button direction=\\\"right\\\">\\n        <div class=\\\"button button-right\\\"></div>\\n    </ya-slider-button>\\n</ya-units-slider>\\n<div class=\\\"recommendation-label\\\">\\n    <ya-recommendation-label class=\\\"label\\\" />\\n</div>\\n</div>\",\"css\":\".ya-units-slider {\\n    width: 100%;\\n}\\n\\n.ya-slider-item:not(:first-child) {\\n    margin-left: 12px;\\n}\\n\\n.block {\\n    padding: 0;\\n}\\n\\n.headline,.label {\\n    font-family: Helvetica,Arial,sans-serif;\\n}\\n\\n.label {\\n    display: block;\\n    font-size: 12px;\\n    color: #999;\\n}\\n\\n.headline {\\n    font-size: 20px;\\n    font-weight: 700;\\n    line-height: 24px;\\n    color: #373e44;\\n    padding-bottom: 12px;\\n    padding-top: 20px;\\n}\\n\\n.unit-wrapper {\\n    height: 100%;\\n}\\n\\n.image,.unit {\\n    position: relative;\\n    overflow: hidden;\\n}\\n\\n.unit {\\n    width: 240px;\\n    box-sizing: border-box;\\n    margin: 0 auto;\\n    -webkit-transform: translateZ(0);\\n    font-family: Helvetica,Arial,sans-serif;\\n    height: 100%;\\n    background: #f0f1f5;\\n    border-radius: 8px;\\n    display: flex;\\n    flex-direction: column;\\n    flex-wrap: nowrap;\\n    text-decoration: none;\\n    color: #000;\\n    cursor: pointer;\\n}\\n\\n.unit:hover {\\n    background: #e1e2e5;\\n}\\n\\n.unit:active {\\n    background: #d7d8db;\\n}\\n\\n.unit-container .ya-ad-warning {\\n    border-radius: 0 0 8px 8px;\\n}\\n\\n.image {\\n    display: block;\\n    flex-grow: 0;\\n    flex-shrink: 0;\\n}\\n\\n.img-source-component {\\n    transition: transform 100ms ease;\\n    border-radius: 0;\\n}\\n\\n.unit-wrapper:hover .unit-image .img-source-component {\\n    transform: scale(1.05);\\n}\\n\\n.unit-image {\\n    max-height: 200px;\\n}\\n\\n.body {\\n    position: relative;\\n    display: flex;\\n    flex-direction: column;\\n    width: 100%;\\n}\\n\\nya-image {\\n    max-height: 100px;\\n}\\n\\n.title {\\n    color: #000;\\n    font-style: normal;\\n    font-weight: 700;\\n    font-size: 16px;\\n    line-height: 20px;\\n    margin-top: 16px;\\n    padding-left: 16px;\\n    padding-right: 16px;\\n}\\n\\n.description,.domain-block {\\n    font-style: normal;\\n    font-weight: 400;\\n    font-size: 14px;\\n    margin-top: 12px;\\n}\\n\\n.description {\\n    line-height: 20px;\\n    color: #505050;\\n    padding-left: 16px;\\n    padding-right: 16px;\\n}\\n\\n.domain-block {\\n    color: #000;\\n    line-height: 16px;\\n    margin-left: 16px;\\n    margin-right: 16px;\\n    display: flex;\\n    align-items: center;\\n    position: relative;\\n}\\n\\n.domain:empty~.favicon {\\n    display: none;\\n}\\n\\n.domain {\\n    padding-left: 24px;\\n}\\n\\n.favicon {\\n    width: 16px;\\n    height: 16px;\\n    background-color: rgba(0 0 0/10%);\\n    display: inline-block;\\n    margin-right: 8px;\\n    position: absolute;\\n    top: 0;\\n    left: 0;\\n    border-radius: 4px;\\n}\\n\\n.meta {\\n    color: silver;\\n    font-style: normal;\\n    font-weight: 400;\\n    font-size: 12px;\\n    line-height: 16px;\\n    margin-top: 12px;\\n    padding-left: 16px;\\n    padding-right: 16px;\\n}\\n\\n.meta:last-child {\\n    padding-bottom: 16px;\\n}\\n\\n.meta-span {\\n    padding: 0;\\n}\\n\\n.meta-span:before {\\n    content: \\\" · \\\";\\n}\\n\\n.meta-span:first-child:before {\\n    content: none;\\n}\\n\\n.meta-span:empty,.unit-warning:empty {\\n    display: none;\\n}\\n\\n.unit-warning {\\n    position: relative;\\n    height: 24px;\\n    bottom: 24px;\\n    border-radius: 0 0 8px 8px;\\n    overflow: hidden;\\n    z-index: 99;\\n}\\n\\n.warning {\\n    min-height: 16px;\\n}\\n\\n.button {\\n    width: 40px;\\n    height: 40px;\\n    border-radius: 20px;\\n    position: absolute;\\n    cursor: pointer;\\n    z-index: 999;\\n    bottom: 39%;\\n    background-color: #fff;\\n    background-image: url(data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDBweCIgaGVpZ2h0PSI0MHB4IiB2aWV3Qm94PSIwIDAgNDAgNDAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PGcgdHJhbnNmb3JtPSJ0cmFuc2xhdGUoMTEuMCwgMTMuMCkiIHN0cm9rZT0iIzE4MTgxOCIgc3Ryb2tlLXdpZHRoPSIxLjgiIGZpbGw9Im5vbmUiPjxsaW5lIHgxPSIwLjUiIHkxPSI3IiB4Mj0iMTYuNSIgeTI9IjciPjwvbGluZT48cG9seWxpbmUgcG9pbnRzPSI5LjUgMCAxNi41IDcgOS41IDE0Ij48L3BvbHlsaW5lPjwvZz48L3N2Zz4=);\\n    background-position: 50%;\\n    background-repeat: no-repeat;\\n    background-origin: content-box;\\n    background-size: 40px 40px;\\n    box-shadow: 0 1px 1px rgba(0,0,0,.05),0 2px 2px rgba(0,0,0,.05),0 4px 4px rgba(0,0,0,.05);\\n    transition: transform 50ms ease-out;\\n}\\n\\n.button:hover {\\n    transform: scale(1.2);\\n}\\n\\n.button:active {\\n    transform: scale(1.1);\\n    transition: transform 50ms ease-in;\\n    background-color: #f0f0f0;\\n}\\n\\n.button-left {\\n    left: 8px;\\n    transform: scaleX(-1);\\n}\\n\\n.button-left:hover {\\n    transform: scaleX(-1) scale(1.2);\\n}\\n\\n.button-right {\\n    right: 8px;\\n}\\n\\n.ya-slider-leftmost .button-left,.ya-slider-rightmost .button-right {\\n    display: none;\\n}\\n\\n.recommendation-label {\\n    display: block;\\n    width: 100%;\\n    color: #ddd;\\n    text-align: right;\\n}\",\"gridColumns\":\"7\",\"gridRows\":\"1\"},{\"value\":\"19\",\"label\":\"Slider: no image, no background\",\"props\":{},\"template\":\"<div class=\\\"headline\\\">Читайте также</div>\\n<ya-units-slider>\\n<div class=\\\"container\\\">\\n    <div class=\\\"body\\\">\\n        <div>\\n            <ya-unit-kebab />\\n            <ya-unit-title class=\\\"title\\\" />\\n        </div>\\n        <ya-clamp class=\\\"description\\\" lines=\\\"3\\\">\\n            <ya-unit-desc />\\n        </ya-clamp>\\n        <div class=\\\"meta\\\">\\n            <ya-unit-category class=\\\"meta-span category\\\" />\\n            <ya-unit-date class=\\\"meta-span date\\\" />\\n            <ya-unit-age class=\\\"meta-span age\\\" />\\n        </div>\\n        <div class=\\\"domain-block\\\">\\n            <ya-unit-domain class=\\\"domain\\\" />\\n            <span class=\\\"favicon\\\">\\n                <ya-unit-favicon size=\\\"16\\\" />\\n            </span>\\n        </div>\\n        <div class=\\\"meta\\\">\\n            <ya-unit-warning class=\\\"meta-span warning\\\" />\\n        </div>\\n    </div>\\n</div>\\n<ya-slider-button direction=\\\"left\\\">\\n    <div class=\\\"button button-left\\\"></div>\\n</ya-slider-button>\\n<ya-slider-button direction=\\\"right\\\">\\n    <div class=\\\"button button-right\\\"></div>\\n</ya-slider-button>\\n</ya-units-slider>\\n<ya-recommendation-label />\",\"css\":\".headline {\\n    font-family: Helvetica,Arial,sans-serif;\\n    font-size: 20px;\\n    font-weight: 700;\\n    line-height: 24px;\\n    color: #373e44;\\n    padding-bottom: 20px;\\n    padding-top: 12px;\\n}\\n\\n.ya-units-slider {\\n    width: 100%;\\n}\\n\\n.ya-slider-item:not(:first-child) {\\n    margin-left: 20px;\\n}\\n\\n.ya-ad-close {\\n    background: 0 0;\\n    width: 20px;\\n    height: 20px;\\n}\\n\\n.unit-wrapper {\\n    width: 280px;\\n    height: 100%;\\n    background-color: #fff;\\n    transition: transform 50ms ease-out;\\n}\\n\\n.unit-wrapper:hover {\\n    transform: translateY(2px);\\n}\\n\\n.unit-wrapper:active {\\n    transform: translateY(4px);\\n}\\n\\n.container {\\n    position: relative;\\n    display: flex;\\n    flex-direction: row;\\n    flex-wrap: nowrap;\\n    width: 100%;\\n}\\n\\n.image {\\n    flex: 0 0 auto;\\n    width: 64px;\\n    margin-right: 16px;\\n}\\n\\n.unit-image {\\n    border-radius: 8px;\\n}\\n\\n.description {\\n    line-height: 20px;\\n}\\n\\n.description,.domain-block,.title {\\n    font-style: normal;\\n}\\n\\n.title {\\n    color: #000;\\n    font-weight: 700;\\n    font-size: 16px;\\n    line-height: 20px;\\n}\\n\\n.ya-unit-close~.ya-unit-title {\\n    margin-right: 16px;\\n}\\n\\n.description,.domain-block {\\n    font-weight: 400;\\n    font-size: 14px;\\n    color: #666;\\n    margin-top: 12px;\\n}\\n\\n.domain-block {\\n    color: #000;\\n    line-height: 16px;\\n    display: flex;\\n    align-items: center;\\n    position: relative;\\n}\\n\\n.domain:empty~.favicon,.meta-span:empty {\\n    display: none;\\n}\\n\\n.domain {\\n    padding-left: 24px;\\n}\\n\\n.favicon {\\n    width: 16px;\\n    height: 16px;\\n    background-color: rgba(0 0 0/10%);\\n    display: inline-block;\\n    margin-right: 8px;\\n    position: absolute;\\n    top: 0;\\n    left: 0;\\n    border-radius: 4px;\\n}\\n\\n.meta {\\n    color: silver;\\n    font-style: normal;\\n    font-weight: 400;\\n    font-size: 12px;\\n    line-height: 16px;\\n    margin-top: 12px;\\n}\\n\\n.meta-span {\\n    padding: 0;\\n}\\n\\n.meta-span:before {\\n    content: \\\" · \\\";\\n}\\n\\n.meta-span:first-child:before {\\n    content: none;\\n}\\n\\n.button {\\n    width: 40px;\\n    height: 40px;\\n    border-radius: 20px;\\n    position: absolute;\\n    cursor: pointer;\\n    z-index: 999;\\n    bottom: 45%;\\n    background-color: #fff;\\n    background-image: url(data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDAiIGhlaWdodD0iNDAiIHZpZXdCb3g9IjAgMCA0MCA0MCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTI3LjY2NjYgMjBMMjguMzczNyAyMC43MDcxQzI4Ljc2NDMgMjAuMzE2NiAyOC43NjQzIDE5LjY4MzQgMjguMzczNyAxOS4yOTI5TDI3LjY2NjYgMjBaTTExLjMzMzMgMjFIMjcuNjY2NlYxOUgxMS4zMzMzVjIxWk0xOS45NTk1IDEzLjcwNzFMMjYuOTU5NSAyMC43MDcxTDI4LjM3MzcgMTkuMjkyOUwyMS4zNzM3IDEyLjI5MjlMMTkuOTU5NSAxMy43MDcxWk0yNi45NTk1IDE5LjI5MjlMMTkuOTU5NSAyNi4yOTI5TDIxLjM3MzcgMjcuNzA3MUwyOC4zNzM3IDIwLjcwNzFMMjYuOTU5NSAxOS4yOTI5WiIgZmlsbD0iYmxhY2siIGZpbGwtb3BhY2l0eT0iMC45Ii8+Cjwvc3ZnPgo=);\\n    background-position: 50%;\\n    background-repeat: no-repeat;\\n    background-origin: content-box;\\n    background-size: 40px 40px;\\n    box-shadow: 0 1px 1px rgba(0,0,0,.05),0 2px 2px rgba(0,0,0,.05),0 4px 4px rgba(0,0,0,.05);\\n    transition: transform 50ms ease-out;\\n}\\n\\n.button:hover {\\n    transform: scale(1.2);\\n}\\n\\n.button:active {\\n    transform: scale(1.1);\\n    transition: transform 50ms ease-in;\\n    background-color: #f0f0f0;\\n}\\n\\n.button-left {\\n    left: 8px;\\n    transform: scaleX(-1);\\n}\\n\\n.button-left:hover {\\n    transform: scaleX(-1) scale(1.2);\\n}\\n\\n.button-right {\\n    right: 8px;\\n}\\n\\n.ya-slider-leftmost .button-left,.ya-slider-rightmost .button-right {\\n    display: none;\\n}\\n\\n.recommendation-label {\\n    display: block;\\n    width: 100%;\\n    color: #ddd;\\n    text-align: right;\\n}\",\"gridColumns\":\"7\",\"gridRows\":\"1\"}]"),
    (0, NOW(), NOW(), 'TurboNativeContextRuTemplates', "[{\"value\":\"1\",\"label\":\"лента рекомендаций\",\"template\":\"<div class=\\\"wrapper\\\">\\n    <ya-units-grid cols=\\\"1\\\" rows=\\\"1\\\">\\n        <div class=\\\"image\\\">\\n            <ya-unit-image ratio=\\\"0.5105\\\" />\\n          \\t<div class=\\\"top-left\\\"><ya-unit-category /></div>\\n        </div>\\n        <div class=\\\"meta\\\">\\n            <span class=\\\"title\\\"><ya-unit-title /></span>\\n            <ya-clamp lines=\\\"2\\\" class=\\\"description\\\">\\n                <ya-unit-desc />\\n            </ya-clamp>\\n            <ya-unit-domain class=\\\"domain\\\" />\\n            <ya-unit-age class=\\\"age\\\" />\\n            <button type=\\\"button\\\" class=\\\"button\\\">\\n                Перейти\\n            </button>\\n            <ya-unit-kebab />\\n        </div>\\n    </ya-units-grid>\\n</div>\",\"css\":\".wrapper {\\n    background: #fff;\\n    padding: 14px;\\n}\\n.image {\\n    border-radius: 12px;\\n    overflow: hidden;\\n    height: auto;\\n    max-width: 100%;\\n    position: relative;\\n    text-align: center;\\n    color: white;\\n}\\n\\n.top-left {\\n  position: absolute;\\n  top: 4px;\\n  left: 4px;\\n  border-radius: 6px;\\n  padding: 3px 4px 3px 4px;\\n  font-family: \\\"Helvetica Neue\\\", arial, sans-serif;\\n  font-size: 12px;\\n  font-weight: normal;\\n  backdrop-filter: blur(16px);\\n  -webkit-tap-highlight-color: transparent;\\n  z-index: 940;\\n}\\n\\n.title {\\n    color: #000;\\n    display: block;\\n    font-family: \\\"Helvetica Neue\\\", arial, sans-serif;\\n    font-size: 20px;\\n    font-weight: bold;\\n    line-height: 25px;\\n    margin-top: 16px;\\n    margin-bottom: 4px;\\n}\\n.description {\\n    margin-bottom: 4px;\\n}.description, .age, .domain {\\n    color: #333;\\n    font-family: \\\"Helvetica Neue\\\", arial, sans-serif;\\n    font-size: 14px;\\n    font-weight: normal;\\n    line-height: 18px;\\n    opacity: 0.8;\\n}\\n.currency {\\n    align-items: center;\\n    background-color: rgba(0,0,0,.6);\\n    border-radius: 50%;\\n    color: rgba(255,255,255,0.9);\\n    display: inline-flex;\\n    height: 20px;\\n    justify-content: center;\\n    opacity: 0.5;\\n    position: absolute;\\n    right: 30px;\\n    top: 6px;\\n    width: 20px;\\n}\\n.button {\\n    border: none;\\n    border-radius: 8px;\\n    background-color: #F0F1F5;\\n    color: #000;\\n    cursor: pointer;\\n    font-family: \\\"Helvetica Neue\\\", arial, sans-serif;\\n    font-size: 14px;\\n    font-weight: 500;\\n    line-height: 18px;\\n    margin-top: 12px;\\n    padding: 13px;\\n    width: 100%;\\n}\",\"gridColumns\":\"1\",\"gridColumnsDisabled\":true,\"gridRows\":\"1\",\"gridRowsDisabled\":true,\"advPositionMode\":\"automatic\",\"advPositions\":[-1],\"defaultWidth\":\"300\"}]"),
    (0, NOW(), NOW(), 'TurboNativeContextEnTemplates', "[{\"value\":\"1\",\"label\":\"recommendations feed\",\"template\":\"<div class=\\\"wrapper\\\">\\n    <ya-units-grid cols=\\\"1\\\" rows=\\\"1\\\">\\n        <div class=\\\"image\\\">\\n            <ya-unit-image ratio=\\\"0.5105\\\" />\\n          \\t<div class=\\\"top-left\\\"><ya-unit-category /></div>\\n        </div>\\n        <div class=\\\"meta\\\">\\n            <span class=\\\"title\\\"><ya-unit-title /></span>\\n            <ya-clamp lines=\\\"2\\\" class=\\\"description\\\">\\n                <ya-unit-desc />\\n            </ya-clamp>\\n            <ya-unit-domain class=\\\"domain\\\" />\\n            <ya-unit-age class=\\\"age\\\" />\\n            <button type=\\\"button\\\" class=\\\"button\\\">\\n                Перейти\\n            </button>\\n            <ya-unit-kebab />\\n        </div>\\n    </ya-units-grid>\\n</div>\",\"css\":\".wrapper {\\n    background: #fff;\\n    padding: 14px;\\n}\\n.image {\\n    border-radius: 12px;\\n    overflow: hidden;\\n    height: auto;\\n    max-width: 100%;\\n    position: relative;\\n    text-align: center;\\n    color: white;\\n}\\n\\n.top-left {\\n  position: absolute;\\n  top: 4px;\\n  left: 4px;\\n  border-radius: 6px;\\n  padding: 3px 4px 3px 4px;\\n  font-family: \\\"Helvetica Neue\\\", arial, sans-serif;\\n  font-size: 12px;\\n  font-weight: normal;\\n  backdrop-filter: blur(16px);\\n  -webkit-tap-highlight-color: transparent;\\n  z-index: 940;\\n}\\n\\n.title {\\n    color: #000;\\n    display: block;\\n    font-family: \\\"Helvetica Neue\\\", arial, sans-serif;\\n    font-size: 20px;\\n    font-weight: bold;\\n    line-height: 25px;\\n    margin-top: 16px;\\n    margin-bottom: 4px;\\n}\\n.description {\\n    margin-bottom: 4px;\\n}.description, .age, .domain {\\n    color: #333;\\n    font-family: \\\"Helvetica Neue\\\", arial, sans-serif;\\n    font-size: 14px;\\n    font-weight: normal;\\n    line-height: 18px;\\n    opacity: 0.8;\\n}\\n.currency {\\n    align-items: center;\\n    background-color: rgba(0,0,0,.6);\\n    border-radius: 50%;\\n    color: rgba(255,255,255,0.9);\\n    display: inline-flex;\\n    height: 20px;\\n    justify-content: center;\\n    opacity: 0.5;\\n    position: absolute;\\n    right: 30px;\\n    top: 6px;\\n    width: 20px;\\n}\\n.button {\\n    border: none;\\n    border-radius: 8px;\\n    background-color: #F0F1F5;\\n    color: #000;\\n    cursor: pointer;\\n    font-family: \\\"Helvetica Neue\\\", arial, sans-serif;\\n    font-size: 14px;\\n    font-weight: 500;\\n    line-height: 18px;\\n    margin-top: 12px;\\n    padding: 13px;\\n    width: 100%;\\n}\",\"gridColumns\":\"1\",\"gridColumnsDisabled\":true,\"gridRows\":\"1\",\"gridRowsDisabled\":true,\"advPositionMode\":\"automatic\",\"advPositions\":[-1],\"defaultWidth\":\"300\"}]"),
    (0, NOW(), NOW(), 'TurboContentContextRuTemplates', "[{\"value\":\"1\",\"label\":\"в тексте\",\"template\":\"<div class=\\\"wrapper\\\">\\n  <ya-units-slider>\\n    <div class=\\\"image\\\">\\n      <ya-unit-image ratio=\\\"0.625\\\" />\\n    </div>\\n    <div class=\\\"content\\\">\\n      <ya-clamp lines=\\\"3\\\" class=\\\"title\\\">\\n        <ya-unit-title/>\\n      </ya-clamp>\\n      <ya-clamp lines=\\\"3\\\" class=\\\"desc\\\">\\n         <ya-unit-desc />\\n      </ya-clamp>\\n      <div class=\\\"meta\\\">\\n        <ya-unit-domain class=\\\"domain\\\" />\\n        <ya-unit-date class=\\\"date\\\"/>\\n        &nbsp;&nbsp;&nbsp;\\n        <ya-unit-category class=\\\"ad-label\\\" ad-only />\\n      </div>\\n      <ya-unit-kebab />\\n    </div>\\n  </ya-units-slider>\\n</div>\\n\",\"css\":\".wrapper {\\n  max-width: 100vw;\\n  box-sizing: border-box;\\n  overflow-y: hidden;\\n  overflow-x: auto;\\n  background: white;\\n  font-family: \\\"Roboto\\\", Arial, Helvetica, sans-serif;\\n  -webkit-overflow-scrolling: touch;\\n}\\n\\n.wrapper::-webkit-scrollbar {\\n  display: none;\\n}\\n\\n.image {\\n  position: relative;\\n}\\n\\n.image .yrw-ya-unit-image-footer {\\n  background: rgba(0,0,0,0.5);\\n}\\n\\n.unit-wrapper {\\n  height: 285px;\\n}\\n\\n.unit-wrapper {\\n  width: 224px;\\n  margin: 0 8px 0 0;\\n  background: white;\\n  box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);\\n  border-radius: 8px;\\n}\\n\\n.content {\\n  display: flex;\\n  flex-direction: column;\\n  max-height: 144px;\\n  padding: 12px 12px 16px;\\n  box-sizing: border-box;\\n  white-space: normal;\\n}\\n\\n.title {\\n  color: #000;\\n  font-weight: 600;\\n  font-size: 16px;\\n  line-height: 20px;\\n}\\n\\n.image {\\n  display: block;\\n  width: 100%;\\n  box-sizing: border-box;\\n  overflow: hidden;\\n  border-radius: 0;\\n}\\n\\n.desc {\\n  min-height: 0;\\n  margin-top: 2px;\\n  overflow: hidden;\\n  color: #333333;\\n  font-size: 14px;\\n  line-height: 17px;\\n}\\n\\n.meta {\\n  display: flex;\\n  flex-wrap: nowrap;\\n  margin-top: 6px;\\n  color: #333333;\\n  opacity: 0.4;\\n  font-size: 14px;\\n  line-height: 17px;\\n}\\n\\n.ad-label {\\n  color: gray;\\n  font-size: 14px;\\n}\\n\\n.ya-ad-close {\\n  border-radius: 50%;\\n  top: 6px;\\n  right: 6px;\\n  background: rgba(0, 0, 0, 0.4);\\n  color: rgba(255, 255, 255, 0.7);\\n  opacity: 1;\\n  transform: scale(0.7) translate(1px, -1px);\\n}\\n\\n.ya-slider {\\n  padding: 14px;\\n}\\n\\n.ya-slider-item:last-child {\\n  padding-right: 6px;\\n}\\n\\n.unit-with-age .ya-unit-age::before {\\n  content: \\\"·\\\";\\n  padding: 0 3px;\\n}\",\"gridColumns\":\"5\",\"gridRows\":\"1\",\"gridRowsDisabled\":true,\"advPositionMode\":\"automatic\",\"advPositions\":[-1,-1],\"defaultWidth\":\"1180\"}]"),
    (0, NOW(), NOW(), 'TurboContentContextEnTemplates', "[{\"value\":\"1\",\"label\":\"in the text\",\"template\":\"<div class=\\\"wrapper\\\">\\n  <ya-units-slider>\\n    <div class=\\\"image\\\">\\n      <ya-unit-image ratio=\\\"0.625\\\" />\\n    </div>\\n    <div class=\\\"content\\\">\\n      <ya-clamp lines=\\\"3\\\" class=\\\"title\\\">\\n        <ya-unit-title/>\\n      </ya-clamp>\\n      <ya-clamp lines=\\\"3\\\" class=\\\"desc\\\">\\n         <ya-unit-desc />\\n      </ya-clamp>\\n      <div class=\\\"meta\\\">\\n        <ya-unit-domain class=\\\"domain\\\" />\\n        <ya-unit-date class=\\\"date\\\"/>\\n        &nbsp;&nbsp;&nbsp;\\n        <ya-unit-category class=\\\"ad-label\\\" ad-only />\\n      </div>\\n      <ya-unit-kebab />\\n    </div>\\n  </ya-units-slider>\\n</div>\\n\",\"css\":\".wrapper {\\n  max-width: 100vw;\\n  box-sizing: border-box;\\n  overflow-y: hidden;\\n  overflow-x: auto;\\n  background: white;\\n  font-family: \\\"Roboto\\\", Arial, Helvetica, sans-serif;\\n  -webkit-overflow-scrolling: touch;\\n}\\n\\n.wrapper::-webkit-scrollbar {\\n  display: none;\\n}\\n\\n.image {\\n  position: relative;\\n}\\n\\n.image .yrw-ya-unit-image-footer {\\n  background: rgba(0,0,0,0.5);\\n}\\n\\n.unit-wrapper {\\n  height: 285px;\\n}\\n\\n.unit-wrapper {\\n  width: 224px;\\n  margin: 0 8px 0 0;\\n  background: white;\\n  box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);\\n  border-radius: 8px;\\n}\\n\\n.content {\\n  display: flex;\\n  flex-direction: column;\\n  max-height: 144px;\\n  padding: 12px 12px 16px;\\n  box-sizing: border-box;\\n  white-space: normal;\\n}\\n\\n.title {\\n  color: #000;\\n  font-weight: 600;\\n  font-size: 16px;\\n  line-height: 20px;\\n}\\n\\n.image {\\n  display: block;\\n  width: 100%;\\n  box-sizing: border-box;\\n  overflow: hidden;\\n  border-radius: 0;\\n}\\n\\n.desc {\\n  min-height: 0;\\n  margin-top: 2px;\\n  overflow: hidden;\\n  color: #333333;\\n  font-size: 14px;\\n  line-height: 17px;\\n}\\n\\n.meta {\\n  display: flex;\\n  flex-wrap: nowrap;\\n  margin-top: 6px;\\n  color: #333333;\\n  opacity: 0.4;\\n  font-size: 14px;\\n  line-height: 17px;\\n}\\n\\n.ad-label {\\n  color: gray;\\n  font-size: 14px;\\n}\\n\\n.ya-ad-close {\\n  border-radius: 50%;\\n  top: 6px;\\n  right: 6px;\\n  background: rgba(0, 0, 0, 0.4);\\n  color: rgba(255, 255, 255, 0.7);\\n  opacity: 1;\\n  transform: scale(0.7) translate(1px, -1px);\\n}\\n\\n.ya-slider {\\n  padding: 14px;\\n}\\n\\n.ya-slider-item:last-child {\\n  padding-right: 6px;\\n}\\n\\n.unit-with-age .ya-unit-age::before {\\n  content: \\\"·\\\";\\n  padding: 0 3px;\\n}\",\"gridColumns\":\"5\",\"gridRows\":\"1\",\"gridRowsDisabled\":true,\"advPositionMode\":\"automatic\",\"advPositions\":[-1,-1],\"defaultWidth\":\"1180\"}]");
