ALTER TABLE `partner` . `internal_context_on_site_campaign` ADD COLUMN `blocks_count` int(10) NOT NULL DEFAULT '0',
  ALGORITHM = INPLACE, LOCK = NONE;
OPTIMIZE TABLE `partner` . `internal_context_on_site_campaign`;

ALTER TABLE `partner` . `internal_mobile_app`
  ADD COLUMN `blocks_count` int(10) NOT NULL DEFAULT '0',
  ALGORITHM = INPLACE, LOCK = NONE;
OPTIMIZE TABLE `partner` . `internal_mobile_app`;

ALTER TABLE `partner` . `internal_search_on_site_campaign`
  ADD COLUMN `blocks_count` int(10) NOT NULL DEFAULT '0',
  ALGORITHM = INPLACE, LOCK = NONE;
OPTIMIZE TABLE `partner` . `internal_search_on_site_campaign`;


ALTER TABLE `partner` . `internal_context_on_site_campaign` ADD COLUMN `blocks_limit` int(10) NOT NULL DEFAULT '400',
  ALGORITHM = INPLACE, LOCK = NONE;
OPTIMIZE TABLE `partner` . `internal_context_on_site_campaign`;

ALTER TABLE `partner` . `internal_mobile_app`
  ADD COLUMN `blocks_limit` int(10) NOT NULL DEFAULT '400',
  ALGORITHM = INPLACE, LOCK = NONE;
OPTIMIZE TABLE `partner` . `internal_mobile_app`;

ALTER TABLE `partner` . `internal_search_on_site_campaign`
  ADD COLUMN `blocks_limit` int(10) NOT NULL DEFAULT '400',
  ALGORITHM = INPLACE, LOCK = NONE;
OPTIMIZE TABLE `partner` . `internal_search_on_site_campaign`;


update `partner`.`internal_context_on_site_campaign` as new
inner join
(
    select p.id as page_id, count(b.id) as cnt from `partner`.`internal_context_on_site_campaign` as p
    join (
        select id, campaign_id, multistate from `partner`.`internal_context_on_site_content`
        union all
        select id, campaign_id, multistate from `partner`.`internal_context_on_site_direct`
        union all
        select id, campaign_id, multistate from `partner`.`internal_context_on_site_natural`
        union all
        select id, campaign_id, multistate from `partner`.`internal_context_on_site_rtb`
        union all
        select id, campaign_id, multistate from `partner`.`internal_context_on_site_stripe`
    ) as b
    on b.campaign_id = p.id and
    b.multistate & 9 = 0 and
    p.multistate & 8 = 0
    group by p.id
) as old
on new.id = old.page_id
set new.blocks_count = old.cnt;

update `partner`.`internal_mobile_app` as new
inner join
(
    select p.id as page_id, count(b.id) as cnt from `partner`.`internal_mobile_app` as p
    join (
        select id, application_id, multistate from `partner`.`internal_mobile_app_rtb`
    ) as b
    on b.application_id = p.id and
    b.multistate & 9 = 0 and
    p.multistate & 8 = 0
    group by p.id
) as old
on new.id = old.page_id
set new.blocks_count = old.cnt;

update `partner`.`internal_search_on_site_campaign` as new
inner join
(
    select p.id as page_id, count(b.id) as cnt from `partner`.`internal_search_on_site_campaign` as p
    join (
        select id, campaign_id, multistate from `partner`.`internal_search_on_site_direct`
        union all
        select id, campaign_id, multistate from `partner`.`internal_search_on_site_premium`
    ) as b
    on b.campaign_id = p.id and
    b.multistate & 9 = 0 and
    p.multistate & 8 = 0
    group by p.id
) as old
on new.id = old.page_id
set new.blocks_count = old.cnt;
