/* PI-8244 start */

CREATE TABLE IF NOT EXISTS `cookie_match_owners` (
    `tag_id` INT UNSIGNED NOT NULL,
    `user_id` BIGINT UNSIGNED NOT NULL,
    PRIMARY KEY (`tag_id`, `user_id`),
    FOREIGN KEY `fk_cookie_match_owners__tag_id___cookie_match__id` (`tag_id`)
        REFERENCES `cookie_match` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_cookie_match_owners__user_id___users__id` (`user_id`)
        REFERENCES `users` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8';

REPLACE INTO `cookie_match_owners` (SELECT cm.id, cm.owner_id FROM cookie_match AS cm WHERE cm.owner_id IS NOT NULL);

/*

--  это кусок - потом

ALTER TABLE `partner`.`cookie_match` 
DROP COLUMN `owner_id`,
DROP INDEX `fk_cookie_match__owner_id___users__id`;
*/

ANALYZE TABLE `partner`.`cookie_match`;

ALTER TABLE `partner`.`search_on_site_campaign` 
ADD COLUMN `user_synchronization` BOOLEAN NOT NULL DEFAULT '0' AFTER `market_api`,
ADD COLUMN `tag_id` INT UNSIGNED NULL AFTER `user_synchronization`;

ANALYZE TABLE `partner`.`search_on_site_campaign`;

REPLACE INTO `role_rights` (`role_id`, `right`)
	SELECT `t`.`role_id`, `t`.`right` FROM (
		SELECT
			`role_id`,
			'search_on_site_campaign_edit_field__user_synchronization' AS `right`
		FROM
			`role_rights`
		WHERE
			`right` = 'context_on_site_campaign_edit_field__user_synchronization'
	) AS `t`;

REPLACE INTO `role_rights` (`role_id`, `right`)
	SELECT `t`.`role_id`, `t`.`right` FROM (
		SELECT
			`role_id`,
			'search_on_site_campaign_view_field__user_synchronization' AS `right`
		FROM
			`role_rights`
		WHERE
			`right` = 'context_on_site_campaign_view_field__user_synchronization'
	) AS `t`;

/* PI-8244 end */
