#!/usr/bin/perl
use strict;
use warnings FATAL => 'all';

=head1 пример вызова

    perl -Ilib ./migrations/before_release/PI-26920-geo-migrations_MANUAL.pl
=cut

use lib::abs qw(../../lib/);

use qbit;
use Utils::ScriptWrapper;

run(
    sub {
        my ($app, $opts) = @_;

        my $models = {
            context_on_site_rtb => [qw(campaign_id id geo)],
            # internal_context_on_site_rtb     => [qw(campaign_id id geo)], он внутри context_on_site_rtb
            context_on_site_content          => [qw(campaign_id id geo)],
            internal_context_on_site_content => [qw(campaign_id id geo)],
            context_on_site_natural          => [qw(campaign_id id geo)],
            internal_context_on_site_natural => [qw(campaign_id id geo)],
            mobile_app_rtb                   => [qw(context_page_id id geo)],
            video_an_site_fullscreen         => [qw(page_id id geo)],
            video_an_site_inpage             => [qw(page_id id geo)],
            video_an_site_instream           => [qw(page_id id geo)],
        };

        # ключ = то что нужно удалить
        # значение = список на что надо заменить
        my $updater = {
            38   => [qw(10950)],
            39   => [qw(11029)],
            43   => [qw(11119)],
            47   => [qw(11079)],
            50   => [qw(11108)],
            51   => [qw(11131)],
            54   => [qw(11162)],
            56   => [qw(11225)],
            62   => [qw(11309)],
            65   => [qw(11316)],
            66   => [qw(11318)],
            172  => [qw(11111)],
            193  => [qw(10672)],
            980  => [qw(117 179 206)],
            1004 => [qw(181 210 1056)],
        };

        # ключ = то на что нужно заменить
        # значение = список что удалить и если нет ключа то взять минимальный cpm среди них
        my $updater2 = {
            149 => [qw(29634 29633 29632 29631 29630 29629)],
            159 => [qw(29403 29404 29406 29407 29408 29409 29410 29411 29412 29413 29414 29415 29416 29417)],
        };

        foreach my $model (keys %$models) {
            foreach my $geo_id (keys %$updater) {
                my $block_list = $app->partner_db->$model->get_all(
                    filter => ['geo', 'LIKE', \"%\"id\":\"$geo_id\"%"],
                    fields => $models->{$model},
                );

                for my $block (@$block_list) {
                    print logstr('Start Update block', $model, 'data before:', $block);
                    print logstr('Update geo', $geo_id);
                    my $old_geo = from_json($block->{geo});
                    my $old_cpm;
                    my @new_geo;
                    my $id_hash;
                    for my $geo_item (@$old_geo) {
                        if ($geo_item->{id} eq $geo_id) {
                            $old_cpm = $geo_item->{cpm};
                        } else {
                            $id_hash->{$geo_item->{id}} = TRUE;
                            push @new_geo, $geo_item;
                        }
                    }
                    my $to_insert = [grep {not exists $id_hash->{$_}} @{$updater->{$geo_id}}];
                    push @new_geo, map {{id => $_, cpm => $old_cpm}} @{$to_insert};

                    $app->partner_db->$model->edit($block, {geo => to_json(\@new_geo)});
                    print logstr('Stop Update block',
                        $model, 'data after:', $app->partner_db->$model->get($block, fields => [qw(geo)]));
                }
            }

            foreach my $geo_id (keys %$updater2) {

                my @filters = ();
                my $child_ids_hash;
                foreach my $child_geo_id (@{$updater2->{$geo_id}}) {
                    $child_ids_hash->{$child_geo_id} = TRUE;
                    push @filters, ['geo', 'LIKE', \"%\"id\":\"$child_geo_id\"%"];
                }

                my $block_list = $app->partner_db->$model->get_all(
                    filter => ['OR', [@filters]],
                    fields => $models->{$model},
                );

                for my $block (@$block_list) {
                    print logstr('Start Update block', $model, 'data before:', $block);
                    print logstr('Update geo', $geo_id);
                    my $old_geo = from_json($block->{geo});
                    my $min_cpm = 10000;                      # max available by interface 9999
                    my @new_geo;
                    my $id_hash;
                    for my $geo_item (@$old_geo) {
                        if (exists $child_ids_hash->{$geo_item->{id}}) {
                            if (int($geo_item->{cpm}) < $min_cpm) {
                                $min_cpm = $geo_item->{cpm};
                            }
                        } else {
                            $id_hash->{$geo_item->{id}} = TRUE;
                            push @new_geo, $geo_item;
                        }
                    }

                    if (not exists $id_hash->{$geo_id}) {
                        # не задан cpm на родительский подставим найденный минимальный среди дочерних
                        if ($min_cpm eq 10000) {
                            print logstr('Something wrong. Not Found correct cpm. geo_id: ', $geo_id);
                        } else {
                            push @new_geo,
                              {
                                id  => $geo_id,
                                cpm => $min_cpm
                              };
                        }
                    }

                    $app->partner_db->$model->edit($block, {geo => to_json(\@new_geo)});
                    print logstr('Stop Update block',
                        $model, 'data after:', $app->partner_db->$model->get($block, fields => [qw(geo)]));
                }
            }
        }
    }
   );
