#!/usr/bin/perl
use strict;
use warnings FATAL => 'all';

=head1 пример вызова

    perl -Ilib ./migrations/before_release/PI-26920-geo-migrations_MANUAL.pl
=cut

use lib::abs qw(../../lib/);

use qbit;
use Utils::ScriptWrapper;

run(
    sub {
        my ($app, $opts) = @_;

        # ключ = то что нужно удалить
        # значение = список на что надо заменить
        my $updater = {
            38   => [qw(10950)],
            39   => [qw(11029)],
            43   => [qw(11119)],
            47   => [qw(11079)],
            50   => [qw(11108)],
            51   => [qw(11131)],
            54   => [qw(11162)],
            56   => [qw(11225)],
            62   => [qw(11309)],
            65   => [qw(11316)],
            66   => [qw(11318)],
            172  => [qw(11111)],
            193  => [qw(10672)],
            980  => [qw(117 179 206)],
            1004 => [qw(181 210 1056)],
        };

        # ключ = то на что нужно заменить
        # значение = список что удалить и если нет ключа то взять минимальный cpm среди них
        my $updater2 = {
            149 => [qw(29634 29633 29632 29631 29630 29629)],
            159 => [qw(29403 29404 29406 29407 29408 29409 29410 29411 29412 29413 29414 29415 29416 29417)],
        };
        foreach my $geo_id (keys %$updater) {
            my $preset_list = $app->partner_db->block_presets->get_all(
                # тут была проблема, в выборку попадали settings в которых вообще не было geo,
                # но были бренды с тем же id
                # Корректный фильтр:
                # filter => [{json_unquote => [{json_extract => [settings => \'$.geo_group']}]},
                # 'LIKE', \"%\"id\": \"$geo_id\"%"],
                filter => ['settings', 'LIKE', \"%\"id\": \"$geo_id\"%"],
                fields => [qw(id settings)],
            );

            for my $preset (@$preset_list) {
                print logstr('Start Update', 'data before:', $preset);
                print logstr('Update geo', $geo_id);
                my $settings = from_json($preset->{settings});
                my $old_geo  = $settings->{geo_group}->{geo};
                my $old_cpm;
                my @new_geo;
                my $id_hash;
                for my $geo_item (@$old_geo) {

                    if ($geo_item->{id} eq $geo_id) {
                        $old_cpm = $geo_item->{cpm};
                    } else {
                        $id_hash->{$geo_item->{id}} = TRUE;
                        push @new_geo, $geo_item;
                    }
                }
                my $to_insert = [grep {not exists $id_hash->{$_}} @{$updater->{$geo_id}}];
                push @new_geo, map {{id => $_, cpm => $old_cpm}} @{$to_insert};

                $settings->{geo_group}->{geo} = \@new_geo;

                $app->partner_db->block_presets->edit($preset, {settings => to_json($settings)});
                print logstr('Stop Update', 'data after:',
                    $app->partner_db->block_presets->get($preset, fields => [qw(settings)]));
            }
        }

        foreach my $geo_id (keys %$updater2) {

            my @filters = ();
            my $child_ids_hash;
            foreach my $child_geo_id (@{$updater2->{$geo_id}}) {
                $child_ids_hash->{$child_geo_id} = TRUE;
                push @filters, ['settings', 'LIKE', \"%\"id\":\"$child_geo_id\"%"];
            }

            my $preset_list = $app->partner_db->block_presets->get_all(
                filter => ['OR', [@filters]],
                fields => [qw(id settings)],
            );

            for my $preset (@$preset_list) {
                print logstr('Start Update', 'data before:', $preset);
                print logstr('Update geo', $geo_id);
                my $settings = from_json($preset->{settings});
                my $old_geo  = $settings->{geo_group}->{geo};
                my $min_cpm  = 10000;                            # max available by interface 9999
                my @new_geo;
                my $id_hash;
                for my $geo_item (@$old_geo) {

                    if (exists $child_ids_hash->{$geo_item->{id}}) {
                        if (int($geo_item->{cpm}) < $min_cpm) {
                            $min_cpm = $geo_item->{cpm};
                        }
                    } else {
                        $id_hash->{$geo_item->{id}} = TRUE;
                        push @new_geo, $geo_item;
                    }
                }

                if (not exists $id_hash->{$geo_id}) {
                    # не задан cpm на родительский подставим найденный минимальный среди дочерних
                    if ($min_cpm eq 10000) {
                        print logstr('Do nothing. Children geo not exists', $geo_id);
                    } else {
                        push @new_geo,
                          {
                            id  => $geo_id,
                            cpm => $min_cpm
                          };
                    }
                }

                $app->partner_db->block_presets->edit($preset, {settings => to_json($settings)});
                print logstr('Stop Update', 'data after:',
                    $app->partner_db->block_presets->get($preset, fields => [qw(settings)]));
            }
        }
    }
   );
