#!/usr/bin/perl

use lib::abs qw(../../lib/);

use qbit;
use Utils::ScriptWrapper;

run(
    sub {
        my ($app, $opts) = @_;

        my $report_list = $app->partner_db->statistics_reports->get_all(
            filter => [
                'AND',
                [
                    ['OR', [['query', 'LIKE', \"%winrate%"], ['query', 'LIKE', \"%fillrate%"]]],
                    ['report_type', '=', \"mol"]
                ]
            ],
            fields => [qw(id query)],
        );

        #fillrate меняем на visibility
        #winrate меняем на fillrate
        for my $report (@$report_list) {
            my $old_query = from_json($report->{query});
            print logstr('report BEFORE:', {id => $report->{id}, query => $old_query});
            my $new_query = clone($old_query);
            foreach (qw(tableLevel chartLevel)) {
                $new_query->{$_}{fields} = [];
                my $already_have_visibility = grep {$_ eq 'visibility'} @{$old_query->{$_}{fields}};
                # to preserve sorting
                foreach my $field (@{$old_query->{$_}{fields}}) {
                    if ($field eq 'fillrate') {
                        push @{$new_query->{$_}{fields}}, 'visibility' unless $already_have_visibility;
                    } elsif ($field eq 'winrate') {
                        push @{$new_query->{$_}{fields}}, 'fillrate';
                    } else {
                        push @{$new_query->{$_}{fields}}, $field;
                    }
                }
            }
            print logstr('report AFTER: ', {%$report, (query => $new_query)});
            unless ($opts->{dry_run}) {
                $app->partner_db->statistics_reports->edit($report, {query => $new_query});
            }
        }
    }
   );
