/* PI-8306 start */

UPDATE `partner`.`ssp_seller` SET `user_id` = 345321935 WHERE id = 7944603;
UPDATE `partner`.`ssp_seller` SET `user_id` = 345331106 WHERE id = 7952356;
UPDATE `partner`.`ssp_seller` SET `user_id` = 368880517 WHERE id = 8739185;
UPDATE `partner`.`ssp_seller` SET `user_id` = 372795335 WHERE id = 8956639;
UPDATE `partner`.`ssp_seller` SET `user_id` = 375912862 WHERE id = 9143013;
UPDATE `partner`.`ssp_seller` SET `user_id` = 379473631 WHERE id = 9317367;
UPDATE `partner`.`ssp_seller` SET `user_id` = 382010672 WHERE id = 9438657;
UPDATE `partner`.`ssp_seller` SET `user_id` = 383782359 WHERE id = 9521033;
UPDATE `partner`.`ssp_seller` SET `user_id` = 412873060 WHERE id = 13921737;
UPDATE `partner`.`ssp_seller` SET `user_id` = 422846975 WHERE id = 17298340;
UPDATE `partner`.`ssp_seller` SET `user_id` = 426342434 WHERE id = 19209650;
UPDATE `partner`.`ssp_seller` SET `user_id` = 432099053 WHERE id = 22781050;

ALTER TABLE `partner`.`ssp_context_rtb` 
ADD COLUMN `owner_id` INT UNSIGNED NOT NULL AFTER `page_id`,
ADD INDEX `fk_ssp_context_rtb__owner_id___ssp_seller__user_id_idx` (`owner_id` ASC);
ALTER TABLE `partner`.`ssp_context_rtb` 
ADD CONSTRAINT `fk_ssp_context_rtb__owner_id___ssp_seller__user_id`
  FOREIGN KEY (`owner_id`)
  REFERENCES `partner`.`ssp_seller` (`user_id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;

ANALYZE TABLE `partner`.`ssp_context_rtb`;

ALTER TABLE `partner`.`ssp_mobile_app` 
ADD COLUMN `owner_id` INT UNSIGNED NOT NULL AFTER `page_id`,
ADD INDEX `fk_ssp_mobile_app__owner_id___ssp_seller__user_id_idx` (`owner_id` ASC);
ALTER TABLE `partner`.`ssp_mobile_app` 
ADD CONSTRAINT `fk_ssp_mobile_app__owner_id___ssp_seller__user_id`
  FOREIGN KEY (`owner_id`)
  REFERENCES `partner`.`ssp_seller` (`user_id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;

ANALYZE TABLE `partner`.`ssp_mobile_app`;

CREATE OR REPLACE
DEFINER = 'root'@'localhost'     -- setting 'definer' to another user requires SUPER privilege
SQL SECURITY INVOKER
VIEW `all_pages` (
    `id`, `model`,
    `page_id`, `caption`, `domain`,
    `product_type`,
    `owner_id`, `login`, `client_id`, `business_unit`
    ) AS
(
    SELECT
        p.`id`, 'context_on_site_campaign' AS `model`,
        p.`page_id` AS `page_id`, p.`caption` AS `caption`, s.`domain` AS `domain`,
        'context' AS `product_type`,
        u.`id` AS `owner_id`, u.`login` AS `login`, u.`client_id` AS `client_id`, u.`business_unit` AS `business_unit`
    FROM `context_on_site_campaign` p
        JOIN `site` s ON s.`id` = p.`domain_id`
        JOIN `users` u ON u.`id` = p.`owner_id`
)
UNION ALL (
    SELECT
        p.`id`, 'search_on_site_campaign' AS `model`,
        p.`page_id` AS `page_id`, p.`caption` AS `caption`, s.`domain` AS `domain`,
        'search' AS `product_type`,
        u.`id` AS `owner_id`, u.`login` AS `login`, u.`client_id` AS `client_id`, u.`business_unit` AS `business_unit`
    FROM `search_on_site_campaign` p
        JOIN `site` s ON s.`id` = p.`domain_id`
        JOIN `users` u ON u.`id` = p.`owner_id`
)
UNION ALL (
    SELECT
        p.`id`, 'mobile_app_settings' AS `model`,
        p.`context_page_id` AS `page_id`, p.`caption` AS `caption`, a.`store_id` AS `domain`,
        'mobile' AS `product_type`,
        u.`id` AS `owner_id`, u.`login` AS `login`, u.`client_id` AS `client_id`, u.`business_unit` AS `business_unit`
    FROM `mobile_app_settings` p
        JOIN `mobile_app` a ON a.`id` = p.`application_id`
        JOIN `users` u ON u.`id` = p.`owner_id`
)
UNION ALL (
    SELECT
        p.`id`, 'video_an_site' AS `model`,
        p.`id` AS `page_id`, p.`caption` AS `caption`, p.`domain` AS `domain`,
        'video' AS `product_type`,
        u.`id` AS `owner_id`, u.`login` AS `login`, u.`client_id` AS `client_id`, u.`business_unit` AS `business_unit`
    FROM `video_an_site` p
        JOIN `users` u ON u.`id` = p.`owner_id`
)
UNION ALL (
    SELECT
        p.`id`, 'internal_context_on_site_campaign' AS `model`,
        p.`id` AS `page_id`, s.`domain` AS `caption`, s.`domain` AS `domain`,
        'context' AS `product_type`,
        54519301 AS `owner_id`, 'adinside' AS `login`, 944028 AS `client_id`, 0 AS `business_unit`
    FROM `internal_context_on_site_campaign` p
        JOIN `internal_site` s ON s.`id` = p.`site_id`
)
UNION ALL (
    SELECT
        p.`id`, 'internal_search_on_site_campaign' AS `model`,
        p.`id` AS `page_id`, s.`domain` AS `caption`, s.`domain` AS `domain`,
        'search' AS `product_type`,
        54519301 AS `owner_id`, 'adinside' AS `login`, 944028 AS `client_id`, 0 AS `business_unit`
    FROM `internal_search_on_site_campaign` p
        JOIN `internal_site` s ON s.`id` = p.`site_id`
)
UNION ALL (
    SELECT
        `id`, 'internal_mobile_app' AS `model`,
        `id` AS `page_id`, `caption` AS `caption`, `store_id` AS `domain`,
        'mobile' AS `product_type`,
        54519301 AS `owner_id`, 'adinside' AS `login`, 944028 AS `client_id`, 0 AS `business_unit`
    FROM `internal_mobile_app`
)
UNION ALL (
    SELECT
        `p`.`id`, 'ssp_mobile_app' AS `model`,
        `p`.`page_id` AS `page_id`, `p`.`store_bundle_id` AS `caption`, `p`.`store_bundle_id` AS `domain`,
        'mobile' AS `product_type`,
        `u`.`id` AS `owner_id`, `u`.`login` AS `login`, `u`.`client_id` AS `client_id`, 0 AS `business_unit`
    FROM `ssp_mobile_app` AS `p`
        JOIN `ssp_seller` AS `s` ON `s`.`id` = `p`.`seller_id`
        JOIN `users` AS `u` ON `u`.`client_id` = `s`.`client_id`
)
UNION ALL (
    SELECT
        `p`.`id`, 'ssp_context_rtb' AS `model`,
        `p`.`page_id` AS `page_id`, `ss`.`domain` AS `caption`, `ss`.`domain` AS `domain`,
        'mobile' AS `product_type`,
        `u`.`id` AS `owner_id`, `u`.`login` AS `login`, `u`.`client_id` AS `client_id`, 0 AS `business_unit`
    FROM `ssp_context_rtb` AS `p`
        JOIN `ssp_link_context_rtb` AS `slcr` ON `slcr`.`context_rtb_id` = `p`.`id`
        JOIN `ssp_site` AS `ss` ON `ss`.`id` = `slcr`.`site_id`
        JOIN `ssp_seller` AS `s` ON `s`.`id` = `slcr`.`seller_id`
        JOIN `users` AS `u` ON `u`.`client_id` = `s`.`client_id`
);

/* PI-8306 end */
