/* PI-9390_page_language start */

RENAME TABLE context_on_site_campaign_bk_language TO context_on_site_campaign_banner_lang;
RENAME TABLE internal_context_on_site_campaign_bk_language TO internal_context_on_site_campaign_banner_lang;
RENAME TABLE search_on_site_campaign_bk_language TO search_on_site_campaign_banner_lang;
RENAME TABLE internal_search_on_site_campaign_bk_language TO internal_search_on_site_campaign_banner_lang;

ALTER TABLE context_on_site_campaign ADD COLUMN page_lang int(10) unsigned NOT NULL DEFAULT '1';
ALTER TABLE internal_context_on_site_campaign ADD COLUMN page_lang int(10) unsigned NOT NULL DEFAULT '1';
ALTER TABLE internal_search_on_site_campaign ADD COLUMN page_lang int(10) unsigned NOT NULL DEFAULT '1';
ALTER TABLE search_on_site_campaign ADD COLUMN page_lang int(10) unsigned NOT NULL DEFAULT '1';

ALTER TABLE context_on_site_campaign ADD FOREIGN KEY (`page_lang`) REFERENCES `bk_language` (`id`);
ALTER TABLE internal_context_on_site_campaign ADD FOREIGN KEY (`page_lang`) REFERENCES `bk_language` (`id`);
ALTER TABLE internal_search_on_site_campaign ADD FOREIGN KEY (`page_lang`) REFERENCES `bk_language` (`id`);
ALTER TABLE search_on_site_campaign ADD FOREIGN KEY (`page_lang`) REFERENCES `bk_language` (`id`);

REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'context_on_site_campaign_edit_field__banner_lang' AS `right` FROM role_rights WHERE `right` = 'context_on_site_campaign_edit_field__bk_languages') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'context_on_site_campaign_view_field__banner_lang' AS `right` FROM role_rights WHERE `right` = 'context_on_site_campaign_view_field__bk_languages') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'internal_context_on_site_campaign_edit_field__banner_lang' AS `right` FROM role_rights WHERE `right` = 'internal_context_on_site_campaign_edit_field__bk_languages') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'internal_context_on_site_campaign_view_field__banner_lang' AS `right` FROM role_rights WHERE `right` = 'internal_context_on_site_campaign_view_field__bk_languages') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'internal_search_on_site_campaign_edit_field__banner_lang' AS `right` FROM role_rights WHERE `right` = 'internal_search_on_site_campaign_edit_field__bk_languages') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'internal_search_on_site_campaign_view_field__banner_lang' AS `right` FROM role_rights WHERE `right` = 'internal_search_on_site_campaign_view_field__bk_languages') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'search_on_site_campaign_edit_field__banner_lang' AS `right` FROM role_rights WHERE `right` = 'search_on_site_campaign_edit_field__bk_languages') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'search_on_site_campaign_view_field__banner_lang' AS `right` FROM role_rights WHERE `right` = 'search_on_site_campaign_view_field__bk_languages') t;

ALTER TABLE bk_language DROP COLUMN multistate;

DROP TABLE bk_language_action_log;

DELETE FROM role_rights WHERE `right` IN (
'context_on_site_campaign_edit_field__bk_languages',
'context_on_site_campaign_view_field__bk_languages',
'internal_context_on_site_campaign_edit_field__bk_languages',
'internal_context_on_site_campaign_view_field__bk_languages',
'internal_search_on_site_campaign_edit_field__bk_languages',
'internal_search_on_site_campaign_view_field__bk_languages',
'search_on_site_campaign_edit_field__bk_languages',
'search_on_site_campaign_view_field__bk_languages',
'bk_language_add',
'bk_language_edit');

ANALYZE TABLE context_on_site_campaign;
ANALYZE TABLE internal_context_on_site_campaign;
ANALYZE TABLE internal_search_on_site_campaign;
ANALYZE TABLE search_on_site_campaign;
ANALYZE TABLE bk_language;

/* PI-9390_page_language end */