use partner;


/* PI-9040 start */
/* PI-9040_editable_users start */

REPLACE `partner`.`role_rights` VALUES
    (39, 'users_edit_all');

DELETE FROM `partner`.`role_rights` WHERE role_id = 8 and `right` = 'users_edit_all';

/* PI-9040_editable_users end */
/* PI-9040 end */


/* PI-9101 start */
/* PI-9101_deleted_mirrors start */

ALTER TABLE `context_on_site_mirrors` ADD COLUMN `multistate` bigint(20) unsigned NOT NULL DEFAULT '0';
UPDATE `context_on_site_mirrors` SET `multistate` = 0 WHERE `moderation_status` = 'new';
UPDATE `context_on_site_mirrors` SET `multistate` = 1 WHERE `moderation_status` = 'approved';
UPDATE `context_on_site_mirrors` SET `multistate` = 2 WHERE `moderation_status` = 'rejected';
ALTER TABLE `context_on_site_mirrors` DROP COLUMN `moderation_status`;
ANALYZE TABLE `context_on_site_mirrors`;

ALTER TABLE `search_on_site_mirrors` ADD COLUMN `multistate` bigint(20) unsigned NOT NULL DEFAULT '0';
UPDATE `search_on_site_mirrors` SET `multistate` = 0 WHERE `moderation_status` = 'new';
UPDATE `search_on_site_mirrors` SET `multistate` = 1 WHERE `moderation_status` = 'approved';
UPDATE `search_on_site_mirrors` SET `multistate` = 2 WHERE `moderation_status` = 'rejected';
ALTER TABLE `search_on_site_mirrors` DROP COLUMN `moderation_status`;
ANALYZE TABLE `search_on_site_mirrors`;

/* PI-9101_deleted_mirrors end */
/* PI-9101 end */


/* PI-9314 start */

ALTER TABLE `partner`.`video_an_site` 
ADD COLUMN `vast_version` TINYINT(1) UNSIGNED NOT NULL DEFAULT '2' AFTER `skin_timeout`;

ANALYZE TABLE `partner`.`video_an_site`;

/* PI-9314 end */


/* PI-9390 start */
/* PI-9390_page_language start */

RENAME TABLE context_on_site_campaign_bk_language TO context_on_site_campaign_banner_lang;
RENAME TABLE internal_context_on_site_campaign_bk_language TO internal_context_on_site_campaign_banner_lang;
RENAME TABLE search_on_site_campaign_bk_language TO search_on_site_campaign_banner_lang;
RENAME TABLE internal_search_on_site_campaign_bk_language TO internal_search_on_site_campaign_banner_lang;

ALTER TABLE context_on_site_campaign ADD COLUMN page_lang int(10) unsigned NOT NULL DEFAULT '1';
ALTER TABLE internal_context_on_site_campaign ADD COLUMN page_lang int(10) unsigned NOT NULL DEFAULT '1';
ALTER TABLE internal_search_on_site_campaign ADD COLUMN page_lang int(10) unsigned NOT NULL DEFAULT '1';
ALTER TABLE search_on_site_campaign ADD COLUMN page_lang int(10) unsigned NOT NULL DEFAULT '1';

ALTER TABLE context_on_site_campaign ADD FOREIGN KEY (`page_lang`) REFERENCES `bk_language` (`id`);
ALTER TABLE internal_context_on_site_campaign ADD FOREIGN KEY (`page_lang`) REFERENCES `bk_language` (`id`);
ALTER TABLE internal_search_on_site_campaign ADD FOREIGN KEY (`page_lang`) REFERENCES `bk_language` (`id`);
ALTER TABLE search_on_site_campaign ADD FOREIGN KEY (`page_lang`) REFERENCES `bk_language` (`id`);

REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'context_on_site_campaign_edit_field__banner_lang' AS `right` FROM role_rights WHERE `right` = 'context_on_site_campaign_edit_field__bk_languages') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'context_on_site_campaign_view_field__banner_lang' AS `right` FROM role_rights WHERE `right` = 'context_on_site_campaign_view_field__bk_languages') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'internal_context_on_site_campaign_edit_field__banner_lang' AS `right` FROM role_rights WHERE `right` = 'internal_context_on_site_campaign_edit_field__bk_languages') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'internal_context_on_site_campaign_view_field__banner_lang' AS `right` FROM role_rights WHERE `right` = 'internal_context_on_site_campaign_view_field__bk_languages') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'internal_search_on_site_campaign_edit_field__banner_lang' AS `right` FROM role_rights WHERE `right` = 'internal_search_on_site_campaign_edit_field__bk_languages') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'internal_search_on_site_campaign_view_field__banner_lang' AS `right` FROM role_rights WHERE `right` = 'internal_search_on_site_campaign_view_field__bk_languages') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'search_on_site_campaign_edit_field__banner_lang' AS `right` FROM role_rights WHERE `right` = 'search_on_site_campaign_edit_field__bk_languages') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'search_on_site_campaign_view_field__banner_lang' AS `right` FROM role_rights WHERE `right` = 'search_on_site_campaign_view_field__bk_languages') t;

ALTER TABLE bk_language DROP COLUMN multistate;

DROP TABLE bk_language_action_log;

DELETE FROM role_rights WHERE `right` IN (
'context_on_site_campaign_edit_field__bk_languages',
'context_on_site_campaign_view_field__bk_languages',
'internal_context_on_site_campaign_edit_field__bk_languages',
'internal_context_on_site_campaign_view_field__bk_languages',
'internal_search_on_site_campaign_edit_field__bk_languages',
'internal_search_on_site_campaign_view_field__bk_languages',
'search_on_site_campaign_edit_field__bk_languages',
'search_on_site_campaign_view_field__bk_languages',
'bk_language_add',
'bk_language_edit');

ANALYZE TABLE context_on_site_campaign;
ANALYZE TABLE internal_context_on_site_campaign;
ANALYZE TABLE internal_search_on_site_campaign;
ANALYZE TABLE search_on_site_campaign;
ANALYZE TABLE bk_language;

/* PI-9390_page_language end */
/* PI-9390 end */


/* PI-9471 start */

ALTER TABLE `video_an_site_fullscreen`
    ADD `strategy` SMALLINT UNSIGNED NOT NULL DEFAULT '0',
    ADD `video_active` BOOLEAN,
    ADD `video_blocked` BOOLEAN,
    ADD `video_cpm` SMALLINT UNSIGNED,
    ADD `video_performance_active` BOOLEAN,
    ADD `video_performance_blocked` BOOLEAN,
    ADD `video_performance_cpm` SMALLINT UNSIGNED,
    CHANGE `mincpm` `mincpm` SMALLINT UNSIGNED;

ANALYZE TABLE `video_an_site_fullscreen`;


ALTER TABLE `video_an_site_instream`
    ADD `strategy` SMALLINT UNSIGNED NOT NULL DEFAULT '0',
    ADD `video_active` BOOLEAN,
    ADD `video_blocked` BOOLEAN,
    ADD `video_cpm` SMALLINT UNSIGNED,
    ADD `video_performance_active` BOOLEAN,
    ADD `video_performance_blocked` BOOLEAN,
    ADD `video_performance_cpm` SMALLINT UNSIGNED,
    CHANGE `mincpm` `mincpm` SMALLINT UNSIGNED;

ANALYZE TABLE `video_an_site_instream`;


ALTER TABLE `video_an_site_inpage`
    ADD `strategy` SMALLINT UNSIGNED NOT NULL DEFAULT '0',
    ADD `video_active` BOOLEAN,
    ADD `video_blocked` BOOLEAN,
    ADD `video_cpm` SMALLINT UNSIGNED,
    ADD `video_performance_active` BOOLEAN,
    ADD `video_performance_blocked` BOOLEAN,
    ADD `video_performance_cpm` SMALLINT UNSIGNED,
    CHANGE `mincpm` `mincpm` SMALLINT UNSIGNED;

ANALYZE TABLE `video_an_site_inpage`;

INSERT IGNORE INTO `partner`.`video_an_site_block_dsps` (`page_id`, `block_id`, `dsp_id`, `show_count`, `interval`, `is_deleted`)
	SELECT t.page_id, t.block_id, t.dsp_id, t.show_count, t.`interval`, t.is_deleted FROM (
		SELECT
			`vasi`.`page_id`,
			`vasi`.`id` AS `block_id`,
			1 AS `dsp_id`,
			NULL AS `show_count`,
			NULL AS `interval`,
			0 AS `is_deleted`
		FROM
			`video_an_site_instream` AS `vasi`
		LEFT JOIN
			`video_an_site_block_dsps` AS `vasbd` ON `vasi`.`page_id` = `vasbd`.`page_id` AND `vasi`.`id` = `vasbd`.`block_id`
		WHERE (`vasi`.`multistate` & 1<<0) = 1 AND `vasbd`.`dsp_id` IS NULL
	) AS t;

INSERT IGNORE INTO `partner`.`video_an_site_block_dsps` (`page_id`, `block_id`, `dsp_id`, `show_count`, `interval`, `is_deleted`)
	SELECT t.page_id, t.block_id, t.dsp_id, t.show_count, t.`interval`, t.is_deleted FROM (
		SELECT
			`vasi`.`page_id`,
			`vasi`.`id` AS `block_id`,
			1 AS `dsp_id`,
			NULL AS `show_count`,
			NULL AS `interval`,
			0 AS `is_deleted`
		FROM
			`video_an_site_inpage` AS `vasi`
		LEFT JOIN
			`video_an_site_block_dsps` AS `vasbd` ON `vasi`.`page_id` = `vasbd`.`page_id` AND `vasi`.`id` = `vasbd`.`block_id`
		WHERE (`vasi`.`multistate` & 1<<0) = 1 AND `vasbd`.`dsp_id` IS NULL
	) AS t;

INSERT IGNORE INTO `partner`.`video_an_site_block_dsps` (`page_id`, `block_id`, `dsp_id`, `show_count`, `interval`, `is_deleted`)
	SELECT t.page_id, t.block_id, t.dsp_id, t.show_count, t.`interval`, t.is_deleted FROM (
		SELECT
			`vasf`.`page_id`,
			`vasf`.`id` AS `block_id`,
			1 AS `dsp_id`,
			NULL AS `show_count`,
			NULL AS `interval`,
			0 AS `is_deleted`
		FROM
			`video_an_site_fullscreen` AS `vasf`
		LEFT JOIN
			`video_an_site_block_dsps` AS `vasbd` ON `vasf`.`page_id` = `vasbd`.`page_id` AND `vasf`.`id` = `vasbd`.`block_id`
		WHERE (`vasf`.`multistate` & 1<<0) = 1 AND `vasbd`.`dsp_id` IS NULL
	) AS t;

UPDATE video_an_site_instream SET bk_data = '{}' WHERE bk_data = '';
UPDATE video_an_site_inpage SET bk_data = '{}' WHERE bk_data = '';
UPDATE video_an_site_fullscreen SET bk_data = '{}' WHERE bk_data = '';

/* PI-9471 end */

