CREATE OR REPLACE
DEFINER = 'root'@'localhost'     -- setting 'definer' to another user requires SUPER privilege
SQL SECURITY INVOKER
VIEW `all_pages` (
    `id`, `model`,
    `page_id`, `caption`, `domain`, `is_protected`, `is_readonly`,
    `product_type`,
    `owner_id`, `login`, `client_id`, `business_unit`
    ) AS
(
    SELECT
        p.`id`, 'context_on_site_campaign' AS `model`,
        p.`page_id` AS `page_id`, p.`caption` AS `caption`, s.`domain` AS `domain`,
        if(p.multistate & 1024, 1, 0) as `is_protected`, if(p.multistate & 32, 1, 0) as `is_readonly`,
        'context' AS `product_type`,
        u.`id` AS `owner_id`, u.`login` AS `login`, u.`client_id` AS `client_id`, u.`business_unit` AS `business_unit`
    FROM `context_on_site_campaign` p
        JOIN `site` s ON s.`id` = p.`domain_id`
        JOIN `users` u ON u.`id` = p.`owner_id`
)
UNION ALL (
    SELECT
        p.`id`, 'search_on_site_campaign' AS `model`,
        p.`page_id` AS `page_id`, p.`caption` AS `caption`, s.`domain` AS `domain`,
        if(p.multistate & 1024, 1, 0) as `is_protected`, if(p.multistate & 32, 1, 0) as `is_readonly`,
        'search' AS `product_type`,
        u.`id` AS `owner_id`, u.`login` AS `login`, u.`client_id` AS `client_id`, u.`business_unit` AS `business_unit`
    FROM `search_on_site_campaign` p
        JOIN `site` s ON s.`id` = p.`domain_id`
        JOIN `users` u ON u.`id` = p.`owner_id`
)
UNION ALL (
    SELECT
        p.`id`, 'mobile_app_settings' AS `model`,
        p.`context_page_id` AS `page_id`, p.`caption` AS `caption`, a.`store_id` AS `domain`,
        if(p.multistate & 256, 1, 0) as `is_protected`, 0 as `is_readonly`,
        'mobile' AS `product_type`,
        u.`id` AS `owner_id`, u.`login` AS `login`, u.`client_id` AS `client_id`, u.`business_unit` AS `business_unit`
    FROM `mobile_app_settings` p
        JOIN `mobile_app` a ON a.`id` = p.`application_id`
        JOIN `users` u ON u.`id` = p.`owner_id`
)
UNION ALL (
    SELECT
        p.`id`, 'video_an_site' AS `model`,
        p.`id` AS `page_id`, p.`caption` AS `caption`, p.`domain` AS `domain`,
        if(p.multistate&32,1,0) as `is_protected`, 0 as `is_readonly`,
        'video' AS `product_type`,
        u.`id` AS `owner_id`, u.`login` AS `login`, u.`client_id` AS `client_id`, u.`business_unit` AS `business_unit`
    FROM `video_an_site` p
        JOIN `users` u ON u.`id` = p.`owner_id`
)
UNION ALL (
    SELECT
        p.`id`, 'internal_context_on_site_campaign' AS `model`,
        p.`id` AS `page_id`, s.`domain` AS `caption`, s.`domain` AS `domain`,
        if(p.multistate&128,1,0) as `is_protected`, if(p.multistate & 32, 1, 0) as `is_readonly`,
        'context' AS `product_type`,
        54519301 AS `owner_id`, 'adinside' AS `login`, 944028 AS `client_id`, 0 AS `business_unit`
    FROM `internal_context_on_site_campaign` p
        JOIN `internal_site` s ON s.`id` = p.`site_id`
)
UNION ALL (
    SELECT
        p.`id`, 'internal_search_on_site_campaign' AS `model`,
        p.`id` AS `page_id`, s.`domain` AS `caption`, s.`domain` AS `domain`,
        if(p.multistate&128,1,0) as `is_protected`, if(p.multistate & 32, 1, 0) as `is_readonly`,
        'search' AS `product_type`,
        54519301 AS `owner_id`, 'adinside' AS `login`, 944028 AS `client_id`, 0 AS `business_unit`
    FROM `internal_search_on_site_campaign` p
        JOIN `internal_site` s ON s.`id` = p.`site_id`
)
UNION ALL (
    SELECT
        `id`, 'internal_mobile_app' AS `model`,
        `id` AS `page_id`, `caption` AS `caption`, `store_id` AS `domain`,
        if(multistate&32,1,0) as `is_protected`, 0 as `is_readonly`,
        'mobile' AS `product_type`,
        54519301 AS `owner_id`, 'adinside' AS `login`, 944028 AS `client_id`, 0 AS `business_unit`
    FROM `internal_mobile_app`
)
UNION ALL (
    SELECT
        `p`.`id`, 'ssp_mobile_app' AS `model`,
        `p`.`page_id` AS `page_id`, `sa`.`bundle_id` AS `caption`, `sa`.`bundle_id` AS `domain`,
        0 as `is_protected`, 0 as `is_readonly`,
        'mobile' AS `product_type`,
        `u`.`id` AS `owner_id`, `u`.`login` AS `login`, `s`.`client_id` AS `client_id`, `u`.`business_unit` AS `business_unit`
    FROM `ssp_mobile_app` AS `p`
        JOIN `ssp_link_mobile_app` AS `slmp` ON `slmp`.`mobile_app_id` = `p`.`id`
        JOIN `ssp_application` AS `sa` ON `sa`.`id` = `slmp`.`application_id`
        JOIN `ssp_seller` AS `s` ON `s`.`id` = `slmp`.`seller_id`
        JOIN `users` AS `u` ON `u`.`client_id` = `s`.`client_id`
)
UNION ALL (
    SELECT
        `p`.`id`, 'ssp_context_rtb' AS `model`,
        `p`.`page_id` AS `page_id`, `ss`.`domain` AS `caption`, `ss`.`domain` AS `domain`,
        0 as `is_protected`, 0 as `is_readonly`,
        'context' AS `product_type`,
        `u`.`id` AS `owner_id`, `u`.`login` AS `login`, `u`.`client_id` AS `client_id`, 0 AS `business_unit`
    FROM `ssp_context_rtb` AS `p`
        JOIN `ssp_link_context_rtb` AS `slcr` ON `slcr`.`context_rtb_id` = `p`.`id`
        JOIN `ssp_site` AS `ss` ON `ss`.`id` = `slcr`.`site_id`
        JOIN `ssp_seller` AS `s` ON `s`.`id` = `slcr`.`seller_id`
        JOIN `users` AS `u` ON `u`.`client_id` = `s`.`client_id`
);
