#!/usr/bin/perl

=encoding UTF-8
=cut

use strict;
use warnings;
use utf8;

use lib::abs qw(
  ../../lib
  );
use qbit;
use Application;

=head1 Скрипт изменяет таблицы

    Скрипт добавляет новые колонки show_video в таблицы
        - mobile_app_rtb
        - internal_mobile_app_rtb
=cut

my $script = lib::abs::path('../../bin/pt-online-schema-change.pl');

system($script, "--table=mobile_app_rtb",
    "--alter=ADD COLUMN `show_video` BOOLEAN NOT NULL DEFAULT '0' AFTER `horizontal_align`");

system($script,
    "--table=internal_mobile_app_rtb",
    "--alter=ADD COLUMN `show_video` BOOLEAN NOT NULL DEFAULT '0' AFTER `horizontal_align`"
);

my $app = Application->new();
$app->pre_run();

$app->set_cur_user({id => 0});

$app->partner_db->_do('ANALYZE TABLE `partner`.`mobile_app_rtb`;');

$app->partner_db->_do('ANALYZE TABLE `partner`.`internal_mobile_app_rtb`;');

print "#END\n";
