#!/usr/bin/perl

=encoding UTF-8
=cut

use strict;
use warnings;
use utf8;

use lib::abs;
use Partner::DB;

=head1 Скрипт изменяет таблицы

    Скрипт удаляет foreign key context_on_site_dsps_ibfk_2, context_on_site_dsps_ibfk_1
    и добавляет новый ключ fk_context_on_site_dsps__campaign_id_block_id___context_on_site_
    в таблицу context_on_site_rtb

    Для переключения на прод, необходимо изменить значение переменной $SERVER на prod

=cut

my $SERVER = 'dev';

my $script = lib::abs::path('../bin/pt-online-schema-change.pl');

system($script, "--server=$SERVER", "--table=context_on_site_dsps",
"--alter=DROP FOREIGN KEY `_context_on_site_dsps_ibfk_2`, DROP FOREIGN KEY `_context_on_site_dsps_ibfk_1`, ADD CONSTRAINT `fk_context_on_site_dsps__campaign_id_block_id___context_on_site_` FOREIGN KEY (`campaign_id` , `block_id`) REFERENCES `partner`.`context_on_site_rtb` (`campaign_id` , `id`) ON DELETE NO ACTION ON UPDATE NO ACTION"
);

my $se = get_db_partner2(server => $SERVER,);

$se->execute('ANALYZE TABLE `partner`.`context_on_site_dsps`;');

print "#END\n";
