use partner;


/* INFRASTRUCTUREPI-1775 start */
/* INFRASTRUCTUREPI-1775-all_pages start */

CREATE OR REPLACE
SQL SECURITY INVOKER
VIEW `all_pages_view` (
    `id`, `model`,
    `page_id`, `caption`, `domain`, `is_protected`, `is_readonly`,
    `product_type`,
    `owner_id`, `login`, `client_id`, `business_unit`
    ) AS
(
    SELECT
        p.`id`, 'context_on_site_campaign' AS `model`,
        p.`page_id` AS `page_id`, p.`caption` AS `caption`, s.`domain` AS `domain`,
        if(p.multistate & 1024, 1, 0) as `is_protected`, if(p.multistate & 32, 1, 0) as `is_readonly`,
        'context' AS `product_type`,
        u.`id` AS `owner_id`, u.`login` AS `login`, u.`client_id` AS `client_id`, u.`business_unit` AS `business_unit`
    FROM `context_on_site_campaign` p
        JOIN `site` s ON s.`id` = p.`domain_id`
        JOIN `users` u ON u.`id` = p.`owner_id`
)
UNION ALL (
    SELECT
        p.`id`, 'search_on_site_campaign' AS `model`,
        p.`page_id` AS `page_id`, p.`caption` AS `caption`, s.`domain` AS `domain`,
        if(p.multistate & 1024, 1, 0) as `is_protected`, if(p.multistate & 32, 1, 0) as `is_readonly`,
        'search' AS `product_type`,
        u.`id` AS `owner_id`, u.`login` AS `login`, u.`client_id` AS `client_id`, u.`business_unit` AS `business_unit`
    FROM `search_on_site_campaign` p
        JOIN `site` s ON s.`id` = p.`domain_id`
        JOIN `users` u ON u.`id` = p.`owner_id`
)
UNION ALL (
    SELECT
        p.`id`, 'mobile_app_settings' AS `model`,
        p.`context_page_id` AS `page_id`, p.`caption` AS `caption`, a.`store_id` AS `domain`,
        if(p.multistate & 256, 1, 0) as `is_protected`, 0 as `is_readonly`,
        'mobile' AS `product_type`,
        u.`id` AS `owner_id`, u.`login` AS `login`, u.`client_id` AS `client_id`, u.`business_unit` AS `business_unit`
    FROM `mobile_app_settings` p
        JOIN `mobile_app` a ON a.`id` = p.`application_id`
        JOIN `users` u ON u.`id` = p.`owner_id`
)
UNION ALL (
    SELECT
        p.`id`, 'video_an_site' AS `model`,
        p.`id` AS `page_id`, p.`caption` AS `caption`, p.`domain` AS `domain`,
        if(p.multistate&32,1,0) as `is_protected`, 0 as `is_readonly`,
        'video' AS `product_type`,
        u.`id` AS `owner_id`, u.`login` AS `login`, u.`client_id` AS `client_id`, u.`business_unit` AS `business_unit`
    FROM `video_an_site` p
        JOIN `users` u ON u.`id` = p.`owner_id`
)
UNION ALL (
    SELECT
        p.`id`, 'internal_context_on_site_campaign' AS `model`,
        p.`id` AS `page_id`, s.`domain` AS `caption`, s.`domain` AS `domain`,
        if(p.multistate&128,1,0) as `is_protected`, if(p.multistate & 32, 1, 0) as `is_readonly`,
        'context' AS `product_type`,
        54519301 AS `owner_id`, 'adinside' AS `login`, 944028 AS `client_id`, 0 AS `business_unit`
    FROM `internal_context_on_site_campaign` p
        JOIN `internal_site` s ON s.`id` = p.`site_id`
)
UNION ALL (
    SELECT
        p.`id`, 'internal_search_on_site_campaign' AS `model`,
        p.`id` AS `page_id`, s.`domain` AS `caption`, s.`domain` AS `domain`,
        if(p.multistate&128,1,0) as `is_protected`, if(p.multistate & 32, 1, 0) as `is_readonly`,
        'search' AS `product_type`,
        54519301 AS `owner_id`, 'adinside' AS `login`, 944028 AS `client_id`, 0 AS `business_unit`
    FROM `internal_search_on_site_campaign` p
        JOIN `internal_site` s ON s.`id` = p.`site_id`
)
UNION ALL (
    SELECT
        `id`, 'internal_mobile_app' AS `model`,
        `id` AS `page_id`, `caption` AS `caption`, `store_id` AS `domain`,
        if(multistate&32,1,0) as `is_protected`, 0 as `is_readonly`,
        'mobile' AS `product_type`,
        54519301 AS `owner_id`, 'adinside' AS `login`, 944028 AS `client_id`, 0 AS `business_unit`
    FROM `internal_mobile_app`
)
UNION ALL (
    SELECT
        `p`.`id`, 'ssp_mobile_app' AS `model`,
        `p`.`page_id` AS `page_id`, `sa`.`bundle_id` AS `caption`, `sa`.`bundle_id` AS `domain`,
        0 as `is_protected`, 0 as `is_readonly`,
        'mobile' AS `product_type`,
        `u`.`id` AS `owner_id`, `u`.`login` AS `login`, `s`.`client_id` AS `client_id`, `u`.`business_unit` AS `business_unit`
    FROM `ssp_mobile_app` AS `p`
        JOIN `ssp_link_mobile_app` AS `slmp` ON `slmp`.`mobile_app_id` = `p`.`id`
        JOIN `ssp_application` AS `sa` ON `sa`.`id` = `slmp`.`application_id`
        JOIN `ssp_seller` AS `s` ON `s`.`id` = `slmp`.`seller_id`
        JOIN `users` AS `u` ON `u`.`client_id` = `s`.`client_id`
)
UNION ALL (
    SELECT
        `p`.`id`, 'ssp_context_rtb' AS `model`,
        `p`.`page_id` AS `page_id`, `ss`.`domain` AS `caption`, `ss`.`domain` AS `domain`,
        0 as `is_protected`, 0 as `is_readonly`,
        'context' AS `product_type`,
        `u`.`id` AS `owner_id`, `u`.`login` AS `login`, `u`.`client_id` AS `client_id`, 0 AS `business_unit`
    FROM `ssp_context_rtb` AS `p`
        JOIN `ssp_link_context_rtb` AS `slcr` ON `slcr`.`context_rtb_id` = `p`.`id`
        JOIN `ssp_site` AS `ss` ON `ss`.`id` = `slcr`.`site_id`
        JOIN `ssp_seller` AS `s` ON `s`.`id` = `slcr`.`seller_id`
        JOIN `users` AS `u` ON `u`.`client_id` = `s`.`client_id`
)
UNION ALL (
    SELECT
        `p`.`id`, 'ssp_video_app' AS `model`,
        `p`.`page_id` AS `page_id`, `ss`.`bundle_id` AS `caption`, `ss`.`bundle_id` AS `domain`,
        0 as `is_protected`, 0 as `is_readonly`,
        'video' AS `product_type`,
        `u`.`id` AS `owner_id`, `u`.`login` AS `login`, `u`.`client_id` AS `client_id`, 0 AS `business_unit`
    FROM `ssp_video_app` AS `p`
        JOIN `ssp_link_video_app` AS `slcr` ON `slcr`.`video_app_id` = `p`.`id`
        JOIN `ssp_application` AS `ss` ON `ss`.`id` = `slcr`.`application_id`
        JOIN `ssp_seller` AS `s` ON `s`.`id` = `slcr`.`seller_id`
        JOIN `users` AS `u` ON `u`.`client_id` = `s`.`client_id`
);




CREATE TABLE all_pages_new (
    id BIGINT unsigned NOT NULL,
    model VARCHAR(255) NOT NULL DEFAULT '',
    page_id INT unsigned,
    caption VARCHAR(255) NOT NULL DEFAULT '',
    domain VARCHAR(255) NOT NULL,
    product_type VARCHAR(255) NOT NULL DEFAULT '',
    owner_id BIGINT unsigned NOT NULL DEFAULT 0,
    login VARCHAR(40) NOT NULL DEFAULT '',
    client_id BIGINT unsigned NOT NULL DEFAULT 0,
    business_unit BOOLEAN NOT NULL DEFAULT 0,
    PRIMARY KEY(id, model),
    KEY(page_id),
    KEY(owner_id),
    KEY(client_id)
);

INSERT INTO all_pages_new(id, model, page_id, caption, domain, product_type, owner_id, login, client_id, business_unit) SELECT id, model, page_id, caption, domain, product_type, owner_id, login, client_id, business_unit FROM all_pages_view;

DROP VIEW all_pages;

RENAME TABLE all_pages_new TO all_pages;



/* INFRASTRUCTUREPI-1775-all_pages end */
/* INFRASTRUCTUREPI-1775 end */


/* PI-5206 start */
/* PI-5206_internal_god start */

ALTER TABLE `partner`.`internal_context_on_site_direct`
ADD COLUMN `is_custom_bk_data` BOOLEAN NOT NULL DEFAULT '0',
ADD COLUMN `bk_data` MEDIUMTEXT;

ANALYZE TABLE `partner`.`internal_context_on_site_direct`;

/* 2 - Разработчик */
insert into role_rights values (2, 'internal_context_on_site_direct_view_field__bk_data');
insert into role_rights values (2, 'internal_context_on_site_direct_edit_field__bk_data');

/* 4 - Сервисы Яндекса: Администратор */
insert into role_rights values (4, 'internal_context_on_site_direct_view_field__bk_data');
insert into role_rights values (4, 'internal_context_on_site_direct_edit_field__bk_data');

/* PI-5206_internal_god end */
/* PI-5206 end */


/* PI-9552 start */

ALTER TABLE `partner`.`context_on_site_adfox`
ADD COLUMN `callouts` BOOLEAN AFTER `horizontal_align`,
ADD COLUMN `create_date` DATETIME AFTER `callouts`,
ALGORITHM = INPLACE, LOCK = NONE;

ANALYZE TABLE `partner`.`context_on_site_adfox`;

ALTER TABLE `partner`.`context_on_site_rtb`
ADD COLUMN `callouts` BOOLEAN,
ALGORITHM = INPLACE, LOCK = NONE;

ANALYZE TABLE `partner`.`context_on_site_rtb`;

ALTER TABLE `partner`.`internal_mobile_app_rtb`
ADD COLUMN `callouts` BOOLEAN,
ADD COLUMN `create_date` DATETIME AFTER `callouts`,
ALGORITHM = INPLACE, LOCK = NONE;

ANALYZE TABLE `partner`.`internal_mobile_app_rtb`;

ALTER TABLE `partner`.`mobile_app_rtb`
ADD COLUMN `callouts` BOOLEAN,
ALGORITHM = INPLACE, LOCK = NONE;

ANALYZE TABLE `partner`.`mobile_app_rtb`;

ALTER TABLE `partner`.`internal_context_on_site_rtb`
ADD COLUMN `callouts` BOOLEAN,
ALGORITHM = INPLACE, LOCK = NONE;

ANALYZE TABLE `partner`.`internal_context_on_site_rtb`;

UPDATE `partner`.`context_on_site_adfox` SET callouts = 0 WHERE `direct_block` = 'horizontal';
UPDATE `partner`.`context_on_site_adfox` SET callouts = 1 WHERE `direct_block` = 'horizontal' and campaign_id not in (
    select page_id from context_on_site_campaign where owner_id in (
        265217053,    #vk-rsya
        363072506,    #vk-rsya-apps
        301147605,    #wwwodnoklassniki-2015
        301137679,    #m-ru-2015
        356502796,    #adv.vertis
        198392540,    #avitortb2013
        235409923,    #rbcpartner
        157209733,    #shmelkin-roman
        269811143     #savvina-ale
    ) and page_id is not null
);
UPDATE `partner`.`context_on_site_rtb` SET callouts = 0 WHERE `direct_block` = 'horizontal';
UPDATE `partner`.`context_on_site_rtb` SET callouts = 1 WHERE `direct_block` = 'horizontal' and campaign_id not in (
    select page_id from context_on_site_campaign where owner_id in (
        265217053,    #vk-rsya
        363072506,    #vk-rsya-apps
        301147605,    #wwwodnoklassniki-2015
        301137679,    #m-ru-2015
        356502796,    #adv.vertis
        198392540,    #avitortb2013
        235409923,    #rbcpartner
        157209733,    #shmelkin-roman
        269811143     #savvina-ale
    ) and page_id is not null
);
UPDATE `partner`.`mobile_app_rtb` SET callouts = 0 WHERE `direct_block` = 'horizontal';
UPDATE `partner`.`mobile_app_rtb` SET callouts = 1 WHERE `direct_block` = 'horizontal' and context_page_id not in (
    select context_page_id from mobile_app_settings where owner_id in (
        265217053,    #vk-rsya
        363072506,    #vk-rsya-apps
        301147605,    #wwwodnoklassniki-2015
        301137679,    #m-ru-2015
        356502796,    #adv.vertis
        198392540,    #avitortb2013
        235409923,    #rbcpartner
        157209733,    #shmelkin-roman
        269811143     #savvina-ale
    ) and context_page_id is not null
);
UPDATE `partner`.`internal_context_on_site_rtb` SET callouts = 0 WHERE `direct_block` = 'horizontal';
UPDATE `partner`.`internal_mobile_app_rtb` SET callouts = 0 WHERE `direct_block` = 'horizontal';

/* PI-9552 end */


/* PI-9570 start */
/* PI-9507 start */

REPLACE `partner`.`role_rights` VALUES
    (3, 'users_view_field__contract_id'),
    (4, 'users_view_field__contract_id'),
    (8, 'users_view_field__contract_id'),
    (15, 'users_view_field__contract_id'),
    (17, 'users_view_field__contract_id'),
    (19, 'users_view_field__contract_id'),
    (38, 'users_view_field__contract_id');

/* PI-9507 end */
/* PI-9570 end */


/* PI-9544 start */
REPLACE `partner`.`role_rights` VALUES
    (2, 'internal_mobile_app_rtb_edit_field__show_video'),
    (2, 'internal_mobile_app_rtb_view_field__show_video'),
    (2, 'mobile_app_rtb_edit_field__show_video'),
    (2, 'mobile_app_rtb_view_field__show_video'),
    (4, 'internal_mobile_app_rtb_edit_field__show_video'),
    (4, 'internal_mobile_app_rtb_view_field__show_video'),
    (15, 'mobile_app_rtb_edit_field__show_video'),
    (15, 'mobile_app_rtb_view_field__show_video'),
    (17, 'mobile_app_rtb_view_field__show_video'),
    (19, 'internal_mobile_app_rtb_view_field__show_video'),
    (38, 'mobile_app_rtb_edit_field__show_video'),
    (38, 'mobile_app_rtb_view_field__show_video');
/* PI-9544 end */

/* PI-9821_standart_reports.sql start */
INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('advnet_report_by_login', 'advnet_on_site', 'Отчет по рекламе на сайтах для логина ${login} за 30 дней', 'Report on website advertisements for ${login} login for past 30 days', '{"tableViewModelData":{"sortBy":"partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_partner_wo_nds","adfox_partner_wo_nds","premium_partner_wo_nds","market_api_context_partner_wo_nds","market_api_search_partner_wo_nds","direct_context_partner_wo_nds","direct_search_partner_wo_nds","stripe_partner_wo_nds","partner_wo_nds"],"levels":[{"filter":["AND",[["login","MATCH",["user","MATCH",["login","IN",["${login}"]]]]]],"id":"advnet_on_site"}],"period":"30days","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["an_campaign_caption","page_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_partner_wo_nds","adfox_partner_wo_nds","premium_partner_wo_nds","market_api_context_partner_wo_nds","market_api_search_partner_wo_nds","direct_context_partner_wo_nds","direct_search_partner_wo_nds","stripe_partner_wo_nds","partner_wo_nds"],"levels":[{"filter":["AND",[["login","MATCH",["user","MATCH",["login","IN",["${login}"]]]]]],"id":"advnet_on_site"}],"period":"30days","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('advnet_report', 'advnet_on_site', 'Отчет по рекламе на сайтах за ${period||30days}', 'Report on website advertisements for ${period||30days}', '{"tableViewModelData":{"sortBy":"partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["stripe_partner_wo_nds","rtb_partner_wo_nds","premium_partner_wo_nds","direct_context_partner_wo_nds","direct_search_partner_wo_nds","market_api_context_partner_wo_nds","market_api_search_partner_wo_nds","adfox_partner_wo_nds","adblock_partner_wo_nds","partner_wo_nds","mcb_context_cpmh_mcb_context_partner_wo_nds","mcb_search_cpmh_mcb_search_partner_wo_nds"],"dimension_fields":["page_id","an_campaign_caption"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"advnet_on_site","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["stripe_partner_wo_nds","rtb_partner_wo_nds","premium_partner_wo_nds","market_api_context_partner_wo_nds","market_api_search_partner_wo_nds","direct_context_partner_wo_nds","direct_search_partner_wo_nds","adfox_partner_wo_nds","adblock_partner_wo_nds","partner_wo_nds","mcb_context_cpmh_mcb_context_partner_wo_nds","mcb_search_cpmh_mcb_search_partner_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"advnet_on_site","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('all_payments', 'payment', 'Доход по всем видам рекламы за ${period||90days}', 'Revenue from all types of advertisements for ${period||90days}', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||90days}","fields":["adfox_partner_wo_nds","direct_context_partner_wo_nds","market_api_context_partner_wo_nds","market_api_search_partner_wo_nds","mobile_rtb_partner_wo_nds","partner_wo_nds","premium_partner_wo_nds","rtb_partner_wo_nds","stripe_partner_wo_nds","video_an_site_sum_partner_wo_nds"],"dimension_fields":[],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"payment","filter":null}]}],"chartLevel":[{"period":"${period||90days}","fields":["rtb_partner_wo_nds","mobile_rtb_partner_wo_nds","adfox_partner_wo_nds","premium_partner_wo_nds","direct_context_partner_wo_nds","stripe_partner_wo_nds","partner_wo_nds","video_an_site_sum_partner_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"payment","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_adblock_detailed_report_by_block_id', 'advnet_context_on_site_adblock', 'Отчет по блоку Adblock ${block_id} «${name}» за ${period||30days}', 'Adblock block ${block_id} "${name}" report for ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["adblock_block_shows","adblock_block_hits","adblock_partner_wo_nds","adblock_block_visibility","adblock_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_adblock"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["adblock_block_shows","adblock_block_shows_own_adv","adblock_block_hits","adblock_block_hits_own_adv","adblock_block_hits_unsold","adblock_partner_wo_nds","adblock_block_winrate","adblock_block_visibility","adblock_block_all_hits","adblock_block_cover_ratio","adblock_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_adblock"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_adblock_detailed_report', 'advnet_context_on_site_adblock', 'Отчет по блокам Adblock за ${period||30days} (с детализацией по дням)', 'Adblock blocks report for ${period||30days} (with daily details)', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||30days}","fields":["adblock_block_shows","adblock_block_hits","adblock_partner_wo_nds","adblock_block_cpm_partner_wo_nds"],"dimension_fields":["date|day","context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_adblock","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["adblock_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_adblock","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_adblock_report_by_page_id', 'advnet_context_on_site_adblock', 'Отчет по блокам Adblock для площадки ${page_id} «${name}» за ${period||30days}', 'Report for Adblock blocks at ${page_id} "${name}" ad platform for ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["adblock_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_adblock"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["adblock_block_shows","adblock_block_hits","adblock_partner_wo_nds","adblock_block_visibility","adblock_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_adblock"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"adblock_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_adblock_report', 'advnet_context_on_site_adblock', 'Отчет по блокам Adblock за ${period||30days} (без детализации по дням)', 'Adblock report for ${period||30days} (without daily details)', '{"tableViewModelData":{"sortBy":"adblock_partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["adblock_block_shows","adblock_block_hits","adblock_partner_wo_nds","adblock_block_cpm_partner_wo_nds"],"dimension_fields":["context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["page_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_adblock","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["adblock_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["page_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_adblock","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_adfox_detailed_report_by_block_id', 'advnet_context_on_site_adfox', 'Отчет по блоку ADFOX ${block_id} «${name}» за ${period||30days}', 'Report on the ADFOX ${block_id} "${name}" block for ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["adfox_block_shows","adfox_block_hits","adfox_partner_wo_nds","adfox_block_visibility","adfox_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_adfox"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["adfox_block_shows","adfox_block_shows_own_adv","adfox_block_hits","adfox_block_hits_own_adv","adfox_block_hits_unsold","adfox_partner_wo_nds","adfox_block_winrate","adfox_block_visibility","adfox_block_all_hits","adfox_block_cover_ratio","adfox_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_adfox"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_adfox_detailed_report', 'advnet_context_on_site_adfox', 'Отчет по ADFOX за ${period||30days} (с детализацией по дням)', 'ADFOX report for ${period||30days} (with daily details)', '{"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["adfox_block_shows","adfox_block_hits","adfox_partner_wo_nds","adfox_block_cpm_partner_wo_nds"],"dimension_fields":["date|day","context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_adfox","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["adfox_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_adfox","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_adfox_report_by_page_id', 'advnet_context_on_site_adfox', 'Отчет по блокам ADFOX для площадки ${page_id} «${name}» за ${period||30days}', 'Report on ADFOX blocks for ${page_id} "${name}" ad platform for ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["adfox_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_adfox"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["adfox_block_shows","adfox_block_hits","adfox_partner_wo_nds","adfox_block_visibility","adfox_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_adfox"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_adfox_report', 'advnet_context_on_site_adfox', 'Отчет по ADFOX за ${period||30days} (без детализации по дням)', 'ADFOX report for ${period||30days} (without daily details)', '{"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["adfox_block_shows","adfox_block_hits","adfox_partner_wo_nds","adfox_block_cpm_partner_wo_nds"],"dimension_fields":["context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_adfox","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["adfox_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_adfox","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_direct_detailed_report_by_block_id', 'advnet_context_on_site_direct', 'Отчет по блоку Директа ${block_id} «${name}» за ${period||30days}', 'Report on the Direct ${block_id} "${name}" block for ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_shows","direct_context_clicks","direct_context_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["direct_context_shows","direct_context_clicks","direct_context_partner_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_partner_wo_nds","direct_context_cpc_direct_context_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_direct_detailed_report', 'advnet_context_on_site_direct', 'Отчет по Директу за ${period||30days} (с детализацией по дням)', 'Direct report for ${period||30days} (with daily details)', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||30days}","fields":["direct_context_shows","direct_context_clicks","direct_context_partner_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_partner_wo_nds","direct_context_cpc_direct_context_partner_wo_nds"],"dimension_fields":["date|day","context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_direct","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["direct_context_partner_wo_nds"],"dimension_fields":["date|day","context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_direct","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_direct_report_by_page_id', 'advnet_context_on_site_direct', 'Отчет по Директу для площадки ${page_id} «${name}» за ${period||30days}', 'Report on Direct for ${page_id} "${name}" ad platform for ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["direct_context_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["direct_context_shows","direct_context_clicks","direct_context_partner_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_partner_wo_nds","direct_context_cpc_direct_context_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"direct_context_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_direct_report', 'advnet_context_on_site_direct', 'Отчет по Директу за ${period||30days} (без детализации по дням)', 'Direct report for ${period||30days} (without daily details)', '{"tableViewModelData":{"sortBy":"direct_context_partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["direct_context_shows","direct_context_clicks","direct_context_partner_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_partner_wo_nds","direct_context_cpc_direct_context_partner_wo_nds"],"dimension_fields":["context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_direct","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["direct_context_partner_wo_nds"],"dimension_fields":["date|day","context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_direct","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_direct_tags_report_by_page_id', 'advnet_context_on_site_direct', 'Отчет по срезам Директа для площадки за ${page_id} «${name}» ${period||30days}', 'Direct cross-section report for ${page_id} "${name}" ad platform for ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","tag_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","tag_id","tag_caption"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_shows","direct_context_clicks","direct_context_partner_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_partner_wo_nds","direct_context_cpc_direct_context_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"direct_search_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_direct_tags_report', 'advnet_context_on_site_direct', 'Отчет по срезам Директа за ${period||30days} (без детализации по дням)', 'Direct cross-section report for ${period||30days} (without daily details)', '{"tableViewModelData":{"sortBy":"direct_context_partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day","tag_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["tag_id","tag_caption"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_context_shows","direct_context_clicks","direct_context_partner_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_partner_wo_nds","direct_context_cpc_direct_context_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_income', 'advnet_context_on_site', 'Доход по рекламе на тематических площадках за ${period||10days}', 'Revenue from advertisement on theme-based ad platforms for ${period||10days}', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":null,"chartLevel":[{"period":"${period||10days}","fields":["stripe_partner_wo_nds","rtb_partner_wo_nds","direct_context_partner_wo_nds","market_api_context_partner_wo_nds","adfox_partner_wo_nds","partner_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site","filter":null}]}],"isLevelsDifferent":false}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_market_api_detailed_report', 'advnet_context_on_site_market_api', 'Отчет по API Маркета за ${period||30days} (с детализацией по дням)', 'API Market report for ${period||30days} (with daily details)', '{"tableViewModelData":{"sortBy":"date","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["market_api_context_partner_wo_nds","market_api_context_clicks","market_api_context_cpc_market_api_context_all_wo_nds","market_api_context_cpm_market_api_context_all_wo_nds","market_api_context_ctr","market_api_context_shows"],"dimension_fields":["context_campaign_caption","currency_id","date|day"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_market_api","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["market_api_context_partner_wo_nds"],"dimension_fields":["context_campaign_caption","currency_id","date|day"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_market_api","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_market_api_report_by_page_id', 'advnet_context_on_site_market_api', 'Отчет по API Маркета для площадки ${page_id} «${name}» за ${period||30days}', 'Report on API Market for ${page_id} "${name}" ad platform for ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["market_api_context_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_market_api"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["market_api_context_clicks","market_api_context_shows","market_api_context_ctr","market_api_context_partner_wo_nds","market_api_context_cpm_market_api_context_partner_wo_nds","market_api_context_cpc_market_api_context_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_market_api"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"market_api_context_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_market_api_report', 'advnet_context_on_site_market_api', 'Отчет по API Маркета за ${period||30days} (без детализации по дням)', 'API Market report for ${period||30days} (without daily details)', '{"tableViewModelData":{"sortBy":"market_api_context_all_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["market_api_context_partner_wo_nds","market_api_context_clicks","market_api_context_cpc_market_api_context_all_wo_nds","market_api_context_cpm_market_api_context_all_wo_nds","market_api_context_ctr","market_api_context_shows"],"dimension_fields":["currency_id","context_campaign_caption"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_market_api","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["market_api_context_partner_wo_nds"],"dimension_fields":["date|day","context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_market_api","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_report_by_page_id', 'advnet_context_on_site', 'Отчет по тематической площадке ${page_id} «${name}» за ${period||30days} (с детализацией по дням)', 'Report on ${page_id} "${name}" theme-based ad platform for ${period||30days} (with daily details)', '{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["adfox_partner_wo_nds","direct_context_partner_wo_nds","market_api_context_partner_wo_nds","partner_wo_nds","rtb_partner_wo_nds","stripe_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["market_api_context_partner_wo_nds","stripe_partner_wo_nds","rtb_partner_wo_nds","direct_context_partner_wo_nds","adfox_partner_wo_nds","partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_report', 'advnet_context_on_site', 'Отчет по рекламе на тематических площадках за ${period||30days}', 'Report on theme-based ad platform advertisement for ${period||30days}', '{"tableViewModelData":{"sortBy":"partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["stripe_partner_wo_nds","rtb_partner_wo_nds","direct_context_partner_wo_nds","market_api_context_partner_wo_nds","adfox_partner_wo_nds","partner_wo_nds"],"dimension_fields":[],"dimension_filter":null,"entity_fields":["page_id","caption"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["stripe_partner_wo_nds","rtb_partner_wo_nds","direct_context_partner_wo_nds","market_api_context_partner_wo_nds","adfox_partner_wo_nds","partner_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_rtb_detailed_report_by_block_id', 'advnet_context_on_site_rtb', 'Отчет по RTB-блоку ${block_id} «${name}» за ${period||30days}', 'RTB block ${block_id} "${name}" report for ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_block_shows","rtb_block_hits","rtb_partner_wo_nds","rtb_block_visibility","rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["rtb_block_shows","rtb_block_shows_own_adv","rtb_block_hits","rtb_block_hits_own_adv","rtb_block_hits_unsold","rtb_partner_wo_nds","rtb_block_winrate","rtb_block_visibility","rtb_block_all_hits","rtb_block_cover_ratio","rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_rtb_detailed_report', 'advnet_context_on_site_rtb', 'Отчет по RTB за ${period||30days} (с детализацией по дням)', 'RTB report for ${period||30days} (with daily details)', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||30days}","fields":["rtb_block_shows","rtb_block_hits","rtb_partner_wo_nds","rtb_block_cpm_partner_wo_nds"],"dimension_fields":["date|day","context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_rtb","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["rtb_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_rtb","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_rtb_report_by_page_id', 'advnet_context_on_site_rtb', 'Отчет по RTB-блокам для площадки ${page_id} «${name}» за ${period||30days}', 'Report for RTB blocks at ${page_id} "${name}" ad platform for ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["rtb_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["rtb_block_shows","rtb_block_hits","rtb_partner_wo_nds","rtb_block_visibility","rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_rtb_report', 'advnet_context_on_site_rtb', 'Отчет по RTB за ${period||30days} (без детализации по дням)', 'RTB report for ${period||30days} (without daily details)', '{"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["rtb_block_shows","rtb_block_hits","rtb_partner_wo_nds","rtb_block_cpm_partner_wo_nds"],"dimension_fields":["context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_rtb","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["rtb_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_rtb","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_rtb_tags_report_by_page_id', 'advnet_context_on_site_rtb', 'Отчет по срезам RTB для площадки за ${page_id} «${name}» ${period||30days}', 'RTB cross-section report for ${page_id} "${name}" ad platform for ${period||30days}', '{"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_rtb"}],"order_by":[{"dir":"asc","field":"rtb_partner_wo_nds"}],"period":"${period||30days}","top_keys":15,"total":0,"vat":-1}],"events":{"use_upper_levels":0},"tableLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_block_shows","rtb_block_direct_shows","rtb_block_direct_clicks","rtb_partner_wo_nds","rtb_block_direct_ctr","rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_rtb_tags_report', 'advnet_context_on_site_rtb', 'Отчет по срезам RTB за ${period||30days} (без детализации по дням)', 'RTB cross-section report for ${period||30days} (without daily details)', '{"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_rtb"}],"order_by":[{"dir":"asc","field":"rtb_partner_wo_nds"}],"period":"${period||30days}","top_keys":15,"total":0,"vat":-1}],"events":{"use_upper_levels":0},"tableLevel":[{"dimension_fields":["tag_id","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["rtb_block_hits","rtb_block_shows","rtb_block_direct_shows","rtb_block_direct_clicks","rtb_partner_wo_nds","rtb_block_direct_ctr","rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_stripe_detailed_report_by_block_id', 'advnet_context_on_site_stripe', 'Отчет по Промоблоку ${block_id} «${name}» за ${period||30days}', 'Stripe ${block_id} "${name}" report for ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_stripe"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","title"],"fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_partner_wo_nds","stripe_ctr","stripe_cpm_partner_wo_nds","stripe_cpc_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_stripe"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_stripe_detailed_report', 'advnet_context_on_site_stripe', 'Отчет по Промоблоку за ${period||30days} (с детализацией по дням)', 'Stripe report for ${period||30days} (with daily details)', '{"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_partner_wo_nds","stripe_ctr","stripe_cpm_partner_wo_nds","stripe_cpc_partner_wo_nds"],"dimension_fields":["date|day","context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_stripe","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["stripe_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_stripe","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_stripe_report_by_page_id', 'advnet_context_on_site_stripe', 'Отчет по Промоблоку для площадки ${page_id} «${name}» за ${period||30days}', 'Stripes report for ${page_id} "${name}" ad platform for ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["stripe_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_stripe"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","title"],"fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_partner_wo_nds","stripe_ctr","stripe_cpm_partner_wo_nds","stripe_cpc_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_stripe"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_stripe_report', 'advnet_context_on_site_stripe', 'Отчет по Промоблоку за ${period||30days} (без детализации по дням)', 'Stripe report for ${period||30days} (without daily details)', '{"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_partner_wo_nds","stripe_ctr","stripe_cpm_partner_wo_nds","stripe_cpc_partner_wo_nds"],"dimension_fields":["context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_stripe","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["stripe_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_stripe","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('dsp_detailed_report_by_dsp_id', 'dsp', 'Отчет для DSP ID ${dsp_id} «${name}»', 'Report for DSP ID ${dsp_id} "${name}"', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||thismonth}","fields":["dsp_bids","dsp_shows","all_hits","dsp_charging_wo_nds","dsp_cpm_charging_wo_nds","average_rate_all_real_price_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["id","short_caption"],"total":0,"vat":-1,"levels":[{"id":"dsp","filter":["AND",[["id","IN",["${dsp_id}"]]]]}]}],"chartLevel":[{"period":"${period||thismonth}","fields":["dsp_charging_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["id","short_caption"],"total":0,"vat":-1,"levels":[{"id":"dsp","filter":["AND",[["id","IN",["${dsp_id}"]]]]}]}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('dsp_detailed_report', 'dsp', 'Отчет по DSP за ${period||thismonth} (с детализацией по дням)', 'DSP report for ${period||thismonth} (with daily details)', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||thismonth}","fields":["dsp_bids","dsp_shows","all_hits","dsp_charging_wo_nds","dsp_cpm_charging_wo_nds","average_rate_all_real_price_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["id","short_caption"],"total":0,"vat":-1,"levels":[{"id":"dsp","filter":null}]}],"chartLevel":[{"period":"${period||thismonth}","fields":["dsp_charging_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["id","short_caption"],"total":0,"vat":-1,"levels":[{"id":"dsp","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('dsp_detailed_report_last_month', 'dsp', 'Отчет по DSP за ${period||lastmonth} (с детализацией по дням)', 'DSP report for ${period||lastmonth} (with daily details)', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||lastmonth}","fields":["dsp_bids","dsp_shows","all_hits","dsp_charging_wo_nds","dsp_cpm_charging_wo_nds","average_rate_all_real_price_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["id","short_caption"],"total":0,"vat":-1,"levels":[{"id":"dsp","filter":null}]}],"chartLevel":[{"period":"${period||lastmonth}","fields":["dsp_charging_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["id","short_caption"],"total":0,"vat":-1,"levels":[{"id":"dsp","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('dsp_report_by_caption', 'dsp', 'Отчет по DSP ${caption} за ${period||30days}', 'DSP ${caption} report for ${period||30days}', '{"chartLevel":[{"period":"${period||30days}","fields":["dsp_bids","dsp_shows","dsp_charging_w_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"dsp","filter":["AND",[["short_caption","LIKE","${caption}"]]]}]}],"tableLevel":null,"isLevelsDifferent":false}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('dsp_report', 'dsp', 'Начислено DSP за ${period||90days} (без детализации по дням)', 'DSP charged for ${period||90days} (without daily details)', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||90days}","fields":["dsp_bids","dsp_shows","all_hits","dsp_charging_wo_nds","dsp_cpm_charging_wo_nds","average_rate_all_real_price_wo_nds"],"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["id","short_caption"],"total":0,"vat":-1,"levels":[{"id":"dsp","filter":null}]}],"chartLevel":[{"period":"${period||90days}","fields":["dsp_charging_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["short_caption"],"total":0,"vat":-1,"levels":[{"id":"dsp","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_advnet_report_by_domain', 'internal_advnet_on_site', 'Отчет по домену ${domain} за ${period||30days}', '${domain} domain report for ${period||30days}', '{"chartLevel":[{"period":"${period||30days}","fields":["stripe_all_w_nds","rtb_all_w_nds","premium_all_w_nds","direct_context_all_w_nds","direct_search_all_w_nds","all_w_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_on_site","filter":["AND",[["domain","LIKE","${domain}"]]]}]}],"tableLevel":null,"isLevelsDifferent":false}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_advnet_report', 'internal_advnet_on_site', 'Отчет по рекламе на сайтах', 'Report on website advertisements', '{"chartLevel":[{"period":"${period||30days}","fields":["stripe_all_wo_nds","rtb_all_wo_nds","premium_all_wo_nds","direct_context_all_wo_nds","direct_search_all_wo_nds","all_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_on_site","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["stripe_all_wo_nds","rtb_all_wo_nds","premium_all_wo_nds","direct_context_all_wo_nds","direct_search_all_wo_nds","all_wo_nds"],"dimension_fields":["date|day","page_id"],"dimension_filter":null,"entity_fields":["domain"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_on_site","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_direct_detailed_report_by_block_id', 'internal_advnet_context_on_site_direct', 'Отчет по блоку Директа ${block_id} «${name}» за ${period||30days}', 'Report on the Direct ${block_id} "${name}" block for ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_shows","direct_context_clicks","direct_context_all_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"internal_advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["direct_context_shows","direct_context_clicks","direct_context_all_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_all_wo_nds","direct_context_cpc_direct_context_all_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"internal_advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_direct_detailed_report', 'internal_advnet_context_on_site_direct', 'Отчет по Директу за ${period||30days} (с детализацией по дням)', 'Direct report for ${period||30days} (with daily details)', '{"chartLevel":[{"period":"${period||30days}","fields":["direct_context_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_direct","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["direct_context_shows","direct_context_clicks","direct_context_all_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_all_wo_nds","direct_context_cpc_direct_context_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_direct","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_direct_report_by_page_id', 'internal_advnet_context_on_site_direct', 'Отчет по блокам Директа для площадки ${page_id} «${name}» за ${period||30days}', 'Report on Direct for ${page_id} "${name}" ad platform for ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","public_id"],"fields":["direct_context_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["direct_context_shows","direct_context_clicks","direct_context_all_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_all_wo_nds","direct_context_cpc_direct_context_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_direct_report', 'internal_advnet_context_on_site_direct', 'Отчет по Директу за ${period||30days} (без детализации по дням)', 'Direct report for ${period||30days} (without daily details)', '{"chartLevel":[{"period":"${period||30days}","fields":["direct_context_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_direct","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["direct_context_shows","direct_context_clicks","direct_context_all_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_all_wo_nds","direct_context_cpc_direct_context_all_wo_nds"],"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_direct","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_direct_tags_report_by_page_id', 'internal_advnet_context_on_site_direct', 'Отчет по срезам Директа для площадки ${page_id} «${name}» за ${period||30days}', 'Direct cross-section report for ${page_id} "${name}" ad platform for ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","tag_id","tag_caption","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_shows","direct_context_clicks","direct_context_all_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_all_wo_nds","direct_context_cpc_direct_context_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"direct_search_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_direct_tags_report', 'internal_advnet_context_on_site_direct', 'Отчет по срезам Директа за ${period||30days} (без детализации по дням)', 'Direct cross-section report for ${period||30days} (without daily details)', '{"tableViewModelData":{"sortBy":"direct_context_partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["tag_id","tag_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_context_shows","direct_context_clicks","direct_context_all_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_all_wo_nds","direct_context_cpc_direct_context_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_income', 'internal_advnet_context_on_site', 'Доход по рекламе на тематических площадках за ${period||10days}', 'Revenue from advertisement on theme-based ad platforms for ${period||10days}', '{"chartLevel":[{"period":"${period||10days}","fields":["stripe_all_wo_nds","rtb_all_wo_nds","direct_context_all_wo_nds","all_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site","filter":null}]}],"tableLevel":null,"isLevelsDifferent":false}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_report_by_page_id', 'internal_advnet_context_on_site', 'Отчет по тематической площадке ${page_id} «${name}» за ${period||30days} (с детализацией по дням)', 'Report on ${page_id} "${name}" theme-based ad platform for ${period||30days} (with daily details)', '{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["id"],"fields":["stripe_all_wo_nds","rtb_all_wo_nds","direct_context_all_wo_nds","all_wo_nds"],"levels":[{"filter":["AND",[["id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_report', 'internal_advnet_context_on_site', 'Отчет по рекламе на тематических площадках за ${period||30days}', 'Report on theme-based ad platform advertisement for ${period||30days}', '{"chartLevel":[{"period":"${period||30days}","fields":["stripe_all_wo_nds","rtb_all_wo_nds","direct_context_all_wo_nds","all_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["stripe_all_wo_nds","rtb_all_wo_nds","direct_context_all_wo_nds","all_wo_nds"],"dimension_fields":[],"dimension_filter":null,"entity_fields":["id","domain"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_rtb_detailed_report_by_block_id', 'internal_advnet_context_on_site_rtb', 'Отчет по RTB-блоку ${block_id} «${name}» за ${period||30days}', 'RTB block ${block_id} "${name}" report for ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_block_shows","rtb_block_hits","rtb_all_wo_nds","rtb_block_visibility","rtb_block_cpm_all_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"internal_advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["rtb_block_shows","rtb_block_shows_own_adv","rtb_block_hits","rtb_block_hits_own_adv","rtb_block_hits_unsold","rtb_all_wo_nds","rtb_block_winrate","rtb_block_visibility","rtb_block_all_hits","rtb_block_cover_ratio"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"internal_advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_rtb_detailed_report', 'internal_advnet_context_on_site_rtb', 'Отчет по RTB за ${period||30days} (с детализацией по дням)', 'RTB report for ${period||30days} (with daily details)', '{"chartLevel":[{"period":"${period||30days}","fields":["rtb_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_rtb","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["rtb_block_shows","rtb_block_hits","rtb_all_wo_nds","rtb_block_cpm_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_rtb","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_rtb_report_by_page_id', 'internal_advnet_context_on_site_rtb', 'Отчет по RTB-блокам для площадки ${page_id} «${name}» за ${period||30days}', 'Report for RTB blocks at ${page_id} "${name}" ad platform for ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["rtb_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["rtb_block_shows","rtb_block_hits","rtb_all_wo_nds","rtb_block_visibility","rtb_block_cpm_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_rtb_report', 'internal_advnet_context_on_site_rtb', 'Отчет по RTB за ${period||30days} (без детализации по дням)', 'RTB report for ${period||30days} (without daily details)', '{"chartLevel":[{"period":"${period||30days}","fields":["rtb_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_rtb","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["rtb_block_shows","rtb_block_hits","rtb_all_wo_nds","rtb_block_cpm_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_rtb","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_rtb_tags_report_by_page_id', 'internal_advnet_context_on_site_rtb', 'Отчет по срезам RTB для площадки ${page_id} «${name}» за ${period||30days}', 'RTB cross-section report for ${page_id} "${name}" ad platform for ${period||30days}', '{"tableViewModelData":{"sortBy":"rtb_search_partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_rtb"}],"order_by":[{"dir":"asc","field":"rtb_all_wo_nds"}],"period":"${period||30days}","top_keys":15,"total":0,"vat":-1}],"events":{"use_upper_levels":0},"tableLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_block_shows","rtb_block_direct_shows","rtb_block_direct_clicks","rtb_all_wo_nds","rtb_block_direct_ctr","rtb_block_cpm_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_rtb_tags_report', 'internal_advnet_context_on_site_rtb', 'Отчет по срезам RTB за ${period||30days} (без детализации по дням)', 'RTB cross-section report for ${period||30days} (without daily details)', '{"tableViewModelData":{"sortBy":"rtb_context_partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_context_on_site_rtb"}],"order_by":[{"dir":"asc","field":"rtb_all_wo_nds"}],"period":"${period||30days}","top_keys":15,"total":0,"vat":-1}],"events":{"use_upper_levels":0},"tableLevel":[{"dimension_fields":["tag_id","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["rtb_block_hits","rtb_block_shows","rtb_block_direct_shows","rtb_block_direct_clicks","rtb_all_wo_nds","rtb_block_direct_ctr","rtb_block_cpm_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_stripe_detailed_report_by_block_id', 'internal_advnet_context_on_site_stripe', 'Отчет по Промоблоку ${block_id} «${name}» за ${period||30days}', 'Stripe ${block_id} "${name}" report for ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_all_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"internal_advnet_context_on_site_stripe"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","title"],"fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_all_wo_nds","stripe_ctr","stripe_cpm_all_wo_nds","stripe_cpc_all_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"internal_advnet_context_on_site_stripe"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_stripe_detailed_report', 'internal_advnet_context_on_site_stripe', 'Отчет по Промоблоку за ${period||30days} (с детализацией по дням)', 'Stripe report for ${period||30days} (with daily details)', '{"chartLevel":[{"period":"${period||30days}","fields":["stripe_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_stripe","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_all_wo_nds","stripe_ctr","stripe_cpm_all_wo_nds","stripe_cpc_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_stripe","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_stripe_report_by_page_id', 'internal_advnet_context_on_site_stripe', 'Отчет по Промоблокам для площадки ${page_id} «${name}» за ${period||30days}', 'Stripes report for ${page_id} "${name}" ad platform for ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["stripe_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_stripe"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","title"],"fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_all_wo_nds","stripe_ctr","stripe_cpm_all_wo_nds","stripe_cpc_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_stripe"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_stripe_report', 'internal_advnet_context_on_site_stripe', 'Отчет по Промоблоку за ${period||30days} (без детализации по дням)', 'Stripe report for ${period||30days} (without daily details)', '{"chartLevel":[{"period":"${period||30days}","fields":["stripe_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_stripe","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_all_wo_nds","stripe_ctr","stripe_cpm_all_wo_nds","stripe_cpc_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_stripe","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_mobile_income', 'internal_mobile_app', 'Доход по рекламе в мобильных приложениях за ${period||10days}', 'Revenue from mobile application advertisements for ${period||10days}', '{"chartLevel":[{"period":"${period||10days}","fields":["mobile_rtb_all_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"internal_mobile_app","filter":null}]}],"tableLevel":null,"isLevelsDifferent":false}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_mobile_report_by_page_id', 'internal_mobile_app', 'Отчет по мобильному приложению ${page_id} «${name}» за ${period||30days} (с детализацией по дням)', '${page_id} "${name}" mobile application report for ${period||30days} (with daily details)', '{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["caption"],"fields":["mobile_rtb_all_wo_nds","all_wo_nds"],"levels":[{"filter":["AND",[["id","IN",["${page_id}"]]]],"id":"internal_mobile_app"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_mobile_report', 'internal_mobile_app', 'Отчет по рекламе в мобильных приложениях за ${period||30days} (без детализации по дням)', 'Report on mobile application advertisements for ${period||30days} (without daily details)', '{"chartLevel":[{"period":"${period||30days}","fields":["mobile_rtb_all_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"internal_mobile_app","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_all_wo_nds","mobile_rtb_block_cpm_all_wo_nds"],"dimension_fields":[],"dimension_filter":null,"entity_fields":["id","caption"],"total":0,"vat":-1,"levels":[{"id":"internal_mobile_app","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_mobile_rtb_detailed_report_by_block_id', 'internal_mobile_app_rtb', 'Отчет по мобильному RTB-блоку ${block_id} «${name}» за ${period||30days}', 'Mobile RTB block ${block_id} "${name}" report for ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_all_wo_nds","mobile_rtb_block_visibility","mobile_rtb_block_cpm_all_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"internal_mobile_app_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["mobile_rtb_block_shows","mobile_rtb_block_shows_own_adv","mobile_rtb_block_hits","mobile_rtb_block_hits_own_adv","mobile_rtb_block_hits_unsold","mobile_rtb_all_wo_nds","mobile_rtb_block_winrate","mobile_rtb_block_visibility","mobile_rtb_block_all_hits","mobile_rtb_block_cover_ratio","mobile_rtb_block_cpm_all_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"internal_mobile_app_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_mobile_rtb_detailed_report', 'internal_mobile_app_rtb', 'Отчет по мобильным RTB-блокам за ${period||30days} (с детализацией по дням)', 'Report on mobile RTB blocks for ${period||30days} (with daily details)', '{"chartLevel":[{"period":"${period||30days}","fields":["mobile_rtb_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["application_id"],"total":0,"vat":-1,"levels":[{"id":"internal_mobile_app_rtb","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_all_wo_nds","mobile_rtb_block_cpm_all_wo_nds"],"dimension_fields":["date|day","internal_mobile_caption","currency_id"],"dimension_filter":null,"entity_fields":["application_id"],"total":0,"vat":-1,"levels":[{"id":"internal_mobile_app_rtb","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_mobile_rtb_report_by_page_id', 'internal_mobile_app_rtb', 'Отчет по мобильным RTB-блокам на площадке ${page_id} «${name}» за ${period||30days}', 'Report on mobile RTB blocks for ${page_id} "${name}" application for ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["mobile_rtb_all_wo_nds"],"levels":[{"filter":["AND",[["application_id","=",["${page_id}"]]]],"id":"internal_mobile_app_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_all_wo_nds","mobile_rtb_block_visibility","mobile_rtb_block_cpm_all_wo_nds"],"levels":[{"filter":["AND",[["application_id","IN",["${page_id}"]]]],"id":"internal_mobile_app_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_mobile_rtb_report', 'internal_mobile_app_rtb', 'Отчет по мобильным RTB-блокам за ${period||30days} (без детализации по дням)', 'Report on mobile RTB blocks for ${period||30days} (without daily details)', '{"chartLevel":[{"period":"${period||30days}","fields":["mobile_rtb_all_wo_nds"],"dimension_fields":["date|day","internal_mobile_caption","currency_id"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"internal_mobile_app_rtb","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_all_wo_nds","mobile_rtb_block_cpm_all_wo_nds"],"dimension_fields":["internal_mobile_caption","currency_id"],"dimension_filter":null,"entity_fields":["application_id"],"total":0,"vat":-1,"levels":[{"id":"internal_mobile_app_rtb","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_search_direct_detailed_report', 'internal_advnet_search_on_site_direct', 'Отчет по поисковому Директу за ${period||30days} (с детализацией по дням)', 'Search Direct report for ${period||30days} (with daily details)', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"fields":["direct_search_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_all_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_all_wo_nds","direct_search_cpc_direct_search_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_search_direct_report_by_page_id', 'internal_advnet_search_on_site_direct', 'Отчет по Директу для площадки ${page_id} «${name}» за ${period||30days}', 'Report on Direct for ${page_id} "${name}" ad platform for ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["direct_search_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["direct_search_shows","direct_search_clicks","direct_search_all_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_all_wo_nds","direct_search_cpc_direct_search_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"direct_search_all_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_search_direct_report', 'internal_advnet_search_on_site_direct', 'Отчет по поисковому Директу за ${period||30days} (без детализации по дням)', 'Search Direct report for ${period||30days} (without daily details)', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"fields":["direct_search_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_all_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_all_wo_nds","direct_search_cpc_direct_search_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_search_direct_tags_report_by_page_id', 'internal_advnet_search_on_site_direct', 'Отчет по срезам поискового Директа для площадки ${page_id} «${name}» за ${period||30days}', 'Search Direct cross-section report for ${page_id} "${name}" ad platform for ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_search_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_all_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_all_wo_nds","direct_search_cpc_direct_search_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"direct_search_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_search_direct_tags_report', 'internal_advnet_search_on_site_direct', 'Отчет по срезам поискового Директа за ${period||30days} (без детализации по дням)', 'Search Direct cross-section report for ${period||30days} (without daily details)', '{"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_search_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_search_shows","direct_search_clicks","direct_search_all_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_all_wo_nds","direct_search_cpc_direct_search_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_search_income', 'internal_advnet_search_on_site', 'Доход по рекламе на поисковых площадках за ${period||10days}', 'Revenue from advertisement on search ad platform for ${period||10days}', '{"chartLevel":[{"period":"${period||10days}","fields":["premium_all_wo_nds","direct_search_all_wo_nds","all_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_search_on_site","filter":null}]}],"tableLevel":null,"isLevelsDifferent":false}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_search_premium_detailed_report_by_block_id', 'internal_advnet_search_on_site_premium', 'Отчет по Спецразмещению ${block_id} «${name}» за ${period||30days}', 'Premium placement ${block_id} "${name}" report for ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["premium_shows","premium_clicks","premium_all_wo_nds"],"levels":[{"filter":["AND",[["id","${block_id}","="]]],"id":"internal_advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["premium_shows","premium_clicks","premium_all_wo_nds","premium_ctr","premium_cpm_all_wo_nds","premium_cpc_all_wo_nds"],"levels":[{"filter":["AND",[["id","${block_id}","="]]],"id":"internal_advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_search_premium_detailed_report', 'internal_advnet_search_on_site_premium', 'Отчет по Спецразмещению ${period||30days} (с детализацией по дням)', 'Premium placement report for ${period||30days} (with daily details)', '{"chartLevel":[{"period":"${period||30days}","fields":["premium_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_search_on_site_premium","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["premium_shows","premium_clicks","premium_all_wo_nds","premium_ctr","premium_cpm_all_wo_nds","premium_cpc_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_search_on_site_premium","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_search_premium_report_by_page_id', 'internal_advnet_search_on_site_premium', 'Отчет по Спецразмещению для площадки ${page_id} «${name}» за ${period||30days}', 'Report on Premium placement for ${page_id} "${name}" ad platform for ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["premium_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["premium_shows","premium_clicks","premium_all_wo_nds","premium_ctr","premium_cpm_all_wo_nds","premium_cpc_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_search_premium_report', 'internal_advnet_search_on_site_premium', 'Отчет по Спецразмещению за ${period||30days} (без детализации по дням)', 'Premium placement report for ${period||30days} (without daily details)', '{"chartLevel":[{"period":"${period||30days}","fields":["premium_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_search_on_site_premium","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["premium_shows","premium_clicks","premium_all_wo_nds","premium_ctr","premium_cpm_all_wo_nds","premium_cpc_all_wo_nds"],"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_search_on_site_premium","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_search_premium_tags_report_by_page_id', 'internal_advnet_search_on_site_premium', 'Отчет по срезам Спецразмещения для площадки ${page_id} «${name}» за ${period||30days}', 'Premium placement cross-section report for ${page_id} "${name}" ad platform for ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["premium_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"fields":["premium_shows","premium_clicks","premium_all_wo_nds","premium_ctr","premium_cpm_all_wo_nds","premium_cpc_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_search_premium_tags_report', 'internal_advnet_search_on_site_premium', 'Отчет по срезам Спецразмещения за ${period||30days} (без детализации по дням)', 'Premium placement cross-section report for ${period||30days} (without daily details)', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["premium_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["tag_id","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"fields":["premium_shows","premium_clicks","premium_all_wo_nds","premium_ctr","premium_cpm_all_wo_nds","premium_cpc_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_search_report_by_page_id', 'internal_advnet_search_on_site', 'Отчет по поисковой площадке ${page_id} «${name}» за ${period||30days} (с детализацией по дням)', 'Report on ${page_id} "${name}" search ad platform for ${period||30days} (with daily details)', '{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["id"],"fields":["premium_all_wo_nds","direct_search_all_wo_nds","all_wo_nds"],"levels":[{"filter":["AND",[["id","IN",["${page_id}"]]]],"id":"internal_advnet_search_on_site"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_search_report', 'internal_advnet_search_on_site', 'Отчет по рекламе на поисковых площадках за ${period||30days}', 'Report on search ad platform advertisements for ${period||30days}', '{"chartLevel":[{"period":"${period||30days}","fields":["premium_all_wo_nds","direct_search_all_wo_nds","all_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_search_on_site","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["premium_all_wo_nds","direct_search_all_wo_nds","all_wo_nds"],"dimension_fields":[],"dimension_filter":null,"entity_fields":["id","domain"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_search_on_site","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('mobile_income', 'mobile_app', 'Доход по рекламе в мобильных приложениях за ${period||10days}', 'Revenue from mobile application advertisements for ${period||10days}', '{"chartLevel":[{"period":"${period||10days}","fields":["mobile_rtb_partner_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"mobile_app","filter":null}]}],"tableLevel":null,"isLevelsDifferent":false}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('mobile_report_by_login', 'mobile_app', 'Отчет по рекламе в мобильных приложениях для логина ${login} за 30 дней (без детализации по дням)', 'Report on mobile application advertisements for ${login} login for past 30 days (without daily details)', '{"tableViewModelData":{"sortBy":"mobile_rtb_partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["caption"],"fields":["mobile_rtb_partner_wo_nds"],"levels":[{"filter":["AND",[["owner","MATCH",["login","IN",["${login}"]]]]],"id":"mobile_app"}],"period":"30days","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":[],"dimension_filter":null,"entity_fields":["caption","context_page_id"],"fields":["mobile_rtb_block_hits","mobile_rtb_block_shows","mobile_rtb_partner_wo_nds","mobile_rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["owner","MATCH",["login","IN",["${login}"]]]]],"id":"mobile_app"}],"period":"30days","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('mobile_report_by_page_id', 'mobile_app', 'Отчет по мобильному приложению ${page_id} «${name}» за ${period||30days} (с детализацией по дням)', '${page_id} "${name}" mobile application report for ${period||30days} (with daily details)', '{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["caption"],"fields":["mobile_rtb_partner_wo_nds"],"levels":[{"filter":["AND",[["context_page_id","IN",["${page_id}"]]]],"id":"mobile_app"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["context_page_id","caption"],"fields":["mobile_rtb_partner_wo_nds"],"levels":[{"filter":["AND",[["context_page_id","IN",["${page_id}"]]]],"id":"mobile_app"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('mobile_report', 'mobile_app', 'Отчет по рекламе в мобильных приложениях за ${period||30days} (без детализации по дням)', 'Report on mobile application advertisements for ${period||30days} (without daily details)', '{"tableViewModelData":{"sortBy":"mobile_rtb_partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_partner_wo_nds","mobile_rtb_block_cpm_partner_wo_nds"],"dimension_fields":[],"dimension_filter":null,"entity_fields":["context_page_id","caption"],"total":0,"vat":-1,"levels":[{"id":"mobile_app","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["mobile_rtb_partner_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"mobile_app","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('mobile_rtb_detailed_report_by_block_id', 'mobile_app_rtb', 'Отчет по мобильному RTB-блоку ${block_id} «${name}» за ${period||30days}', 'Mobile RTB block ${block_id} "${name}" report for ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_partner_wo_nds","mobile_rtb_block_visibility","mobile_rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"mobile_app_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["mobile_rtb_block_shows","mobile_rtb_block_shows_own_adv","mobile_rtb_block_hits","mobile_rtb_block_hits_own_adv","mobile_rtb_block_hits_unsold","mobile_rtb_partner_wo_nds","mobile_rtb_block_winrate","mobile_rtb_block_visibility","mobile_rtb_block_all_hits","mobile_rtb_block_cover_ratio","mobile_rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"mobile_app_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('mobile_rtb_detailed_report', 'mobile_app_rtb', 'Отчет по мобильным RTB-блокам за ${period||30days} (с детализацией по дням)', 'Report on mobile RTB blocks for ${period||30days} (with daily details)', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||30days}","fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_partner_wo_nds","mobile_rtb_block_cpm_partner_wo_nds"],"dimension_fields":["date|day","mobile_caption","currency_id"],"dimension_filter":null,"entity_fields":["context_page_id"],"total":0,"vat":-1,"levels":[{"id":"mobile_app_rtb","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["mobile_rtb_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["context_page_id"],"total":0,"vat":-1,"levels":[{"id":"mobile_app_rtb","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('mobile_rtb_report_by_page_id', 'mobile_app_rtb', 'Отчет по мобильным RTB-блокам для приложения ${page_id} «${name}» за ${period||30days}', 'Report on mobile RTB blocks for ${page_id} "${name}" application for ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["mobile_rtb_partner_wo_nds"],"levels":[{"filter":["AND",[["context_page_id","IN",["${page_id}"]]]],"id":"mobile_app_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_partner_wo_nds","mobile_rtb_block_visibility","mobile_rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["context_page_id","IN",["${page_id}"]]]],"id":"mobile_app_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('mobile_rtb_report', 'mobile_app_rtb', 'Отчет по мобильным RTB-блокам за ${period||30days} (без детализации по дням)', 'Report on mobile RTB blocks for ${period||30days} (without daily details)', '{"tableViewModelData":{"sortBy":"mobile_rtb_partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_partner_wo_nds","mobile_rtb_block_cpm_partner_wo_nds"],"dimension_fields":["mobile_caption","currency_id"],"dimension_filter":null,"entity_fields":["context_page_id"],"total":0,"vat":-1,"levels":[{"id":"mobile_app_rtb","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["mobile_rtb_partner_wo_nds"],"dimension_fields":["date|day","mobile_caption","currency_id"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"mobile_app_rtb","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('monitorings_all_payments', 'payment', 'Доход по всем видам рекламы за период ${period_current} со сравнением', 'Revenue from all types of advertisements for period ${period_current} with comparison', '{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"fields":["fullscreen_partner_wo_nds","instream_partner_wo_nds","inpage_partner_wo_nds","rtb_partner_wo_nds","mobile_rtb_partner_wo_nds","adfox_partner_wo_nds","adblock_partner_wo_nds","premium_partner_wo_nds","direct_context_partner_wo_nds","direct_search_partner_wo_nds","stripe_partner_wo_nds","partner_wo_nds"],"levels":[{"filter":null,"id":"payment"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"fields":["fullscreen_partner_wo_nds","instream_partner_wo_nds","inpage_partner_wo_nds","rtb_partner_wo_nds","mobile_rtb_partner_wo_nds","adfox_partner_wo_nds","adblock_partner_wo_nds","premium_partner_wo_nds","direct_context_partner_wo_nds","direct_search_partner_wo_nds","stripe_partner_wo_nds","partner_wo_nds"],"levels":[{"filter":null,"id":"payment"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('monitorings_context_adfox', 'payment', 'Отчет по ADFOX за период ${period_current} со сравнением', 'ADFOX report for period ${period_current} with comparison', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["adfox_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_adfox"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["adfox_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_adfox"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('monitorings_context_direct', 'payment', 'Отчет по Директу за период ${period_current} со сравнением', 'Direct report for period ${period_current} with comparison', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_shows","direct_context_clicks","direct_context_partner_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_partner_wo_nds","direct_context_cpc_direct_context_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_direct"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_shows","direct_context_clicks","direct_context_partner_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_partner_wo_nds","direct_context_cpc_direct_context_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_direct"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('monitorings_context_rtb', 'payment', 'Отчет по RTB за период ${period_current} со сравнением', 'RTB report for period ${period_current} with comparison', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_block_hits","rtb_block_shows","rtb_partner_wo_nds","rtb_block_visibility","rtb_block_cpmh_partner_wo_nds","rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_rtb"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_block_hits","rtb_block_shows","rtb_partner_wo_nds","rtb_block_visibility","rtb_block_cpmh_partner_wo_nds","rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_rtb"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('monitorings_context_stripe', 'payment', 'Отчет по ADFOX за период ${period_current} со сравнением', 'ADFOX report for period ${period_current} with comparison', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_partner_wo_nds","stripe_ctr"],"levels":[{"filter":null,"id":"advnet_context_on_site_stripe"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_partner_wo_nds","stripe_ctr"],"levels":[{"filter":null,"id":"advnet_context_on_site_stripe"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('monitorings_mobile_rtb', 'payment', 'Отчет по мобильным RTB-блокам за период ${period_current} со сравнением', 'Report on mobile RTB blocks for period ${period_current} with comparison', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["mobile_rtb_block_hits","mobile_rtb_block_shows","mobile_rtb_partner_wo_nds","mobile_rtb_block_visibility","mobile_rtb_block_cpmh_partner_wo_nds","mobile_rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"mobile_app_rtb"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["mobile_rtb_block_hits","mobile_rtb_block_shows","mobile_rtb_partner_wo_nds","mobile_rtb_block_visibility","mobile_rtb_block_cpmh_partner_wo_nds","mobile_rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"mobile_app_rtb"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('monitorings_search_direct', 'payment', 'Отчет по поисковому Директу за период ${period_current} со сравнением', 'Search Direct report for period ${period_current} with comparison', '{"chartLevel":[{"dimension_fields":["date|day","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_partner_wo_nds","direct_search_ctr"],"levels":[{"filter":null,"id":"advnet_search_on_site_direct"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_partner_wo_nds","direct_search_ctr"],"levels":[{"filter":null,"id":"advnet_search_on_site_direct"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('monitorings_search_premium', 'payment', 'Отчет по Спецразмещению за период ${period_current} со сравнением', 'Premium placement report for period ${period_current} with comparison', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["premium_shows","premium_clicks","premium_partner_wo_nds","premium_ctr"],"levels":[{"filter":null,"id":"advnet_search_on_site_premium"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["premium_shows","premium_clicks","premium_partner_wo_nds","premium_ctr"],"levels":[{"filter":null,"id":"advnet_search_on_site_premium"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('monitorings_video_fullscreen_block', 'payment', 'Отчет по Fullscreen видеоблокам за период ${period_current} со сравнением', 'Report on Fullscreen video blocks for period ${period_current} with comparison', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["fullscreen_block_hits","fullscreen_block_shows","fullscreen_partner_wo_nds","fullscreen_block_visibility"],"levels":[{"filter":null,"id":"video_an_site_fullscreen"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["fullscreen_block_hits","fullscreen_block_shows","fullscreen_partner_wo_nds","fullscreen_block_visibility"],"levels":[{"filter":null,"id":"video_an_site_fullscreen"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('monitorings_video_inpage_block', 'payment', 'Отчет по InPage видеоблокам за период ${period_current} со сравнением', 'Report on InPage video blocks for period ${period_current} with comparison', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["inpage_block_hits","inpage_block_shows","inpage_partner_wo_nds","inpage_block_visibility"],"levels":[{"filter":null,"id":"video_an_site_inpage"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["inpage_block_hits","inpage_block_shows","inpage_partner_wo_nds","inpage_block_visibility"],"levels":[{"filter":null,"id":"video_an_site_inpage"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('monitorings_video_instream_block', 'payment', 'Отчет по Instream видеоблокам за период ${period_current} со сравнением', 'Report on Instream video blocks for period ${period_current} with comparison', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["instream_block_hits","instream_block_shows","instream_partner_wo_nds","instream_block_visibility"],"levels":[{"filter":null,"id":"video_an_site_instream"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["instream_block_hits","instream_block_shows","instream_partner_wo_nds","instream_block_visibility"],"levels":[{"filter":null,"id":"video_an_site_instream"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_direct_detailed_report_by_block_id', 'advnet_search_on_site_direct', 'Отчет по поисковому Директу ${block_id} «${name}» за ${period||30days} (с детализацией по дням)', 'Search Direct ${block_id} "${name}" report for ${period||30days} (with daily details)', '{"chartLevel":[{"dimension_fields":["date|day","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_partner_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_partner_wo_nds","direct_search_cpc_direct_search_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_direct_detailed_report', 'advnet_search_on_site_direct', 'Отчет по поисковому Директу за ${period||30days} (с детализацией по дням)', 'Search Direct report for ${period||30days} (with daily details)', '{"chartLevel":[{"dimension_fields":["date|day","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_partner_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_partner_wo_nds","direct_search_cpc_direct_search_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_direct_report_by_page_id', 'advnet_search_on_site_direct', 'Отчет по Директу для площадки ${page_id} «${name}» за ${period||30days}', 'Report on Direct for ${page_id} "${name}" ad platform for ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["direct_search_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["direct_search_shows","direct_search_clicks","direct_search_partner_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_partner_wo_nds","direct_search_cpc_direct_search_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"direct_search_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_direct_report', 'advnet_search_on_site_direct', 'Отчет по поисковому Директу за ${period||30days} (без детализации по дням)', 'Search Direct report for ${period||30days} (without daily details)', '{"chartLevel":[{"dimension_fields":["date|day","currency_id","search_campaign_caption"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id","search_campaign_caption"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_partner_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_partner_wo_nds","direct_search_cpc_direct_search_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_direct_tags_report_by_page_id', 'advnet_search_on_site_direct', 'Отчет по срезам поискового Директа для площадки ${page_id} «${name}» за ${period||30days}', 'Search Direct cross-section report for ${page_id} "${name}" ad platform for ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_search_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","tag_id","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_partner_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_partner_wo_nds","direct_search_cpc_direct_search_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"direct_search_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_direct_tags_report', 'advnet_search_on_site_direct', 'Отчет по срезам поискового Директа за ${period||30days} (без детализации по дням)', 'Search Direct cross-section report for ${period||30days} (without daily details)', '{"chartLevel":[{"dimension_fields":["date|day","currency_id","tag_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_search_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id","tag_id","search_campaign_caption"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_partner_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_partner_wo_nds","direct_search_cpc_direct_search_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_income', 'advnet_search_on_site', 'Доход по рекламе на поисковых площадках за ${period||10days}', 'Revenue from advertisement on search ad platforms for ${period||10days}', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":null,"chartLevel":[{"period":"${period||10days}","fields":["premium_partner_wo_nds","market_api_search_partner_wo_nds","direct_search_partner_wo_nds","partner_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site","filter":null}]}],"isLevelsDifferent":false}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_market_api_detailed_report', 'advnet_search_on_site_market_api', 'Отчет по поисковому API Маркета за ${period||30days} (с детализацией по дням)', 'Search API Market report for ${period||30days} (with daily details)', '{"tableLevel":[{"period":"${period||30days}","fields":["market_api_search_partner_wo_nds","market_api_search_clicks","market_api_search_cpc_market_api_search_partner_wo_nds","market_api_search_cpm_market_api_search_partner_wo_nds","market_api_search_ctr","market_api_search_shows"],"dimension_fields":["search_campaign_caption","currency_id","date|day"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site_market_api","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["market_api_search_partner_wo_nds"],"dimension_fields":["search_campaign_caption","currency_id","date|day"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site_market_api","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_market_api_report_by_page_id', 'advnet_search_on_site_market_api', 'Отчет по поисковому API маркета для площадки ${page_id} «${name}» за ${period||30days}', 'Report on search API Market for ${page_id} "${name}" ad platform for ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["market_api_search_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_market_api"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["market_api_search_clicks","market_api_search_shows","market_api_search_ctr","market_api_search_partner_wo_nds","market_api_search_cpm_market_api_search_partner_wo_nds","market_api_search_cpc_market_api_search_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_market_api"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"market_api_search_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_market_api_report', 'advnet_search_on_site_market_api', 'Отчет по поисковому API Маркета за ${period||30days} (без детализации по дням)', 'Search API Market report for ${period||30days} (without daily details)', '{"tableLevel":[{"period":"${period||30days}","fields":["market_api_search_partner_wo_nds","market_api_search_clicks","market_api_search_cpc_market_api_search_partner_wo_nds","market_api_search_cpm_market_api_search_partner_wo_nds","market_api_search_ctr","market_api_search_shows"],"dimension_fields":["currency_id","search_campaign_caption"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site_market_api","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["market_api_search_all_wo_nds"],"dimension_fields":["date|day","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site_market_api","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_premium_detailed_report_by_block_id', 'advnet_search_on_site_premium', 'Отчет по Спецразмещению ${block_id} «${name}» за ${period||30days}', 'Premium placement ${block_id} "${name}" report for ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["premium_shows","premium_clicks","premium_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["premium_shows","premium_clicks","premium_partner_wo_nds","premium_ctr","premium_cpm_partner_wo_nds","premium_cpc_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_premium_detailed_report', 'advnet_search_on_site_premium', 'Отчет по Спецразмещению за ${period||30days} (с детализацией по дням)', 'Premium placement report for ${period||30days} (with daily details)', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||30days}","fields":["premium_shows","premium_clicks","premium_partner_wo_nds","premium_ctr","premium_cpm_partner_wo_nds","premium_cpc_partner_wo_nds"],"dimension_fields":["date|day","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site_premium","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["premium_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site_premium","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_premium_report_by_page_id', 'advnet_search_on_site_premium', 'Отчет по Спецразмещению для площадки ${page_id} «${name}» за ${period||30days}', 'Report on Premium placement for ${page_id} "${name}" ad platform for ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["premium_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["premium_shows","premium_clicks","premium_partner_wo_nds","premium_ctr","premium_cpm_partner_wo_nds","premium_cpc_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_premium_report', 'advnet_search_on_site_premium', 'Отчет по Спецразмещению за ${period||30days} (без детализации по дням)', 'Premium placement report for ${period||30days} (without daily details)', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||30days}","fields":["premium_shows","premium_clicks","premium_partner_wo_nds","premium_ctr","premium_cpm_partner_wo_nds","premium_cpc_partner_wo_nds"],"dimension_fields":["search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site_premium","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["premium_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site_premium","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_premium_tags_report_by_page_id', 'advnet_search_on_site_premium', 'Отчет по срезам Спецразмещения для площадки ${page_id} «${name}» за ${period||30days}', 'Premium placement cross-section report for ${page_id} "${name}" ad platform for ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["premium_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","tag_id","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["premium_shows","premium_clicks","premium_partner_wo_nds","premium_ctr","premium_cpm_partner_wo_nds","premium_cpc_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_premium_tags_report', 'advnet_search_on_site_premium', 'Отчет по срезам Спецразмещения за ${period||30days} (без детализации по дням)', 'Premium placement cross-section report for ${period||30days} (without daily details)', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["premium_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["tag_id","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["premium_shows","premium_clicks","premium_partner_wo_nds","premium_ctr","premium_cpm_partner_wo_nds","premium_cpc_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_report_by_page_id', 'advnet_search_on_site', 'Отчет по поисковой площадке ${page_id} «${name}» за ${period||30days} (с детализацией по дням)', 'Report on ${page_id} "${name}" search ad platform for ${period||30days} (with daily details)', '{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["direct_search_partner_wo_nds","market_api_search_partner_wo_nds","partner_wo_nds","premium_partner_wo_nds","mcb_search_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["market_api_search_partner_wo_nds","premium_partner_wo_nds","direct_search_partner_wo_nds","partner_wo_nds","mcb_search_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_report', 'advnet_search_on_site', 'Отчет по рекламе на поисковых площадках за ${period||30days}', 'Report on search ad platforms advertisements for ${period||30days}', '{"tableViewModelData":{"sortBy":"partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["premium_partner_wo_nds","market_api_search_partner_wo_nds","direct_search_partner_wo_nds","partner_wo_nds","mcb_search_cpmh_mcb_search_partner_wo_nds"],"dimension_fields":[],"dimension_filter":null,"entity_fields":["page_id","caption"],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["premium_partner_wo_nds","market_api_search_partner_wo_nds","direct_search_partner_wo_nds","partner_wo_nds","mcb_search_cpmh_mcb_search_partner_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('ssp_report', 'ssp', 'Отчет по SSP за ${period||30days} (без детализации по дням)', 'Report on SSP for ${period||30days} (without daily details)', '{"tableViewModelData":{"sortBy":"all_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"fields":["ssp_mobile_rtb_partner_wo_nds","partner_wo_nds","ssp_mobile_rtb_all_wo_nds","all_wo_nds"],"levels":[{"filter":null,"id":"ssp"}],"period":"30days","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":[],"dimension_filter":null,"entity_fields":["id","name"],"fields":["ssp_mobile_rtb_partner_wo_nds","partner_wo_nds","ssp_mobile_rtb_all_wo_nds","all_wo_nds"],"levels":[{"filter":null,"id":"ssp"}],"period":"30days","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('video_fullscreen_block_detailed_report_by_block_id', 'video_an_site_fullscreen', 'Отчет по Fullscreen видеоблоку ${block_id} «${name}» за ${period||30days}', 'Fullscreen video block ${block_id} "${name}" report for ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["fullscreen_block_hits","fullscreen_block_shows","fullscreen_partner_wo_nds","fullscreen_block_visibility","fullscreen_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"video_an_site_fullscreen"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["fullscreen_block_hits","fullscreen_block_shows","fullscreen_block_hits_own_adv","fullscreen_block_shows_own_adv","fullscreen_block_hits_unsold","fullscreen_block_all_hits","fullscreen_partner_wo_nds","fullscreen_block_winrate","fullscreen_block_visibility","fullscreen_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"video_an_site_fullscreen"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('video_fullscreen_block_detailed_report', 'video_an_site_fullscreen', 'Отчет по Fullscreen видеоблокам за ${period||30days} (с детализацией по дням)', 'Report on Fullscreen video blocks for ${period||30days} (with daily details)', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["fullscreen_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_fullscreen"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","video_caption","currency_id"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["fullscreen_block_hits","fullscreen_block_shows","fullscreen_partner_wo_nds","fullscreen_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_fullscreen"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('video_fullscreen_block_report_by_page_id', 'video_an_site_fullscreen', 'Отчет по Fullscreen видеоблокам для ресурса ${page_id} «${name}» за ${period||30days}', 'Report on Fullscreen video blocks for ${page_id} "${name}" resource for ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["fullscreen_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"video_an_site_fullscreen"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["fullscreen_block_hits","fullscreen_block_shows","fullscreen_partner_wo_nds","fullscreen_block_visibility","fullscreen_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"video_an_site_fullscreen"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('video_fullscreen_block_report', 'video_an_site_fullscreen', 'Отчет по Fullscreen видеоблокам за ${period||30days} (без детализации по дням)', 'Report on Fullscreen video blocks for ${period||30days} (without daily details)', '{"tableViewModelData":{"sortBy":"fullscreen_partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["fullscreen_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_fullscreen"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["video_caption","currency_id"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["fullscreen_block_hits","fullscreen_block_shows","fullscreen_partner_wo_nds","fullscreen_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_fullscreen"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('video_income', 'video_an_site', 'Доход по видеорекламе за ${period||10days}', 'Revenue from video advertisement for ${period||10days}', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":null,"chartLevel":[{"period":"${period||10days}","fields":["fullscreen_partner_wo_nds","instream_partner_wo_nds","inpage_partner_wo_nds","partner_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"video_an_site","filter":null}]}],"isLevelsDifferent":false}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('video_inpage_block_detailed_report_by_block_id', 'video_an_site_inpage', 'Отчет по InPage видеоблоку ${block_id} «${name}» за ${period||30days}', 'InPage video block ${block_id} "${name}" report for ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"fields":["inpage_block_hits","inpage_block_shows","inpage_partner_wo_nds","inpage_block_visibility","inpage_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"video_an_site_inpage"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["inpage_block_hits","inpage_block_shows","inpage_block_hits_own_adv","inpage_block_shows_own_adv","inpage_block_hits_unsold","inpage_block_all_hits","inpage_partner_wo_nds","inpage_block_winrate","inpage_block_visibility","inpage_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"video_an_site_inpage"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('video_inpage_block_detailed_report', 'video_an_site_inpage', 'Отчет по InPage видеоблокам за ${period||30days} (с детализацией по дням)', 'Report on InPage video blocks for ${period||30days} (with daily details)', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["inpage_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_inpage"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","video_caption"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["inpage_block_hits","inpage_block_shows","inpage_partner_wo_nds","inpage_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_inpage"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('video_inpage_block_report_by_page_id', 'video_an_site_inpage', 'Отчет по InPage видеоблокам для ресурса ${page_id} «${name}» за ${period||30days}', 'Report on InPage video blocks for ${page_id} "${name}" resource for ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["inpage_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"video_an_site_inpage"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["inpage_block_hits","inpage_block_shows","inpage_partner_wo_nds","inpage_block_visibility","inpage_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"video_an_site_inpage"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('video_inpage_block_report', 'video_an_site_inpage', 'Отчет по InPage видеоблокам за ${period||30days} (без детализации по дням)', 'Report on InPage video blocks for ${period||30days} (without daily details)', '{"tableViewModelData":{"sortBy":"inpage_partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["inpage_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_inpage"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["video_caption"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["inpage_block_hits","inpage_block_shows","inpage_partner_wo_nds","inpage_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_inpage"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('video_instream_block_detailed_report_by_block_id', 'video_an_site_instream', 'Отчет по Instream видеоблоку ${block_id} «${name}» за ${period||30days}', 'Instream video block ${block_id} "${name}" report for ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["instream_block_hits","instream_block_shows","instream_partner_wo_nds","instream_block_visibility","instream_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"video_an_site_instream"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["instream_block_hits","instream_block_shows","instream_block_hits_own_adv","instream_block_shows_own_adv","instream_block_hits_unsold","instream_block_all_hits","instream_partner_wo_nds","instream_block_winrate","instream_block_visibility","instream_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"video_an_site_instream"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('video_instream_block_detailed_report', 'video_an_site_instream', 'Отчет по Instream видеоблокам за ${period||30days} (с детализацией по дням)', 'Report on Instream video blocks for ${period||30days} (with daily details)', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["instream_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_instream"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","video_caption","currency_id"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["instream_block_hits","instream_block_shows","instream_partner_wo_nds","instream_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_instream"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('video_instream_block_report_by_page_id', 'video_an_site_instream', 'Отчет по Instream видеоблокам для ресурса ${page_id} «${name}» за ${period||30days}', 'Report on Instream video blocks for ${page_id} "${name}" resource for ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["instream_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"video_an_site_instream"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["instream_block_hits","instream_block_shows","instream_partner_wo_nds","instream_block_visibility","instream_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"video_an_site_instream"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('video_instream_block_report', 'video_an_site_instream', 'Отчет по Instream видеоблокам за ${period||30days} (без детализации по дням)', 'Report on Instream video blocks for ${period||30days} (without daily details)', '{"tableViewModelData":{"sortBy":"instream_partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["instream_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_instream"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["video_caption","currency_id"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["instream_block_hits","instream_block_shows","instream_partner_wo_nds","instream_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_instream"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('video_report_by_page_id', 'video_an_site', 'Отчет по видеоресурсу ${page_id} «${name}» за ${period||30days} (с детализацией по дням)', 'Report on ${page_id} "${name}" video resource for ${period||30days} (with daily details)', '{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["id"],"fields":["fullscreen_partner_wo_nds","inpage_partner_wo_nds","instream_partner_wo_nds","video_an_site_sum_partner_wo_nds"],"levels":[{"filter":["AND",[["id","IN",["${page_id}"]]]],"id":"video_an_site"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["caption","id"],"fields":["fullscreen_partner_wo_nds","inpage_partner_wo_nds","instream_partner_wo_nds","video_an_site_sum_partner_wo_nds"],"levels":[{"filter":["AND",[["id","IN",["${page_id}"]]]],"id":"video_an_site"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('video_site_report_by_login', 'video_an_site', 'Отчет по видеорекламе для логина ${login} за 30 дней (без детализациии по дням)', 'Video advertisement report for ${login} login for past 30 days (without daily details)', '{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"fields":["video_an_site_sum_partner_wo_nds"],"levels":[{"filter":["AND",[["owner","MATCH",["login","IN",["${login}"]]]]],"id":"video_an_site"}],"period":"30days","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":[],"dimension_filter":null,"entity_fields":["caption","id"],"fields":["fullscreen_block_hits","instream_block_hits","inpage_block_hits","fullscreen_block_shows","instream_block_shows","inpage_block_shows","video_an_site_sum_partner_wo_nds","fullscreen_block_visibility","instream_block_visibility","inpage_block_visibility","fullscreen_block_cpm_partner_wo_nds","instream_block_cpm_partner_wo_nds","inpage_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["owner","MATCH",["login","IN",["${login}"]]]]],"id":"video_an_site"}],"period":"30days","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('video_site_report', 'video_an_site', 'Отчет по видеорекламе за ${period||30days} (без детализациии по дням)', 'Video advertisement report for ${period||30days} (without daily details)', '{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"fields":["video_an_site_sum_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":[],"dimension_filter":null,"entity_fields":["caption","id"],"fields":["fullscreen_block_hits","instream_block_hits","inpage_block_hits","fullscreen_block_shows","instream_block_shows","inpage_block_shows","video_an_site_sum_partner_wo_nds","fullscreen_block_visibility","instream_block_visibility","inpage_block_visibility","fullscreen_block_cpm_partner_wo_nds","instream_block_cpm_partner_wo_nds","inpage_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`=VALUES(`level`),
    `caption_ru`=VALUES(`caption_ru`),
    `caption_en`=VALUES(`caption_en`),
    `query`=VALUES(`query`),
    `not_show`=VALUES(`not_show`);

/* PI-9821_standart_reports.sql end */
