#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION

Нужно подключить ПРОД БАЗУ и ПРОД БК

=cut

# project modules
use lib::abs qw(
  ../../lib
  );
use qbit;
use Application;

my $APP;

my $FILENAME = 'PI-10464_stripe';

main();

sub main {
    $APP = Application->new();

    $APP->pre_run();

    $APP->set_option('cur_user' => {id => 0});

    my $tmp_rights = $APP->add_all_tmp_rights();

    delete_stripes();
    shuffle_bits();
    update_pages();

    $APP->post_run();

    print "#END\n";
}

sub shuffle_bits {
    foreach my $table (qw(context_on_site_stripe internal_context_on_site_stripe)) {

        print "\nTable: $table\n\n";
        print
          "Need to shift 'multistate' one bit right. Lower 3 bits become lower 2 bits. Also, need to reorder bits:\n";
        print "Old deleted = 100, New deleted = 01\n";
        print "Old working = 001, New working = 10\n";

        my $recs = $APP->partner_db->$table->get_all(
            fields   => [qw(campaign_id id multistate)],
            order_by => [qw(campaign_id id)],
        );

        my ($block, $multistate);
        foreach my $rec (@$recs) {
            $block = {campaign_id => $rec->{'campaign_id'}, id => $rec->{'id'}};

            $multistate = _convert_multistate($rec->{'multistate'});

            printf("$table block=$rec->{'campaign_id'}-$rec->{'id'} multistate %07b => %07b\n",
                $rec->{'multistate'}, $multistate);

            $APP->partner_db->$table->edit($block, {multistate => $multistate},);
        }
    }

    foreach my $table (qw(context_on_site_stripe_action_log internal_context_on_site_stripe_action_log)) {

        print "\nTable: $table\n\n";
        print
"Need to shift 'old_multistate' and 'new_multistate' one bit right. Lower 3 bits become lower 2 bits. Also, need to reorder bits:\n";
        print "Old deleted = 100, New deleted = 01\n";
        print "Old working = 001, New working = 10\n";

        my $recs = $APP->partner_db->$table->get_all(
            fields   => [qw(id old_multistate new_multistate)],
            order_by => [qw(id)],
        );

        my ($id, $old_multistate, $new_multistate);
        foreach my $rec (@$recs) {
            $id = $rec->{'id'};

            $old_multistate = _convert_multistate($rec->{'old_multistate'});
            $new_multistate = _convert_multistate($rec->{'new_multistate'});

            printf(
                "$table id=$rec->{'id'} old_multistate %07b => %07b, new_multistate %07b => %07b\n",
                $rec->{'old_multistate'},
                $old_multistate, $rec->{'new_multistate'},
                $new_multistate
            );

            $APP->partner_db->$table->edit($id, {old_multistate => $old_multistate, new_multistate => $new_multistate},
            );
        }
    }
}

sub delete_stripes {
    my %need_update_pages = ();

    foreach my $model (qw(context_on_site_stripe internal_context_on_site_stripe)) {
        print "\nDelete blocks in model: $model\n";

        my $page_model = $APP->$model->get_campaign_model_name();

        my $blocks =
          $APP->partner_db->_get_all("select campaign_id, id, multistate from $model where not (multistate & 4)");

        my %pages = map {$_->{'page_id'} => $_->{'is_deleted'}} @{
            $APP->$page_model->get_all(
                fields => ['page_id', 'is_deleted'],
                filter => {page_id => [map {$_->{'campaign_id'}} @$blocks]}
            )
          };

        foreach my $rec (@$blocks) {
            my $new_multistate = $rec->{'multistate'} | 4;

            my $msg = sprintf('Block %d-%d old_multistate %d => %d ',
                $rec->{'campaign_id'}, $rec->{'id'}, $rec->{'multistate'}, $new_multistate);

            $APP->partner_db->$model->edit($rec, {multistate => $new_multistate});

            $msg .= 'deleted';

            unless ($pages{$rec->{'campaign_id'}}) {
                $msg .= ', need update';
                $need_update_pages{$rec->{'campaign_id'}} = TRUE;
            }

            print "$msg\n";
        }
    }

    writefile($FILENAME, join("\n", sort {$a <=> $b} keys(%need_update_pages)));
}

sub update_pages {
    print "resend_to_bk.pl log file: $FILENAME.log\n";

    my $system_string = "perl bin/resend_to_bk.pl --file_path=$FILENAME 2>&1 1>$FILENAME.log";

    print "Starting system('$system_string')\n";

    system($system_string);
}

sub _convert_multistate {
    my ($multistate) = @_;

    my $deleted = $multistate & 4;    # 100 in old
    my $working = $multistate & 1;    # 001 in old

    # one bit less in the lower part. remove "stopped" bit.
    my $new_multistate = $multistate >> 1;

    $new_multistate &= ~3;            # clear lower 2 bits

    # reorder deleted and working in new
    if ($deleted) {
        $new_multistate |= 1;         # 01 in new
    }
    if ($working) {
        $new_multistate |= 2;         # 10 in new
    }

    return $new_multistate;
}
