/* PI-9119 start */

CREATE TABLE IF NOT EXISTS `stat_download_data` (
    `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
    `method` VARCHAR(255) NOT NULL,
    `stat_date` DATE NOT NULL,
    `hostname` VARCHAR(255) NOT NULL,
    `checksum` INT(11) UNSIGNED NOT NULL,
    `update_time` DATETIME NOT NULL,
    `filename` VARCHAR(1024),
    `sync` tinyint(1) NOT NULL DEFAULT '0',
    PRIMARY KEY (`id`),
    UNIQUE KEY `stat_download_data_tags__method__stat_date` (`method`, `stat_date`, `update_time`, `hostname`)
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8';

ALTER TABLE `video_stat_files`
ADD COLUMN `from_date` DATE,
ADD COLUMN `to_date` DATE,
ADD COLUMN `s3_key` VARCHAR(255),
ADD COLUMN `s3_size` BIGINT,
ALGORITHM=INPLACE, LOCK=NONE;

UPDATE `video_stat_files`
SET `from_date` = `date`,
    `to_date` = `date`
WHERE `type` = 'yesterday';

UPDATE `video_stat_files`
SET `from_date` = `date`,
    `to_date` = DATE_SUB(DATE(`modification_date`), interval 1 day)
WHERE `type` = 'this_month';

UPDATE `video_stat_files`
SET `from_date` = `date`,
    `to_date` = LAST_DAY(`date`)
WHERE `type` = 'archive';
