/* PI-10049 start */

ALTER TABLE `users`
    ADD COLUMN `allowed_constructed_formats` BOOLEAN NOT NULL DEFAULT '0',
    ALGORITHM=INPLACE, LOCK=NONE;

ANALYZE TABLE `users`;

UPDATE `users` SET `allowed_constructed_formats` = 1 WHERE `login` IN (
    'adinside',
    'avitortb2013',
    'm-ru-2015',
    'savvameteo',
    'rambler-p',
    'shmelkin-roman',
    'wwwodnoklassniki-2015',
    'maximatelecom',
    'riandir',
    'gazeta-context',
    'aib-mamba',
    'sup-partner',
    'adv-vertis',
    'wwwrg',
    'rbcpartner',
    'lenta-partner',
    'tass-rtb',
    'daniel-lourie',
    'smi2smi2'
);

ALTER TABLE `context_on_site_rtb`
    ADD COLUMN `is_constructed_format` BOOLEAN NOT NULL DEFAULT '0',
    CHANGE COLUMN `horizontal_align` `horizontal_align` TINYINT(1) NULL DEFAULT '1',
    ALGORITHM=INPLACE, LOCK=NONE;

ANALYZE TABLE `context_on_site_rtb`;

CREATE TABLE IF NOT EXISTS `constructed_formats` (
    `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
    `user_id` BIGINT UNSIGNED NOT NULL,
    `caption` VARCHAR(128) NOT NULL,
    `direct_settings` TEXT,
    `multistate` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    PRIMARY KEY (`id`),
    UNIQUE INDEX `uniq_constructed_formats__user_id_caption` (`user_id`, `caption`),
    INDEX `constructed_formats__multistate` (`multistate`),
    FOREIGN KEY `fk_constructed_formats__user_id___users__id` (`user_id`)
        REFERENCES `users` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8';

CREATE TABLE IF NOT EXISTS `constructed_formats_action_log` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `dt` DATETIME NOT NULL,
    `user_id` BIGINT UNSIGNED NOT NULL,
    `elem_id` INT UNSIGNED NOT NULL,
    `old_multistate` BIGINT UNSIGNED NOT NULL,
    `action` VARCHAR(100) NOT NULL,
    `new_multistate` BIGINT UNSIGNED NOT NULL,
    `opts` TEXT NOT NULL,
    `comment` VARCHAR(100) NOT NULL DEFAULT '',
    PRIMARY KEY (`id`),
    INDEX `constructed_formats_action_log__dt_elem_id_action` (`dt`, `elem_id`, `action`),
    INDEX `constructed_formats_action_log__elem_id_action` (`elem_id`, `action`),
    FOREIGN KEY `fk_constructed_formats_action_log__user_id___users__id` (`user_id`)
        REFERENCES `users` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_constructed_formats_action_log__elem_id___constructed_format` (`elem_id`)
        REFERENCES `constructed_formats` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8';

REPLACE `partner`.`role_rights` VALUES
    (2, 'constructed_formats_add_other'),
    (2, 'constructed_formats_edit'),
    (2, 'constructed_formats_view'),
    (2, 'constructed_formats_view_action_log'),
    (2, 'constructed_formats_view_all'),
    (2, 'constructed_formats_view_field__login'),
    (15, 'constructed_formats_add_other'),
    (15, 'constructed_formats_edit'),
    (15, 'constructed_formats_view'),
    (15, 'constructed_formats_view_all'),
    (15, 'constructed_formats_view_field__login'),
    (17, 'constructed_formats_view'),
    (17, 'constructed_formats_view_all'),
    (17, 'constructed_formats_view_field__login'),
    (38, 'constructed_formats_add_other'),
    (38, 'constructed_formats_edit'),
    (38, 'constructed_formats_view'),
    (38, 'constructed_formats_view_all'),
    (38, 'constructed_formats_view_field__login'),
    (2, 'do_constructed_formats_add'),
    (2, 'users_edit_field__allowed_constructed_formats'),
    (2, 'users_view_field__allowed_constructed_formats'),
    (15, 'do_constructed_formats_add'),
    (15, 'users_edit_field__allowed_constructed_formats'),
    (15, 'users_view_field__allowed_constructed_formats'),
    (17, 'users_view_field__allowed_constructed_formats'),
    (38, 'do_constructed_formats_add'),
    (38, 'users_view_field__allowed_constructed_formats');

/* PI-10049 end */
