#!/usr/bin/perl

use qbit;

use feature 'say';

use Partner::DB;
use Text::CSV;
use File::Temp qw(tempfile);
use Encode;

my $dump_filters_to_be_deleted = <<SQL;
SELECT filters.page_id, filters.filter_id
FROM filters
INNER JOIN thematic_filters
ON filters.filter_id = thematic_filters.id
WHERE thematic_filters.bk_name in ("reg-allow", "work_abroad", "drugs", "abortion")
SQL

my $dump_pages_to_be_resent = <<SQL;
SELECT DISTINCT filters.page_id
FROM filters
INNER JOIN thematic_filters
ON filters.filter_id = thematic_filters.id
WHERE thematic_filters.bk_name in ("realtor", "reg-allow", "work_abroad", "drugs", "abortion", "weapon", "casino")
SQL

my $dump_thematic_filters = <<SQL;
SELECT *
FROM thematic_filters
SQL

my $delete_filters = <<SQL;
DELETE filters
FROM filters
INNER JOIN thematic_filters
ON filters.filter_id = thematic_filters.id
WHERE thematic_filters.bk_name in ("reg-allow", "work_abroad", "drugs", "abortion")
SQL

my $delete_thematic_filters = <<SQL;
DELETE FROM thematic_filters
WHERE thematic_filters.bk_name in ("reg-allow", "work_abroad", "drugs", "abortion")
SQL

my $update_thematic_filter_bk_name = <<SQL;
UPDATE thematic_filters
SET bk_name = CASE
    WHEN bk_name = "weapon" THEN "weapons"
    WHEN bk_name = "casino" THEN "gamble"
    ELSE bk_name
    END
SQL

my $update_thematic_filter_caption_en = <<SQL;
UPDATE thematic_filters
SET caption_en = "gamble"
WHERE bk_name = "gamble"
SQL

my $update_thematic_filter_caption_tr = <<SQL;
UPDATE thematic_filters
SET caption_tr = CASE
    WHEN bk_name = "unfamily"         THEN "aileye uygun değil"
    WHEN bk_name = "medicine"         THEN "sağlık"
    WHEN bk_name = "gamble"           THEN "kumar"
    WHEN bk_name = "alcohol"          THEN "alkol"
    WHEN bk_name = "tobacco"          THEN "tütün ürünleri"
    WHEN bk_name = "weapons"          THEN "silah"
    WHEN bk_name = "diploma"          THEN "diplomalar"
    WHEN bk_name = "milk-substitute"  THEN "devam sütü"
    WHEN bk_name = "realtor"          THEN "emlak"
    WHEN bk_name = "smi"              THEN "Medya"
    WHEN bk_name = "magic"            THEN "sihir"
    WHEN bk_name = "underwear"        THEN "iç çamaşırı"
    WHEN bk_name = "matchmaking"      THEN "çöpçatanlık"
    WHEN bk_name = "finance"          THEN "finans"
    WHEN bk_name = "game_values"      THEN "oyun kazanımları"
    WHEN bk_name = "rapid_enrichment" THEN "hızlı kazanç"
    ELSE caption_tr
    END
SQL

my $update_thematic_filter_caption_ru = <<SQL;
UPDATE thematic_filters
SET caption_ru = CASE
    WHEN bk_name = "unfamily"         THEN "реклама «для взрослых»"
    WHEN bk_name = "gamble"           THEN "азартные игры"
    WHEN bk_name = "milk-substitute"  THEN "детское питание"
    ELSE caption_ru
    END
SQL

say 'CONNECT';

my $se = get_db_partner2(server => ($ARGV[0] // die "Please supply db server type: dev/docker:PORT/ts/prod"));

my %dumps = (
    delete => {
        query     => $dump_filters_to_be_deleted,
        file_name => (tempfile('PI_9976_deleted_filters_dump_XXXXXX', OPEN => 0, DIR => './'))[1],
        columns   => [qw(page_id filter_id)],
    },
    resend => {
        query     => $dump_pages_to_be_resent,
        file_name => (tempfile('PI_9976_resend_to_bk_list_XXXXXX', OPEN => 0, DIR => './'))[1],
        columns   => [qw(page_id)],
    },
    thematic => {
        query     => $dump_thematic_filters,
        file_name => (tempfile('PI_9976_thematic_filters_dump_XXXXXX', OPEN => 0, DIR => './'))[1],
        columns   => [qw(id caption_en caption_ru caption_tr bk_name)],
    },
);

my $tsv = Text::CSV->new({binary => 1, sep_char => "\t", quote_char => undef, eol => "\n"})
  or die "Cannot use CSV: " . Text::CSV->error_diag();

say 'DUMP';

for my $dump (values %dumps) {
    my $data = $se->get_data($dump->{query});

    open(my $fh, '>:encoding(UTF-8)', $dump->{file_name}) or die "open: $!";

    for my $row (@$data) {
        $tsv->print($fh, [map {$row->{$_}} @{$dump->{columns}}])
          or die "Cannot print: " . Text::CSV->error_diag();
    }

    close($fh) or die "close: $!";
}

say 'MODIFY';

$se->execute($delete_filters);
$se->execute($delete_thematic_filters);
$se->execute($update_thematic_filter_bk_name);
$se->execute($update_thematic_filter_caption_en);
$se->execute($update_thematic_filter_caption_tr);
$se->execute($update_thematic_filter_caption_ru);

say '';
say "Don't forget to run after_release script";
say "page_ids for after_release script are stored in $dumps{resend}{file_name}";
say '';

say 'END';
