CREATE TABLE IF NOT EXISTS `distribution_campaign` (
    `id` INT UNSIGNED NOT NULL,
    `page_id` INT UNSIGNED,
    `owner_id` BIGINT UNSIGNED NOT NULL,
    `opts` JSON NOT NULL,
    `caption` VARCHAR(255) NOT NULL DEFAULT '',
    `multistate` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `create_date` DATETIME NOT NULL,
    `update_time` DATETIME NOT NULL,
    `send_time` DATETIME NOT NULL,
    `comment` TEXT,
    `creator_id` BIGINT UNSIGNED NOT NULL,
    `patch` JSON,
    `blocks_limit` INT NOT NULL DEFAULT '400',
    `blocks_count` INT NOT NULL DEFAULT '0',
    PRIMARY KEY (`id`),
    UNIQUE INDEX `uniq_distribution_campaign__page_id` (`page_id`),
    FOREIGN KEY `fk_distribution_campaign__owner_id___users__id` (`owner_id`)
        REFERENCES `users` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_distribution_campaign__creator_id___users__id` (`creator_id`)
        REFERENCES `users` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8';

CREATE TABLE IF NOT EXISTS `distribution_campaign_action_log` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `dt` DATETIME NOT NULL,
    `user_id` BIGINT UNSIGNED NOT NULL,
    `elem_id` INT UNSIGNED NOT NULL,
    `old_multistate` BIGINT UNSIGNED NOT NULL,
    `action` VARCHAR(100) NOT NULL,
    `new_multistate` BIGINT UNSIGNED NOT NULL,
    `opts` TEXT NOT NULL,
    `comment` VARCHAR(100) NOT NULL DEFAULT '',
    PRIMARY KEY (`id`),
    INDEX `distribution_campaign_action_log__dt_elem_id_action` (`dt`, `elem_id`, `action`),
    INDEX `distribution_campaign_action_log__elem_id_action` (`elem_id`, `action`),
    FOREIGN KEY `fk_distribution_campaign_action_log__user_id___users__id` (`user_id`)
        REFERENCES `users` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_distribution_campaign_action_log__elem_id___distribution_cam` (`elem_id`)
        REFERENCES `distribution_campaign` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8';
