ALTER TABLE `internal_mobile_app_rtb_action_log`
    DROP FOREIGN KEY `internal_mobile_app_rtb_action_log_ibfk_2`,
    ADD COLUMN `elem_campaign_id` BIGINT UNSIGNED,
    MODIFY COLUMN `elem_application_id` BIGINT UNSIGNED;


ALTER TABLE internal_mobile_app_rtb
    ADD from_trigger BOOLEAN NOT NULL DEFAULT '0',
    ADD COLUMN `campaign_id` INT UNSIGNED,
    ALGORITHM=INPLACE, LOCK=NONE;


ALTER TABLE `context_on_site_rtb`
    MODIFY COLUMN model
    ENUM('context_on_site_rtb', 'internal_context_on_site_rtb', 'mobile_app_rtb', 'context_on_site_content', 'internal_mobile_app_rtb')
    NOT NULL DEFAULT 'context_on_site_rtb',
    ALGORITHM=INPLACE, LOCK=NONE;


DROP TRIGGER IF EXISTS `internal_mobile_rtb_opts_insert`;
DELIMITER $$
CREATE TRIGGER internal_mobile_rtb_opts_insert
    BEFORE INSERT
    ON internal_mobile_app_rtb
    FOR EACH ROW
BEGIN
    SET NEW.campaign_id = IF(NEW.campaign_id IS NULL, NEW.application_id, NEW.campaign_id);
    SET NEW.application_id = IF(NEW.application_id IS NULL, NEW.campaign_id, NEW.application_id);
    SET NEW.opts = JSON_MERGE_PATCH(JSON_OBJECT(
            'adaptive_height', NEW.adaptive_height,
            'adaptive_width', NEW.adaptive_width,
            'bg_color', NEW.bg_color,
            'border_color', NEW.border_color,
            'border_radius', NEW.border_radius,
            'border_type', NEW.border_type,
            'callouts', NEW.callouts,
            'favicon', NEW.favicon,
            'font_family', NEW.font_family,
            'font_size', NEW.font_size,
            'header_bg_color', NEW.header_bg_color,
            'hover_color', NEW.hover_color,
            'is_custom_format_direct', NEW.is_custom_format_direct,
            'limit', NEW.limit,
            'links_underline', NEW.links_underline,
            'no_sitelinks', NEW.no_sitelinks,
            'site_bg_color', NEW.site_bg_color,
            'sitelinks_color', NEW.sitelinks_color,
            'text_color', NEW.text_color,
            'title_color', NEW.title_color,
            'title_font_size', NEW.title_font_size,
            'url_background_color', NEW.url_background_color,
            'url_color', NEW.url_color),
        IF(NEW.opts IS NULL, JSON_OBJECT(), NEW.opts)
    );
END; $$
DELIMITER ;


DROP TRIGGER IF EXISTS `internal_mobile_rtb_opts_update`;
DELIMITER $$
CREATE TRIGGER internal_mobile_rtb_opts_update
    BEFORE UPDATE
    ON internal_mobile_app_rtb
    FOR EACH ROW
BEGIN
    #from fields to opts

    IF(IFNULL(NEW.adaptive_height <> OLD.adaptive_height, NOT (NEW.adaptive_height IS NULL AND OLD.adaptive_height IS NULL)))
    THEN
        SET NEW.opts = JSON_MERGE_PATCH(NEW.opts, JSON_OBJECT('adaptive_height', NEW.adaptive_height));
END IF;

IF(IFNULL(NEW.adaptive_width <> OLD.adaptive_width, NOT (NEW.adaptive_width IS NULL AND OLD.adaptive_width IS NULL)))
    THEN
        SET NEW.opts = JSON_MERGE_PATCH(NEW.opts, JSON_OBJECT('adaptive_width', NEW.adaptive_width));
END IF;

    IF(IFNULL(NEW.bg_color <> OLD.bg_color, NOT (NEW.bg_color IS NULL AND OLD.bg_color IS NULL)))
    THEN
        SET NEW.opts = JSON_MERGE_PATCH(NEW.opts, JSON_OBJECT('bg_color', NEW.bg_color));
END IF;

    IF(IFNULL(NEW.border_color <> OLD.border_color, NOT (NEW.border_color IS NULL AND OLD.border_color IS NULL)))
    THEN
        SET NEW.opts = JSON_MERGE_PATCH(NEW.opts, JSON_OBJECT('border_color', NEW.border_color));
END IF;

    IF(IFNULL(NEW.border_radius <> OLD.border_radius, NOT (NEW.border_radius IS NULL AND OLD.border_radius IS NULL)))
    THEN
        SET NEW.opts = JSON_MERGE_PATCH(NEW.opts, JSON_OBJECT('border_radius', NEW.border_radius));
END IF;

    IF(IFNULL(NEW.border_type <> OLD.border_type, NOT (NEW.border_type IS NULL AND OLD.border_type IS NULL)))
    THEN
        SET NEW.opts = JSON_MERGE_PATCH(NEW.opts, JSON_OBJECT('border_type', NEW.border_type));
END IF;

    IF(IFNULL(NEW.callouts <> OLD.callouts, NOT (NEW.callouts IS NULL AND OLD.callouts IS NULL)))
    THEN
        SET NEW.opts = JSON_MERGE_PATCH(NEW.opts, JSON_OBJECT('callouts', NEW.callouts));
END IF;

    IF(IFNULL(NEW.favicon <> OLD.favicon, NOT (NEW.favicon IS NULL AND OLD.favicon IS NULL)))
    THEN
        SET NEW.opts = JSON_MERGE_PATCH(NEW.opts, JSON_OBJECT('favicon', NEW.favicon));
END IF;

    IF(IFNULL(NEW.font_family <> OLD.font_family, NOT (NEW.font_family IS NULL AND OLD.font_family IS NULL)))
    THEN
        SET NEW.opts = JSON_MERGE_PATCH(NEW.opts, JSON_OBJECT('font_family', NEW.font_family));
END IF;

    IF(IFNULL(NEW.font_size <> OLD.font_size, NOT (NEW.font_size IS NULL AND OLD.font_size IS NULL)))
    THEN
        SET NEW.opts = JSON_MERGE_PATCH(NEW.opts, JSON_OBJECT('font_size', NEW.font_size));
END IF;

    IF(IFNULL(NEW.header_bg_color <> OLD.header_bg_color, NOT (NEW.header_bg_color IS NULL AND OLD.header_bg_color IS NULL)))
    THEN
        SET NEW.opts = JSON_MERGE_PATCH(NEW.opts, JSON_OBJECT('header_bg_color', NEW.header_bg_color));
END IF;

    IF(IFNULL(NEW.hover_color <> OLD.hover_color, NOT (NEW.hover_color IS NULL AND OLD.hover_color IS NULL)))
    THEN
        SET NEW.opts = JSON_MERGE_PATCH(NEW.opts, JSON_OBJECT('hover_color', NEW.hover_color));
END IF;

    IF(IFNULL(NEW.is_custom_format_direct <> OLD.is_custom_format_direct, NOT (NEW.is_custom_format_direct IS NULL AND OLD.is_custom_format_direct IS NULL)))
    THEN
        SET NEW.opts = JSON_MERGE_PATCH(NEW.opts, JSON_OBJECT('is_custom_format_direct', NEW.is_custom_format_direct));
END IF;

    IF(IFNULL(NEW.limit <> OLD.limit, NOT (NEW.limit IS NULL AND OLD.limit IS NULL)))
    THEN
        SET NEW.opts = JSON_MERGE_PATCH(NEW.opts, JSON_OBJECT('limit', NEW.limit));
END IF;

    IF(IFNULL(NEW.links_underline <> OLD.links_underline, NOT (NEW.links_underline IS NULL AND OLD.links_underline IS NULL)))
    THEN
        SET NEW.opts = JSON_MERGE_PATCH(NEW.opts, JSON_OBJECT('links_underline', NEW.links_underline));
END IF;

    IF(IFNULL(NEW.no_sitelinks <> OLD.no_sitelinks, NOT (NEW.no_sitelinks IS NULL AND OLD.no_sitelinks IS NULL)))
    THEN
        SET NEW.opts = JSON_MERGE_PATCH(NEW.opts, JSON_OBJECT('no_sitelinks', NEW.no_sitelinks));
END IF;

    IF(IFNULL(NEW.site_bg_color <> OLD.site_bg_color, NOT (NEW.site_bg_color IS NULL AND OLD.site_bg_color IS NULL)))
    THEN
        SET NEW.opts = JSON_MERGE_PATCH(NEW.opts, JSON_OBJECT('site_bg_color', NEW.site_bg_color));
END IF;

    IF(IFNULL(NEW.sitelinks_color <> OLD.sitelinks_color, NOT (NEW.sitelinks_color IS NULL AND OLD.sitelinks_color IS NULL)))
    THEN
        SET NEW.opts = JSON_MERGE_PATCH(NEW.opts, JSON_OBJECT('sitelinks_color', NEW.sitelinks_color));
END IF;

    IF(IFNULL(NEW.text_color <> OLD.text_color, NOT (NEW.text_color IS NULL AND OLD.text_color IS NULL)))
    THEN
        SET NEW.opts = JSON_MERGE_PATCH(NEW.opts, JSON_OBJECT('text_color', NEW.text_color));
END IF;

    IF(IFNULL(NEW.title_color <> OLD.title_color, NOT (NEW.title_color IS NULL AND OLD.title_color IS NULL)))
    THEN
        SET NEW.opts = JSON_MERGE_PATCH(NEW.opts, JSON_OBJECT('title_color', NEW.title_color));
END IF;

    IF(IFNULL(NEW.title_font_size <> OLD.title_font_size, NOT (NEW.title_font_size IS NULL AND OLD.title_font_size IS NULL)))
    THEN
        SET NEW.opts = JSON_MERGE_PATCH(NEW.opts, JSON_OBJECT('title_font_size', NEW.title_font_size));
END IF;

    IF(IFNULL(NEW.url_background_color <> OLD.url_background_color, NOT (NEW.url_background_color IS NULL AND OLD.url_background_color IS NULL)))
    THEN
        SET NEW.opts = JSON_MERGE_PATCH(NEW.opts, JSON_OBJECT('url_background_color', NEW.url_background_color));
END IF;

    IF(IFNULL(NEW.url_color <> OLD.url_color, NOT (NEW.url_color IS NULL AND OLD.url_color IS NULL)))
    THEN
        SET NEW.opts = JSON_MERGE_PATCH(NEW.opts, JSON_OBJECT('url_color', NEW.url_color));
END IF;

    #from opts to fields

    IF (JSON_CONTAINS_PATH(NEW.opts, 'one', '$.adaptive_height') AND NEW.adaptive_height <> JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.adaptive_height')))
    THEN
        SET NEW.adaptive_height = IF(JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.adaptive_height')) = 'null', NULL, JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.adaptive_height')));
END IF;

    IF (JSON_CONTAINS_PATH(NEW.opts, 'one', '$.adaptive_width') AND NEW.adaptive_width <> JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.adaptive_width')))
    THEN
        SET NEW.adaptive_width = IF(JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.adaptive_width')) = 'null', NULL, JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.adaptive_width')));
END IF;

    IF (JSON_CONTAINS_PATH(NEW.opts, 'one', '$.bg_color') AND NEW.bg_color <> JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.bg_color')))
    THEN
        SET NEW.bg_color = IF(JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.bg_color')) = 'null', NULL, JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.bg_color')));
END IF;

    IF (JSON_CONTAINS_PATH(NEW.opts, 'one', '$.border_color') AND NEW.border_color <> JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.border_color')))
    THEN
        SET NEW.border_color = IF(JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.border_color')) = 'null', NULL, JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.border_color')));
END IF;

    IF (JSON_CONTAINS_PATH(NEW.opts, 'one', '$.border_radius') AND NEW.border_radius <> JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.border_radius')))
    THEN
        SET NEW.border_radius = IF(JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.border_radius')) = 'null', NULL, JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.border_radius')));
END IF;

    IF (JSON_CONTAINS_PATH(NEW.opts, 'one', '$.border_type') AND NEW.border_type <> JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.border_type')))
    THEN
        SET NEW.border_type = IF(JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.border_type')) = 'null', NULL, JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.border_type')));
END IF;

    IF (JSON_CONTAINS_PATH(NEW.opts, 'one', '$.callouts') AND NEW.callouts <> JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.callouts')))
    THEN
        SET NEW.callouts = IF(JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.callouts')) = 'null', NULL, JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.callouts')));
END IF;

    IF (JSON_CONTAINS_PATH(NEW.opts, 'one', '$.favicon') AND NEW.favicon <> JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.favicon')))
    THEN
        SET NEW.favicon = IF(JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.favicon')) = 'null', NULL, JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.favicon')));
END IF;

    IF (JSON_CONTAINS_PATH(NEW.opts, 'one', '$.font_family') AND NEW.font_family <> JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.font_family')))
    THEN
        SET NEW.font_family = IF(JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.font_family')) = 'null', NULL, JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.font_family')));
END IF;

    IF (JSON_CONTAINS_PATH(NEW.opts, 'one', '$.font_size') AND NEW.font_size <> JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.font_size')))
    THEN
        SET NEW.font_size = IF(JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.font_size')) = 'null', NULL, JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.font_size')));
END IF;

    IF (JSON_CONTAINS_PATH(NEW.opts, 'one', '$.header_bg_color') AND NEW.header_bg_color <> JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.header_bg_color')))
    THEN
        SET NEW.header_bg_color = IF(JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.header_bg_color')) = 'null', NULL, JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.header_bg_color')));
END IF;

    IF (JSON_CONTAINS_PATH(NEW.opts, 'one', '$.hover_color') AND NEW.hover_color <> JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.hover_color')))
    THEN
        SET NEW.hover_color = IF(JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.hover_color')) = 'null', NULL, JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.hover_color')));
END IF;

    IF (JSON_CONTAINS_PATH(NEW.opts, 'one', '$.is_custom_format_direct') AND NEW.is_custom_format_direct <> JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.is_custom_format_direct')))
    THEN
        SET NEW.is_custom_format_direct = IF(JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.is_custom_format_direct')) = 'null', NULL, JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.is_custom_format_direct')));
END IF;

    IF (JSON_CONTAINS_PATH(NEW.opts, 'one', '$.limit') AND NEW.limit <> JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.limit')))
    THEN
        SET NEW.limit = IF(JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.limit')) = 'null', NULL, JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.limit')));
END IF;

    IF (JSON_CONTAINS_PATH(NEW.opts, 'one', '$.links_underline') AND NEW.links_underline <> JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.links_underline')))
    THEN
        SET NEW.links_underline = IF(JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.links_underline')) = 'null', NULL, JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.links_underline')));
END IF;

    IF (JSON_CONTAINS_PATH(NEW.opts, 'one', '$.no_sitelinks') AND NEW.no_sitelinks <> JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.no_sitelinks')))
    THEN
        SET NEW.no_sitelinks = IF(JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.no_sitelinks')) = 'null', NULL, JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.no_sitelinks')));
END IF;

    IF (JSON_CONTAINS_PATH(NEW.opts, 'one', '$.site_bg_color') AND NEW.site_bg_color <> JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.site_bg_color')))
    THEN
        SET NEW.site_bg_color = IF(JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.site_bg_color')) = 'null', NULL, JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.site_bg_color')));
END IF;

    IF (JSON_CONTAINS_PATH(NEW.opts, 'one', '$.sitelinks_color') AND NEW.sitelinks_color <> JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.sitelinks_color')))
    THEN
        SET NEW.sitelinks_color = IF(JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.sitelinks_color')) = 'null', NULL, JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.sitelinks_color')));
END IF;

    IF (JSON_CONTAINS_PATH(NEW.opts, 'one', '$.text_color') AND NEW.text_color <> JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.text_color')))
    THEN
        SET NEW.text_color = IF(JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.text_color')) = 'null', NULL, JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.text_color')));
END IF;

    IF (JSON_CONTAINS_PATH(NEW.opts, 'one', '$.title_color') AND NEW.title_color <> JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.title_color')))
    THEN
        SET NEW.title_color = IF(JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.title_color')) = 'null', NULL, JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.title_color')));
END IF;

    IF (JSON_CONTAINS_PATH(NEW.opts, 'one', '$.title_font_size') AND NEW.title_font_size <> JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.title_font_size')))
    THEN
        SET NEW.title_font_size = IF(JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.title_font_size')) = 'null', NULL, JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.title_font_size')));
END IF;

    IF (JSON_CONTAINS_PATH(NEW.opts, 'one', '$.url_background_color') AND NEW.url_background_color <> JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.url_background_color')))
    THEN
        SET NEW.url_background_color = IF(JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.url_background_color')) = 'null', NULL, JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.url_background_color')));
END IF;

    IF (JSON_CONTAINS_PATH(NEW.opts, 'one', '$.url_color') AND NEW.url_color <> JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.url_color')))
    THEN
        SET NEW.url_color = IF(JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.url_color')) = 'null', NULL, JSON_UNQUOTE(JSON_EXTRACT(NEW.opts, '$.url_color')));
END IF;

END; $$
DELIMITER ;


DROP TRIGGER IF EXISTS `internal_mobile_rtb_action_log_insert`;
DELIMITER $$
CREATE TRIGGER internal_mobile_rtb_action_log_insert
    BEFORE INSERT
    ON internal_mobile_app_rtb_action_log
    FOR EACH ROW
BEGIN
    SET NEW.elem_campaign_id = IF(NEW.elem_campaign_id IS NULL, NEW.elem_application_id, NEW.elem_campaign_id);
    SET NEW.elem_application_id = IF(NEW.elem_application_id IS NULL, NEW.elem_campaign_id, NEW.elem_application_id);
END; $$
DELIMITER ;


UPDATE
    `internal_mobile_app_rtb_action_log`
SET
    `elem_campaign_id` = `elem_application_id`;


UPDATE
    `internal_mobile_app_rtb`
SET
    `campaign_id` = `application_id`,
    `opts` = JSON_MERGE_PATCH(JSON_OBJECT(
                                  'adaptive_height', `adaptive_height`,
                                  'adaptive_width', `adaptive_width`,
                                  'bg_color', `bg_color`,
                                  'border_color', `border_color`,
                                  'border_radius', `border_radius`,
                                  'border_type', `border_type`,
                                  'callouts', `callouts`,
                                  'favicon', `favicon`,
                                  'font_family', `font_family`,
                                  'font_size', `font_size`,
                                  'header_bg_color', `header_bg_color`,
                                  'hover_color', `hover_color`,
                                  'is_custom_format_direct', `is_custom_format_direct`,
                                  'limit', `limit`,
                                  'links_underline', `links_underline`,
                                  'no_sitelinks', `no_sitelinks`,
                                  'site_bg_color', `site_bg_color`,
                                  'sitelinks_color', `sitelinks_color`,
                                  'text_color', `text_color`,
                                  'title_color', `title_color`,
                                  'title_font_size', `title_font_size`,
                                  'url_background_color', `url_background_color`,
                                  'url_color', `url_color`),
                              `opts`
    );
