update
    internal_mobile_app_rtb
set
    opts = json_set(opts, '$.dsp_mode', 'force')
;

update
    internal_context_on_site_content
set
    opts = json_set(opts, '$.dsp_mode', 'force')
;

update
    context_on_site_natural
set
    opts = json_set(opts, '$.dsp_mode', 'force')
;

update
    internal_context_on_site_natural
set
    opts = json_set(opts, '$.dsp_mode', 'force')
;

update
    video_an_site_instream
set
    opts = json_set(opts, '$.dsp_mode', 'force')
;

update
    video_an_site_inpage
set
    opts = json_set(opts, '$.dsp_mode', 'force')
;

update
    video_an_site_fullscreen
set
    opts = json_set(opts, '$.dsp_mode', 'force')
;

drop procedure if exists UpdateContextOnSiteRtb;

DELIMITER //
CREATE PROCEDURE UpdateContextOnSiteRtb()
BEGIN
    DECLARE PAGE_ID INT DEFAULT 0;
    DECLARE BULKSIZE INT DEFAULT 3000;
    DECLARE STARTTIME DATETIME DEFAULT NOW();

    WHILE PAGE_ID <= 2000000 DO
        SET STARTTIME = NOW();

        update
            context_on_site_rtb
        set
            opts = json_set(opts, '$.dsp_mode', 'force')
        where
            campaign_id > PAGE_ID and campaign_id <= PAGE_ID + BULKSIZE
        ;

        SET PAGE_ID = PAGE_ID + BULKSIZE;
        SELECT TIMESTAMPDIFF(SECOND, STARTTIME, NOW());

    END WHILE;

END //

DELIMITER ;

call UpdateContextOnSiteRtb();
