#!/usr/bin/perl
use strict;
use warnings FATAL => 'all';

=head1 пример вызова

    perl -Ilib ./migrations/before_release/PI-29067-fix-geo-cpm.pl
=cut

use lib::abs qw(../../lib/);

use qbit;
use Utils::ScriptWrapper;

run(
    sub {
        my ($app, $opts) = @_;

        my $preset_list = $app->partner_db->block_presets->get_all(
            filter => [{json_unquote => [{json_extract => [settings => \'$.geo_group']}]}, 'LIKE', \"%\"cpm\": null%"],
            fields => [qw(id settings)],
        );

        for my $preset (@$preset_list) {
            print logstr('Start Update', 'data before:', $preset);
            print logstr('Update geo', $preset->{id});
            my $settings = from_json($preset->{settings});
            my $old_geo  = $settings->{geo_group}->{geo};
            my @new_geo;
            for my $geo_item (@$old_geo) {
                if ($geo_item->{cpm}) {
                    push @new_geo, $geo_item;
                }
            }

            $settings->{geo_group}->{geo} = \@new_geo;
            $app->partner_db->block_presets->edit($preset, {settings => to_json($settings)});
            print logstr('Stop Update', 'data after:',
                $app->partner_db->block_presets->get($preset, fields => [qw(settings)]));
        }
    }
   );
