#!/usr/bin/perl

=encoding UTF-8
=cut

use strict;
use warnings;
use utf8;

use lib::abs qw(
  ../../lib
  );
use qbit;
use Application;

my $app = Application->new();
$app->pre_run();

$app->set_cur_user({id => 0});

my $i      = 1;
my @tables = qw(
  context_on_site_rtb
  mobile_app_rtb
  context_on_site_direct
  search_on_site_direct
  internal_mobile_app_rtb
  internal_context_on_site_direct
  internal_search_on_site_direct
  );

foreach my $table (@tables) {

    warn sprintf("## table %s (%s/%s)\n", $table, $i, scalar(@tables));
    warn "\n";

    my $script = lib::abs::path('../../bin/pt-online-schema-change.pl');

    system($script, "--table=$table", "--alter=ADD COLUMN `url_background_color` VARCHAR(6) AFTER `url_color`");

    $app->partner_db->_do("ANALYZE TABLE `partner`.`$table`;");

    $i++;
}

print "#END\n";
