CREATE TEMPORARY TABLE `adfox_mobile_block_ids` (
    `campaign_id` INT UNSIGNED NOT NULL,
    `id` INT UNSIGNED NOT NULL,
    PRIMARY KEY (`campaign_id`, `id`)
);

INSERT INTO `adfox_mobile_block_ids` (`campaign_id`, `id`) VALUES
(161333, 8),
(28011, 11),
(31125, 25),
(31125, 26),
(52223, 27),
(52223, 29),
(52223, 31),
(52223, 28),
(60623, 2),
(69381, 26),
(69381, 25),
(69381, 37),
(69381, 33),
(71307, 7),
(81260, 11),
(81260, 13),
(85462, 9),
(111868, 7),
(111868, 6),
(111868, 8),
(111868, 4),
(121145, 63),
(121145, 65),
(121145, 64),
(124532, 31),
(125354, 4),
(126897, 5),
(127976, 8),
(129367, 2),
(129405, 6),
(138704, 11),
(144200, 10),
(144200, 3),
(144200, 9),
(144200, 8),
(144200, 11),
(144202, 3),
(144350, 26),
(146159, 13),
(146159, 12),
(146159, 9),
(146159, 11),
(146159, 8),
(146159, 10),
(146159, 15),
(147473, 25),
(147473, 26),
(161355, 1),
(148265, 15),
(149896, 2),
(153840, 19),
(153996, 8),
(153996, 2),
(153996, 6),
(153996, 9),
(153996, 3),
(159070, 1),
(159070, 3),
(159080, 3),
(159080, 1),
(163385, 2),
(163385, 7),
(163843, 1),
(164743, 21),
(164743, 24),
(164743, 22),
(164743, 25),
(164743, 23),
(169259, 19),
(172264, 5),
(175475, 2),
(183621, 3),
(183621, 38),
(183621, 9),
(183621, 17),
(183621, 49),
(183621, 28),
(184991, 9),
(184991, 10),
(185143, 1),
(188279, 13),
(188279, 12),
(188279, 15),
(191304, 6),
(191304, 1),
(191304, 5),
(198429, 5),
(198429, 1),
(204073, 4),
(204073, 6),
(204075, 3),
(204075, 5),
(204078, 4),
(204078, 6),
(204086, 4),
(208364, 3),
(208365, 3),
(208366, 3),
(208367, 4),
(221777, 2),
(221791, 2),
(223754, 3),
(223754, 2),
(223754, 4),
(223754, 5),
(224553, 9),
(224553, 3),
(224560, 4),
(235034, 1),
(237353, 2),
(241835, 1);

DELETE `m`
FROM `adfox_mobile_block_ids` as `m`
LEFT JOIN `context_on_site_adfox` as `a`
ON `m`.`campaign_id` = `a`.`campaign_id` AND `m`.`id` = `a`.`id`
WHERE `a`.`direct_block` IN (
    '1000x120',
    '160x600',
    '300x600',
    '300x500',
    '728x90',
    '970x250',
    '970x90'
)
OR `a`.`direct_block` = 'horizontal'       AND `a`.`limit` > 2
OR `a`.`direct_block` = 'vertical'         AND `a`.`limit` > 2
OR `a`.`direct_block` = 'posterHorizontal' AND `a`.`limit` > 1
OR `a`.`direct_block` = 'posterVertical'   AND `a`.`limit` > 1
;

UPDATE `adfox_mobile_block_ids` as `m` LEFT JOIN `adfox_old_new_block_ids` as `n`
ON `m`.`campaign_id` = `n`.`page_id` and `m`.`id` = `n`.`old_block_id`
SET `m`.`id` = `n`.`new_block_id`
WHERE `n`.`new_block_id` is not NULL;

INSERT IGNORE INTO `adfox_mobile_block_ids`
SELECT `campaign_id`, `id`
FROM `context_on_site_adfox`
WHERE `direct_block` in ('320x50', '320x100', 'extensibleMobile');

INSERT INTO `context_on_site_rtb` (
`campaign_id`,
`id`,
`caption`,
`direct_block`,
`media_block`,
`limit`,
`multistate`,
`articles`,
`geo`,
`mincpm`,
`border_radius`,
`border_type`,
`favicon`,
`images_first`,
`no_sitelinks`,
`links_underline`,
`site_bg_color`,
`bg_color`,
`border_color`,
`header_bg_color`,
`sitelinks_color`,
`title_color`,
`text_color`,
`url_color`,
`hover_color`,
`font_family`,
`font_size`,
`title_font_size`,
`blind`,
`comment`,
`strategy`,
`percent_traffic`,
`is_custom_bk_data`,
`adaptive_width`,
`adaptive_height`,
`bk_data`,
`media_active`,
`media_blocked`,
`media_cpm`,
`text_active`,
`text_blocked`,
`text_cpm`,
`has_adfox_deals`,
`private_auction`,
`adfox_site_name`,
`adfox_section_name`,
`adfox_banner_description`,
`is_custom_format_direct`,
`form_factor`,
`smart_media`,
`horizontal_align`,
`callouts`,
`create_date`,
`adaptive_type`,
`adfox_user_id`,
`adfox_block`,
`active`,
`alternative_code`,
`alt_width`,
`alt_height`,
`show_video`,
`duplicate_direct`,
`ex_direct`,
`site_version`
)
SELECT
`campaign_id`,
`id`,
`caption`,
`direct_block`,
`media_block`,
`limit`,
`multistate`,
`articles`,
`geo`,
`mincpm`,
`border_radius`,
`border_type`,
`favicon`,
`images_first`,
`no_sitelinks`,
`links_underline`,
`site_bg_color`,
`bg_color`,
`border_color`,
`header_bg_color`,
`sitelinks_color`,
`title_color`,
`text_color`,
`url_color`,
`hover_color`,
`font_family`,
`font_size`,
`title_font_size`,
`blind`,
`comment`,
`strategy`,
`percent_traffic`,
`is_custom_bk_data`,
`adaptive_width`,
`adaptive_height`,
`bk_data`,
`media_active`,
`media_blocked`,
`media_cpm`,
`text_active`,
`text_blocked`,
`text_cpm`,
`has_adfox_deals`,
`private_auction`,
`adfox_site_name`,
`adfox_section_name`,
`adfox_banner_description`,
`is_custom_format_direct`,
`form_factor`,
`smart_media`,
`horizontal_align`,
`callouts`,
`create_date`,
`adaptive_type`,
`adfox_user_id`,
1 as `adfox_block`,
1 as `active`,
"" as `alternative_code`,
NULL as `alt_width`,
NULL as `alt_height`,
0 as `show_video`,
0 as `duplicate_direct`,
0 as `ex_direct`,
"desktop" as `site_version`
FROM `context_on_site_adfox`;

UPDATE `context_on_site_rtb`
SET `site_version` = "mobile",
    `form_factor`  = NULL,
    `smart_media`  = NULL
WHERE (`campaign_id`, `id`) in (select `campaign_id`, `id` from `adfox_mobile_block_ids`);

UPDATE `context_on_site_rtb`
SET `limit` = NULL
WHERE (`campaign_id`, `id`) in (select `campaign_id`, `id` from `adfox_mobile_block_ids`)
  AND `direct_block` = "posterHorizontal" AND `limit` = 1;

/* https://st.yandex-team.ru/PI-10746#1510068839000 */
UPDATE `context_on_site_rtb`
SET `images_first` = CASE
    WHEN `direct_block`     IN ("posterHorizontal", "posterVertical", "extensibleMobile") AND `images_first` IS NOT NULL THEN NULL
    WHEN `direct_block` NOT IN ("posterHorizontal", "posterVertical", "extensibleMobile") AND `images_first` IS     NULL THEN 0
    ELSE `images_first`
    END
WHERE (`campaign_id`, `id`) in (select `campaign_id`, `id` from `context_on_site_adfox`);


INSERT INTO `context_on_site_dsps` (
`campaign_id`,
`block_id`,
`dsp_id`,
`is_deleted`
)
SELECT
`campaign_id`,
`block_id`,
`dsp_id`,
`is_deleted`
FROM `context_on_site_adfox_dsps`;

INSERT INTO `context_on_site_rtb_dsp_blocks` (
`campaign_id`,
`block_id`,
`type`
)
SELECT
`campaign_id`,
`block_id`,
`type`
FROM `context_on_site_adfox_dsp_blocks`;

INSERT INTO `context_on_site_rtb_action_log` (
`dt`,
`user_id`,
`elem_campaign_id`,
`elem_id`,
`old_multistate`,
`action`,
`new_multistate`,
`opts`,
`comment`
)
SELECT
`dt`,
`user_id`,
`elem_campaign_id`,
`elem_id`,
`old_multistate`,
`action`,
`new_multistate`,
`opts`,
`comment`
FROM `context_on_site_adfox_action_log`;


/* Reports */
CREATE TABLE `statistics_reports__before_adfox_migration` LIKE `statistics_reports`;

INSERT INTO `statistics_reports__before_adfox_migration` (
`id`,
`report_id`,
`caption_en`,
`caption_ru`,
`description`,
`level`,
`query`,
`owner_id`,
`not_show`,
`multistate`
)
SELECT
`id`,
`report_id`,
`caption_en`,
`caption_ru`,
`description`,
`level`,
`query`,
`owner_id`,
`not_show`,
`multistate`
FROM `statistics_reports`;

CREATE TABLE `statistics_reports_action_log__before_adfox_migration` LIKE `statistics_reports_action_log`;

INSERT INTO `statistics_reports_action_log__before_adfox_migration` (
`id`,
`dt`,
`user_id`,
`elem_id`,
`old_multistate`,
`action`,
`new_multistate`,
`opts`,
`comment`
)
SELECT
`id`,
`dt`,
`user_id`,
`elem_id`,
`old_multistate`,
`action`,
`new_multistate`,
`opts`,
`comment`
FROM `statistics_reports_action_log`;

CREATE TABLE `deleted_standart_statistics_reports__before_adfox_migration` LIKE `deleted_standart_statistics_reports`;

INSERT INTO `deleted_standart_statistics_reports__before_adfox_migration` (
`user_id`,
`report_id`
)
SELECT
`user_id`,
`report_id`
FROM `deleted_standart_statistics_reports`;

CREATE TABLE `event_log__before_adfox_migration` LIKE `event_log`;

INSERT INTO `event_log__before_adfox_migration` (
`id`,
`multistate`,
`date`,
`create_dt`,
`create_user_id`,
`description`,
`level`,
`element`,
`type_id`,
`pi_id`,
`class_id`
)
SELECT
`id`,
`multistate`,
`date`,
`create_dt`,
`create_user_id`,
`description`,
`level`,
`element`,
`type_id`,
`pi_id`,
`class_id`
FROM `event_log`;

CREATE TABLE `event_log_action_log__before_adfox_migration` LIKE `event_log_action_log`;

INSERT INTO `event_log_action_log__before_adfox_migration` (
`id`,
`dt`,
`user_id`,
`elem_id`,
`old_multistate`,
`action`,
`new_multistate`,
`opts`,
`comment`
)
SELECT
`id`,
`dt`,
`user_id`,
`elem_id`,
`old_multistate`,
`action`,
`new_multistate`,
`opts`,
`comment`
FROM `event_log_action_log`;

CREATE TABLE `widgets__before_adfox_migration` LIKE `widgets`;

INSERT INTO `widgets__before_adfox_migration` (
`user_id`,
`json_widgets_settings`,
`json_default_deleted_ids`,
`multistate`
)
SELECT
`user_id`,
`json_widgets_settings`,
`json_default_deleted_ids`,
`multistate`
FROM `widgets`;

CREATE TABLE `widgets_action_log__before_adfox_migration` LIKE `widgets_action_log`;

INSERT INTO `widgets_action_log__before_adfox_migration` (
`id`,
`dt`,
`user_id`,
`elem_user_id`,
`old_multistate`,
`action`,
`new_multistate`,
`opts`,
`comment`
)
SELECT
`id`,
`dt`,
`user_id`,
`elem_user_id`,
`old_multistate`,
`action`,
`new_multistate`,
`opts`,
`comment`
FROM `widgets_action_log`;

CREATE TABLE `stat_report_params_digest__before_adfox_migration` LIKE `stat_report_params_digest`;

INSERT INTO `stat_report_params_digest__before_adfox_migration` (
`id`,
`params`
)
SELECT
`id`,
`params`
FROM `stat_report_params_digest`;

drop table `stored_stat_report`;
drop table `deleted_standard_reports`;
