#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION

Скрипт выставляет флаг need_update во всех моделях на всех пейджах которые working/testing и не read_only, и не protected, и не SSP.

Для работы скрипта нужно подключить продакшн базу. Никаке другие продакшн системы подключать не нужно.

=cut

# common modules
use feature 'say';
use Carp;

# project modules
use lib::abs qw(
    ../../lib
);
use qbit;
use Application;
use Term::ProgressBar;

# global vars

# subs

# main
sub main {
    my $app = Application->new();
    $app->pre_run();

    my $yndx_bessarabov_user_id = 155209804;
    $app->set_cur_user({id => $yndx_bessarabov_user_id});

    my @page_models = grep {blessed($app->{$_}) && $app->$_->isa('Application::Model::Page')} sort keys(%$app);

    foreach my $model (@page_models) {

        next if $model =~ /ssp/;

        warn sprintf "## %s\n", $model;

        my %multistate_bits = map { $_->[0] => 1 } @{ $app->$model->get_multistates_bits(); };

        my $filter = '(working or testing) and not need_update';

        if ($multistate_bits{protected}) {
            $filter .= ' and not protected'
        }

        if ($multistate_bits{read_only}) {
            $filter .= ' and not read_only'
        }

        my $data = $app->$model->get_all(
            filter => {
                multistate => $filter,
            },
        );

        warn 'Number of Page IDs to update: ' . scalar(@$data) . "\n";

        my $tp = Term::ProgressBar->new ({
            count => scalar(@$data),
            ETA   => 'linear',
        });

        my $i = 0;
        foreach my $el (@$data) {
            $app->$model->do_action($el, 'set_need_update');
            $i++;
            $tp->update($i);
        }
    }

    $app->post_run();
    say "#END";
}
main();
__END__
