CREATE TABLE IF NOT EXISTS `business_rules` (
    `rule_id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `owner_id` BIGINT UNSIGNED NOT NULL,
    `caption` VARCHAR(255) NOT NULL DEFAULT '',
    `cpm` INT UNSIGNED NOT NULL,
    `conditions` TEXT NOT NULL,
    `multistate` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `position` INT UNSIGNED NOT NULL,
    `create_date` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
    `update_time` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
    `send_time` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
    PRIMARY KEY (`rule_id`),
    FOREIGN KEY `fk_business_rules__owner_id___users__id` (`owner_id`)
        REFERENCES `users` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8';


CREATE TABLE IF NOT EXISTS `business_rules_action_log` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `dt` DATETIME NOT NULL,
    `user_id` BIGINT UNSIGNED NOT NULL,
    `elem_rule_id` BIGINT UNSIGNED NOT NULL,
    `old_multistate` BIGINT UNSIGNED NOT NULL,
    `action` VARCHAR(100) NOT NULL,
    `new_multistate` BIGINT UNSIGNED NOT NULL,
    `opts` TEXT NOT NULL,
    `comment` VARCHAR(100) NOT NULL DEFAULT '',
    PRIMARY KEY (`id`),
    INDEX `business_rules_action_log__dt_elem_rule_id_action` (`dt`, `elem_rule_id`, `action`),
    INDEX `business_rules_action_log__elem_rule_id_action` (`elem_rule_id`, `action`),
    FOREIGN KEY `fk_business_rules_action_log__user_id___users__id` (`user_id`)
        REFERENCES `users` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_business_rules_action_log__elem_rule_id___business_rules__ru` (`elem_rule_id`)
        REFERENCES `business_rules` (`rule_id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8';



CREATE TABLE IF NOT EXISTS `business_blocks` (
    `rule_id` BIGINT UNSIGNED NOT NULL,
    `page_id` INT UNSIGNED NOT NULL,
    `block_id` INT UNSIGNED NOT NULL,
    `block_accessor` VARCHAR(255) NOT NULL,
    PRIMARY KEY (`rule_id`, `page_id`, `block_id`),
    FOREIGN KEY `fk_business_blocks__rule_id___business_rules__rule_id` (`rule_id`)
        REFERENCES `business_rules` (`rule_id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8';


