#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION

Для работы скрипта нужно подключить продакшн базу.
Никаке другие продакшн системы подключать не нужно.

=cut

# common modules
use feature 'say';
use Carp;

# project modules
use lib::abs qw(
  ../../lib
  );
use qbit;
use Application;

# global vars

my $INTERNAL_WEB_DSPS = [];

my $INTERNAL_MOBILE_DSPS = [];

# subs

# main
sub main {
    my $app = Application->new();
    $app->pre_run();

    $app->set_cur_user({id => 0});

    {
        no warnings 'redefine';
        *QBit::Application::check_rights = sub {1};
    }

    my $iternal_dsps =
      $app->dsp->get_all(fields => [qw(id types)], filter => {tag => ['yabs', 'awaps', 'local', 'dc_dsp_test']});
    foreach my $dsp (@$iternal_dsps) {
        if (in_array(0, $dsp->{'types'})) {
            push(@$INTERNAL_WEB_DSPS, $dsp->{'id'});
        }

        if (in_array(2, $dsp->{'types'})) {
            push(@$INTERNAL_MOBILE_DSPS, $dsp->{'id'});
        }
    }

    my $dsps = $app->dsp->get_all(
        fields => [qw(id multistate)],
        filter => [
            'AND',
            [
                ['id', 'NOT IN', [@$INTERNAL_WEB_DSPS, @$INTERNAL_MOBILE_DSPS]],
                {multistate => 'working_on_yandex_services'}
            ]
        ]
    );

    foreach my $dsp (@$dsps) {
        $app->dsp->do_action($dsp, 'stop_on_yandex_services');
    }

    _remove_dsps($app, 'internal_context_on_site_rtb', $INTERNAL_WEB_DSPS);

    _remove_dsps($app, 'internal_mobile_app_rtb', $INTERNAL_MOBILE_DSPS);

    say '#END';
}

sub _remove_dsps {
    my ($app, $model, $dsps) = @_;

    say "MODEL: $model";

    my $dsp_table = $model;
    $dsp_table =~ s/rtb/dsps/;

    my $page_model         = $app->$model->get_campaign_model_name();
    my $page_id_field_name = $app->$model->get_page_id_field_name();

    my %dsps = map {$_ => TRUE} @$dsps;

    my $blocks = $app->$model->get_all(fields => [qw(public_id page_id id internal_campaign_id dsps editable_fields)]);

    foreach my $block (@$blocks) {
        my @new_dsps = grep {$dsps{$_}} @{$block->{'dsps'}};

        if (@new_dsps != @{$block->{'dsps'}}) {
            @new_dsps = (1) unless @new_dsps;

            my $msg = to_json($block);

            if ($block->{'editable_fields'}{'dsps'}) {
                $msg .= ' do_action';
                try {
                    $app->$model->do_action($block->{'public_id'}, 'edit', 'dsps' => \@new_dsps);

                    $msg .= ' - OK';
                }
                catch {
                    $msg .= ' - ERROR ' . shift->message();
                };
            } else {
                $msg .= ' db';
                try {
                    $app->partner_db->$dsp_table->delete(
                        $app->partner_db->filter(
                            [
                                'AND',
                                [
                                    [$page_id_field_name, '=',      \$block->{'page_id'}],
                                    ['block_id',          '=',      \$block->{'id'}],
                                    ['dsp_id',            'NOT IN', \\@new_dsps]
                                ]
                            ]
                        )
                    );

                    $app->$page_model->do_action($block->{'internal_campaign_id'}, 'set_need_update');

                    $msg .= ' - OK';
                }
                catch {
                    $msg .= ' - ERROR ' . shift->message();
                };
            }

            say $msg;
        }
    }
}

main();

__END__
