CREATE TABLE IF NOT EXISTS `indoor` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `page_id` INT UNSIGNED DEFAULT NULL,
    `owner_id` BIGINT UNSIGNED NOT NULL,
    `opts` JSON NOT NULL,
    `caption` VARCHAR(255) GENERATED ALWAYS AS (opts->>"$.caption") VIRTUAL NOT NULL,
    `domain` VARCHAR(255) GENERATED ALWAYS AS (opts->>"$.domain") VIRTUAL NOT NULL,
    `multistate` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `create_date` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
    `update_time` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
    `send_time` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
    PRIMARY KEY (`id`),
    UNIQUE INDEX `uniq_indoor__page_id` (`page_id`),
    FOREIGN KEY `fk_indoor__owner_id___users__id` (`owner_id`)
        REFERENCES `users` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8';

CREATE TABLE IF NOT EXISTS `indoor_action_log` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `dt` DATETIME NOT NULL,
    `user_id` BIGINT UNSIGNED NOT NULL,
    `elem_id` BIGINT UNSIGNED NOT NULL,
    `old_multistate` BIGINT UNSIGNED NOT NULL,
    `action` VARCHAR(100) NOT NULL,
    `new_multistate` BIGINT UNSIGNED NOT NULL,
    `opts` TEXT NOT NULL,
    `comment` VARCHAR(100) NOT NULL DEFAULT '',
    PRIMARY KEY (`id`),
    INDEX `indoor_action_log__dt_elem_id_action` (`dt`, `elem_id`, `action`),
    INDEX `indoor_action_log__elem_id_action` (`elem_id`, `action`),
    FOREIGN KEY `fk_indoor_action_log__user_id___users__id` (`user_id`)
        REFERENCES `users` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_indoor_action_log__elem_id___indoor__id` (`elem_id`)
        REFERENCES `indoor` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8';

CREATE TABLE IF NOT EXISTS `indoor_block_seq` (
    `page_id` INT UNSIGNED,
    `next_block_id` INT UNSIGNED NOT NULL,
    PRIMARY KEY (`page_id`),
    FOREIGN KEY `fk_indoor_block_seq__page_id___indoor__page_id` (`page_id`)
        REFERENCES `indoor` (`page_id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8';

CREATE TABLE IF NOT EXISTS `indoor_block` (
    `page_id` INT UNSIGNED,
    `id` INT UNSIGNED NOT NULL,
    `opts` JSON NOT NULL,
    `caption` VARCHAR(255) GENERATED ALWAYS AS (opts->>"$.caption") VIRTUAL NOT NULL,
    `resolution` VARCHAR(9) GENERATED ALWAYS AS (opts->>"$.resolution") VIRTUAL NOT NULL,
    `touch_screen` BOOLEAN GENERATED ALWAYS AS (opts->>"$.touch_screen") VIRTUAL NOT NULL,
    `sound` BOOLEAN GENERATED ALWAYS AS (opts->>"$.sound") VIRTUAL NOT NULL,
    `zone_category` TINYINT GENERATED ALWAYS AS (opts->>"$.zone_category") VIRTUAL NOT NULL,
    `multistate` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `create_date` DATETIME NOT NULL,
    `start_time` SMALLINT UNSIGNED,
    `is_custom_bk_data` BOOLEAN NOT NULL DEFAULT '0',
    `bk_data` MEDIUMTEXT,
    PRIMARY KEY (`page_id`, `id`),
    INDEX `indoor_block__multistate` (`multistate`),
    INDEX `indoor_block__id` (`id`),
    FOREIGN KEY `fk_indoor_block__page_id___indoor__page_id` (`page_id`)
        REFERENCES `indoor` (`page_id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8';

CREATE TABLE IF NOT EXISTS `indoor_block_action_log` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `dt` DATETIME NOT NULL,
    `user_id` BIGINT UNSIGNED NOT NULL,
    `elem_page_id` INT UNSIGNED NOT NULL,
    `elem_id` INT UNSIGNED NOT NULL,
    `old_multistate` BIGINT UNSIGNED NOT NULL,
    `action` VARCHAR(100) NOT NULL,
    `new_multistate` BIGINT UNSIGNED NOT NULL,
    `opts` TEXT NOT NULL,
    `comment` VARCHAR(100) NOT NULL DEFAULT '',
    PRIMARY KEY (`id`),
    INDEX `indoor_block_action_log__dt_elem_page_id_elem_id_action` (`dt`, `elem_page_id`, `elem_id`, `action`),
    INDEX `indoor_block_action_log__elem_page_id_elem_id_action` (`elem_page_id`, `elem_id`, `action`),
    FOREIGN KEY `fk_indoor_block_action_log__user_id___users__id` (`user_id`)
        REFERENCES `users` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_indoor_block_action_log__elem_page_id_elem_id___indoor_block` (`elem_page_id`, `elem_id`)
        REFERENCES `indoor_block` (`page_id`, `id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8';

CREATE OR REPLACE
DEFINER = 'root'@'localhost'     -- setting 'definer' to another user requires SUPER privilege
SQL SECURITY INVOKER
VIEW `all_pages_view` (
    `id`,
    `model`,
    `page_id`,
    `caption`,
    `domain_id`,
    `domain`,

    `is_internal`,
    `is_working`,
    `is_stopped`,
    `is_deleted`,
    `is_readonly`,
    `is_blocked`,
    `is_rejected`,
    `is_protected`,

    `product_type`,
    `owner_id`,
    `login`,
    `client_id`,
    `business_unit`
    ) AS
        SELECT
            page.id                        AS `id`,
            'context_on_site_campaign'     AS `model`,
            page.page_id                   AS `page_id`,
            page.caption                   AS `caption`,
            page.domain_id                 AS `domain_id`,
            site.domain                    AS `domain`,

            '0'                            AS `is_internal`,
            if(page.multistate & 1, 1, 0)  AS `is_working`,
            if(page.multistate & 4, 1, 0)  AS `is_stopped`,
            if(page.multistate & 8, 1, 0)  AS `is_deleted`,
            if(page.multistate & 32, 1, 0) AS `is_readonly`,
            if(page.multistate & 128, 1, 0) AS `is_blocked`,
            if(page.multistate & 512, 1, 0) AS `is_rejected`,
            if(page.multistate & 1024, 1, 0) AS `is_protected`,

            'context'                      AS `product_type`,
            users.id                       AS `owner_id`,
            users.login                    AS `login`,
            users.client_id                AS `client_id`,
            users.business_unit            AS `business_unit`
        FROM `context_on_site_campaign` page
            JOIN site    ON site.id  = page.domain_id
            JOIN users   ON users.id = page.owner_id

     UNION ALL
        SELECT
            page.id                        AS `id`,
            'search_on_site_campaign'      AS `model`,
            page.page_id                   AS `page_id`,
            page.caption                   AS `caption`,
            page.domain_id                 AS `domain_id`,
            site.domain                    AS `domain`,

            '0'                            AS `is_internal`,
            if(page.multistate & 1, 1, 0)  AS `is_working`,
            if(page.multistate & 4, 1, 0)  AS `is_stopped`,
            if(page.multistate & 8, 1, 0)  AS `is_deleted`,
            if(page.multistate & 32, 1, 0) AS `is_readonly`,
            if(page.multistate & 128, 1, 0) AS `is_blocked`,
            if(page.multistate & 512, 1, 0) AS `is_rejected`,
            if(page.multistate & 1024, 1, 0) AS `is_protected`,

            'search'                       AS `product_type`,
            users.id                       AS `owner_id`,
            users.login                    AS `login`,
            users.client_id                AS `client_id`,
            users.business_unit            AS `business_unit`
        FROM `search_on_site_campaign` page
            JOIN site    ON site.id  = page.domain_id
            JOIN users   ON users.id = page.owner_id

     UNION ALL
        SELECT
            page.id                        AS `id`,
            'mobile_app_settings'          AS `model`,
            page.context_page_id           AS `page_id`,
            page.caption                   AS `caption`,
            page.application_id            AS `domain_id`,
            app.store_id                   AS `domain`,

            '0'                            AS `is_internal`,
            if(page.multistate & 1, 1, 0)  AS `is_working`,
            if(page.multistate & 4, 1, 0)  AS `is_stopped`,
            if(page.multistate & 8, 1, 0)  AS `is_deleted`,
            0                              AS `is_readonly`,
            if(page.multistate & 128, 1, 0) AS `is_blocked`,
            if(page.multistate & 4096, 1, 0) AS `is_rejected`,
            if(page.multistate & 256, 1, 0) AS `is_protected`,

            'mobile'                       AS `product_type`,
            users.id                       AS `owner_id`,
            users.login                    AS `login`,
            users.client_id                AS `client_id`,
            users.business_unit            AS `business_unit`
        FROM `mobile_app_settings` page
            JOIN mobile_app app ON app.id   = page.application_id
            JOIN users          ON users.id = page.`owner_id`

     UNION ALL
        SELECT
            page.id                        AS `id`,
            'video_an_site'                AS `model`,
            page.id                        AS `page_id`,
            page.caption                   AS `caption`,
            page.id                        AS `domain_id`,
            page.domain                    AS `domain`,

            '0'                            AS `is_internal`,
            if(page.multistate & 1, 1, 0)  AS `is_working`,
            if(page.multistate & 4, 1, 0)  AS `is_stopped`,
            if(page.multistate & 8, 1, 0)  AS `is_deleted`,
            0                              AS `is_readonly`,
            0                              AS `is_blocked`,
            0                              AS `is_rejected`,
            if(page.multistate & 32, 1, 0) AS `is_protected`,

            'video'                        AS `product_type`,
            users.id                       AS `owner_id`,
            users.login                    AS `login`,
            users.client_id                AS `client_id`,
            users.business_unit            AS `business_unit`
        FROM `video_an_site` page
            JOIN `users` ON users.`id` = page.`owner_id`

     UNION ALL
        SELECT
            page.id                        AS `id`,
            'indoor'                       AS `model`,
            page.page_id                   AS `page_id`,
            page.caption                   AS `caption`,
            page.id                        AS `domain_id`,
            page.domain                    AS `domain`,

            '0'                            AS `is_internal`,
            if(page.multistate & 1, 1, 0)  AS `is_working`,
            if(page.multistate & 2, 1, 0)  AS `is_stopped`,
            if(page.multistate & 4, 1, 0)  AS `is_deleted`,
            if(page.multistate & 32, 1, 0) AS `is_readonly`,
            0                              AS `is_blocked`,
            0                              AS `is_rejected`,
            if(page.multistate & 64, 1, 0) AS `is_protected`,

            'indoor'                       AS `product_type`,
            users.id                       AS `owner_id`,
            users.login                    AS `login`,
            users.client_id                AS `client_id`,
            users.business_unit            AS `business_unit`
        FROM `indoor` page
            JOIN users   ON users.id = page.owner_id

     UNION ALL
        SELECT
            page.id                        AS `id`,
            'internal_context_on_site_campaign' AS `model`,
            page.id                        AS `page_id`,
            site.domain                    AS `caption`,
            page.site_id                   AS `domain_id`,
            site.domain                    AS `domain`,

            '1'                            AS `is_internal`,
            if(page.multistate & 1, 1, 0)  AS `is_working`,
            if(page.multistate & 4, 1, 0)  AS `is_stopped`,
            if(page.multistate & 8, 1, 0)  AS `is_deleted`,
            if(page.multistate & 32, 1, 0) AS `is_readonly`,
            0                              AS `is_blocked`,
            0                              AS `is_rejected`,
            if(page.multistate & 128, 1, 0) AS `is_protected`,

            'context'                      AS `product_type`,
            '54519301'                     AS `owner_id`,
            'adinside'                     AS `login`,
            '944028'                       AS `client_id`,
            '0'                            AS `business_unit`
        FROM `internal_context_on_site_campaign` page
            JOIN internal_site site ON site.id = page.site_id

     UNION ALL
        SELECT
            page.id                        AS `id`,
            'internal_search_on_site_campaign' AS `model`,
            page.id                        AS `page_id`,
            site.domain                    AS `caption`,
            page.site_id                   AS `domain_id`,
            site.domain                    AS `domain`,

            '1'                            AS `is_internal`,
            if(page.multistate & 1, 1, 0)  AS `is_working`,
            if(page.multistate & 4, 1, 0)  AS `is_stopped`,
            if(page.multistate & 8, 1, 0)  AS `is_deleted`,
            if(page.multistate & 32, 1, 0) AS `is_readonly`,
            0                              AS `is_blocked`,
            0                              AS `is_rejected`,
            if(page.multistate & 128, 1, 0) AS `is_protected`,

            'search'                       AS `product_type`,
            '54519301'                     AS `owner_id`,
            'adinside'                     AS `login`,
            '944028'                       AS `client_id`,
            '0'                            AS `business_unit`
        FROM `internal_search_on_site_campaign` page
            JOIN internal_site site ON site.id = page.site_id

     UNION ALL
        SELECT
            page.id                        AS `id`,
            'internal_mobile_app'          AS `model`,
            page.id                        AS `page_id`,
            page.caption                   AS `caption`,
            page.id                        AS `domain_id`,
            page.store_id                  AS `domain`,

            '1'                            AS `is_internal`,
            if(page.multistate & 1, 1, 0)  AS `is_working`,
            if(page.multistate & 4, 1, 0)  AS `is_stopped`,
            if(page.multistate & 8, 1, 0)  AS `is_deleted`,
            0                              AS `is_readonly`,
            0                              AS `is_blocked`,
            0                              AS `is_rejected`,
            if(page.multistate & 32, 1, 0) AS `is_protected`,

            'mobile'                       AS `product_type`,
            '54519301'                     AS `owner_id`,
            'adinside'                     AS `login`,
            '944028'                       AS `client_id`,
            '0'                            AS `business_unit`
        FROM `internal_mobile_app` page
     UNION ALL
        SELECT
            page.id                        AS `id`,
            'ssp_mobile_app_settings'      AS `model`,
            page.page_id                   AS `page_id`,
            app.bundle_id                  AS `caption`,
            app.id                         AS `domain_id`,
            app.bundle_id                  AS `domain`,

            '0'                            AS `is_internal`,
            if(page.multistate & 1, 1, 0)  AS `is_working`,
            if(page.multistate & 4, 1, 0)  AS `is_stopped`,
            if(page.multistate & 8, 1, 0)  AS `is_deleted`,
            if(page.multistate & 32, 1, 0) AS `is_readonly`,
            if(page.multistate & 128, 1, 0) AS `is_blocked`,
            if(page.multistate & 512, 1, 0) AS `is_rejected`,
            if(page.multistate & 1024, 1, 0) AS `is_protected`,

            'mobile'                       AS `product_type`,
            users.id                       AS `owner_id`,
            users.login                    AS `login`,
            seller.client_id               AS `client_id`,
            '0'                            AS `business_unit`
        FROM `ssp_mobile_app_settings` page
            JOIN ssp_link_mobile_app AS link   ON link.mobile_app_id = page.id
            JOIN ssp_application     AS app    ON app.id = link.application_id
            JOIN ssp_seller          AS seller ON seller.id = link.seller_id
            JOIN users                         ON users.client_id = seller.client_id

     UNION ALL
        SELECT
            page.id                        AS `id`,
            'ssp_context_on_site_campaign' AS `model`,
            page.page_id                   AS `page_id`,
            site.domain                    AS `caption`,
            site.id                        AS `domain_id`,
            site.domain                    AS `domain`,

            '0'                            AS `is_internal`,
            if(page.multistate & 1, 1, 0)  AS `is_working`,
            if(page.multistate & 4, 1, 0)  AS `is_stopped`,
            if(page.multistate & 8, 1, 0)  AS `is_deleted`,
            if(page.multistate & 32, 1, 0) AS `is_readonly`,
            if(page.multistate & 128, 1, 0) AS `is_blocked`,
            if(page.multistate & 512, 1, 0) AS `is_rejected`,
            if(page.multistate & 1024, 1, 0) AS `is_protected`,

            'context'                      AS `product_type`,
            users.id                       AS `owner_id`,
            users.login                    AS `login`,
            seller.client_id               AS `client_id`,
            '0'                            AS `business_unit`
        FROM `ssp_context_on_site_campaign` page
            JOIN ssp_link_context_rtb AS link   ON link.context_rtb_id = page.id
            JOIN ssp_site             AS site   ON site.id = link.site_id
            JOIN ssp_seller           AS seller ON seller.id = link.seller_id
            JOIN users                          ON users.client_id = seller.client_id

     UNION ALL
        SELECT
            page.id                        AS `id`,
            'ssp_video_an_site'            AS `model`,
            page.page_id                   AS `page_id`,
            app.bundle_id                  AS `caption`,
            app.id                         AS `domain_id`,
            app.bundle_id                  AS `domain`,

            '0'                            AS `is_internal`,
            if(page.multistate & 1, 1, 0)  AS `is_working`,
            if(page.multistate & 4, 1, 0)  AS `is_stopped`,
            if(page.multistate & 8, 1, 0)  AS `is_deleted`,
            if(page.multistate & 32, 1, 0) AS `is_readonly`,
            if(page.multistate & 128, 1, 0) AS `is_blocked`,
            if(page.multistate & 512, 1, 0) AS `is_rejected`,
            if(page.multistate & 1024, 1, 0) AS `is_protected`,

            'video'                        AS `product_type`,
            users.id                       AS `owner_id`,
            users.login                    AS `login`,
            users.client_id                AS `client_id`,
            '0'                            AS `business_unit`
        FROM `ssp_video_an_site` page
            JOIN ssp_link_video_app  AS link   ON link.video_app_id = page.id
            JOIN ssp_application     AS app    ON app.id = link.application_id
            JOIN ssp_seller          AS seller ON seller.id = link.seller_id
            JOIN users                         ON users.client_id = seller.client_id

    ;
