#!/bin/bash

export YT_HOME=$HOME

export YT_TOKEN=`cat ~/.yt/robot_token`

set -e
set -x

################## Constants

YT_META_CLUSTER='pythia'
YT_REPLICA_CLUSTER_1='freud'
YT_REPLICA_CLUSTER_2='hume'

YT_PROJECT_PATH='//home/partner'

YT_TABLE_PATH="${YT_PROJECT_PATH}/business_rules_dict"
YT_TABLE_SCHEMA='[{name=id;sort_order=ascending;type=uint64};{name=caption;type=string};{name=update_time;type=string}]'


# Удаляем старый business_rules_dict
yt remove $YT_TABLE_PATH --proxy $YT_REPLICA_CLUSTER_1 2>/dev/null || true
yt remove $YT_TABLE_PATH --proxy $YT_REPLICA_CLUSTER_2 2>/dev/null || true
yt remove $YT_TABLE_PATH --proxy $YT_META_CLUSTER      2>/dev/null || true

# Смотрим что осталось
yt list $YT_PROJECT_PATH --proxy $YT_REPLICA_CLUSTER_1
yt list $YT_PROJECT_PATH --proxy $YT_REPLICA_CLUSTER_2
yt list $YT_PROJECT_PATH --proxy $YT_META_CLUSTER

################## заводим таблицы
REPLICATED_TABLE_ID=$(\
    yt create replicated_table $YT_TABLE_PATH --attr "{
      dynamic=%true;
      schema=$YT_TABLE_SCHEMA
    }"  --proxy $YT_META_CLUSTER
); echo $REPLICATED_TABLE_ID


# Создаем реплику, смотрящую на кластер Freud
REPLICA_ID_ClUSTER_1=$( \
    yt create table_replica --attr "{
        table_path=\"$YT_TABLE_PATH\";
        cluster_name=$YT_REPLICA_CLUSTER_1;
        replica_path=\"$YT_TABLE_PATH\"
    }" --proxy $YT_META_CLUSTER
); echo $REPLICA_ID_ClUSTER_1

# Вторую реплику заведем на кластере Hume
REPLICA_ID_ClUSTER_2=$( \
    yt create table_replica --attr "{
        table_path=\"$YT_TABLE_PATH\";
        cluster_name=$YT_REPLICA_CLUSTER_2;
        replica_path=\"$YT_TABLE_PATH\"
    }" --proxy $YT_META_CLUSTER
); echo $REPLICA_ID_ClUSTER_2


# Теперь заведем на Freud саму таблицу-реплику.
TABLE_ID_1=$( \
    yt create table $YT_TABLE_PATH --attr "{
       dynamic=%true;
       upstream_replica_id=\"$REPLICA_ID_ClUSTER_1\";
       schema=$YT_TABLE_SCHEMA
    }" --proxy $YT_REPLICA_CLUSTER_1
); echo $TABLE_ID_1


# И аналогично сделаем таблицу-реплику на Hume.
# Теперь заведем на Hume саму таблицу-реплику.
TABLE_ID_2=$( \
    yt create table $YT_TABLE_PATH --attr "{
       dynamic=%true;
       upstream_replica_id=\"$REPLICA_ID_ClUSTER_2\";
       schema=$YT_TABLE_SCHEMA
    }" --proxy $YT_REPLICA_CLUSTER_2
); echo $TABLE_ID_2


# Примонтируем таблицы-реплики и реплицированную таблицу.
yt mount-table   $YT_TABLE_PATH    --proxy $YT_META_CLUSTER
yt mount-table   $YT_TABLE_PATH    --proxy $YT_REPLICA_CLUSTER_1
yt mount-table   $YT_TABLE_PATH    --proxy $YT_REPLICA_CLUSTER_2


# Включаем реплики.
yt alter-table-replica "$REPLICA_ID_ClUSTER_1" --enable --mode async  --proxy $YT_META_CLUSTER
yt alter-table-replica "$REPLICA_ID_ClUSTER_2" --enable --mode async  --proxy $YT_META_CLUSTER


exit 0;



