#!/usr/bin/perl

#15m ~ month
#3h ~ year

use qbit;

mkdir 'clickhouse_tmp_data';

my $OLD_CH_CONN = 'clickhouse-client --host=ppchouse04e.yandex.ru --port=9000 --database=partner --user=partner_reader';
my $new_CH_CONN =
'clickhouse-client --ssl --host=man-whecdgrou6tfa07o.db.yandex.net --port=9440 --database=partner --user=partner --password=2UWgj3ltqjP1h';

#TEST
#my $new_CH_CONN =
#'clickhouse-client --ssl --host=man-1t71zs5e3qalyfvq.db.yandex.net --port=9440 --database=partner --user=partner --password=wkf1IAVdF1BDF';

die 'Set actual connections';

my $end_date = curdate(oformat => 'db');
my $start_date = date_sub($end_date, day => 30, iformat => 'db', oformat => 'db');

my $stop_date = `echo "SELECT MIN(dt) from statistics FORMAT TabSeparated" | $OLD_CH_CONN`;
chomp($stop_date);

while ($end_date ge $stop_date) {
    printf("%s Period: %s - %s\n", curdate(oformat => 'db_time'), $start_date, $end_date);

    my $sql = qq{
SELECT
    `dt`,
    `product_id`,
    `page_id`,
    `block_id`,
    `dsp_id`,
    `currency_id`,
    `tag_id`,
    `shows`,
    `clicks`,
    `hits`,
    `direct_clicks`,
    `direct_shows`,
    `all_w_nds`,
    `all_wo_nds`,
    `partner_w_nds`,
    `partner_wo_nds`,
    `bad_shows`,
    `bad_hits`,
    `bad_win_price_w_nds`,
    `bad_win_price_wo_nds`,
    `bad_win_partner_price_w_nds`,
    `bad_win_partner_price_wo_nds`,
    `an_fraud_shows`,
    `an_fraud_clicks`,
    `an_fraud_hits`,
    `an_cover_hits`,
    `an_cover_direct_hits`,
    `an_cover_market_hits`,
    `an_cover_mcb_hits`,
    `an_cover_senthits`,
    `an_rtb_cover_hits`,
    `an_rtb_cover_senthits`,
    `an_rtb_cover_direct_hits`,
    `direct_page_ad_shows`,
    `premium_page_ad_shows`,
    `direct_hits`,
    `market_hits`,
    `mcb_hits`,
    `premium_hits`,
    `view`,
    `open_player`
FROM statistics
WHERE
    `dt` >= '$start_date' and `dt` <= '$end_date'
FORMAT TabSeparated
    };

    writefile('clickhouse_tmp_data/SQL', $sql);

    print `cat clickhouse_tmp_data/SQL | $OLD_CH_CONN > clickhouse_tmp_data/data.tsv`;

    print
`$new_CH_CONN --query="INSERT INTO statistics (dt, product_id, page_id, block_id, dsp_id, currency_id, tag_id, shows, clicks, hits, direct_clicks, direct_shows, all_w_nds, all_wo_nds, partner_w_nds, partner_wo_nds, bad_shows, bad_hits, bad_win_price_w_nds, bad_win_price_wo_nds, bad_win_partner_price_w_nds, bad_win_partner_price_wo_nds, an_fraud_shows, an_fraud_clicks, an_fraud_hits, an_cover_hits, an_cover_direct_hits, an_cover_market_hits, an_cover_mcb_hits, an_cover_senthits, an_rtb_cover_hits, an_rtb_cover_senthits, an_rtb_cover_direct_hits, direct_page_ad_shows, premium_page_ad_shows, direct_hits, market_hits, mcb_hits, premium_hits, view, open_player) FORMAT TabSeparated" < clickhouse_tmp_data/data.tsv`;

    `rm clickhouse_tmp_data/data.tsv`;

    $end_date   = date_sub($start_date, day => 1,  iformat => 'db', oformat => 'db');
    $start_date = date_sub($end_date,   day => 30, iformat => 'db', oformat => 'db');
}

print "#END\n";
