CREATE TABLE IF NOT EXISTS `context_on_site_content` (
    `campaign_id` INT UNSIGNED,
    `id` INT UNSIGNED NOT NULL,
    `create_date` DATETIME,
    `caption` VARCHAR(255) NOT NULL DEFAULT '',
    `multistate` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `geo` MEDIUMTEXT,
    `comment` TEXT,
    `opts` JSON NOT NULL,
    `is_custom_bk_data` BOOLEAN NOT NULL DEFAULT '0',
    `bk_data` MEDIUMTEXT,
    PRIMARY KEY (`campaign_id`, `id`),
    INDEX `context_on_site_content__id` (`id`),
    FOREIGN KEY `fk_context_on_site_content__campaign_id___context_on_site_campa` (`campaign_id`)
        REFERENCES `context_on_site_campaign` (`page_id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8';

CREATE TABLE IF NOT EXISTS `context_on_site_content_dsps` (
    `campaign_id` INT UNSIGNED,
    `block_id` INT UNSIGNED NOT NULL,
    `dsp_id` BIGINT UNSIGNED NOT NULL,
    `is_deleted` BOOLEAN NOT NULL DEFAULT '0',
    PRIMARY KEY (`campaign_id`, `block_id`, `dsp_id`),
    FOREIGN KEY `fk_context_on_site_content_dsps__campaign_id_block_id___context` (`campaign_id`, `block_id`)
        REFERENCES `context_on_site_content` (`campaign_id`, `id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_context_on_site_content_dsps__dsp_id___dsp__id` (`dsp_id`)
        REFERENCES `dsp` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8';

CREATE TABLE IF NOT EXISTS `context_on_site_content_action_log` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `dt` DATETIME NOT NULL,
    `user_id` BIGINT UNSIGNED NOT NULL,
    `elem_campaign_id` INT UNSIGNED NOT NULL,
    `elem_id` INT UNSIGNED NOT NULL,
    `old_multistate` BIGINT UNSIGNED NOT NULL,
    `action` VARCHAR(100) NOT NULL,
    `new_multistate` BIGINT UNSIGNED NOT NULL,
    `opts` TEXT NOT NULL,
    `comment` VARCHAR(100) NOT NULL DEFAULT '',
    PRIMARY KEY (`id`),
    INDEX `context_on_site_content_action_log__dt_elem_campaign_id_elem_id_` (`dt`, `elem_campaign_id`, `elem_id`, `action`),
    INDEX `context_on_site_content_action_log__elem_campaign_id_elem_id_act` (`elem_campaign_id`, `elem_id`, `action`),
    FOREIGN KEY `fk_context_on_site_content_action_log__user_id___users__id` (`user_id`)
        REFERENCES `users` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_context_on_site_content_action_log__elem_campaign_id_elem_id` (`elem_campaign_id`, `elem_id`)
        REFERENCES `context_on_site_content` (`campaign_id`, `id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8';
