#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION
    Нужна ПРОД база
=cut

# project modules
use lib::abs qw(
  ../../lib
  );
use qbit;
use Application;

my $SELLER_ID = 17298340;
my $FILTERS = [1, 3, 4, 5, 6, 7, 20, 21];

my $LIMIT = 5_000;

main();

sub main {
    my $app = Application->new();
    $app->pre_run();

    {
        no strict 'refs';
        no warnings 'redefine';
        *{'QBit::Application::check_rights'} = sub {TRUE};
    }

    $app->set_cur_user({id => 0, login => 'system-cron'});

    add_filters($app);

    $app->post_run();

    print "#END\n";
}

sub add_filters {
    my ($app) = @_;

    my @pages = ();
    my $data  = [];
    foreach my $accessor (qw(ssp_context_on_site_campaign ssp_mobile_app_settings)) {
        my $offset = 0;

        while (
            (
                $data = $app->$accessor->get_all(
                    fields => [qw(id seller_id page_id filters)],
                    filter => ['AND', [['seller_id' => '=' => $SELLER_ID], [page_id => 'IS NOT' => undef]]],
                    offset => $offset,
                    limit  => $LIMIT
                )
            )
            && @$data
          )
        {
            foreach my $row (@$data) {
                my %filters = map {$_ => TRUE} @{$row->{'filters'}};

                my $need_update = FALSE;
                foreach (@$FILTERS) {
                    unless ($filters{$_}) {
                        push(@{$row->{'filters'}}, $_);

                        $need_update = TRUE;
                    }
                }

                if ($need_update) {
                    print $row->{'page_id'} . "\n";

                    push(@pages, {id => $row->{'id'}, model => $accessor, page_id => $row->{'page_id'}});

                    my @filter_rows = map {{page_id => $row->{'page_id'}, filter_id => $_}} @{$row->{'filters'}};

                    $app->partner_db->filters->add_multi(\@filter_rows, replace => TRUE);
                }
            }

            $offset += $LIMIT;
        }
    }

    $app->all_pages->mark_pages_for_async_update(pages => \@pages);
}
