#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION
    Нужна ПРОД база
=cut

# project modules
use lib::abs qw(
  ../../lib
  );
use qbit;
use Application;
use PiConstants qw($BOOKMAKER_FLAG_ID);

my $CLIENT_ID = 17298340;
my $FILTERS = [1, 3, 4, 5, 6, 7, 20, 21, 24];

my $LIMIT = 5_000;

main();

sub main {
    my $app = Application->new();
    $app->pre_run();

    {
        no strict 'refs';
        no warnings 'redefine';
        *{'QBit::Application::check_rights'} = sub {TRUE};
    }

    $app->set_cur_user({id => 0, login => 'system-cron'});

    change_templates($app);
    add_filters($app);

    $app->post_run();

    print "#END\n";
}

sub change_templates {
    my ($app) = @_;

    my @fields = qw(tmpl_ssp_mobile_app tmpl_ssp_context_rtb);

    my $db_value = $app->partner_db->ssp_seller->get($CLIENT_ID, fields => \@fields);

    foreach (@fields) {
        my $value = from_json($db_value->{$_});
        $value->{'filters'} = $FILTERS;
        $db_value->{$_} = to_json($value);
    }

    $app->partner_db->ssp_seller->edit($CLIENT_ID, $db_value);
}

sub add_filters {
    my ($app) = @_;

    my $data = [];
    foreach my $accessor (qw(ssp_context_on_site_campaign ssp_mobile_app_settings)) {
        my $offset = 0;

        while (
            (
                $data = $app->$accessor->get_all(
                    fields => [qw(seller_id page_id)],
                    filter => [page_id => 'IS NOT' => undef],
                    offset => $offset,
                    limit  => $LIMIT
                )
            )
            && @$data
          )
        {
            foreach my $row (@$data) {
                my $filters = [$BOOKMAKER_FLAG_ID];
                if ($row->{'seller_id'} == $CLIENT_ID) {
                    $filters = $FILTERS;
                }

                my @filter_rows = map {{page_id => $row->{'page_id'}, filter_id => $_}} @$filters;

                $app->partner_db->filters->add_multi(\@filter_rows, replace => TRUE);
            }

            $offset += $LIMIT;
        }
    }
}
