INSERT INTO `kv_store` (`key`, `value`) VALUES
    ('focus_domains_for_managers_mailing_lists', NOW())
    ON DUPLICATE KEY UPDATE
        `value` = NOW();

ALTER TABLE `owner_site`
    ADD COLUMN `create_date` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
    ALGORITHM=INPLACE, LOCK=NONE;

ANALYZE TABLE `owner_site`;

CREATE TABLE IF NOT EXISTS `focus_domains_for_managers_mailing_lists` (
    `domain` VARCHAR(255) NOT NULL,
    `tier` BIGINT UNSIGNED NOT NULL,
    PRIMARY KEY (`domain`)
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8';

INSERT INTO focus_domains_for_managers_mailing_lists (`domain`, `tier`)
    VALUES
        ('116.ru', 1),
        ('161.ru', 1),
        ('164.ru', 1),
        ('1prime.ru', 1),
        ('29.ru', 1),
        ('360tv.ru', 1),
        ('45.ru', 1),
        ('51.ru', 1),
        ('59.ru', 1),
        ('62.ru', 1),
        ('63.ru', 1),
        ('72.ru', 1),
        ('74.ru', 1),
        ('76.ru', 1),
        ('101.ru', 2),
        ('89.ru', 1),
        ('afisha.ru', 1),
        ('armeniasputnik.am', 1),
        ('autochel.ru', 1),
        ('autonews.ru', 1),
        ('autorambler.ru', 1),
        ('avito.ru', 1),
        ('7days.ru', 1),
        ('bing.com', 1),
        ('biztorg.ru', 1),
        ('championat.com', 1),
        ('djforex.ru', 1),
        ('dnpmag.com', 1),
        ('domofond.ru', 1),
        ('domru.ru', 1),
        ('e1.ru', 1),
        ('eda.ru', 1),
        ('ellegirl.ru', 1),
        ('fb.ru', 1),
        ('ferra.ru', 1),
        ('finmarket.ru', 1),
        ('gazeta.ru', 1),
        ('gismeteo.by', 1),
        ('gismeteo.ru', 1),
        ('gmbox.ru', 1),
        ('icq.com', 1),
        ('indicator.ru', 1),
        ('inosmi.ru', 1),
        ('interessant.ru', 1),
        ('interfax.ru', 1),
        ('lenta.ru', 1),
        ('letidor.ru', 1),
        ('live.com', 1),
        ('avtoradio.ru', 2),
        ('livejournal.com', 1),
        ('m24.ru', 1),
        ('mail.ru', 1),
        ('marieclaire.ru', 1),
        ('matchtv.ru', 1),
        ('maximonline.ru', 1),
        ('mgorsk.ru', 1),
        ('moslenta.ru', 1),
        ('motor.ru', 1),
        ('moya-planeta.ru', 1),
        ('msk.ru', 1),
        ('msn.com', 1),
        ('zhenskoe-mnenie.ru', 3),
        ('naukatv.ru', 1),
        ('filmpro.ru', 1),
        ('ngs24.ru', 1),
        ('ngs55.ru', 1),
        ('ngsdo.ru', 1),
        ('nightparty.ru', 1),
        ('nn.ru', 1),
        ('nnov.org', 1),
        ('gismeteo.kz', 1),
        ('parents.ru', 1),
        ('passion.ru', 1),
        ('prime-tass.ru', 1),
        ('psychologies.ru', 1),
        ('quto.ru', 1),
        ('rabota66.ru', 1),
        ('rambler.ru', 1),
        ('rambler.ua', 1),
        ('rbc.ru', 1),
        ('ria.ru', 1),
        ('rian.ru', 1),
        ('riarealty.ru', 1),
        ('rns.online', 1),
        ('rsport.ru', 1),
        ('rus4all.ru', 1),
        ('russia.tv', 1),
        ('samara24.ru', 1),
        ('secretmag.ru', 1),
        ('smi2.ru', 1),
        ('sportbox.ru', 1),
        ('sputnik.az', 1),
        ('sputnik.by', 1),
        ('sputnik.kg', 1),
        ('sputnik.md', 1),
        ('sputnik-abkhazia.info', 1),
        ('sputnik-abkhazia.ru', 1),
        ('sputnik-georgia.com', 1),
        ('sputnik-georgia.ru', 1),
        ('sputnik-news.ee', 1),
        ('sputniknews.kz', 1),
        ('sputniknews.lt', 1),
        ('sputniknewslv.com', 1),
        ('sputniknews-uz.com', 1),
        ('sputnik-ossetia.com', 1),
        ('sputnik-ossetia.ru', 1),
        ('sputnik-tj.com', 1),
        ('starhit.ru', 1),
        ('strana.ru', 1),
        ('syl.ru', 1),
        ('trista60tv', 1),
        ('ufa1.ru', 1),
        ('ukraina.ru', 1),
        ('v1.ru', 1),
        ('liveinternet.ru', 1),
        ('vestifinance.ru', 1),
        ('vk.com', 1),
        ('vokrugsveta.ru', 1),
        ('vrachiha.ru', 1),
        ('vse-temu.org', 1),
        ('wi-fi.ru', 1),
        ('wmj.ru', 1),
        ('ngs.ru', 1),
        ('zarplata.ru', 1),
        ('kianews.ru', 1),
        ('steaklovers.menu', 1),
        ('03.ru', 2),
        ('1000.menu', 2),
        ('1000listnik.ru', 2),
        ('1000sovetov.ru', 2),
        ('1001goroskop.ru', 2),
        ('100migrantov.ru', 2),
        ('ntv.ru', 1),
        ('101dizain.ru', 2),
        ('101zakon.ru', 2),
        ('103.by', 2),
        ('17track.net', 2),
        ('1brus.ru', 2),
        ('1decor.org', 2),
        ('1ginekologiya.com', 2),
        ('1klop.com', 2),
        ('1kvartirka.ru', 2),
        ('1likvidaciya.ru', 2),
        ('1pochki.ru', 2),
        ('1pozaimam.ru', 2),
        ('1september.ru', 2),
        ('1teplica.com', 2),
        ('1tv.ru', 2),
        ('2017god.com', 2),
        ('2018god.net', 2),
        ('2019-god.com', 2),
        ('24au.ru', 2),
        ('24gadget.ru', 2),
        ('24molnia.com', 2),
        ('24open.ru', 2),
        ('24-open.ru', 2),
        ('24smi.info', 2),
        ('24smi.org', 2),
        ('24tv.ua', 2),
        ('26-2.ru', 2),
        ('2drive.ru', 2),
        ('2dsl.ru', 2),
        ('2epic.ru', 2),
        ('2italia.ru', 2),
        ('2-love.ru', 2),
        ('2proraba.com', 2),
        ('2sotki.ru', 2),
        ('2vracha.ru', 2),
        ('33devici.ru', 2),
        ('365days.ru', 2),
        ('365news.biz', 2),
        ('3dlist.ru', 2),
        ('3ladies.ru', 2),
        ('3wforums.ru', 2),
        ('4apple.org', 2),
        ('4bro.club', 2),
        ('4dancing.ru', 2),
        ('4goodluck.org', 2),
        ('4job.ru', 2),
        ('4prostatit.ru', 2),
        ('4released.ru', 2),
        ('worldcrisis.ru', 3),
        ('5ballov.ru', 2),
        ('5kogotkov.com', 2),
        ('5-tv.ru', 2),
        ('6sotok-dom.com', 2),
        ('6watt.ru', 2),
        ('71smi.ru', 2),
        ('77metrov.ru', 2),
        ('7dach.ru', 2),
        ('7lestnic.com', 2),
        ('7ls.ru', 2),
        ('7mam.ru', 2),
        ('7psihozov.ru', 2),
        ('7x7-journal.ru', 2),
        ('7ya.ru', 2),
        ('9111.ru', 2),
        ('9ban.ru', 2),
        ('9dach.ru', 2),
        ('9tv.co.il', 2),
        ('abcfact.ru', 2),
        ('abino.ru', 2),
        ('aboutstones.ru', 2),
        ('academ-clinic.ru', 2),
        ('academic.ru', 2),
        ('accuweather.com', 2),
        ('actez.ru', 2),
        ('actualnews.org', 2),
        ('ad-auto.ru', 2),
        ('addsmap.ru', 2),
        ('adlabsnetworks.com', 2),
        ('adme.ru', 2),
        ('adreser.ru', 2),
        ('aeterna.ru', 2),
        ('afrodita.guru', 2),
        ('aftershock.su', 2),
        ('ag.ru', 2),
        ('agrognom.ru', 2),
        ('aif.ru', 2),
        ('akket.com', 2),
        ('alegri.ru', 2),
        ('alfa.kz', 2),
        ('alice-wedding.me', 2),
        ('alko.expert', 2),
        ('all-biography.ru', 2),
        ('wordyou.ru', 3),
        ('allchoco.com', 2),
        ('allcrimea.net', 2),
        ('allemp.biz', 2),
        ('allergia.life', 2),
        ('allergolife.ru', 2),
        ('allergycentr.ru', 2),
        ('allgrib.ru', 2),
        ('allinfo24.ru', 2),
        ('all-library.ru', 2),
        ('all-routes.ru', 2),
        ('allspectech.com', 2),
        ('allstr.ru', 2),
        ('allwomens.ru', 2),
        ('altegrip.com', 2),
        ('alternate-politics.info', 2),
        ('alternathistory.com', 2),
        ('amymama.ru', 2),
        ('an-crimea.ru', 2),
        ('androidinsider.ru', 2),
        ('androidp1.ru', 2),
        ('androidster.ru', 2),
        ('anekbook.ru', 2),
        ('anekdot.ru', 2),
        ('anekdotov.net', 2),
        ('anews.com', 2),
        ('animedia.tv', 2),
        ('antifashist.com', 2),
        ('antiflu.ru', 2),
        ('antisochinenie.ru', 2),
        ('antivrediteli.ru', 2),
        ('anycon.ru', 2),
        ('apandaznaet.com', 2),
        ('appleinsider.ru', 2),
        ('aquacomm.ru', 2),
        ('aqua-guru.ru', 2),
        ('aqua-mechanica.ru', 2),
        ('aqua-rmnt.com', 2),
        ('arbitr-praktika.ru', 2),
        ('argumenti.ru', 2),
        ('argumentiru.com', 2),
        ('arhivinfo.ru', 2),
        ('armblogs.ru', 2),
        ('armfootball.com', 2),
        ('armystandard.ru', 2),
        ('aromamasla.com', 2),
        ('arpeflu.ru', 2),
        ('art-assorty.ru', 2),
        ('as-audit.ru', 2),
        ('ask.fm', 2),
        ('asks.ru', 2),
        ('asktel.ru', 2),
        ('astrabasket.ru', 2),
        ('astrologic-cafe.ru', 2),
        ('astromeridian.ru', 2),
        ('astroonlain.ru', 2),
        ('asusfans.ru', 2),
        ('attuale.ru', 2),
        ('audit-it.ru', 2),
        ('autoclub.su', 2),
        ('autodvig.com', 2),
        ('autoexpertnost.ru', 2),
        ('autokadabra.ru', 2),
        ('autokolonka.ru', 2),
        ('autolab24.ru', 2),
        ('automania.ru', 2),
        ('autopulse.net', 2),
        ('autosport.com.ru', 2),
        ('autovsalone.ru', 2),
        ('autoweek.ru', 2),
        ('autozam.ru', 2),
        ('av.by', 2),
        ('avrorra.com', 2),
        ('avtobez.com', 2),
        ('avtoelektrik-info.ru', 2),
        ('avtojeep.ru', 2),
        ('avtoklema.com', 2),
        ('avto-nomer.ru', 2),
        ('avtopoisk.ru', 2),
        ('avtopravo.guru', 2),
        ('avtopravozashita.ru', 2),
        ('ok.ru', 1),
        ('avtostreets.ru', 2),
        ('avtotochki.ru', 2),
        ('avto-urist.online', 2),
        ('avtovill.ru', 2),
        ('avtovzglyad.ru', 2),
        ('avtozakony.ru', 2),
        ('avtozam.com', 2),
        ('avtozvuk-info.ru', 2),
        ('ayzdorov.ru', 2),
        ('azbukadiet.ru', 2),
        ('babushkinadacha.ru', 2),
        ('baby.ru', 2),
        ('babyblog.ru', 2),
        ('baby-calendar.ru', 2),
        ('babyzzz.ru', 2),
        ('back-in-ussr.com', 2),
        ('bagvendt.ru', 2),
        ('bankdirect.pro', 2),
        ('banki.ru', 2),
        ('bankist.ru', 2),
        ('bankru.info', 2),
        ('baq.kz', 2),
        ('bash.im', 2),
        ('bazaar.ru', 2),
        ('bazr.ru', 2),
        ('bbc.com', 2),
        ('beauty-around.com', 2),
        ('beautybaz.ru', 2),
        ('beautylunch.ru', 2),
        ('beboo.ru', 2),
        ('beentocyprus.com', 2),
        ('being-woman.ru', 2),
        ('belarus2.by', 2),
        ('belarusgid.by', 2),
        ('belnovosti.by', 2),
        ('benefit.by', 2),
        ('beremennost.net', 2),
        ('berrys.guru', 2),
        ('besedkimoskva.ru', 2),
        ('best-trailer.ru', 2),
        ('bestwom.ru', 2),
        ('bezboleznej.ru', 2),
        ('unibo.ru', 3),
        ('bezmedikov.ru', 2),
        ('bezprovodoff.com', 2),
        ('bezvalgusa.ru', 2),
        ('b-g.by', 2),
        ('bibiguru.ru', 2),
        ('bigarnold.ru', 2),
        ('bigcaucasus.com', 2),
        ('bigness.ru', 2),
        ('bigslide.ru', 2),
        ('biznes.guru', 2),
        ('biznes-delo.ru', 2),
        ('biznesklubonline.com', 2),
        ('bizneslab.com', 2),
        ('biznesok.com', 2),
        ('u-mama.ru', 3),
        ('bizorg.su', 2),
        ('bizovo.ru', 2),
        ('bizru.org', 2),
        ('bizsovet.com', 2),
        ('bizspravka.org', 2),
        ('bizspravka.su', 2),
        ('blamper.ru', 2),
        ('blizko.ru', 2),
        ('blizzardheroes.ru', 2),
        ('bmwpc.ru', 2),
        ('bnews.kz', 2),
        ('bobik.online', 2),
        ('bobsoccer.ru', 2),
        ('bolitgrud.com', 2),
        ('bolitgrud.net', 2),
        ('bolshoiural.ru', 2),
        ('bolshoyvopros.ru', 2),
        ('bomba.co', 2),
        ('bonna.ru', 2),
        ('books2you.ru', 2),
        ('booksonline.com.ua', 2),
        ('boooh.ru', 2),
        ('borda.ru', 2),
        ('borofka.ru', 2),
        ('bossout.ru', 2),
        ('bouw.ru', 2),
        ('brakexpert.ru', 2),
        ('breakingnews24.ru', 2),
        ('brosajkurit.ru', 2),
        ('brulant.ru', 2),
        ('budgetnik.ru', 2),
        ('budumamoi.com', 2),
        ('buhdzen.ru', 2),
        ('buhonline24.ru', 2),
        ('buhuchetpro.ru', 2),
        ('bumper.guru', 2),
        ('burdastyle.ru', 2),
        ('businessmonster.ru', 2),
        ('buy.net', 2),
        ('bycard.by', 2),
        ('byton.ru', 2),
        ('caddress.ru', 2),
        ('cafe-vokzal.ru', 2),
        ('calcsoft.ru', 2),
        ('calculator-ipoteki.ru', 2),
        ('calend.ru', 2),
        ('carambatv.ru', 2),
        ('cardiobook.ru', 2),
        ('career.ru', 2),
        ('carfrance.ru', 2),
        ('carnovato.ru', 2),
        ('carrotblog.ru', 2),
        ('cars.ru', 2),
        ('carsguru.net', 2),
        ('cataloxy.ru', 2),
        ('cataloxy-by.ru', 2),
        ('cataloxy-kz.ru', 2),
        ('cbskiev.ru', 2),
        ('ceo.ru', 2),
        ('chas.tv', 2),
        ('chelotzyv.ru', 2),
        ('chelyabdom.ru', 2),
        ('chess-samara.ru', 2),
        ('chetv.ru', 2),
        ('chistaya-koja.net', 2),
        ('chocomir.com', 2),
        ('chtojebudet.ru', 2),
        ('chtozaslovo.com', 2),
        ('c-ib.ru', 2),
        ('c-inform.info', 2),
        ('ci-sharp.ru', 2),
        ('citiko.ru', 2),
        ('citol.ru', 2),
        ('citty.org', 2),
        ('citynfo.ru', 2),
        ('classifieds24.ru', 2),
        ('climara.ru', 2),
        ('clubpechnikov.ru', 2),
        ('clubtk.ru', 2),
        ('comandir.com', 2),
        ('comceos.com', 2),
        ('comchart.ru', 2),
        ('comedy-radio.ru', 2),
        ('comfortclub.ru', 2),
        ('commercy.ru', 2),
        ('commfy.ru', 2),
        ('companyinform.ru', 2),
        ('companyru.ru', 2),
        ('complexdoc.ru', 2),
        ('compmastera.com', 2),
        ('composs.ru', 2),
        ('compromesso.ru', 2),
        ('comrates.ru', 2),
        ('comready.ru', 2),
        ('comreport.ru', 2),
        ('consultmill.ru', 2),
        ('cont.ws', 2),
        ('continentalist.ru', 2),
        ('cool-movies.ru', 2),
        ('corstone.biz', 2),
        ('cosmo.ru', 2),
        ('tvc.ru', 3),
        ('c-pu.ru', 2),
        ('cpykami.ru', 2),
        ('creditzzz.ru', 2),
        ('crimea-news.com', 2),
        ('cripo.com.ua', 2),
        ('critman.ru', 2),
        ('ctc.ru', 2),
        ('ctclove.ru', 2),
        ('ctv.by', 2),
        ('cultmanager.ru', 2),
        ('cursorinfo.co.il', 2),
        ('customsforum.ru', 2),
        ('cvetnik.me', 2),
        ('cyberforum.ru', 2),
        ('cyberpedia.su', 2),
        ('cyrillitsa.ru', 2),
        ('dacha.help', 2),
        ('dachadecor.ru', 2),
        ('dadaviz.ru', 2),
        ('dailyshow.ru', 2),
        ('daiting.ru', 2),
        ('damochka.ru', 2),
        ('dancepoisk.ru', 2),
        ('darada.co', 2),
        ('davlenies.ru', 2),
        ('dayonline.ru', 2),
        ('dazzy.ru', 2),
        ('deeplyrics.ru', 2),
        ('dekoriko.ru', 2),
        ('dela.biz', 2),
        ('delasuper.ru', 2),
        ('dentazone.ru', 2),
        ('depcult95.com', 2),
        ('deti.fm', 2),
        ('deti-online.com', 2),
        ('detkipodelki.ru', 2),
        ('detskie-igry.net', 2),
        ('devanews.ru', 2),
        ('diabet24.guru', 2),
        ('diabethelp.guru', 2),
        ('diabetik.guru', 2),
        ('dialog.ua', 2),
        ('dietadvice.ru', 2),
        ('dietfriendly.ru', 2),
        ('din.ru', 2),
        ('dirsalona.ru', 2),
        ('disbakter.ru', 2),
        ('discusdental.ru', 2),
        ('dispetcher-gruzoperevozok.biz', 2),
        ('dispetcher-gruzoperevozok.info', 2),
        ('diva.by', 2),
        ('diwis.ru', 2),
        ('diyideas.ru', 2),
        ('diz-cafe.com', 2),
        ('dm-st.ru', 2),
        ('dni.ru', 2),
        ('dni24.com', 2),
        ('dobleska.com', 2),
        ('doctorfeel.net', 2),
        ('doctorpiter.ru', 2),
        ('doktor365.ru', 2),
        ('dom-2.club', 2),
        ('domashniy.ru', 2),
        ('domdomoff.ru', 2),
        ('domkadrov.ru', 2),
        ('domocvet.com', 2),
        ('domokode.ru', 2),
        ('domovenok-as.ru', 2),
        ('domsnov.ru', 2),
        ('dom-v-rostove.ru', 2),
        ('domznatok.ru', 2),
        ('doorinworld.ru', 2),
        ('doripenem.ru', 2),
        ('dostinex.ru', 2),
        ('dota2.ru', 2),
        ('drive.ru', 2),
        ('drive2.ru', 2),
        ('dropi.ru', 2),
        ('druginfo.org.ua', 2),
        ('dumav.ru', 2),
        ('dv.land', 2),
        ('dveri-mezhkomnatnyedoma.ru', 2),
        ('dzhipi.com', 2),
        ('eadaily.com', 2),
        ('ebay.com', 2),
        ('ecobyt.ru', 2),
        ('ecocollaps.ru', 2),
        ('economtravels.ru', 2),
        ('ecosever.ru', 2),
        ('edadeal.ru', 2),
        ('eda-land.ru', 2),
        ('edimdoma.ru', 2),
        ('eer.ru', 2),
        ('effectfree.ru', 2),
        ('eg.ru', 2),
        ('egdz.ru', 2),
        ('egowoman.ru', 2),
        ('egrinf.com', 2),
        ('egrul-piter.ru', 2),
        ('e-history.kz', 2),
        ('ej-ka.net', 2),
        ('ekatdom.ru', 2),
        ('ekavuz.ru', 2),
        ('el.kz', 2),
        ('electorat.info', 2),
        ('electroadvice.ru', 2),
        ('elektro.guru', 2),
        ('elektro-sadovnik.ru', 2),
        ('eljur.ru', 2),
        ('emigrant.guru', 2),
        ('emigranto.ru', 2),
        ('emocom.ru', 2),
        ('energyfm.ru', 2),
        ('energz.ru', 2),
        ('enspe.com', 2),
        ('entercomputers.ru', 2),
        ('epicube.ru', 2),
        ('esquire.ru', 2),
        ('estroyka.com', 2),
        ('etokavkaz.ru', 2),
        ('eto-vannaya.club', 2),
        ('eto-vannaya.ru', 2),
        ('eurasia96.ru', 2),
        ('euro-football.ru', 2),
        ('euroki.me', 2),
        ('eurosport.ru', 2),
        ('eva.ru', 2),
        ('eva-health.ru', 2),
        ('every-holiday.ru', 2),
        ('evroportal.ru', 2),
        ('e-w-e.ru', 2),
        ('exacom.ru', 2),
        ('exdex.ru', 2),
        ('expert.ru', 2),
        ('expertcen.ru', 2),
        ('expert-nasledstva.com', 2),
        ('exposo.ru', 2),
        ('expres.ua', 2),
        ('expresrabota.com', 2),
        ('ex-press.by', 2),
        ('ezka.ru', 2),
        ('fabrikamakiyazha.ru', 2),
        ('facerussia.ru', 2),
        ('factroom.ru', 2),
        ('fanart.info', 2),
        ('fanat1k.ru', 2),
        ('fanera-info.ru', 2),
        ('fano-events.ru', 2),
        ('fans-android.com', 2),
        ('farverig.ru', 2),
        ('fasad.guru', 2),
        ('fd.ru', 2),
        ('fedage.ru', 2),
        ('fedpress.ru', 2),
        ('feech.org', 2),
        ('feelcontrol.net', 2),
        ('felomena.com', 2),
        ('femma.ru', 2),
        ('fermilon.ru', 2),
        ('fermok.ru', 2),
        ('ficbook.net', 2),
        ('film.ru', 2),
        ('finam.info', 2),
        ('finam.ru', 2),
        ('finbox.ru', 2),
        ('finobzor.ru', 2),
        ('finrussia.ru', 2),
        ('firmap.ru', 2),
        ('firms.city', 2),
        ('firmsbase.ru', 2),
        ('fishki.cc', 2),
        ('fishki.net', 2),
        ('fitladies.ru', 2),
        ('fitnessguide.pro', 2),
        ('fitnesslair.ru', 2),
        ('fitseven.ru', 2),
        ('fizcultprivet.ru', 2),
        ('flagma.by', 2),
        ('flagma.kz', 2),
        ('flagma.ru', 2),
        ('flirchi.ru', 2),
        ('floordigest.ru', 2),
        ('flowercare.ru', 2),
        ('flytothesky.ru', 2),
        ('fontanka.fi', 2),
        ('fontanka.ru', 2),
        ('football.by', 2),
        ('trinixy.ru', 3),
        ('formulalubvi.com', 2),
        ('fortolke.ru', 2),
        ('fortuna.today', 2),
        ('forum220.ru', 2),
        ('forumchata.ru', 2),
        ('forumhouse.ru', 2),
        ('forumhouse.tv', 2),
        ('fotkidepo.ru', 2),
        ('fotoresepti.ru', 2),
        ('fotostrana.ru', 2),
        ('foundus.biz', 2),
        ('frail.ru', 2),
        ('frazy.su', 2),
        ('freesoft.ru', 2),
        ('freshtv.tv', 2),
        ('frf.name', 2),
        ('friendaround.ru', 2),
        ('frondetv.ru', 2),
        ('fruktik.guru', 2),
        ('ftimes.ru', 2),
        ('fx-commodities.ru', 2),
        ('gagadget.com', 2),
        ('galagram.com', 2),
        ('galoche.ru', 2),
        ('gametech.ru', 2),
        ('gandex.ru', 2),
        ('garant.ru', 2),
        ('gastronom.ru', 2),
        ('gastrotips.ru', 2),
        ('gazeta-unp.ru', 2),
        ('gd.ru', 2),
        ('gde.by', 2),
        ('gde.ru', 2),
        ('gde-in.ru', 2),
        ('gdeposylka.ru', 2),
        ('gdz.guru', 2),
        ('gdz.im', 2),
        ('gdz.work', 2),
        ('gdzlol.org', 2),
        ('gdz-na5.ru', 2),
        ('gdz-online.com', 2),
        ('gdzputina.com', 2),
        ('gdz-putina.info', 2),
        ('gdz-putina.net', 2),
        ('gdzroom.org', 2),
        ('geekhacker.ru', 2),
        ('geek-nose.com', 2),
        ('georgiatimes.info', 2),
        ('german-guide.ru', 2),
        ('germania.one', 2),
        ('getdiz.ru', 2),
        ('getvideo.org', 2),
        ('gidmed.com', 2),
        ('gidroguide.ru', 2),
        ('gidroguru.com', 2),
        ('gidtorg.ru', 2),
        ('gifpics.ru', 2),
        ('gigano.ru', 2),
        ('ginekola.ru', 2),
        ('gipertonia.pro', 2),
        ('gipertonic.ru', 2),
        ('gipertonija.ru', 2),
        ('gipsodecor.ru', 2),
        ('gipsokartonom.ru', 2),
        ('gisher.ru', 2),
        ('gitem.me', 2),
        ('gkh.ru', 2),
        ('glav.su', 2),
        ('glavbukh.ru', 2),
        ('glavnoe.io', 2),
        ('glavtema.ru', 2),
        ('glaz.tv', 2),
        ('glisty.su', 2),
        ('globuss24.ru', 2),
        ('god-2017.su', 2),
        ('goldenlib.ru', 2),
        ('goldorfey.com', 2),
        ('golplan.ru', 2),
        ('goodhouse.ru', 2),
        ('goodkrovlya.ru', 2),
        ('goodmeteo.ru', 2),
        ('goodster.ru', 2),
        ('gopsy.ru', 2),
        ('gormonexpert.ru', 2),
        ('gorobzor.ru', 2),
        ('gorodrabot.by', 2),
        ('gorodrabot.ru', 2),
        ('goroskop.guru', 2),
        ('goroskopy.info', 2),
        ('gotovim.ru', 2),
        ('gotovkin.su', 2),
        ('gpclub.ru', 2),
        ('gpk.gov.by', 2),
        ('graycell.ru', 2),
        ('grazhdaninu.com', 2),
        ('graziamagazine.ru', 2),
        ('grippozus.ru', 2),
        ('grounde.ru', 2),
        ('grudinfo.ru', 2),
        ('gryzhinet.ru', 2),
        ('gryzhi-net.ru', 2),
        ('gs.by', 2),
        ('gtavicecity.ru', 2),
        ('gtrksmol.ru', 2),
        ('gubdaily.ru', 2),
        ('guiderf.ru', 2),
        ('guideru.ru', 2),
        ('guidetorussia.ru', 2),
        ('gurubanks.com', 2),
        ('gyba.ru', 2),
        ('gzkp.ru', 2),
        ('habardom.ru', 2),
        ('habrahabr.ru', 2),
        ('haircaretips.ru', 2),
        ('hairproblem.ru', 2),
        ('hairs-club.ru', 2),
        ('happydizain.com', 2),
        ('happymodern.ru', 2),
        ('healthy-lady.ru', 2),
        ('helpmyhtc.com', 2),
        ('herbalpedia.ru', 2),
        ('herpes.guru', 2),
        ('hh.ru', 2),
        ('hi.ru', 2),
        ('hi-news.ru', 2),
        ('hipdir.com', 2),
        ('hmn.ru', 2),
        ('hokido.ru', 2),
        ('homeferma.com', 2),
        ('homeli.ru', 2),
        ('horki.info', 2),
        ('hormonus.com', 2),
        ('hotnews02.ru', 2),
        ('hotsport.ua', 2),
        ('house-dacha.ru', 2),
        ('howmeb.com', 2),
        ('howtogetrid.ru', 2),
        ('hozobzor.ru', 2),
        ('hozsekretiki.ru', 2),
        ('hqtexture.com', 2),
        ('hr-director.ru', 2),
        ('hrivna.info', 2),
        ('hromosoma.com', 2),
        ('hudeiskorei.com', 2),
        ('hudelkin.ru', 2),
        ('huliganka.net', 2),
        ('hvatit-bolet.ru', 2),
        ('iamcook.ru', 2),
        ('ibis-art.com', 2),
        ('ice-cherry.com', 2),
        ('ichip.ru', 2),
        ('idealdomik.ru', 2),
        ('ideibiznesa.org', 2),
        ('iforex.su', 2),
        ('igraemsa.ru', 2),
        ('ilibrary.ru', 2),
        ('ilovedomain.ru', 2),
        ('image-auto.ru', 2),
        ('imgur.com', 2),
        ('imolodost.com', 2),
        ('impotencija.net', 2),
        ('in.ua', 2),
        ('indexphone.ru', 2),
        ('indi1.top', 2),
        ('indiatv.ru', 2),
        ('info24.am', 2),
        ('infocourt.ru', 2),
        ('infoniac.ru', 2),
        ('infopedia.su', 2),
        ('inforeactor.ru', 2),
        ('infored.ru', 2),
        ('inform-progulka.by', 2),
        ('infornix.ru', 2),
        ('infotime.co', 2),
        ('infox.ru', 2),
        ('infox.sg', 2),
        ('infox.tv', 2),
        ('inndex.ru', 2),
        ('inopressa.ru', 2),
        ('inoprosport.ru', 2),
        ('inpot.ru', 2),
        ('inpreds.com', 2),
        ('insgid.ru', 2),
        ('instablog.info', 2),
        ('instrukciya-otzyvy.ru', 2),
        ('intererro.ru', 2),
        ('interesnoznat.com', 2),
        ('interier.club', 2),
        ('inter-view.org', 2),
        ('intim-news.ru', 2),
        ('investing.com', 2),
        ('inzoloto.ru', 2),
        ('io.ua', 2),
        ('iohotnik.ru', 2),
        ('ipboss.guru', 2),
        ('ipexperts.ru', 2),
        ('iphone-gps.ru', 2),
        ('ipinform.ru', 2),
        ('ipopen.ru', 2),
        ('ipoteka-expert.com', 2),
        ('ipotekam.com', 2),
        ('ipshnik.com', 2),
        ('ip-spravka.ru', 2),
        ('iqcomp.ru', 2),
        ('irecommend.ru', 2),
        ('irk.ru', 2),
        ('irr.ru', 2),
        ('iskitimcity.ru', 2),
        ('ithappens.me', 2),
        ('itmaster.guru', 2),
        ('i-trailer.ru', 2),
        ('itrate.ru', 2),
        ('ivan-teas.ru', 2),
        ('ivd.ru', 2),
        ('ivi.ru', 2),
        ('iwiki.su', 2),
        ('ixbt.com', 2),
        ('izppp.ru', 2),
        ('izvagonki.ru', 2),
        ('izvestia.ru', 2),
        ('jainux.net', 2),
        ('jdis.co', 2),
        ('jkuhnya.ru', 2),
        ('job.ru', 2),
        ('joblab.by', 2),
        ('joblab.kz', 2),
        ('joblab.ru', 2),
        ('job-mo.ru', 2),
        ('joinfo.com', 2),
        ('joobix.ru', 2),
        ('jpgazeta.ru', 2),
        ('jsprav.ru', 2),
        ('junona.org', 2),
        ('jurist-center.ru', 2),
        ('jurist-protect.ru', 2),
        ('justcoolidea.ru', 2),
        ('justdoits.guru', 2),
        ('just-interes.ru', 2),
        ('justlady.ru', 2),
        ('justwoman.club', 2),
        ('jvlife.ru', 2),
        ('kadriruem.ru', 2),
        ('kadrovik.guru', 2),
        ('kakbog.ru', 2),
        ('kakmed.ru', 2),
        ('kakpersik.ru', 2),
        ('kakpostroit.su', 2),
        ('kakpozvonit.ru', 2),
        ('kakprosto.ru', 2),
        ('kalendarogoroda.ru', 2),
        ('kanobu.ru', 2),
        ('karaoke.ru', 2),
        ('kareliyanews.ru', 2),
        ('kartaslov.ru', 2),
        ('kdelo.ru', 2),
        ('kedem.ru', 2),
        ('keer.su', 2),
        ('khl.ru', 2),
        ('kick.media', 2),
        ('kids365.ru', 2),
        ('kino67.ru', 2),
        ('kinoafisha.info', 2),
        ('kinonews.ru', 2),
        ('kino-teatr.ru', 2),
        ('kirov-dom.ru', 2),
        ('kishechnik.guru', 2),
        ('kitchenguide.ru', 2),
        ('kitchenremont.ru', 2),
        ('klademkirpich.ru', 2),
        ('kladraz.ru', 2),
        ('kleo.ru', 2),
        ('klikabol.com', 2),
        ('klimakspms.ru', 2),
        ('klubochek.net', 2),
        ('klumba.guru', 2),
        ('klyv.ru', 2),
        ('knittingideas.ru', 2),
        ('knittochka.ru', 2),
        ('kogda-budet.com', 2),
        ('kohuku.ru', 2),
        ('kolesa.kz', 2),
        ('kolodec.guru', 2),
        ('kom-dir.ru', 2),
        ('kommersant.ru', 2),
        ('komok.com', 2),
        ('kompkimi.ru', 2),
        ('konservashka.ru', 2),
        ('koolinar.ru', 2),
        ('kotel.guru', 2),
        ('kot-i-koshka.ru', 2),
        ('kot-pes.com', 2),
        ('kozhzdrav.ru', 2),
        ('kp.by', 2),
        ('kp.ru', 2),
        ('krasnayakrov.ru', 2),
        ('kratkoesoderzhaniepro.ru', 2),
        ('kreditstock.ru', 2),
        ('kredit-vbanke.ru', 2),
        ('krisha.kz', 2),
        ('kritika24.ru', 2),
        ('krohababy.com', 2),
        ('krovlyakryshi.ru', 2),
        ('krugompravo.ru', 2),
        ('krutimotor.ru', 2),
        ('krutomer.ru', 2),
        ('ksprf.com', 2),
        ('ktogdeest.com', 2),
        ('ktovkurse.com', 2),
        ('kudamsk.ru', 2),
        ('kudatotam.ru', 2),
        ('kufar.by', 2),
        ('kuhnyatv.ru', 2),
        ('kulichki.net', 2),
        ('kulturologia.ru', 2),
        ('kundelik.kz', 2),
        ('kurs.com.ua', 2),
        ('kursremonta.ru', 2),
        ('kursvalut.com', 2),
        ('kvartiravnovgorode.ru', 2),
        ('kvartirkapro.ru', 2),
        ('kvartiry-66.ru', 2),
        ('kvartiry-77.ru', 2),
        ('kvartiry-78.ru', 2),
        ('kyhmister.com', 2),
        ('kykarek.com', 2),
        ('kyky.org', 2),
        ('labavto.com', 2),
        ('lachat.ru', 2),
        ('ladycharm.net', 2),
        ('ladycleo.ru', 2),
        ('laminortv.ru', 2),
        ('landscape-project.ru', 2),
        ('lapku.ru', 2),
        ('lawyercom.ru', 2),
        ('lawyer-guide.ru', 2),
        ('lawyer-road.ru', 2),
        ('lazzy.ru', 2),
        ('lecheniegorla.ru', 2),
        ('lechenie-narodom.ru', 2),
        ('lechenie-simptomy.ru', 2),
        ('lechilka.com', 2),
        ('lechimkashel.com', 2),
        ('legalmap.ru', 2),
        ('legkovmeste.ru', 2),
        ('lekcion.ru', 2),
        ('lektsia.com', 2),
        ('lektsii.com', 2),
        ('lektsii.net', 2),
        ('lektsii.org', 2),
        ('lektsiopedia.org', 2),
        ('lengid.ru', 2),
        ('lenobl-dom.ru', 2),
        ('lentainform.com', 2),
        ('lenty.ru', 2),
        ('lestnicymaster.ru', 2),
        ('lestnicypro.ru', 2),
        ('lestnitsy-perila.ru', 2),
        ('letuale.club', 2),
        ('leyma.ru', 2),
        ('lgotypro.ru', 2),
        ('lifansolano-club.ru', 2),
        ('life.ru', 2),
        ('trendymen.ru', 3),
        ('lifehacker.ru', 2),
        ('lifeinbooks.net', 2),
        ('lifenofear.com', 2),
        ('life-prog.ru', 2),
        ('lifter.com.ua', 2),
        ('linezolid.ru', 2),
        ('lisa.ru', 2),
        ('listis.ru', 2),
        ('littleone.ru', 2),
        ('veseloeradio.ru', 2),
        ('liveresult.ru', 2),
        ('livescore.ru', 2),
        ('livestory.com.ua', 2),
        ('liwli.ru', 2),
        ('ljrate.ru', 2),
        ('lodgers.ru', 2),
        ('lokomotiv.info', 2),
        ('lostfilm.info', 2),
        ('lostfilm.tv', 2),
        ('lovegeek.ru', 2),
        ('loveplanet.ru', 2),
        ('lput.ru', 2),
        ('lrnews.ru', 2),
        ('lublumed.ru', 2),
        ('lucklove.ru', 2),
        ('lunniykalendar.com', 2),
        ('macd.ru', 2),
        ('magical-skin.com', 2),
        ('magickum.com', 2),
        ('magiya.guru', 2),
        ('mainavi.ru', 2),
        ('mainews.ru', 2),
        ('maja-dacha.ru', 2),
        ('makaronina.ru', 2),
        ('makulaturin.ru', 2),
        ('mamafm.ru', 2),
        ('mamapluspapa.ru', 2),
        ('mamaprofi.com', 2),
        ('mamba.ru', 2),
        ('mamium.ru', 2),
        ('mamochki.by', 2),
        ('manageru.net', 2),
        ('manikyres.ru', 2),
        ('marry.ru', 2),
        ('masterabetona.ru', 2),
        ('mastera-fasada.ru', 2),
        ('masterok.guru', 2),
        ('master-saydinga.ru', 2),
        ('materinskij-kapital.ru', 2),
        ('materinstvo.ru', 2),
        ('maxpark.com', 2),
        ('maxtender.ru', 2),
        ('med2.ru', 2),
        ('med-atlas.ru', 2),
        ('meddaily.ru', 2),
        ('medikateka.ru', 2),
        ('medistok.ru', 2),
        ('medknsltant.com', 2),
        ('medlec.org', 2),
        ('med-look.ru', 2),
        ('medoboz.com', 2),
        ('medpulse.ru', 2),
        ('medside.ru', 2),
        ('medsovet.guru', 2),
        ('medvoice.ru', 2),
        ('med-zabolevaniya.ru', 2),
        ('megalektsii.ru', 2),
        ('megaobuchalka.ru', 2),
        ('megapolisonline.ru', 2),
        ('megapolis-real.by', 2),
        ('megapredmet.ru', 2),
        ('megaresheba.com', 2),
        ('megaresheba.net', 2),
        ('megazdorov.ru', 2),
        ('megogo.net', 2),
        ('melanomam.ru', 2),
        ('melkie.net', 2),
        ('menfo.ru', 2),
        ('menobr.ru', 2),
        ('mestam.info', 2),
        ('mestarf.ru', 2),
        ('mestarf.su', 2),
        ('metallocherepica-pro.ru', 2),
        ('metalloprokat.com', 2),
        ('meteoinfo.ru', 2),
        ('meteolocator.ru', 2),
        ('meteonova.ru', 2),
        ('meteonova.ua', 2),
        ('meteonovosti.ru', 2),
        ('meteovesti.ru', 2),
        ('metodisty.ru', 2),
        ('mexalib.com', 2),
        ('mfc-list.info', 2),
        ('mia-italia.com', 2),
        ('microklimat.pro', 2),
        ('mignews.com', 2),
        ('migom.by', 2),
        ('militarytimes.ru', 2),
        ('minimum-price.ru', 2),
        ('miningexpo.ru', 2),
        ('miniotvet.ru', 2),
        ('minskotzyv.ru', 2),
        ('mintlinux.ru', 2),
        ('topface.com', 3),
        ('mirfermera.ru', 2),
        ('mirkupit.ru', 2),
        ('mirkvartir.ru', 2),
        ('mirmam.info', 2),
        ('mirsegondya.com', 2),
        ('mirsustavov.ru', 2),
        ('mirtesen.ru', 2),
        ('mirzubov.info', 2),
        ('missus.ru', 2),
        ('mjusli.ru', 2),
        ('mk.ru', 2),
        ('mkb.guru', 2),
        ('mkb2.ru', 2),
        ('mk-london.co.uk', 2),
        ('mmo-db.com', 2),
        ('mnogo-reshebnikov.com', 2),
        ('mobicombo.ru', 2),
        ('mobilepics.ru', 2),
        ('modagid.ru', 2),
        ('modber.ru', 2),
        ('moddam.ru', 2),
        ('modnohod.ru', 2),
        ('moe-belgorod.ru', 2),
        ('moe-kursk.ru', 2),
        ('moe-lipetsk.ru', 2),
        ('moe-online.ru', 2),
        ('moevideo.com', 2),
        ('moevideo.net', 2),
        ('moikompas.ru', 2),
        ('moimirdizaina.ru', 2),
        ('moi-oftalmolog.com', 2),
        ('molochnicynet.ru', 2),
        ('molodaja-semja.ru', 2),
        ('momat.ru', 2),
        ('momenty.org', 2),
        ('moneytimes.ru', 2),
        ('morecoffee.ru', 2),
        ('morfei.ru', 2),
        ('morgenmad.ru', 2),
        ('mosadvokat.org', 2),
        ('moscvichka.ru', 2),
        ('mosgid.ru', 2),
        ('moskidka.ru', 2),
        ('moskv.ru', 2),
        ('mosmama.ru', 2),
        ('motorltd.ru', 2),
        ('moyareklama.ru', 2),
        ('moyaspravka.ru', 2),
        ('moyateplica.ru', 2),
        ('moyidorogi.ru', 2),
        ('moy-kroha.info', 2),
        ('moypodval.ru', 2),
        ('moy-znahar.ru', 2),
        ('mp3.ru', 2),
        ('mp3party.net', 2),
        ('mtests.ru', 2),
        ('multilisting.su', 2),
        ('multitran.ru', 2),
        ('murzik.online', 2),
        ('muza.name', 2),
        ('mybiblioteka.su', 2),
        ('my-calend.ru', 2),
        ('mycompany.su', 2),
        ('mydesigninfo.ru', 2),
        ('myfin.by', 2),
        ('myfirms.su', 2),
        ('mygdz.com', 2),
        ('mykex.ru', 2),
        ('mylambreken.ru', 2),
        ('mylove.ru', 2),
        ('my-pomoshnik.ru', 2),
        ('my-rasskazhem.ru', 2),
        ('myslo.ru', 2),
        ('my-sunshine.ru', 2),
        ('myvi.ru', 2),
        ('myvi.tv', 2),
        ('naaltae.ru', 2),
        ('nachild.com', 2),
        ('nadache.guru', 2),
        ('nadietu.net', 2),
        ('naexamen.ru', 2),
        ('nagadala.com', 2),
        ('naitiko.ru', 2),
        ('nakom.ru', 2),
        ('nakormi.com', 2),
        ('na-ladoni.su', 2),
        ('nalogobzor.info', 2),
        ('name-1.ru', 2),
        ('namenu.ru', 2),
        ('nam-pokursu.ru', 2),
        ('narodnimisredstvami.ru', 2),
        ('narrecepti.ru', 2),
        ('narule.ru', 2),
        ('nashaotdelka.ru', 2),
        ('nashaspalnya.ru', 2),
        ('nash-dom2.su', 2),
        ('nashgazon.com', 2),
        ('nashzeleniymir.ru', 2),
        ('nasledstvo.guru', 2),
        ('nasotke.ru', 2),
        ('nastroykino.ru', 2),
        ('natapku.ru', 2),
        ('nationaljournal.ru', 2),
        ('nation-news.ru', 2),
        ('natpress.net', 2),
        ('natrukodel.ru', 2),
        ('naturalmask.ru', 2),
        ('naydidom.com', 2),
        ('nazimu.net', 2),
        ('ndv16.ru', 2),
        ('ndv174.ru', 2),
        ('ndv22.ru', 2),
        ('ndv23.ru', 2),
        ('ndv23dom.ru', 2),
        ('ndv-24.ru', 2),
        ('ndv-31.ru', 2),
        ('ndv-33.ru', 2),
        ('ndv34.ru', 2),
        ('ndv-36.ru', 2),
        ('ndv38.ru', 2),
        ('ndv39.ru', 2),
        ('ndv40.ru', 2),
        ('ndv50.ru', 2),
        ('ndv54.ru', 2),
        ('ndv54dom.ru', 2),
        ('ndv55.ru', 2),
        ('ndv59dom.ru', 2),
        ('ndv61.ru', 2),
        ('ndv63.ru', 2),
        ('ndv63dom.ru', 2),
        ('ndv64.ru', 2),
        ('ndv66.ru', 2),
        ('ndv70.ru', 2),
        ('ndv-72.ru', 2),
        ('ndv74.ru', 2),
        ('ndv76.ru', 2),
        ('ndv77.ru', 2),
        ('ndv777.ru', 2),
        ('ndv78.ru', 2),
        ('ndv88.ru', 2),
        ('ndv96.ru', 2),
        ('neek.su', 2),
        ('neelov.ru', 2),
        ('nektarin.su', 2),
        ('nekurok.ru', 2),
        ('nemodno.com', 2),
        ('neotorg.com', 2),
        ('netmorshin.ru', 2),
        ('neurodoc.ru', 2),
        ('neurofob.com', 2),
        ('neuro-logia.ru', 2),
        ('neutralitet.ru', 2),
        ('nevnov.ru', 2),
        ('nevsedoma.com.ua', 2),
        ('newauto.kz', 2),
        ('newbusiness.su', 2),
        ('newdaynews.ru', 2),
        ('newinform.com', 2),
        ('newizv.ru', 2),
        ('newkaliningrad.ru', 2),
        ('new-retail.ru', 2),
        ('newsbuzz.ru', 2),
        ('newseum.ru', 2),
        ('newshappens.ru', 2),
        ('newsinfo.ru', 2),
        ('newsland.com', 2),
        ('newsoftheday.ru', 2),
        ('newsrank.ru', 2),
        ('newsru.co.il', 2),
        ('newsru.com', 2),
        ('newstime.am', 2),
        ('newstube.ru', 2),
        ('nimica.ru', 2),
        ('njcar.ru', 2),
        ('nmedic.info', 2),
        ('nnn.ru', 2),
        ('nogot.net', 2),
        ('noprost.ru', 2),
        ('notarius.help', 2),
        ('notarius-moscow.ru', 2),
        ('notebook-center.ru', 2),
        ('notecom.biz', 2),
        ('notefood.ru', 2),
        ('novate.ru', 2),
        ('novayagazeta.ru', 2),
        ('novostino.ru', 2),
        ('novostionline.net', 2),
        ('nter.net.ua', 2),
        ('vesti.ru', 2),
        ('nuipogoda.ru', 2),
        ('nur.kz', 2),
        ('nuzhnaviza.ru', 2),
        ('oane.ws', 2),
        ('obalkonah.ru', 2),
        ('obrazovalka.ru', 2),
        ('obsleduem.net', 2),
        ('obsuzhday.com', 2),
        ('obustroen.ru', 2),
        ('obustroeno.com', 2),
        ('obyavleniya.info', 2),
        ('odamah.ru', 2),
        ('ofcompany.ru', 2),
        ('ofundamentah.com', 2),
        ('o-gaimorite.ru', 2),
        ('ognyvo.ru', 2),
        ('ogodom.ru', 2),
        ('ogorod.guru', 2),
        ('ogorod-bez-hlopot.ru', 2),
        ('ogorodnik.guru', 2),
        ('ogrn.org', 2),
        ('ogrninfo.ru', 2),
        ('ohotniki.ru', 2),
        ('wday.ru', 1),
        ('okardio.com', 2),
        ('okato.net', 2),
        ('okoge.ru', 2),
        ('o-krohe.ru', 2),
        ('oktools.ru', 2),
        ('oliu.ru', 2),
        ('thequestion.ru', 3),
        ('olx.kz', 2),
        ('omaskah.ru', 2),
        ('omind.ru', 2),
        ('o-motoblokah.ru', 2),
        ('onbizy.com', 2),
        ('oncc.ru', 2),
        ('onedio.com', 2),
        ('onedio.ru', 2),
        ('onkolib.ru', 2),
        ('online812.ru', 2),
        ('onlinegdz.ru', 2),
        ('online-knigi.com', 2),
        ('onliner.by', 2),
        ('onlineur.ru', 2),
        ('only-holiday.ru', 2),
        ('ontvtime.ru', 2),
        ('on-woman.com', 2),
        ('onwomen.ru', 2),
        ('ooo-faq.ru', 2),
        ('oops.ru', 2),
        ('openoblokah.ru', 2),
        ('operaciya.info', 2),
        ('opitanii.net', 2),
        ('oppps.ru', 2),
        ('orakul.ru', 2),
        ('orange3.ru', 2),
        ('orchardo.ru', 2),
        ('orebenke.info', 2),
        ('orgpage.ru', 2),
        ('original-flowers.ru', 2),
        ('osteocure.ru', 2),
        ('ostirke.ru', 2),
        ('otchistka.com', 2),
        ('otdelka-expert.ru', 2),
        ('otendere.com', 2),
        ('oteplicah.ru', 2),
        ('otkritkiok.ru', 2),
        ('otoplenie-gid.ru', 2),
        ('otprazdnuem.com', 2),
        ('o-trubah.ru', 2),
        ('otvetclub.com', 2),
        ('otvetkak.ru', 2),
        ('otzovik.com', 2),
        ('otzovy.ru', 2),
        ('ourbaby.ru', 2),
        ('o-vannoy.ru', 2),
        ('ovideo.ru', 2),
        ('oxvo.ru', 2),
        ('oxycom.biz', 2),
        ('ozakone.com', 2),
        ('ozhkt.com', 2),
        ('ozrenii.com', 2),
        ('paidagogos.com', 2),
        ('pancreat.ru', 2),
        ('pancreatit.info', 2),
        ('pandia.ru', 2),
        ('paparazzi.ru', 2),
        ('paperdoc.ru', 2),
        ('parazity.com', 2),
        ('partprice.ru', 2),
        ('pasmi.ru', 2),
        ('passionforum.ru', 2),
        ('passportrus.ru', 2),
        ('pc01.ru', 2),
        ('pcpro100.info', 2),
        ('pediatriya.info', 2),
        ('ped-kopilka.ru', 2),
        ('pedsovet.su', 2),
        ('pensiology.ru', 2),
        ('pensiyaportal.ru', 2),
        ('peopletalk.ru', 2),
        ('peretz.ru', 2),
        ('permdom59.ru', 2),
        ('pesikot.org', 2),
        ('pfj.ru', 2),
        ('pics.ru', 2),
        ('pikabu.ru', 2),
        ('pishempravilno.ru', 2),
        ('pishi-stihi.ru', 2),
        ('piterburger.ru', 2),
        ('piter-realtor.ru', 2),
        ('pitomcy.net', 2),
        ('pitomec.guru', 2),
        ('pitomec.ru', 2),
        ('pixanews.com', 2),
        ('placesofrussia.ru', 2),
        ('placesrf.ru', 2),
        ('planeta-online.tv', 2),
        ('planetaorigami.ru', 2),
        ('planshetcomp.ru', 2),
        ('plantshouse.net', 2),
        ('plantsmed.net', 2),
        ('plastgid.ru', 2),
        ('plasticinform.com', 2),
        ('plastika.guru', 2),
        ('plateginfo.com', 2),
        ('plategonline.ru', 2),
        ('playboyrussia.com', 2),
        ('playbuzz.com', 2),
        ('playground.ru', 2),
        ('plussize-model.ru', 2),
        ('pmtoday.ru', 2),
        ('pochistim.com', 2),
        ('podborkadrov.com', 2),
        ('podkormka.guru', 2),
        ('podpricelom.com', 2),
        ('pogoda.org.ua', 2),
        ('pogoda1.ru', 2),
        ('pogoda12.ru', 2),
        ('pogoda360.ru', 2),
        ('pogoda7.ru', 2),
        ('pogoda-na-more.ru', 2),
        ('pogoda-v-adlere.ru', 2),
        ('pohudeemsami.ru', 2),
        ('poisk-ru.ru', 2),
        ('pokatim.ru', 2),
        ('pokodeksu.ru', 2),
        ('pokofemanim.ru', 2),
        ('pokoroche.ru', 2),
        ('pokrasote.com', 2),
        ('po-krupnomu.ru', 2),
        ('pokushay.ru', 2),
        ('polere.ru', 2),
        ('polit.info', 2),
        ('politexpert.net', 2),
        ('politfox.ru', 2),
        ('politikus.ru', 2),
        ('politobzor.net', 2),
        ('politonline.ru', 2),
        ('politpuzzle.ru', 2),
        ('politros.com', 2),
        ('pol-master.com', 2),
        ('polsov.com', 2),
        ('pol-spec.ru', 2),
        ('pol-z.ru', 2),
        ('polzovred.ru', 2),
        ('pomidorka.info', 2),
        ('ponylove.ru', 2),
        ('tarifkin.ru', 3),
        ('popmech.ru', 2),
        ('pora.ru', 2),
        ('porjati.ru', 2),
        ('poslerodov.pro', 2),
        ('posmotre.li', 2),
        ('posobie-expert.ru', 2),
        ('posobieguru.ru', 2),
        ('posobie-help.ru', 2),
        ('postroika.biz', 2),
        ('potolokmentor.ru', 2),
        ('potolokspec.ru', 2),
        ('povar.ru', 2),
        ('pravda.ru', 2),
        ('pravila-deneg.ru', 2),
        ('pravo-auto.com', 2),
        ('pravopark.ru', 2),
        ('pravoved24.ru', 2),
        ('prbn.ru', 2),
        ('predskazanie.ru', 2),
        ('pregnancycalendar.ru', 2),
        ('prelest.com', 2),
        ('pressa.tv', 2),
        ('pricesguru.ru', 2),
        ('primechaniya.ru', 2),
        ('prisnilos.su', 2),
        ('pristav-russia.org', 2),
        ('privorot.expert', 2),
        ('proakril.com', 2),
        ('pro-allergen.ru', 2),
        ('proantiage.ru', 2),
        ('probankrotstvo.com', 2),
        ('probp.ru', 2),
        ('prodetey.ru', 2),
        ('prodveri.guru', 2),
        ('professionali.ru', 2),
        ('profguide.ru', 2),
        ('profinance.ru', 2),
        ('proglaza.ru', 2),
        ('pro-goszakaz.ru', 2),
        ('programma-molodaja-semja.ru', 2),
        ('programmist1s.ru', 2),
        ('prokyr.ru', 2),
        ('pro-materinskiy-kapital.ru', 2),
        ('promesyachnye.ru', 2),
        ('promobila.info', 2),
        ('promodu.com', 2),
        ('pro-motobloky.ru', 2),
        ('pronedra.ru', 2),
        ('propartner.ru', 2),
        ('pro-personal.ru', 2),
        ('propertyhelp.ru', 2),
        ('pro-poly.ru', 2),
        ('proprovoda.ru', 2),
        ('prorab.guru', 2),
        ('proremontpk.ru', 2),
        ('proroofer.ru', 2),
        ('pro-selhoz.ru', 2),
        ('prospinu.com', 2),
        ('prossto.pro', 2),
        ('prostata.guru', 2),
        ('prosto-top.com', 2),
        ('prostrahovanie24.ru', 2),
        ('prostudynet.ru', 2),
        ('prosud24.ru', 2),
        ('protezi-zubov.ru', 2),
        ('protoxin.ru', 2),
        ('pro-traktor.ru', 2),
        ('pro-tv.net', 2),
        ('pro-uteplenie.ru', 2),
        ('provodim24.ru', 2),
        ('proydem.ru', 2),
        ('prozvezd.info', 2),
        ('psihotesti.ru', 2),
        ('psinovo.ru', 2),
        ('psoriazinform.ru', 2),
        ('psyfiles.ru', 2),
        ('publy.ru', 2),
        ('pulscen.ru', 2),
        ('pulse32.ru', 2),
        ('puzzleheap.ru', 2),
        ('qashqairussia.ru', 2),
        ('qip.ru', 2),
        ('qiwiq.ru', 2),
        ('querycom.ru', 2),
        ('rabota.by', 2),
        ('rabotis.com', 2),
        ('radikal.ru', 2),
        ('radiokot.ru', 2),
        ('radionetplus.ru', 2),
        ('radioromantika.ru', 2),
        ('radiozvezda.ru', 2),
        ('rantac.ru', 2),
        ('rap.ru', 2),
        ('rasfokus.ru', 2),
        ('rasprodaga.ru', 2),
        ('razdeti.ru', 2),
        ('razlozhi.ru', 2),
        ('razvod-gid.ru', 2),
        ('razvodka.com', 2),
        ('rb-edu.ru', 2),
        ('read-book.ru', 2),
        ('readovka.ru', 2),
        ('realt.by', 2),
        ('realtymag.ru', 2),
        ('realtyurist.ru', 2),
        ('rebenok.by', 2),
        ('recepti.tv', 2),
        ('redmediatv.ru', 2),
        ('refite.ru', 2),
        ('reg67.ru', 2),
        ('regmarkets.ru', 2),
        ('regnum.ru', 2),
        ('subscribe.ru', 3),
        ('regrus.ru', 2),
        ('relax.by', 2),
        ('relax-fm.ru', 2),
        ('relbox.ru', 2),
        ('release-series.com', 2),
        ('remkasam.ru', 2),
        ('remnabor.net', 2),
        ('remont220.ru', 2),
        ('remont-express.ru', 2),
        ('remont-samomy.ru', 2),
        ('remoskop.ru', 2),
        ('remotvet.ru', 2),
        ('removecom.ru', 2),
        ('remrep.ru', 2),
        ('ren.tv', 2),
        ('renaultlogan2.ru', 2),
        ('rent-and-sale.com', 2),
        ('renteres.com', 2),
        ('ren-tv.com', 2),
        ('rep.ru', 2),
        ('repaireasily.ru', 2),
        ('repairshome.ru', 2),
        ('repost.uz', 2),
        ('reshak.ru', 2),
        ('reshator.ru', 2),
        ('reshebnik.com', 2),
        ('reshuege.ru', 2),
        ('resobr.ru', 2),
        ('rg.ru', 2),
        ('rh.by', 2),
        ('riafan.ru', 2),
        ('ribalka.guru', 2),
        ('ribalych.ru', 2),
        ('ridus.ru', 2),
        ('rmnt.ru', 2),
        ('rnk.ru', 2),
        ('rockstar-games.ru', 2),
        ('rodinkam.com', 2),
        ('rodinkam.net', 2),
        ('roofs.club', 2),
        ('roof-tops.ru', 2),
        ('rosbalt.ru', 2),
        ('rospromportal.ru', 2),
        ('rosregistr.ru', 2),
        ('rostov-lovers.ru', 2),
        ('rsute.ru', 2),
        ('rt.com', 2),
        ('rtvi.com', 2),
        ('ruback.ru', 2),
        ('rubankom.com', 2),
        ('rubrikator.su', 2),
        ('rubrikator24.ru', 2),
        ('rubrikatorrf.ru', 2),
        ('rueconomics.ru', 2),
        ('rumeteo.ru', 2),
        ('runaruna.ru', 2),
        ('ruonc.ru', 2),
        ('ruposters.ru', 2),
        ('rusanalogi.ru', 2),
        ('rusceo.com', 2),
        ('rusday.com', 2),
        ('rusdemotivator.ru', 2),
        ('rusdialog.ru', 2),
        ('rusdtp.ru', 2),
        ('rusegodnya.ru', 2),
        ('rusfolder.com', 2),
        ('rusfootball.info', 2),
        ('ruslar.ru', 2),
        ('rusplt.ru', 2),
        ('ruspravka.org', 2),
        ('rusprofile.ru', 2),
        ('russia-companies.ru', 2),
        ('russian7.ru', 2),
        ('russianfirms.ru', 2),
        ('russianfood.com', 2),
        ('russianpost.su', 2),
        ('russkiiyazyk.ru', 2),
        ('rus-tv.su', 2),
        ('rusvesna.su', 2),
        ('rutube.ru', 2),
        ('rutwitter.com', 2),
        ('ruzakaz.com', 2),
        ('rydo.ru', 2),
        ('sadovij-instrument.ru', 2),
        ('sadovij-pomoshnik.ru', 2),
        ('sadovodka.ru', 2),
        ('sadovodu.com', 2),
        ('safetymoscow.ru', 2),
        ('sagtmodig.ru', 2),
        ('salat-legko.ru', 2),
        ('saldovka.com', 2),
        ('samnews.ru', 2),
        ('samsung-galaxy.mobi', 2),
        ('samsunggalaxytabblog.ru', 2),
        ('saphris.ru', 2),
        ('savefrom.net', 2),
        ('sazhaemvsadu.ru', 2),
        ('sb.by', 2),
        ('sbankami.ru', 2),
        ('sber-info.com', 2),
        ('sberometer.ru', 2),
        ('schetavbanke.com', 2),
        ('scoot-club.ru', 2),
        ('sdelai-lestnicu.ru', 2),
        ('sdelai-zabor.ru', 2),
        ('sdelala-sama.ru', 2),
        ('sdnnet.ru', 2),
        ('sekretariat.ru', 2),
        ('selhoz.guru', 2),
        ('semeinoe-pravo.net', 2),
        ('seplace.ru', 2),
        ('septik.guru', 2),
        ('septikland.ru', 2),
        ('serdcedoc.com', 2),
        ('setquest.com', 2),
        ('sharknews.ru', 2),
        ('shbnews.ru', 2),
        ('shipcity.ru', 2),
        ('shkolabuduschego.ru', 2),
        ('shkolapola.club', 2),
        ('shkolazhizni.ru', 2),
        ('shopsave.ru', 2),
        ('showbiz-life.ru', 2),
        ('showjet.ru', 2),
        ('shpilki.net', 2),
        ('shpuntel.ru', 2),
        ('sibdating.ru', 2),
        ('sprashivalka.com', 3),
        ('sigareta.guru', 2),
        ('signorina.ru', 2),
        ('simpa-simpa.com', 2),
        ('simptomy-i-lechenie.net', 2),
        ('sinoptik.com.ru', 2),
        ('siteproremont.ru', 2),
        ('sjthemes.com', 2),
        ('sk1project.org', 2),
        ('skanvordoff.ru', 2),
        ('skesov.ru', 2),
        ('skidkaonline.ru', 2),
        ('skidkimarket.ru', 2),
        ('skinfaq.ru', 2),
        ('skinwell.ru', 2),
        ('skolkovarim.ru', 2),
        ('sloosh.ru', 2),
        ('slovodel.com', 2),
        ('slovomaga.ru', 2),
        ('slovonovo.ru', 2),
        ('smart-lab.ru', 2),
        ('smartsearchapp.com', 2),
        ('sml-stb.ru', 2),
        ('smo333.com', 2),
        ('smolensk2.ru', 2),
        ('smolmama.ru', 2),
        ('smolnews.ru', 2),
        ('smotri.com', 2),
        ('snatchnews.com', 2),
        ('snitsya-son.ru', 2),
        ('sntat.ru', 2),
        ('sobakada.ru', 2),
        ('sobaki.guru', 2),
        ('sobesednik.ru', 2),
        ('sobut.ru', 2),
        ('soccer.ru', 2),
        ('sochinenieliteratura.com', 2),
        ('sochinenienatemu.com', 2),
        ('sochinenienatemupro.ru', 2),
        ('sochinenietut.ru', 2),
        ('sonme.ru', 2),
        ('sonnik-enigma.ru', 2),
        ('sooo.ru', 2),
        ('sornyakov.net', 2),
        ('sorokulya.ru', 2),
        ('sostatusom.ru', 2),
        ('sosudinfo.ru', 2),
        ('sovdok.ru', 2),
        ('sovet.help', 2),
        ('sovets.net', 2),
        ('sovets24.ru', 2),
        ('sovsport.ru', 2),
        ('spbvoditel.ru', 2),
        ('speak-hebrew.ru', 2),
        ('spellonyou.ru', 2),
        ('spina-health.ru', 2),
        ('spina-sustav.ru', 2),
        ('spishi.ru', 2),
        ('sport-express.ru', 2),
        ('sportliga.com', 2),
        ('sports.ru', 2),
        ('spr.ru', 2),
        ('spravinfo.ru', 2),
        ('spravka.me', 2),
        ('spravka.today', 2),
        ('spravka1.biz', 2),
        ('spravka24.su', 2),
        ('spravkakirova.ru', 2),
        ('spravkarf.ru', 2),
        ('spravkarf.su', 2),
        ('spravkarf24.ru', 2),
        ('spravkaru.info', 2),
        ('spravker.ru', 2),
        ('spravkus.com', 2),
        ('spravochnik.city', 2),
        ('spravochnikov.ru', 2),
        ('sptoday.ru', 2),
        ('sptovarov.ru', 2),
        ('spuzom.ru', 2),
        ('stanok.guru', 2),
        ('starfate.ru', 2),
        ('star-magazine.ru', 2),
        ('stavcur.ru', 2),
        ('steven-jobs.ru', 2),
        ('stockmap.ru', 2),
        ('stoma.guru', 2),
        ('stopgripp.ru', 2),
        ('stopvaric.ru', 2),
        ('stopvarikoz.net', 2),
        ('storub.ru', 2),
        ('stozabot.com', 2),
        ('strananaladoni.ru', 2),
        ('strana-sovetov.com', 2),
        ('stranavstrech.ru', 2),
        ('strmnt.com', 2),
        ('stroy-aqua.com', 2),
        ('stroy-banya.com', 2),
        ('stroyday.ru', 2),
        ('stroydom.guru', 2),
        ('stroykat.com', 2),
        ('stroy-podskazka.ru', 2),
        ('stroyres.net', 2),
        ('structum.ru', 2),
        ('studbooks.net', 2),
        ('studexpo.ru', 2),
        ('studfiles.net', 2),
        ('studfiles.ru', 2),
        ('studme.org', 2),
        ('studopedia.com.ua', 2),
        ('studopedia.info', 2),
        ('studopedia.org', 2),
        ('studopedia.ru', 2),
        ('studopedia.su', 2),
        ('studopedya.ru', 2),
        ('studref.com', 2),
        ('studwood.ru', 2),
        ('stydopedia.ru', 2),
        ('stydopedya.ru', 2),
        ('subcar.org', 2),
        ('sibnet.ru', 3),
        ('sudguru.ru', 2),
        ('sudotvet.ru', 2),
        ('sueveriya.ru', 2),
        ('suharewa.ru', 2),
        ('sundekor.ru', 2),
        ('superbotanik.net', 2),
        ('supercoolpics.com', 2),
        ('superinvestor.ru', 2),
        ('supersadovnik.ru', 2),
        ('supersadovod.ru', 2),
        ('superstyle.ru', 2),
        ('sustav.info', 2),
        ('sustavzdorov.ru', 2),
        ('svadba-russia.ru', 2),
        ('svadbavo.ru', 2),
        ('svali.ru', 2),
        ('svejse.ru', 2),
        ('svekrovi.net', 2),
        ('svoimi-rykami.ru', 2),
        ('svopi.ru', 2),
        ('svoyabesedka.ru', 2),
        ('svpressa.ru', 2),
        ('talks.by', 2),
        ('tarakanam.com', 2),
        ('taratorka.ru', 2),
        ('tass.ru', 2),
        ('tayniymir.com', 2),
        ('tchesnok.ru', 2),
        ('tearoad.ru', 2),
        ('teender.ru', 2),
        ('teenslang.su', 2),
        ('tehnopanorama.ru', 2),
        ('tehznatok.com', 2),
        ('tekstil.guru', 2),
        ('teleprogramma.pro', 2),
        ('telzir.ru', 2),
        ('temperatura03.ru', 2),
        ('tendus.org', 2),
        ('tengrinews.kz', 2),
        ('tenox.ru', 2),
        ('teplica-i-parnik.ru', 2),
        ('teplichniku.ru', 2),
        ('teplicnik.ru', 2),
        ('teplo.guru', 2),
        ('teploclass.ru', 2),
        ('teploguru.ru', 2),
        ('terrafaq.ru', 2),
        ('terrnews.com', 2),
        ('text.ru', 2),
        ('textologia.ru', 2),
        ('theecology.ru', 2),
        ('sdelanounas.ru', 3),
        ('theuk.one', 2),
        ('thrombo.ru', 2),
        ('ti-boginya-detka.ru', 2),
        ('tiensmed.ru', 2),
        ('tiguans.ru', 2),
        ('tikitoki.ru', 2),
        ('tilbagevise.ru', 2),
        ('timbr.ru', 2),
        ('time4lime.ru', 2),
        ('timeskaner.ru', 2),
        ('tipdoma.com', 2),
        ('tivizor.ru', 2),
        ('tizu.ru', 2),
        ('today.kz', 2),
        ('tolkru.com', 2),
        ('tolstosym.com', 2),
        ('tonkosti.ru', 2),
        ('tonusmozga.ru', 2),
        ('top10a.ru', 2),
        ('top10deals.ru', 2),
        ('top10s.ru', 2),
        ('topcor.ru', 2),
        ('topmigrant.ru', 2),
        ('topnews.ru', 2),
        ('toppotolok.su', 2),
        ('topwar.ru', 2),
        ('tormozi.ru', 2),
        ('toster.ru', 2),
        ('toxinam.net', 2),
        ('track24.ru', 2),
        ('trailerstube.ru', 2),
        ('travelask.ru', 2),
        ('travelata.ru', 2),
        ('trenirofka.ru', 2),
        ('trental.ru', 2),
        ('regreestr.com', 3),
        ('trubsovet.ru', 2),
        ('truck-auto.info', 2),
        ('trud.com', 2),
        ('trudohrana.ru', 2),
        ('tsargrad.tv', 2),
        ('tspor.ru', 2),
        ('tuningkod.ru', 2),
        ('tuning-lada-2109.ru', 2),
        ('tuningtaza.ru', 2),
        ('turizmik.ru', 2),
        ('turtella.ru', 2),
        ('tut.by', 2),
        ('tutmet.ru', 2),
        ('tutu.ru', 2),
        ('readmanga.me', 3),
        ('tvgid.ua', 2),
        ('tvigle.ru', 2),
        ('tvmir.tv', 2),
        ('tvoe-ip.ru', 2),
        ('tvoikot.ru', 2),
        ('tvoi-setevichok.ru', 2),
        ('tvoiugolok.ru', 2),
        ('tvoyadres.ru', 2),
        ('tvoyaspravka.ru', 2),
        ('tvoyastrana.su', 2),
        ('tvoytrener.com', 2),
        ('tvoytrener.ru', 2),
        ('tvr.by', 2),
        ('tvrain.ru', 2),
        ('tvzavr.ru', 2),
        ('tvzvezda.ru', 2),
        ('twizz.ru', 2),
        ('uborka.co', 2),
        ('uchastie.com', 2),
        ('uchcom.biz', 2),
        ('uchebe.net', 2),
        ('uchiyaziki.ru', 2),
        ('udf.by', 2),
        ('udobreniya.info', 2),
        ('uduba.com', 2),
        ('u-f.ru', 2),
        ('ufatut.ru', 2),
        ('ugolovka.com', 2),
        ('ugolovnyi-expert.com', 2),
        ('ugpr.ru', 2),
        ('ugrozenet.ru', 2),
        ('uhonos.ru', 2),
        ('ulov.guru', 2),
        ('ultra-term.ru', 2),
        ('umnaja.ru', 2),
        ('unfall.ru', 2),
        ('up2go.ru', 2),
        ('upjobs.ru', 2),
        ('ura.news', 2),
        ('uralpolit.ru', 2),
        ('urank.ru', 2),
        ('urhelp.guru', 2),
        ('uriston.com', 2),
        ('urned.net', 2),
        ('urohelp.guru', 2),
        ('urologinfo.com', 2),
        ('urpravo24.ru', 2),
        ('usa.one', 2),
        ('usatiki.ru', 2),
        ('uslugu4u.ru', 2),
        ('ustaliy.ru', 2),
        ('utro.ru', 2),
        ('uznayvse.ru', 2),
        ('v4k.online', 2),
        ('vamsochinenie.ru', 2),
        ('vamzabor.net', 2),
        ('vancomycin.ru', 2),
        ('vannadecor.ru', 2),
        ('vannadizain.ru', 2),
        ('vannaguide.ru', 2),
        ('vashaginekologiya.ru', 2),
        ('vasha-teplitsa.ru', 2),
        ('vashechudo.ru', 2),
        ('vashflebolog.ru', 2),
        ('vash-ginecolog.ru', 2),
        ('vashurok.ru', 2),
        ('vazhno.ru', 2),
        ('vazremont.com', 2),
        ('vdecret.ru', 2),
        ('v-dome-deti.ru', 2),
        ('velosipedinfo.ru', 2),
        ('venture-biz.ru', 2),
        ('verena.ru', 2),
        ('versiya.info', 2),
        ('woman.ru', 1),
        ('vesti-ukr.com', 2),
        ('vetinpharm.com', 2),
        ('videomore.ru', 2),
        ('vigortrade.ru', 2),
        ('villaved.ru', 2),
        ('v-interere.ru', 2),
        ('vippe.ru', 2),
        ('v-ispanii.com', 2),
        ('vistanews.ru', 2),
        ('vitaminki.guru', 2),
        ('vizaguide.ru', 2),
        ('vkadry.com', 2),
        ('vklad.ru', 2),
        ('vkusneedoma.ru', 2),
        ('vladtime.ru', 2),
        ('vm.ru', 2),
        ('vmdaily.ru', 2),
        ('vneshpol.ru', 2),
        ('vnutri.info', 2),
        ('vodila-help.com', 2),
        ('vokrug.tv', 2),
        ('vokrugdachi.com', 2),
        ('vokrugsmeha.info', 2),
        ('volna.org', 2),
        ('volosy.me', 2),
        ('volt220.ru', 2),
        ('vopros-remont.ru', 2),
        ('votbankrot.ru', 2),
        ('vplate.ru', 2),
        ('vrachmedik.ru', 2),
        ('vsegdazdorov.net', 2),
        ('vseobalkone.ru', 2),
        ('vseokino.com', 2),
        ('vse-o-tattoo.ru', 2),
        ('vseotrubax.com', 2),
        ('vseproip.com', 2),
        ('vseshtory.com', 2),
        ('vsezdorovo.com', 2),
        ('vsluh.net', 2),
        ('vstrogino.ru', 2),
        ('v-teple.com', 2),
        ('vusadebke.com', 2),
        ('vuzlit.ru', 2),
        ('vz.ru', 2),
        ('vzglyadzagran.ru', 2),
        ('warfiles.ru', 2),
        ('wd-x.ru', 2),
        ('webautoblog.ru', 2),
        ('webdiana.ru', 2),
        ('webhostingtalk.ru', 2),
        ('web-kapiche.ru', 2),
        ('websad.ru', 2),
        ('weburologiya.ru', 2),
        ('weddingadvice.ru', 2),
        ('wehelp.ru', 2),
        ('welinux.ru', 2),
        ('wellady.ru', 2),
        ('whoch.biz', 2),
        ('whokpo.com', 2),
        ('wikia.com', 2),
        ('wikihow.com', 2),
        ('wikiotzyv.org', 2),
        ('wikipage.com.ua', 2),
        ('wikispravka.ru', 2),
        ('winblog.ru', 2),
        ('windows-phone-7.su', 2),
        ('withoutallergy.com', 2),
        ('wlooks.ru', 2),
        ('wologda.ru', 2),
        ('woman365.ru', 2),
        ('womanadvice.ru', 2),
        ('womanhit.ru', 2),
        ('womanmir.net', 2),
        ('womanspb.ru', 2),
        ('womee.ru', 2),
        ('womensmed.ru', 2),
        ('womond.com', 2),
        ('qrz.ru', 3),
        ('working-papers.ru', 2),
        ('worldorchids.ru', 2),
        ('worldseatemp.com', 2),
        ('world-weather.by', 2),
        ('world-weather.ru', 2),
        ('wow-helper.com', 2),
        ('wpfree.ru', 2),
        ('wpincode.com', 2),
        ('wtalks.com', 2),
        ('xcook.info', 2),
        ('xeff.ru', 2),
        ('xsport.ua', 2),
        ('xstud.ru', 2),
        ('yagdz.com', 2),
        ('yagodka.club', 2),
        ('yaplakal.com', 2),
        ('ya-superpuper.com', 2),
        ('yconsult.ru', 2),
        ('yecom.ru', 2),
        ('yellcity.ru', 2),
        ('yellcom.ru', 2),
        ('yellua.ru', 2),
        ('ygholding.ru', 2),
        ('yofi-tofi.ru', 2),
        ('yoki.ru', 2),
        ('youbeauty.ru', 2),
        ('yurday.ru', 2),
        ('yurface.ru', 2),
        ('yuristi.org', 2),
        ('yuristlab.ru', 2),
        ('zaborprofnastil.ru', 2),
        ('zadolba.li', 2),
        ('zagolovki.ru', 2),
        ('zagony.ru', 2),
        ('zagorod-47.ru', 2),
        ('zagorod-50.ru', 2),
        ('zagran.guru', 2),
        ('zagrandok.ru', 2),
        ('zagranportal.ru', 2),
        ('zahav.ru', 2),
        ('zaimexpert.ru', 2),
        ('zaimgid.ru', 2),
        ('zakabanom.ru', 2),
        ('zakgo.ru', 2),
        ('zakonmaster.ru', 2),
        ('zakonprost.ru', 2),
        ('zakonrus.ru', 2),
        ('zakulisi.ru', 2),
        ('zamzy.tv', 2),
        ('za-partoi.ru', 2),
        ('zarplata-online.ru', 2),
        ('zaryadka.guru', 2),
        ('zaschita-prav.com', 2),
        ('zastavki.com', 2),
        ('zataskaem.ru', 2),
        ('zavtrasessiya.com', 2),
        ('zaycev.fm', 2),
        ('zaycev.net', 2),
        ('zaymcentr.ru', 2),
        ('zaympro.ru', 2),
        ('zaymrus.ru', 2),
        ('zdorovja.com.ua', 2),
        ('zdorpechen.ru', 2),
        ('zdrav.ru', 2),
        ('zdravskin.com', 2),
        ('zeftera.ru', 2),
        ('zelv.ru', 2),
        ('zhdumalisha.ru', 2),
        ('zhenomaniya.ru', 2),
        ('popcornnews.ru', 3),
        ('ziv.ru', 2),
        ('znak.com', 2),
        ('znakomstva.ru', 2),
        ('znakomstva.ua', 2),
        ('znakomstva-chelyabinsk.ru', 2),
        ('znanija.com', 2),
        ('znatokprava.ru', 2),
        ('znaybiz.ru', 2),
        ('znaydelo.ru', 2),
        ('znaymama.ru', 2),
        ('zodiak.com.ru', 2),
        ('zoobrilka.org', 2),
        ('zoohoz.ru', 2),
        ('zoolog.guru', 2),
        ('zoon.ru', 2),
        ('zooproblemnet.ru', 2),
        ('zootvet.ru', 2),
        ('zoowka.com', 2),
        ('zr.ru', 2),
        ('zubki2.ru', 2),
        ('zubzone.ru', 2),
        ('zvezdaweekly.ru', 2),
        ('zvezdi.ru', 2),
        ('идея-малого-бизнеса.рф', 2),
        ('компании.онлайн', 2),
        ('компаниирф.рф', 2),
        ('лада.онлайн', 2),
        ('лада2111.рф', 2),
        ('лечим-грибок.рф', 2),
        ('олекарствах.сайт', 2),
        ('отзывырф.рф', 2),
        ('офирмах.сайт', 2),
        ('предприятия.онлайн', 2),
        ('россиясейчас.рф', 2),
        ('рубрикатор.онлайн', 2),
        ('справкарф.онлайн', 2),
        ('странаналадони.рф', 2),
        ('твоястрана.рф', 2),
        ('твояфирма.рф', 2),
        ('телефонырф.рф', 2),
        ('фирмырф.рф', 2),
        ('читать-онлайн.com.ua', 2),
        ('football-pitch.ru', 2),
        ('zabavnik.club', 2),
        ('34mag.net', 2),
        ('iz.ru', 2),
        ('34travel.me', 2),
        ('xabar.uz', 2),
        ('celebnic.net', 2),
        ('medbotanica.net', 2),
        ('zdravman.com', 2),
        ('vidos.cc', 2),
        ('bookmp3.ru', 2),
        ('nazimu.info', 2),
        ('povar24.info', 2),
        ('gadaniya.me', 2),
        ('pridiabete.ru', 2),
        ('allinsurance.kz', 2),
        ('pensiapro24.ru', 2),
        ('kurjer.info', 2),
        ('piteronline.tv', 2),
        ('greatlove.ru', 2),
        ('sarinform.ru', 2),
        ('shoubiz.guru', 2),
        ('animalgrow.com', 2),
        ('all.soccer', 2),
        ('tribuna.uz', 2),
        ('wfin.kz', 2),
        ('hendmeid.guru', 2),
        ('recipes365.ru', 2),
        ('uoperatora.ru', 2),
        ('ezoterika.me', 2),
        ('sovety.guru', 2),
        ('zrenie.me', 2),
        ('autouristpro.ru', 2),
        ('lgotywiki.ru', 2),
        ('passportwiki.ru', 2),
        ('realtyaudit.ru', 2),
        ('womanwin.ru', 2),
        ('newzfeed.ru', 2),
        ('upet.com', 2),
        ('ugolovnichek.ru', 2),
        ('osudili.ru', 2),
        ('vsetravel.ru', 2),
        ('mistika.club', 2),
        ('sindrom.info', 2),
        ('nl-catalog.com', 2),
        ('udargol.com', 2),
        ('obrazovaka.ru', 2),
        ('goscontract.info', 2),
        ('gosuchetnik.ru', 2),
        ('okey.uz', 2),
        ('topmusic.uz', 2),
        ('if24.ru', 2),
        ('bricknews.ru', 2),
        ('uz24.uz', 2),
        ('pokroyka.ru', 2),
        ('denezniypotok.com', 2),
        ('avtozakon.guru', 2),
        ('lazycom.ru', 2),
        ('okatocom.ru', 2),
        ('reabiz.ru', 2),
        ('domovod.guru', 2),
        ('god-2019.ru', 2),
        ('translit-online.ru', 2),
        ('5erka.com', 2),
        ('gdzavr.org', 2),
        ('gdzpop.net', 2),
        ('tn.kz', 2),
        ('minsknews.by', 2),
        ('prohvost.club', 2),
        ('modevice.pro', 2),
        ('inn-kuban.ru', 2),
        ('vwauto.club', 2),
        ('megogo.ru', 2),
        ('massaget.kz', 2),
        ('epil.guru', 2),
        ('imena.guru', 2),
        ('molodei.com', 2),
        ('4pda.ru', 2),
        ('superjob.ru', 3),
        ('polzavred.ru', 3),
        ('pozdravok.ru', 2),
        ('laim.tv', 3),
        ('consultant.ru', 2),
        ('instagramm.ru', 3),
        ('ati.su', 3),
        ('aviasales.ru', 3),
        ('stadion.uz', 3),
        ('stormo.tv', 3),
        ('litnet.com', 3),
        ('postila.ru', 3),
        ('ololo.tv', 3),
        ('sakh.com', 3),
        ('rabota.ru', 3),
        ('shikimori.org', 3),
        ('spletnik.ru', 2),
        ('sprashivai.ru', 3),
        ('faberlic-i.ru', 3),
        ('cian.ru', 2),
        ('3ddd.ru', 3),
        ('fragrantica.ru', 3),
        ('livelib.ru', 3),
        ('euronews.com', 3),
        ('shararam.ru', 3),
        ('novorosinform.org', 3),
        ('e-katalog.ru', 3),
        ('mangalib.me', 3),
        ('mover.uz', 3),
        ('povarenok.ru', 3),
        ('nashaspravka.ru', 3),
        ('audioknigi.club', 3),
        ('ringon.pro', 3),
        ('autopiter.ru', 3),
        ('test.msk.ru', 3),
        ('poezdato.net', 3),
        ('goodfon.ru', 3),
        ('championat.asia', 3),
        ('football.ua', 3),
        ('stapico.ru', 3),
        ('bazarpnz.ru', 3),
        ('ucheba.ru', 3),
        ('amalgama-lab.com', 3),
        ('ранобэ.рф', 3),
        ('trashbox.ru', 3),
        ('medialeaks.ru', 2),
        ('knigavuhe.ru', 3),
        ('piluli.ru', 2),
        ('stranamam.ru', 3),
        ('orsk.ru', 3),
        ('24-ok.ru', 3),
        ('mts.ru', 2),
        ('move.ru', 3),
        ('mahnem.ru', 3),
        ('alpha-ag.ru', 3),
        ('all.biz', 3),
        ('mir24.tv', 3),
        ('bombardir.ru', 3),
        ('rlsnet.ru', 3),
        ('overclockers.ru', 3),
        ('list.am', 3),
        ('f1news.ru', 3),
        ('sibmama.ru', 3),
        ('schlock.ru', 3),
        ('tourister.ru', 3),
        ('otzyv.ru', 3),
        ('teamo.ru', 3),
        ('gisher.org', 3),
        ('kosmetista.ru', 3),
        ('awd.ru', 3),
        ('multoigri.ru', 3),
        ('b17.ru', 3),
        ('sexlib.org', 3),
        ('cybersport.ru', 3),
        ('acomics.ru', 3),
        ('mediametrics.ru', 3),
        ('sunhome.ru', 3),
        ('телеграмм.онлайн', 3),
        ('kolesa.ru', 3),
        ('mintmanga.com', 3),
        ('220vk.com', 3),
        ('gl5.ru', 3),
        ('reverso.net', 3),
        ('onlinetestpad.com', 3),
        ('pancafepro.com', 3),
        ('pravoved.ru', 3),
        ('livemaster.ru', 2),
        ('3dnews.ru', 3),
        ('tjournal.ru', 2),
        ('na-svyazi.ru', 3),
        ('nsn.fm', 3),
        ('galya.ru', 3),
        ('yesasia.ru', 3),
        ('zachestnyibiznes.ru', 3),
        ('vprognoze.ru', 3),
        ('modxvm.com', 3),
        ('newauction.ru', 3),
        ('korzik.net', 3),
        ('musavat.com', 3),
        ('klops.ru', 3),
        ('game01.ru', 3),
        ('avtodispetcher.ru', 3),
        ('alimero.ru', 3),
        ('gamemodding.net', 3),
        ('the-village.ru', 2),
        ('mytube.uz', 3),
        ('snob.ru', 2),
        ('forbes.ru', 2),
        ('poncy.ru', 3),
        ('babyplan.ru', 3),
        ('sravni.ru', 2),
        ('youdo.com', 3),
        ('darudar.org', 3),
        ('forum.ykt.ru', 3),
        ('ondom2.com', 3),
        ('mangaclub.ru', 3),
        ('promodj.com', 3),
        ('kak2z.ru', 3),
        ('wooordhunt.ru', 3),
        ('allhockey.ru', 3),
        ('naviny.by', 3),
        ('invi.tv', 3),
        ('mlsn.ru', 3),
        ('gotovim-doma.ru', 3),
        ('diary.ru', 3),
        ('votpusk.ru', 3),
        ('life-dom2.su', 3),
        ('kasparov.ru', 3),
        ('playcast.ru', 3),
        ('car.ru', 3),
        ('twirpx.com', 3),
        ('hellomagazine.com', 2),
        ('amur.info', 3),
        ('fotokto.ru', 3),
        ('zakupka.com', 3),
        ('cmlt.ru', 3),
        ('1in.am', 3),
        ('vtomske.ru', 3),
        ('d3.ru', 3),
        ('ivbb.ru', 3),
        ('calc.ru', 3),
        ('radiorecord.ru', 3),
        ('agroserver.ru', 3),
        ('center-yf.ru', 3),
        ('voenhronika.ru', 3),
        ('mamochka-club.com', 3),
        ('dnevnik.ru', 3),
        ('gdepapa.ru', 3),
        ('mirkosmosa.ru', 3),
        ('litlife.club', 3),
        ('bankturov.ru', 3),
        ('vse42.ru', 3),
        ('bmwclub.ru', 3),
        ('facenews.ua', 3),
        ('barahla.net', 3),
        ('neolove.ru', 3),
        ('sevastopol.info', 3),
        ('neboleem.net', 3),
        ('vsekolledzhi.ru', 3),
        ('netbynet.ru', 3),
        ('rosrabota.ru', 3),
        ('1777.ru', 3),
        ('caniplay.ru', 3),
        ('moeobrazovanie.ru', 3),
        ('calorizator.ru', 3),
        ('madmuzel.ru', 3),
        ('ng.ru', 3),
        ('rusnext.ru', 3),
        ('news-front.info', 3),
        ('yell.ru', 3),
        ('vuzoteka.ru', 3),
        ('avtomarket.ru', 3),
        ('blognews.am', 3),
        ('oko-planet.su', 3),
        ('sterlegrad.ru', 3),
        ('be-in.ru', 3),
        ('mam4.ru', 3),
        ('гибдд-дпс.рф', 3),
        ('jv.ru', 3),
        ('tatarlove.ru', 3),
        ('littlebigsnake.com', 3),
        ('spaces.ru', 3),
        ('altapress.ru', 3),
        ('ogorod.ru', 3),
        ('sevastopol.su', 3),
        ('chipmaker.ru', 3),
        ('muz-tv.ru', 3),
        ('mfd.ru', 3),
        ('weburg.net', 3),
        ('tripodrugi.ru', 3),
        ('tragos.ru', 3),
        ('ru-an.info', 3),
        ('cyberleninka.ru', 3),
        ('kodifikant.ru', 3),
        ('avia.pro', 3),
        ('rutxt.ru', 3),
        ('wikireading.ru', 3),
        ('saletur.ru', 3),
        ('proshoper.ru', 3),
        ('экзон.рф', 3),
        ('centro-pol.ru', 3),
        ('stoboi.ru', 3),
        ('hiterbober.ru', 3),
        ('fermer.ru', 3),
        ('mediasole.ru', 3),
        ('wikimapia.org', 3),
        ('kakzovut.ru', 3),
        ('newsvideo.su', 3),
        ('simptomy-lechenie.net', 3),
        ('inpearls.ru', 3),
        ('astrocentr.ru', 3),
        ('proufu.ru', 3),
        ('espec.ws', 3),
        ('alcofan.com', 3),
        ('jobinmoscow.ru', 3),
        ('medaboutme.ru', 3),
        ('drivenn.ru', 3),
        ('compromat.ru', 3),
        ('onrealt.ru', 3),
        ('medi.ru', 3),
        ('dp.ru', 3),
        ('ekabu.ru', 3),
        ('damataro.ru', 3),
        ('jobfilter.ru', 3),
        ('fapl.ru', 3),
        ('rubrikator.org', 3),
        ('ladyelena.ru', 3),
        ('footballhd.ru', 3),
        ('mel.fm', 3),
        ('marshruty.ru', 3),
        ('sidex.ru', 3),
        ('sdelaysam-svoimirukami.ru', 3),
        ('moika78.ru', 3),
        ('nalog-nalog.ru', 3),
        ('dailyhoro.ru', 3),
        ('oka.fm', 3),
        ('mama66.ru', 3),
        ('govoritmoskva.ru', 3),
        ('lovefond.ru', 3),
        ('versia.ru', 3),
        ('bipbap.ru', 3),
        ('vashgorod.ru', 3),
        ('zavtra.ru', 3),
        ('vodakanazer.ru', 3),
        ('diletant.media', 3),
        ('003ms.ru', 3),
        ('domkino.tv', 3),
        ('build-experts.ru', 3),
        ('ya62.ru', 3),
        ('agronomu.com', 3),
        ('translate.ru', 3),
        ('coins.lave.ru', 3),
        ('infpol.ru', 3),
        ('o-pogode.ru', 3),
        ('tests24.ru', 3),
        ('express-novosti.ru', 3),
        ('myplaycity.ru', 3),
        ('qaru.site', 3),
        ('vseprorebenka.ru', 3),
        ('glav-dacha.ru', 3),
        ('moscowmap.ru', 3),
        ('iarex.ru', 3),
        ('47news.ru', 3),
        ('mirturbaz.ru', 3),
        ('wroom.ru', 3),
        ('bk55.ru', 3),
        ('mastergrad.com', 3),
        ('coub.com', 3),
        ('primpogoda.ru', 3),
        ('orgdir.ru', 3),
        ('tele.ru', 3),
        ('temaretik.com', 3),
        ('bezrulya.ru', 3),
        ('autonet.ru', 3),
        ('narodna-pravda.ua', 3),
        ('chepetsk.ru', 3),
        ('apple-iphone.ru', 3),
        ('markakachestva.ru', 3),
        ('oculus.ru', 3),
        ('storinka.com.ua', 3),
        ('nicstyle.ru', 3),
        ('vdolevke.ru', 3),
        ('vidal.ru', 3),
        ('servicebox.ru', 3),
        ('vse-shutochki.ru', 3),
        ('1000bankov.ru', 3),
        ('ochepyatki.ru', 3),
        ('medportal.ru', 3),
        ('miltor.ru', 3),
        ('missfit.ru', 3),
        ('stihi-rus.ru', 3),
        ('life-moon.pp.ru', 3),
        ('service-centers.ru', 3),
        ('ironhorse.ru', 3),
        ('delo-vcusa.ru', 3),
        ('krauzer.ru', 3),
        ('adella.ru', 3),
        ('pnp.ru', 3),
        ('volshebnaya-eda.ru', 3),
        ('03online.com', 3),
        ('afy.ru', 3),
        ('fenglish.ru', 3),
        ('assistentus.ru', 3),
        ('mykorus.ru', 3),
        ('astroscope.ru', 3),
        ('sinonim.org', 3),
        ('news.am', 3),
        ('newkuban.ru', 3),
        ('rusmedserv.com', 3),
        ('womane.ru', 3),
        ('leagueoflegends.com', 3),
        ('pokur.su', 3),
        ('hr-portal.ru', 3),
        ('stroyinf.ru', 3),
        ('riamo.ru', 3),
        ('cadelta.ru', 3),
        ('hlebopechka.ru', 3),
        ('f1-world.ru', 3),
        ('leboard.ru', 3),
        ('portall.zp.ua', 3),
        ('webapteka.ru', 3),
        ('belayarosa.ru', 3),
        ('1rre.ru', 3),
        ('komandirovka.ru', 3),
        ('fishingsib.ru', 3),
        ('krasnodarmedia.su', 3),
        ('sovet-ok.ru', 3),
        ('promportal.su', 3),
        ('twenmill.ru', 3),
        ('rybalku.ru', 3),
        ('4geo.ru', 3),
        ('luna-segodnja.ru', 3),
        ('vestivrn.ru', 3),
        ('1gai.ru', 3),
        ('pravda-sotrudnikov.ru', 3),
        ('redwhite.ru', 3),
        ('kramola.info', 3),
        ('ikona-i-molitva.info', 3),
        ('scanwordhelper.ru', 3),
        ('trudbox.by', 3),
        ('ufacitynews.ru', 3),
        ('receptveka.ru', 3),
        ('ir-center.ru', 3),
        ('magmans.ru', 3),
        ('pddmaster.ru', 3),
        ('amurmedia.ru', 3),
        ('prosto-mariya.ru', 3),
        ('bugaga.ru', 3),
        ('brotest.ru', 3),
        ('polismed.com', 3),
        ('stroyportal.ru', 3),
        ('areviews.ru', 3),
        ('antiwomen.ru', 3),
        ('perevozka24.ru', 3),
        ('prognoz3.ru', 3),
        ('ценыавто.рф', 3),
        ('elhow.ru', 3),
        ('ilive.com.ua', 3),
        ('synapsenet.ru', 3),
        ('razvitie-krohi.ru', 3),
        ('v-tagile.ru', 3),
        ('profermu.com', 3),
        ('carsweek.ru', 3),
        ('avtonovostidnya.ru', 3),
        ('bigmir.net', 3),
        ('bigpuzzle.ru', 3),
        ('classinform.ru', 3),
        ('mainfun.ru', 3),
        ('parcelsapp.com', 3),
        ('avon-n.ru', 3),
        ('19rus.info', 3),
        ('runews24.ru', 3),
        ('блогчастногоинвестора.рф', 3),
        ('adresa-telefony.ru', 3),
        ('tehnika.expert', 3),
        ('monavista.ru', 3),
        ('yp.ru', 3),
        ('vkysnoemyaso.ru', 3),
        ('the-avto.ru', 3),
        ('antif.ru', 3),
        ('myfamilydoctor.ru', 3),
        ('stranagruzov.ru', 3),
        ('fisher.spb.ru', 3),
        ('wek.ru', 3),
        ('edunews.ru', 3),
        ('rabota-ipoisk.ru', 3),
        ('medcentre.com.ua', 3),
        ('thebell.io', 3),
        ('spb-guide.ru', 3),
        ('cxem.net', 3),
        ('antiagent.ru', 3),
        ('doseng.org', 3),
        ('promdevelop.ru', 3),
        ('job50.ru', 3),
        ('thewalls.ru', 3),
        ('rrnews.ru', 3),
        ('biznes-prost.ru', 3),
        ('simptomer.ru', 3),
        ('урок.рф', 3),
        ('colady.ru', 3),
        ('avtorazborki.org', 3),
        ('karelinform.ru', 3),
        ('basetop.ru', 3),
        ('inmoment.ru', 3),
        ('igrydljadevochek2.ru', 3),
        ('zaks.ru', 3),
        ('jobcareer.ru', 3),
        ('sob.ru', 3),
        ('mosday.ru', 3),
        ('global-weather.ru', 3),
        ('sonnikonline.club', 3),
        ('kudamoscow.ru', 3),
        ('dom-2-efiri.ru', 3),
        ('grandars.ru', 3),
        ('ufatime.ru', 3),
        ('pribalt.info', 3),
        ('wuzzup.ru', 3),
        ('weaf.ru', 3),
        ('transportspb.com', 3),
        ('kitabi.ru', 3),
        ('ruscatalog.org', 3),
        ('spravka.city', 3),
        ('khazin.ru', 3),
        ('amoskva.com', 3),
        ('regtorg.ru', 3),
        ('fiteria.ru', 3),
        ('metaltorg.ru', 3),
        ('samelectrik.ru', 3),
        ('vsadu.ru', 3),
        ('topruscar.ru', 3),
        ('doski.ru', 3),
        ('optlist.ru', 3),
        ('speedme.ru', 3),
        ('wordparts.ru', 3),
        ('allzip.org', 3),
        ('stroychik.ru', 3),
        ('ya-pogoda.ru', 3),
        ('rf.biz', 3),
        ('timeserver.ru', 3),
        ('samozapis-spb.ru', 3),
        ('nashsovetik.ru', 3),
        ('sovet-ingenera.com', 3),
        ('ru.tv', 3),
        ('dekormyhome.ru', 3),
        ('24tr.ru', 3),
        ('history-doc.ru', 3),
        ('openfile.ru', 3),
        ('remoo.ru', 3),
        ('domkad.ru', 3),
        ('y-story.ru', 3),
        ('krov.expert', 3),
        ('bibika.ru', 3),
        ('дом-2-эфиры.рф', 3),
        ('chessfield.ru', 3),
        ('print-post.com', 3),
        ('gdekluet.ru', 3),
        ('mwmoskva.ru', 3),
        ('online-buhuchet.ru', 3),
        ('tepliepol.ru', 3),
        ('big-book-relax.ru', 3),
        ('med-explorer.ru', 3),
        ('mr7.ru', 3),
        ('empiremam.com', 3),
        ('kitchendecorium.ru', 3),
        ('mirnov.ru', 3),
        ('piter.tv', 3),
        ('myshared.ru', 3),
        ('topbanki.ru', 3),
        ('biznet.ru', 3),
        ('apeterburg.com', 3),
        ('allcarz.ru', 3),
        ('omegapost.ru', 3),
        ('vseprivoroty.ru', 3),
        ('mir-procentov.ru', 3),
        ('house2you.ru', 3),
        ('4damki.ru', 3),
        ('strport.ru', 3),
        ('big-book-avto.ru', 3),
        ('mashintop.ru', 3),
        ('carpis.ru', 3),
        ('dachadizain.ru', 3),
        ('coolgirlsgames.ru', 3),
        ('akaoray.ru', 3),
        ('nova-wings.ru', 3),
        ('dachamechty.ru', 3),
        ('gornnisa.ru', 3),
        ('gazelleclub.ru', 3),
        ('bigpicture.ru', 3),
        ('prostanki.com', 3),
        ('spravkaforme.ru', 3),
        ('photorecept.ru', 3),
        ('fresher.ru', 3),
        ('panoidl.ru', 3),
        ('simpleslim.ru', 3),
        ('big-book-med.ru', 3),
        ('konfiskator.com', 3),
        ('newsnn.ru', 3),
        ('rusfermer.net', 3),
        ('toshop.ru', 3),
        ('findpatent.ru', 3),
        ('medsovet.info', 3),
        ('yoip.ru', 3),
        ('mos-holidays.ru', 3),
        ('apest.ru', 3),
        ('floristics.info', 3),
        ('sportschools.ru', 3),
        ('postavshhiki.ru', 3),
        ('bezformata.ru', 3),
        ('orgsinfo.ru', 3),
        ('kredit-blog.ru', 3),
        ('novostroy-m.ru', 3),
        ('flatinfo.ru', 3),
        ('fis.ru', 3),
        ('tomall.ru', 3),
        ('metaprom.ru', 3),
        ('hullabaloo.ru', 3),
        ('spravkainform.ru', 3),
        ('informing.ru', 3),
        ('istihi.ru', 3),
        ('infoskidka.ru', 3),
        ('inline.ru', 3),
        ('my-infant.com', 3),
        ('mashmaster.ru', 3),
        ('rusargument.ru', 3),
        ('railnation.ru', 3),
        ('gidm.ru', 3),
        ('gazeta.spb.ru', 3),
        ('hyundai-creta2.ru', 3),
        ('euroki.org', 3),
        ('army-news.ru', 3),
        ('incred.ru', 3),
        ('irinazaytseva.ru', 3),
        ('dnevnyk-uspeha.com', 3),
        ('missli.ru', 3),
        ('ulaula.ru', 3),
        ('lechim-prosto.ru', 3),
        ('trud.ru', 3),
        ('gmstar.ru', 3),
        ('korrespondent.net', 3),
        ('dentaliga.ru', 3),
        ('dorus.ru', 3),
        ('sudba.info', 3),
        ('форум-трейдеров.рф', 3),
        ('subsidii.net', 3),
        ('electricalschool.info', 3),
        ('mnogonado.net', 3),
        ('kremlinrus.ru', 3),
        ('all-gorod.ru', 3),
        ('sportgyms.ru', 3),
        ('moneymakerfactory.ru', 3),
        ('bankgid.com', 3),
        ('довериевсети.рф', 3),
        ('sravni.com', 3),
        ('analogist.ru', 3),
        ('self-edu.ru', 3),
        ('russianrealty.ru', 3),
        ('bellaestetica.ru', 3),
        ('visasam.ru', 3),
        ('psihomed.com', 3),
        ('znatokdeneg.ru', 3),
        ('podrygka.info', 3),
        ('vashaspina.ru', 3),
        ('katalogi-tovarov-ceny.ru', 3),
        ('turpogoda.ru', 3),
        ('i.ua', 3),
        ('roadres.com', 3),
        ('oonkologii.ru', 3),
        ('berkem.ru', 3),
        ('arabio.ru', 3),
        ('etopochki.ru', 3),
        ('bebeshka.info', 3),
        ('naavtotrasse.ru', 3),
        ('povozcar.ru', 3),
        ('e-ecolog.ru', 3),
        ('vlanamed.com', 3),
        ('operatorsmobile.info', 3),
        ('tver-portal.ru', 3),
        ('therussiantimes.com', 3),
        ('rasteniya-lecarstvennie.ru', 3),
        ('litra.ru', 3),
        ('cardana.ru', 3),
        ('ogorodsadovod.com', 3),
        ('orgpoisk.ru', 3),
        ('selomoe.ru', 3),
        ('bogolub.info', 3),
        ('tvoe-avto.com', 3),
        ('spectehinfo.ru', 3),
        ('pulset.ru', 3),
        ('dantistika.ru', 3),
        ('grudnichky.ru', 3),
        ('autorazbory.ru', 3),
        ('pogoda.ru', 3),
        ('h-rf.ru', 3),
        ('ladyflora.ru', 3),
        ('kmvcity.ru', 3),
        ('lada-vesta2.ru', 3),
        ('goodgrunt.ru', 3),
        ('big-book-city.ru', 3),
        ('silazdorovya.ru', 3),
        ('ayle.ru', 3),
        ('homemyhome.ru', 3),
        ('domenolog.ru', 3),
        ('roomplan.ru', 3),
        ('uchim.org', 3),
        ('sredstva.ru', 3),
        ('greensector.ru', 3),
        ('armlur.am', 3),
        ('gushak.ru', 3),
        ('ecology-of.ru', 3),
        ('choiz.me', 3),
        ('aravot.am', 3),
        ('10bankov.net', 3),
        ('spbmed.info', 3),
        ('stroika.biz.ua', 3),
        ('b2bsky.ru', 3),
        ('megaidei.ru', 3),
        ('zcarz.ru', 3),
        ('olympteka.ru', 3),
        ('dboxp.com', 3),
        ('tulp.ru', 3),
        ('ciscoexpo.ru', 3),
        ('metrprice.ru', 3),
        ('vanilla.su', 3),
        ('budu5.com', 3),
        ('сельхозпортал.рф', 3),
        ('sport-weekend.com', 3),
        ('ds78.ru', 3),
        ('apral.ru', 3),
        ('ds77.ru', 3),
        ('amic.ru', 3),
        ('all-detal.ru', 3),
        ('couo.ru', 3),
        ('salda.ws', 3),
        ('dmir.ru', 3),
        ('turako.ru', 3),
        ('metaphysican.com', 3),
        ('roomidea.ru', 3),
        ('rabota7.ru', 3),
        ('24auto.ru', 3),
        ('mafors.ru', 3),
        ('belaruspartisan.org', 3),
        ('newsmsk.com', 3),
        ('meteoplan.ru', 3),
        ('raskonyaga.ru', 3),
        ('kinoafisha.spb.ru', 3),
        ('gazeta-petrozavodsk.ru', 3),
        ('kredist.ru', 3),
        ('2conv.com', 3),
        ('meduza.io', 3),
        ('chocoapp.ru', 3),
        ('wikium.ru', 3),
        ('viberu.ru', 3),
        ('kadis.ru', 3),
        ('fanfics.ru', 3),
        ('skyki-net.ru', 3),
        ('nekto.me', 3),
        ('allboxing.ru', 3),
        ('frequentflyers.ru', 3),
        ('360.ru', 3),
        ('vyboroved.ru', 3),
        ('www.forbes.ru', 3),
        ('ok-magazine.ru', 2),
        ('sncmedia.ru', 2),
        ('trendspace.ru', 3),
        ('geo.ru', 3),
        ('disgustingmen.com', 3),
        ('metronews.ru', 3),
        ('webtelegram.net', 3),
        ('monamour.ru', 3),
        ('lady-day.ru', 3),
        ('goha.ru', 3),
        ('dtf.ru', 3),
        ('arhangel.ru', 3),
        ('biletik.aero', 3),
        ('infourok.ru', 3),
        ('joyreactor.cc', 3),
        ('78.ru', 3),
        ('onlayn-radio.ru', 3),
        ('4tololo.ru', 3),
        ('time100.ru', 3)
    ON DUPLICATE KEY UPDATE
        `tier` = VALUES(`tier`);
