#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION
    Нужна ПРОД база
=cut

# project modules
use lib::abs qw(
  ../../lib
  );
use qbit;
use Application;
use PiConstants qw($BOOKMAKER_FLAG_ID);

my $NEED_FIX = [
    {
        accessor => 'context_on_site_stripe',
        page_id  => 107957,
        id       => 3,
        new_id   => undef,
    }
];

main();

sub main {
    my $app = Application->new();
    $app->pre_run();

    {
        no strict 'refs';
        no warnings 'redefine';
        *{'QBit::Application::check_rights'} = sub {TRUE};
    }

    $app->set_cur_user({id => 0, login => 'system-cron'});

    foreach my $fix (@$NEED_FIX) {
        printf("%s\n", to_json($fix));

        my ($accessor, $page_id, $id, $new_id) = @$fix{qw(accessor page_id id new_id)};

        unless (defined($new_id)) {
            $app->partner_db->transaction(
                sub {
                    $new_id = $app->$accessor->page->get_next_block_id($page_id);
                }
            );
        }

        printf("new id: %d\n", $new_id);

        $app->partner_db->_do('SET FOREIGN_KEY_CHECKS=0');

        $app->partner_db->context_on_site_stripe->edit($app->partner_db->filter({campaign_id => $page_id, id => $id}),
            {id => $new_id});

        $app->partner_db->context_on_site_stripe_action_log->edit(
            $app->partner_db->filter({elem_campaign_id => $page_id, elem_id => $id}),
            {elem_id => $new_id});

        $app->partner_db->statistics_context_on_site_stripe->edit(
            $app->partner_db->filter({campaign_id => $page_id, block_id => $id}),
            {block_id => $new_id});

        $app->partner_db->_do('SET FOREIGN_KEY_CHECKS=1');
    }

    $app->post_run();

    print "#END\n";
}
