CREATE TABLE `outdoor` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `page_id` int(10) unsigned DEFAULT NULL,
  `owner_id` bigint(20) unsigned NOT NULL,
  `opts` json NOT NULL,
  `caption` varchar(255) GENERATED ALWAYS AS (json_extract(`opts`,'$.caption')) VIRTUAL NOT NULL,
  `domain` varchar(255) GENERATED ALWAYS AS (json_extract(`opts`,'$.domain')) VIRTUAL NOT NULL,
  `multistate` bigint(20) unsigned NOT NULL DEFAULT '0',
  `create_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `update_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `send_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `tier` tinyint(3) unsigned NOT NULL DEFAULT '3',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq_outdoor__page_id` (`page_id`),
  KEY `fk_outdoor__owner_id___users__id` (`owner_id`),
  CONSTRAINT `outdoor_ibfk_1` FOREIGN KEY (`owner_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `outdoor_block` (
  `page_id` int(10) unsigned NOT NULL,
  `id` int(10) unsigned NOT NULL,
  `opts` json NOT NULL,
  `caption` varchar(255) GENERATED ALWAYS AS (json_extract(`opts`,'$.caption')) VIRTUAL NOT NULL,
  `resolution` varchar(11) GENERATED ALWAYS AS (json_extract(`opts`,'$.resolution')) VIRTUAL NOT NULL,
  `touch_screen` tinyint(1) GENERATED ALWAYS AS (json_extract(`opts`,'$.touch_screen')) VIRTUAL NOT NULL,
  `sound` tinyint(1) GENERATED ALWAYS AS (json_extract(`opts`,'$.sound')) VIRTUAL NOT NULL,
  `zone_category` tinyint(4) GENERATED ALWAYS AS (json_extract(`opts`,'$.zone_category')) VIRTUAL NOT NULL,
  `multistate` bigint(20) unsigned NOT NULL DEFAULT '0',
  `create_date` datetime NOT NULL,
  `start_time` smallint(5) unsigned DEFAULT NULL,
  `is_custom_bk_data` tinyint(1) NOT NULL DEFAULT '0',
  `bk_data` mediumtext,
  PRIMARY KEY (`page_id`,`id`),
  KEY `outdoor_block__multistate` (`multistate`),
  KEY `outdoor_block__id` (`id`),
  CONSTRAINT `outdoor_block_ibfk_1` FOREIGN KEY (`page_id`) REFERENCES `outdoor` (`page_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `outdoor_block_seq` (
  `page_id` int(10) unsigned NOT NULL,
  `next_block_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`page_id`),
  CONSTRAINT `outdoor_block_seq_ibfk_1` FOREIGN KEY (`page_id`) REFERENCES `outdoor` (`page_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `outdoor_action_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `dt` datetime NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `elem_id` bigint(20) unsigned NOT NULL,
  `old_multistate` bigint(20) unsigned NOT NULL,
  `action` varchar(100) NOT NULL,
  `new_multistate` bigint(20) unsigned NOT NULL,
  `opts` text NOT NULL,
  `comment` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `outdoor_action_log__dt_elem_id_action` (`dt`,`elem_id`,`action`),
  KEY `outdoor_action_log__elem_id_action` (`elem_id`,`action`),
  KEY `fk_outdoor_action_log__user_id___users__id` (`user_id`),
  CONSTRAINT `outdoor_action_log_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`),
  CONSTRAINT `outdoor_action_log_ibfk_2` FOREIGN KEY (`elem_id`) REFERENCES `outdoor` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

CREATE TABLE `outdoor_block_action_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `dt` datetime NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `elem_page_id` int(10) unsigned NOT NULL,
  `elem_id` int(10) unsigned NOT NULL,
  `old_multistate` bigint(20) unsigned NOT NULL,
  `action` varchar(100) NOT NULL,
  `new_multistate` bigint(20) unsigned NOT NULL,
  `opts` text NOT NULL,
  `comment` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `outdoor_block_action_log__dt_elem_page_id_elem_id_action` (`dt`,`elem_page_id`,`elem_id`,`action`),
  KEY `outdoor_block_action_log__elem_page_id_elem_id_action` (`elem_page_id`,`elem_id`,`action`),
  KEY `fk_outdoor_block_action_log__user_id___users__id` (`user_id`),
  CONSTRAINT `outdoor_block_action_log_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`),
  CONSTRAINT `outdoor_block_action_log_ibfk_2` FOREIGN KEY (`elem_page_id`, `elem_id`) REFERENCES `outdoor_block` (`page_id`, `id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

