SET @preparedStatement = (SELECT IF(
    (
        SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = "video_an_site_inpage"
            AND table_schema = "partner"
            AND column_name = "opts"
    ) > 0,
    "SELECT 1",
    "ALTER TABLE `video_an_site_inpage` ADD COLUMN `opts` JSON NOT NULL, ALGORITHM = INPLACE, LOCK = NONE"
));

PREPARE alterIfNotExists FROM @preparedStatement;

EXECUTE alterIfNotExists;

DEALLOCATE PREPARE alterIfNotExists;

UPDATE `video_an_site_inpage` SET `opts` = JSON_OBJECT() WHERE JSON_TYPE(opts) = 'NULL';

UPDATE `video_an_site_inpage` SET `opts` = JSON_SET(opts,'$.preload', 0);

ANALYZE TABLE `video_an_site_inpage`;
