#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION

=cut

# project modules
use lib::abs qw(
  ../../lib
  );
use qbit;
use Application;

my $SELLER_ID = 17298340;
my $FILTERS = [1, 3, 4, 5, 6, 7, 20, 21, 24];

my $_warn_badjson = '';

my $LIMIT = 5_000;

main();

sub main {
    my $app = Application->new();
    $app->pre_run();

    {
        no strict 'refs';
        no warnings 'redefine';
        *{'QBit::Application::check_rights'} = sub {TRUE};
    }

    $app->set_cur_user({id => 0, login => 'system-cron'});

    change_templates($app);
    add_filters($app);

    warn $_warn_badjson if $_warn_badjson;

    $app->post_run();

    print "#END\n";
}

# $a1, $a2 - array of scalar
# returns values from $a1 that are not present in $a2
sub _get_values_not_in_set($$) {
    my ($a1, $a2) = @_;
    my %h = map {$_ => 1} @$a2;
    return grep {!exists $h{$_}} @$a1;
}

sub change_templates {
    my ($app) = @_;

    my @fields = qw(tmpl_ssp_mobile_app tmpl_ssp_context_rtb);

    my $db_ssp_seller_list = $app->partner_db->ssp_seller->get_all(fields => ['id', @fields]);

    foreach my $db_ssp_seller (@$db_ssp_seller_list) {
        my $is_update_needed = 0;
        foreach my $field (@fields) {
            # on empty string or invalid JSON do nothing
            try {
                my $value = from_json($db_ssp_seller->{$field});
                $value->{'filters'} = [] unless $value->{'filters'};
                my @filters_not_in_set =
                  @{$value->{'filters'}} ? _get_values_not_in_set($FILTERS, $value->{'filters'}) : @$FILTERS;
                if (@filters_not_in_set) {
                    push @{$value->{'filters'}}, @filters_not_in_set;
                    $is_update_needed = 1;
                    $db_ssp_seller->{$field} = to_json($value, pretty => TRUE);
                }
            }
            catch Exception::Validation::BadArguments::InvalidJSON with {
                $_warn_badjson .= sprintf("!can not update ssp_seller.id[%d] has %s in field [%s]\n",
                    $db_ssp_seller->{id}, $db_ssp_seller->{$field} ? 'invalid JSON' : 'empty string', $field);
            };
        }

        if ($is_update_needed) {
            $app->partner_db->ssp_seller->edit($db_ssp_seller->{id}, $db_ssp_seller);
        }
    }
}

sub add_filters {
    my ($app) = @_;

    my @pages = ();
    my $data  = [];
    foreach my $accessor (qw(ssp_context_on_site_campaign ssp_mobile_app_settings)) {
        my $offset = 0;

        while (
            (
                $data = $app->$accessor->get_all(
                    fields => [qw(id seller_id page_id filters)],
                    filter => ['AND', [['seller_id' => 'IS NOT' => undef], [page_id => 'IS NOT' => undef]]],
                    offset => $offset,
                    limit  => $LIMIT
                )
            )
            && @$data
          )
        {
            foreach my $row (@$data) {
                my %filters = map {$_ => TRUE} @{$row->{'filters'}};

                my $need_update = FALSE;
                foreach (@$FILTERS) {
                    unless ($filters{$_}) {
                        push(@{$row->{'filters'}}, $_);

                        $need_update = TRUE;
                    }
                }

                if ($need_update) {
                    print $row->{'page_id'} . "\n";

                    push(@pages, {id => $row->{'id'}, model => $accessor, page_id => $row->{'page_id'}});

                    my @filter_rows = map {{page_id => $row->{'page_id'}, filter_id => $_}} @{$row->{'filters'}};

                    $app->partner_db->filters->add_multi(\@filter_rows, replace => TRUE);
                }
            }

            $offset += $LIMIT;
        }
    }
}
