CREATE TABLE `internal_context_on_site_content` (
  `campaign_id` int(10) unsigned NOT NULL,
  `id` int(10) unsigned NOT NULL,
  `create_date` datetime DEFAULT NULL,
  `caption` varchar(255) NOT NULL DEFAULT '',
  `multistate` bigint(20) unsigned NOT NULL DEFAULT '0',
  `geo` mediumtext,
  `comment` text,
  `opts` json NOT NULL,
  `is_custom_bk_data` tinyint(1) NOT NULL DEFAULT '0',
  `bk_data` mediumtext,
  PRIMARY KEY (`campaign_id`,`id`),
  KEY `internal_context_on_site_content__id` (`id`),
  CONSTRAINT `internal_context_on_site_content_ibfk_1` FOREIGN KEY (`campaign_id`) REFERENCES `internal_context_on_site_campaign` (`id`)
);

CREATE TABLE `internal_context_on_site_content_action_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `dt` datetime NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `elem_campaign_id` int(10) unsigned NOT NULL,
  `elem_id` int(10) unsigned NOT NULL,
  `old_multistate` bigint(20) unsigned NOT NULL,
  `action` varchar(100) NOT NULL,
  `new_multistate` bigint(20) unsigned NOT NULL,
  `opts` text NOT NULL,
  `comment` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `internal_context_on_site_content_action_log__dt_elem_campaign_id` (`dt`,`elem_campaign_id`,`elem_id`,`action`),
  KEY `internal_context_on_site_content_action_log__elem_campaign_id_el` (`elem_campaign_id`,`elem_id`,`action`),
  KEY `fk_internal_context_on_site_content_action_log__user_id___users` (`user_id`),
  CONSTRAINT `internal_context_on_site_content_action_log_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`),
  CONSTRAINT `internal_context_on_site_content_action_log_ibfk_2` FOREIGN KEY (`elem_campaign_id`, `elem_id`) REFERENCES `internal_context_on_site_content` (`campaign_id`, `id`)
);

CREATE TABLE `statistics_internal_context_on_site_content` (
  `dt` date NOT NULL,
  `campaign_id` int(10) unsigned NOT NULL,
  `block_id` int(10) unsigned NOT NULL,
  `dsp_id` int(10) unsigned NOT NULL,
  `currency_id` tinyint(3) unsigned NOT NULL DEFAULT '2',
  `tag_id` bigint(20) unsigned NOT NULL,
  `content_block_shows` int(10) unsigned NOT NULL DEFAULT '0',
  `content_block_shows_own_adv` int(10) unsigned NOT NULL DEFAULT '0',
  `content_block_hits` int(10) unsigned NOT NULL DEFAULT '0',
  `content_block_hits_own_adv` int(10) unsigned NOT NULL DEFAULT '0',
  `content_block_hits_unsold` int(10) unsigned NOT NULL DEFAULT '0',
  `content_all_w_nds` bigint(20) unsigned NOT NULL DEFAULT '0',
  `content_all_wo_nds` bigint(20) unsigned NOT NULL DEFAULT '0',
  `all_w_nds` bigint(20) unsigned NOT NULL DEFAULT '0',
  `all_wo_nds` bigint(20) unsigned NOT NULL DEFAULT '0',
  `content_block_bad_shows` int(10) unsigned NOT NULL DEFAULT '0',
  `content_block_bad_shows_own_adv` int(10) unsigned NOT NULL DEFAULT '0',
  `content_block_bad_win_hits` int(10) unsigned NOT NULL DEFAULT '0',
  `content_block_bad_win_hits_own_adv` int(10) unsigned NOT NULL DEFAULT '0',
  `content_block_bad_win_hits_unsold` int(10) unsigned NOT NULL DEFAULT '0',
  `content_bad_win_price_w_nds` bigint(20) unsigned NOT NULL DEFAULT '0',
  `content_bad_win_price_wo_nds` bigint(20) unsigned NOT NULL DEFAULT '0',
  `bad_win_price_w_nds` bigint(20) unsigned NOT NULL DEFAULT '0',
  `bad_win_price_wo_nds` bigint(20) unsigned NOT NULL DEFAULT '0',
  `content_block_direct_clicks` int(10) unsigned NOT NULL DEFAULT '0',
  `content_block_direct_shows` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`dt`,`campaign_id`,`block_id`,`dsp_id`,`currency_id`,`tag_id`),
  KEY `statistics_internal_context_on_site_content__campaign_id_block_i` (`campaign_id`,`block_id`,`dt`),
  KEY `statistics_internal_context_on_site_content__dsp_id_dt` (`dsp_id`,`dt`),
  KEY `fk_statistics_internal_context_on_site_content__currency_id___c` (`currency_id`),
  CONSTRAINT `statistics_internal_context_on_site_content_ibfk_1` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`)
);

INSERT INTO `statistics_reports_level_order` (`level_id`,`order`) VALUES ('internal_advnet_context_on_site_content',181);
