
#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION

Для работы скрипта нужно подключить продакшн базу.
Никаке другие продакшн системы подключать не нужно.

Скрипт меняет фильтр для сохраненных отчетов и хэшей:
campaign.owner.is_tutby    => user_type
owner.is_tutby             => user_type
page.owner.is_tutby        => user_type
application.owner.is_tutby => user_type
users.is_tutby             => user_type
login.user.is_tutby        => user_type
is_tutby                   => user_type

=cut

# common modules
use feature 'say';
use Carp;

# project modules
use lib::abs qw(
  ../../lib
  );
use qbit;
use Application;

# global vars

my $TABLES_INFO = [
    {
        table => 'statistics_reports',
        field => 'query',
    },
    {
        table => 'stat_report_params_digest',
        field => 'params',
    },
];

my $REGEXPS = [
    {
        search  => '["campaign","MATCH",["owner","MATCH",["is_tutby","=",true]]]',
        replace => '["user_type","=",["1"]]'
    },
    {
        search  => '["campaign","MATCH",["owner","MATCH",["is_tutby","=",false]]]',
        replace => '["user_type","<>",["1"]]'
    },
    {
        search  => '["page","MATCH",["owner","MATCH",["is_tutby","=",true]]]',
        replace => '["user_type","=",["1"]]'
    },
    {
        search  => '["page","MATCH",["owner","MATCH",["is_tutby","=",false]]]',
        replace => '["user_type","<>",["1"]]'
    },
    {
        search  => '["application","MATCH",["owner","MATCH",["is_tutby","=",true]]]',
        replace => '["user_type","=",["1"]]'
    },
    {
        search  => '["application","MATCH",["owner","MATCH",["is_tutby","=",false]]]',
        replace => '["user_type","<>",["1"]]'
    },
    {
        search  => '["login","MATCH",["user","MATCH",["is_tutby","=",true]]]',
        replace => '["user_type","=",["1"]]'
    },
    {
        search  => '["login","MATCH",["user","MATCH",["is_tutby","=",false]]]',
        replace => '["user_type","<>",["1"]]'
    },
    {
        search  => '["users","MATCH",["is_tutby","=",true]]',
        replace => '["user_type","=",["1"]]'
    },
    {
        search  => '["users","MATCH",["is_tutby","=",false]]',
        replace => '["user_type","<>",["1"]]'
    },
    {
        search  => '["owner","MATCH",["is_tutby","=",true]]',
        replace => '["user_type","=",["1"]]'
    },
    {
        search  => '["owner","MATCH",["is_tutby","=",false]]',
        replace => '["user_type","<>",["1"]]'
    },
    {
        search  => '["is_tutby","=",true]',
        replace => '["user_type","=",["1"]]'
    },
    {
        search  => '["is_tutby","=",false]',
        replace => '["user_type","<>",["1"]]'
    },
];

# subs

sub _change_filter {
    my ($row, $field) = @_;

    my $json = $row->{$field};

    my $result = FALSE;
    foreach my $regexp (@$REGEXPS) {
        my $search  = $regexp->{'search'};
        my $replace = $regexp->{'replace'};

        if ($json =~ s/\Q$search\E/$replace/g) {
            $result = TRUE;

            $row->{$field} = $json;
        }
    }

    from_json($json);

    return $result;
}

# main
sub main {
    my $app = Application->new();
    $app->pre_run();

    $app->set_cur_user({id => 0});

    {
        no warnings 'redefine';
        *QBit::Application::check_rights = sub {1};
    }

    my $dry = grep {$_ eq '--dry'} @ARGV;

    foreach my $table_info (@$TABLES_INFO) {
        my $table = $table_info->{'table'};
        my $field = $table_info->{'field'};

        say "START - $table";

        my $data =
          $app->partner_db->$table->get_all(fields => [qw(id), $field], filter => [$field => 'LIKE' => \'%is_tutby%']);

        my $updated = 0;
        foreach my $row (@$data) {
            my $message = "$table\t$row->{'id'}\t$row->{$field}";
            if (_change_filter($row, $field)) {
                $message .= "\t$row->{$field}";
                $app->partner_db->$table->edit($row->{'id'}, {$field => $row->{$field}}) unless $dry;

                $updated++;
                $message = "OK\t$message";
            } else {
                $message = "FAIL\t$message";
            }

            say $message;
        }

        say "FOUND: " . scalar(@$data);
        say "UPDATED: $updated";
    }

    say '#END';
}

main();

__END__
